<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>أقل 10 أصناف مبيعًا (في العموم)</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            background-color: #f4f4f4;
            color: #333;
        }
        h1 {
            color: #0056b3;
            text-align: center;
            margin-bottom: 30px;
        }
        table {
            width: 90%;
            border-collapse: collapse;
            margin: 0 auto 30px auto; /* Center table and add margin-bottom */
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            background-color: #fff;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 12px;
            text-align: right; /* Align text to the right for Arabic */
        }
        th {
            background-color: #007bff;
            color: white;
            font-weight: bold;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        tr:hover {
            background-color: #f1f1f1;
        }
        p {
            text-align: center;
            font-size: 1.1em;
            color: #666;
        }
        /* Optional: Add some basic responsive styling */
        @media (max-width: 768px) {
            table, thead, tbody, th, td, tr {
                display: block;
            }
            thead tr {
                position: absolute;
                top: -9999px;
                left: -9999px;
            }
            tr {
                border: 1px solid #ccc;
                margin-bottom: 10px;
            }
            td {
                border: none;
                border-bottom: 1px solid #eee;
                position: relative;
                padding-left: 50%;
                text-align: right;
            }
            td:before {
                position: absolute;
                top: 6px;
                left: 6px;
                width: 45%;
                padding-right: 10px;
                white-space: nowrap;
                content: attr(data-label);
                font-weight: bold;
                text-align: left;
            }
        }
    </style>
</head>
<body>
<h1>تقرير: أقل 10 أصناف مبيعًا (في العموم)</h1>

<?php if($topSellingProducts->isEmpty()): ?>
    <p>لا توجد بيانات عن الأصناف الأقل مبيعًا.</p>
<?php else: ?>
    <table>
        <thead>
        <tr>
            <th>الترتيب</th>
            <th>اسم الصنف</th>
            <th>إجمالي الكمية المباعة</th>
            <th>إجمالي الإيرادات</th>
        </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $topSellingProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td data-label="الترتيب"><?php echo e($index + 1); ?></td>
                <td data-label="اسم الصنف"><?php echo e($product->product_name); ?></td>
                <td data-label="إجمالي الكمية المباعة"><?php echo e(number_format($product->total_quantity_sold, 0)); ?></td>
                <td data-label="إجمالي الإيرادات"><?php echo e(number_format($product->total_revenue, 2)); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
<?php endif; ?>
</body>
</html>
<?php /**PATH /Applications/MAMP/htdocs/laravel/ERP/resources/views/admin/less_selling_products.blade.php ENDPATH**/ ?>