<?php $__env->startSection('content'); ?>
<?php
use App\Models\AccountsDefaultData;
$Def=AccountsDefaultData::orderBy('id','desc')->first();
?>
<title><?php echo e(trans('admin.Edit_Journalizing')); ?></title>


<main id="js-page-content" role="main" class="page-content">
    <ol class="breadcrumb page-breadcrumb">
        <li class="breadcrumb-item"><a href="javascript:void(0);"><?php echo e(trans('admin.Sechdules')); ?> </a></li>
        <li class="breadcrumb-item active"><?php echo e(trans('admin.Edit_Journalizing')); ?> </li>
        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
    </ol>
    <form action="<?php echo e(url('PostEditJournalizing')); ?>" method="post">
        <?php echo csrf_field(); ?>

        <?php echo view('honeypot::honeypotFormFields'); ?>
        <div class="row">
            <div class="col-lg-12">
                <div id="panel-2" class="panel">
                    <div class="panel-hdr">
                        <h2>
                            <span class="fw-300"><i> <?php echo e(trans('admin.Edit_Journalizing')); ?> </i></span>
                        </h2>
                    </div>
                    <div class="panel-container show">
                        <span id="ex"> <?php echo $__env->make('admin.layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></span>
                        <div class="panel-content">
                            <div class="form-row">
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Code')); ?> </label>
                                    <input type="text" name="Old_Code" value="<?php echo e($item->Code); ?>" class="form-control " readonly>
                                    <input type="hidden" name="Code" value="<?php echo e($Code); ?>">
                                    <input type="hidden" name="ID" value="<?php echo e($item->id); ?>">
                                </div>

                                <?php if(auth()->guard('admin')->user()->emp == 0): ?>
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Date')); ?></label>
                                    <input type="date" name="Date" value="<?php echo e($item->Date); ?>" class="form-control" required>
                                </div>
                                <?php else: ?>

                                <?php if(auth()->guard('admin')->user()->Date == 1): ?>
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Date')); ?></label>
                                    <input type="date" name="Date" value="<?php echo e($item->Date); ?>" class="form-control" required>
                                </div>
                                <?php else: ?>
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Date')); ?></label>
                                    <input type="date" name="Date" value="<?php echo e($item->Date); ?>" class="form-control" required readonly>
                                </div>
                                <?php endif; ?>

                                <?php endif; ?>

                                <div class="form-group col-lg-3" <?php if($Def->Coin_Show == 0): ?> style="display: none" <?php endif; ?>>
                                    <label class="form-label" for=""><?php echo e(trans('admin.Currency')); ?></label>
                                    <select class="select2 form-control w-100" name="Coin" required>
                                        <option value=""><?php echo e(trans('admin.Currency')); ?></option>
                                        <?php $__currentLoopData = $Coins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($coin->id); ?>" <?php if($item->Coin == $coin->id): ?> selected <?php endif; ?>>
                                            <?php echo e(app()->getLocale() == 'ar' ?$coin->Arabic_Name :$coin->English_Name); ?>

                                        </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="form-group col-lg-2" <?php if($Def->Draw_Show == 0): ?> style="display: none" <?php endif; ?>>
                                    <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Draw')); ?></label>
                                    <input type="number" step="any" name="Draw" value="<?php echo e($item->Draw); ?>" class="form-control" required>
                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for=""><?php echo e(trans('admin.Branch')); ?></label>
                                    <select class="select2 form-control w-100" name="Branch">
                                        <option value=""> <?php echo e(trans('admin.Branch')); ?></option>
                                        <?php $__currentLoopData = $Branchs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($branch->id); ?>" <?php if($item->Branch == $branch->id): ?> selected <?php endif; ?>>

                                            <?php echo e(app()->getLocale() == 'ar' ?$branch->Arabic_Name :$branch->English_Name); ?>

                                        </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="form-group col-lg-3" <?php if($Def->Cost_Show == 0): ?> style="display: none" <?php endif; ?>>
                                    <label class="form-label" for=""><?php echo e(trans('admin.Cost_Center')); ?></label>
                                    <select class="select2 form-control w-100" name="Cost_Center">
                                        <option value=""><?php echo e(trans('admin.Cost_Center')); ?></option>
                                        <?php $__currentLoopData = $CostCenters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cost): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($cost->id); ?>" <?php if($item->Cost_Center == $cost->id): ?> selected <?php endif; ?>>
                                            <?php echo e(app()->getLocale() == 'ar' ?$cost->Arabic_Name :$cost->English_Name); ?>

                                        </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-12">
                <div id="panel-1" class="panel">
                    <div class="panel-container show">
                        <div class="panel-content">
                            <table class="table table-bordered table-hover table-striped w-100">
                                <thead>
                                    <tr>
                                        <th> <?php echo e(trans('admin.Debitor')); ?></th>
                                        <th> <?php echo e(trans('admin.Creditor')); ?></th>
                                        <th> <?php echo e(trans('admin.Account_Name')); ?></th>
                                        <th><?php echo e(trans('admin.Statement')); ?></th>
                                        <th><?php echo e(trans('admin.Actions')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            <div class="form-group">
                                                <input onkeyup="PLUS()" type="number" step="any" id="debit" class="form-control">
                                            </div>
                                        </td>
                                        <td>
                                            <div class="form-group">
                                                <input onkeyup="PLUS()" type="number" step="any" id="creditor" class="form-control">
                                            </div>
                                        </td>
                                        <td>
                                            <div class="form-group">
                                                <select onchange="PLUS()" class="select2 form-control w-100" id="AccountCode">
                                                    <option value=""><?php echo e(trans('admin.Account')); ?></option>
                                                    <?php $__currentLoopData = $Accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $acc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($acc->id); ?>"> <?php echo e(app()->getLocale() == 'ar' ?$acc->Name :$acc->NameEn); ?> </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <input type="hidden" id="AccountName" class="form-control">
                                                <input type="hidden" id="AccID" class="form-control">
                                                <input type="hidden" id="AccCode" class="form-control">
                                            </div>
                                        </td>
                                        <td>
                                            <div class="form-group">
                                                <input type="text" onkeyup="PLUS()" id="statement" class="form-control">
                                            </div>
                                        </td>
                                        <td>
                                            <button type="button" onclick="Insert()" class="btn btn-default" id="add-data" style="display: none"><i class="fal fa-plus"></i></button>
                                        </td>

                                    </tr>
                                </tbody>
                            </table>
                            <!-- datatable start -->
                            <table id="dt-basic-example" class="table table-bordered table-hover table-striped w-100">
                                <thead>
                                    <tr>
                                        <th><?php echo e(trans('admin.Debitor')); ?></th>
                                        <th><?php echo e(trans('admin.Creditor')); ?></th>
                                        <th><?php echo e(trans('admin.Account_Code')); ?></th>
                                        <th><?php echo e(trans('admin.Account_Name')); ?></th>
                                        <th><?php echo e(trans('admin.Statement')); ?></th>
                                        <th><?php echo e(trans('admin.Actions')); ?></th>
                                    </tr>
                                </thead>
                                <tbody id="data-dt">
                                    <?php $__currentLoopData = $details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $det): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="TDeb">
                                            <?php echo e($det->Debitor); ?>

                                        </td>
                                        <td class="TCred">
                                            <?php echo e($det->Creditor); ?>

                                        </td>
                                        <td> <?php echo e($det->Account()->first()->Code); ?></td>
                                        <td> <?php echo e(app()->getLocale() == 'ar' ?$det->Account()->first()->Name :$det->Account()->first()->NameEn); ?> </td>
                                        <td>
                                            <?php echo e($det->Statement); ?>

                                            <input type="hidden" name="Debitor[]" value=" <?php echo e($det->Debitor); ?>">
                                            <input type="hidden" name="Creditor[]" value=" <?php echo e($det->Creditor); ?>">
                                            <input type="hidden" name="Account[]" value=" <?php echo e($det->Account); ?>">
                                            <input type="hidden" name="Statement[]" value="<?php echo e($det->Statement); ?>">
                                        </td>
                                        <td>
                                            <button id="Del" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                        </td>

                                    </tr>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th><?php echo e(trans('admin.Debitor')); ?></th>
                                        <th><?php echo e(trans('admin.Creditor')); ?></th>
                                        <th><?php echo e(trans('admin.Account_Code')); ?></th>
                                        <th><?php echo e(trans('admin.Account_Name')); ?></th>
                                        <th><?php echo e(trans('admin.Statement')); ?></th>
                                        <th><?php echo e(trans('admin.Actions')); ?></th>
                                    </tr>
                                </tfoot>
                            </table>
                            <!-- datatable end -->
                            <div class="form-row">
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Total_Debitor')); ?></label>
                                    <input type="text" id="totalDeb" disabled class="form-control">
                                    <input type="hidden" id="totalDebHide" name="Total_Debaitor" class="form-control">
                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.Total_Creditor')); ?></label>
                                    <input type="text" id="totalCred" disabled class="form-control">
                                    <input type="hidden" id="totalCredHide" name="Total_Creditor" class="form-control">

                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.Differnence')); ?> </label>
                                    <input type="text" id="Differnence" disabled class="form-control">
                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Notes')); ?></label>
                                    <input type="text" name="Note" value="<?php echo e($item->Note); ?>" class="form-control">
                                </div>

                            </div>
                            <div class="buttons mt-3" id="SHOW" style="display: none">
                                <button type="submit" class="btn btn-primary"> <i class="fal fa-folder"></i> <?php echo e(trans('admin.Save')); ?> </button>
                                <button type="button" class="btn btn-primary"><i class="fal fa-save"></i> <?php echo e(trans('admin.SaveandPrint')); ?> </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>



        </div>
    </form>
    <div class="row">

    </div>

</main>




<?php $__env->stopSection(); ?>


<?php $__env->startPush('js'); ?>
<link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/datagrid/datatables/datatables.bundle.css')); ?>">
<link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/formplugins/summernote/summernote.css')); ?>">
<link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/formplugins/select2/select2.bundle.css')); ?>">

<script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.bundle.js')); ?>"></script>
<script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.export.js')); ?>"></script>
<script src="<?php echo e(asset('Admin/js/formplugins/summernote/summernote.js')); ?>"></script>
<script src="<?php echo e(asset('Admin/js/formplugins/select2/select2.bundle.js')); ?>"></script>


<script>
    $(document).ready(function() {
        var sumR = 0;
        $('.TDeb').each(function() {
            sumR += parseFloat($(this).text());
        });

        var sum = 0;
        $('.TCred').each(function() {
            sum += parseFloat($(this).text());
        });

        $('#totalDeb').val(sumR);
        $('#totalDebHide').val(sumR);
        $('#totalCred').val(sum);
        $('#totalCredHide').val(sum);

        var Dif = parseFloat(sumR) - parseFloat(sum);
        $('#Differnence').val(Dif);


        if (Dif == 0) {

            document.getElementById("SHOW").style.display = "block";
        } else {

            document.getElementById("SHOW").style.display = "none";

        }
    });

</script>



<script>
    var autoSave = $('#autoSave');
    var interval;
    var timer = function() {
        interval = setInterval(function() {
            //start slide...
            if (autoSave.prop('checked'))
                saveToLocal();

            clearInterval(interval);
        }, 3000);
    };

    //save
    var saveToLocal = function() {
        localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
        console.log("saved");
    }

    //delete 
    var removeFromLocal = function() {
        localStorage.removeItem("summernoteData");
        $('#saveToLocal').summernote('reset');
    }

    $(document).ready(function() {
        //init default
        $('.js-summernote').summernote({
            height: 200,
            tabsize: 2,
            placeholder: "Type here...",
            dialogsFade: true,
            toolbar: [
                ['style', ['style']],
                ['font', ['strikethrough', 'superscript', 'subscript']],
                ['font', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['height', ['height']]
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ],
            callbacks: {
                //restore from localStorage
                onInit: function(e) {
                    $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                },
                onChange: function(contents, $editable) {
                    clearInterval(interval);
                    timer();
                }
            }
        });

        //load emojis
        $.ajax({
            url: 'https://api.github.com/emojis',
            async: false
        }).then(function(data) {
            window.emojis = Object.keys(data);
            window.emojiUrls = data;
        });

        //init emoji example
        $(".js-hint2emoji").summernote({
            height: 100,
            toolbar: false,
            placeholder: 'type starting with : and any alphabet',
            hint: {
                match: /:([\-+\w]+)$/,
                search: function(keyword, callback) {
                    callback($.grep(emojis, function(item) {
                        return item.indexOf(keyword) === 0;
                    }));
                },
                template: function(item) {
                    var content = emojiUrls[item];
                    return '<img src="' + content + '" width="20" /> :' + item + ':';
                },
                content: function(item) {
                    var url = emojiUrls[item];
                    if (url) {
                        return $('<img />').attr('src', url).css('width', 20)[0];
                    }
                    return '';
                }
            }
        });

        //init mentions example
        $(".js-hint2mention").summernote({
            height: 100,
            toolbar: false,
            placeholder: "type starting with @",
            hint: {
                mentions: ['jayden', 'sam', 'alvin', 'david'],
                match: /\B@(\w*)$/,
                search: function(keyword, callback) {
                    callback($.grep(this.mentions, function(item) {
                        return item.indexOf(keyword) == 0;
                    }));
                },
                content: function(item) {
                    return '@' + item;
                }
            }
        });

    });

</script>



<script>
    function Insert() {
        var debit = document.getElementById('debit').value;
        var creditor = document.getElementById('creditor').value;
        var accountCode = document.getElementById('AccCode').value;
        var accountID = document.getElementById('AccID').value;
        var accountName = document.getElementById('AccountName').value;
        var statement = document.getElementById('statement').value;

        var table = ` <tr> 
                                <td class="TDeb">
                            ${debit}

                                </td>
                                <td class="TCred">
                                ${creditor}
                               </td>
                                <td>${accountCode}</td>
                                <td>${accountName}</td>
                                <td>${statement}
                <input type="hidden" name="Debitor[]" value="${debit}">
    <input type="hidden" name="Creditor[]" value="${creditor}">
    <input type="hidden" name="Account[]" value="${accountID}">
    <input type="hidden" name="Statement[]" value="${statement}">
                                 </td>
                                <td>
                    <button id="Del" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                </td>




                             </tr>`;
        document.getElementById('data-dt').innerHTML += table;


        $('#debit').val('');
        $('#creditor').val('');
        $('#AccountCode').val('');
        document.getElementById("add-data").style.display = "none";


        var sumR = 0;
        $('.TDeb').each(function() {
            sumR += parseFloat($(this).text());
        });

        var sum = 0;
        $('.TCred').each(function() {
            sum += parseFloat($(this).text());
        });

        $('#totalDeb').val(parseFloat(sumR).toFixed(2));
        $('#totalDebHide').val(parseFloat(sumR).toFixed(2));
        $('#totalCred').val(parseFloat(sum).toFixed(2));
        $('#totalCredHide').val(parseFloat(sum).toFixed(2));

        var Dif = parseFloat(sumR) - parseFloat(sum);
        $('#Differnence').val(parseFloat(Dif).toFixed(2));


        if (parseFloat(sumR).toFixed(2) == parseFloat(sum).toFixed(2)) {

            document.getElementById("SHOW").style.display = "block";
        } else {

            document.getElementById("SHOW").style.display = "none";

        }



        $('#dt-basic-example #data-dt').on('click', '#Del', function(e) {
            $(this).closest('tr').remove();



            var sumR = 0;
            $('.TDeb').each(function() {
                sumR += parseFloat($(this).text());
            });

            var sum = 0;
            $('.TCred').each(function() {
                sum += parseFloat($(this).text());
            });

            $('#totalDeb').val(parseFloat(sumR).toFixed(2));
            $('#totalDebHide').val(parseFloat(sumR).toFixed(2));
            $('#totalCred').val(parseFloat(sum).toFixed(2));
            $('#totalCredHide').val(parseFloat(sum).toFixed(2));

            var Dif = parseFloat(sumR) - parseFloat(sum);
            $('#Differnence').val(parseFloat(Dif).toFixed(2));


            if (parseFloat(sumR).toFixed(2) == parseFloat(sum).toFixed(2)) {

                document.getElementById("SHOW").style.display = "block";
            } else {

                document.getElementById("SHOW").style.display = "none";

            }





        })





    }

</script>


<script>
    $('#dt-basic-example #data-dt').on('click', '#Del', function(e) {
        $(this).closest('tr').remove();



        var sumR = 0;
        $('.TDeb').each(function() {
            sumR += parseFloat($(this).text());
        });

        var sum = 0;
        $('.TCred').each(function() {
            sum += parseFloat($(this).text());
        });

        $('#totalDeb').val(parseFloat(sumR).toFixed(2));
        $('#totalDebHide').val(parseFloat(sumR).toFixed(2));
        $('#totalCred').val(parseFloat(sum).toFixed(2));
        $('#totalCredHide').val(parseFloat(sum).toFixed(2));

        var Dif = parseFloat(sumR) - parseFloat(sum);
        $('#Differnence').val(parseFloat(Dif).toFixed(2));


        if (parseFloat(sumR).toFixed(2) == parseFloat(sum).toFixed(2)) {

            document.getElementById("SHOW").style.display = "block";
        } else {

            document.getElementById("SHOW").style.display = "none";

        }





    })

</script>


<script>
    $(document).ready(function() {

        $('#AccountCode').on('change', function() {
            var countryId = $(this).val();
            if (countryId) {
                $.ajax({
                    url: 'AccountNameFilter/' + countryId,
                    type: "GET",
                    dataType: "json",
                    beforeSend: function() {
                        $('#loader').css("visibility", "visible");
                    },

                    success: function(data) {
                        $.each(data, function(key, value) {

                            $('#AccCode').val(data.code);
                            $('#AccountName').val(data.name);
                            $('#AccID').val(data.ID);
                        });
                    },
                    complete: function() {
                        $('#loader').css("visibility", "hidden");
                    }
                });
            } else {

                $('select[name="state"]').empty();
            }

        });

    });

</script>

<script>
    function PLUS() {

        var Dept = $('#debit').val();
        var Credt = $('#creditor').val();
        var Code = $('#AccountCode').val();


        if (Dept != 0) {

            $('#creditor').val(0);
        }


        if (Credt != 0) {

            $('#debit').val(0);
        }


        if (Dept != '' && Credt != '' && Code != null) {


            if (Dept != 0 || Credt != 0) {
                document.getElementById("add-data").style.display = "none";
            }


            if (Dept == 0 && Credt == 0) {
                document.getElementById("add-data").style.display = "none";
            }

            if (Dept == 0 && Credt != 0) {
                document.getElementById("add-data").style.display = "block";
            }

            if (Dept != 0 && Credt == 0) {
                document.getElementById("add-data").style.display = "block";
            }


            if (parseFloat(Dept) < 0) {

                document.getElementById("add-data").style.display = "none";

            }

            if (parseFloat(Credt) < 0) {

                document.getElementById("add-data").style.display = "none";

            }


        } else {

            document.getElementById("add-data").style.display = "none";

        }

    }

</script>

<!-- Search Selecet -->
<script>
    $(document).ready(function() {
        $(function() {
            $('.select2').select2();

            $(".select2-placeholder-multiple").select2({
                placeholder: "Select State"
            });
            $(".js-hide-search").select2({
                minimumResultsForSearch: 1 / 0
            });
            $(".js-max-length").select2({
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items"
            });
            $(".select2-placeholder").select2({
                placeholder: "Select a state",
                allowClear: true
            });

            $(".js-select2-icons").select2({
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function(elm) {
                    return elm
                }
            });

            function icon(elm) {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
            }



        });
    });

</script>


<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/laravel/ERP/resources/views/admin/Accounts/EditJournalizing.blade.php ENDPATH**/ ?>