<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>أكثر 10 عملاء مبيعًا</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; background-color: #f4f4f4; color: #333; }
        h1 { color: #0056b3; text-align: center; margin-bottom: 30px; }
        table { width: 90%; border-collapse: collapse; margin: 0 auto 30px auto; box-shadow: 0 2px 8px rgba(0,0,0,0.1); background-color: #fff; }
        th, td { border: 1px solid #ddd; padding: 12px; text-align: right; }
        th { background-color: #007bff; color: white; font-weight: bold; }
        tr:nth-child(even) { background-color: #f9f9f9; }
        tr:hover { background-color: #f1f1f1; }
        p { text-align: center; font-size: 1.1em; color: #666; }
    </style>
</head>
<body>
<h1>تقرير: أكثر 10 عملاء تحقيقاً للمبيعات</h1>

@if($topSellingCustomers->isEmpty())
    <p>لا توجد بيانات عن العملاء الأكثر تحقيقاً للمبيعات.</p>
@else
    <table>
        <thead>
        <tr>
            <th>الترتيب</th>
            <th>اسم العميل</th>
            <th>إجمالي الإيرادات المحققة</th>
            <th>**عدد مرات البيع**</th> </tr>
        </thead>
        <tbody>
        @foreach($topSellingCustomers as $index => $customer)
            <tr>
                <td>{{ $index + 1 }}</td>
                <td>{{ $customer->app_name }}</td>
                <td>{{ number_format($customer->total_revenue, 2) }}</td>

        @endforeach
        </tbody>
    </table>
@endif
</body>
</html>
