@php
use App\Models\CompanyData;
$def=CompanyData::latest('id')->first();
@endphp
<!doctype html>
<html lang="en">
<head>

    <!-- CSS FILES -->
    <link rel="stylesheet" href="{{asset('Admin/Email/assets/css/bootstrap.min.css')}}">
    <link rel="stylesheet" href="{{asset('Admin/Email/assets/fonts/iconfonts.css')}}">
    <link rel="stylesheet" href="{{asset('Admin/Email/assets/css/plugins.css')}}">
    <link rel="stylesheet" href="{{asset('Admin/Email/assets/css/style.css')}}">
    <link rel="stylesheet" href="{{asset('Admin/Email/assets/css/responsive.css')}}">
    <link rel="stylesheet" href="{{asset('Admin/Email/assets/css/color.css')}}">
</head>
<body>
<div id="dtr-wrapper" class="clearfix">

    <!-- == main content area starts == -->
    <div id="dtr-main-content">

        <!-- hero section starts
================================================== -->
        <section id="home" class="dtr-section dtr-section-with-bg dtr-hero-section-top-padding bg-blue" style="background-image: url({{asset('Admin/Email/assets/images/white-shape-bg.png')}})">

            <!-- wrapping div for background bottom curve stripes image - easy to change color - no need to edit image - refer help doc -->
            <div class="dtr-bottom-shape-img" style="background-image: url({{asset('Admin/Email/assets/images/hero-bottom.svg')}})">
                <div class="container">

                    <!--===== row 1 starts =====-->
                    <div class="row">

                        <!-- column 1 starts -->
                        <div class="col-12 col-md-6">

                            <!-- intro text -->
                            <h1 class="color-white">{{app()->getLocale() == 'ar' ?$def->Name :$def->NameEn}}</h1>
                            <p class="color-white-muted">

                                {{app()->getLocale() == 'ar' ?$def->Welcome_Arabic_Word_App :$def->Welcome_English_Word_App}}
                            </p>




                        </div>
                        <!-- column 1 ends -->

                        <!-- column 2 starts -->
                        <div class="col-12 col-md-6 small-device-space"> <img src="{{URL::to($def->Logo_Store)}}" alt="image" class="dtr-rounded-img dtr-mb-minus50"> </div>
                        <!-- column 2 ends -->

                    </div>
                    <!--===== row 1 ends =====-->

                </div>
            </div>
        </section>
        <!-- hero section ends
================================================== -->

        <!-- features section starts
================================================== -->
        <section id="features" class="dtr-section dtr-pt-150 dtr-pb-100">
            <div class="container">

<h1 class="text-center" style="color: #014b2a">{{trans('admin.Welcome')}} :  {{$data['Name']}}</h1>

                <!--== row starts ==-->
                <div class="row dtr-pt-10">

                    {!!  $data['data'] !!}
                </div>
                <!--== row ends ==-->

            </div>
        </section>
        <!-- features section ends
================================================== -->




        <!-- contact section starts
================================================== -->
        <!-- top background curve image - easy to change color / no need to edit image - refer help doc -->
        <section id="contact" class="dtr-section dtr-section-with-bg bg-blue color-white" style="background-image: url({{asset('Admin/Email/assets/images/white-shape-bg.png')}});">

            <!-- wrapping div for top shape image - easy to change color / no need to edit image - refer help doc -->
            <div class="dtr-py-100 dtr-top-shape-img" style="background-image: url({{asset('Admin/Email/assets/images/contact-section-top.svg')}});">
                <div class="container">

                    <!--== row starts ==-->
                    <div class="row">

                        <!-- column 1 starts -->
                        <div class="col-12 col-md-4 small-device-space"> <img src="{{URL::to($def->Logo_Store)}}" alt="logo">



                        </div>
                        <!-- column 1 ends -->

                        <!-- column 2 starts -->
                        <div class="col-12 col-md-4 small-device-space">

                            <div class="spacer-30"></div>

                            <!-- nested row starts -->
                            <div class="row">

                                <!-- social starts -->
                                <div class="dtr-social-large dtr-mt-30">
                                    <ul class="dtr-social dtr-social-list text-left">
                                        <li><a href="#" class="dtr-instagram" target="_blank" title="instagram"></a></li>
                                        <li><a href="#" class="dtr-skype" target="_blank" title="skype"></a></li>
                                        <li><a href="#" class="dtr-google" target="_blank" title="google"></a></li>
                                    </ul>
                                </div>
                                <!-- social ends -->

                            </div>
                            <!-- nested row ends -->

                        </div>
                        <!-- column 2 ends -->

                        <!-- column 3 starts -->
                        <div class="col-12 col-md-4 small-device-space">
                            <h4>Contact Info</h4>
                            <div class="spacer-30"></div>
                            <ul class="dtr-contact-widget">
                                <li><i class="icon-phone-call"></i>{{$def->Phone1}}</li>
                                <li><i class="icon-phone-call"></i>{{$def->Phone2}}</li>
                                <li><i class="icon-phone-call"></i>{{$def->Phone3}}</li>
                                <li><i class="icon-phone-call"></i>{{$def->Phone4}}</li>

                                <li><i class="icon-envelope1"></i><a href="mailto:{{$def->Email}}">{{$def->Email}}</a></li>
                                <li><i class="icon-map-pin1"></i>
                                    {{app()->getLocale() == 'ar' ?$def->Address :$def->AddressEn}}

                                </li>
                            </ul>








                        </div>
                        <!-- column 3 ends -->


                        <!-- column 1 starts -->
                        <div class="col-12 text-center text-size-sm">
                            <p> Copyright © {{date('Y')}}.  by <a href="https://rabiherp.com/public/">R A B I H  ERP</a>.</p>
                        </div>
                        <!-- column 1 ends -->



                    </div>
                    <!--== row ends ==-->

                </div>
            </div>
        </section>
        <!-- contact section ends
================================================== -->



    </div>
    <!-- == main content area ends == -->

</div>
<!-- #dtr-wrapper ends -->

<!-- JS FILES -->
<script src="{{asset('Admin/Email/assets/js/jquery.min.js')}}"></script>
<script src="{{asset('Admin/Email/assets/js/bootstrap.min.js')}}"></script>
<script src="{{asset('Admin/Email/assets/js/plugins.js')}}"></script>
<script src="{{asset('Admin/Email/assets/js/custom.js')}}"></script>

<style>
    .bg-blue {
        background-color: #205952 !important;
    }

</style>


</body>
</html>
