@extends('admin.index')
@section('content')

    <title>{{trans('admin.FingerPrintDevice')}}</title>

    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Settings')}}</a></li>
            <li class="breadcrumb-item active">{{trans('admin.FingerPrintDevice')}}</li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                    class="js-get-date"></span></li>
        </ol>
        <div class="subheader">

        </div>
        <div class="row">
            <div class="col-xl-12">
                <div id="panel-1" class="panel">
                    <div class="panel-hdr">
                        <h2>
                            <span class="fw-300"><i> {{trans('admin.FingerPrintDevice')}}</i></span>

                        </h2>

                        <div class="panel-toolbar">

                            <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>
                            @include('admin.layouts.toolbar')
                        </div>
                    </div>
                    <div class="panel-container show">
                        <span id="ex"> @include('admin.layouts.messages')</span>
                        <div class="panel-content">
                            <!-- datatable start -->

                            <dev class="row">
                            <dev class="col-md-6">

                                <div class="device-container">
                                    <div class="left-section">
                                        <div class="screen-area">
                                            <div class="screen-time" id="deviceTime">{{date('Y-m-d H:i:s')}}</div>
                                            <div class="screen-message" id="deviceMessage">Welcome</div>
                                            <div class="screen-sub-message" id="deviceSubMessage">Rabih Finger Print </div>
                                        </div>
                                        <div class="indicator-lights">
                                            <div class="light active-green"></div> <!-- Example active light -->
                                            <div class="light active-red"></div>
                                            <div class="light"></div>
                                        </div>


                                        <div class="row">
                                            <div class="col-md-6">
                                                <button style="width: 90%" class="btn btn-primary mt-2" type="button">Shutdown</button>
                                            </div>

                                            <div class="col-md-6">
                                                <button style="width: 90%" class="btn btn-primary mt-2" type="button">Restart</button>
                                            </div>

                                            <div class="col-md-6">
                                                <button style="width: 90%" class="btn btn-primary mt-2" type="button">Sleep</button>
                                            </div>

                                            <div class="col-md-6">
                                                <button style="width: 90%" class="btn btn-primary mt-2" type="button">Resume</button>
                                            </div>


                                            <div class="col-md-6">
                                                <button style="width: 90%" class="btn btn-primary mt-2" type="button">Connect</button>
                                            </div>

                                            <div class="col-md-6">
                                                <button style="width: 90%" class="btn btn-primary mt-2" type="button">Disconnect</button>
                                            </div>

                                            <div class="col-md-6">
                                                <button style="width: 90%" class="btn btn-primary mt-2" type="button">Users</button>
                                            </div>


                                            <div class="col-md-6">
                                                <button style="width: 90%" class="btn btn-primary mt-2" type="button">Attendence</button>
                                            </div>


                                            <div class="col-md-6">
                                                <button style="width: 90%" class="btn btn-primary mt-2" type="button">Clear Attendence</button>
                                            </div>



                                            <div class="col-md-6">
                                                <button style="width: 90%" class="btn btn-primary mt-2" type="button">Register Attendance</button>
                                            </div>




                                        </div>

                                    </div>



                                    <div class="right-section">
                                        <div class="keypad">
                                            <div class="key">1</div>
                                            <div class="key">2</div>
                                            <div class="key">3</div>
                                            <div class="key">4</div>
                                            <div class="key">5</div>
                                            <div class="key">6</div>
                                            <div class="key">7</div>
                                            <div class="key">8</div>
                                            <div class="key">9</div>
                                            <div class="key clear-key"><-</div> <!-- Clear/Cancel -->
                                            <div class="key">0</div>
                                            <div class="key action-key">-></div> <!-- OK/Enter -->
                                        </div>


                                        <div class="scanner-area">
                                            <!-- Fingerprint SVG Icon -->
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
                                                <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm-1-13h2v6h-2zm0 8h2v2h-2z"/>
                                                <path fill-rule="evenodd" d="M11.5 10.5a.5.5 0 011 0v3a.5.5 0 01-1 0v-3zM11.5 15.5a.5.5 0 011 0v.5a.5.5 0 01-1 0v-.5zM12 4a8 8 0 100 16 8 8 0 000-16zM12 18a6 6 0 110-12 6 6 0 010 12zM12 6a4 4 0 100 8 4 4 0 000-8zM12 14a2 2 0 110-4 2 2 0 010 4z" clip-rule="evenodd" />
                                            </svg>
                                        </div>

                                    </div>

                                    <div class="zkteco-logo"> <h3 class="text-center">ZKT eco</h3> IP : 192.168.1.175 </div>


                                </div>

                            </dev>

                                <dev class="col-md-6">

                                    <div id="mobile-overflow">
                                        <table id="dt-basic-example"
                                               class="table table-bordered table-hover table-striped mobile-width">
                                            <thead class="bg-highlight">
                                            <tr>
                                                <th>{{trans('admin.Date')}}</th>
                                                <th>{{trans('admin.Time')}}</th>
                                                <th>{{trans('admin.Name')}}</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @foreach($todaysAttendance as $get)

                                               @php  $name=\App\Models\Employess::find($get['id']);   @endphp
                                                <tr>
                                                    <td>{{date('Y-m-d')}}</td>
                                                    <td>{{$get['timestamp']}}</td>
                                                    <td>

                                                    @if(!empty($name))


                                                        {{$name->Name}}

                                                    @endif


                                                    </td>


                                                </tr>
                                            @endforeach
                                            </tbody>
                                            <tfoot>
                                            <tr>
                                                <th>{{trans('admin.Date')}}</th>
                                                <th>{{trans('admin.Time')}}</th>
                                                <th>{{trans('admin.Name')}}</th>

                                            </tr>
                                            </tfoot>
                                        </table>
                                    </div>

                                </dev>



                            </dev>



                            <!-- datatable end -->
                        </div>
                    </div>
                </div>
            </div>
        </div>



    </main>


    <style>

        .device-container {
            background-color: #1a1a1a; /* Deep black for device body */
            border-radius: 1.5rem; /* Large rounded corners */
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.6), 0 10px 15px -3px rgba(0, 0, 0, 0.3); /* Stronger shadow */
            padding: 1.5rem; /* Padding inside the frame */
            max-width: 850px; /* Wider device */
            width: 100%;
            aspect-ratio: 1.4 / 1; /* Maintain aspect ratio (e.g., 1.4 times wider than tall) */
            display: flex;
            flex-direction: row; /* Layout content side-by-side */
            align-items: flex-start; /* Align items to the top */
            gap: 1.5rem; /* Gap between screen and keypad */
            border: 5px solid #333; /* Silver/gray border for the device frame */
            position: relative;
            min-height: 550px; /* Increased min-height significantly */
            overflow: hidden; /* Ensures glow within bounds */
        }

        /* Left section: Screen and indicators */
        .left-section {
            display: flex;
            flex-direction: column;
            flex: 3; /* Takes 3 parts of the available space */
            gap: 1rem;
            align-items: center;
        }
        .screen-area {
            background-color: #000; /* Pure black screen */
            border-radius: 0.5rem;
            width: 100%;
            height: 180px; /* Fixed height for screen */
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            color: #cd9b27; /* Bright green text */
            font-size: 1.8rem; /* Larger font for time */
            font-weight: 600;
            padding: 1rem;
            box-shadow: 0 0 25px rgba(0, 255, 0, 0.6), inset 0 0 15px rgba(0, 255, 0, 0.4); /* Stronger outer and inner glow */
            border: 3px solid #205952; /* Thicker green border */
            text-shadow: 0 0 8px rgba(0, 255, 0, 0.7); /* Text glow */
            position: relative;
            overflow: hidden; /* Ensures glow within bounds */
        }
        .screen-time {
            font-size: 1rem; /* Very large time font */
            font-weight: 700;
            margin-bottom: 0.5rem;
        }
        .screen-message {
            font-size: 1.2rem;
            font-weight: 500;
            color: #cd9b27;
        }
        .screen-sub-message {
            font-size: 0.9rem;
            color: #cd9b27;
            margin-top: 0.5rem;
        }

        .indicator-lights {
            display: flex;
            gap: 1rem;
            margin-top: 1rem;
        }
        .light {
            width: 18px;
            height: 18px;
            border-radius: 50%;
            background-color: #333; /* Off state */
            border: 1px solid #555;
            box-shadow: inset 0 0 5px rgba(0,0,0,0.5);
            transition: background-color 0.3s;
        }
        .light.active-red {
            background-color: #f00;
            box-shadow: 0 0 10px rgba(255,0,0,0.7), inset 0 0 5px rgba(255,100,100,0.5);
        }
        .light.active-green {
            background-color: #0f0;
            box-shadow: 0 0 10px rgba(0,255,0,0.7), inset 0 0 5px rgba(100,255,100,0.5);
        }

        /* Right section: Keypad and Fingerprint Scanner */
        .right-section {
            display: flex;
            flex-direction: column;
            flex: 2; /* Takes 2 parts of the available space */
            gap: 1.5rem;
            align-items: center;
            justify-content: space-between; /* Distribute space vertically */
            padding-bottom: 1rem; /* Add some padding at the bottom */
        }
        .keypad {
            display: grid;
            grid-template-columns: repeat(3, 1fr); /* 3 columns */
            gap: 0.75rem; /* Gap between keys */
            width: 100%;
            background-color: #222; /* Darker background for keypad area */
            padding: 1rem;
            border-radius: 0.75rem;
            box-shadow: inset 0 0 8px rgba(0,0,0,0.7);
        }
        .key {
            background-color: #333; /* Key color */
            color: #eee;
            padding: 0.8rem 0.5rem;
            border-radius: 0.5rem;
            font-size: 1.1rem;
            font-weight: 600;
            cursor: pointer;
            transition: background-color 0.1s, transform 0.1s;
            box-shadow: 0 2px 5px rgba(0,0,0,0.5);
            text-align: center;
        }
        .key:active {
            background-color: #555;
            transform: translateY(1px);
        }
        .key.action-key {
            background-color: #007bff; /* Blue for action keys */
            color: #fff;
        }
        .key.action-key:active {
            background-color: #0056b3;
        }
        .key.clear-key {
            background-color: #dc3545; /* Red for clear */
            color: #fff;
        }
        .key.clear-key:active {
            background-color: #c82333;
        }

        /* Fingerprint Scanner Area */
        .scanner-area {
            width: 150px; /* Increased Scanner width */
            height: 150px; /* Increased Scanner height */
            background-color: #000; /* Black background */
            border-radius: 0.75rem; /* Rounded corners for scanner */
            display: flex;
            justify-content: center;
            align-items: center;
            border: 5px solid #014b2a; /* Thicker Green border for scanner */
            box-shadow: 0 0 25px rgba(0, 255, 0, 0.8), inset 0 0 15px rgba(0, 255, 0, 0.5); /* Stronger Green glow */
            overflow: hidden;
            position: relative;
        }
        .scanner-area svg {
            fill: #0a0; /* Darker green icon */
            width: 90px; /* Increased SVG icon size */
            height: 90px;
            filter: drop-shadow(0 0 8px rgba(0, 255, 0, 0.7)); /* Stronger shadow for SVG icon */
        }

        .zkteco-logo {
            position: absolute;
            bottom: 1rem;
            left: 50%;
            transform: translateX(-50%);
            color: #555; /* Dark gray logo text */
            font-size: 0.8rem;
            font-weight: 700;
            letter-spacing: 0.05em;
        }

        /* New container for action buttons inside right-section */
        .right-section-buttons {
            display: flex;
            flex-direction: row; /* Arrange buttons horizontally */
            flex-wrap: wrap; /* Allow wrapping */
            justify-content: center; /* Center buttons */
            gap: 0.75rem; /* Gap between buttons */
            width: 100%; /* Take full width of right-section */
            margin-top: auto; /* Push this group to the bottom of right-section */
            padding-top: 1rem; /* Space from scanner/keypad */
        }

        /* Styles for LLM-powered button and other action buttons */
        .llm-btn, .action-btn {
            background-color: #8B5CF6; /* Purple */
            color: #ffffff;
            padding: 0.8rem 1.2rem;
            border-radius: 0.5rem;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: background-color 0.2s, transform 0.1s;
            box-shadow: 0 2px 5px rgba(0,0,0,0.3);
            flex-grow: 1; /* Allow buttons to grow */
            min-width: 100px; /* Ensure they are not too small */
            max-width: 48%; /* Max width to allow two per row */
        }
        .llm-btn:hover, .action-btn:hover {
            background-color: #7C3AED; /* Darker purple */
            transform: translateY(-1px);
        }
        .llm-btn:active, .action-btn:active {
            background-color: #6D28D9;
        }
        .loading-spinner {
            border: 4px solid rgba(255, 255, 255, 0.3);
            border-top: 4px solid #fff;
            border-radius: 50%;
            width: 20px;
            height: 20px;
            animation: spin 1s linear infinite;
            display: inline-block;
            vertical-align: middle;
            margin-left: 8px;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* Responsive adjustments */
        @media (max-width: 768px) {
            .device-container {
                flex-direction: column; /* Stack sections vertically on smaller screens */
                padding: 1rem;
                max-width: 400px;
                aspect-ratio: auto; /* Allow height to adjust */
                min-height: 550px;
            }
            .left-section, .right-section {
                flex: none; /* Remove flex grow */
                width: 100%; /* Take full width */
            }
            .screen-area {
                height: 150px;
                font-size: 1.5rem;
            }
            .screen-time {
                font-size: 1rem;
            }
            .screen-message {
                font-size: 1rem;
            }
            .scanner-area {
                width: 120px; /* Adjusted scanner size for smaller screens */
                height: 120px;
            }
            .scanner-area svg {
                width: 70px;
                height: 70px;
            }
            .keypad {
                padding: 0.75rem;
                gap: 0.5rem;
            }
            .key {
                font-size: 1rem;
                padding: 0.6rem 0.4rem;
            }
            .right-section-buttons {
                flex-direction: column; /* Stack buttons vertically on small screens */
                gap: 0.5rem;
            }
            .llm-btn, .action-btn {
                min-width: unset;
                max-width: 100%;
            }
        }
    </style>
@endsection
