@extends('admin.index')
@section('content')
   @php
use App\Models\SalesDefaultData;
$Def=SalesDefaultData::orderBy('id','desc')->first();
use App\Models\DefaultDataShowHide;
$show=DefaultDataShowHide::orderBy('id','desc')->first();
@endphp
  <title>{{trans('admin.Permission_to_receive_goods')}}</title>

    <main id="js-page-content" role="main" class="page-content">
                    <ol class="breadcrumb page-breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Stores')}} </a></li>
                        <li class="breadcrumb-item active">{{trans('admin.Permission_to_receive_goods')}} </li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                                class="js-get-date"></span></li>
                    </ol>

    <form id="form" action="{{url('PostEditRecivedGoods/'.$item->id)}}" method="post" enctype="multipart/form-data">

        {!! csrf_field() !!}
               @honeypot
                    <div class="row">
                        <div class="col-lg-12">
                            <div id="panel-2" class="panel">
                                <div class="panel-hdr">
                                    <h2>
                                        <span class="fw-300"><i>   {{trans('admin.Permission_to_receive_goods')}}  </i></span>
                                    </h2>
                                </div>
                                <div class="panel-container show">
                                      <span id="ex"> @include('admin.layouts.messages')</span>
                                    <div class="panel-content">
                                    <div class="form-row">
                                        <div class="form-group col-lg-2">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Code')}} </label>
                                            <input type="text" name="Old_Code" value="{{$item->Code}}" class="form-control " disabled>
                                            <input type="hidden" name="Code" value="{{$Code}}" class="form-control">
                                        </div>
                                        <div class="form-group col-lg-2">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                           <input type="date" name="Date" value="{{$item->Date}}" class="form-control" required>
                                        </div>


                                        <div class="form-group col-lg-2">
                                            <label class="form-label" for="">{{trans('admin.Store')}}</label>
                                            <select class="select2 form-control w-100" id="store" name="Store" required>
                              @foreach($Stores as $stor)
                                                <option value="{{$stor->id}}" @if($item->Store == $stor->id) selected @endif>
                                                {{app()->getLocale() == 'ar' ?$stor->Name :$stor->NameEn}}
                                                </option>
                                            @endforeach
                                            </select>
                                        </div>



                                        <div class="form-group col-lg-2">
                                            <label class="form-label" for="">{{trans('admin.Coin')}}</label>
                                            <select class="select2 form-control w-100" name="Coin" required>

                                            @foreach($Coins as $coin)
                                                <option value="{{$coin->id}}" @if($item->Coin == $coin->id) selected @endif>
                                                        {{app()->getLocale() == 'ar' ?$coin->Arabic_Name :$coin->English_Name}}
                                                </option>
                                            @endforeach
                                            </select>
                                        </div>
                                        <div class="form-group col-lg-2">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Draw')}}</label>
                                            <input type="text" name="Draw" value="{{$item->Draw}}" class="form-control" required>
                                        </div>


                                        <div class="form-group col-lg-2">
                                            <label class="form-label" for=""> {{trans('admin.Cost_Center')}} </label>
                                            <select class="select2 form-control w-100" name="Cost_Center">
                                            <option value=""> {{trans('admin.Cost_Center')}}</option>
                                            @foreach($CostCenters as $cost)
                                                <option value="{{$cost->id}}" @if($item->Cost_Center == $cost->id) selected @endif>
                                                      {{app()->getLocale() == 'ar' ?$cost->Arabic_Name :$cost->English_Name}}
                                                </option>
                                            @endforeach
                                            </select>
                                        </div>

                                        <div class="form-group col-lg-4">
                                            <label class="form-label" for="">{{trans('admin.Account')}}</label>
                       <select  class="select2 form-control w-100" id="client"  name="Account" required>

                                            @foreach($Accounts as $acc)
                                                <option value="{{$acc->id}}"  @if($item->Account == $acc->id) selected @endif>
                                               {{app()->getLocale() == 'ar' ?$acc->Name :$acc->NameEn}}
                                                </option>
                                            @endforeach
                                            </select>
                                        </div>



                                        <div class="form-group col-lg-4">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Notes')}}  </label>
                                            <input type="text" name="Note" value="{{$item->Note}}" class="form-control">
                                        </div>
                                    </div>
                            </div>
                        </div>
                    </div>
                    </div>
                    <div class="col-xl-12">
                        <div id="panel-1" class="panel">
                            <div class="form-group col-lg-12">
                                <label class="form-label" for="simpleinput">  </label>
                                <div class="input-items" style="position:relative;">
                 <input type="text" id="search" class="form-control" placeholder="{{trans('admin.Search_For_Products')}}">
                                                      @if(app()->getLocale() == 'ar' )
                     <i class="fal fa-barcode-alt" style="position:absolute ;top:5px;left:3px;"></i>
                      @else
                            <i class="fal fa-barcode-alt" style="position:absolute ;top:5px;right: 0;left:auto;"></i>
                      @endif
                                </div>
                             </div>
                            <div class="panel-container show">
                                <div class="panel-content">
                                      <div id="mobile-overflow">
                                    <table
                                    class="table table-bordered table-hover table-striped w-100 mobile-width-more">
                                    <thead>
                                        <tr>
                                            <th>{{trans('admin.Name')}}</th>
                                            <th>{{trans('admin.Unit')}}</th>
                                            <th>{{trans('admin.Code')}}</th>

                                            <th>{{trans('admin.Qty')}}</th>

                                            <th>{{trans('admin.Store')}}</th>
                                               @if($show->Expire_Date == 1)
                                            <th>{{trans('admin.Exp_Date')}}</th>
                                            @endif
                                            <th>{{trans('admin.Actions')}}</th>
                                        </tr>
                                    </thead>
                                    <tbody class="Data">

                                    </tbody>
                                    </table>
                                    </div>
                                    <!-- datatable start -->
                                      <div id="mobile-overflow">
                                    <table id="dt"
                                        class="table table-bordered table-hover table-striped w-100 mobile-width-more">
                                        <thead>
                                            <tr>
                                               <th>{{trans('admin.Name')}}</th>
                                            <th>{{trans('admin.Unit')}}</th>
                                            <th>{{trans('admin.Code')}}</th>

                                            <th>{{trans('admin.Qty')}}</th>

                                            <th>{{trans('admin.Store')}}</th>
                                                   @if($show->Expire_Date == 1)
                                            <th>{{trans('admin.Exp_Date')}}</th>
                                                @endif
                                            <th>{{trans('admin.Actions')}}</th>
                                            </tr>
                                        </thead>
                                        <tbody id="data-dt">
                                         @foreach($details as $detail)

                                <tr>
                                    <td>
                                        <input type='hidden' name='P_Ar_Name[]' value='{{$detail->P_Ar_Name}}'>
                                        <input type='hidden' name='P_En_Name[]' value='{{$detail->P_En_Name}}'>
                                           {{app()->getLocale() == 'ar' ?$detail->Product()->first()->P_Ar_Name :$detail->Product()->first()->P_En_Name}}
                                @if(!empty($detail->V1))    ({{app()->getLocale() == 'ar' ?$detail->V1()->first()->Name :$detail->V1()->first()->NameEn}} )  @endif
                                  @if(!empty($detail->V2))    ({{app()->getLocale() == 'ar' ?$detail->V2()->first()->Name :$detail->V2()->first()->NameEn}} )  @endif

                                    </td>
                                    <td><input type='hidden' name='Unit[]' value='{{$detail->Unit}}'>                  {{app()->getLocale() == 'ar' ?$detail->Unit()->first()->Name :$detail->Unit()->first()->NameEn}}  </td>
                                    <td><input type='hidden' name='P_Code[]' value='{{$detail->Product_Code}}'>{{$detail->Product_Code}}</td>

                   <td>
                       <input class='Qun form-control' id="QTY{{$detail->id}}" type='number' step="any" onclick="ChangeQty({{$detail->id}})" onkeyup="ChangeQty({{$detail->id}})" name='Qty[]' value='{{$detail->Qty}}'>

                    </td>




                                    <td><input  type='hidden' name='StorePurch[]' value='{{$detail->Store}}'>      {{app()->getLocale() == 'ar' ?$detail->Store()->first()->Name :$detail->Store()->first()->NameEn}}  </td>

                                       @if($show->Expire_Date == 1)
                                    <td>{{$detail->Exp_Date}}</td>
                                    @endif
                                    <td>

                                        <button id='DelAssem' type='button' class='btn btn-default'><i class='fal fa-trash'></i></button>
                                        <input type='hidden' name='Product[]' value='{{$detail->Product}}'>
                                        <input type='hidden' name='Exp_Date[]' value='{{$detail->Exp_Date}}'>
                                        <input type='hidden' name='VOne[]' value='{{$detail->V1}}'>
                                        <input type='hidden' name='VTwo[]' value='{{$detail->V2}}'>
                                     <input type='hidden' name='V_Name[]' value='{{$detail->V_Name}}'>
                                    <input type='hidden' name='VV_Name[]' value='{{$detail->VV_Name}}'>
                                    <input type='hidden' name='PurchTax[]' value='{{$detail->Tax()->first()->Rate}}'  id="TAXRATE{{$detail->id}}">
                                    <input type='hidden' name='PurchTax[]' value='{{$detail->Tax()->first()->Type}}'  id="TAXTYPE{{$detail->id}}">
                                    <input type='hidden' name='PurchTax[]' value='{{$detail->Tax}}'  id="TAX{{$detail->id}}">
                                    <input type='hidden' name='Price[]' value='{{$detail->Price}}'  id="PRICE{{$detail->id}}">
                                    <input class='Disc' type='hidden' name='Discount[]' value='{{$detail->Discount}}'  id="DISCOUNT{{$detail->id}}">
                                    <input class='TotalBFTax' type='hidden' name='TotalBFTax[]' value='{{$detail->Total_Bf_Tax}}'  id="TOTALBF{{$detail->id}}">
                                    <input class='TotalTax' type='hidden' name='TotalTax[]' value='{{$detail->Total_Tax}}'  id="TOTALTAX{{$detail->id}}">
                                    <input class='Tot' type='hidden' name='Total[]' value='{{$detail->Total}}'  id="TOTAL{{$detail->id}}">
                                        <input type='hidden' name='AvQty[]' value='{{$detail->AvQty}}' id="AVQTY{{$detail->id}}">
                                    </td>

                                            </tr>



                                        @endforeach
                                        </tbody>
                                    </table>
                                    </div>
                                    <!-- datatable end -->
                                    <div class="form-row">
                                        <div class="form-group col-lg-4">
                                 <label class="form-label" for="simpleinput"> {{trans('admin.Product_Numbers')}} </label>
                      <input type="text" id="Product_Numbers" disabled  class="form-control">
                      <input type="hidden" id="Product_NumbersHide" name="Product_Numbers">
                                        </div>
                                        <div class="form-group col-lg-4">
                         <label class="form-label" for="simpleinput"> {{trans('admin.Total_Qty')}} </label>
                                           <input type="text" id="Total_Qty" disabled  class="form-control">
                                            <input type="hidden" id="Total_QtyHide" name="Total_Qty">
                                                         <input type="hidden" id="Total_DiscountHide" name="Total_Discount">
      <input type="hidden" id="Total_Bf_TaxesHide" name="Total_BF_Taxes">
         <input type="hidden" id="Total_TaxesHide" name="Total_Taxes">
            <input type="hidden" id="Total_PriceHide" name="Total_Price">
                                        </div>




                                    </div>
                                    <div class="buttons mt-3" id="Submit" style="display: none">
                          <input type="hidden" id="sp" name="SP">
            <button type="button"  class="btn btn-primary" onclick="SPS()"> <i class="fal fa-folder"></i> {{trans('admin.Save_Changes')}} </button>


                                      </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    </div>
                </form>

                        @if(auth()->guard('admin')->user()->emp == 0)
     <input type="hidden" id="PUR" value="1">
          @else
  @if(auth()->guard('admin')->user()->cost_price_purch == 1)

    <input type="hidden" id="PUR" value="1">
@else
      <input type="hidden" id="PUR" value="0">

 @endif
                                    @endif


                </main>
@if(app()->getLocale() == 'ar' )
<input type="hidden" id="LANG" value="ar">
@else
<input type="hidden" id="LANG" value="en">
@endif

    <input type="hidden" id="EXPIRE" value="{{$show->Expire_Date}}">



@endsection

@push('js')

    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">

    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script>
        var autoSave = $('#autoSave');
        var interval;
        var timer = function()
        {
            interval = setInterval(function()
            {
                //start slide...
                if (autoSave.prop('checked'))
                    saveToLocal();

                clearInterval(interval);
            }, 3000);
        };

        //save
        var saveToLocal = function()
        {
            localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
            console.log("saved");
        }

        //delete
        var removeFromLocal = function()
        {
            localStorage.removeItem("summernoteData");
            $('#saveToLocal').summernote('reset');
        }

        $(document).ready(function()
        {
            //init default
            $('.js-summernote').summernote(
            {
                height: 200,
                tabsize: 2,
                placeholder: "Type here...",
                dialogsFade: true,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['strikethrough', 'superscript', 'subscript']],
                    ['font', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['fontname', ['fontname']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['height', ['height']]
                    ['table', ['table']],
                    ['insert', ['link', 'picture', 'video']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ],
                callbacks:
                {
                    //restore from localStorage
                    onInit: function(e)
                    {
                        $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                    },
                    onChange: function(contents, $editable)
                    {
                        clearInterval(interval);
                        timer();
                    }
                }
            });

            //load emojis
            $.ajax(
            {
                url: 'https://api.github.com/emojis',
                async: false
            }).then(function(data)
            {
                window.emojis = Object.keys(data);
                window.emojiUrls = data;
            });

            //init emoji example
            $(".js-hint2emoji").summernote(
            {
                height: 100,
                toolbar: false,
                placeholder: 'type starting with : and any alphabet',
                hint:
                {
                    match: /:([\-+\w]+)$/,
                    search: function(keyword, callback)
                    {
                        callback($.grep(emojis, function(item)
                        {
                            return item.indexOf(keyword) === 0;
                        }));
                    },
                    template: function(item)
                    {
                        var content = emojiUrls[item];
                        return '<img src="' + content + '" width="20" /> :' + item + ':';
                    },
                    content: function(item)
                    {
                        var url = emojiUrls[item];
                        if (url)
                        {
                            return $('<img />').attr('src', url).css('width', 20)[0];
                        }
                        return '';
                    }
                }
            });

            //init mentions example
            $(".js-hint2mention").summernote(
            {
                height: 100,
                toolbar: false,
                placeholder: "type starting with @",
                hint:
                {
                    mentions: ['jayden', 'sam', 'alvin', 'david'],
                    match: /\B@(\w*)$/,
                    search: function(keyword, callback)
                    {
                        callback($.grep(this.mentions, function(item)
                        {
                            return item.indexOf(keyword) == 0;
                        }));
                    },
                    content: function(item)
                    {
                        return '@' + item;
                    }
                }
            });

        });

    </script>

<!-- Search Selecet -->
<script>
    $(document).ready(function () {
        $(function () {
            $(".select2").select2();

            $(".select2-placeholder-multiple").select2({
                placeholder: "Select State",
            });
            $(".js-hide-search").select2({
                minimumResultsForSearch: 1 / 0,
            });
            $(".js-max-length").select2({
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items",
            });
            $(".select2-placeholder").select2({
                placeholder: "Select a state",
                allowClear: true,
            });

            $(".js-select2-icons").select2({
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function (elm) {
                    return elm;
                },
            });

            function icon(elm) {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
            }



        });
    });
</script>

    <!-- Unit Code and Name V-->
    <script>
        function  UnitCodePurch(r){

            var countryId = $('#UnitPurch'+r).val();
            var Pro = $('#Product'+r).val();
            var client = $('#client').val();
            var code = $('#CodePurch'+r).val();
            var Store = $('#StorePurch'+r).val();
            if(countryId) {
                $.ajax({
                    url: '1/UnitSalesFilter',
                    type:"GET",
                    data:{
                        countryId:countryId,
                        Pro:Pro,
                        client:client,
                        code:code,
                        Store:Store,
                    },
                    dataType:"json",
                    beforeSend: function(){
                        $('#loader').css("visibility", "visible");
                    },

                    success:function(data) {
                        $.each(data, function(key, value){


                            $('#UnitPurchName'+r).val(data.name);
                            $('#TaxRate'+r).val(data.rate);
                            $('#TaxType'+r).val(data.type);
                            $('#Price'+r).val(data.cost);
                            $('#PurchTax'+r).val(data.tax);
                            $('#AvQty'+r).val(parseFloat(data.qty).toFixed(2));


                            $('#UnitPriceOne'+r).val(data.priceOne);
                            $('#UnitPriceTwo'+r).val(data.priceTwo);
                            $('#UnitPriceThree'+r).val(data.priceThree);




                        });

                        var TaxRate = $("#TaxRate"+r).val();
                        var TaxType = $("#TaxType"+r).val();
                        var Qty = $("#Qty"+r).val();
                        var Price = $("#Price"+r).val();
                        var Discount = $("#Discount"+r).val();
                        var i = 0;
                        var ii=0;
                        var iii=0;


                        if(TaxType == 1){
                            //Precent

                            var BF = ( parseFloat(Qty) *  parseFloat(Price) ) -  parseFloat(Discount);

                            $("#TotalBFTax"+r).val(parseFloat(BF));

                            i =    parseFloat(TaxRate)  / 100 ;

                            ii=  parseFloat(BF) * parseFloat(i) ;

                            $("#Tax"+r).val(parseFloat(ii));

                            iii =  parseFloat(BF) + parseFloat(ii) ;

                            $("#Total"+r).val(parseFloat(iii));

                        }else if(TaxType == 2){
                            //Number
                            var BF = ( parseFloat(Qty) *  parseFloat(Price) ) -  parseFloat(Discount);
                            $("#TotalBFTax"+r).val(parseFloat(BF));

                            i =    parseFloat(TaxRate)   ;

                            $("#Tax"+r).val(parseFloat(i));

                            iii =  parseFloat(BF) + parseFloat(i) ;

                            $("#Total"+r).val(parseFloat(iii));


                        }


                        var Total = $("#Total"+r).val();
                        var TotalBFTax = $("#TotalBFTax"+r).val();
                        var Tax = $("#Tax"+r).val();
                        var UnitID = $("#UnitPurch"+r).val();
                        var StorePurch = $("#StorePurch"+r).val();
                        var AvQty = $("#AvQty"+r).val();
                        var x=  @php echo $Def->Mainus; @endphp ;

                        if(TaxRate == ''  || TaxType == ''  ||  Qty == '' || Price == '' || Discount == '' || Total == '' || TotalBFTax == '' || Tax == '' || UnitID == '' || StorePurch == ''){

                            document.getElementById("AddBtnPur"+r).style.display = "none";
                        }


                        if(TaxRate != ''  && TaxType != ''  &&  Qty != '' && Price != '' && Discount != '' && Total != '' && TotalBFTax != '' && Tax != '' && UnitID != '' && StorePurch != ''){

                            document.getElementById("AddBtnPur"+r).style.display = "block";
                        }

                        // x de elly hya lw byshtghl bsalb
                        if(x == 0){

                            if(AvQty != 0){


                                if(parseFloat(AvQty) >= parseFloat(Qty)){

                                    document.getElementById("AddBtnPur"+r).style.display = "block";

                                }else{


                                    document.getElementById("AddBtnPur"+r).style.display = "none";

                                }


                            }else{

                                document.getElementById("AddBtnPur"+r).style.display = "none";
                            }


                        }else{

                            document.getElementById("AddBtnPur"+r).style.display = "block";

                        }



                    },
                    complete: function(){
                        $('#loader').css("visibility", "hidden");
                    }
                });
            } else {

                $('select[name="state"]').empty();
            }

        }
    </script>

    <!-- Unit Code and Name -->
    <script>
        function  UnitCodePurchh(r){

            var countryId = $('#UnitPurch'+r).val();
            var Pro = $('#Product'+r).val();
            var client = $('#client').val();
            var code = $('#CodePurch'+r).val();
            var Store = $('#StorePurch'+r).val();
            if(countryId) {
                $.ajax({
                    url: '1/UnitSalesFilter',
                    type:"GET",
                    data:{
                        countryId:countryId,
                        Pro:Pro,
                        client:client,
                        code:code,
                        Store:Store,
                    },
                    dataType:"json",
                    beforeSend: function(){
                        $('#loader').css("visibility", "visible");
                    },

                    success:function(data) {
                        $.each(data, function(key, value){

                            $('#CodePurch'+r).val(data.code);
                            $('#UnitPurchName'+r).val(data.name);
                            $('#TaxRate'+r).val(data.rate);
                            $('#TaxType'+r).val(data.type);
                            $('#Price'+r).val(data.cost);
                            $('#PurchTax'+r).val(data.tax);
                            $('#AvQty'+r).val(parseFloat(data.qty).toFixed(2));

                            $('#UnitPriceOne'+r).val(data.priceOne);
                            $('#UnitPriceTwo'+r).val(data.priceTwo);
                            $('#UnitPriceThree'+r).val(data.priceThree);




                        });

                        var TaxRate = $("#TaxRate"+r).val();
                        var TaxType = $("#TaxType"+r).val();
                        var Qty = $("#Qty"+r).val();
                        var Price = $("#Price"+r).val();
                        var Discount = $("#Discount"+r).val();
                        var i = 0;
                        var ii=0;
                        var iii=0;


                        if(TaxType == 1){
                            //Precent

                            var BF = ( parseFloat(Qty) *  parseFloat(Price) ) -  parseFloat(Discount);

                            $("#TotalBFTax"+r).val(parseFloat(BF));

                            i =    parseFloat(TaxRate)  / 100 ;

                            ii=  parseFloat(BF) * parseFloat(i) ;

                            $("#Tax"+r).val(parseFloat(ii));

                            iii =  parseFloat(BF) + parseFloat(ii) ;

                            $("#Total"+r).val(parseFloat(iii));

                        }else if(TaxType == 2){
                            //Number
                            var BF = ( parseFloat(Qty) *  parseFloat(Price) ) -  parseFloat(Discount);
                            $("#TotalBFTax"+r).val(parseFloat(BF));

                            i =    parseFloat(TaxRate)   ;

                            $("#Tax"+r).val(parseFloat(i));

                            iii =  parseFloat(BF) + parseFloat(i) ;

                            $("#Total"+r).val(parseFloat(iii));


                        }


                        var Total = $("#Total"+r).val();
                        var TotalBFTax = $("#TotalBFTax"+r).val();
                        var Tax = $("#Tax"+r).val();
                        var UnitID = $("#UnitPurch"+r).val();
                        var StorePurch = $("#StorePurch"+r).val();
                        var AvQty = $("#AvQty"+r).val();
                        var x=  @php echo $Def->Mainus; @endphp ;

                        if(TaxRate == ''  || TaxType == ''  ||  Qty == '' || Price == '' || Discount == '' || Total == '' || TotalBFTax == '' || Tax == '' || UnitID == '' || StorePurch == ''){

                            document.getElementById("AddBtnPur"+r).style.display = "none";
                        }


                        if(TaxRate != ''  && TaxType != ''  &&  Qty != '' && Price != '' && Discount != '' && Total != '' && TotalBFTax != '' && Tax != '' && UnitID != '' && StorePurch != ''){

                            document.getElementById("AddBtnPur"+r).style.display = "block";
                        }

                        // x de elly hya lw byshtghl bsalb
                        if(x == 0){

                            if(AvQty != 0){


                                if(parseFloat(AvQty) >= parseFloat(Qty)){

                                    document.getElementById("AddBtnPur"+r).style.display = "block";

                                }else{


                                    document.getElementById("AddBtnPur"+r).style.display = "none";

                                }


                            }else{

                                document.getElementById("AddBtnPur"+r).style.display = "none";
                            }


                        }else{

                            document.getElementById("AddBtnPur"+r).style.display = "block";

                        }



                    },
                    complete: function(){
                        $('#loader').css("visibility", "hidden");
                    }
                });
            } else {

                $('select[name="state"]').empty();
            }

        }
    </script>


    <!-- Store Name -->
    <script>
        function  StoreNamePurch(r){

            var countryId = $('#StorePurch'+r).val();
            var Product = $('#Product'+r).val();
            var Code = $('#CodePurch'+r).val();
            var Unit = $('#UnitPurch'+r).val();
            if(countryId) {
                $.ajax({
                    url: '1/StoreNameSalesFilter',
                    type:"GET",
                    data:{
                        countryId:countryId,
                        Product:Product,
                        Code:Code,
                        Unit:Unit,
                    },
                    dataType:"json",
                    beforeSend: function(){
                        $('#loader').css("visibility", "visible");
                    },

                    success:function(data) {
                        $.each(data, function(key, value){

                            $('#StorePurchName'+r).val(data.name);
                            $('#AvQty'+r).val(data.AvQty);



                        });

                        var TaxRate = $("#TaxRate"+r).val();
                        var TaxType = $("#TaxType"+r).val();
                        var Qty = $("#Qty"+r).val();
                        var Price = $("#Price"+r).val();
                        var Discount = $("#Discount"+r).val();
                        var i = 0;
                        var ii=0;
                        var iii=0;


                        if(TaxType == 1){
                            //Precent

                            var BF = ( parseFloat(Qty) *  parseFloat(Price) ) -  parseFloat(Discount);

                            $("#TotalBFTax"+r).val(parseFloat(BF));

                            i =    parseFloat(TaxRate)  / 100 ;

                            ii=  parseFloat(BF) * parseFloat(i) ;

                            $("#Tax"+r).val(parseFloat(ii));

                            iii =  parseFloat(BF) + parseFloat(ii) ;

                            $("#Total"+r).val(parseFloat(iii));

                        }else if(TaxType == 2){
                            //Number
                            var BF = ( parseFloat(Qty) *  parseFloat(Price) ) -  parseFloat(Discount);
                            $("#TotalBFTax"+r).val(parseFloat(BF));

                            i =    parseFloat(TaxRate)   ;

                            $("#Tax"+r).val(parseFloat(i));

                            iii =  parseFloat(BF) + parseFloat(i) ;

                            $("#Total"+r).val(parseFloat(iii));


                        }


                        var Total = $("#Total"+r).val();
                        var TotalBFTax = $("#TotalBFTax"+r).val();
                        var Tax = $("#Tax"+r).val();
                        var UnitID = $("#UnitPurch"+r).val();
                        var StorePurch = $("#StorePurch"+r).val();
                        var AvQty = $("#AvQty"+r).val();
                        var x=  @php echo $Def->Mainus; @endphp ;




                        if(TaxRate == ''  || TaxType == ''  ||  Qty == '' || Price == '' || Discount == '' || Total == '' || TotalBFTax == '' || Tax == '' || UnitID == '' || StorePurch == ''){

                            document.getElementById("AddBtnPur"+r).style.display = "none";
                        }


                        if(TaxRate != ''  && TaxType != ''  &&  Qty != '' && Price != '' && Discount != '' && Total != '' && TotalBFTax != '' && Tax != '' && UnitID != '' && StorePurch != ''){

                            document.getElementById("AddBtnPur"+r).style.display = "block";
                        }

                        // x de elly hya lw byshtghl bsalb
                        if(x == 0){

                            if(AvQty != 0){


                                if(parseFloat(AvQty) >= parseFloat(Qty)){

                                    document.getElementById("AddBtnPur"+r).style.display = "block";

                                }else{

                                    document.getElementById("AddBtnPur"+r).style.display = "none";

                                }


                            }else{

                                document.getElementById("AddBtnPur"+r).style.display = "none";
                            }


                        }else{

                            document.getElementById("AddBtnPur"+r).style.display = "block";

                        }




                    },
                    complete: function(){
                        $('#loader').css("visibility", "hidden");
                    }
                });
            } else {

                $('select[name="state"]').empty();
            }

        }
    </script>


    <!--  Filter Products -->
<script>
   $(document).ready(function(){

    fetch_customer_data();

    function fetch_customer_data(search = '',store='')
    {
     $.ajax({
      url:'1/RecivedProductsFilter',
      method:'GET',
      data:{search:search,store:store},
      dataType:'json',
      success:function(data)
      {
       $('.Data').html(data.table_data);
      }
     })
    }

   $(document).on('keyup', '#search', function(){
     var search = $(this).val();
     var store = $('#store').val();
     fetch_customer_data(search,store);
    });


    $(document).on('change', '#store', function(){
     var store = $(this).val();
     var search = $('#search').val();
     fetch_customer_data(search,store);
    });

   });
</script>

<!-- Add Products -->
<script>
   function Fun(r) {

             var P_Ar_Name = $("#P_Ar_Name"+r).val();
             var P_En_Name= $("#P_En_Name"+r).val();
             var Product = $("#Product"+r).val();
             var UnitID = $("#UnitPurch"+r).val();
             var UnitName = $("#UnitPurchName"+r).val();
             var Qty = $("#Qty"+r).val();
             var AvQty = $("#AvQty"+r).val();
             var Barcode = $("#CodePurch"+r).val();
             var Price = $("#Price"+r).val();
             var Total = $("#Total"+r).val();
             var ExpDate = $("#ExpDate"+r).val();
             var PurchTax = $("#PurchTax"+r).val();
             var TotalTax = $("#Tax"+r).val();
             var Discount = $("#Discount"+r).val();
             var TotalBFTax = $("#TotalBFTax"+r).val();
             var StorePurch = $("#StorePurch"+r).val();
             var StorePurchName = $("#StorePurchName"+r).val();
             var PurchTax = $("#PurchTax"+r).val();
             var VOne = $("#VOne"+r).val();
             var VTwo = $("#VTwo"+r).val();
             var V_Name = $("#V_Name"+r).val();
             var VV_Name = $("#VV_Name"+r).val();
             var Viro = '';
             var VViro = '';
       var PUR=$("#PUR").val();
       if( V_Name != ''){

          Viro= '(' + V_Name +')';
       }

       if( VV_Name != ''){

         VViro= '(' + VV_Name +')';
       }

               var LANG = $("#LANG").val();
   if(LANG == 'ar' ){
          var Nemo = P_Ar_Name ;
          }else{
             var Nemo = P_En_Name ;
          }

             document.getElementById("AddBtnPur"+r).style.display = "none";
             document.getElementById("Row"+r).style.display = "none";

                  var EXPIRE = $("#EXPIRE").val();
    if(parseFloat(EXPIRE) == 1 ){
          var Exp =  "<td><input type='hidden' name='Exp_Date[]' value='"+ExpDate+"'>" + ExpDate + "</td>";
          }else{
             var Exp = "<input type='hidden' name='Exp_Date[]' value='"+ExpDate+"'>";
          }


        var markup = "<tr><td><input type='hidden' name='P_Ar_Name[]' value='"+P_Ar_Name+"'><input type='hidden' name='P_En_Name[]' value='"+P_En_Name+"'>" + Nemo + ""+ Viro +" "+ VViro +"</td><td><input type='hidden' name='Unit[]' value='"+UnitID+"'>" + UnitName + "</td><td><input type='hidden' name='P_Code[]' value='"+Barcode+"'>" + Barcode + "</td><td><input class='Qun' type='hidden' name='Qty[]' value='"+Qty+"'>" + Qty + "</td><td><input  type='hidden' name='StorePurch[]' value='"+StorePurch+"'>" + StorePurchName + "</td>"+Exp+"<td><button id='DelAssem' type='button' class='btn btn-default'><i class='fal fa-trash'></i></button><input type='hidden' name='Product[]' value='"+Product+"'><input type='hidden' name='VOne[]' value='"+VOne+"'><input type='hidden' name='VTwo[]' value='"+VTwo+"'></td><input type='hidden' name='V_Name[]' value='"+Viro+"'><input type='hidden' name='VV_Name[]' value='"+VViro+"'><input type='hidden' name='PurchTax[]' value='"+PurchTax+"'><input type='hidden' name='Price[]' value='"+Price+"'><input class='Disc' type='hidden' name='Discount[]' value='"+Discount+"'><input class='TotalBFTax' type='hidden' name='TotalBFTax[]' value='"+TotalBFTax+"'><input class='TotalTax' type='hidden' name='TotalTax[]' value='"+TotalTax+"'><input type='hidden' name='AvQty[]' value='"+AvQty+"'><input class='Tot' type='hidden' name='Total[]' value='"+Total+"'></tr>";


             $("#data-dt").append(markup);

      $.fn.rowCount = function() {
     return $('tr', $(this).find('tbody')).length;
   };

   var rowctr = $('#dt').rowCount();

    var sumQ = 0;
   $('.Qun').each(function(){
   sumQ += parseFloat($(this).val());
   });

    var sumT = 0;
   $('.Tot').each(function(){
   sumT += parseFloat($(this).val());
   });

        var sumD = 0;
   $('.Disc').each(function(){
   sumD += parseFloat($(this).val());
   });


           var sumBF = 0;
   $('.TotalBFTax').each(function(){
   sumBF += parseFloat($(this).val());
   });

           var sumTax = 0;
   $('.TotalTax').each(function(){
   sumTax += parseFloat($(this).val());
   });


   $('#Product_Numbers').val(parseFloat(rowctr));
   $('#Product_NumbersHide').val(parseFloat(rowctr));

   $('#Total_Qty').val(parseFloat(sumQ));
   $('#Total_QtyHide').val(parseFloat(sumQ));

   $('#Total_Price').val(parseFloat(sumT));
   $('#Total_PriceHide').val(parseFloat(sumT));


   $('#Total_Discount').val(parseFloat(sumD));
   $('#Total_DiscountHide').val(parseFloat(sumD));

   $('#Total_Bf_Taxes').val(parseFloat(sumBF));
   $('#Total_Bf_TaxesHide').val(parseFloat(sumBF));

   $('#Total_Taxes').val(parseFloat(sumTax));
   $('#Total_TaxesHide').val(parseFloat(sumTax));


       if(rowctr == 0){
        document.getElementById("Submit").style.display = "none";

       }else{

        document.getElementById("Submit").style.display = "block";
       }

            var Pay =$('#Payment_Method').val();
        var Stat =$('#Status').val();
        var paid =$('#paid').val();

      if(Pay == 'Later' &&  Stat == 0 ){

             if(paid == 0 || paid < 0){
        document.getElementById("Submit").style.display = "none";
             }else{

           if(rowctr == 0){
        document.getElementById("Submit").style.display = "none";

       }else{

        document.getElementById("Submit").style.display = "block";
       }



             }

       }else{

       if(rowctr == 0){
        document.getElementById("Submit").style.display = "none";

       }else{

        document.getElementById("Submit").style.display = "block";
       }
       }

        $('#data-dt').on('click', '#DelAssem', function(e){
                $(this).closest('tr').remove();


      $.fn.rowCount = function() {
     return $('tr', $(this).find('tbody')).length;
   };

   var rowctr = $('#dt').rowCount();

    var sumQ = 0;
   $('.Qun').each(function(){
   sumQ += parseFloat($(this).val());
   });

    var sumT = 0;
   $('.Tot').each(function(){
   sumT += parseFloat($(this).val());
   });

        var sumD = 0;
   $('.Disc').each(function(){
   sumD += parseFloat($(this).val());
   });


           var sumBF = 0;
   $('.TotalBFTax').each(function(){
   sumBF += parseFloat($(this).val());
   });

           var sumTax = 0;
   $('.TotalTax').each(function(){
   sumTax += parseFloat($(this).val());
   });


   $('#Product_Numbers').val(parseFloat(rowctr));
   $('#Product_NumbersHide').val(parseFloat(rowctr));

   $('#Total_Qty').val(parseFloat(sumQ));
   $('#Total_QtyHide').val(parseFloat(sumQ));

   $('#Total_Price').val(parseFloat(sumT));
   $('#Total_PriceHide').val(parseFloat(sumT));


       $('#Total_Discount').val(parseFloat(sumD));
   $('#Total_DiscountHide').val(parseFloat(sumD));

          $('#Total_Bf_Taxes').val(parseFloat(sumBF));
   $('#Total_Bf_TaxesHide').val(parseFloat(sumBF));

          $('#Total_Taxes').val(parseFloat(sumTax));
   $('#Total_TaxesHide').val(parseFloat(sumTax));


       if(rowctr == 0){
        document.getElementById("Submit").style.display = "none";

       }else{

        document.getElementById("Submit").style.display = "block";
       }

                  var Pay =$('#Payment_Method').val();
        var Stat =$('#Status').val();
        var paid =$('#paid').val();

      if(Pay == 'Later' &&  Stat == 0 ){

             if(paid == 0 || paid < 0){
        document.getElementById("Submit").style.display = "none";
             }else{

           if(rowctr == 0){
        document.getElementById("Submit").style.display = "none";

       }else{

        document.getElementById("Submit").style.display = "block";
       }



             }

       }else{

       if(rowctr == 0){
        document.getElementById("Submit").style.display = "none";

       }else{

        document.getElementById("Submit").style.display = "block";
       }
       }






                    })


     }
</script>

<!-- Total Products -->
<script>
   function PurchTotal(r) {
   var TaxRate = $("#TaxRate"+r).val();
   var TaxType = $("#TaxType"+r).val();
   var Qty = $("#Qty"+r).val();
   var AvQty = $("#AvQty"+r).val();
   var Price = $("#Price"+r).val();
   var Discount = $("#Discount"+r).val();
   var i = 0;
   var ii=0;
   var iii=0;
 var x=  @php echo $Def->Mainus; @endphp ;


       if(TaxType == 1){
           //Precent

      var BF = ( parseFloat(Qty) *  parseFloat(Price) ) -  parseFloat(Discount);

       $("#TotalBFTax"+r).val(parseFloat(BF));

       i =    parseFloat(TaxRate)  / 100 ;

        ii=  parseFloat(BF) * parseFloat(i) ;

           $("#Tax"+r).val(parseFloat(ii));

       iii =  parseFloat(BF) + parseFloat(ii) ;

           $("#Total"+r).val(parseFloat(iii));

       }else if(TaxType == 2){
          //Number
        var BF = ( parseFloat(Qty) *  parseFloat(Price) ) -  parseFloat(Discount);
         $("#TotalBFTax"+r).val(parseFloat(BF));

            i =    parseFloat(TaxRate)   ;

           $("#Tax"+r).val(parseFloat(i));

       iii =  parseFloat(BF) + parseFloat(i) ;

           $("#Total"+r).val(parseFloat(iii));


       }


        var Total = $("#Total"+r).val();
        var TotalBFTax = $("#TotalBFTax"+r).val();
        var Tax = $("#Tax"+r).val();
        var UnitID = $("#UnitPurch"+r).val();
        var StorePurch = $("#StorePurch"+r).val();

       if(TaxRate == ''  || TaxType == ''  ||  Qty == '' || Price == '' || Discount == '' || Total == '' || TotalBFTax == '' || Tax == '' || UnitID == '' || StorePurch == ''){

        document.getElementById("AddBtnPur"+r).style.display = "none";
     }


       if(TaxRate != ''  && TaxType != ''  &&  Qty != ''  && Qty != 0 && Price != '' && Discount != '' && Total != '' && TotalBFTax != '' && Tax != '' && UnitID != '' && StorePurch != ''){

        document.getElementById("AddBtnPur"+r).style.display = "block";
     }




   }

    function ChangeQty(r){

         var TaxRate = $("#TAXRATE"+r).val();
   var TaxType = $("#TAXTYPE"+r).val();
   var Qty = $("#QTY"+r).val();
   var AvQty = $("#AVQTY"+r).val();
   var Price = $("#PRICE"+r).val();
   var Discount = $("#DISCOUNT"+r).val();
   var i = 0;
   var ii=0;
   var iii=0;

 var x=  @php echo $Def->Mainus; @endphp ;


       if(TaxType == 1){
           //Precent

      var BF = ( parseFloat(Qty) *  parseFloat(Price) ) -  parseFloat(Discount);

       $("#TOTALBF"+r).val(parseFloat(BF));

       i =    parseFloat(TaxRate)  / 100 ;

        ii=  parseFloat(BF) * parseFloat(i) ;

           $("#TOTALTAX"+r).val(parseFloat(ii));

       iii =  parseFloat(BF) + parseFloat(ii) ;

           $("#TOTAL"+r).val(parseFloat(iii));

       }else if(TaxType == 2){
          //Number
        var BF = ( parseFloat(Qty) *  parseFloat(Price) ) -  parseFloat(Discount);
         $("#TOTALBF"+r).val(parseFloat(BF));

            i =    parseFloat(TaxRate)   ;

           $("#TOTALTAX"+r).val(parseFloat(i));

       iii =  parseFloat(BF) + parseFloat(i) ;

           $("#TOTAL"+r).val(parseFloat(iii));


       }

            $.fn.rowCount = function() {
     return $('tr', $(this).find('tbody')).length;
   };

   var rowctr = $('#dt').rowCount();

    var sumQ = 0;
   $('.Qun').each(function(){
   sumQ += parseFloat($(this).val());
   });

    var sumT = 0;
   $('.Tot').each(function(){
   sumT += parseFloat($(this).val());
   });

        var sumD = 0;
   $('.Disc').each(function(){
   sumD += parseFloat($(this).val());
   });


           var sumBF = 0;
   $('.TotalBFTax').each(function(){
   sumBF += parseFloat($(this).val());
   });

           var sumTax = 0;
   $('.TotalTax').each(function(){
   sumTax += parseFloat($(this).val());
   });


   $('#Product_Numbers').val(parseFloat(rowctr));
   $('#Product_NumbersHide').val(parseFloat(rowctr));

   $('#Total_Qty').val(parseFloat(sumQ));
   $('#Total_QtyHide').val(parseFloat(sumQ));

   $('#Total_Price').val(parseFloat(sumT));
   $('#Total_PriceHide').val(parseFloat(sumT));


   $('#Total_Discount').val(parseFloat(sumD));
   $('#Total_DiscountHide').val(parseFloat(sumD));

   $('#Total_Bf_Taxes').val(parseFloat(sumBF));
   $('#Total_Bf_TaxesHide').val(parseFloat(sumBF));

   $('#Total_Taxes').val(parseFloat(sumTax));
   $('#Total_TaxesHide').val(parseFloat(sumTax));



    }
</script>

<!-- Scanner  problem -->
<script>
   $(".form-control").keypress(function(event){
   if (event.which == '10' || event.which == '13') {
   event.preventDefault();
   }
   });


</script>

<!-- Submit Script -->
<script>

        function SPP(){
           $('#sp').val(1);
           var x= $('#sp').val();

        if(x == 1){
             document.getElementById("Submit").style.display = "none";
      document.getElementById('form').submit();
        }
    }


       function SPS(){
           $('#sp').val(0);
           var x= $('#sp').val();

        if(x == 0){
             document.getElementById("Submit").style.display = "none";
      document.getElementById('form').submit();
        }
    }

      function SPP8(){
           $('#sp').val(2);
           var x= $('#sp').val();

        if(x == 2){
             document.getElementById("Submit").style.display = "none";
      document.getElementById('form').submit();
        }
    }



</script>

<!-- Change Price -->
<script>
function ChangePriceU(r){

  var PriceOne = $("#UnitPriceOne"+r).val();
       $("#Price"+r).val(parseFloat(PriceOne).toFixed(2));

 var TaxRate = $("#TaxRate"+r).val();
   var TaxType = $("#TaxType"+r).val();
   var Qty = $("#Qty"+r).val();
   var AvQty = $("#AvQty"+r).val();
   var Price = $("#Price"+r).val();
   var Discount = $("#Discount"+r).val();
   var i = 0;
   var ii=0;
   var iii=0;
 var x=  @php echo $Def->Mainus; @endphp ;


       if(TaxType == 1){
           //Precent

      var BF = ( parseFloat(Qty) *  parseFloat(Price) ) -  parseFloat(Discount);

       $("#TotalBFTax"+r).val(parseFloat(BF));

       i =    parseFloat(TaxRate)  / 100 ;

        ii=  parseFloat(BF) * parseFloat(i) ;

           $("#Tax"+r).val(parseFloat(ii));

       iii =  parseFloat(BF) + parseFloat(ii) ;

           $("#Total"+r).val(parseFloat(iii));

       }else if(TaxType == 2){
          //Number
        var BF = ( parseFloat(Qty) *  parseFloat(Price) ) -  parseFloat(Discount);
         $("#TotalBFTax"+r).val(parseFloat(BF));

            i =    parseFloat(TaxRate)   ;

           $("#Tax"+r).val(parseFloat(i));

       iii =  parseFloat(BF) + parseFloat(i) ;

           $("#Total"+r).val(parseFloat(iii));


       }


        var Total = $("#Total"+r).val();
        var TotalBFTax = $("#TotalBFTax"+r).val();
        var Tax = $("#Tax"+r).val();
        var UnitID = $("#UnitPurch"+r).val();
        var StorePurch = $("#StorePurch"+r).val();

       if(TaxRate == ''  || TaxType == ''  ||  Qty == '' || Price == '' || Discount == '' || Total == '' || TotalBFTax == '' || Tax == '' || UnitID == '' || StorePurch == ''){

        document.getElementById("AddBtnPur"+r).style.display = "none";
     }


       if(TaxRate != ''  && TaxType != ''  &&  Qty != ''  && Qty != 0 && Price != '' && Discount != '' && Total != '' && TotalBFTax != '' && Tax != '' && UnitID != '' && StorePurch != ''){

        document.getElementById("AddBtnPur"+r).style.display = "block";
     }

      // x de elly hya lw byshtghl bsalb
    if(x == 0){

       if(parseFloat(AvQty) != 0){


        if(parseFloat(AvQty) >= parseFloat(Qty)){


    document.getElementById("AddBtnPur"+r).style.display = "block";

        }else{

   document.getElementById("AddBtnPur"+r).style.display = "none";

        }


           }else{

      document.getElementById("AddBtnPur"+r).style.display = "none";
           }


    }else{

       document.getElementById("AddBtnPur"+r).style.display = "block";

    }


}


function ChangePriceUU(r){

  var PriceTwo = $("#UnitPriceTwo"+r).val();
       $("#Price"+r).val(parseFloat(PriceTwo).toFixed(2));

 var TaxRate = $("#TaxRate"+r).val();
   var TaxType = $("#TaxType"+r).val();
   var Qty = $("#Qty"+r).val();
   var AvQty = $("#AvQty"+r).val();
   var Price = $("#Price"+r).val();
   var Discount = $("#Discount"+r).val();
   var i = 0;
   var ii=0;
   var iii=0;
 var x=  @php echo $Def->Mainus; @endphp ;


       if(TaxType == 1){
           //Precent

      var BF = ( parseFloat(Qty) *  parseFloat(Price) ) -  parseFloat(Discount);

       $("#TotalBFTax"+r).val(parseFloat(BF));

       i =    parseFloat(TaxRate)  / 100 ;

        ii=  parseFloat(BF) * parseFloat(i) ;

           $("#Tax"+r).val(parseFloat(ii));

       iii =  parseFloat(BF) + parseFloat(ii) ;

           $("#Total"+r).val(parseFloat(iii));

       }else if(TaxType == 2){
          //Number
        var BF = ( parseFloat(Qty) *  parseFloat(Price) ) -  parseFloat(Discount);
         $("#TotalBFTax"+r).val(parseFloat(BF));

            i =    parseFloat(TaxRate)   ;

           $("#Tax"+r).val(parseFloat(i));

       iii =  parseFloat(BF) + parseFloat(i) ;

           $("#Total"+r).val(parseFloat(iii));


       }


        var Total = $("#Total"+r).val();
        var TotalBFTax = $("#TotalBFTax"+r).val();
        var Tax = $("#Tax"+r).val();
        var UnitID = $("#UnitPurch"+r).val();
        var StorePurch = $("#StorePurch"+r).val();

       if(TaxRate == ''  || TaxType == ''  ||  Qty == '' || Price == '' || Discount == '' || Total == '' || TotalBFTax == '' || Tax == '' || UnitID == '' || StorePurch == ''){

        document.getElementById("AddBtnPur"+r).style.display = "none";
     }


       if(TaxRate != ''  && TaxType != ''  &&  Qty != ''  && Qty != 0 && Price != '' && Discount != '' && Total != '' && TotalBFTax != '' && Tax != '' && UnitID != '' && StorePurch != ''){

        document.getElementById("AddBtnPur"+r).style.display = "block";
     }

      // x de elly hya lw byshtghl bsalb
    if(x == 0){

       if(parseFloat(AvQty) != 0){


        if(parseFloat(AvQty) >= parseFloat(Qty)){


    document.getElementById("AddBtnPur"+r).style.display = "block";

        }else{

   document.getElementById("AddBtnPur"+r).style.display = "none";

        }


           }else{

      document.getElementById("AddBtnPur"+r).style.display = "none";
           }


    }else{

       document.getElementById("AddBtnPur"+r).style.display = "block";

    }


}



function ChangePriceUUU(r){

  var PriceThree = $("#UnitPriceThree"+r).val();
       $("#Price"+r).val(parseFloat(PriceThree).toFixed(2));

 var TaxRate = $("#TaxRate"+r).val();
   var TaxType = $("#TaxType"+r).val();
   var Qty = $("#Qty"+r).val();
   var AvQty = $("#AvQty"+r).val();
   var Price = $("#Price"+r).val();
   var Discount = $("#Discount"+r).val();
   var i = 0;
   var ii=0;
   var iii=0;
 var x=  @php echo $Def->Mainus; @endphp ;


       if(TaxType == 1){
           //Precent

      var BF = ( parseFloat(Qty) *  parseFloat(Price) ) -  parseFloat(Discount);

       $("#TotalBFTax"+r).val(parseFloat(BF));

       i =    parseFloat(TaxRate)  / 100 ;

        ii=  parseFloat(BF) * parseFloat(i) ;

           $("#Tax"+r).val(parseFloat(ii));

       iii =  parseFloat(BF) + parseFloat(ii) ;

           $("#Total"+r).val(parseFloat(iii));

       }else if(TaxType == 2){
          //Number
        var BF = ( parseFloat(Qty) *  parseFloat(Price) ) -  parseFloat(Discount);
         $("#TotalBFTax"+r).val(parseFloat(BF));

            i =    parseFloat(TaxRate)   ;

           $("#Tax"+r).val(parseFloat(i));

       iii =  parseFloat(BF) + parseFloat(i) ;

           $("#Total"+r).val(parseFloat(iii));


       }


        var Total = $("#Total"+r).val();
        var TotalBFTax = $("#TotalBFTax"+r).val();
        var Tax = $("#Tax"+r).val();
        var UnitID = $("#UnitPurch"+r).val();
        var StorePurch = $("#StorePurch"+r).val();

       if(TaxRate == ''  || TaxType == ''  ||  Qty == '' || Price == '' || Discount == '' || Total == '' || TotalBFTax == '' || Tax == '' || UnitID == '' || StorePurch == ''){

        document.getElementById("AddBtnPur"+r).style.display = "none";
     }


       if(TaxRate != ''  && TaxType != ''  &&  Qty != ''  && Qty != 0 && Price != '' && Discount != '' && Total != '' && TotalBFTax != '' && Tax != '' && UnitID != '' && StorePurch != ''){

        document.getElementById("AddBtnPur"+r).style.display = "block";
     }

      // x de elly hya lw byshtghl bsalb
    if(x == 0){

       if(parseFloat(AvQty) != 0){


        if(parseFloat(AvQty) >= parseFloat(Qty)){


    document.getElementById("AddBtnPur"+r).style.display = "block";

        }else{

   document.getElementById("AddBtnPur"+r).style.display = "none";

        }


           }else{

      document.getElementById("AddBtnPur"+r).style.display = "none";
           }


    }else{

       document.getElementById("AddBtnPur"+r).style.display = "block";

    }


}



</script>

<script>

           $(document).ready(function()
        {
 $.fn.rowCount = function() {
     return $('tr', $(this).find('tbody')).length;
   };

   var rowctr = $('#dt').rowCount();

    var sumQ = 0;
   $('.Qun').each(function(){
   sumQ += parseFloat($(this).val());
   });

    var sumT = 0;
   $('.Tot').each(function(){
   sumT += parseFloat($(this).val());
   });

        var sumD = 0;
   $('.Disc').each(function(){
   sumD += parseFloat($(this).val());
   });


           var sumBF = 0;
   $('.TotalBFTax').each(function(){
   sumBF += parseFloat($(this).val());
   });

           var sumTax = 0;
   $('.TotalTax').each(function(){
   sumTax += parseFloat($(this).val());
   });


   $('#Product_Numbers').val(parseFloat(rowctr));
   $('#Product_NumbersHide').val(parseFloat(rowctr));

   $('#Total_Qty').val(parseFloat(sumQ));
   $('#Total_QtyHide').val(parseFloat(sumQ));

   $('#Total_Price').val(parseFloat(sumT));
   $('#Total_PriceHide').val(parseFloat(sumT));


   $('#Total_Discount').val(parseFloat(sumD));
   $('#Total_DiscountHide').val(parseFloat(sumD));

   $('#Total_Bf_Taxes').val(parseFloat(sumBF));
   $('#Total_Bf_TaxesHide').val(parseFloat(sumBF));

   $('#Total_Taxes').val(parseFloat(sumTax));
   $('#Total_TaxesHide').val(parseFloat(sumTax));


       if(rowctr == 0){
        document.getElementById("Submit").style.display = "none";

       }else{

        document.getElementById("Submit").style.display = "block";
       }

            var Pay =$('#Payment_Method').val();
        var Stat =$('#Status').val();
        var paid =$('#paid').val();

      if(Pay == 'Later' &&  Stat == 0 ){

             if(paid == 0 || paid < 0){
        document.getElementById("Submit").style.display = "none";
             }else{

           if(rowctr == 0){
        document.getElementById("Submit").style.display = "none";

       }else{

        document.getElementById("Submit").style.display = "block";
       }



             }

       }else{

       if(rowctr == 0){
        document.getElementById("Submit").style.display = "none";

       }else{

        document.getElementById("Submit").style.display = "block";
       }
       }


           });

        $('#data-dt').on('click', '#DelAssem', function(e){
                $(this).closest('tr').remove();


      $.fn.rowCount = function() {
     return $('tr', $(this).find('tbody')).length;
   };

   var rowctr = $('#dt').rowCount();

    var sumQ = 0;
   $('.Qun').each(function(){
   sumQ += parseFloat($(this).val());
   });

    var sumT = 0;
   $('.Tot').each(function(){
   sumT += parseFloat($(this).val());
   });

        var sumD = 0;
   $('.Disc').each(function(){
   sumD += parseFloat($(this).val());
   });


           var sumBF = 0;
   $('.TotalBFTax').each(function(){
   sumBF += parseFloat($(this).val());
   });

           var sumTax = 0;
   $('.TotalTax').each(function(){
   sumTax += parseFloat($(this).val());
   });


   $('#Product_Numbers').val(parseFloat(rowctr));
   $('#Product_NumbersHide').val(parseFloat(rowctr));

   $('#Total_Qty').val(parseFloat(sumQ));
   $('#Total_QtyHide').val(parseFloat(sumQ));

   $('#Total_Price').val(parseFloat(sumT));
   $('#Total_PriceHide').val(parseFloat(sumT));


       $('#Total_Discount').val(parseFloat(sumD));
   $('#Total_DiscountHide').val(parseFloat(sumD));

          $('#Total_Bf_Taxes').val(parseFloat(sumBF));
   $('#Total_Bf_TaxesHide').val(parseFloat(sumBF));

          $('#Total_Taxes').val(parseFloat(sumTax));
   $('#Total_TaxesHide').val(parseFloat(sumTax));


       if(rowctr == 0){
        document.getElementById("Submit").style.display = "none";

       }else{

        document.getElementById("Submit").style.display = "block";
       }

                  var Pay =$('#Payment_Method').val();
        var Stat =$('#Status').val();
        var paid =$('#paid').val();

      if(Pay == 'Later' &&  Stat == 0 ){

             if(paid == 0 || paid < 0){
        document.getElementById("Submit").style.display = "none";
             }else{

           if(rowctr == 0){
        document.getElementById("Submit").style.display = "none";

       }else{

        document.getElementById("Submit").style.display = "block";
       }



             }

       }else{

       if(rowctr == 0){
        document.getElementById("Submit").style.display = "none";

       }else{

        document.getElementById("Submit").style.display = "block";
       }
       }






                    })

</script>

@endpush
