@extends('admin.index')
@section('content')

    <title>

        {{trans('admin.Statistics_Graph')}}

    </title>


    <style>
        .panel.panel-locked:not(.panel-fullscreen) .panel-hdr h2:before{

            display: none !important;
        }
        .custom-control{
            display: none !important;
        }

        .GG{
            background: black;
            padding: 10px;
            color: white;
            margin: 5px;
            border-radius: 10%;
        }

        .table.table-striped:not(.table-bordered) th, .table.table-striped:not(.table-bordered) tbody th, .table.table-striped:not(.table-bordered) tbody td {

            border: 1px solid !important;
            padding: 4px;
            text-align: center;
        }


    </style>


    <main id="js-page-content" role="main" class="page-content">



        <script>
            /**
             *	This script should be placed right after the body tag for fast execution
             *	Note: the script is written in pure javascript and does not depend on thirdparty library
             **/
            'use strict';

            var classHolder = document.getElementsByTagName("BODY")[0],
                /**
                 * Load from localstorage
                 **/
                themeSettings = (localStorage.getItem('themeSettings')) ? JSON.parse(localStorage.getItem('themeSettings')) :
                    {},
                themeURL = themeSettings.themeURL || '',
                themeOptions = themeSettings.themeOptions || '';
            /**
             * Load theme options
             **/
            if (themeSettings.themeOptions)
            {
                classHolder.className = themeSettings.themeOptions;
                console.log("%c✔ Theme settings loaded", "color: #148f32");
            }
            else
            {
                console.log("%c✔ Heads up! Theme settings is empty or does not exist, loading default settings...", "color: #ed1c24");
            }
            if (themeSettings.themeURL && !document.getElementById('mytheme'))
            {
                var cssfile = document.createElement('link');
                cssfile.id = 'mytheme';
                cssfile.rel = 'stylesheet';
                cssfile.href = themeURL;
                document.getElementsByTagName('head')[0].appendChild(cssfile);

            }
            else if (themeSettings.themeURL && document.getElementById('mytheme'))
            {
                document.getElementById('mytheme').href = themeSettings.themeURL;
            }
            /**
             * Save to localstorage
             **/
            var saveSettings = function()
            {
                themeSettings.themeOptions = String(classHolder.className).split(/[^\w-]+/).filter(function(item)
                {
                    return /^(nav|header|footer|mod|display)-/i.test(item);
                }).join(' ');
                if (document.getElementById('mytheme'))
                {
                    themeSettings.themeURL = document.getElementById('mytheme').getAttribute("href");
                };
                localStorage.setItem('themeSettings', JSON.stringify(themeSettings));
            }
            /**
             * Reset settings
             **/
            var resetSettings = function()
            {
                localStorage.setItem("themeSettings", "");
            }

        </script>

        <div class="page-wrapper">
            <div class="page-inner">

                <div class="page-content-wrapper">

                    <main id="js-page-content" role="main" class="page-content">





                        <div class="row">

                            <!-- Sales Each Two Hours -->
                            <div class="col-lg-8">
                                <div id="panel-1" class="panel">
                                    <div class="panel-hdr">
                                        <h2 class="text-center">
                                            {{trans('admin.SalesHourly')}}
                                        </h2>
                                    </div>
                                    <div class="panel-container show">
                                        <div class="panel-content bg-subtlelight-fade">
                                            <div id="js-checkbox-toggles" class="d-flex mb-3" >
                                                <div class="custom-control custom-switch mr-2" >
                                                    <input type="checkbox" class="custom-control-input" name="gra-0" id="gra-0" checked="checked">
                                                    <label class="custom-control-label" for="gra-0" style="padding:inherit">{{trans('admin.pyramidal')}}</label>
                                                </div>
                                                <div class="custom-control custom-switch mr-2" style="display:none !important">
                                                    <input type="checkbox" class="custom-control-input" name="gra-1" id="gra-1" checked="checked">
                                                    <label class="custom-control-label" for="gra-1">Actual Profit</label>
                                                </div>
                                                <div class="custom-control custom-switch mr-2">
                                                    <input type="checkbox" class="custom-control-input" name="gra-2" id="gra-2" checked="checked">
                                                    <label class="custom-control-label" for="gra-2" style="padding:inherit">{{trans('admin.graph')}}</label>
                                                </div>
                                            </div>
                                            <div id="flot-toggles" class="w-100 mt-4" style="height: 300px"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Sales Order -->
                            <div class="col-xl-4">
                                <div id="panel-4" class="panel">
                                    <div class="panel-hdr">
                                        <h2>
                                            {{trans('admin.TotalSalesOrder')}} VS  {{trans('admin.TotalSalesOrderTranfered')}}
                                        </h2>

                                    </div>
                                    <div class="panel-container show">
                                        <div class="panel-content">

                                            <div id="splilneLine" style="width:100%; height:300px;"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <!-- Sales Each Two Hours -->
                            <div class="col-lg-8">
                                <div id="panel-1" class="panel">
                                    <div class="panel-hdr">
                                        <h2 class="text-center">
                                            {{trans('admin.SalesWeeklyHourly')}}
                                        </h2>
                                    </div>
                                    <div class="panel-container show">
                                        <div class="panel-content bg-subtlelight-fade">
                                            <div id="js-checkbox-toggles-weekly" class="d-flex mb-3" >
                                                <div class="custom-control custom-switch mr-2" >
                                                    <input type="checkbox" class="custom-control-input" name="gra-0" id="gra-0" checked="checked">
                                                    <label class="custom-control-label" for="gra-0" style="padding:inherit">{{trans('admin.pyramidal')}}</label>
                                                </div>
                                                <div class="custom-control custom-switch mr-2" style="display:none !important">
                                                    <input type="checkbox" class="custom-control-input" name="gra-1" id="gra-1" checked="checked">
                                                    <label class="custom-control-label" for="gra-1">Actual Profit</label>
                                                </div>
                                                <div class="custom-control custom-switch mr-2">
                                                    <input type="checkbox" class="custom-control-input" name="gra-2" id="gra-2" checked="checked">
                                                    <label class="custom-control-label" for="gra-2" style="padding:inherit">{{trans('admin.graph')}}</label>
                                                </div>
                                            </div>
                                            <div id="flot-toggles-weekly" class="w-100 mt-4" style="height: 300px"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Sales Order -->
                            <div class="col-xl-4">
                                <div id="panel-4" class="panel">
                                    <div class="panel-hdr">
                                        <h2>
                                            {{trans('admin.TotalSalesOrder')}} VS  {{trans('admin.TotalSalesOrderTranfered')}}
                                        </h2>

                                    </div>
                                    <div class="panel-container show">
                                        <div class="panel-content">

                                            <div id="splilneLineW" style="width:100%; height:300px;"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <!-- Sales Each Two Hours -->
                            <div class="col-lg-8">
                                <div id="panel-1" class="panel">
                                    <div class="panel-hdr">
                                        <h2 class="text-center">
                                            {{trans('admin.SalesMonthlyHourly')}}
                                        </h2>
                                    </div>
                                    <div class="panel-container show">
                                        <div class="panel-content bg-subtlelight-fade">
                                            <div id="js-checkbox-toggles-monthly" class="d-flex mb-3" >
                                                <div class="custom-control custom-switch mr-2" >
                                                    <input type="checkbox" class="custom-control-input" name="gra-0" id="gra-0" checked="checked">
                                                    <label class="custom-control-label" for="gra-0" style="padding:inherit">{{trans('admin.pyramidal')}}</label>
                                                </div>
                                                <div class="custom-control custom-switch mr-2" style="display:none !important">
                                                    <input type="checkbox" class="custom-control-input" name="gra-1" id="gra-1" checked="checked">
                                                    <label class="custom-control-label" for="gra-1">Actual Profit</label>
                                                </div>
                                                <div class="custom-control custom-switch mr-2">
                                                    <input type="checkbox" class="custom-control-input" name="gra-2" id="gra-2" checked="checked">
                                                    <label class="custom-control-label" for="gra-2" style="padding:inherit">{{trans('admin.graph')}}</label>
                                                </div>
                                            </div>
                                            <div id="flot-toggles-monthly" class="w-100 mt-4" style="height: 300px"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Customers -->
                            <div class="col-xl-4">
                                <div id="panel-4" class="panel">
                                    <div class="panel-hdr">
                                        <h2>
                                            {{trans('admin.NewCustomers')}}
                                        </h2>

                                    </div>
                                    <div class="panel-container show">
                                        <div class="panel-content">

                                            <div id="flot-line-alt" style="width:100%; height:300px;"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>



                            <!-- Sales Each Two Hours -->
                            <div class="col-lg-12">
                                <div id="panel-1" class="panel">
                                    <div class="panel-hdr">
                                        <h2 class="text-center">
                                            {{trans('admin.SalesYearlyHourly')}}
                                        </h2>
                                    </div>
                                    <div class="panel-container show">
                                        <div class="panel-content bg-subtlelight-fade">
                                            <div id="js-checkbox-toggles-yearly" class="d-flex mb-3" >
                                                <div class="custom-control custom-switch mr-2" >
                                                    <input type="checkbox" class="custom-control-input" name="gra-0" id="gra-0" checked="checked">
                                                    <label class="custom-control-label" for="gra-0" style="padding:inherit">{{trans('admin.pyramidal')}}</label>
                                                </div>
                                                <div class="custom-control custom-switch mr-2" style="display:none !important">
                                                    <input type="checkbox" class="custom-control-input" name="gra-1" id="gra-1" checked="checked">
                                                    <label class="custom-control-label" for="gra-1">Actual Profit</label>
                                                </div>
                                                <div class="custom-control custom-switch mr-2">
                                                    <input type="checkbox" class="custom-control-input" name="gra-2" id="gra-2" checked="checked">
                                                    <label class="custom-control-label" for="gra-2" style="padding:inherit">{{trans('admin.graph')}}</label>
                                                </div>
                                            </div>
                                            <div id="flot-toggles-yearly" class="w-100 mt-4" style="height: 300px"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>



                            <div class="col-lg-12">
                                <h1 class="text-center">{{trans('admin.MostSalesProducts')}}</h1>
                            </div>
                            <div class="col-lg-6">

                                <div class="st-wrapper" style="position: relative; width: 100%;">

                                    <table id="myTable" class="st-table table table-striped table-hover" style="width: 100%; opacity: 1;    background: #205952;color: #cd9b27;">
                                        <thead style="background: #cd9b27 ; color: #205952">
                                        <tr>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Name')}}</th>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Total_Qty')}}</th>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Total_Price')}}</th>

                                        </tr>
                                        </thead>
                                        <tbody>

                                        @foreach($topSellingProducts as $index => $product)
                                        <tr data-id="1">

                                            <td>{{ $product->product_name }}</td>
                                            <td>{{ number_format($product->total_quantity_sold, 0) }}</td>
                                            <td>{{ number_format($product->total_revenue, 2) }}</td>

                                        </tr>
                                        @endforeach

                                        </tbody>
                                    </table>

                                </div>
                            </div>

                            <div class="col-xl-6">

                                <!-- Pie Chart -->
                                <div id="panel-4" class="panel">
                                    <div class="panel-hdr">
                                        <h2>
                                            {{trans('admin.MostSalesProducts')}}
                                        </h2>

                                    </div>
                                    <div class="panel-container show">
                                        <div class="panel-content">
                                            <div id="pieChart">
                                                <canvas style="width:100%; height:300px;"></canvas>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="col-lg-6">
<h2>{{trans('admin.Monthly')}}</h2>
                                <div class="st-wrapper" style="position: relative; width: 100%;">

                                    <table id="myTable" class="st-table table table-striped table-hover" style="width: 100%; opacity: 1;    background: #205952;color: #cd9b27;">
                                        <thead style="background: #cd9b27 ; color: #205952">
                                        <tr>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Name')}}</th>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Total_Qty')}}</th>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Total_Price')}}</th>

                                        </tr>
                                        </thead>
                                        <tbody>

                                        @foreach($topSellingProductsMonthly as  $productM)
                                        <tr data-id="1">

                                            <td>{{ $productM->product_name }}</td>
                                            <td>{{ number_format($productM->total_quantity_sold, 0) }}</td>
                                            <td>{{ number_format($productM->total_revenue, 2) }}</td>

                                        </tr>
                                        @endforeach

                                        </tbody>
                                    </table>

                                </div>
                            </div>

                            <div class="col-xl-6">

                                <!-- Pie Chart -->
                                <div id="panel-4" class="panel">
                                    <div class="panel-hdr">
                                        <h2>
                                            {{trans('admin.MostSalesProducts')}} ({{trans('admin.Monthly')}})
                                        </h2>

                                    </div>
                                    <div class="panel-container show">
                                        <div class="panel-content">
                                            <div id="pieChartM">
                                                <canvas style="width:100%; height:300px;"></canvas>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>






                            <!-- Customers -->

                            <div class="col-lg-12">
                                <h1>{{trans('admin.MostSalesClients')}}</h1>
                            </div>

                            <div class="col-xl-6">
                                <div id="panel-6" class="panel">
                                    <div class="panel-hdr">
                                        <div class="panel-toolbar">
                                            <button class="btn btn-panel" data-action="panel-collapse" data-toggle="tooltip" data-offset="0,10" data-original-title="Collapse"></button>
                                            <button class="btn btn-panel" data-action="panel-fullscreen" data-toggle="tooltip" data-offset="0,10" data-original-title="Fullscreen"></button>
                                            <button class="btn btn-panel" data-action="panel-close" data-toggle="tooltip" data-offset="0,10" data-original-title="Close"></button>
                                        </div>
                                    </div>
                                    <div class="panel-container show">
                                        <div class="panel-content">

                                            <div id="barChart" style="width:100%; height:300px;"></div>

                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-6">

                                <div class="st-wrapper" style="position: relative; width: 100%;">

                                    <table id="myTable" class="st-table table table-striped table-hover" style="width: 100%; opacity: 1;    background: #205952;color: #cd9b27;">
                                        <thead style="background: #cd9b27 ; color: #205952">
                                        <tr>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Name')}}</th>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Total_Qty')}}</th>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Total_Price')}}</th>

                                        </tr>
                                        </thead>
                                        <tbody>

                                        @foreach($topSellingCustomers as  $topCust)
                                            <tr data-id="1">

                                                <td>{{ $topCust->customer_name }}</td>
                                                <td>{{ number_format($topCust->total_sales_count, 0) }}</td>
                                                <td>{{ number_format($topCust->total_revenue, 2) }}</td>

                                            </tr>

                                        @endforeach

                                        </tbody>
                                    </table>

                                </div>
                            </div>

                            <div class="col-lg-12">
                                <h1>{{trans('admin.MostSalesClients')}}  ({{trans('admin.Monthly')}})</h1>
                            </div>

                            <div class="col-xl-6">
                                <div id="panel-6" class="panel">
                                    <div class="panel-hdr">

                                    </div>
                                    <div class="panel-container show">
                                        <div class="panel-content">

                                            <div id="barChartM" style="width:100%; height:300px;"></div>

                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-6">

                                <div class="st-wrapper" style="position: relative; width: 100%;">

                                    <table id="myTable" class="st-table table table-striped table-hover" style="width: 100%; opacity: 1;    background: #205952;color: #cd9b27;">
                                        <thead style="background: #cd9b27 ; color: #205952">
                                        <tr>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Name')}}</th>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Total_Qty')}}</th>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Total_Price')}}</th>

                                        </tr>
                                        </thead>
                                        <tbody>

                                        @foreach($topSellingCustomersM as  $topCustM)
                                            <tr data-id="1">

                                                <td>{{ $topCustM->customer_name }}</td>
                                                <td>{{ number_format($topCustM->total_sales_count, 0) }}</td>
                                                <td>{{ number_format($topCustM->total_revenue, 2) }}</td>

                                            </tr>

                                        @endforeach

                                        </tbody>
                                    </table>

                                </div>
                            </div>




                            <div class="col-lg-12">
                                <h1>{{trans('admin.MostSalesDelegate')}}  </h1>
                            </div>


                            <div class="col-lg-6">

                                <div class="st-wrapper" style="position: relative; width: 100%;">

                                    <table id="myTable" class="st-table table table-striped table-hover" style="width: 100%; opacity: 1;    background: #205952;color: #cd9b27;">
                                        <thead style="background: #cd9b27 ; color: #205952">
                                        <tr>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Name')}}</th>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Total_Qty')}}</th>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Total_Price')}}</th>

                                        </tr>
                                        </thead>
                                        <tbody>

                                        @foreach($topSellingDelegate as  $topDele)
                                            <tr data-id="1">

                                                <td>{{ $topDele->emp_name }}</td>
                                                <td>{{ number_format($topDele->total_sales_count, 0) }}</td>
                                                <td>{{ number_format($topDele->total_revenue, 2) }}</td>

                                            </tr>

                                        @endforeach

                                        </tbody>
                                    </table>

                                </div>
                            </div>

                            <div class="col-lg-6">
                            <div id="panel-20" class="panel">
                                <div class="panel-hdr">

                                </div>
                                <div class="panel-container show">
                                    <div class="panel-content">
                                        <div id="distributedSeries" class="ct-chart" style="width:100%; height:300px;"></div>
                                    </div>
                                </div>
                            </div>
                            </div>>



                            <div class="col-lg-12">
                                <h1>{{trans('admin.MostSalesDelegate')}}  ({{trans('admin.Monthly')}})</h1>
                            </div>

                            <div class="col-lg-6">

                                <div class="st-wrapper" style="position: relative; width: 100%;">

                                    <table id="myTable" class="st-table table table-striped table-hover" style="width: 100%; opacity: 1;    background: #205952;color: #cd9b27;">
                                        <thead style="background: #cd9b27 ; color: #205952">
                                        <tr>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Name')}}</th>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Total_Qty')}}</th>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Total_Price')}}</th>

                                        </tr>
                                        </thead>
                                        <tbody>

                                        @foreach($topSellingDelegateM as  $topDeleM)
                                            <tr data-id="1">

                                                <td>{{ $topDeleM->emp_name }}</td>
                                                <td>{{ number_format($topDeleM->total_sales_count, 0) }}</td>
                                                <td>{{ number_format($topDeleM->total_revenue, 2) }}</td>

                                            </tr>

                                        @endforeach

                                        </tbody>
                                    </table>

                                </div>
                            </div>

                            <div class="col-lg-6">
                                <div id="panel-20" class="panel">
                                    <div class="panel-hdr">

                                    </div>
                                    <div class="panel-container show">
                                        <div class="panel-content">
                                            <div id="distributedSeriesM" class="ct-chart" style="width:100%; height:300px;"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>>




                            <div class="col-lg-12">
                                <h1>{{trans('admin.MostSalesStores')}} </h1>
                            </div>

                            <div class="col-lg-6">

                                <div class="st-wrapper" style="position: relative; width: 100%;">

                                    <table id="myTable" class="st-table table table-striped table-hover" style="width: 100%; opacity: 1;    background: #205952;color: #cd9b27;">
                                        <thead style="background: #cd9b27 ; color: #205952">
                                        <tr>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Name')}}</th>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Total_Qty')}}</th>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Total_Price')}}</th>

                                        </tr>
                                        </thead>
                                        <tbody>

                                        @foreach($topSellingStores as  $topStore)
                                            <tr data-id="1">

                                                <td>{{ $topStore->store_name }}</td>
                                                <td>{{ number_format($topStore->total_sales_count, 0) }}</td>
                                                <td>{{ number_format($topStore->total_revenue, 2) }}</td>

                                            </tr>

                                        @endforeach

                                        </tbody>
                                    </table>

                                </div>
                            </div>


                            <div class="col-lg-6">
                            <div id="panel-22" class="panel">

                                <div class="panel-container show">
                                    <div class="panel-content">
                                        <div id="gaugeChartFill" class="ct-chart" style="width:100%; height:300px;"></div>
                                    </div>
                                </div>
                            </div>
                            </div>

                            <div class="col-lg-12">
                                <h1>{{trans('admin.MostSalesStores')}}  ({{trans('admin.Monthly')}})</h1>
                            </div>

                            <div class="col-lg-6">

                                <div class="st-wrapper" style="position: relative; width: 100%;">

                                    <table id="myTable" class="st-table table table-striped table-hover" style="width: 100%; opacity: 1;    background: #205952;color: #cd9b27;">
                                        <thead style="background: #cd9b27 ; color: #205952">
                                        <tr>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Name')}}</th>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Total_Qty')}}</th>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Total_Price')}}</th>

                                        </tr>
                                        </thead>
                                        <tbody>

                                        @foreach($topSellingStoresM as  $topStoreM)
                                            <tr data-id="1">

                                                <td>{{ $topStoreM->store_name }}</td>
                                                <td>{{ number_format($topStoreM->total_sales_count, 0) }}</td>
                                                <td>{{ number_format($topStoreM->total_revenue, 2) }}</td>

                                            </tr>

                                        @endforeach

                                        </tbody>
                                    </table>

                                </div>
                            </div>

                            <div class="col-lg-6">
                            <div id="panel-22" class="panel">

                                <div class="panel-container show">
                                    <div class="panel-content">
                                        <div id="gaugeChartFillM" class="ct-chart" style="width:100%; height:300px;"></div>
                                    </div>
                                </div>
                            </div>
                            </div>








                            <div class="col-lg-12">
                                <h1>{{trans('admin.MostPurchasesProduct')}}  </h1>
                            </div>

                            <div class="col-lg-6">

                                <div class="st-wrapper" style="position: relative; width: 100%;">

                                    <table id="myTable" class="st-table table table-striped table-hover" style="width: 100%; opacity: 1;    background: #205952;color: #cd9b27;">
                                        <thead style="background: #cd9b27 ; color: #205952">
                                        <tr>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Name')}}</th>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Total_Qty')}}</th>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Total_Price')}}</th>

                                        </tr>
                                        </thead>
                                        <tbody>

                                        @foreach($topPurchProducts as  $topPurch)
                                            <tr data-id="1">

                                                <td>{{ $topPurch->product_name }}</td>
                                                <td>{{ number_format($topPurch->total_quantity_sold, 0) }}</td>
                                                <td>{{ number_format($topPurch->total_revenue, 2) }}</td>

                                            </tr>

                                        @endforeach

                                        </tbody>
                                    </table>

                                </div>
                            </div>


                            <div class="col-lg-6">
                            <div id="panel-21" class="panel">
                                <div class="panel-container show">
                                    <div class="panel-content">
                                        <div id="donutFill" class="ct-chart" style="width:100%; height:300px;"></div>
                                    </div>
                                </div>
                            </div>
                            </div>






                            <div class="col-lg-12">
                                <h1>{{trans('admin.AppsSales')}}  </h1>
                            </div>


                            <div class="col-lg-6">

                                <div class="st-wrapper" style="position: relative; width: 100%;">

                                    <table id="myTable" class="st-table table table-striped table-hover" style="width: 100%; opacity: 1;    background: #205952;color: #cd9b27;">
                                        <thead style="background: #cd9b27 ; color: #205952">
                                        <tr>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Name')}}</th>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Total_Price')}}</th>

                                        </tr>
                                        </thead>
                                        <tbody>

                                        @foreach($AppSales as  $app)
                                            <tr data-id="1">

                                                <td>{{ $app->app_name }}</td>
                                                <td>{{ number_format($app->total_revenue, 2) }}</td>

                                            </tr>

                                        @endforeach

                                        </tbody>
                                    </table>

                                </div>
                            </div>


                            <div class="col-xl-6">
                                <div id="panel-10" class="panel">
                                    <div class="panel-container show">
                                        <div class="panel-content">
                                            <div id="donutChart" style="width:100%; height:300px;"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>




                            <!--  Less -->

                            <div class="col-lg-6">
                                <h1>{{trans('admin.LessSalesProducts')}}</h1>
                                <div class="st-wrapper" style="position: relative; width: 100%;">

                                    <table id="myTable" class="st-table table table-striped table-hover" style="width: 100%; opacity: 1;    background: #205952;color: #cd9b27;">
                                        <thead style="background: #cd9b27 ; color: #205952">
                                        <tr>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Name')}}</th>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Total_Qty')}}</th>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Total_Price')}}</th>

                                        </tr>
                                        </thead>
                                        <tbody>

                                        @foreach($lessSalesProducts as  $Lessproduct)
                                            <tr data-id="1">

                                                <td>{{ $Lessproduct->product_name }}</td>
                                                <td>{{ number_format($Lessproduct->total_quantity_sold, 0) }}</td>
                                                <td>{{ number_format($Lessproduct->total_revenue, 2) }}</td>

                                            </tr>
                                        @endforeach

                                        </tbody>
                                    </table>

                                </div>
                            </div>

                            <div class="col-lg-6">
                                <h1>{{trans('admin.LessPurchProducts')}}</h1>
                                <div class="st-wrapper" style="position: relative; width: 100%;">

                                    <table id="myTable" class="st-table table table-striped table-hover" style="width: 100%; opacity: 1;    background: #205952;color: #cd9b27;">
                                        <thead style="background: #cd9b27 ; color: #205952">
                                        <tr>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Name')}}</th>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Total_Qty')}}</th>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Total_Price')}}</th>

                                        </tr>
                                        </thead>
                                        <tbody>

                                        @foreach($LessPurchProducts as  $Lessproduct)
                                            <tr data-id="1">

                                                <td>{{ $Lessproduct->product_name }}</td>
                                                <td>{{ number_format($Lessproduct->total_quantity_sold, 0) }}</td>
                                                <td>{{ number_format($Lessproduct->total_revenue, 2) }}</td>

                                            </tr>
                                        @endforeach

                                        </tbody>
                                    </table>

                                </div>
                            </div>

                            <div class="col-lg-6">
                                <h1>{{trans('admin.LessSalesClient')}}</h1>
                                <div class="st-wrapper" style="position: relative; width: 100%;">

                                    <table id="myTable" class="st-table table table-striped table-hover" style="width: 100%; opacity: 1;    background: #205952;color: #cd9b27;">
                                        <thead style="background: #cd9b27 ; color: #205952">
                                        <tr>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Name')}}</th>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Total_Qty')}}</th>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Total_Price')}}</th>

                                        </tr>
                                        </thead>
                                        <tbody>

                                        @foreach($LessSellingCustomers as  $LessCust)
                                            <tr data-id="1">

                                                <td>{{ $LessCust->customer_name }}</td>
                                                <td>{{ number_format($LessCust->total_sales_count, 0) }}</td>
                                                <td>{{ number_format($LessCust->total_revenue, 2) }}</td>

                                            </tr>
                                        @endforeach

                                        </tbody>
                                    </table>

                                </div>
                            </div>

                            <div class="col-lg-6">
                                <h1>{{trans('admin.LessSalesDelegate')}}</h1>
                                <div class="st-wrapper" style="position: relative; width: 100%;">

                                    <table id="myTable" class="st-table table table-striped table-hover" style="width: 100%; opacity: 1;    background: #205952;color: #cd9b27;">
                                        <thead style="background: #cd9b27 ; color: #205952">
                                        <tr>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Name')}}</th>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Total_Qty')}}</th>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Total_Price')}}</th>

                                        </tr>
                                        </thead>
                                        <tbody>

                                        @foreach($LessSellingDelegate as  $LessDele)
                                            <tr data-id="1">

                                                <td>{{ $LessDele->emp_name }}</td>
                                                <td>{{ number_format($LessDele->total_sales_count, 0) }}</td>
                                                <td>{{ number_format($LessDele->total_revenue, 2) }}</td>

                                            </tr>
                                        @endforeach

                                        </tbody>
                                    </table>

                                </div>
                            </div>

                            <div class="col-lg-6">
                                <h1>{{trans('admin.LessSalesStores')}}</h1>
                                <div class="st-wrapper" style="position: relative; width: 100%;">

                                    <table id="myTable" class="st-table table table-striped table-hover" style="width: 100%; opacity: 1;    background: #205952;color: #cd9b27;">
                                        <thead style="background: #cd9b27 ; color: #205952">
                                        <tr>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Name')}}</th>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Total_Qty')}}</th>
                                            <th class="st-sort-neutral" style="cursor: pointer;">{{trans('admin.Total_Price')}}</th>

                                        </tr>
                                        </thead>
                                        <tbody>

                                        @foreach($LessSellingStores as  $LessStore)
                                            <tr data-id="1">

                                                <td>{{ $LessStore->store_name }}</td>
                                                <td>{{ number_format($LessStore->total_sales_count, 0) }}</td>
                                                <td>{{ number_format($LessStore->total_revenue, 2) }}</td>

                                            </tr>
                                        @endforeach

                                        </tbody>
                                    </table>

                                </div>
                            </div>



                        </div>


                    </main>

                </div>
            </div>
        </div>





    </main>

    <input type="hidden" id="toggleOneName1" value="{{trans('admin.pyramidal')}}">
    <input type="hidden" id="toggleOneName2" value="{{trans('admin.graph')}}">




    @foreach($formattedSales as $sale)

    <input type="hidden" name="TimeName2Hours[]" value="{{ $sale['time_interval'] }}">
    <input type="hidden" name="TotalSales2Hours[]" value="{{ $sale['total_sales'] }}">

    @endforeach

    @foreach($WeeklyHours as $Wsale)

    <input type="hidden" name="WeeklyTimeName2Hours[]" value="{{ $Wsale['time_interval'] }}">
    <input type="hidden" name="WeeklyTotalSales2Hours[]" value="{{ $Wsale['total_sales'] }}">

    @endforeach


    @foreach($MonthlyHours as $Msale)

    <input type="hidden" name="MonthlyTimeName2Hours[]" value="{{ $Msale['time_interval'] }}">
    <input type="hidden" name="MonthlyTotalSales2Hours[]" value="{{ $Msale['total_sales'] }}">

    @endforeach


    @foreach($YearlyHours as $Ysale)

    <input type="hidden" name="YearlyTimeName2Hours[]" value="{{ $Ysale['time_interval'] }}">
    <input type="hidden" name="YearlyTotalSales2Hours[]" value="{{ $Ysale['total_sales'] }}">

    @endforeach


    @foreach($topSellingProducts as $product)

    <input type="hidden" name="MostProductName[]" value="{{ $product->product_name }}">
    <input type="hidden" name="MostProductQty[]" value="{{ $product->total_quantity_sold }}">

    @endforeach


    @foreach($topSellingProductsMonthly as $productM)

    <input type="hidden" name="MostProductNameM[]" value="{{ $productM->product_name }}">
    <input type="hidden" name="MostProductQtyM[]" value="{{ $productM->total_quantity_sold }}">

    @endforeach


    @foreach($topSellingCustomers as $topSellCut)

    <input type="hidden" name="MostCustomerName[]" value="{{ $topSellCut->customer_name }}">
    <input type="hidden" name="MostCustomerQty[]" value="{{ $topSellCut->total_sales_count }}">

    @endforeach


    @foreach($topSellingCustomersM as $topSellCutM)

    <input type="hidden" name="MostCustomerNameM[]" value="{{ $topSellCutM->customer_name }}">
    <input type="hidden" name="MostCustomerQtyM[]" value="{{ $topSellCutM->total_sales_count }}">

    @endforeach


    @foreach($topSellingDelegate as $topSellDele)

        <input type="hidden" name="MostDelegateName[]" value="{{ $topSellDele->emp_name }}">
        <input type="hidden" name="MostDelegateQty[]" value="{{ $topSellDele->total_sales_count }}">

    @endforeach


    @foreach($topSellingDelegateM as $topSellDeleM)

        <input type="hidden" name="MostDelegateNameM[]" value="{{ $topSellDeleM->emp_name }}">
        <input type="hidden" name="MostDelegateQtyM[]" value="{{ $topSellDeleM->total_sales_count }}">

    @endforeach






    @foreach($topSellingStores as $topSellStore)

        <input type="hidden" name="MostStoreName[]" value="{{ $topSellStore->store_name }}">
        <input type="hidden" name="MostStoreQty[]" value="{{ $topSellStore->total_sales_count }}">

    @endforeach


    @foreach($topSellingStoresM as $topSellStoreM)

        <input type="hidden" name="MostStoreNameM[]" value="{{ $topSellStoreM->store_name }}">
        <input type="hidden" name="MostStoreQtyM[]" value="{{ $topSellStoreM->total_sales_count }}">

    @endforeach


    @foreach($topPurchProducts as $topPurch)

        <input type="hidden" name="MostPurchName[]" value="{{ $topPurch->product_name }}">
        <input type="hidden" name="MostPurchQty[]" value="{{ $topPurch->total_quantity_sold }}">

    @endforeach


    @foreach($AppSales as $app)

        <input type="hidden" name="AppName[]" value="{{ $app->app_name }}">
        <input type="hidden" name="AppTotal[]" value="{{ $app->total_revenue }}">

    @endforeach








    <input type="hidden" id="TotSOJan" value="{{$TotSOJan}}">
    <input type="hidden" id="TotSOFeb" value="{{$TotSOFeb}}">
    <input type="hidden" id="TotSOMar" value="{{$TotSOMar}}">
    <input type="hidden" id="TotSOApr" value="{{$TotSOApr}}">
    <input type="hidden" id="TotSOMay" value="{{$TotSOMay}}">
    <input type="hidden" id="TotSOJune" value="{{$TotSOJune}}">
    <input type="hidden" id="TotSOJul" value="{{$TotSOJul}}">
    <input type="hidden" id="TotSOAug" value="{{$TotSOAug}}">
    <input type="hidden" id="TotSOSep" value="{{$TotSOSep}}">
    <input type="hidden" id="TotSOOct" value="{{$TotSOOct}}">
    <input type="hidden" id="TotSONov" value="{{$TotSONov}}">
    <input type="hidden" id="TotSODec" value="{{$TotSODec}}">

    <input type="hidden" id="TotSOJanT" value="{{$TotSOJanT}}">
    <input type="hidden" id="TotSOFebT" value="{{$TotSOFebT}}">
    <input type="hidden" id="TotSOMarT" value="{{$TotSOMarT}}">
    <input type="hidden" id="TotSOAprT" value="{{$TotSOAprT}}">
    <input type="hidden" id="TotSOMayT" value="{{$TotSOMayT}}">
    <input type="hidden" id="TotSOJuneT" value="{{$TotSOJuneT}}">
    <input type="hidden" id="TotSOJulT" value="{{$TotSOJulT}}">
    <input type="hidden" id="TotSOAugT" value="{{$TotSOAugT}}">
    <input type="hidden" id="TotSOSepT" value="{{$TotSOSepT}}">
    <input type="hidden" id="TotSOOctT" value="{{$TotSOOctT}}">
    <input type="hidden" id="TotSONovT" value="{{$TotSONovT}}">
    <input type="hidden" id="TotSODecT" value="{{$TotSODecT}}">

    <input type="hidden" id="TotSOSat" value="{{$TotSOSat}}">
    <input type="hidden" id="TotSOSun" value="{{$TotSOSun}}">
    <input type="hidden" id="TotSOSMon" value="{{$TotSOSMon}}">
    <input type="hidden" id="TotSOTue" value="{{$TotSOTue}}">
    <input type="hidden" id="TotSOWed" value="{{$TotSOWed}}">
    <input type="hidden" id="TotSOThu" value="{{$TotSOThu}}">
    <input type="hidden" id="TotSOFri" value="{{$TotSOFri}}">
    <input type="hidden" id="TotSOSatT" value="{{$TotSOSatT}}">
    <input type="hidden" id="TotSOSunT" value="{{$TotSOSunT}}">
    <input type="hidden" id="TotSOSMonT" value="{{$TotSOSMonT}}">
    <input type="hidden" id="TotSOTueT" value="{{$TotSOTueT}}">
    <input type="hidden" id="TotSOWedT" value="{{$TotSOWedT}}">
    <input type="hidden" id="TotSOThuT" value="{{$TotSOThuT}}">
    <input type="hidden" id="TotSOFriT" value="{{$TotSOFriT}}">


    <input type="hidden" id="currentWeekCustomers" value="{{$currentWeekCustomers}}">
    <input type="hidden" id="currentMonthCustomers" value="{{$currentMonthCustomers}}">
    <input type="hidden" id="currentYearCustomers" value="{{$currentYearCustomers}}">


@endsection
@push('js')


    <script src="{{asset('Admin/js/vendors.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/app.bundle.js')}}"></script>
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/statistics/chartjs/chartjs.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/statistics/chartist/chartist.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/statistics/c3/c3.css')}}">


    <!-- The order of scripts is irrelevant. Please check out the plugin pages for more details about these plugins below: -->
    <script src="{{asset('Admin/js/statistics/peity/peity.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/statistics/flot/flot.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/statistics/easypiechart/easypiechart.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/statistics/chartjs/chartjs.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/statistics/chartist/chartist.js')}}"></script>
    <script src="{{asset('Admin/js/statistics/d3/d3.js')}}"></script>
    <script src="{{asset('Admin/js/statistics/c3/c3.js')}}"></script>
    <script src="{{asset('Admin/js/statistics/demo-data/demo-c3.js')}}"></script>




    <!-- Sales All Two Hours  -->
    <script>
        /* data of sales */


        var names = $("input[name='TimeName2Hours[]']")
            .map(function(){return $(this).val();}).get();


        var values = $("input[name='TotalSales2Hours[]']")
            .map(function(){return $(this).val();}).get();




        var One=values[0];
        var Two=values[1];
        var Three=values[2];
        var Four=values[3];
        var Five=values[4];
        var Six=values[5];
        var Seven=values[6];
        var Eight=values[7];
        var Nine=values[8];
        var Ten=values[9];
        var Eleven=values[10];
        var Tweleve=values[11];



        var dataTargetProfit = [
            [1354586000000, One],
            [1364587000000, Two],
            [1374588000000, Three],
            [1384589000000, Four],
            [1394590000000, Five],
            [1404591000000, Six],
            [1414592000000, Seven],
            [1424593000000, Eight],
            [1434594000000, Nine],
            [1444595000000, Ten],
            [1454596000000, Eleven],
            [1464596000000, Tweleve]

        ]

        var dataProfit = [
            [1354587000000, 900],
            [1364587000000, 65],
            [1374588000000, 98],
            [1384589000000, 83],
            [1394590000000, 980],
            [1404591000000, 808],
            [1414592000000, 720],
            [1424593000000, 674],
            [1434594000000, 23],
            [1444595000000, 79],
            [1454596000000, 88],
            [1464596000000, 30]

        ]

        var dataSignups = [
            [1354586000000, One],
            [1364587000000, Two],
            [1374588000000, Three],
            [1384589000000, Four],
            [1394590000000, Five],
            [1404591000000, Six],
            [1414592000000, Seven],
            [1424593000000, Eight],
            [1434594000000, Nine],
            [1444595000000, Ten],
            [1454596000000, Eleven],
            [1464596000000, Tweleve]
        ]


        var pyrmid=$('#toggleOneName1').val();
        var graph=$('#toggleOneName2').val();
        $(document).ready(function()
        {
            /* f Sales Monthly*/
            var flot_toggle = function()
            {

                var data = [
                    {
                        label: pyrmid,
                        data: dataTargetProfit,
                        color: 'darkgreen',
                        bars:
                            {
                                show: true,
                                align: "center",
                                barWidth: 30 * 30 * 60 * 1000 * 80,
                                lineWidth: 0,
                                fillColor:
                                    {
                                        colors: [
                                            {
                                                opacity: 0.9
                                            },
                                            {
                                                opacity: 0.1
                                            }]
                                    }
                            },
                        lines:
                            {
                                show: true,
                                lineWidth: 2
                            },
                        highlightColor: 'rgba(255,255,255,0.3)',
                        shadowSize: 0
                    },
                    {
                        label: '',
                        data: dataProfit,
                        color: "darkblue",
                        lines:
                            {
                                show: false,
                                lineWidth: 2
                            },
                        shadowSize: 0,
                        points:
                            {
                                show: false
                            }
                    },
                    {
                        label:graph,
                        data: dataSignups,
                        color: "darkblue",
                        lines:
                            {
                                show: true,
                                lineWidth: 2
                            },
                        shadowSize: 0,
                        points:
                            {
                                show: true
                            }
                    }]

                var options = {
                    grid:
                        {
                            hoverable: true,
                            clickable: true,
                            tickColor: 'rgba(0,0,0,0.05)',
                            borderWidth: 1,
                            borderColor: 'rgba(0,0,0,0.05)'
                        },
                    tooltip: {
                        show: true,
                        content: "Total: %y"
                    },
                    tooltipOpts:
                        {
                            cssClass: 'tooltip-inner',
                            defaultTheme: false
                        },
                    xaxis:
                        {
                            mode: "times",
                            tickLength: 0,
                            ticks: [
                                [1354586000000, names[0]],
                                [1364587000000, names[1]],
                                [1374588000000, names[2]],
                                [1384589000000, names[3]],
                                [1394590000000, names[4]],
                                [1404591000000, names[5]],
                                [1414592000000, names[6]],
                                [1424593000000, names[7]],
                                [1434594000000, names[8]],
                                [1444595000000, names[9]],
                                [1454596000000, names[10]],
                                [1464596000000, names[11]],
                            ]

                        },
                    yaxes:
                        {


                            tickColor: 'rgba(0,0,0,0.05)'

                        }

                };

                var plot2 = null;

                function plotNow()
                {
                    var d = [];
                    $("#js-checkbox-toggles").find(':checkbox').each(function()
                    {
                        if ($(this).is(':checked'))
                        {
                            d.push(data[$(this).attr("name").substr(4, 1)]);
                        }
                    });
                    if (d.length > 0)
                    {
                        if (plot2)
                        {
                            plot2.setData(d);
                            plot2.draw();
                        }
                        else
                        {
                            plot2 = $.plot($("#flot-toggles"), d, options);
                        }
                    }

                };

                $("#js-checkbox-toggles").find(':checkbox').on('change', function()
                {
                    plotNow();
                });
                plotNow()
            }
            flot_toggle();
            /*  Sales Monthly-- end*/


            /* ========================================= */


        });

    </script>

    <!-- Sales Weekly Two Hours  -->
    <script>


        var namesW = $("input[name='WeeklyTimeName2Hours[]']")
            .map(function(){return $(this).val();}).get();


        var valuesW = $("input[name='WeeklyTotalSales2Hours[]']")
            .map(function(){return $(this).val();}).get();





        var One=valuesW[0];
        var Two=valuesW[1];
        var Three=valuesW[2];
        var Four=valuesW[3];
        var Five=valuesW[4];
        var Six=valuesW[5];
        var Seven=valuesW[6];
        var Eight=valuesW[7];
        var Nine=valuesW[8];
        var Ten=valuesW[9];
        var Eleven=valuesW[10];
        var Tweleve=valuesW[11];



        var dataTargetProfitW = [
            [1354586000000, One],
            [1364587000000, Two],
            [1374588000000, Three],
            [1384589000000, Four],
            [1394590000000, Five],
            [1404591000000, Six],
            [1414592000000, Seven],
            [1424593000000, Eight],
            [1434594000000, Nine],
            [1444595000000, Ten],
            [1454596000000, Eleven],
            [1464596000000, Tweleve]

        ]

        var dataProfitW = [
            [1354587000000, 900],
            [1364587000000, 65],
            [1374588000000, 98],
            [1384589000000, 83],
            [1394590000000, 980],
            [1404591000000, 808],
            [1414592000000, 720],
            [1424593000000, 674],
            [1434594000000, 23],
            [1444595000000, 79],
            [1454596000000, 88],
            [1464596000000, 30],

        ]

        var dataSignupsW = [
            [1354586000000, One],
            [1364587000000, Two],
            [1374588000000, Three],
            [1384589000000, Four],
            [1394590000000, Five],
            [1404591000000, Six],
            [1414592000000, Seven],
            [1424593000000, Eight],
            [1434594000000, Nine],
            [1444595000000, Ten],
            [1454596000000, Eleven],
            [1464596000000, Tweleve]
        ]


        var pyrmid=$('#toggleOneName1').val();
        var graph=$('#toggleOneName2').val();
        $(document).ready(function()
        {
            /* f Sales Monthly*/
            var flot_toggle_weekly = function()
            {

                var data = [
                    {
                        label: pyrmid,
                        data: dataTargetProfitW,
                        color: 'darkred',
                        bars:
                            {
                                show: true,
                                align: "center",
                                barWidth: 30 * 30 * 60 * 1000 * 80,
                                lineWidth: 0,
                                fillColor:
                                    {
                                        colors: [
                                            {
                                                opacity: 0.9
                                            },
                                            {
                                                opacity: 0.1
                                            }]
                                    }
                            },
                        lines:
                            {
                                show: true,
                                lineWidth: 2
                            },
                        highlightColor: 'rgba(255,255,255,0.3)',
                        shadowSize: 0
                    },
                    {
                        label: '',
                        data: dataProfitW,
                        color: "gold",
                        lines:
                            {
                                show: false,
                                lineWidth: 2
                            },
                        shadowSize: 0,
                        points:
                            {
                                show: false
                            }
                    },
                    {
                        label:graph,
                        data: dataSignupsW,
                        color: "gold",
                        lines:
                            {
                                show: true,
                                lineWidth: 2
                            },
                        shadowSize: 0,
                        points:
                            {
                                show: true
                            }
                    }]

                var options = {
                    grid:
                        {
                            hoverable: true,
                            clickable: true,
                            tickColor: 'rgba(0,0,0,0.05)',
                            borderWidth: 1,
                            borderColor: 'rgba(0,0,0,0.05)'
                        },
                    tooltip: {
                        show: true,
                        content: "Total: %y"
                    },
                    tooltipOpts:
                        {
                            cssClass: 'tooltip-inner',
                            defaultTheme: false
                        },
                    xaxis:
                        {
                            mode: "times",
                            tickLength: 0,
                            ticks: [
                                [1354586000000, namesW[0]],
                                [1364587000000, namesW[1]],
                                [1374588000000, namesW[2]],
                                [1384589000000, namesW[3]],
                                [1394590000000, namesW[4]],
                                [1404591000000, namesW[5]],
                                [1414592000000, namesW[6]],
                                [1424593000000, namesW[7]],
                                [1434594000000, namesW[8]],
                                [1444595000000, namesW[9]],
                                [1454596000000, namesW[10]],
                                [1464596000000, namesW[11]],
                            ]

                        },
                    yaxes:
                        {


                            tickColor: 'rgba(0,0,0,0.05)'

                        }

                };

                var plot2 = null;

                function plotNow()
                {
                    var d = [];
                    $("#js-checkbox-toggles-weekly").find(':checkbox').each(function()
                    {
                        if ($(this).is(':checked'))
                        {
                            d.push(data[$(this).attr("name").substr(4, 1)]);
                        }
                    });
                    if (d.length > 0)
                    {
                        if (plot2)
                        {
                            plot2.setData(d);
                            plot2.draw();
                        }
                        else
                        {
                            plot2 = $.plot($("#flot-toggles-weekly"), d, options);
                        }
                    }

                };

                $("#js-checkbox-toggles-weekly").find(':checkbox').on('change', function()
                {
                    plotNow();
                });
                plotNow()
            }
            flot_toggle_weekly();



            /* ========================================= */


        });

    </script>

    <!-- Sales Monthly Two Hours  -->
    <script>


        var namesM = $("input[name='MonthlyTimeName2Hours[]']")
            .map(function(){return $(this).val();}).get();


        var valuesM = $("input[name='MonthlyTotalSales2Hours[]']")
            .map(function(){return $(this).val();}).get();





        var One=valuesM[0];
        var Two=valuesM[1];
        var Three=valuesM[2];
        var Four=valuesM[3];
        var Five=valuesM[4];
        var Six=valuesM[5];
        var Seven=valuesM[6];
        var Eight=valuesM[7];
        var Nine=valuesM[8];
        var Ten=valuesM[9];
        var Eleven=valuesM[10];
        var Tweleve=valuesM[11];



        var dataTargetProfitM = [
            [1354586000000, One],
            [1364587000000, Two],
            [1374588000000, Three],
            [1384589000000, Four],
            [1394590000000, Five],
            [1404591000000, Six],
            [1414592000000, Seven],
            [1424593000000, Eight],
            [1434594000000, Nine],
            [1444595000000, Ten],
            [1454596000000, Eleven],
            [1464596000000, Tweleve]

        ]

        var dataProfitM = [
            [1354587000000, 900],
            [1364587000000, 65],
            [1374588000000, 98],
            [1384589000000, 83],
            [1394590000000, 980],
            [1404591000000, 808],
            [1414592000000, 720],
            [1424593000000, 674],
            [1434594000000, 23],
            [1444595000000, 79],
            [1454596000000, 88],
            [1464596000000, 30],

        ]

        var dataSignupsM = [
            [1354586000000, One],
            [1364587000000, Two],
            [1374588000000, Three],
            [1384589000000, Four],
            [1394590000000, Five],
            [1404591000000, Six],
            [1414592000000, Seven],
            [1424593000000, Eight],
            [1434594000000, Nine],
            [1444595000000, Ten],
            [1454596000000, Eleven],
            [1464596000000, Tweleve]
        ]


        var pyrmid=$('#toggleOneName1').val();
        var graph=$('#toggleOneName2').val();
        $(document).ready(function()
        {
            /* f Sales Monthly*/
            var flot_toggle_monthly = function()
            {

                var data = [
                    {
                        label: pyrmid,
                        data: dataTargetProfitM,
                        color: 'gold',
                        bars:
                            {
                                show: true,
                                align: "center",
                                barWidth: 30 * 30 * 60 * 1000 * 80,
                                lineWidth: 0,
                                fillColor:
                                    {
                                        colors: [
                                            {
                                                opacity: 0.9
                                            },
                                            {
                                                opacity: 0.1
                                            }]
                                    }
                            },
                        lines:
                            {
                                show: true,
                                lineWidth: 2
                            },
                        highlightColor: 'rgba(255,255,255,0.3)',
                        shadowSize: 0
                    },
                    {
                        label: '',
                        data: dataProfitM,
                        color: "red",
                        lines:
                            {
                                show: false,
                                lineWidth: 2
                            },
                        shadowSize: 0,
                        points:
                            {
                                show: false
                            }
                    },
                    {
                        label:graph,
                        data: dataSignupsM,
                        color: "red",
                        lines:
                            {
                                show: true,
                                lineWidth: 2
                            },
                        shadowSize: 0,
                        points:
                            {
                                show: true
                            }
                    }]

                var options = {
                    grid:
                        {
                            hoverable: true,
                            clickable: true,
                            tickColor: 'rgba(0,0,0,0.05)',
                            borderWidth: 1,
                            borderColor: 'rgba(0,0,0,0.05)'
                        },
                    tooltip: {
                        show: true,
                        content: "Total: %y"
                    },
                    tooltipOpts:
                        {
                            cssClass: 'tooltip-inner',
                            defaultTheme: false
                        },
                    xaxis:
                        {
                            mode: "times",
                            tickLength: 0,
                            ticks: [
                                [1354586000000, namesM[0]],
                                [1364587000000, namesM[1]],
                                [1374588000000, namesM[2]],
                                [1384589000000, namesM[3]],
                                [1394590000000, namesM[4]],
                                [1404591000000, namesM[5]],
                                [1414592000000, namesM[6]],
                                [1424593000000, namesM[7]],
                                [1434594000000, namesM[8]],
                                [1444595000000, namesM[9]],
                                [1454596000000, namesM[10]],
                                [1464596000000, namesM[11]],
                            ]

                        },
                    yaxes:
                        {


                            tickColor: 'rgba(0,0,0,0.05)'

                        }

                };

                var plot2 = null;

                function plotNow()
                {
                    var d = [];
                    $("#js-checkbox-toggles-monthly").find(':checkbox').each(function()
                    {
                        if ($(this).is(':checked'))
                        {
                            d.push(data[$(this).attr("name").substr(4, 1)]);
                        }
                    });
                    if (d.length > 0)
                    {
                        if (plot2)
                        {
                            plot2.setData(d);
                            plot2.draw();
                        }
                        else
                        {
                            plot2 = $.plot($("#flot-toggles-monthly"), d, options);
                        }
                    }

                };

                $("#js-checkbox-toggles-monthly").find(':checkbox').on('change', function()
                {
                    plotNow();
                });
                plotNow()
            }
            flot_toggle_monthly();



            /* ========================================= */


        });

    </script>

    <!-- Sales Yearly Two Hours  -->
    <script>


        var namesY = $("input[name='YearlyTimeName2Hours[]']")
            .map(function(){return $(this).val();}).get();


        var valuesY = $("input[name='YearlyTotalSales2Hours[]']")
            .map(function(){return $(this).val();}).get();





        var One=valuesY[0];
        var Two=valuesY[1];
        var Three=valuesY[2];
        var Four=valuesY[3];
        var Five=valuesY[4];
        var Six=valuesY[5];
        var Seven=valuesY[6];
        var Eight=valuesY[7];
        var Nine=valuesY[8];
        var Ten=valuesY[9];
        var Eleven=valuesY[10];
        var Tweleve=valuesY[11];



        var dataTargetProfitY = [
            [1354586000000, One],
            [1364587000000, Two],
            [1374588000000, Three],
            [1384589000000, Four],
            [1394590000000, Five],
            [1404591000000, Six],
            [1414592000000, Seven],
            [1424593000000, Eight],
            [1434594000000, Nine],
            [1444595000000, Ten],
            [1454596000000, Eleven],
            [1464596000000, Tweleve]

        ]

        var dataProfitY = [
            [1354587000000, 900],
            [1364587000000, 65],
            [1374588000000, 98],
            [1384589000000, 83],
            [1394590000000, 980],
            [1404591000000, 808],
            [1414592000000, 720],
            [1424593000000, 674],
            [1434594000000, 23],
            [1444595000000, 79],
            [1454596000000, 88],
            [1464596000000, 30],

        ]

        var dataSignupsY = [
            [1354586000000, One],
            [1364587000000, Two],
            [1374588000000, Three],
            [1384589000000, Four],
            [1394590000000, Five],
            [1404591000000, Six],
            [1414592000000, Seven],
            [1424593000000, Eight],
            [1434594000000, Nine],
            [1444595000000, Ten],
            [1454596000000, Eleven],
            [1464596000000, Tweleve]
        ]


        var pyrmid=$('#toggleOneName1').val();
        var graph=$('#toggleOneName2').val();
        $(document).ready(function()
        {
            /* f Sales Monthly*/
            var flot_toggle_yearly = function()
            {

                var data = [
                    {
                        label: pyrmid,
                        data: dataTargetProfitY,
                        color: 'purple',
                        bars:
                            {
                                show: true,
                                align: "center",
                                barWidth: 30 * 30 * 60 * 1000 * 80,
                                lineWidth: 0,
                                fillColor:
                                    {
                                        colors: [
                                            {
                                                opacity: 0.9
                                            },
                                            {
                                                opacity: 0.1
                                            }]
                                    }
                            },
                        lines:
                            {
                                show: true,
                                lineWidth: 2
                            },
                        highlightColor: 'rgba(255,255,255,0.3)',
                        shadowSize: 0
                    },
                    {
                        label: '',
                        data: dataProfitY,
                        color: "darkred",
                        lines:
                            {
                                show: false,
                                lineWidth: 2
                            },
                        shadowSize: 0,
                        points:
                            {
                                show: false
                            }
                    },
                    {
                        label:graph,
                        data: dataSignupsY,
                        color: "darkred",
                        lines:
                            {
                                show: true,
                                lineWidth: 2
                            },
                        shadowSize: 0,
                        points:
                            {
                                show: true
                            }
                    }]

                var options = {
                    grid:
                        {
                            hoverable: true,
                            clickable: true,
                            tickColor: 'rgba(0,0,0,0.05)',
                            borderWidth: 1,
                            borderColor: 'rgba(0,0,0,0.05)'
                        },
                    tooltip: {
                        show: true,
                        content: "Total: %y"
                    },
                    tooltipOpts:
                        {
                            cssClass: 'tooltip-inner',
                            defaultTheme: false
                        },
                    xaxis:
                        {
                            mode: "times",
                            tickLength: 0,
                            ticks: [
                                [1354586000000, namesY[0]],
                                [1364587000000, namesY[1]],
                                [1374588000000, namesY[2]],
                                [1384589000000, namesY[3]],
                                [1394590000000, namesY[4]],
                                [1404591000000, namesY[5]],
                                [1414592000000, namesY[6]],
                                [1424593000000, namesY[7]],
                                [1434594000000, namesY[8]],
                                [1444595000000, namesY[9]],
                                [1454596000000, namesY[10]],
                                [1464596000000, namesY[11]],
                            ]

                        },
                    yaxes:
                        {


                            tickColor: 'rgba(0,0,0,0.05)'

                        }

                };

                var plot2 = null;

                function plotNow()
                {
                    var d = [];
                    $("#js-checkbox-toggles-yearly").find(':checkbox').each(function()
                    {
                        if ($(this).is(':checked'))
                        {
                            d.push(data[$(this).attr("name").substr(4, 1)]);
                        }
                    });
                    if (d.length > 0)
                    {
                        if (plot2)
                        {
                            plot2.setData(d);
                            plot2.draw();
                        }
                        else
                        {
                            plot2 = $.plot($("#flot-toggles-yearly"), d, options);
                        }
                    }

                };

                $("#js-checkbox-toggles-yearly").find(':checkbox').on('change', function()
                {
                    plotNow();
                });
                plotNow()
            }
            flot_toggle_yearly();



            /* ========================================= */


        });

    </script>


    <!-- TotalSalesOrder VS TotalSalesOrderTranfered  -->
    <script>

        var colors = [color.success._500, color.danger._500, color.info._500, color.primary._500, color.warning._500];

        var TotSOJan=$('#TotSOJan').val();
        var TotSOFeb=$('#TotSOFeb').val();
        var TotSOMar=$('#TotSOMar').val();
        var TotSOApr=$('#TotSOApr').val();
        var TotSOMay=$('#TotSOMay').val();
        var TotSOJune=$('#TotSOJune').val();
        var TotSOJul=$('#TotSOJul').val();
        var TotSOAug=$('#TotSOAug').val();
        var TotSOSep=$('#TotSOSep').val();
        var TotSOOct=$('#TotSOOct').val();
        var TotSONov=$('#TotSONov').val();
        var TotSODec=$('#TotSODec').val();

        var TotSOJanT=$('#TotSOJanT').val();
        var TotSOFebT=$('#TotSOFebT').val();
        var TotSOMarT=$('#TotSOMarT').val();
        var TotSOAprT=$('#TotSOAprT').val();
        var TotSOMayT=$('#TotSOMayT').val();
        var TotSOJuneT=$('#TotSOJuneT').val();
        var TotSOJulT=$('#TotSOJulT').val();
        var TotSOAugT=$('#TotSOAugT').val();
        var TotSOSepT=$('#TotSOSepT').val();
        var TotSOOctT=$('#TotSOOctT').val();
        var TotSONovT=$('#TotSONovT').val();
        var TotSODecT=$('#TotSODecT').val();

        var TotSOSat=$('#TotSOSat').val();
        var TotSOSun=$('#TotSOSun').val();
        var TotSOSMon=$('#TotSOSMon').val();
        var TotSOTue=$('#TotSOTue').val();
        var TotSOWed=$('#TotSOWed').val();
        var TotSOThu=$('#TotSOThu').val();
        var TotSOFri=$('#TotSOFri').val();


        var TotSOSatT=$('#TotSOSatT').val();
        var TotSOSunT=$('#TotSOSunT').val();
        var TotSOSMonT=$('#TotSOSMonT').val();
        var TotSOTueT=$('#TotSOTueT').val();
        var TotSOWedT=$('#TotSOWedT').val();
        var TotSOThuT=$('#TotSOThuT').val();
        var TotSOFriT=$('#TotSOFriT').val();


        var splilneLine = c3.generate(
            {
                bindto: "#splilneLine",

                data:
                    {

                        x: 'x',
                        columns: [
                            ['x','Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Desc'],
                            ['Total Sales Order', TotSOJan, TotSOFeb, TotSOMar, TotSOApr, TotSOMay, TotSOJune, TotSOJul, TotSOAug, TotSOSep, TotSOOct, TotSONov, TotSODec],
                            ['Total Sales Order Transfered', TotSOJanT, TotSOFebT, TotSOMarT, TotSOAprT, TotSOMayT, TotSOJuneT, TotSOJulT, TotSOAugT, TotSOSepT, TotSOOctT, TotSONovT, TotSODecT]
                        ],
                        type: 'spline'
                    },
                color:
                    {
                        pattern: colors
                    },
                axis:
                    {
                        x:
                            {
                                type: 'category',

                                x:['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Desc'],

                            }
                    }
            });


        var splilneLineW = c3.generate(
            {
                bindto: "#splilneLineW",

                data:
                    {

                        x: 'x',
                        columns: [
                            ['x','Sat', 'Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri'],
                            ['Total Sales Order', TotSOSat, TotSOSun, TotSOSMon, TotSOTue, TotSOWed, TotSOThu, TotSOFri],
                            ['Total Sales Order Transfered', TotSOSatT, TotSOSunT, TotSOSMonT, TotSOTueT, TotSOWedT, TotSOThuT, TotSOFriT]
                        ],
                        type: 'spline'
                    },
                color:
                    {
                        pattern: colors
                    },
                axis:
                    {
                        x:
                            {
                                type: 'category',

                                x:['Sat', 'Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri'],

                            }
                    }
            });







    </script>

    <!-- New Customers -->
    <script>



        var currentWeekCustomers=$('#currentWeekCustomers').val();
        var currentMonthCustomers=$('#currentMonthCustomers').val();
        var currentYearCustomers=$('#currentYearCustomers').val();


        var dataSet3 = [
            [0, currentWeekCustomers],
            [1, currentMonthCustomers],
            [2, currentYearCustomers],


        ];
        var flotLineAlt = $.plot($('#flot-line-alt'), [
                {
                    data: dataSet3,
                    label: 'Weekly /  Monthly / Yearly',
                    color: color.danger._500
                },

                ],
            {
                series:
                    {
                        lines:
                            {
                                show: true,
                                lineWidth: 1
                            },
                        shadowSize: 0
                    },
                points:
                    {
                        show: true,
                    },
                legend:
                    {
                        noColumns: 1,
                        position: 'nw'
                    },
                grid:
                    {
                        hoverable: true,
                        clickable: true,
                        tickColor: 'rgba(0,0,0,0.05)',
                        borderWidth: 1,
                        borderColor: 'rgba(0,0,0,0.05)'
                    },
                tooltip: {
                    show: true,
                    content: "Num: %y"
                },
                tooltipOpts:
                    {
                        cssClass: 'tooltip-inner',
                        defaultTheme: false
                    },
                yaxis:
                    {

                    },
                xaxis:
                    {
                        color: '#eee',
                        font:
                            {
                                size: 10,
                                color: '#999'
                            },
                        ticks: [
                            [0, 'Weekly'],
                            [1, 'Monthly'],
                            [2, 'Yearly'],


                        ],

                    }
            });




    </script>

    <!-- Most Product Sales -->
    <script>


        var colors = ['darkred','darkblue','purple','gold','green','black','red','blue','yellow','orange'];
        var colorsM = ['darkgreen','red','purple','gold','green','black','darkred','blue','yellow','orange'];

        var namesMostP = $("input[name='MostProductName[]']")
            .map(function(){return $(this).val();}).get();


        var valuesMostP = $("input[name='MostProductQty[]']")
            .map(function(){return $(this).val();}).get();


        var namesMostPM = $("input[name='MostProductNameM[]']")
            .map(function(){return $(this).val();}).get();


        var valuesMostPM = $("input[name='MostProductQtyM[]']")
            .map(function(){return $(this).val();}).get();


        var namesLess = $("input[name='LessProductName[]']")
            .map(function(){return $(this).val();}).get();


        var valuesLess = $("input[name='LessProductQty[]']")
            .map(function(){return $(this).val();}).get();




        var pieChart = c3.generate(
            {

                bindto: "#pieChart",
                data:
                    {

                        columns: [

                            [namesMostP[0],valuesMostP[0]],
                            [namesMostP[1],valuesMostP[1]],
                            [namesMostP[2],valuesMostP[2]],
                            [namesMostP[3],valuesMostP[3]],
                            [namesMostP[4],valuesMostP[4]],
                            [namesMostP[5],valuesMostP[5]],
                            [namesMostP[6],valuesMostP[6]],
                            [namesMostP[7],valuesMostP[7]],
                            [namesMostP[8],valuesMostP[8]],
                            [namesMostP[9],valuesMostP[9]]

                        ],
                        type: 'pie' //,

                    },
                color:
                    {
                        pattern: colors
                    }
            });

        var pieChartM = c3.generate(
            {

                bindto: "#pieChartM",
                data:
                    {

                        columns: [

                            [namesMostPM[0],valuesMostPM[0]],
                            [namesMostPM[1],valuesMostPM[1]],
                            [namesMostPM[2],valuesMostPM[2]],
                            [namesMostPM[3],valuesMostPM[3]],
                            [namesMostPM[4],valuesMostPM[4]],
                            [namesMostPM[5],valuesMostPM[5]],
                            [namesMostPM[6],valuesMostPM[6]],
                            [namesMostPM[7],valuesMostPM[7]],
                            [namesMostPM[8],valuesMostPM[8]],
                            [namesMostPM[9],valuesMostPM[9]]

                        ],
                        type: 'pie' //,

                    },
                color:
                    {
                        pattern: colorsM
                    }
            });





    </script>


    <!-- Most Customer Sales -->
    <script>


        var namesCust = $("input[name='MostCustomerName[]']")
            .map(function(){return $(this).val();}).get();


        var valuesCust = $("input[name='MostCustomerQty[]']")
            .map(function(){return $(this).val();}).get();

        var namesCustM = $("input[name='MostCustomerNameM[]']")
            .map(function(){return $(this).val();}).get();


        var valuesCustM = $("input[name='MostCustomerQtyM[]']")
            .map(function(){return $(this).val();}).get();

        var barChart = c3.generate(
            {
                bindto: "#barChart",
                data:
                    {
                        columns: [
                            [namesCust[0], valuesCust[0]],
                            [namesCust[1], valuesCust[1]],
                            [namesCust[2], valuesCust[2]],
                            [namesCust[3], valuesCust[3]],
                            [namesCust[4], valuesCust[4]],
                            [namesCust[5], valuesCust[5]],
                            [namesCust[6], valuesCust[6]],
                            [namesCust[7], valuesCust[7]],
                            [namesCust[8], valuesCust[8]],
                            [namesCust[9], valuesCust[9]]
                        ],
                        type: 'bar',

                    },
                color:
                    {
                        pattern: colors
                    },
                bar:
                    {
                        width:
                            {
                                ratio: 0.8 // this makes bar width 50% of length between ticks
                            }
                        // or
                        //width: 100 // this makes bar width 100px
                    }
            });


        var barChartM = c3.generate(
            {
                bindto: "#barChartM",
                data:
                    {
                        columns: [
                            [namesCustM[0], valuesCustM[0]],
                            [namesCustM[1], valuesCustM[1]],
                            [namesCustM[2], valuesCustM[2]],
                            [namesCustM[3], valuesCustM[3]],
                            [namesCustM[4], valuesCustM[4]],
                            [namesCustM[5], valuesCustM[5]],
                            [namesCustM[6], valuesCustM[6]],
                            [namesCustM[7], valuesCustM[7]],
                            [namesCustM[8], valuesCustM[8]],
                            [namesCustM[9], valuesCustM[9]]
                        ],
                        type: 'bar',

                    },
                color:
                    {
                        pattern: colors
                    },
                bar:
                    {
                        width:
                            {
                                ratio: 0.8 // this makes bar width 50% of length between ticks
                            }
                        // or
                        //width: 100 // this makes bar width 100px
                    }
            });


    </script>

    <!-- Most Delegate Sales -->
    <script>


        var namesDelegate = $("input[name='MostDelegateName[]']")
            .map(function(){return $(this).val();}).get();


        var valuesDelegate = $("input[name='MostDelegateQty[]']")
            .map(function(){return $(this).val();}).get();

        var namesDelegateM = $("input[name='MostDelegateNameM[]']")
            .map(function(){return $(this).val();}).get();


        var valuesDelegateM = $("input[name='MostDelegateQtyM[]']")
            .map(function(){return $(this).val();}).get();


        var distributedSeries = function()
        {
            new Chartist.Bar('#distributedSeries',
                {
                    labels: [namesDelegate[0], namesDelegate[1], namesDelegate[2], namesDelegate[3], namesDelegate[4], namesDelegate[5], namesDelegate[6], namesDelegate[7], namesDelegate[8], namesDelegate[9] ],
                    series: [valuesDelegate[0], valuesDelegate[1], valuesDelegate[2], valuesDelegate[3], valuesDelegate[4], valuesDelegate[5], valuesDelegate[6], valuesDelegate[7], valuesDelegate[8], valuesDelegate[9]]
                },
                {
                    distributeSeries: true
                });
        }


        var distributedSeriesM = function()
        {
            new Chartist.Bar('#distributedSeriesM',
                {
                    labels: [namesDelegateM[0], namesDelegateM[1], namesDelegateM[2], namesDelegateM[3], namesDelegateM[4], namesDelegateM[5], namesDelegateM[6], namesDelegateM[7], namesDelegateM[8], namesDelegateM[9] ],
                    series: [valuesDelegateM[0], valuesDelegateM[1], valuesDelegateM[2], valuesDelegateM[3], valuesDelegateM[4], valuesDelegateM[5], valuesDelegateM[6], valuesDelegateM[7], valuesDelegateM[8], valuesDelegateM[9]]
                },
                {
                    distributeSeries: true
                });
        }



    </script>


    <!-- Most Stores Sales -->
    <script>


        var namesStore = $("input[name='MostStoreName[]']")
            .map(function(){return $(this).val();}).get();


        var valuesStore = $("input[name='MostStoreQty[]']")
            .map(function(){return $(this).val();}).get();

        var namesStoreM = $("input[name='MostStoreNameM[]']")
            .map(function(){return $(this).val();}).get();


        var valuesStoreM = $("input[name='MostStoreQtyM[]']")
            .map(function(){return $(this).val();}).get();


        var gaugeChart = function()
        {
            new Chartist.Pie('#gaugeChart',
                {
                    series: [namesStore[0], namesStore[1], namesStore[2], namesStore[3],namesStore[4]]
                },
                {
                    donut: true,
                    donutWidth: 60,
                    startAngle: 270,
                    total: 200,
                    colors:color,
                    showLabel: true
                });
        }



        var gaugeChartFill = function()
        {
            new Chartist.Pie('#gaugeChartFill',
                {

                    series: [valuesStore[0], valuesStore[1], valuesStore[2], valuesStore[3],valuesStore[4]],

                },
                {
                    donut: true,
                    donutWidth: 100,
                    donutSolid: true,
                    startAngle: 270,
                    total: 100,
                    color: colors,
                    showLabel: true
                });
        }


        var gaugeChartFillM = function()
        {
            new Chartist.Pie('#gaugeChartFillM',
                {

                    series: [valuesStoreM[0], valuesStoreM[1], valuesStoreM[2], valuesStoreM[3],valuesStoreM[4]],

                },
                {
                    donut: true,
                    donutWidth: 100,
                    donutSolid: true,
                    startAngle: 270,
                    total: 100,
                    color: colors,
                    showLabel: true
                });
        }




    </script>

    <!-- Most Product Purchases -->
    <script>


        var namesPurch = $("input[name='MostPurchName[]']")
            .map(function(){return $(this).val();}).get();


        var valuesPurch = $("input[name='MostPurchQty[]']")
            .map(function(){return $(this).val();}).get();



        var donutFill = function()
        {
            new Chartist.Pie('#donutFill',
                {
                    series: [valuesPurch[0],valuesPurch[1],valuesPurch[2],valuesPurch[3],valuesPurch[4],valuesPurch[5],valuesPurch[6],valuesPurch[7],valuesPurch[8],valuesPurch[9]]
                },
                {
                    donut: true,
                    donutWidth: 60,
                    donutSolid: true,
                    startAngle: 270,
                    showLabel: true
                });
        }





    </script>


    <!-- App Sales -->
    <script>


        var namesApp = $("input[name='AppName[]']")
            .map(function(){return $(this).val();}).get();


        var valuesApp = $("input[name='AppTotal[]']")
            .map(function(){return $(this).val();}).get();

        var donutChart = c3.generate(
            {
                bindto: "#donutChart",
                data:
                    {
                        // iris data from R
                        columns: [
                            [namesApp[0], valuesApp[0]],
                            [namesApp[1], valuesApp[1]],
                            [namesApp[2], valuesApp[2]],
                            [namesApp[3], valuesApp[3]],
                            [namesApp[4], valuesApp[4]],


                        ],
                        type: 'donut' //,

                    },
                donut:
                    {
                        title: "Apps Sales"
                    },
                color:
                    {
                        pattern: colors
                    }
            });

    </script>

    <script>

        $(document).ready(function()
        {
            distributedSeries();
            distributedSeriesM();
            gaugeChart();
            donutFill();
            gaugeChartFill();
            gaugeChartFillM();

        });

    </script>


@endpush
