@extends('admin.index')
@section('content')
    @php
        use App\Models\ExpireDateQty;

    @endphp
    <title>{{$title}}</title>

    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Sales')}} </a></li>
            <li class="breadcrumb-item active">{{$title}} </li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                    class="js-get-date"></span></li>
        </ol>



        <form id="form" action="{{$urll}}" method="post" enctype="multipart/form-data">
            {!! csrf_field() !!}
            @honeypot
            <input type="hidden" name="ID" value="{{$item->id}}">
            <input type="hidden" name="User" value="{{$item->User}}">
            <div class="row">
                <div class="col-lg-12">
                    <div id="panel-2" class="panel">
                        <div class="panel-hdr">
                            <h2>
                                <span class="fw-300"><i>   {{$title}}  </i></span>
                            </h2>
                        </div>
                        <div class="panel-container show">
                            <span id="ex"> @include('admin.layouts.messages')</span>
                            <div class="panel-content">
                                <div class="form-row">
                                    <div class="form-group col-lg-2">
                                        <label class="form-label" for="simpleinput">{{trans('admin.Code')}} </label>
                                        <input type="text" name="Old_Code" value="{{$item->Code}}" class="form-control " readonly>
                                        <input type="hidden" name="Code" value="{{$Code}}" class="form-control">
                                    </div>
                                    @if(auth()->guard('admin')->user()->emp == 0)
                                        <div class="form-group col-lg-2">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                                            <input type="date" name="Date" value="{{$item->Date}}" class="form-control" required>
                                        </div>
                                    @else

                                        @if(auth()->guard('admin')->user()->Date == 1)
                                            <div class="form-group col-lg-2">
                                                <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                                                <input type="date" name="Date" value="{{$item->Date}}" class="form-control" required>
                                            </div>
                                        @else
                                            <div class="form-group col-lg-2">
                                                <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                                                <input type="date" name="Date" value="{{$item->Date}}" class="form-control" required readonly>
                                            </div>
                                        @endif

                                    @endif

                                    @if($Place != 'Edit_Sales')

                                        <div class="form-group col-lg-2">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Sale_Date')}}</label>
                                            <input type="date" name="Sale_Date" value="{{$item->Sale_Date}}"  class="form-control">
                                        </div>

                                    @endif


                                    @if($item->TaxBill == 0)

                                        @if($show->TaxBill == 1)
                                            <div class="form-group col-lg-2">
                                                <label class="form-label" for="">{{trans('admin.TaxBill')}}</label>
                                                <select class="select2 form-control w-100" disabled>
                                                    <option value="0" @if($item->TaxBill == 0) selected @endif>{{trans('admin.No_Tax')}}</option>
                                                    <option value="1" @if($item->TaxBill == 1) selected @endif>{{trans('admin.Yes_Tax')}}</option>
                                                </select>
                                            </div>
                                            <input type="hidden" name="TaxBill" value="{{$item->TaxBill}}">
                                        @else

                                            <input type="hidden" name="TaxBill" value="{{$item->TaxBill}}">
                                        @endif
                                    @else

                                        <input type="hidden" name="TaxBill" value="{{$item->TaxBill}}">
                                    @endif

                                    @if($Def->DiscountTaxShow == 1)
                                        <div class="form-group col-lg-2">
                                            <label class="form-label" for="">{{trans('admin.DiscountTax')}}</label>
                                            <select class="select2 form-control w-100"  disabled>
                                                <option value="0" @if($item->DiscountTaxShow == 0) selected @endif>{{trans('admin.No')}}</option>
                                                <option value="1" @if($item->DiscountTaxShow == 1) selected @endif>{{trans('admin.Yes')}}</option>
                                            </select>
                                        </div>
                                        <input type="hidden" name="DiscountTaxShow" value="{{$item->DiscountTaxShow}}">
                                    @else
                                        <input type="hidden" name="DiscountTaxShow" value="{{$item->DiscountTaxShow}}">
                                    @endif


                                    <div class="form-group col-lg-2">
                                        <label class="form-label" for="">({{trans('admin.Code')}})  @if($Place=='SalesOrder'){{trans('admin.SalesOrder')}}@else {{trans('admin.Sales')}}  @endif  </label>
                                        <input type="text" class="form-control" readonly value="{{$Code}}">
                                    </div>

                                    <div class="form-group col-lg-2">
                                        <label class="form-label" for="">{{trans('admin.Store')}}</label>
                                        <select class="select2 form-control w-100" id="store"  disabled>
                                            @foreach($Stores as $stor)
                                                <option value="{{$stor->id}}" @if($item->Store == $stor->id) selected @endif>
                                                    {{app()->getLocale() == 'ar' ?$stor->Name :$stor->NameEn}}
                                                </option>
                                            @endforeach
                                        </select>
                                        <input type="hidden" name="Store" value="{{$item->Store}}">
                                    </div>
                                    <div class="form-group col-lg-2">
                                        <label class="form-label" for="">{{trans('admin.Safe')}}</label>
                                        <select class="select2 form-control w-100" name="Safe" required>

                                            @foreach($Safes as $safe)
                                                <option value="{{$safe->id}}" @if($item->Safe == $safe->id) selected @endif>
                                                    {{app()->getLocale() == 'ar' ?$safe->Name :$safe->NameEn}}
                                                </option>
                                            @endforeach
                                        </select>

                                    </div>


                                    @if($show->Coin == 1)
                                        <div class="form-group col-lg-2">
                                            <label class="form-label" for="">{{trans('admin.Coin')}}</label>
                                            <select class="select2 form-control w-100"  disabled>
                                                <option value=""> {{trans('admin.Coin')}}</option>
                                                @foreach($Coins as $coin)
                                                    <option value="{{$coin->id}}" @if($item->Coin == $coin->id) selected @endif>
                                                        {{app()->getLocale() == 'ar' ?$coin->Arabic_Name :$coin->English_Name}}
                                                    </option>
                                                @endforeach
                                            </select>
                                            <input type="hidden" name="Coin" value="{{$item->Coin}}">
                                        </div>
                                    @else
                                        <div class="form-group col-lg-2" style="display: none">
                                            <label class="form-label" for="">{{trans('admin.Coin')}}</label>
                                            <select class="select2 form-control w-100" name="Coin" required>
                                                <option value=""> {{trans('admin.Coin')}}</option>
                                                @foreach($Coins as $coin)
                                                    <option value="{{$coin->id}}" @if($item->Coin == $coin->id) selected @endif>
                                                        {{app()->getLocale() == 'ar' ?$coin->Arabic_Name :$coin->English_Name}}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    @endif

                                    @if($show->Draw == 1)
                                        <div class="form-group col-lg-2">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Draw')}}</label>
                                            <input type="text" name="Draw" value="{{$item->Draw}}" class="form-control" readonly>
                                        </div>
                                    @else
                                        <div class="form-group col-lg-2" style="display: none">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Draw')}}</label>
                                            <input type="text" name="Draw" value="{{$item->Draw}}" class="form-control" required>
                                        </div>
                                    @endif


                                    @if(auth()->guard('admin')->user()->emp != 0)
                                        <div class="form-group col-lg-2">
                                            <label class="form-label" for=""> {{trans('admin.Payment_Method')}}</label>
                                            <select class="select2 form-control w-100" name="Payment_Method" id="Payment_Method" onchange="Statuss()" required>

                                                @if(auth()->guard('admin')->user()->Cash == 1)
                                                    <option value="Cash" @if($item->Payment_Method == 'Cash') selected @endif>{{trans('admin.Cash')}} </option>
                                                @endif
                                                @if(auth()->guard('admin')->user()->Later == 1)
                                                    <option value="Later" @if($item->Payment_Method == 'Later') selected @endif>{{trans('admin.Later')}}</option>
                                                @endif
                                                @if(auth()->guard('admin')->user()->Installment == 1)
                                                    <option value="Installment"  @if($item->Payment_Method == 'Installment') selected @endif>{{trans('admin.Installment')}}</option>
                                                @endif
                                                @if(auth()->guard('admin')->user()->Check == 1)
                                                    <option value="Check" @if($item->Payment_Method == 'Check') selected @endif>{{trans('admin.Check')}}</option>
                                                @endif
                                                @if(auth()->guard('admin')->user()->InstallmentCompanies == 1)
                                                    <option value="InstallmentCompanies">{{trans('admin.InstallmentCompanies')}}</option>
                                                @endif
                                            </select>
                                        </div>

                                    @else
                                        <div class="form-group col-lg-2">
                                            <label class="form-label" for=""> {{trans('admin.Payment_Method')}}</label>
                                            <select class="select2 form-control w-100" name="Payment_Method" id="Payment_Method" onchange="Statuss()" required>
                                                <option value="Cash" @if($item->Payment_Method == 'Cash') selected @endif>{{trans('admin.Cash')}} </option>
                                                <option value="Later" @if($item->Payment_Method == 'Later') selected @endif>{{trans('admin.Later')}}</option>
                                                <option value="Installment"  @if($item->Payment_Method == 'Installment') selected @endif>{{trans('admin.Installment')}}</option>
                                                <option value="Check" @if($item->Payment_Method == 'Check') selected @endif>{{trans('admin.Check')}}</option>
                                                <option value="InstallmentCompanies">{{trans('admin.InstallmentCompanies')}}</option>
                                            </select>
                                        </div>
                                    @endif
                                    <div class="form-group col-lg-2" style="display: none" id="Later_Due">
                                        <label class="form-label" for="simpleinput">{{trans('admin.Later_Due')}}</label>
                                        <input type="date" name="Later_Due" value="{{$item->Later_Due}}"  class="form-control" >
                                    </div>



                                    @if($show->Status == 1)
                                        <div class="form-group col-lg-2">
                                            <label class="form-label" for="">{{trans('admin.Status')}}</label>
                                            <select class="select2 form-control w-100" name="Status" onchange="Statuss()" id="Status"  required>
                                                <option value="1" @if($item->Status == 1) selected @endif>{{trans('admin.Recived')}} </option>
                                                <option value="0" @if($item->Status == 0) selected @endif>{{trans('admin.Pending')}}</option>
                                            </select>
                                        </div>
                                    @else
                                        <div class="form-group col-lg-2" style="display: none">
                                            <label class="form-label" for="">{{trans('admin.Status')}}</label>
                                            <select class="select2 form-control w-100" name="Status" onchange="Statuss()" id="Status"  required>
                                                <option value="1" @if($item->Status == 1) selected @endif>{{trans('admin.Recived')}} </option>
                                                <option value="0" @if($item->Status == 0) selected @endif>{{trans('admin.Pending')}}</option>
                                            </select>
                                        </div>
                                    @endif

                                    @if($show->Cost_Center == 1)
                                        <div class="form-group col-lg-2">
                                            <label class="form-label" for=""> {{trans('admin.Cost_Center')}} </label>
                                            <select class="select2 form-control w-100"  disabled>
                                                <option value=""> {{trans('admin.Cost_Center')}}</option>
                                                @foreach($CostCenters as $cost)
                                                    <option value="{{$cost->id}}"  @if($item->Cost_Center == $cost->id) selected @endif>
                                                        {{app()->getLocale() == 'ar' ?$cost->Arabic_Name :$cost->English_Name}}
                                                    </option>
                                                @endforeach
                                            </select>
                                            <input type="hidden" name="Cost_Center" value="{{$item->Cost_Center}}">
                                        </div>
                                    @else
                                        <div class="form-group col-lg-2" style="display: none">

                                            <label class="form-label" for=""> {{trans('admin.Cost_Center')}} </label>
                                            <select class="select2 form-control w-100" name="Cost_Center">
                                                <option value=""> {{trans('admin.Cost_Center')}}</option>
                                                @foreach($CostCenters as $cost)
                                                    <option value="{{$cost->id}}" @if($item->Cost_Center == $cost->id) selected @endif>
                                                        {{app()->getLocale() == 'ar' ?$cost->Arabic_Name :$cost->English_Name}}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    @endif

                                    @if($show->Delegate_Sale == 1)
                                        @if(auth()->guard('admin')->user()->emp == 0)
                                            <div class="form-group col-lg-2">
                                                <label class="form-label" for="">{{trans('admin.Delegate')}}</label>
                                                <select class="select2 form-control w-100 EmpDele"  disabled>
                                                    <option value=""> {{trans('admin.Delegate')}}</option>
                                                    @foreach($Employess as $emp)
                                                        <option value="{{$emp->id}}" @if($item->Delegate == $emp->id) selected @endif>
                                                            {{app()->getLocale() == 'ar' ?$emp->Name :$emp->NameEn}}
                                                        </option>
                                                    @endforeach
                                                </select>

                                                <input type="hidden" name="Delegate" value="{{$item->Delegate}}">
                                            </div>
                                        @else
                                            @if($Def->DelegateEmp == 0)
                                                <input type="hidden" name="Delegate" value="{{auth()->guard('admin')->user()->emp}}">
                                            @else
                                                <div class="form-group col-lg-2">
                                                    <label class="form-label" for="">{{trans('admin.Delegate')}}</label>
                                                    <select class="select2 form-control w-100 EmpDele" disabled>
                                                        <option value=""> {{trans('admin.Delegate')}}</option>
                                                        @foreach($Employess as $emp)
                                                            <option value="{{$emp->id}}" @if($item->Delegate == $emp->id) selected @endif>
                                                                {{app()->getLocale() == 'ar' ?$emp->Name :$emp->NameEn}}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                    <input type="hidden" name="Delegate" value="{{$item->Delegate}}">
                                                </div>

                                            @endif
                                        @endif
                                    @else
                                        <div class="form-group col-lg-2" style="display: none">
                                            <label class="form-label" for="">{{trans('admin.Delegate')}}</label>
                                            <select class="select2 form-control w-100 EmpDele" name="Delegate">
                                                <option value=""> {{trans('admin.Delegate')}}</option>
                                                @foreach($Employess as $emp)
                                                    <option value="{{$emp->id}}" @if($item->Delegate == $emp->id) selected @endif>
                                                        {{app()->getLocale() == 'ar' ?$emp->Name :$emp->NameEn}}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    @endif


                                    @if(auth()->guard()->user()->emp == 0)

                                        @if($show->Executor_Sale == 1)
                                            <div class="form-group col-lg-2">
                                                <label class="form-label" for="">{{trans('admin.Executor')}}</label>
                                                <select  class="js-data-example-ajax form-control w-100" id="Emp" disabled >
                                                    @if(!empty($item->Executor))
                                                        <option value="{{$item->Executor}}">

                                                            {{app()->getLocale() == 'ar' ?$item->Executor()->first()->Name :$item->Executor()->first()->NameEn}}
                                                        </option>
                                                    @endif
                                                </select>
                                                <input type="hidden" name="Executor" value="{{$item->Executor}}">
                                            </div>
                                        @else
                                            <input type="hidden" name="Executor" value="{{$item->Executor}}">
                                        @endif

                                    @else




                                        @if($Def->ExecuteEmp == 0)

                                            <input type="hidden" name="Executor" value="{{auth()->guard()->user()->executor}}">

                                        @else


                                            @if($show->Executor_Sale == 1)

                                                <div class="form-group col-lg-2">
                                                    <label class="form-label" for="">{{trans('admin.Executor')}}</label>
                                                    <select  class="js-data-example-ajax form-control w-100" id="Emp" disabled >
                                                        @if(!empty($item->Executor))
                                                            <option value="{{$item->Executor}}">

                                                                {{app()->getLocale() == 'ar' ?$item->Executor()->first()->Name :$item->Executor()->first()->NameEn}}
                                                            </option>
                                                        @endif
                                                    </select>
                                                    <input type="hidden" name="Executor" value="{{$item->Executor}}">
                                                </div>
                                            @else

                                                <input type="hidden" name="Executor" value="{{auth()->guard()->user()->executor}}">
                                            @endif




                                        @endif

                                    @endif


                                    @if($show->Refrence_Number == 1)
                                        <div class="form-group col-lg-2">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Refrence_Number')}}</label>
                                            <input type="text" name="Refernce_Number" value="{{$item->Refernce_Number}}" class="form-control" readonly>
                                        </div>
                                    @else
                                        <div class="form-group col-lg-2" style="display: none">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Refrence_Number')}}</label>
                                            <input type="text" name="Refernce_Number" value="{{$item->Refernce_Number}}" class="form-control">
                                        </div>
                                    @endif


                                    <div class="form-group col-lg-4">
                                        <label class="form-label" for="">{{trans('admin.Account')}} ({{trans('admin.Client')}})</label>
                                        <select  class="select2 form-control w-100" id="client"  disabled>

                                            <option value="{{$item->Client()->first()->id}}">

                                                {{app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn}}
                                            </option>
                                        </select>
                                        <input type="hidden" name="Client" value="{{$item->Client()->first()->id}}">
                                    </div>



                                    @can('خانه رصيد حساب العميل')   @php $credStyle="block"; @endphp @endcan

                                    <div class="form-group col-lg-3" style="display: {{$credStyle}}">
                                        <label class="form-label" for="simpleinput"> {{trans('admin.Account_Credit')}} </label>
                                        <input type="text" id="AccountCredit"  value="{{$item->Current_Credit}}" class="form-control " name="Current_Credit" readonly>

                                    </div>

                                    @if($show->Shipping_Company == 1)
                                        <div class="form-group col-lg-2">
                                            <label class="form-label" for="">{{trans('admin.Shipping_Compaines')}}</label>
                                            <select class="select2 form-control w-100" disabled >
                                                <option value=""> {{trans('admin.Shipping_Compaines')}}</option>
                                                @foreach($Shippings as $ship)
                                                    <option value="{{$ship->id}}" @if($item->Ship == $ship->id) selected @endif>

                                                        {{app()->getLocale() == 'ar' ?$ship->Name :$ship->NameEn}}
                                                    </option>
                                                @endforeach
                                            </select>
                                            <input type="hidden" name="Ship" value="{{$item->Ship}}">
                                        </div>
                                    @else
                                        <div class="form-group col-lg-2" style="display: none">
                                            <label class="form-label" for="">{{trans('admin.Shipping_Compaines')}}</label>
                                            <select class="select2 form-control w-100"  name="Ship" >
                                                <option value=""> {{trans('admin.Shipping_Compaines')}}</option>
                                                @foreach($Shippings as $ship)
                                                    <option value="{{$ship->id}}" @if($item->Ship == $ship->id) selected @endif>
                                                        {{app()->getLocale() == 'ar' ?$ship->Name :$ship->NameEn}}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    @endif

                                    @if($show->Note == 1)
                                        <div class="form-group col-lg-4">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Notes')}}  </label>
                                            <input type="text" name="Note" value="{{$item->Note}}" class="form-control" readonly>
                                        </div>
                                    @else
                                        <div class="form-group col-lg-4" style="display: none">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Notes')}}  </label>
                                            <input type="text" name="Note" value="{{$item->Note}}" class="form-control">
                                        </div>
                                    @endif


                                    <input type="hidden" name="Files" value="{{$item->File}}">
                                    @if($show->Show_File_Sales == 1)
                                        <div class="form-group col-lg-12">
                                            <label class="form-label" for="simpleinput">{{trans('admin.File')}}</label>
                                            <input type="file" name="File"  class="form-control">
                                        </div>
                                    @endif
                                </div>

                                <div id="Install" style="display: none">

                                    <div class="row">
                                        <div class="form-group col-lg-3">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Presenter')}}</label>
                                            <input type="number" step="any"  value="{{$item->presenter}}" class="form-control" name="presenter" >

                                        </div>
                                        <div class="form-group col-lg-3">
                                            <label class="form-label" for="simpleinput">{{trans('admin.annual_interest')}}</label>
                                            <input type="number" step="any"  value="{{$item->annual_interest}}" class="form-control" name="annual_interest">

                                        </div>

                                        <div class="form-group col-lg-3">
                                            <label class="form-label" for="simpleinput">{{trans('admin.monthly_installment')}}</label>
                                            <input type="number" step="any"  value="{{$item->monthly_installment}}" class="form-control" name="monthly_installment">

                                        </div>

                                        <div class="form-group col-lg-3">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Years_Number')}}</label>
                                            <input type="number" step="any"  value="{{$item->Years_Number}}" class="form-control" name="Years_Number">

                                        </div>

                                        <div class="form-group col-lg-4">
                                            <label class="form-label" for="simpleinput">{{trans('admin.total')}}</label>
                                            <input type="number" step="any"  value="{{$item->total}}" class="form-control" name="total" readonly>

                                        </div>

                                        <div class="form-group col-lg-4">
                                            <label class="form-label" for="simpleinput">{{trans('admin.installment_Num')}}</label>
                                            <input type="number" step="any"  value="{{$item->installment_Num}}" class="form-control" name="installment_Num">

                                        </div>

                                        <div class="form-group col-lg-4">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Date_First_installment')}}</label>
                                            <input type="date"   value="{{$item->Date_First_installment}}" class="form-control" name="Date_First_installment">

                                        </div>
                                    </div>
                                </div>

                                <div  id="CHECK" style="display: none">

                                    <div class="row">
                                        <div class="form-group col-lg-4">
                                            <label class="form-label" for="">{{trans('admin.Check_Type')}}</label>
                                            <select class="select2 form-control w-100"  name="Check_Type" >
                                                <option value=""> {{trans('admin.Check_Type')}}</option>
                                                @foreach($ChecksTypes as $type)
                                                    <option value="{{$type->id}}" @if($item->Check_Type == $type->id) selected @endif>

                                                        {{app()->getLocale() == 'ar' ?$type->Arabic_Name :$type->English_Name}}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div class="form-group col-lg-4">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Due_Date')}}  </label>
                                            <input type="date"  value="{{$item->Due_Date}}" class="form-control" name="Due_Date">
                                        </div>


                                        <div class="form-group col-lg-4">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Check_Number')}}  </label>
                                            <input type="number" step="any"  value="{{$item->Check_Number}}" class="form-control" name="Check_Number">
                                        </div>
                                    </div>

                                </div>

                                <div id="CompInstall" style="display: none">
                                    <div class="row">

                                        <div class="form-group col-lg-4">
                                            <label class="form-label" for="">{{trans('admin.InstallCompany')}}</label>
                                            <select class="select2 form-control w-100"  name="InstallCompany" id="InstallCompany" onchange="InstaallComp()" >
                                                <option value=""> {{trans('admin.InstallCompany')}}</option>
                                                @foreach($InstallmentCompanies as $inst)
                                                    <option value="{{$inst->id}}">
                                                        {{app()->getLocale() == 'ar' ?$inst->Arabic_Name :$inst->English_Name}}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>


                                        <div class="form-group col-lg-4">
                                            <label class="form-label" for="simpleinput">{{trans('admin.ContractNumber')}}  </label>
                                            <input type="text" name="ContractNumber" value="{{old('ContractNumber')}}" class="form-control">
                                        </div>



                                        <div class="form-group col-lg-4">
                                            <label class="form-label" for="">{{trans('admin.PayFees')}}</label>
                                            <select class="select2 form-control w-100"  name="PayFees"  >
                                                <option value="No"> {{trans('admin.No')}}</option>
                                                <option value="Yes"> {{trans('admin.Yes')}}</option>
                                            </select>
                                        </div>
                                        @can('رسوم خدمات شركات التقسيط')  @php $Style='block';  @endphp   @endcan

                                        <div class="form-group col-lg-4" style="display: {{$Style}}">
                                            <label class="form-label" for="simpleinput">{{trans('admin.ServiceFee')}}  </label>
                                            <input type="text" name="ServiceFee" id="ServiceFee" value="{{old('ServiceFee')}}" class="form-control" readonly>
                                        </div>


                                        <div class="form-group col-lg-4" style="display: {{$Style}}">
                                            <label class="form-label" for="simpleinput">{{trans('admin.CompanyPrecent')}}  </label>
                                            <input type="text" name="CompanyPrecent" id="CompanyPrecent" value="{{old('CompanyPrecent')}}" class="form-control" readonly>
                                        </div>

                                        <div class="form-group col-lg-4" style="display: {{$Style}}">
                                            <label class="form-label" for="simpleinput">{{trans('admin.TotalServiceFee')}}  </label>
                                            <input type="text"  id="TotalServiceFee"  class="form-control" readonly>
                                        </div>



                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-12">
                    <div id="panel-1" class="panel">

                        <div class="panel-container show">
                            <div class="panel-content">


                                <!-- datatable start -->
                                <div id="mobile-overflow">
                                    <table id="dt"
                                           class="table table-bordered table-hover table-striped w-100 mobile-width-more table-color2">
                                        <thead>
                                        <tr>
                                            <th>{{trans('admin.Name')}}</th>
                                             @if($show->Show_Unit == 1)
                                                <th>{{trans('admin.Unit')}}</th>
                                            @endif

                                            @if($show->Show_Barcode == 1)
                                                <th>{{trans('admin.Code')}}</th>
                                            @endif
                                            @if($show->Patch_Number == 1)
                                                <th>{{trans('admin.Patch_Number')}}</th>
                                            @endif
                                            @if($show->AvQty == 1)
                                                <th>{{trans('admin.AvQty')}}</th>
                                            @endif
                                            <th>{{trans('admin.Qty')}}</th>
                                            <th>{{trans('admin.Price')}}</th>
                                            @if($show->Disc == 1)
                                                <th>{{trans('admin.Discount')}}</th>
                                            @endif
                                            @if($show->TotalBfTax == 1)
                                                <th>{{trans('admin.Total_Bf_Taxes')}}</th>
                                            @endif
                                            @if($show->Tax == 1)
                                                <th>{{trans('admin.Tax')}}</th>
                                            @endif
                                            @if($show->Show_Total == 1)
                                                <th>{{trans('admin.Total')}}</th>
                                            @endif

                                            @if($show->Show_Net == 1)
                                                <th>{{trans('admin.The_Net')}}</th>
                                            @endif


                                            @if($show->Store == 1)
                                                <th>{{trans('admin.Store')}}</th>
                                            @endif
                                            @if($show->Expire_Date == 1)
                                                <th>{{trans('admin.Exp_Date')}}</th>
                                            @endif
                                            @if($show->Sales_Pro_Desc == 1)
                                                <th>{{trans('admin.Desc')}}</th>
                                            @endif
                                            <th>{{trans('admin.Actions')}}</th>
                                        </tr>
                                        </thead>
                                        <tbody id="data-dt">
                                        @if($show->Disc == 1)
                                            @php  $disshow='';   @endphp
                                        @else
                                            @php  $disshow='none';   @endphp
                                        @endif


                                        @if($show->TotalBfTax == 1)
                                            @php  $totbfhow='';   @endphp
                                        @else
                                            @php  $totbfhow='none';   @endphp
                                        @endif


                                        @if($show->Tax == 1)
                                            @php  $taxshow='';   @endphp
                                        @else
                                            @php  $taxshow='none';   @endphp
                                        @endif


                                        @if($show->Store == 1)
                                            @php  $storeshow='';   @endphp
                                        @else
                                            @php  $storeshow='none';   @endphp
                                        @endif


                                        @if($show->AvQty == 1)
                                            @php  $avqtyshow='';   @endphp
                                        @else
                                            @php  $avqtyshow='none';   @endphp
                                        @endif





                                        @if($Place=='RecivedSales')



                                            @foreach($details as $pro)

                                                <tr>
                                                    <td>

                                                        {{app()->getLocale() == 'ar' ?$pro->Product()->first()->P_Ar_Name :$pro->Product()->first()->P_En_Name}}
                                                        <input type='hidden' name='P_Ar_Name[]' value='{{$pro->Product()->first()->P_Ar_Name}}'>
                                                        <input type='hidden' name='P_En_Name[]' value='{{$pro->Product()->first()->P_En_Name}}'>

                                                        @if(!empty($pro->V1))
                                                            ( {{app()->getLocale() == 'ar' ?$pro->V1()->first()->Name :$pro->V1()->first()->NameEn}} )

                                                            <input type='hidden' name='VOne[]' value='{{$pro->V1}}'>
                                                            <input type='hidden' name='V_Name[]' value='{{$pro->V_Name}}'>

                                                        @else
                                                            <input type='hidden' name='VOne[]' value=''>
                                                            <input type='hidden' name='V_Name[]' value=''>
                                                        @endif

                                                        @if(!empty($pro->V2))
                                                            ( {{app()->getLocale() == 'ar' ?$pro->V2()->first()->Name :$pro->V2()->first()->NameEn}} )
                                                            <input type='hidden' name='VTwo[]' value='{{$pro->V2}}'>
                                                            <input type='hidden' name='VV_Name[]' value='{{$pro->VV_Name}}'>
                                                        @else
                                                            <input type='hidden' name='VTwo[]' value=''>
                                                            <input type='hidden' name='VV_Name[]' value=''>
                                                        @endif

                                                    </td>

                                                    @if($show->Show_Unit == 1)

                                                        <td><input type='hidden' id="UnitPurch{{$pro->id}}" name='Unit[]' value='{{$pro->Unit}}'>{{app()->getLocale() == 'ar' ?$pro->Unit()->first()->Name :$pro->Unit()->first()->NameEn}}</td>

                                                    @else
                                                        <input type='hidden' id="UnitPurch{{$pro->id}}" name='Unit[]' value='{{$pro->Unit}}'>
                                                    @endif

                                                    @if($show->Show_Barcode == 1)
                                                        <td><input type='hidden' id="CodePurch{{$pro->id}}" name='P_Code[]' value='{{$pro->Product_Code}}'>
                                                            <input type='hidden' name='Patch_Number[]' value='{{$pro->Patch_Number}}'>
                                                            {{$pro->Product_Code}}
                                                        </td>
                                                    @else
                                                        <input type='hidden' id="CodePurch{{$pro->id}}" name='P_Code[]' value='{{$pro->Product_Code}}'>
                                                        <input type='hidden' name='Patch_Number[]' value='{{$pro->Patch_Number}}'>
                                                    @endif




                                                    @if($show->Patch_Number == 1)
                                                        <td>{{$pro->Patch_Number}}

                                                        </td>
                                                    @endif


                                                    <td style="display: {{$avqtyshow}}" ><input type='hidden' id="AvQuntD{{$pro->id}}" name='AvQty[]' value='{{$pro->AvQty}}'>{{$pro->AvQty}}</td>
                                                    <td><input class='Qun' type='hidden' id="QuntD{{$pro->id}}"  name='Qty[]' value='{{$pro->Qty}}'>{{$pro->Qty}}</td>

                                                    <td><input type='text' name='Price[]' id="PriD{{$pro->id}}" class="form-control" onclick="TotD({{$pro->id}})" onkeyup="TotD({{$pro->id}})" value='{{$pro->Price}}'></td>
                                                    <td style="display: {{$disshow}}"><input class='Disc' id="DiscD{{$pro->id}}" type='hidden' name='Discount[]' value='{{$pro->Discount}}'>
                                                        <input type='hidden' class='TDISCOOO' id='TDiscProEdit{{$pro->id}}' name='TDiscPro[]' value='{{$pro->TDiscount}}'>{{$pro->Discount}}</td>

                                                    <td style="display: {{$totbfhow}}"><input class='TotalBFTax form-control' id="TotBFTaxD{{$pro->id}}"  type='text' name='TotalBFTax[]' value='{{$pro->Total_Bf_Tax}}' readonly></td>
                                                    <td style="display: {{$taxshow}}"><input class='TotalTax form-control' id="TaxD{{$pro->id}}" type='text' name='TotalTax[]' value='{{$pro->Total_Tax}}' readonly></td>
                                                    @if($show->Show_Total == 1)
                                                        <td><input class='Tot form-control' id="TotD{{$pro->id}}" type='text' name='Total[]' value='{{$pro->Total}}' readonly></td>
                                                    @else
                                                        <input class='Tot form-control' id="TotD{{$pro->id}}" type='hidden' name='Total[]' value='{{$pro->Total}}'>
                                                    @endif

                                                    @if($show->Show_Net == 1)
                                                        <td><input class="net form-control" type='text' id="NetD{{$pro->id}}" name='Total_Net[]' value='{{$pro->Total_Net}}' readonly></td>
                                                    @else
                                                        <input type='hidden' class="net" id="NetD{{$pro->id}}" name='Total_Net[]' value='{{$pro->Total_Net}}'>
                                                    @endif




                                                    <td style="display: {{$storeshow}}"><input  type='hidden'  id="StorePurch{{$pro->id}}" name='StorePurch[]' value='{{$pro->Store}}'>  {{app()->getLocale() == 'ar' ?$pro->Store()->first()->Name :$pro->Store()->first()->NameEn}}</td>
                                                    <input type='hidden' name='Exp_Date[]' value='{{$pro->Exp_Date}}'>
                                                    <input type='hidden'  id='costPric{{$pro->id}}'   name='CostPrice[]' value='{{$pro->CostPrice}}'>
                                                    <input type='hidden'  class='COSTPRICES' id='TotCostNew{{$pro->id}}' name='TotCostNew[]' value='{{$pro->TotCostNew}}'>


                                                    <input type='hidden'  id='weightT{{$pro->id}}'    name='weight[]' value='{{$pro->weight}}'>
                                                    <input type='hidden'  id="Product{{$pro->id}}"    name='Product[]' value='{{$pro->Product}}'>




                                                    <input type='hidden'    name='UnitRate[]' value='{{$pro->UnitRate}}'>
                                                    <input type='hidden' id='Total_Wight{{$pro->id}}'  class='W'  name='Total_Wight[]' value='{{$pro->Total_Wight}}'>




                                                    @if($show->Expire_Date == 1)

                                                        <td>
                                                            @php  $qqq=ExpireDateQty::find($pro->Exp_Date); @endphp
                                                            @if(!empty($qqq))
                                                                {{$qqq->Exp_Date}}
                                                            @endif
                                                        </td>

                                                    @endif

                                                    <input type='hidden' name='SalesProDesc[]' value='{{$pro->SalesProDesc}}'>
                                                    @if($show->Sales_Pro_Desc == 1)
                                                        <td>{{$pro->SalesProDesc}}</td>
                                                    @endif


                                                    <td>
                                                        <input type='hidden' name='PurchTax[]' value='{{$pro->Tax}}'>
                                                        <input type='hidden' id='TaxRateD{{$pro->id}}' value='{{$pro->Tax()->first()->Rate}}'>
                                                        <input type='hidden' id='TaxTypeD{{$pro->id}}' value='{{$pro->Tax()->first()->Type}}'>
                                                        <input type='hidden' id='TotBFTaxDHide{{$pro->id}}' value='{{$pro->Total_Bf_Tax}}' >
                                                        <input type='hidden' id='TaxDHide{{$pro->id}}' value='{{$pro->Total_Tax}}' >
                                                        <input type='hidden' id='TotDHide{{$pro->id}}' value='{{$pro->Total}}' >
                                                        <input type='hidden' id='Enough{{$pro->id}}' name='AllEnough[]' class='ENO'  value='0'>
                                                    </td>
                                                </tr>

                                            @endforeach


                                        @else
                                        @foreach($details as $pro)

                                            <tr>
                                                <td>

                                                    {{app()->getLocale() == 'ar' ?$pro->Product()->first()->P_Ar_Name :$pro->Product()->first()->P_En_Name}}
                                                    <input type='hidden' name='P_Ar_Name[]' value='{{$pro->Product()->first()->P_Ar_Name}}'>
                                                    <input type='hidden' name='P_En_Name[]' value='{{$pro->Product()->first()->P_En_Name}}'>

                                                    @if(!empty($pro->V1))
                                                        ( {{app()->getLocale() == 'ar' ?$pro->V1()->first()->Name :$pro->V1()->first()->NameEn}} )

                                                        <input type='hidden' name='VOne[]' value='{{$pro->V1}}'>
                                                        <input type='hidden' name='V_Name[]' value='{{$pro->V_Name}}'>

                                                    @else
                                                        <input type='hidden' name='VOne[]' value=''>
                                                        <input type='hidden' name='V_Name[]' value=''>
                                                    @endif

                                                    @if(!empty($pro->V2))
                                                        ( {{app()->getLocale() == 'ar' ?$pro->V2()->first()->Name :$pro->V2()->first()->NameEn}} )
                                                        <input type='hidden' name='VTwo[]' value='{{$pro->V2}}'>
                                                        <input type='hidden' name='VV_Name[]' value='{{$pro->VV_Name}}'>
                                                    @else
                                                        <input type='hidden' name='VTwo[]' value=''>
                                                        <input type='hidden' name='VV_Name[]' value=''>
                                                    @endif

                                                </td>

                                                @if($show->Show_Unit == 1)

                                                <td><input type='hidden' name='Unit[]' value='{{$pro->Unit}}'>{{app()->getLocale() == 'ar' ?$pro->Unit()->first()->Name :$pro->Unit()->first()->NameEn}}</td>

                                                @else
                                                    <input type='hidden' name='Unit[]' value='{{$pro->Unit}}'>
                                                @endif

                                                    @if($show->Show_Barcode == 1)
                                                <td><input type='hidden' name='P_Code[]' value='{{$pro->Product_Code}}'>
                                                    <input type='hidden' name='Patch_Number[]' value='{{$pro->Patch_Number}}'>
                                                    {{$pro->Product_Code}}
                                                </td>
                                                    @else
                                                        <input type='hidden' name='P_Code[]' value='{{$pro->Product_Code}}'>
                                                        <input type='hidden' name='Patch_Number[]' value='{{$pro->Patch_Number}}'>
                                                    @endif



                                                @if($show->Patch_Number == 1)
                                                    <td>{{$pro->Patch_Number}}

                                                    </td>
                                                @endif

                                                <td style="display: {{$avqtyshow}}" ><input type='hidden' name='AvQty[]' value='{{$pro->AvQty}}'>{{$pro->AvQty}}</td>
                                                <td><input class='Qun' type='hidden'  name='Qty[]' value='{{$pro->Qty}}'>{{$pro->Qty}}</td>

                                                <td><input type='hidden' name='Price[]' value='{{$pro->Price}}'>{{$pro->Price}}</td>
                                                <td style="display: {{$disshow}}"><input class='Disc' type='hidden' name='Discount[]' value='{{$pro->Discount}}'>  <input type='hidden' class='TDISCOOO' id='TDiscProEdit{{$pro->id}}' name='TDiscPro[]' value='{{$pro->TDiscount}}'>{{$pro->Discount}}</td>

                                                <td style="display: {{$totbfhow}}"><input class='TotalBFTax' type='hidden' name='TotalBFTax[]' value='{{$pro->Total_Bf_Tax}}'>{{$pro->Total_Bf_Tax}}</td>
                                                <td style="display: {{$taxshow}}"><input class='TotalTax' type='hidden' name='TotalTax[]' value='{{$pro->Total_Tax}}'>{{$pro->Total_Tax}}</td>
                                                @if($show->Show_Total == 1)
                                                    <td><input class='Tot' type='hidden' name='Total[]' value='{{$pro->Total}}'>{{$pro->Total}}</td>
                                                @else
                                                    <input class='Tot' type='hidden' name='Total[]' value='{{$pro->Total}}'>
                                                @endif

                                                @if($show->Show_Net == 1)
                                                    <td><input class="net" type='hidden' name='Total_Net[]' value='{{$pro->Total_Net}}'>{{$pro->Total_Net}}</td>
                                                @else
                                                    <input type='hidden' class="net" name='Total_Net[]' value='{{$pro->Total_Net}}'>
                                                @endif
                                                <td style="display: {{$storeshow}}"><input  type='hidden' name='StorePurch[]' value='{{$pro->Store}}'>  {{app()->getLocale() == 'ar' ?$pro->Store()->first()->Name :$pro->Store()->first()->NameEn}}</td>
                                                <input type='hidden' name='Exp_Date[]' value='{{$pro->Exp_Date}}'>
                                                <input type='hidden'   name='CostPrice[]' value='{{$pro->CostPrice}}'>
                                                <input type='hidden' class='COSTPRICES' id='TotCostNew{{$pro->id}}' name='TotCostNew[]' value='{{$pro->TotCostNew}}'>


                                                <input type='hidden'    name='weight[]' value='{{$pro->weight}}'>
                                                <input type='hidden'    name='Product[]' value='{{$pro->Product}}'>
                                                <input type='hidden'    name='UnitRate[]' value='{{$pro->UnitRate}}'>
                                                <input type='hidden'  class='W'  name='Total_Wight[]' value='{{$pro->Total_Wight}}'>

                                                @if($show->Expire_Date == 1)

                                                    <td>
                                                        @php  $qqq=ExpireDateQty::find($pro->Exp_Date); @endphp
                                                        @if(!empty($qqq))
                                                            {{$qqq->Exp_Date}}
                                                        @endif
                                                    </td>

                                                @endif

                                                <input type='hidden' name='SalesProDesc[]' value='{{$pro->SalesProDesc}}'>
                                                @if($show->Sales_Pro_Desc == 1)
                                                    <td>{{$pro->SalesProDesc}}</td>
                                                @endif


                                                <td>
                                                    <input type='hidden' name='PurchTax[]' value='{{$pro->Tax}}'>
                                                    <input type='hidden' id='Enough{{$pro->id}}' name='AllEnough[]' class='ENO'  value='0'>
                                                </td>
                                            </tr>

                                        @endforeach

                                        @endif
                                        </tbody>

                                    </table>
                                </div>
                                <!-- datatable end -->
                                <div class="form-row">
                                    <div class="form-group col-lg-4">
                                        <label class="form-label" for="simpleinput"> {{trans('admin.Product_Numbers')}} </label>
                                        <input type="text" id="Product_Numbers" disabled class="form-control">
                                        <input type="hidden" id="Product_NumbersHide" name="Product_Numbers">
                                    </div>
                                    <div class="form-group col-lg-4">
                                        <label class="form-label" for="simpleinput"> {{trans('admin.Total_Qty')}} </label>
                                        <input type="text" id="Total_Qty" disabled class="form-control">
                                        <input type="hidden" id="Total_QtyHide" name="Total_Qty">
                                    </div>
                                    <div class="form-group col-lg-4">
                                        <label class="form-label" for="simpleinput"> {{trans('admin.Total_Price')}}</label>
                                        <input type="text" id="Total_Price" disabled class="form-control">
                                        <input type="hidden" id="Total_PriceHide" name="Total_Price">
                                        <input type="hidden" id="Total_Bf_Taxes" disabled class="form-control">
                                        <input type="hidden" id="Total_Bf_TaxesHide" name="Total_BF_Taxes">
                                        <input type="hidden" id="Total_Discount" disabled class="form-control">
                                        <input type="hidden" id="Total_DiscountHide" name="Total_Discount">
                                        <input type="hidden" id="TotalCost" name="Total_Cost">
                                    </div>
                                    <div class="form-group col-lg-3">
                                        <label class="form-label" for="simpleinput"> {{trans('admin.Total_Taxes')}}</label>
                                        <input type="text" id="Total_Taxes" disabled class="form-control">
                                        <input type="hidden" id="Total_TaxesHide" name="Total_Taxes">
                                    </div>
                                    <div class="form-group col-lg-3">
                                        <label class="form-label" for="simpleinput"> {{trans('admin.Total_After_Taxes')}}</label>
                                        <input type="text" id="Total_After_Taxes" disabled class="form-control">
                                    </div>
                                    <div class="form-group col-lg-3">
                                        <label class="form-label" for="simpleinput"> {{trans('admin.Total_Discount')}} </label>
                                        <input type="text" id="Total_DiscountTT" disabled class="form-control">
                                        <input type="hidden" id="Total_DiscountHideTT" name="Total_Discount">
                                    </div>
                                    <div class="form-group col-lg-3">
                                        <label class="form-label" for="simpleinput"> {{trans('admin.Total_af_Discount')}} </label>
                                        <input type="text" class="form-control" id="TAFterD" disabled>
                                    </div>

                                    <div class="form-group col-lg-2">
                                        <label class="form-label" for="simpleinput"> {{trans('admin.Total_Bill')}} </label>
                                        <input type="text" id="Total_Bill" disabled class="form-control">
                                    </div>


                                    @if(auth()->guard('admin')->user()->emp == 0)
                                        <div class="form-group col-lg-2">
                                            <label class="form-label" for="simpleinput"> {{trans('admin.Discount_Bill')}} </label>
                                            <input type="text" class="form-control" id="resdiual" name="DiscountBill" value="{{$item->DiscountBill}}" onkeyup="Statuss()">
                                        </div>
                                    @else

                                        <div class="form-group col-lg-2" @if(auth()->guard('admin')->user()->bill_discount == 0) style="display: none" @endif >
                                            <label class="form-label" for="simpleinput"> {{trans('admin.Discount_Bill')}} </label>
                                            <input type="text" class="form-control" id="resdiual" name="DiscountBill" value="{{$item->DiscountBill}}" onkeyup="Statuss()">
                                        </div>

                                    @endif

                                    <div class="form-group col-lg-2">
                                        <label class="form-label" for="simpleinput"> {{trans('admin.Total_Net')}} </label>
                                        <input type="text" class="form-control" id="Total_PriceW" disabled>
                                    </div>
                                    <div class="form-group col-lg-2">
                                        <label class="form-label" for="simpleinput"> {{trans('admin.Paid')}} </label>
                                        <input type="number" step="any" name="Pay" id="paid" onkeyup="PayInstall()" onclick="PayInstall()" class="form-control">

                                    </div>
                                    @can('نسبه الربح')
                                        <div class="form-group col-lg-2">
                                            <label class="form-label" for="simpleinput"> {{trans('admin.Profit')}} </label>
                                            <input type="number" step="any" name="ProfitPrecent" id="ProfitPrecent" class="form-control" value="0" readonly>

                                        </div>
                                        <div class="form-group col-lg-2">
                                            <label class="form-label" for="simpleinput"> {{trans('admin.ProfitPrecent')}} %</label>
                                            <input type="number" step="any"  id="proPrecent" class="form-control" value="0" readonly>
                                        </div>
                                    @endcan


                                    @if($show->TaxOnTotal == 1)
                                        <div class="form-group col-lg-3">
                                            <label class="form-label" for="simpleinput"> {{trans('admin.TaxOnTotal')}} </label>
                                            <select class="select2 form-control" name="TaxOnTotal">
                                                <option value="No">{{trans('admin.No')}}</option>
                                                <option value="Yes">{{trans('admin.Yes')}}</option>
                                            </select>
                                        </div>

                                        <div class="form-group col-lg-3">
                                            <label class="form-label" for="simpleinput"> {{trans('admin.TaxOnTotalType')}} </label>
                                            <select class="select2 form-control" name="TaxOnTotalType" id="TaxOnTotalType" onchange="TaxOn()">
                                                <option value="">{{trans('admin.TaxOnTotalType')}}</option>
                                                @foreach($Taxes as $tax)
                                                    <option value="{{$tax->id}}"> {{app()->getLocale() == 'ar' ?$tax->Name :$tax->NameEn}}</option>
                                                @endforeach
                                            </select>
                                        </div>


                                        <div class="form-group col-lg-3">
                                            <label class="form-label" for="simpleinput"> {{trans('admin.ProfitTax')}} </label>
                                            <input type="text" class="form-control" id="ProfitTax" name="ProfitTax" value="0" readonly>
                                        </div>
                                    @endcan


                                    @if($Def->Total_Wight_Bill == 1)
                                        <div class="form-group col-lg-3">
                                            <label class="form-label" for="simpleinput"> {{trans('admin.Total_Wight_Bill')}} </label>
                                            <input type="number" step="any" name="Total_Wight_Bill" id="Total_Wight_Bill" class="form-control" value="0" readonly>

                                        </div>
                                    @endif
                                </div>
                                <div class="buttons mt-3" id="Submit" style="display: none">
                                    <input type="hidden" id="sp" name="SP">
                                    <button type="button"  class="btn btn-primary" onclick="SPS()"> <i class="fal fa-folder"></i> {{trans('admin.SaveChanges')}} </button>



                                </div>
                            </div>
                        </div>
                    </div>
                </div>



            </div>

        </form>
        <input type="hidden" id="ED" value="{{$show->Expire_Date}}">
        <input type="hidden" id="DISCSHOW" value="{{$show->Disc}}">
        <input type="hidden" id="TOTBFSHOW" value="{{$show->TotalBfTax}}">
        <input type="hidden" id="TAXSHOW" value="{{$show->Tax}}">
        <input type="hidden" id="STORESHOW" value="{{$show->Store}}">
        <input type="hidden" id="AVQTYSHOW" value="{{$show->AvQty}}">
        <input type="hidden" id="ALLOFDISC" value="{{$item->Total_Discount}}">
        <input type="hidden" id="Sales_Pro_Desc" value="{{$show->Sales_Pro_Desc}}">
        <input type="hidden" id="Show_Unit" value="{{$show->Show_Unit}}">
        <input type="hidden" id="Show_Barcode" value="{{$show->Show_Barcode}}">
        <input type="hidden" id="Show_Total" value="{{$show->Show_Total}}">
        <input type="hidden" id="Show_Net" value="{{$show->Show_Net}}">
        <input type="hidden" id="SHW"  value="0">

        @if($Def->Price_Sale == 0)

            @if(auth()->guard('admin')->user()->emp != 0)

                @if(auth()->guard('admin')->user()->price_sale == 1)

                    <input type="hidden" id="PRICEOPEN" value="1">
                @else

                    <input type="hidden" id="PRICEOPEN" value="0">
                @endif

            @else

                <input type="hidden" id="PRICEOPEN" value="0">
            @endif


        @else

            @if(auth()->guard('admin')->user()->emp != 0)

                @if(auth()->guard('admin')->user()->price_sale == 1)

                    <input type="hidden" id="PRICEOPEN" value="1">
                @else

                    <input type="hidden" id="PRICEOPEN" value="0">
                @endif

            @else

                <input type="hidden" id="PRICEOPEN" value="1">
            @endif




        @endif




        @if(auth()->guard('admin')->user()->emp != 0)

            @if(auth()->guard('admin')->user()->discount == 1)

                <input type="hidden" id="DISCOPEN" value="1">
            @else

                <input type="hidden" id="DISCOPEN" value="0">
            @endif

        @else

            <input type="hidden" id="DISCOPEN" value="1">
        @endif

        @if($show->Patch_Number == 1)
            <input type="hidden" id="Patch" value="1">
        @else
            <input type="hidden" id="Patch" value="0">
        @endif

        @if($Def->Discount == 0)
            <input type="hidden" id="DIS" value="0">  <!-- Number -->
        @else
            <input type="hidden" id="DIS" value="1">  <!-- Precent -->
        @endif
    </main>

    <!--         Recipt Voucher modal -->
    <div class="modal fade" id="Recipt" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        {{trans('admin.Receipt_Voucher')}}
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-3">
                            <label>{{trans('admin.Creditor')}}</label>
                            <input type="number" step="any" class="form-control" id="Creditor">
                        </div>
                        <div class="col-md-3">
                            <label>{{trans('admin.Account')}}</label>
                            <select  class="select2 form-control w-100" id="AccountCodeF" >
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="">{{trans('admin.Store')}}</label>
                            <select class="select2 form-control w-100" id="STOREF" >
                                @foreach($Stores as $stor)
                                    <option value="{{$stor->id}}" @if($Def->Store == $stor->id) selected @endif>
                                        {{app()->getLocale() == 'ar' ?$stor->Name :$stor->NameEn}}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="">{{trans('admin.Safe')}}</label>
                            <select class="select2 form-control w-100" id="SafeF">
                                @foreach($Safes as $safe)
                                    <option value="{{$safe->id}}" @if($Def->Safe == $safe->id) selected @endif>
                                        {{app()->getLocale() == 'ar' ?$safe->Name :$safe->NameEn}}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <input type="hidden" id="CoinF"  value="{{$Def->Coin}}">
                        <input type="hidden" id="DrawF"  value="{{$Def->Draw}}">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">   {{trans('admin.Close')}}</button>
                    <button type="button" class="btn btn-secondary" id="ReciptVoucher">   {{trans('admin.Save')}}</button>
                </div>
            </div>
        </div>
    </div>
    <!--         Payment Voucher modal -->
    <div class="modal fade" id="PayVouch" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        {{trans('admin.Payment_Voucher')}}
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-3">
                            <label>{{trans('admin.Debitor')}}</label>
                            <input type="number" step="any" class="form-control" id="Debitor">
                        </div>
                        <div class="col-md-3">
                            <label>{{trans('admin.Account')}}</label>
                            <select  class="select2 form-control w-100" id="AccountCodee" >
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="">{{trans('admin.Store')}}</label>
                            <select class="select2 form-control w-100" id="STOREP" >
                                @foreach($Stores as $stor)
                                    <option value="{{$stor->id}}" @if($Def->Store == $stor->id) selected @endif>
                                        {{app()->getLocale() == 'ar' ?$stor->Name :$stor->NameEn}}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="">{{trans('admin.Safe')}}</label>
                            <select class="select2 form-control w-100" id="SafeP">
                                @foreach($Safes as $safe)
                                    <option value="{{$safe->id}}" @if($Def->Safe == $safe->id) selected @endif>
                                        {{app()->getLocale() == 'ar' ?$safe->Name :$safe->NameEn}}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <input type="hidden" id="CoinP"  value="{{$Def->Coin}}">
                        <input type="hidden" id="DrawP"  value="{{$Def->Draw}}">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">   {{trans('admin.Close')}}</button>
                    <button type="button" class="btn btn-secondary" id="PaymentVoucher">   {{trans('admin.Save')}}</button>
                </div>
            </div>
        </div>
    </div>



    @if(app()->getLocale() == 'ar' )
        <input type="hidden" id="LANG" value="ar">
    @else
        <input type="hidden" id="LANG" value="en">
    @endif


    <input type="hidden" id="LOWCOSTPRICE" value="{{$Def->SalesLowCostPrice}}">
    <input type="hidden" id="LimitSalesQty" value="{{$Def->LimitSalesQty}}">
    <input type="hidden" id="Duplicate_Items" value="{{$Def->Duplicate_Items}}">
    <input type="hidden" id="RATOO" value="0">
    <input type="hidden" id="DEFAULTCOSTPRICE" value="{{$FCOST->Cost_Price}}">
    <input type="hidden" id="SHOWHIDEPRO" value="{{$Def->Hide_Product}}">

@endsection

@push('js')

    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">

    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/ERP/EditSales.js')}}"></script>


@endpush
