@extends('admin.index')
@section('content')
    @php
        use App\Models\ProductSales;
        use App\Models\ExpireDateQty;
        use App\Models\CompanyData;
        use App\Models\GeneralDaily;
        $Def=CompanyData::orderBy('id','desc')->first();
        use App\Models\DefaultDataShowHide;
        $show=DefaultDataShowHide::orderBy('id','desc')->first();
        use App\Models\ReciptVoucher;use App\Models\SalesDefaultData;
        use App\Models\ReturnSales;
        $Deff=SalesDefaultData::orderBy('id','desc')->first();
    @endphp

    <title>{{trans('admin.SalesSechdule')}}</title>


    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Sales')}}</a></li>
            <li class="breadcrumb-item active"> {{trans('admin.SalesSechdule')}} </li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
        </ol>

        <!-- Filter -->
        <div class="row">
            <div class="col-lg-12">
                <div id="panel-2" class="panel first-color">
                    <div class="panel-hdr">
                        <h2>
                            <span class="fw-300"><i> {{trans('admin.SalesSechdule')}} </i></span>
                        </h2>
                    </div>
                    <div class="panel-container show">
                        <div class="panel-content">
                            <form action="{{url('FilterBillSales')}}" method="get" class="form-row">
                                <div class="form-group col-md-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.From')}}</label>
                                    <input type="date" name="From" value="{{date('Y-m-d')}}" class="form-control"
                                           required>
                                </div>
                                <div class="form-group col-md-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.To')}}</label>
                                    <input type="date" name="To" value="{{date('Y-m-d')}}" class="form-control"
                                           required>
                                </div>
                                <div class="form-group col-md-2">
                                    <label class="form-label" for=""> {{trans('admin.Store')}} </label>
                                    <select class="select2 form-control w-100" name="Store">
                                        <option value=""> {{trans('admin.Store')}}</option>
                                        @foreach($Stores as $stor)
                                            <option value="{{$stor->id}}">
                                                {{app()->getLocale() == 'ar' ?$stor->Name :$stor->NameEn}}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group col-md-2">
                                    <label class="form-label" for=""> {{trans('admin.Account')}} </label>
                                    <select class="select2 form-control w-100" id="client" name="Client">
                                        <option value=""> {{trans('admin.Account')}}</option>

                                    </select>
                                </div>
                                <div class="form-group col-md-2">
                                    <label class="form-label" for=""> {{trans('admin.Coin')}} </label>
                                    <select class="select2 form-control w-100" name="Coin">
                                        <option value=""> {{trans('admin.Coin')}}</option>
                                        @foreach($Coins as $coin)
                                            <option value="{{$coin->id}}">

                                                {{app()->getLocale() == 'ar' ?$coin->Arabic_Name :$coin->English_Name}}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group col-md-2">
                                    <label class="form-label" for=""> {{trans('admin.Safe')}} </label>
                                    <select class="select2 form-control w-100" name="Safe">
                                        <option value=""> {{trans('admin.Safe')}}</option>
                                        @foreach($Safes as $safe)
                                            <option value="{{$safe->id}}">

                                                {{app()->getLocale() == 'ar' ?$safe->Name :$safe->NameEn}}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group col-md-2">
                                    <label class="form-label" for=""> {{trans('admin.Payment_Method')}} </label>
                                    <select class="select2 form-control w-100" name="Payment_Method">
                                        <option value=""> {{trans('admin.Payment_Method')}}</option>
                                        <option value="Cash">{{trans('admin.Cash')}} </option>
                                        <option value="Later">{{trans('admin.Later')}}</option>
                                        <option value="Installment">{{trans('admin.Installment')}}</option>
                                    </select>
                                </div>
                                <div class="form-group col-md-2">
                                    <label class="form-label" for=""> {{trans('admin.Cost_Center')}} </label>
                                    <select class="select2 form-control w-100" name="Cost_Center">

                                        <option value=""> {{trans('admin.Cost_Center')}}</option>
                                        @foreach($CostCenters as $cost)
                                            <option value="{{$cost->id}}">

                                                {{app()->getLocale() == 'ar' ?$cost->Arabic_Name :$cost->English_Name}}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group col-md-2">
                                    <label class="form-label" for=""> {{trans('admin.Delegate')}} </label>
                                    <select class="select2 form-control w-100" name="Delegate">
                                        <option value=""> {{trans('admin.Delegate')}}</option>
                                        @foreach($Employess as $emp)
                                            <option value="{{$emp->id}}">

                                                {{app()->getLocale() == 'ar' ?$emp->Name :$emp->NameEn}}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group col-md-2">
                                    <label class="form-label" for=""> {{trans('admin.Executor')}} </label>
                                    <select class="js-data-example-ajax form-control w-100" id="Emp" name="Executor">

                                    </select>
                                </div>
                                <div class="form-group col-md-2">
                                    <label class="form-label" for=""> {{trans('admin.User')}} </label>
                                    <select class="select2 form-control w-100" name="User">
                                        <option value=""> {{trans('admin.User')}}</option>
                                        @foreach($Users as $user)
                                            <option value="{{$user->id}}">
                                                {{app()->getLocale() == 'ar' ?$user->name :$user->nameEn}}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>


                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Code')}} </label>
                                    <input type="text" name="Code" class="form-control">
                                </div>

                                <div class="form-group col-md-2">
                                    <div class="buttons mt-4">
                                        <button type="submit" class="btn btn-primary show-table w-100"><i
                                                class="fal fa-folder"></i> {{trans('admin.Show')}}</button>
                                    </div>
                                </div>

                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Data -->
        <div class="row hide-table">
            <div class="col-xl-12">
                <div id="panel-1" class="panel second-color">
                    <div class="panel-hdr">
                        <h2>
                            {{trans('admin.SalesSechdule')}}
                        </h2>

                        <div class="panel-toolbar">
                            <button class="btn btn-primary btn-sm" data-toggle="dropdown">Table
                                Style
                            </button>
                            @include('admin.layouts.toolbar')
                        </div>

                    </div>
                    <div class="panel-container show">
                        <span id="ex"> @include('admin.layouts.messages')</span>
                        <div class="panel-content">

                            <!-- datatable start -->
                            <div style="overflow:auto;">
                                <table  class="table table-bordered table-hover table-striped ">
                                    <thead class="bg-highlight">
                                    <tr>
                                        <th>{{trans('admin.Code')}}</th>
                                        <th>{{trans('admin.Date')}}</th>
                                        <th> {{trans('admin.Payment_Method')}}</th>
                                        <th> {{trans('admin.Executor')}} </th>
                                        <th> {{trans('admin.Safe')}} </th>
                                        <th> {{trans('admin.Client')}} </th>
                                        <th> {{trans('admin.Delegate')}} </th>
                                        <th> {{trans('admin.Store')}} </th>
                                        <th> {{trans('admin.Sale_Type')}} </th>
                                        <th>{{trans('admin.Details')}}</th>
                                        <th>{{trans('admin.Data')}}</th>
                                        <th>{{trans('admin.ProfitPrecent')}}</th>
                                        <th class="text-center">{{trans('admin.Actions')}} </th>

                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($items as $item)
                                        <tr @if($item->Edit == 1) class="edited"
                                            @elseif($item->Delete == 1) class="deleted" @endif >
                                            <td>{{$item->Code}}</td>

                                            <td>{{$item->Date}}</td>

                                            <td>

                                                @if($item->Payment_Method == 'Cash')
                                                    {{trans('admin.Cash')}}
                                                @elseif($item->Payment_Method == 'Later')
                                                    {{trans('admin.Later')}}
                                                @elseif($item->Payment_Method == 'Delivery')
                                                    {{trans('admin.Delivery')}}
                                                @elseif($item->Payment_Method == 'Cash_Visa')
                                                    {{trans('admin.Cash_Visa')}}
                                                @elseif($item->Payment_Method == 'Visa')
                                                    {{trans('admin.Visa')}}
                                                @elseif($item->Payment_Method == 'Cash_Collection')
                                                    {{trans('admin.Cash_Collection')}}

                                                @elseif($item->Payment_Method == 'Check')

                                                    <button type="button" class="btn btn-default" data-toggle="modal"
                                                            data-target="#Check{{$item->id}}">{{trans('admin.Check')}} </button>
                                                @elseif($item->Payment_Method == 'Installment')

                                                    <button type="button" class="btn btn-default" data-toggle="modal"
                                                            data-target="#Installment{{$item->id}}">{{trans('admin.Installment')}} </button>
                                                @elseif($item->Payment_Method == 'InstallmentCompanies')

                                                    <button type="button" class="btn btn-default" data-toggle="modal"
                                                            data-target="#InstallmentCompanies{{$item->id}}">{{trans('admin.InstallmentCompanies')}} </button>
                                                @endif
                                            </td>

                                            <td>
                                                @if(!empty($item->Executor()->first()->Name))
                                                    {{app()->getLocale() == 'ar' ?$item->Executor()->first()->Name :$item->Executor()->first()->NameEn}}
                                                @endif
                                            </td>

                                            <td>
                                                @if(!empty($item->Safe()->first()->Name))
                                                    {{app()->getLocale() == 'ar' ?$item->Safe()->first()->Name :$item->Safe()->first()->NameEn}}
                                                @endif
                                            </td>
                                            <td>
                                                @if(!empty($item->Client()->first()->Name))
                                                    {{app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn}}
                                                @endif
                                            </td>
                                            <td>
                                                @if(!empty($item->Delegate()->first()->Name))

                                                    {{app()->getLocale() == 'ar' ?$item->Delegate()->first()->Name :$item->Delegate()->first()->NameEn}}
                                                @endif
                                            </td>
                                            <td>
                                                @if(!empty($item->Store()->first()->Name))
                                                    {{app()->getLocale() == 'ar' ?$item->Store()->first()->Name :$item->Store()->first()->NameEn}}
                                                @endif
                                            </td>

                                            <td>
                                                @if($item->Sale_Type  == 'POS')
                                                    {{trans('admin.POS')}}
                                                @else
                                                    {{trans('admin.Sales')}}

                                                @endif
                                            </td>


                                            <td>
                                                <button type="button" class="btn btn-default" data-toggle="modal"
                                                        data-target="#default-example-modal-center-open{{$item->id}}">
                                                    {{trans('admin.Details')}}
                                                </button>
                                            </td>


                                            <td>
                                                <button type="button" class="btn btn-primary" data-toggle="modal"
                                                        data-target="#show-data{{$item->id}}">
                                                    {{trans('admin.Data')}}
                                                </button>
                                            </td>


                                            <td>
                                                <button type="button" class="btn btn-primary" data-toggle="modal"
                                                        data-target="#ProfitPrecent{{$item->id}}">
                                                    {{trans('admin.ProfitPrecent')}}
                                                </button>
                                            </td>


                                            @php
                                                $Total_Return_Qty=ReturnSales::where('Sales',$item->id)->get()->sum('Total_Return_Qty');
                                                $Total_Qty=ProductSales::where('Sales',$item->id)->get()->sum('Original_Qty');
                                            @endphp


                                            @if($Total_Return_Qty !=$Total_Qty)

                                                <td class="text-center" style="width: 20%;">

                                                    <a href="{{url('SalesPrint/'.$item->id)}}" class="btn btn-default">
                                                        <i class="fal fa-print">A4</i>
                                                    </a>

                                                    <a href="{{url('SalesPrint5/'.$item->id)}}" class="btn btn-default">
                                                        <i class="fal fa-print">A5</i>
                                                    </a>


                                                    <a href="{{url('SalesPrint8/'.$item->id)}}" class="btn btn-default">
                                                        <i class="fal fa-print">8CM</i>
                                                    </a>


                                                    <a href="{{url('SalesTakeGoods/'.$item->id)}}"
                                                       class="btn btn-default" data-toggle="tooltip"
                                                       data-placement="top"
                                                       title="{{trans('admin.Premission_To_GoodsOut')}}">
                                                        <i class="fal fa-print"></i>
                                                    </a>


                                                    @if($item->Edit == 0 and $item->Delete == 0)
                                                        @can('ارتجاع فاتوره مبيعات')
                                                            <a href="{{url('ReturnSales/'.$item->id)}}"
                                                               class="btn btn-default"><i
                                                                    class="fal fa-arrow-right"></i></a>
                                                        @endcan

                                                        @if($item->Sale_Type  == 'POS')
                                                                @if($Settung->Edit_System == 1)
                                                            @can('تعديل فاتوره مبيعات')
                                                                @if(auth()->guard('admin')->user()->emp != 0)
                                                                    <a href="{{url('ESBillPOS/'.$item->id)}}"
                                                                       class="btn btn-default"><i
                                                                            class="fal fa-edit"></i></a>
                                                                @endif
                                                            @endcan
                                                                @endif
                                                                @if($Settung->Delete_System == 1)
                                                            @can('حذف فاتوره مبيعات')
                                                                <button type="button" class="btn btn-default"
                                                                        data-toggle="modal"
                                                                        data-target="#DeletePOS{{$item->id}}"><i
                                                                        class="fal fa-trash-alt"></i></button>
                                                            @endcan
                                                                @endif

                                                        @else


                                                               @if($Settung->Edit_System == 1)
                                                            @can('تعديل فاتوره مبيعات')
                                                                <a href="{{url('ESBill/'.$item->id)}}"
                                                                   class="btn btn-default"><i
                                                                        class="fal fa-edit"></i></a>
                                                            @endcan
                                                                @endif
                                                                 @if($Settung->Delete_System == 1)
                                                            @can('حذف فاتوره مبيعات')
                                                                <button type="button" class="btn btn-default"
                                                                        data-toggle="modal"
                                                                        data-target="#Delete{{$item->id}}"><i
                                                                        class="fal fa-trash-alt"></i></button>
                                                            @endcan
                                                        @endif
                                                        @endif


                                                        @if($item->Total_Price != $item->Pay)
                                                            @if($item->Payment_Method == 'Later')
                                                                @if($item->Later_Collection == 0)

                                                                    @can('اضافه سند قبض')
                                                                        <button type="button"
                                                                                class="btn btn-default pos-icon"
                                                                                data-toggle="modal"
                                                                                data-target="#ReciptTwo{{$item->id}}">
                                                                            <a data-toggle="tooltip"
                                                                               data-placement="top"
                                                                               title="{{trans('admin.Later_Collection')}}">
                                                                                <i class="fal fa-money-bill-alt"></i>
                                                                            </a>
                                                                        </button>
                                                                    @endcan

                                                                @endif
                                                            @endif
                                                        @endif

                                                        @if($show->client_delivery == 1)

                                                            <a href="{{url('ClientDelivery/'.$item->id)}}"
                                                               class="btn btn-default"><i class="fal fa-hands"></i></a>

                                                        @endif

                                                    @endif

                                                    @if($item->Edit == 1)
                                                        <span class="btn btn-warning">{{trans('admin.Edited_to_New_One')}} ({{$item->Edit_New_Code}})</span>
                                                    @elseif($item->Delete == 1)

                                                        <span class="btn btn-danger">{{trans('admin.Deleted')}}</span>
                                                    @endif


                                                </td>

                                            @else
                                                <td>

                                                    {{trans('admin.FullReturned')}}
                                                </td>

                                            @endif


                                        </tr>

                                    @endforeach

                                    </tbody>
                                    <tfoot>
                                    <tr>
                                        <th>{{trans('admin.Code')}}</th>
                                        <th>{{trans('admin.Date')}}</th>
                                        <th> {{trans('admin.Payment_Method')}}</th>
                                        <th> {{trans('admin.Executor')}} </th>
                                        <th> {{trans('admin.Safe')}} </th>
                                        <th> {{trans('admin.Client')}} </th>
                                        <th> {{trans('admin.Delegate')}} </th>
                                        <th> {{trans('admin.Store')}} </th>
                                        <th> {{trans('admin.Sale_Type')}} </th>
                                        <th>{{trans('admin.Details')}}</th>
                                        <th>{{trans('admin.Data')}}</th>
                                        <th>{{trans('admin.ProfitPrecent')}}</th>
                                        <th class="text-center">{{trans('admin.Actions')}} </th>

                                    </tr>
                                    </tfoot>

                                </table>

                                {{$items->Links()}}
                            </div>
                            <!-- datatable end -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>

    @foreach($items as $item)

        <!-- Modal Details -->
        <div class="modal fade" id="default-example-modal-center-open{{$item->id}}" tabindex="-1" role="dialog"
             aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">
                            {{trans('admin.Details')}}
                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>
                    <div class="modal-body">


                        @php
                            $details=ProductSales::where('Sales',$item->id)->get();
                        @endphp
                        <div class="mt-3">
                            <div style="overflow:auto">
                                <table id="details" class="table table-bordered table-hover table-striped ">
                                    <thead>
                                    <tr>
                                        <th>{{trans('admin.Code')}} </th>
                                        @if($show->Patch_Number == 1)
                                            <th>{{trans('admin.Patch_Number')}}</th>
                                        @endif
                                        <th>{{trans('admin.Name')}} </th>
                                        <th>{{trans('admin.Group')}} </th>
                                        <th>{{trans('admin.Brand')}} </th>
                                        <th>{{trans('admin.Unit')}} </th>
                                        <th>{{trans('admin.AvQty')}} </th>
                                        <th>{{trans('admin.Qty')}} </th>
                                        <th>{{trans('admin.Price')}} </th>
                                        <th>{{trans('admin.Discount')}} </th>
                                        <th>{{trans('admin.Total_Bf_Tax')}} </th>
                                        <th>{{trans('admin.Total_Tax')}} </th>
                                        <th>{{trans('admin.Total')}} </th>
                                        <th>{{trans('admin.The_Net')}} </th>
                                        <th>{{trans('admin.Store')}} </th>
                                        <th>{{trans('admin.Exp_Date')}} </th>
                                        <th>{{trans('admin.Desc')}} </th>
                                        <th>{{trans('admin.Cost')}} </th>
                                        <th>{{trans('admin.Total_Cost')}} </th>


                                    </tr>
                                    </thead>
                                    <tbody id="">
                                    @php  $bonus=0; @endphp
                                    @foreach($details as $detail)

                                        @php

                                            $fqty=$detail->Original_Qty - $detail->Qty;

                                            if($detail->Price == $detail->Discount){
                                              $bonus +=   $detail->Discount * $detail->Qty ;
                                            }
                                            $fqty=$detail->Original_Qty - $detail->Qty;
                                        @endphp
                                        <tr @if($detail->Qty == 0) style="background-color:darkred;color:white"
                                            @elseif($fqty != 0) style="background-color:#21afe4;color:white"
                                            @elseif($detail->Discount != 0) style="background-color:darkgreen;color:white" @endif>
                                            <td>
                                                @if($detail->Product()->first()->P_Type == 'Serial')

                                                   @php $proVX=\App\Models\ProductsQty::where('P_Code',$detail->Product_Code)->first();  @endphp

                                                    @if(!empty($proVX))
                                                   ( {{$proVX->ChassisNumber}} )
                                                   ( {{$proVX->MotorNumber}} )
                                                    @endif

                                                @endif

                                                {{$detail->Product_Code}}




                                            </td>
                                            @if($show->Patch_Number == 1)
                                                <td>{{$detail->Patch_Number}}</td>
                                            @endif
                                            <td>

                                                @if(!empty($detail->Product()->first()->P_Ar_Name))
                                                    {{app()->getLocale() == 'ar' ?$detail->Product()->first()->P_Ar_Name :$detail->Product()->first()->P_En_Name}}
                                                @endif

                                                @if(!empty($detail->V1()->first()->Name))
                                                    ({{app()->getLocale() == 'ar' ?$detail->V1()->first()->Name :$detail->V1()->first()->NameEn}}
                                                    )
                                                @endif
                                                @if(!empty($detail->V2()->first()->Name))
                                                    (({{app()->getLocale() == 'ar' ?$detail->V2()->first()->Name :$detail->V2()->first()->NameEn}}
                                                    ))
                                                @endif
                                            </td>
                                            <td>
                                                @if(!empty($detail->Product()->first()->Group()->first()->Name))
                                                    {{app()->getLocale() == 'ar' ?$detail->Product()->first()->Group()->first()->Name :$detail->Product()->first()->Group()->first()->NameEn}}
                                                @endif
                                            </td>
                                            <td>
                                                @if(!empty($detail->Product()->first()->Brand()->first()->Name))
                                                    {{app()->getLocale() == 'ar' ?$detail->Product()->first()->Brand()->first()->Name :$detail->Product()->first()->Brand()->first()->NameEn}}
                                                @endif
                                            </td>
                                            <td>
                                                @if(!empty($detail->Unit()->first()->Name ))
                                                    {{app()->getLocale() == 'ar' ?$detail->Unit()->first()->Name :$detail->Unit()->first()->NameEn}}
                                                @endif
                                            </td>
                                            <td>{{$detail->AvQty}}</td>
                                            <td>{{$detail->Qty}} ({{$detail->Original_Qty - $detail->Qty}})</td>
                                            <td>{{$detail->Price}}</td>
                                            <td>{{$detail->Discount}}</td>
                                            <td>{{$detail->Total_Bf_Tax}}</td>
                                            <td>{{$detail->Total_Tax}}</td>
                                            <td>{{$detail->Total}}
                                                ({{($detail->Original_Qty - $detail->Qty) * $detail->Price}})
                                            </td>
                                            <td>{{$detail->Total_Net}} </td>
                                            <td>
                                                @if(!empty($detail->Store()->first()->Name))
                                                    {{app()->getLocale() == 'ar' ?$detail->Store()->first()->Name :$detail->Store()->first()->NameEn}}
                                                @endif
                                            </td>
                                            <td>

                                                @php $qqq=ExpireDateQty::find($detail->Exp_Date); @endphp
                                                @if(!empty($qqq))
                                                    {{$qqq->Exp_Date}}
                                                @endif

                                            </td>
                                            <td>

                                                {{$detail->SalesProDesc}}

                                            </td>
                                            <td>

                                                {{$detail->CostPrice}}

                                            </td>
                                            <td>

                                                {{$detail->TotCostNew}}

                                            </td>


                                        </tr>
                                    @endforeach
                                    </tbody>
                                    <tfoot>
                                    <tr>
                                        <th>{{trans('admin.Code')}} </th>
                                        @if($show->Patch_Number == 1)
                                            <th>{{trans('admin.Patch_Number')}}</th>
                                        @endif
                                        <th>{{trans('admin.Name')}} </th>
                                        <th>{{trans('admin.Group')}} </th>
                                        <th>{{trans('admin.Brand')}} </th>
                                        <th>{{trans('admin.Unit')}} </th>
                                        <th>{{trans('admin.AvQty')}} </th>
                                        <th>{{trans('admin.Qty')}} </th>
                                        <th>{{trans('admin.Price')}} </th>
                                        <th>{{trans('admin.Discount')}} </th>
                                        <th>{{trans('admin.Total_Bf_Tax')}} </th>
                                        <th>{{trans('admin.Total_Tax')}} </th>
                                        <th>{{trans('admin.Total')}} </th>
                                        <th>{{trans('admin.The_Net')}} </th>
                                        <th>{{trans('admin.Store')}} </th>
                                        <th>{{trans('admin.Exp_Date')}} </th>
                                        <th>{{trans('admin.Desc')}} </th>
                                        <th>{{trans('admin.Cost')}} </th>
                                        <th>{{trans('admin.Total_Cost')}} </th>

                                    </tr>
                                    </tfoot>
                                </table>
                            </div>
                            <div style="overflow:auto">
                                <table class="table table-bordered table-hover table-striped mt-4">
                                    <tbody>
                                    @php
                                        $TotalReturnQty=ReturnSales::where('Sales',$item->id)->get()->sum('Total_Return_Qty');
                                        $TotalReturnBfTax=ReturnSales::where('Sales',$item->id)->get()->sum('Total_BF_Taxes');
                                        $TotalReturnTax=ReturnSales::where('Sales',$item->id)->get()->sum('Total_Taxes');
                                        $TotalReturnDiscount=ReturnSales::where('Sales',$item->id)->get()->sum('Total_Discount');
                                        $TotalReturn=ReturnSales::where('Sales',$item->id)->get()->sum('Total_Return_Value');
                                    @endphp
                                    <tr>
                                        <td>{{trans('admin.Product_Numbers')}}</td>
                                        <td>{{$item->Product_Numbers}}</td>

                                        <td>{{trans('admin.Total_Qty')}}</td>
                                        <td>{{$item->Total_Qty + $TotalReturnQty}}</td>
                                    </tr>

                                    <tr>

                                        <td>{{trans('admin.Total_Price')}}</td>
                                        <td>{{number_format((float)$item->Total_Price + $TotalReturn  , 2, '.', '')}}</td>


                                        <td>{{trans('admin.Total_Discount')}}</td>
                                        <td>{{$item->Total_Discount + $TotalReturnDiscount }}</td>


                                    </tr>

                                    <tr>


                                        <td>{{trans('admin.Total_Bf_Taxes')}}</td>
                                        <td>{{$item->Total_BF_Taxes + $TotalReturnBfTax}}</td>

                                        <td>{{trans('admin.Total_Taxes')}}</td>
                                        <td>{{$item->Total_Taxes + $TotalReturnTax}}</td>
                                    </tr>

                                    <tr>
                                        <td>{{trans('admin.Total_Net')}}</td>
                                        <td>{{$item->Total_Net}}</td>

                                        <td>{{trans('admin.Paid')}}</td>
                                        <td>{{$item->Pay}}</td>


                                    </tr>

                                    <tr>
                                        <td>{{trans('admin.Total_Return')}}</td>

                                        <td>{{$TotalReturn}}</td>

                                        <td>{{trans('admin.TotalNetReturn')}}</td>

                                        <td>{{$item->Total_Net - $TotalReturn}}</td>
                                    </tr>


                                    @if($show->TaxOnTotal == 1)
                                        <tr>
                                            <td>{{trans('admin.TaxOnTotal')}}</td>
                                            <td>{{$item->TaxOnTotal}}</td>

                                            <td>{{trans('admin.TaxOnTotalType')}}</td>
                                            <td>@if(!empty($item->TaxOnTotalType))
                                                    {{$item->TaxOnTotalType()->first()->Name}}
                                                @endif</td>

                                            <td>{{trans('admin.ProfitTax')}}</td>
                                            <td>{{$item->ProfitTax}}</td>

                                        </tr>
                                    @endif


                                    <tr>
                                        <td>{{trans('admin.Total_Return_Qty')}}</td>
                                        <td>{{$Total_Return_Qty}}</td>
                                        <td>{{trans('admin.Total_Return_BF_Taxes')}}</td>
                                        <td>{{$TotalReturnBfTax}}</td>


                                    </tr>


                                    <tr>
                                        <td>{{trans('admin.Total_Return_Taxes')}}</td>
                                        <td>{{$TotalReturnTax}}</td>
                                        <td>{{trans('admin.Total_Return_Discount')}}</td>
                                        <td>{{$TotalReturnDiscount}}</td>


                                    </tr>


                                    <tr>
                                        <td>{{trans('admin.Discount_Bill')}}</td>
                                        <td>{{$item->DiscountBill}}</td>
                                    </tr>

                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary"
                                    data-dismiss="modal">{{trans('admin.Close')}}</button>
                            @can('تعديل فاتوره مبيعات')
                                <a href="{{url('ESBill/'.$item->id)}}" class="btn btn-default"><i
                                        class="fal fa-edit"></i></a>
                            @endcan
                        </div>
                    </div>
                </div>
            </div>

        </div>



        <!-- Modal Installment -->
        <div class="modal fade" id="Installment{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">

            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">

                            <div class="row">
                                <div class="col-md-3">
                                    <label>{{trans('admin.Presenter')}}</label>
                                    <span>{{$item->presenter}}</span>
                                </div>

                                <div class="col-md-3">
                                    <label>{{trans('admin.annual_interest')}}</label>
                                    <span>{{$item->annual_interest}}</span>
                                </div>

                                <div class="col-md-3">
                                    <label>{{trans('admin.monthly_installment')}}</label>
                                    <span>{{$item->monthly_installment}}</span>
                                </div>

                                <div class="col-md-3">
                                    <label>{{trans('admin.Years_Number')}}</label>
                                    <span>{{$item->Years_Number}}</span>
                                </div>

                                <div class="col-md-3">
                                    <label>{{trans('admin.total')}}</label>
                                    <span>{{$item->total}}</span>
                                </div>

                                <div class="col-md-3">
                                    <label>{{trans('admin.installment_Num')}}</label>
                                    <span>{{$item->installment_Num}}</span>
                                </div>

                                <div class="col-md-3">
                                    <label>{{trans('admin.Date_First_installment')}}</label>
                                    <span>{{$item->Date_First_installment}}</span>
                                </div>

                            </div>


                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                                data-dismiss="modal">{{trans('admin.No')}}</button>
                    </div>
                </div>
            </div>
        </div>


        <!-- Modal Check -->
        <div class="modal fade" id="Check{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">

            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">

                            <div class="row">
                                <div class="col-md-4">
                                    <label>{{trans('admin.Check_Type')}}</label>
                                    @if(!empty($item->Check_Type()->first()->Arabic_Name))
                                        <span>

                                {{app()->getLocale() == 'ar' ?$item->Check_Type()->first()->Arabic_Name :$item->Check_Type()->first()->English_Name}}
                            </span>
                                    @endif
                                </div>

                                <div class="col-md-4">
                                    <label>{{trans('admin.Due_Date')}}</label>
                                    <span>{{$item->Due_Date}}</span>
                                </div>

                                <div class="col-md-4">
                                    <label>{{trans('admin.Check_Number')}}</label>
                                    <span>{{$item->Check_Number}}</span>
                                </div>


                            </div>


                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                                data-dismiss="modal">{{trans('admin.No')}}</button>
                    </div>
                </div>
            </div>
        </div>


        <!-- Modal InstallmentCompanies -->
        <div class="modal fade" id="InstallmentCompanies{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">

            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">

                            <div class="row">
                                <div class="col-md-3">
                                    <label>{{trans('admin.InstallCompany')}}</label>
                                    <span>@if(!empty($item->InstallCompany()->first()->Arabic_Name))

                                            {{app()->getLocale() == 'ar' ?$item->InstallCompany()->first()->Arabic_Name :$item->InstallCompany()->first()->English_Name}}
                                        @endif</span>
                                </div>

                                <div class="col-md-3">
                                    <label>{{trans('admin.ContractNumber')}}</label>
                                    <span>{{$item->ContractNumber}}</span>
                                </div>

                                <div class="col-md-3">
                                    <label>{{trans('admin.PayFees')}}</label>
                                    <span>{{$item->PayFees}}</span>
                                </div>

                                <div class="col-md-3">
                                    <label>{{trans('admin.ServiceFee')}}</label>
                                    <span>{{$item->ServiceFee}}</span>
                                </div>

                                <div class="col-md-3">
                                    <label>{{trans('admin.CompanyPrecent')}}</label>
                                    <span>{{$item->CompanyPrecent}}</span>
                                </div>


                            </div>


                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                                data-dismiss="modal">{{trans('admin.No')}}</button>
                    </div>
                </div>
            </div>
        </div>


        <!-- Modal Delete -->
        <div class="modal fade" id="Delete{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">

            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">
                            {{trans('admin.RUSWDT')}} <strong>{{$item->Code}}</strong>
                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                                data-dismiss="modal"> {{trans('admin.No')}}</button>
                        <a href="{{url('DeleteSalesBill/'.$item->id)}}"
                           class="btn btn-primary"> {{trans('admin.Yes')}}</a>
                    </div>
                </div>
            </div>
        </div>


        <!-- Modal Delete POS -->
        <div class="modal fade" id="DeletePOS{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">

            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">
                            {{trans('admin.RUSWDT')}} <strong>{{$item->Code}}</strong>
                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                                data-dismiss="modal"> {{trans('admin.No')}}</button>
                        <a href="{{url('DeleteSalesBillPOS/'.$item->id)}}"
                           class="btn btn-primary"> {{trans('admin.Yes')}}</a>
                    </div>
                </div>
            </div>
        </div>

        <!--         Later Collection modal -->
        <div class="modal fade" id="ReciptTwo{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">
                            {{trans('admin.Later_Collection')}}
                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>

                    <form action="{{url('CollectionLaterBill')}}" method="post">
                        @csrf
                        <input type="hidden" name="ID" value="{{$item->id}}">
                        <div class="modal-body">
                            <div class="row m-2">
                                <select class="select2 form-control" id="D{{$item->id}}"
                                        onchange="SHOWVOUCHER({{$item->id}})" name="DO" required>
                                    <option value="">{{trans('admin.DUWTMVoucher')}}</option>
                                    <option value="1">{{trans('admin.Yes')}}</option>
                                    <option value="2">{{trans('admin.No')}}</option>
                                </select>
                            </div>

                            <div  style="display: none" id="SS{{$item->id}}">


                            <div class="row">
                                @php $recipt=ReciptVoucher::where('Status',1)->where('Delete',null)->where('Edit',null)->where('Sales_Bill',$item->Code)->get()->sum('Total_Creditor'); @endphp
                                <div class="col-md-4">
                                    <label>{{trans('admin.Total_Recipt_Voucher_Paid')}}</label>
                                    <input type="number" step="any"   disabled class="form-control"
                                           value="{{$recipt}}">
                                </div>

                                <div class="col-md-4">
                                    <label>{{trans('admin.Net_Bill_Pay')}}</label>
                                    <input type="number" step="any"   disabled class="form-control"
                                           value="{{$item->Total_Net  - $item->Pay}}">
                                </div>
                                <div class="col-md-4">
                                    <label>{{trans('admin.Creditor')}}</label>


                                    @if(!empty($item->Pay))

                                        @if(is_numeric($item->Pay))
                                            @php $pay=$item->Pay; @endphp
                                        @else
                                            @php $pay=0; @endphp

                                        @endif

                                        <input type="number" step="any" class="form-control" name="Creditor"
                                               value="{{($item->Total_Net  - $pay) - $recipt}}">

                                    @else
                                        <input type="number" step="any" class="form-control" name="Creditor"
                                               value="{{$item->Total_Net - $recipt}}">
                                    @endif

                                </div>

                                <div class="col-md-6">
                                    <label>{{trans('admin.Account')}}</label>
                                    <select class="select2 form-control w-100" disabled>
                                        <option value=""> {{trans('admin.Account')}}</option>

                                            <option value="{{$item->Client}}"  selected >

                                                {{app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn}}
                                            </option>

                                    </select>

                                    <input type="hidden" name="Account" value="{{$item->Client}}">
                                </div>

                                <div class="form-group col-lg-4">
                                    <label class="form-label" for="">{{trans('admin.Currency')}}</label>
                                    <select class="select2 form-control w-100" name="Coin">
                                        <option value="">{{trans('admin.Currency')}}</option>
                                        @foreach($Coins as $coin)
                                            <option value="{{$coin->id}}" @if($Deff->Coin == $coin->id) selected @endif>
                                                {{app()->getLocale() == 'ar' ?$coin->Arabic_Name :$coin->English_Name}}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                                @if(auth()->guard('admin')->user()->emp == 0)
                                    <div class="form-group col-lg-4">
                                        <label class="form-label" for="">{{trans('admin.Collector')}}</label>
                                        <select class="select2 form-control w-100" name="Collector">
                                            <option value="">{{trans('admin.Collector')}}</option>
                                            @foreach($Employess as $emp)
                                                <option value="{{$emp->id}}">

                                                    {{app()->getLocale() == 'ar' ?$emp->Name :$emp->NameEn}}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                @else

                                    <input type="hidden" name="Collector"
                                           value="{{auth()->guard('admin')->user()->emp}}" class="form-control"/>
                                @endif
                                <div class="form-group col-lg-4">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Draw')}}</label>
                                    <input type="number" step="any" name="Draw" value="1" class="form-control"/>
                                </div>


                                <div class="form-group col-lg-4">

                                    <label class="form-label" for="">{{trans('admin.Safe')}} </label>
                                    <select class="select2 form-control w-100" name="Safe">
                                        <option value=""> {{trans('admin.Safe')}}</option>
                                        @foreach($Safes as $safe)
                                            <option value="{{$safe->id}}" @if($Deff->Safe == $safe->id) selected @endif>

                                                {{app()->getLocale() == 'ar' ?$safe->Name :$safe->NameEn}}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                            </div>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary"
                                    data-dismiss="modal"> {{trans('admin.Close')}}</button>
                            <button type="submit" class="btn btn-secondary"> {{trans('admin.Save')}}</button>
                        </div>
                    </form>

                </div>
            </div>
        </div>


        <!-- Modal show data -->
        <div class="modal fade" id="show-data{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">
                            {{trans('admin.Data')}}
                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div style="overflow:auto;">
                            <table id="" class="table table-bordered table-hover table-striped ">
                                <thead class="bg-highlight">
                                <tr>

                                    <th>{{trans('admin.Store_Code')}}</th>
                                    <th> {{trans('admin.Draw')}} </th>
                                    <th>{{trans('admin.Status')}} </th>
                                    <th> {{trans('admin.Refernce_Number')}} </th>
                                    <th> {{trans('admin.Notes')}} </th>
                                    <th> {{trans('admin.Later_Due')}} </th>
                                    <th> {{trans('admin.Coin')}} </th>
                                    <th> {{trans('admin.Cost_Center')}} </th>
                                    <th> {{trans('admin.Shipping_Compaines')}} </th>
                                    <th> {{trans('admin.User')}} </th>

                                    <th> {{trans('admin.ResturantOrderType')}} </th>
                                    <th> {{trans('admin.Table')}} </th>
                                    <th> {{trans('admin.File')}} </th>
                                    <th> {{trans('admin.Location')}} </th>


                                </tr>
                                </thead>
                                <tbody>

                                <tr>

                                    <td>{{$item->Store_Code}}</td>
                                    <td>{{$item->Draw}}</td>

                                    <td>

                                        @if($item->Status == 1)
                                            {{trans('admin.Recived')}}
                                        @elseif($item->Status == 0)
                                            {{trans('admin.Pending')}}
                                        @endif
                                    </td>
                                    <td>{{$item->Refernce_Number}}</td>
                                    <td>{{$item->Note}}</td>
                                    <td>

                                        {{$item->Later_Due}}
                                    </td>
                                    <td>

                                        @if(!empty($item->Coin()->first()->Arabic_Name))

                                            {{app()->getLocale() == 'ar' ?$item->Coin()->first()->Arabic_Name :$item->Coin()->first()->English_Name}}

                                        @endif
                                    </td>
                                    <td>
                                        @if(!empty($item->Cost_Center()->first()->Arabic_Name ))
                                            {{app()->getLocale() == 'ar' ?$item->Cost_Center()->first()->Arabic_Name :$item->Cost_Center()->first()->English_Name}}
                                        @endif
                                    </td>

                                    <td>
                                        @if(!empty($item->Ship()->first()->Name))

                                            {{app()->getLocale() == 'ar' ?$item->Ship()->first()->Name :$item->Ship()->first()->NameEn}}
                                        @endif
                                    </td>

                                    <td>

                                        @if(!empty($item->User()->first()->name))
                                            {{app()->getLocale() == 'ar' ?$item->User()->first()->name :$item->User()->first()->nameEn}}
                                        @endif
                                    </td>


                                    <td>


                                        {{trans('admin.'.$item->ResturantOrderType)}}

                                    </td>
                                    <td>
                                        @if(!empty($item->Table()->first()->Arabic_Name))
                                            {{app()->getLocale() == 'ar' ?$item->Table()->first()->Arabic_Name :$item->Table()->first()->English_Name}}
                                        @endif
                                    </td>


                                    <td>
                                        @if(!empty($item->File))
                                            <a href="{{URL::to($item->File)}}" class="btn btn-primary" dowmload><i
                                                    class="fal fa-download"></i></a>
                                        @endif
                                    </td>


                                    <td>

                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Loc{{$item->id}}">{{trans('admin.Location')}}</button>
                                    </td>
                                </tr>


                                </tbody>


                            </table>

                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                                data-dismiss="modal">{{trans('admin.Close')}}</button>

                    </div>
                </div>
            </div>
        </div>


        <!-- Modal ProfitPrecent -->
        <div class="modal fade" id="ProfitPrecent{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">
                            {{trans('admin.ProfitPrecent')}}











                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div style="overflow:auto;">


                            <table id="" class="table table-bordered table-hover table-striped ">
                                <thead class="bg-highlight">
                                <tr>

                                    <th>{{trans('admin.Total_Cost')}}</th>
                                    <th>{{trans('admin.Total_Price')}}</th>
                                    <th> {{trans('admin.Profit')}} </th>
                                    <th>{{trans('admin.ProfitPrecent')}} </th>


                                </tr>
                                </thead>
                                <tbody>
                                @php
                                    $TotCost=ProductSales::where('Sales',$item->id)->get()->sum('TotCostNew');
                                    $Total_Return=ReturnSales::where('Sales',$item->id)->get()->sum('Total_Return_Value');
                                @endphp
                                <tr>

                                    <td>{{$TotCost}}</td>
                                    @php $egmaly_s3r=$item->Total_Net - $Total_Return ;@endphp

                                    <td>{{$egmaly_s3r}}</td>
                                    @php
                                        $rab7=$egmaly_s3r- $TotCost;
                                        if($TotCost != 0){
                                        $Nsbtrab7=(($rab7) * 100) / $TotCost ;
                                        }else{
                                        $Nsbtrab7=(($rab7) * 100)  ;
                                        }
                                    @endphp
                                    <td>
                                        {{$item->Total_Net - $TotCost}}

                                    </td>


                                    <td>

                                        {{number_format($Nsbtrab7,2)}} %
                                    </td>

                                </tr>


                                </tbody>


                            </table>


                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                                data-dismiss="modal">{{trans('admin.Close')}}</button>

                    </div>
                </div>
            </div>
        </div>



        <!-- Modal Location -->
        <div class="modal fade" id="Loc{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-body">



                        <iframe src="https://maps.google.com/maps?q={{$item->bill_lat}},{{$item->bill_lng}}&hl=en&z=14&amp;output=embed" width="100%" height="400" frameborder="0" style="border:0" allowfullscreen></iframe>


                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>

                    </div>
                </div>
            </div>
        </div>

    @endforeach

@endsection


@push('js')
    <link rel="stylesheet" media="screen, print"
          href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">

    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable({
                // responsive: true,
                orderCellsTop: true,
                fixedHeader: true,
                lengthChange: true,

                dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                    "<'row'<'col-sm-12'tr>>" +
                    "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                buttons: [{
                    extend: 'pageLength',
                    className: 'btn-outline-default'
                },
                    {
                        extend: 'colvis',
                        text: 'Column Visibility',
                        titleAttr: 'Col visibility',
                        className: 'btn-outline-default'
                    },
                    {
                        extend: 'pdfHtml5',
                        text: 'PDF',
                        titleAttr: 'Generate PDF',
                        className: 'btn-outline-danger btn-sm mr-1'
                    },
                    {
                        extend: 'excelHtml5',
                        text: 'Excel',
                        titleAttr: 'Generate Excel',
                        className: 'btn-outline-success btn-sm mr-1'
                    },
                    {
                        extend: 'csvHtml5',
                        text: 'CSV',
                        titleAttr: 'Generate CSV',
                        className: 'btn-outline-primary btn-sm mr-1'
                    },
                    {
                        extend: 'copyHtml5',
                        text: 'Copy',
                        titleAttr: 'Copy to clipboard',
                        className: 'btn-outline-primary btn-sm mr-1'
                    },
                    {
                        extend: 'print',
                        text: 'Print',
                        titleAttr: 'Print Table',
                        className: 'btn-outline-primary btn-sm'
                    }
                ],
            });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('#details thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#details thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#details').DataTable({
                // responsive: true,
                orderCellsTop: true,
                fixedHeader: true,
                lengthChange: true,

                dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                    "<'row'<'col-sm-12'tr>>" +
                    "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                buttons: [{
                    extend: 'pageLength',
                    className: 'btn-outline-default'
                },
                    {
                        extend: 'colvis',
                        text: 'Column Visibility',
                        titleAttr: 'Col visibility',
                        className: 'btn-outline-default'
                    },
                    {
                        extend: 'pdfHtml5',
                        text: 'PDF',
                        titleAttr: 'Generate PDF',
                        className: 'btn-outline-danger btn-sm mr-1'
                    },
                    {
                        extend: 'excelHtml5',
                        text: 'Excel',
                        titleAttr: 'Generate Excel',
                        className: 'btn-outline-success btn-sm mr-1'
                    },
                    {
                        extend: 'csvHtml5',
                        text: 'CSV',
                        titleAttr: 'Generate CSV',
                        className: 'btn-outline-primary btn-sm mr-1'
                    },
                    {
                        extend: 'copyHtml5',
                        text: 'Copy',
                        titleAttr: 'Copy to clipboard',
                        className: 'btn-outline-primary btn-sm mr-1'
                    },
                    {
                        extend: 'print',
                        text: 'Print',
                        titleAttr: 'Print Table',
                        className: 'btn-outline-primary btn-sm'
                    }
                ],
            });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#details thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#details').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>

    <!-- Search Selecet -->
    <script>
        $(document).ready(function () {
            $(function () {
                $(".select2").select2();

                $(".select2-placeholder-multiple").select2({
                    placeholder: "Select State",
                });
                $(".js-hide-search").select2({
                    minimumResultsForSearch: 1 / 0,
                });
                $(".js-max-length").select2({
                    maximumSelectionLength: 2,
                    placeholder: "Select maximum 2 items",
                });
                $(".select2-placeholder").select2({
                    placeholder: "Select a state",
                    allowClear: true,
                });

                $(".js-select2-icons").select2({
                    minimumResultsForSearch: 1 / 0,
                    templateResult: icon,
                    templateSelection: icon,
                    escapeMarkup: function (elm) {
                        return elm;
                    },
                });

                function icon(elm) {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
                }

                $("#Emp").select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "AllEmps",
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {
                                    return {
                                        id: index,
                                        text: obj
                                    };
                                }),
                            };

                            console.log(data);
                        },
                        data: function (params) {


                            var query = {
                                search: params.term,
                            };


                            $.ajax({
                                url: 'AllEmpsJ/' + params.term,
                                type: "GET",
                                dataType: "json",
                                beforeSend: function () {
                                    $('#loader').css("visibility", "visible");
                                },

                                success: function (data) {
                                    $('#Emp').empty();
                                    $.each(data, function (key, value) {

                                        $('#Emp').append('<option value="' + key + '">' + value + '</option>');

                                    });
                                },
                                complete: function () {
                                    $('#loader').css("visibility", "hidden");
                                }
                            });


                        }
                    },
                });

                $("#Emp").on("select2:select", function (e) {
                    console.log("select done", e.params.data);
                });

                $("#client").select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "AllClientsFilter",
                        processResults: function(data) {
                            return {
                                results: $.map(data, function(obj, index) {

                                    return {
                                        id: index,
                                        text: obj
                                    };
                                }),
                            };

                            console.log(data);
                        },
                        data: function(params) {

                            $.ajax({
                                url: 'AllClientsFilterJS/' + params.term,
                                type: "GET",
                                dataType: "json",
                                beforeSend: function() {
                                    $('#loader').css("visibility", "visible");
                                },

                                success: function(data) {
                                    $('#client').empty();
                                    $.each(data, function(key, value) {

                                        $('#client').append('<option value="' + key + '">' + value + '</option>');

                                    });

                                    var countryId = $('#client').val();
                                    if (countryId) {
                                        $.ajax({
                                            url: 'NewAccountBalanceSOFilter/' + countryId,
                                            type: "GET",
                                            dataType: "json",
                                            beforeSend: function() {
                                                $('#loader').css("visibility", "visible");
                                            },

                                            success: function(data) {

                                                $('#AccountCredit').val(data.credit);
                                                $('#Credit_Limit').val(data.limit);

                                            },
                                            complete: function() {
                                                $('#loader').css("visibility", "hidden");
                                            }
                                        });
                                    } else {

                                        $('select[name="state"]').empty();
                                    }



                                },
                                complete: function() {
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    },
                });

                $("#client").on("select2:select", function(e) {
                    console.log("select done", e.params.data);
                });


            });
        });

    </script>


    <script>
        var autoSave = $('#autoSave');
        var interval;
        var timer = function () {
            interval = setInterval(function () {
                //start slide...
                if (autoSave.prop('checked'))
                    saveToLocal();

                clearInterval(interval);
            }, 3000);
        };

        //save
        var saveToLocal = function () {
            localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
            console.log("saved");
        }

        //delete
        var removeFromLocal = function () {
            localStorage.removeItem("summernoteData");
            $('#saveToLocal').summernote('reset');
        }

        $(document).ready(function () {
            //init default
            $('.js-summernote').summernote({
                height: 200,
                tabsize: 2,
                placeholder: "Type here...",
                dialogsFade: true,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['strikethrough', 'superscript', 'subscript']],
                    ['font', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['fontname', ['fontname']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['height', ['height']]
                        ['table', ['table']],
                    ['insert', ['link', 'picture', 'video']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ],
                callbacks: {
                    //restore from localStorage
                    onInit: function (e) {
                        $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                    },
                    onChange: function (contents, $editable) {
                        clearInterval(interval);
                        timer();
                    }
                }
            });

            //load emojis
            $.ajax({
                url: 'https://api.github.com/emojis',
                async: false
            }).then(function (data) {
                window.emojis = Object.keys(data);
                window.emojiUrls = data;
            });

            //init emoji example
            $(".js-hint2emoji").summernote({
                height: 100,
                toolbar: false,
                placeholder: 'type starting with : and any alphabet',
                hint: {
                    match: /:([\-+\w]+)$/,
                    search: function (keyword, callback) {
                        callback($.grep(emojis, function (item) {
                            return item.indexOf(keyword) === 0;
                        }));
                    },
                    template: function (item) {
                        var content = emojiUrls[item];
                        return '<img src="' + content + '" width="20" /> :' + item + ':';
                    },
                    content: function (item) {
                        var url = emojiUrls[item];
                        if (url) {
                            return $('<img />').attr('src', url).css('width', 20)[0];
                        }
                        return '';
                    }
                }
            });

            //init mentions example
            $(".js-hint2mention").summernote({
                height: 100,
                toolbar: false,
                placeholder: "type starting with @",
                hint: {
                    mentions: ['jayden', 'sam', 'alvin', 'david'],
                    match: /\B@(\w*)$/,
                    search: function (keyword, callback) {
                        callback($.grep(this.mentions, function (item) {
                            return item.indexOf(keyword) == 0;
                        }));
                    },
                    content: function (item) {
                        return '@' + item;
                    }
                }
            });

        });

    </script>
    <script type="text/javascript">
        $(".show-table").click(function () {
            $(".hide-table").show();
        });

    </script>

    <style>
        @media print {
            body * {
                visibility: hidden;
            }

            .modal-content * {
                visibility: visible;
                overflow: visible;
            }

            .main-page * {
                display: none;
            }

            .modal {
                position: absolute;
                left: 0;
                top: -220px;
                margin: 0;
                padding: 0;
                min-height: 550px;
                visibility: visible;
                overflow: visible !important;
                /* Remove scrollbar for printing. */
            }

            .modal-dialog {
                visibility: visible !important;
                overflow: visible !important;
                /* Remove scrollbar for printing. */
            }

            .page-content {
                display: none;
            }

            @page {

                size: a4;

            }

        }

    </style>


    <!-- Account Balance -->
    <script>
        function priiiint() {

            var countryId = $('#Credit').val();
            if (countryId) {
                $.ajax({
                    url: 'AccountBalanceFilter/' + countryId,
                    type: "GET",
                    dataType: "json",
                    beforeSend: function () {
                        $('#loader').css("visibility", "visible");
                    },

                    success: function (data) {
                        $.each(data, function (key, value) {

                            $('#AccountCredit').text(parseFloat(key).toFixed(2));
                            $('#AccountCredit').text(parseFloat(value).toFixed(2));


                        });
                    },
                    complete: function () {
                        $('#loader').css("visibility", "hidden");
                    }
                });
            } else {

                $('select[name="state"]').empty();
            }

        }

    </script>

    <script>
        function SHOWVOUCHER(r) {

            var d = $('#D' + r).val();

            if (parseFloat(d) == 1) {
                document.getElementById('SS' + r).style.display = 'block';
            } else {
                document.getElementById('SS' + r).style.display = 'none';
            }
        }

    </script>

@endpush
