@extends('admin.index')
@section('content')
@php
use App\Models\ProductJobOrder;
use App\Models\CompanyData;
use App\Models\GeneralDaily;
use App\Models\JobOrdersExecutors;
$Def=CompanyData::orderBy('id','desc')->first();
use App\Models\DefaultDataShowHide;
$show=DefaultDataShowHide::orderBy('id','desc')->first();
use App\Models\SalesDefaultData;
$Deff=SalesDefaultData::orderBy('id','desc')->first();
@endphp
  <title>{{trans('admin.JobOrderSechdule')}}</title>


     <main id="js-page-content" role="main" class="page-content">
                    <ol class="breadcrumb page-breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Sales')}}</a></li>
                        <li class="breadcrumb-item active"> {{trans('admin.JobOrderSechdule')}} </li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                                class="js-get-date"></span></li>
                    </ol>


            <!-- Data -->
                    <div class="row hide-table">
                        <div class="col-xl-12">
                            <div id="panel-1" class="panel second-color">
                                <div class="panel-hdr">
                                    <h2>
                                    {{trans('admin.JobOrderSechdule')}}
                                    </h2>

                                    <div class="panel-toolbar">
                                        <button class="btn btn-primary btn-sm" data-toggle="dropdown">Table
                                            Style</button>
                                        @include('admin.layouts.toolbar')
                                    </div>

                                </div>
                                <div class="panel-container show">
                              <span id="ex"> @include('admin.layouts.messages')</span>
                                    <div class="panel-content">

                                        <!-- datatable start -->
                                        <div style="overflow:auto;">
        <table id="dt-basic-example" class="table table-bordered table-hover table-striped ">
                                            <thead class="bg-highlight">
                                                <tr>
                                                    <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Date')}}</th>
                                                    <th> {{trans('admin.Payment_Method')}}</th>
                                                    <th> {{trans('admin.Executor')}} </th>
                                                    <th> {{trans('admin.Safe')}} </th>
                                                    <th> {{trans('admin.Client')}} </th>
                                                    <th> {{trans('admin.Delegate')}} </th>
                                                      <th> {{trans('admin.Store')}} </th>
                                                    <th> {{trans('admin.RecivedDate')}} </th>
                                                    <th> {{trans('admin.Recipient')}} </th>
                                                    <th>{{trans('admin.Details')}}</th>
                                                    <th>{{trans('admin.Data')}}</th>
                                                    <th class="text-center">{{trans('admin.Actions')}} </th>

                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($items as $item)
                                                <tr  @if($item->Edit == 1) class="edited" @elseif($item->Delete == 1) class="deleted" @endif>
                                                    <td>{{$item->Code}}</td>

                                                    <td>{{$item->Date}}</td>

                                                    <td>

                                                    @if($item->Payment_Method == 'Cash')
                                                       {{trans('admin.Cash')}}
                                                    @elseif($item->Payment_Method == 'Later')
                                                       {{trans('admin.Later')}}
                                                    @endif
                                                    </td>

                                                        <td>
                                                                @if(!empty($item->Executor))


                                                     {{app()->getLocale() == 'ar' ?$item->Executor()->first()->Name :$item->Executor()->first()->NameEn}}
                                                    @endif
                                                    </td>



                                                      <td>


                                         {{app()->getLocale() == 'ar' ?$item->Safe()->first()->Name :$item->Safe()->first()->NameEn}}
                                                       </td>
                                                        <td>

                                    {{app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn}}
                                                    </td>
                                                        <td>
                                                  @if(!empty($item->Delegate))

                                       {{app()->getLocale() == 'ar' ?$item->Delegate()->first()->Name :$item->Delegate()->first()->NameEn}}
                                                    @endif
                                                    </td>
                                                        <td>

                                   {{app()->getLocale() == 'ar' ?$item->Store()->first()->Name :$item->Store()->first()->NameEn}}
                                                    </td>

                                                    <td>
                         {{$item->RecivedDate}}

                                                    </td>
                                                    <td>

                                                        @if(!empty($item->Recipient))
                                   {{app()->getLocale() == 'ar' ?$item->Recipient()->first()->Name :$item->Recipient()->first()->NameEn}}
                                                        @endif
                                                    </td>
                                                    <td>
                                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center-open{{$item->id}}">
                                                            {{trans('admin.Details')}}
                                                        </button>
                                                    </td>


                                                   <td>
                                                        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#show-data{{$item->id}}">
                                                           {{trans('admin.Data')}}
                                                        </button>
                                                    </td>


                                                    @if($item->Edit == 0 and $item->Delete == 0)

                                                    <td class="text-center" style="width: 20%;">


      <button style="display: inline-block;" type="button" class="btn btn-default" data-toggle="modal" data-target="#Print{{$item->id}}"><i class="fal fa-print"></i></button>



                                                @php
                                                $jobs=JobOrdersExecutors::where('Order',$item->id)->count();
                                                $jobsZero=JobOrdersExecutors::where('Order',$item->id)->where('Status',0)->count();
                                                $jobsOne=JobOrdersExecutors::where('Order',$item->id)->where('Status',1)->count();
                                                @endphp


                                                @if($jobsZero == $jobs)

                            <form action="{{url('EditJobOrder')}}" method="post" style="display: inline-block;">
                                    @csrf
                        <input type="hidden" name="ID" value="{{$item->id}}">
             <button type="submit" class="btn btn-default" ><i class="fal fa-edit"></i></button>
                                    </form>


           <button style="display: inline-block;" type="button" class="btn btn-default" data-toggle="modal" data-target="#Delete{{$item->id}}"><i class="fal fa-trash-alt"></i></button>
                                        @endif



                               @if($jobsOne == $jobs)

                                          @if($item->ExecuteOrder == 0)


                          <form action="{{url('ExecuteJobOrder')}}" method="post" style="display: inline-block;">
                                    @csrf
                                <input type="hidden" name="ID" value="{{$item->id}}">
             <button type="submit" class="btn btn-default" ><i class="fal fa-check"></i></button>
                                    </form>



                                   @endif

                                   @endif


                                       @if($jobsOne != $jobs and $jobsZero != $jobs)

                                        {{trans('admin.WaitingToEmpExecute')}}
                                        @endif

                                                    </td>

                                                    @else

                                                        <td>
                                                        @if($item->Edit == 1)
                                                            <span class="btn btn-warning">{{trans('admin.Edited_to_New_One')}} ({{$item->Edit_New_Code}})</span>
                                                        @elseif($item->Delete == 1)

                                                            <span class="btn btn-danger">{{trans('admin.Deleted')}}</span>

                                                        @endif
                                                        </td>

                                                    @endif

                                                </tr>

                                                @endforeach

                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                        <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Date')}}</th>
                                                    <th> {{trans('admin.Payment_Method')}}</th>
                                                    <th> {{trans('admin.Executor')}} </th>
                                                    <th> {{trans('admin.Safe')}} </th>
                                                    <th> {{trans('admin.Client')}} </th>
                                                    <th> {{trans('admin.Delegate')}} </th>
                                                      <th> {{trans('admin.Store')}} </th>
                                                       <th> {{trans('admin.RecivedDate')}} </th>
                                                    <th> {{trans('admin.Recipient')}} </th>

                                                    <th>{{trans('admin.Details')}}</th>
                                                         <th>{{trans('admin.Data')}}</th>
                                                    <th class="text-center">{{trans('admin.Actions')}} </th>
                                                </tr>
                                            </tfoot>

                                        </table>

                                        {{$items->Links()}}
                                        </div>
                                        <!-- datatable end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </main>

  @foreach($items as $item)

                        <!-- Modal Details -->
    <div class="modal fade" id="default-example-modal-center-open{{$item->id}}" tabindex="-1" role="dialog"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                               {{trans('admin.Details')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">


                @php
                $details=ProductJobOrder::where('Order',$item->id)->get();
                @endphp
                        <div class="mt-3">
                             <div style="overflow:auto">
                            <table id=""
                            class="table table-bordered table-hover table-striped " >
                            <thead>
                                <tr>
                                    <th>{{trans('admin.Code')}} </th>
                                    <th>{{trans('admin.Name')}} </th>
                                     <th>{{trans('admin.Unit')}} </th>
                                    <th>{{trans('admin.Length')}} </th>
                                    <th>{{trans('admin.Width')}} </th>
                                    <th>{{trans('admin.Height')}} </th>
                                    <th>{{trans('admin.Thickness')}} </th>
                                    <th>{{trans('admin.Size')}} </th>
                                    <th>{{trans('admin.Qty')}} </th>


                            @if(auth()->guard('admin')->user()->emp == 0)

                                      <th>{{trans('admin.Price')}} </th>
                                    <th>{{trans('admin.Discount')}} </th>
                                    <th>{{trans('admin.Total_Bf_Tax')}} </th>
                                    <th>{{trans('admin.Total_Tax')}} </th>
                                    <th>{{trans('admin.Total')}} </th>

                            @else
                            @if(auth()->guard('admin')->user()->job_order_price == 1)
                                    <th>{{trans('admin.Price')}} </th>
                                    <th>{{trans('admin.Discount')}} </th>
                                    <th>{{trans('admin.Total_Bf_Tax')}} </th>
                                    <th>{{trans('admin.Total_Tax')}} </th>
                                    <th>{{trans('admin.Total')}} </th>
                            @endif

                                @endif


                                    <th>{{trans('admin.Executor')}}</th>

                                </tr>
                            </thead>
                            <tbody id="">
                                @foreach($details as $detail)
                                <tr>
                                    <td>{{$detail->Product_Code}}</td>

                                    <td>
                             {{app()->getLocale() == 'ar' ?$detail->Product()->first()->P_Ar_Name :$detail->Product()->first()->P_En_Name}}
                                    </td>

                                    <td>{{app()->getLocale() == 'ar' ?$detail->Unit()->first()->Name :$detail->Unit()->first()->NameEn}}</td>

                                    <td>{{$detail->Length}}</td>
                                    <td>{{$detail->Width}}</td>
                                    <td>{{$detail->Height}}</td>
                                    <td>{{$detail->Thickness}}</td>
                                    <td>{{$detail->Size}}</td>
                                    <td>{{$detail->Qty}}</td>


                                       @if(auth()->guard('admin')->user()->emp == 0)
                                                <td>{{$detail->Price}}</td>
                                    <td>{{$detail->Discount}}</td>
                                    <td>{{$detail->Total_Bf_Tax}}</td>
                                    <td>{{$detail->Total_Tax}}</td>
                                    <td>{{$detail->Total}}</td>
       @else
                            @if(auth()->guard('admin')->user()->job_order_price == 1)
                                                <td>{{$detail->Price}}</td>
                                    <td>{{$detail->Discount}}</td>
                                    <td>{{$detail->Total_Bf_Tax}}</td>
                                    <td>{{$detail->Total_Tax}}</td>
                                    <td>{{$detail->Total}}</td>
   @endif

                                @endif

                                   <td>

                @if(!empty($detail->Executor()->first()->Name))

            {{app()->getLocale() == 'ar' ?$detail->Executor()->first()->Name :$detail->Executor()->first()->NameEn}}
                             @endif

                                  </td>


                                </tr>
                                 @endforeach
                            </tbody>

                        </table>
                        </div>
                        <div style="overflow:auto">
                        <table class="table table-bordered table-hover table-striped mt-4">
                            <tbody>
                                <tr>
                                    <td>{{trans('admin.Product_Numbers')}}</td>
                                    <td>{{$item->Product_Numbers}}</td>

                                    <td>{{trans('admin.Total_Qty')}}</td>
                                    <td>{{$item->Total_Qty}}</td>



                                          @if(auth()->guard('admin')->user()->emp == 0)
                                                   <td>{{trans('admin.Total_Discount')}}</td>
                                    <td>{{$item->Total_Discount}}</td>

                                     <td>{{trans('admin.Total_Bf_Taxes')}}</td>
                                    <td>{{$item->Total_BF_Taxes}}</td>
       @else
  @if(auth()->guard('admin')->user()->job_order_price == 1)

                                   <td>{{trans('admin.Total_Discount')}}</td>
                                    <td>{{$item->Total_Discount}}</td>

                                     <td>{{trans('admin.Total_Bf_Taxes')}}</td>
                                    <td>{{$item->Total_BF_Taxes}}</td>
   @endif

                                @endif


                                </tr>


                    @if(auth()->guard('admin')->user()->emp == 0)
                                            @if($show->TaxOnTotal == 1)
                                 <tr>
                                    <td>{{trans('admin.TaxOnTotal')}}</td>
                                    <td>{{$item->TaxOnTotal}}</td>

                                    <td>{{trans('admin.TaxOnTotalType')}}</td>
                                    <td>@if(!empty($item->TaxOnTotalType)){{$item->TaxOnTotalType()->first()->Name}}@endif</td>

                                    <td>{{trans('admin.ProfitTax')}}</td>
                                    <td>{{$item->ProfitTax}}</td>

                                </tr>
                                @endif
                                <tr>
                                    <td>{{trans('admin.Total_Taxes')}}</td>
                                    <td>{{$item->Total_Taxes}}</td>

                                    <td>{{trans('admin.Total_Price')}}</td>
                                    <td>{{number_format((float)$item->Total_Price, 2, '.', '')}}</td>

                                    <td>{{trans('admin.Paid')}}</td>
                                    <td>{{$item->Pay}}</td>

                                     @if($show->TaxOnTotal == 1)

                                        <td>{{trans('admin.Total_Net')}}</td>



                                    <td>
                                    @if(is_numeric($item->ProfitTax))
                                        {{($item->Total_Price + $item->Total_Taxes + $item->ProfitTax) - $item->Total_Discount}}
                                    @else
                                          {{($item->Total_Price + $item->Total_Taxes + 0) - $item->Total_Discount}}
                                        @endif
                                    </td>

                            @else
                                            <td>{{trans('admin.Total_Net')}}</td>

                                    <td>
                                             @if(is_numeric($item->Total_Price))

                                        @php  $tot=$item->Total_Price; @endphp

                                        @else

                                              @php  $tot=0; @endphp
                                        @endif
                                                   @if(is_numeric($item->Total_Taxes))

                                        @php  $totTax=$item->Total_Taxes; @endphp

                                        @else

                                              @php  $totTax=0; @endphp
                                        @endif
                                                   @if(is_numeric($item->Total_Discount))

                                        @php  $totDisc=$item->Total_Discount; @endphp

                                        @else

                                              @php  $totDisc=0; @endphp
                                        @endif


                                        {{$tot + $totTax- $totDisc}}




                                    </td>
                                    @endif


                                </tr>

     @else
  @if(auth()->guard('admin')->user()->job_order_price == 1)

                                @if($show->TaxOnTotal == 1)
                                 <tr>
                                    <td>{{trans('admin.TaxOnTotal')}}</td>
                                    <td>{{$item->TaxOnTotal}}</td>

                                    <td>{{trans('admin.TaxOnTotalType')}}</td>
                                    <td>@if(!empty($item->TaxOnTotalType)){{$item->TaxOnTotalType()->first()->Name}}@endif</td>

                                    <td>{{trans('admin.ProfitTax')}}</td>
                                    <td>{{$item->ProfitTax}}</td>

                                </tr>
                                @endif
                                <tr>
                                    <td>{{trans('admin.Total_Taxes')}}</td>
                                    <td>{{$item->Total_Taxes}}</td>

                                    <td>{{trans('admin.Total_Price')}}</td>
                                    <td>{{number_format((float)$item->Total_Price, 2, '.', '')}}</td>

                                    <td>{{trans('admin.Paid')}}</td>
                                    <td>{{$item->Pay}}</td>

                                     @if($show->TaxOnTotal == 1)

                                        <td>{{trans('admin.Total_Net')}}</td>
                                    <td>{{($item->Total_Price + $item->Total_Taxes + $item->ProfitTax) - $item->Total_Discount}}</td>

                            @else
                                            <td>{{trans('admin.Total_Net')}}</td>
                                    <td>{{$item->Total_Price + $item->Total_Taxes - $item->Total_Discount}}</td>
                                    @endif


                                </tr>

   @endif

                                @endif


                            </tbody>
                        </table>
                        </div>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>

                        </div>
                    </div>
                </div>
            </div>

            </div>



          <!-- Modal Delete -->
                    <div class="modal fade" id="Delete{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">

                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">
                                    {{trans('admin.RUSWDT')}} <strong>{{$item->Code}}</strong>
                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>
                                <div class="modal-footer">
                 <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                   <a href="{{url('DeleteJobOrder/'.$item->id)}}"  class="btn btn-primary"> {{trans('admin.Yes')}}</a>
                                </div>
                            </div>
                        </div>
                    </div>



    <!-- Modal show data -->
    <div class="modal fade" id="show-data{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                             {{trans('admin.Data')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">
      <div style="overflow:auto;">
        <table id="" class="table table-bordered table-hover table-striped ">
                                            <thead class="bg-highlight">
                                                <tr>


                              <th> {{trans('admin.Draw')}} </th>

                               <th> {{trans('admin.Refernce_Number')}} </th>
                                    <th> {{trans('admin.Notes')}} </th>

                               <th> {{trans('admin.Coin')}} </th>
                                  <th> {{trans('admin.Cost_Center')}} </th>

                                     <th> {{trans('admin.User')}} </th>




                                                </tr>
                                            </thead>
                                            <tbody>

                                                <tr>


                                                    <td>{{$item->Draw}}</td>

       <td>{{$item->Refernce_Number}}</td>
      <td>{{$item->Note}}</td>

      <td>


                                       {{app()->getLocale() == 'ar' ?$item->Coin()->first()->Arabic_Name :$item->Coin()->first()->English_Name}}
                                                    </td>
                                                            <td>
                                                     @if(!empty($item->Cost_Center))
                                                    {{app()->getLocale() == 'ar' ?$item->Cost_Center()->first()->Arabic_Name :$item->Cost_Center()->first()->English_Name}}
                                                    @endif
                                                    </td>



                                                                     <td>


                      {{app()->getLocale() == 'ar' ?$item->User()->first()->name :$item->User()->first()->nameEn}}
                                                    </td>



                                                </tr>


                                            </tbody>


                                        </table>

                                        </div>

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>

                        </div>
                    </div>
                </div>
            </div>



    <!-- Modal Print -->
    <div class="modal fade" id="Print{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                             {{trans('admin.Print')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">

                                   @if(auth()->guard('admin')->user()->emp == 0)
      <a href="{{url('JobOrderPrint/'.$item->id)}}" class="btn btn-default" >
                                                    <i class="fal fa-print">A4</i>
                                                    </a>

                          <a href="{{url('JobOrderPrint5/'.$item->id)}}" class="btn btn-default" >
                                                    <i class="fal fa-print">A5</i>
                                                    </a>


                          <a href="{{url('JobOrderPrint8/'.$item->id)}}" class="btn btn-default" >
                                                    <i class="fal fa-print">8CM</i>
                                                    </a>
                                                        @endif

                                        <a href="{{url('JobOrderPrintEmp8/'.$item->id)}}" class="btn btn-default" >
                                                    <i class="fal fa-print">{{trans('admin.EmpPrint')}} 8CM</i>

                                                    </a>


                                            <a href="{{url('JobOrderPrintEmp/'.$item->id)}}" class="btn btn-default" >
                                                    <i class="fal fa-print">{{trans('admin.EmpPrint')}} A4</i>

                                                    </a>

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>

                        </div>
                    </div>
                </div>
            </div>




@endforeach



@endsection


@push('js')
       <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">

  <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search '  + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    // responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>

 <!-- Search Selecet -->
<script>
    $(document).ready(function () {
        $(function () {
            $(".select2").select2();

            $(".select2-placeholder-multiple").select2({
                placeholder: "Select State",
            });
            $(".js-hide-search").select2({
                minimumResultsForSearch: 1 / 0,
            });
            $(".js-max-length").select2({
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items",
            });
            $(".select2-placeholder").select2({
                placeholder: "Select a state",
                allowClear: true,
            });

            $(".js-select2-icons").select2({
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function (elm) {
                    return elm;
                },
            });

            function icon(elm) {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
            }

            $("#Emp").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "AllEmps",
                    processResults: function (data) {
                        return {
                            results: $.map(data, function (obj, index) {
                                return { id: index, text: obj };
                            }),
                        };

                        console.log(data);
                    },
                  data: function (params) {


                   var query = {
                            search: params.term,
                        };


              $.ajax({
                              url: 'AllEmpsJ/'+params.term,
                              type:"GET",
                              dataType:"json",
                              beforeSend: function(){
                                  $('#loader').css("visibility", "visible");
                              },

                              success:function(data) {
                                          $('#Emp').empty();
                                  $.each(data, function(key, value){

                         $('#Emp').append('<option value="'+ key +'">' + value + '</option>');

                                  });
                              },
                              complete: function(){
                                  $('#loader').css("visibility", "hidden");
                              }
                          });



        }
                },
            });

            $("#Emp").on("select2:select", function (e) {
                console.log("select done", e.params.data);
            });






        });
    });
</script>


<script>
    var autoSave = $('#autoSave');
    var interval;
    var timer = function()
    {
        interval = setInterval(function()
        {
            //start slide...
            if (autoSave.prop('checked'))
                saveToLocal();

            clearInterval(interval);
        }, 3000);
    };

    //save
    var saveToLocal = function()
    {
        localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
        console.log("saved");
    }

    //delete
    var removeFromLocal = function()
    {
        localStorage.removeItem("summernoteData");
        $('#saveToLocal').summernote('reset');
    }

    $(document).ready(function()
    {
        //init default
        $('.js-summernote').summernote(
        {
            height: 200,
            tabsize: 2,
            placeholder: "Type here...",
            dialogsFade: true,
            toolbar: [
                ['style', ['style']],
                ['font', ['strikethrough', 'superscript', 'subscript']],
                ['font', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['height', ['height']]
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ],
            callbacks:
            {
                //restore from localStorage
                onInit: function(e)
                {
                    $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                },
                onChange: function(contents, $editable)
                {
                    clearInterval(interval);
                    timer();
                }
            }
        });

        //load emojis
        $.ajax(
        {
            url: 'https://api.github.com/emojis',
            async: false
        }).then(function(data)
        {
            window.emojis = Object.keys(data);
            window.emojiUrls = data;
        });

        //init emoji example
        $(".js-hint2emoji").summernote(
        {
            height: 100,
            toolbar: false,
            placeholder: 'type starting with : and any alphabet',
            hint:
            {
                match: /:([\-+\w]+)$/,
                search: function(keyword, callback)
                {
                    callback($.grep(emojis, function(item)
                    {
                        return item.indexOf(keyword) === 0;
                    }));
                },
                template: function(item)
                {
                    var content = emojiUrls[item];
                    return '<img src="' + content + '" width="20" /> :' + item + ':';
                },
                content: function(item)
                {
                    var url = emojiUrls[item];
                    if (url)
                    {
                        return $('<img />').attr('src', url).css('width', 20)[0];
                    }
                    return '';
                }
            }
        });

        //init mentions example
        $(".js-hint2mention").summernote(
        {
            height: 100,
            toolbar: false,
            placeholder: "type starting with @",
            hint:
            {
                mentions: ['jayden', 'sam', 'alvin', 'david'],
                match: /\B@(\w*)$/,
                search: function(keyword, callback)
                {
                    callback($.grep(this.mentions, function(item)
                    {
                        return item.indexOf(keyword) == 0;
                    }));
                },
                content: function(item)
                {
                    return '@' + item;
                }
            }
        });

    });

</script>
<script type="text/javascript">


    $(".show-table").click(function(){
        $(".hide-table").show();
    });

</script>

	<style>
	@media print {
		body * {
			visibility: hidden;
		}
		.modal-content * {
			visibility: visible;
			overflow: visible;
		}
		.main-page * {
			display: none;
		}
		.modal {
			position: absolute;
			left: 0;
			top: -220px;
			margin: 0;
			padding: 0;
			min-height: 550px;
			visibility: visible;
			overflow: visible !important; /* Remove scrollbar for printing. */
		}
		.modal-dialog {
			visibility: visible !important;
			overflow: visible !important; /* Remove scrollbar for printing. */
		}

        .page-content{
            display:none;
        }
        @page {

		size: a4;

    }

	}
	</style>


<!-- Account Balance -->
<script>
    function priiiint() {

                      var countryId = $('#Credit').val();
                      if(countryId) {
                          $.ajax({
                              url: 'AccountBalanceFilter/'+countryId,
                              type:"GET",
                              dataType:"json",
                              beforeSend: function(){
                                  $('#loader').css("visibility", "visible");
                              },

                              success:function(data) {
                                  $.each(data, function(key, value){

                    $('#AccountCredit').text(parseFloat(key).toFixed(2));
                    $('#AccountCredit').text(parseFloat(value).toFixed(2));



                                  });
                              },
                              complete: function(){
                                  $('#loader').css("visibility", "hidden");
                              }
                          });
                      } else {

                          $('select[name="state"]').empty();
                      }

    }
</script>

<script>
    function SHOWVOUCHER(r){

         var d =$('#D'+r).val();

        if(parseFloat(d) == 1){
            document.getElementById('SS'+r).style.display='block';
        }else{
            document.getElementById('SS'+r).style.display='none';
        }
    }
</script>

@endpush
