@extends('admin.index')
@section('content')

<style>
    .customize-input {
        font-size: unset;
    }

</style>
<title>{{trans('admin.Add_Clients')}}</title>
<main id="js-page-content" role="main" class="page-content">
    <ol class="breadcrumb page-breadcrumb">
        <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Sales')}} </a></li>
        <li class="breadcrumb-item active">{{trans('admin.Add_Clients')}} </li>
        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
    </ol>
    <div class="row">
        <div class="col-xl-12">
            <div class="panel">
                <div class="panel-container show">
                    <span id="ex"> @include('admin.layouts.messages')</span>
                    <div class="panel-content">
                        <div class="modal-header">
                            <h5 class="modal-title">{{trans('admin.Add_Clients')}} </h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="panel-container show">
                            <div class="panel-content">
                                <ul class="nav nav-tabs" role="tablist">
                                    <li class="nav-item">
                                        <a class="nav-link active" data-toggle="tab" href="#tab_borders_icons-1" role="tab"><i class="fal fa-home mr-1"></i> {{trans('admin.Main')}} </a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" data-toggle="tab" href="#tab_borders_icons-2" role="tab"><i class="fal fa-user mr-1"></i> {{trans('admin.Sub')}}</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" data-toggle="tab" href="#tab_borders_icons-4" role="tab"><i class="fal fa-user mr-1"></i> {{trans('admin.Trading_Data')}}</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" data-toggle="tab" href="#tab_borders_icons-3" role="tab"><i class="fal fa-user mr-1"></i> {{trans('admin.Addresses')}}</a>
                                    </li>
                                </ul>
                                <form action="{{url('PostAddClients')}}" method="post" enctype="multipart/form-data">
                                    {!! csrf_field() !!}
                                    @honeypot
                                    <div class="tab-content border border-top-0 p-3">
                                        <div class="tab-pane fade show active" id="tab_borders_icons-1" role="tabpanel">
                                            <div class="form-row">
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Code')}}</label>
                                                    <input type="text" value="{{$Code}}" disabled class="form-control">
                                                    <input type="hidden" name="Code" value="{{$Code}}">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput">{{trans('admin.Date')}} </label>
                                                    <input type="date" name="Date" value="{{date('Y-m-d')}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Arabic_Name')}} </label><span class="strick">*</span>
                                                    <input type="text" name="Name" value="{{old('Name')}}" class="form-control" required>
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.English_Name')}} </label><span class="strick">*</span>
                                                    <input type="text" name="NameEn" value="{{old('NameEn')}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for=""> {{trans('admin.Price_Level')}} </label><span class="strick">*</span>
                                                    <select class="select2 form-control w-100" name="Price_Level" required>
                                                        <option value=""> {{trans('admin.Price_Level')}} </option>
                                                        <option value="1" @if($Def->Price_Level == 1) selected @endif > {{trans('admin.Level1')}} </option>
                                                        <option value="2" @if($Def->Price_Level == 2) selected @endif> {{trans('admin.Level2')}} </option>
                                                        <option value="3" @if($Def->Price_Level == 3) selected @endif> {{trans('admin.Level3')}} </option>
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Phone')}} </label>
                                                    <input type="number" name="Phone" value="{{old('Phone')}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Email')}} </label>
                                                    <input type="email" name="email" value="{{old('email')}}" class="form-control">
                                                </div>

                                            </div>
                                            <div class="form-row mt-3">
                                                <div class="form-group col-md-3">
                                                    <label class="form-label" for=""> {{trans('admin.Group')}} </label>
                                                    <select class="select2 form-control w-100" name="Group" required>
                                                        <option value="">{{trans('admin.Group')}}</option>
                                                        @foreach($Groups as $g)
                                                        <option value="{{$g->id}}" @if($Def->ClientGroup == $g->id) selected @endif>

                                                            {{app()->getLocale() == 'ar' ?$g->Arabic_Name :$g->English_Name}}
                                                        </option>
                                                        @endforeach
                                                    </select>
                                                </div>

                                                <div class="form-group col-md-3">
                                                    <label class="form-label" for=""> {{trans('admin.ClientStatus')}}</label>
                                                    <select class="select2 form-control w-100" name="ClientStatus">
                                                        <option value="">{{trans('admin.ClientStatus')}}</option>
                                                        @foreach($ClientStatus as $cls)
                                                        <option value="{{$cls->id}}" @if($Def->ClientStatus == $cls->id) selected @endif >

                                                            {{app()->getLocale() == 'ar' ?$cls->Arabic_Name :$cls->English_Name}}
                                                        </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-3">
                                                    <label class="form-label" for=""> {{trans('admin.Platforms')}} </label>
                                                    <select class="select2 form-control w-100" id="Platform" name="Platform">
                                                        <option value="">{{trans('admin.Platforms')}}</option>
                                                        @foreach($Platforms as $pl)
                                                        <option value="{{$pl->id}}" @if($Def->Platforms == $pl->id) selected @endif>

                                                            {{app()->getLocale() == 'ar' ?$pl->Arabic_Name :$pl->English_Name}}
                                                        </option>
                                                        @endforeach
                                                    </select>
                                                </div>

                                                <div class="form-group col-md-3">
                                                    <label class="form-label" for=""> {{trans('admin.Campagin')}} </label>
                                                    <select class="select2 form-control w-100" id="Campagin" name="Campagin">
                                                        @if(!empty($Def->Campagin))
                                                        <option value="{{$Def->Campagin}}">
                                                            {{app()->getLocale() == 'ar' ?$Def->Campagin()->first()->Arabic_Name :$Def->Campagin()->first()->Arabic_Name}}
                                                        </option>
                                                        @endif
                                                    </select>
                                                </div>



                                            </div>

                                            <div class="form-row mt-4">
                                                <div class="form-group col-md-3">
                                                    <label class="form-label" for=""> {{trans('admin.Activity')}}</label>
                                                    <select class="select2 form-control w-100" name="Activity">
                                                        <option value="">{{trans('admin.Activity')}}</option>
                                                        @foreach($Activites as $act)
                                                        <option value="{{$act->id}}" @if($Def->Activity == $act->id) selected @endif>

                                                            {{app()->getLocale() == 'ar' ?$act->Arabic_Name :$act->English_Name}}
                                                        </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label class="form-label" for=""> {{trans('admin.Responsible')}}</label>
                                                    <select class="select2 form-control w-100" name="Responsible">
                                                        <option value="">{{trans('admin.Responsible')}}</option>
                                                        @foreach($Employess as $emp)
                                                        <option value="{{$emp->id}}" @if($Def->Responsible == $emp->id) selected @endif>

                                                            {{app()->getLocale() == 'ar' ?$emp->Name :$emp->NameEn}}
                                                        </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label class="form-label" for="simpleinput">{{trans('admin.Address')}} </label>
                                                    <input type="text" name="Address" value="{{old('Address')}}" class="form-control">
                                                </div>

                                                <div class="form-group col-lg-4">
                                                    <label class="form-label" for=""> {{trans('admin.Governrate')}}</label>
                                                    <select class="select2 form-control w-100 Governrate" name="Governrate">
                                                        <option value="">{{trans('admin.Governrate')}}</option>
                                                        @foreach($Governrates as $gov)
                                                            <option value="{{$gov->id}}">

                                                                {{app()->getLocale() == 'ar' ?$gov->Arabic_Name :$gov->English_Name}}
                                                            </option>
                                                        @endforeach
                                                    </select>


                                                </div>


                                                <div class="form-group col-lg-4">
                                                    <label class="form-label" for=""> {{trans('admin.City')}}</label>
                                                    <select class="select2 form-control w-100 City" name="City">

                                                    </select>

                                                </div>


                                                <div class="form-group col-lg-4">
                                                    <label class="form-label" for=""> {{trans('admin.Place')}}</label>
                                                    <select class="select2 form-control w-100 Place" name="Place">

                                                    </select>

                                                </div>



                                                <div class="form-group col-lg-6">
                                                    <button type="button" onclick="getLocation()" class="btn btn-primary"> {{trans('admin.Location')}}</button><br><br>
                                                    <div id="map"></div>
                                                    <input type="hidden" name="Lat" id="latInput" readonly>
                                                    <input type="hidden" name="Lang" id="lonInput" readonly>
                                                </div>


                                                <div class="form-group col-lg-6">
                                                    <label class="form-label" for=""> {{trans('admin.Guarantor')}}</label>
                                                    <select class="select2 form-control w-100" id="Guarantor" name="Guarantor">

                                                    </select>
                                                </div>













                                            </div>
                                        </div>



                                        <div class="tab-pane fade" id="tab_borders_icons-2" role="tabpanel">
                                            <div class="form-row">
                                                <div class="form-group col-md-3">
                                                    <label class="form-label" for=""> {{trans('admin.Executions_Status')}}</label>
                                                    <select class="select2 form-control w-100" name="Executions_Status">
                                                        <option value="potential_client">{{trans('admin.potential_client')}}</option>
                                                        <option value="new_client">{{trans('admin.new_client')}}</option>
                                                        <option value="pending">{{trans('admin.pending')}}</option>
                                                        <option value="former">{{trans('admin.former')}}</option>
                                                        <option value="important">{{trans('admin.important')}}</option>
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-3">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Repayment_Period')}} </label>
                                                    <input type="number" name="Repayment_Period" value="30" class="form-control">
                                                </div>
                                                <div class="form-group col-md-3">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.ID_Number')}} </label>
                                                    <input type="number" name="ID_Number" value="{{old('ID_Number')}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Respon_Person')}} </label>
                                                    <input type="text"  name="Respon_Person" value="{{old('Respon_Person')}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Respon_Person_Phone')}} </label>
                                                    <input type="tel"  name="Respon_Person_Phone" value="{{old('Respon_Person_Phone')}}" class="form-control">
                                                </div>
                                                           <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Operating_Date')}} </label>
                                                    <input type="date"  name="Operating_Date" value="{{old('Operating_Date')}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Activation_Serial')}} </label>
                                                    <input type="text"  name="Activation_Serial" value="{{old('Activation_Serial')}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Activation_Code')}} </label>
                                                    <input type="text"  name="Activation_Code" value="{{old('Activation_Code')}}" class="form-control">
                                                </div>



                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Credit_Limit')}} </label>
                                                    <input type="number" step="any" name="Credit_Limit" value="{{old('Credit_Limit')}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Qualifications')}} </label>
                                                    <input type="text" name="Qualifications" value="{{old('Qualifications')}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Birthdate')}} </label>
                                                    <input type="date" name="Birthdate" value="{{old('Birthdate')}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Social_Status')}} </label>
                                                    <input type="text" name="Social_Status" value="{{old('Social_Status')}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Passport_Number')}} </label>
                                                    <input type="text" name="Passport_Number" value="{{old('Passport_Number')}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Contract_Strat')}} </label>
                                                    <input type="date" name="Contract_Start" value="{{old('Contract_Start')}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Contract_End')}} </label>
                                                    <input type="date" name="Contract_End" value="{{old('Contract_End')}}" class="form-control">
                                                </div>
                                            </div>
                                            <div class="form-row">
                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Company_Name')}} </label>
                                                    <input type="text" name="Company_Name" value="{{old('Company_Name')}}" class="form-control">
                                                </div>

                                                <div class="form-group col-md-2">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Bank_Account')}} </label>
                                                    <input type="text" name="Bank_Account" value="{{old('Bank_Account')}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2 mb-2">
                                                    <label class="form-label customize-input" for="imgInp"><i class="fal fa-image"></i> {{trans('admin.Image')}} </label>
                                                    <input type="file" name="Image">
                                                </div>
                                                <div class="form-group col-md-2 mb-2" style="margin-top:7px;">
                                                    <label class="form-label" for=""> {{trans('admin.Client_Paper')}} </label>
                                                    <input type="file" name="File[]" multiple>
                                                </div>
                                                <div class="form-group col-md-2 mb-2">
                                                    <label class="form-label" for=""> {{trans('admin.Phone2')}} </label>
                                                    <input type="tel" name="Phone2" value="{{old('Phone2')}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2 mb-2">
                                                    <label class="form-label" for=""> {{trans('admin.Phone3')}} </label>
                                                    <input type="tel" name="Phone3" value="{{old('Phone3')}}" class="form-control">
                                                </div>

                                                <div class="form-group col-md-2 mb-2">
                                                    <label class="form-label" for=""> {{trans('admin.Phone4')}} </label>
                                                    <input type="tel" name="Phone4" value="{{old('Phone4')}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2 mb-2">
                                                    <label class="form-label" for=""> {{trans('admin.SearchCode')}} </label>
                                                    <input type="text" name="SearchCode" value="{{old('SearchCode')}}" class="form-control">
                                                </div>

                                                <div class="form-group col-lg-4">
                                                    <label class="form-label" for=""> ({{trans('admin.Product')}})</label>
                                                    <select class="select2 form-control w-100" id="product" name="Product">

                                                    </select>
                                                </div>

                                                <div class="form-group col-lg-4" style="margin-top:23px;">

                                                    <select class="select2 form-control w-100" name="Warranty">
                                                        <option value="">{{trans('admin.Warranty')}}</option>
                                                        <option value="Yes">{{trans('admin.Yes')}}</option>
                                                        <option value="No">{{trans('admin.No')}}</option>
                                                    </select>


                                                </div>




                                            </div>
                                        </div>
                                        <div class="tab-pane fade" id="tab_borders_icons-4" role="tabpanel">

                                            <div class="form-row">
                                                <div class="form-group col-md-4">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Commercial_Registration_No')}} </label>
                                                    <input type="number" name="Commercial_Registration_No" value="{{old('Commercial_Registration_No')}}" class="form-control">
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label class="form-label" for="simpleinput"> {{trans('admin.Tax_Card_No')}} </label>
                                                    <input type="number" name="Tax_Card_No" value="{{old('Tax_Card_No')}}" class="form-control">
                                                </div>



                                                <div class="form-group col-md-4">
                                                    <label class="form-label" for=""> {{trans('admin.Tax_Registration_Number')}} </label>
                                                    <input type="text" name="Tax_Registration_Number" value="{{old('Tax_Registration_Number')}}" class="form-control">
                                                </div>


                                                <div class="form-group col-md-4">
                                                    <label class="form-label" for=""> {{trans('admin.Tax_activity_code')}} </label>
                                                    <input type="text" name="Tax_activity_code" class="form-control">
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label class="form-label" for=""> {{trans('admin.work_nature')}} </label>
                                                    <select class="select2 form-control" name="work_nature">
                                                        <option value="P">{{trans('admin.Person')}}</option>
                                                        <option value="B">{{trans('admin.Egyptian_trading_company')}}</option>
                                                        <option value="F">{{trans('admin.foreign_trading_company')}}</option>
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label class="form-label" for=""> {{trans('admin.Nationality')}} </label>
                                                    <select class="select2 form-control w-100" name="Nationality">

                                                        @foreach($Nationality as $nation)
                                                        <option value="{{$nation->id}}">

                                                            {{app()->getLocale() == 'ar' ?$nation->Arabic_Name :$nation->English_Name}}
                                                        </option>
                                                        @endforeach
                                                    </select>
                                                </div>


                                                <div class="form-group col-md-4">
                                                    <label class="form-label" for=""> {{trans('admin.Buliding_Num')}} </label>
                                                    <input type="text" name="Buliding_Num" class="form-control">
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label class="form-label" for=""> {{trans('admin.Street')}} </label>
                                                    <input type="text" name="Street" class="form-control">
                                                </div>

                                                <div class="form-group col-md-4">
                                                    <label class="form-label" for=""> {{trans('admin.Postal_Code')}} </label>
                                                    <input type="text" name="Postal_Code" class="form-control">
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label class="form-label" for=""> {{trans('admin.tax_magistrate')}} </label>
                                                    <input type="text" name="tax_magistrate" class="form-control">
                                                </div>

                                                <div class="form-group col-md-4">
                                                    <label class="form-label" for=""> {{trans('admin.Floor')}} </label>
                                                    <input type="text" name="Floor" class="form-control">
                                                </div>


                                                <div class="form-group col-md-4">
                                                    <label class="form-label" for=""> {{trans('admin.Room')}} </label>
                                                    <input type="text" name="Room" class="form-control">
                                                </div>


                                                <div class="form-group col-md-4">
                                                    <label class="form-label" for=""> {{trans('admin.Landmark')}} </label>
                                                    <input type="text" name="Landmark" class="form-control">
                                                </div>


                                                <div class="form-group col-md-4">
                                                    <label class="form-label" for=""> {{trans('admin.Add_Info')}} </label>
                                                    <input type="text" name="Add_Info" class="form-control">
                                                </div>


                                            </div>
                                        </div>
                                        <div class="tab-pane fade" id="tab_borders_icons-3" role="tabpanel">
                                            <div class="panel-container show">
                                                <div class="panel-content">
                                                    <div id="mobile-overflow">
                                                        <table class="table table-bordered table-hover table-striped w-100 mobile-width th-width">
                                                            <thead>
                                                                <tr>
                                                                    <th>{{trans('admin.Name')}}</th>
                                                                    <th>{{trans('admin.Governrate')}}</th>
                                                                    <th>{{trans('admin.City')}}</th>
                                                                    <th>{{trans('admin.Place')}}</th>
                                                                    <th>{{trans('admin.Street')}}</th>
                                                                    <th>{{trans('admin.Buliding')}}</th>
                                                                    <th>{{trans('admin.Floor')}}</th>
                                                                    <th>{{trans('admin.Flat')}}</th>
                                                                    <th>{{trans('admin.Special_Mark')}} </th>
                                                                    <th>{{trans('admin.Location')}} </th>
                                                                    <th>{{trans('admin.Address_Details')}} </th>
                                                                    <th>{{trans('admin.Actions')}}</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <tr>
                                                                    <td>
                                                                        <input type="text" id="Naame" class="form-control">
                                                                    </td>
                                                                    <td>
                                                                        <div class="form-group">

                                                                            <select class="select2 form-control w-100" id="Governrate">
                                                                                <option value="">{{trans('admin.Governrate')}}</option>
                                                                                @foreach($Governrates as $gov)
                                                                                <option value="{{$gov->id}}" @if($Def->Governrate == $gov->id) selected @endif >

                                                                                    {{app()->getLocale() == 'ar' ?$gov->Arabic_Name :$gov->English_Name}}
                                                                                </option>
                                                                                @endforeach
                                                                            </select>


                                                                        </div>
                                                                    </td>
                                                                    <td>
                                                                        <div class="form-group">

                                                                            <select class="select2 form-control w-100" id="City">

                                                                            </select>

                                                                        </div>
                                                                    </td>
                                                                    <td>
                                                                        <div class="form-group">

                                                                            <select class="select2 form-control w-100" id="Place">

                                                                            </select>

                                                                        </div>
                                                                    </td>

                                                                    <td>
                                                                        <div class="form-group">

                                                                            <input type="text" id="Street" class="form-control">
                                                                        </div>
                                                                    </td>
                                                                    <td>
                                                                        <div class="form-group">

                                                                            <input type="text" id="Buliding" class="form-control">
                                                                        </div>
                                                                    </td>
                                                                    <td>
                                                                        <div class="form-group">

                                                                            <input type="text" id="Floor" class="form-control">
                                                                        </div>
                                                                    </td>
                                                                    <td>
                                                                        <div class="form-group">

                                                                            <input type="text" id="Flat" class="form-control">
                                                                        </div>
                                                                    </td>
                                                                    <td>
                                                                        <div class="form-group">

                                                                            <input type="text" id="Special_Mark" class="form-control">
                                                                        </div>
                                                                    </td>
                                                                    <td>
                                                                        <div class="form-group">

                                                                            <input type="text" id="Location" class="form-control">
                                                                        </div>
                                                                    </td>

                                                                    <td>
                                                                        <div class="form-group">

                                                                            <input type="text" id="Address_Details" class="form-control">
                                                                        </div>
                                                                    </td>

                                                                    <td>
                                                                        <button type="button" onclick="InsertData()" class="btn btn-default" id="add-data"><i class="fal fa-plus"></i></button>
                                                                    </td>

                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                    <!-- datatable start -->
                                                    <div id="mobile-overflow">
                                                        <table id="" class="table table-bordered table-hover table-striped w-100 mobile-width">
                                                            <thead>
                                                                <tr>
                                                                    <th>{{trans('admin.Name')}}</th>
                                                                    <th>{{trans('admin.Governrate')}}</th>
                                                                    <th>{{trans('admin.City')}}</th>
                                                                    <th>{{trans('admin.Place')}}</th>
                                                                    <th>{{trans('admin.Street')}}</th>
                                                                    <th>{{trans('admin.Buliding')}}</th>
                                                                    <th>{{trans('admin.Floor')}}</th>
                                                                    <th>{{trans('admin.Flat')}}</th>
                                                                    <th>{{trans('admin.Special_Mark')}} </th>
                                                                    <th>{{trans('admin.Location')}} </th>
                                                                    <th>{{trans('admin.Address_Details')}} </th>
                                                                </tr>
                                                            </thead>
                                                            <tbody id="data-dt">

                                                            </tbody>

                                                        </table>
                                                    </div>
                                                    <!-- datatable end -->

                                                </div>
                                            </div>


                                        </div>

                                        <div class="form-row">
                                            <div class="buttons mt-3">
                                                <button type="submit" class="btn btn-primary"><i class="fal fa-save"></i> {{trans('admin.Save')}} </button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
<style>
    #map {
        height: 400px;
        width: 100%;
        margin-top: 20px;
    }
</style>
@endsection

@push('js')
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/dropzone/dropzone.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
<script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
<script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
<script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
<script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>

<script>
    //_fnFeatureHtmlLength();
    $(document).ready(function() {
        // Setup - add a text input to each footer cell
        $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
        $('#dt-basic-example thead tr:eq(1) th').each(function(i) {
            var title = $(this).text();
            $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

            $('input', this).on('keyup change', function() {
                if (table.column(i).search() !== this.value) {
                    table
                        .column(i)
                        .search(this.value)
                        .draw();
                }
            });
        });
        var table = $('#dt-basic-example').DataTable({
            responsive: true,
            orderCellsTop: true,
            fixedHeader: true,
            lengthChange: true,

            dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

            buttons: [{
                    extend: 'pageLength',
                    className: 'btn-outline-default'
                },
                {
                    extend: 'colvis',
                    text: 'Column Visibility',
                    titleAttr: 'Col visibility',
                    className: 'btn-outline-default'
                },
                {
                    extend: 'pdfHtml5',
                    text: 'PDF',
                    titleAttr: 'Generate PDF',
                    className: 'btn-outline-danger btn-sm mr-1'
                },
                {
                    extend: 'excelHtml5',
                    text: 'Excel',
                    titleAttr: 'Generate Excel',
                    className: 'btn-outline-success btn-sm mr-1'
                },
                {
                    extend: 'csvHtml5',
                    text: 'CSV',
                    titleAttr: 'Generate CSV',
                    className: 'btn-outline-primary btn-sm mr-1'
                },
                {
                    extend: 'copyHtml5',
                    text: 'Copy',
                    titleAttr: 'Copy to clipboard',
                    className: 'btn-outline-primary btn-sm mr-1'
                },
                {
                    extend: 'print',
                    text: 'Print',
                    titleAttr: 'Print Table',
                    className: 'btn-outline-primary btn-sm'
                }
            ],
        });
        $('.js-thead-colors a').on('click', function() {
            var theadColor = $(this).attr("data-bg");
            console.log(theadColor);
            $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
        });

        $('.js-tbody-colors a').on('click', function() {
            var theadColor = $(this).attr("data-bg");
            console.log(theadColor);
            $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
        });

    });

</script>
<script>
    //_fnFeatureHtmlLength();
    $(document).ready(function() {
        // Setup - add a text input to each footer cell
        $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
        $('#dt-basic-example thead tr:eq(1) th').each(function(i) {
            var title = $(this).text();
            $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

            $('input', this).on('keyup change', function() {
                if (table.column(i).search() !== this.value) {
                    table
                        .column(i)
                        .search(this.value)
                        .draw();
                }
            });
        });
        var table = $('#dt-basic-example').DataTable({
            responsive: true,
            orderCellsTop: true,
            fixedHeader: true,
            lengthChange: true,

            dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

            buttons: [{
                    extend: 'pageLength',
                    className: 'btn-outline-default'
                },
                {
                    extend: 'colvis',
                    text: 'Column Visibility',
                    titleAttr: 'Col visibility',
                    className: 'btn-outline-default'
                },
                {
                    extend: 'pdfHtml5',
                    text: 'PDF',
                    titleAttr: 'Generate PDF',
                    className: 'btn-outline-danger btn-sm mr-1'
                },
                {
                    extend: 'excelHtml5',
                    text: 'Excel',
                    titleAttr: 'Generate Excel',
                    className: 'btn-outline-success btn-sm mr-1'
                },
                {
                    extend: 'csvHtml5',
                    text: 'CSV',
                    titleAttr: 'Generate CSV',
                    className: 'btn-outline-primary btn-sm mr-1'
                },
                {
                    extend: 'copyHtml5',
                    text: 'Copy',
                    titleAttr: 'Copy to clipboard',
                    className: 'btn-outline-primary btn-sm mr-1'
                },
                {
                    extend: 'print',
                    text: 'Print',
                    titleAttr: 'Print Table',
                    className: 'btn-outline-primary btn-sm'
                }
            ],
        });
        $('.js-thead-colors a').on('click', function() {
            var theadColor = $(this).attr("data-bg");
            console.log(theadColor);
            $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
        });

        $('.js-tbody-colors a').on('click', function() {
            var theadColor = $(this).attr("data-bg");
            console.log(theadColor);
            $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
        });

    });

</script>

<!-- Search Selecet -->
<script>
    $(document).ready(function() {
        $(function() {
            $(".select2").select2();

            $(".select2-placeholder-multiple").select2({
                placeholder: "Select State",
            });
            $(".js-hide-search").select2({
                minimumResultsForSearch: 1 / 0,
            });
            $(".js-max-length").select2({
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items",
            });
            $(".select2-placeholder").select2({
                placeholder: "Select a state",
                allowClear: true,
            });

            $(".js-select2-icons").select2({
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function(elm) {
                    return elm;
                },
            });

            function icon(elm) {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
            }




            $('#product').select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: 'json',
                    url: 'AllProClientFilter',
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            })
                        };

                        console.log(data);

                    },
                    data: function(params) {


                        var query = {
                            search: params.term,
                        };


                        $.ajax({
                            url: 'AllProClientFilterJs/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#product').empty();
                                $.each(data, function(key, value) {

                                    $('#product').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                }
            });


            $('#product').on('select2:select', function(e) {
                console.log("select done", e.params.data);
            });



            $('#Guarantor').select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: 'json',
                    url: 'AllCli',
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            })
                        };

                        console.log(data);

                    },
                    data: function(params) {


                        var query = {
                            search: params.term,
                        };


                        $.ajax({
                            url: 'AllCliJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#product').empty();
                                $.each(data, function(key, value) {

                                    $('#product').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                }
            });


            $('#Guarantor').on('select2:select', function(e) {
                console.log("select done", e.params.data);
            });





        });
    });

</script>
<script>
    var autoSave = $('#autoSave');
    var interval;
    var timer = function() {
        interval = setInterval(function() {
            //start slide...
            if (autoSave.prop('checked'))
                saveToLocal();

            clearInterval(interval);
        }, 3000);
    };

    //save
    var saveToLocal = function() {
        localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
        console.log("saved");
    }

    //delete
    var removeFromLocal = function() {
        localStorage.removeItem("summernoteData");
        $('#saveToLocal').summernote('reset');
    }

    $(document).ready(function() {
        //init default
        $('.js-summernote').summernote({
            height: 200,
            tabsize: 2,
            placeholder: "Type here...",
            dialogsFade: true,
            toolbar: [
                ['style', ['style']],
                ['font', ['strikethrough', 'superscript', 'subscript']],
                ['font', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['height', ['height']]
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ],
            callbacks: {
                //restore from localStorage
                onInit: function(e) {
                    $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                },
                onChange: function(contents, $editable) {
                    clearInterval(interval);
                    timer();
                }
            }
        });

        //load emojis
        $.ajax({
            url: 'https://api.github.com/emojis',
            async: false
        }).then(function(data) {
            window.emojis = Object.keys(data);
            window.emojiUrls = data;
        });

        //init emoji example
        $(".js-hint2emoji").summernote({
            height: 100,
            toolbar: false,
            placeholder: 'type starting with : and any alphabet',
            hint: {
                match: /:([\-+\w]+)$/,
                search: function(keyword, callback) {
                    callback($.grep(emojis, function(item) {
                        return item.indexOf(keyword) === 0;
                    }));
                },
                template: function(item) {
                    var content = emojiUrls[item];
                    return '<img src="' + content + '" width="20" /> :' + item + ':';
                },
                content: function(item) {
                    var url = emojiUrls[item];
                    if (url) {
                        return $('<img />').attr('src', url).css('width', 20)[0];
                    }
                    return '';
                }
            }
        });

        //init mentions example
        $(".js-hint2mention").summernote({
            height: 100,
            toolbar: false,
            placeholder: "type starting with @",
            hint: {
                mentions: ['jayden', 'sam', 'alvin', 'david'],
                match: /\B@(\w*)$/,
                search: function(keyword, callback) {
                    callback($.grep(this.mentions, function(item) {
                        return item.indexOf(keyword) == 0;
                    }));
                },
                content: function(item) {
                    return '@' + item;
                }
            }
        });

    });

</script>
<script type="text/javascript">
    $(".show-table").click(function() {
        $(".hide-table").show();
    });

</script>
<!-- Filter Governrate and City !-->
<script>
    $(document).ready(function() {

        $('#Governrate').on('change', function() {
            var countryId = $(this).val();

            if (countryId) {
                $.ajax({
                    url: 'GovernrateFilter/' + countryId,
                    type: "GET",
                    dataType: "json",
                    beforeSend: function() {
                        $('#loader').css("visibility", "visible");
                    },

                    success: function(data) {

                        $('#City').empty();

                        $.each(data, function(key, value) {

                            $('#City').append('<option value="' + key + '">' + value + '</option>');

                        });

                        var CIITY = $('#City').val();
                        $.ajax({
                            url: 'CityFilter/' + CIITY,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {

                                $('#Place').empty();

                                $.each(data, function(key, value) {

                                    $('#Place').append('<option value="' + key + '">' + value + '</option>');

                                });


                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    },
                    complete: function() {
                        $('#loader').css("visibility", "hidden");
                    }
                });
            } else {

                $('select[name="states"]').empty();
            }

        });

    });

    $(document).ready(function() {


        var countryId = $('#Governrate').val();
        if (countryId) {
            $.ajax({
                url: 'GovernrateFilter/' + countryId,
                type: "GET",
                dataType: "json",
                beforeSend: function() {
                    $('#loader').css("visibility", "visible");
                },

                success: function(data) {

                    $('#City').empty();

                    $.each(data, function(key, value) {

                        $('#City').append('<option value="' + key + '">' + value + '</option>');

                    });

                    var CIITY = $('#City').val();
                    $.ajax({
                        url: 'CityFilter/' + CIITY,
                        type: "GET",
                        dataType: "json",
                        beforeSend: function() {
                            $('#loader').css("visibility", "visible");
                        },

                        success: function(data) {

                            $('#Place').empty();

                            $.each(data, function(key, value) {

                                $('#Place').append('<option value="' + key + '">' + value + '</option>');

                            });


                        },
                        complete: function() {
                            $('#loader').css("visibility", "hidden");
                        }
                    });




                },
                complete: function() {
                    $('#loader').css("visibility", "hidden");
                }
            });
        } else {

            $('select[name="states"]').empty();
        }


    });


    $('#City').on('change', function() {
        var CIITY = $('#City').val();
        $.ajax({
            url: 'CityFilter/' + CIITY,
            type: "GET",
            dataType: "json",
            beforeSend: function() {
                $('#loader').css("visibility", "visible");
            },

            success: function(data) {

                $('#Place').empty();

                $.each(data, function(key, value) {

                    $('#Place').append('<option value="' + key + '">' + value + '</option>');

                });


            },
            complete: function() {
                $('#loader').css("visibility", "hidden");
            }
        });


    });



    $(document).ready(function() {

        $('.Governrate').on('change', function() {
            var countryId = $(this).val();

            if (countryId) {
                $.ajax({
                    url: 'GovernrateFilter/' + countryId,
                    type: "GET",
                    dataType: "json",
                    beforeSend: function() {
                        $('#loader').css("visibility", "visible");
                    },

                    success: function(data) {

                        $('.City').empty();

                        $.each(data, function(key, value) {

                            $('.City').append('<option value="' + key + '">' + value + '</option>');

                        });

                        var CIITY = $('.City').val();
                        $.ajax({
                            url: 'CityFilter/' + CIITY,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {

                                $('.Place').empty();

                                $.each(data, function(key, value) {

                                    $('.Place').append('<option value="' + key + '">' + value + '</option>');

                                });


                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    },
                    complete: function() {
                        $('#loader').css("visibility", "hidden");
                    }
                });
            } else {

                $('select[name="states"]').empty();
            }

        });

    });

    $(document).ready(function() {


        var countryId = $('.Governrate').val();
        if (countryId) {
            $.ajax({
                url: 'GovernrateFilter/' + countryId,
                type: "GET",
                dataType: "json",
                beforeSend: function() {
                    $('#loader').css("visibility", "visible");
                },

                success: function(data) {

                    $('.City').empty();

                    $.each(data, function(key, value) {

                        $('.City').append('<option value="' + key + '">' + value + '</option>');

                    });

                    var CIITY = $('.City').val();
                    $.ajax({
                        url: 'CityFilter/' + CIITY,
                        type: "GET",
                        dataType: "json",
                        beforeSend: function() {
                            $('#loader').css("visibility", "visible");
                        },

                        success: function(data) {

                            $('.Place').empty();

                            $.each(data, function(key, value) {

                                $('.Place').append('<option value="' + key + '">' + value + '</option>');

                            });


                        },
                        complete: function() {
                            $('#loader').css("visibility", "hidden");
                        }
                    });




                },
                complete: function() {
                    $('#loader').css("visibility", "hidden");
                }
            });
        } else {

            $('select[name="states"]').empty();
        }


    });


    $('.City').on('change', function() {
        var CIITY = $('.City').val();
        $.ajax({
            url: 'CityFilter/' + CIITY,
            type: "GET",
            dataType: "json",
            beforeSend: function() {
                $('#loader').css("visibility", "visible");
            },

            success: function(data) {

                $('.Place').empty();

                $.each(data, function(key, value) {

                    $('.Place').append('<option value="' + key + '">' + value + '</option>');

                });


            },
            complete: function() {
                $('#loader').css("visibility", "hidden");
            }
        });


    });

</script>
<!-- Filter Platform and Campaigns !-->
<script>
    $(document).ready(function() {

        $('#Platform').on('change', function() {
            var countryId = $(this).val();
            if (countryId) {
                $.ajax({
                    url: 'PlatformFilter/' + countryId,
                    type: "GET",
                    dataType: "json",
                    beforeSend: function() {
                        $('#loader').css("visibility", "visible");
                    },

                    success: function(data) {

                        $('#Campagin').empty();

                        $.each(data, function(key, value) {

                            $('#Campagin').append('<option value="' + key + '">' + value + '</option>');

                        });
                    },
                    complete: function() {
                        $('#loader').css("visibility", "hidden");
                    }
                });
            } else {

                $('select[name="states"]').empty();
            }

        });

    });

    $(document).ready(function() {

        var countryId = $('#Platform').val();
        if (countryId) {
            $.ajax({
                url: 'PlatformFilter/' + countryId,
                type: "GET",
                dataType: "json",
                beforeSend: function() {
                    $('#loader').css("visibility", "visible");
                },

                success: function(data) {

                    $('#Campagin').empty();

                    $.each(data, function(key, value) {

                        $('#Campagin').append('<option value="' + key + '">' + value + '</option>');

                    });
                },
                complete: function() {
                    $('#loader').css("visibility", "hidden");
                }
            });
        } else {

            $('select[name="states"]').empty();
        }



    });

</script>

<!-- Address -->
<script>
    function InsertData() {
        var Naame = document.getElementById("Naame").value;
        var Street = document.getElementById("Street").value;
        var Buliding = document.getElementById("Buliding").value;
        var Floor = document.getElementById("Floor").value;
        var Flat = document.getElementById("Flat").value;
        var Special_Mark = document.getElementById("Special_Mark").value;
        var Location = document.getElementById("Location").value;
        var Address_Details = document.getElementById("Address_Details").value;

        var GovernrateName = $("#Governrate option:selected").text();
        var Governrate = $("#Governrate").val();

        var CityName = $("#City option:selected").text();
        var City = $("#City").val();

        var PlaceName = $("#Place option:selected").text();
        var Place = $("#Place").val();


        var table = ` <tr>
                            <td>
                            ${Naame}
                                </td>
                                <td>
                            ${GovernrateName}
                                </td>
                            <td>
                            ${CityName}
                                </td>

                                <td>
                                ${PlaceName}
                               </td>

                                <td>
                                ${Street}
                               </td>
                                <td>
                                ${Buliding}
                               </td>
                                <td>
                                ${Floor}
                               </td>
                                <td>
                                ${Flat}
                               </td>
                                <td>
                                ${Special_Mark}
                               </td>
                                <td>
                                ${Location}
                               </td>
                                <td>
                                ${Address_Details}

 <input type="hidden" name="Address_Name[]" value="${Naame}">
 <input type="hidden" name="StreetAdd[]" value="${Street}">
 <input type="hidden" name="BulidingAdd[]" value="${Buliding}">
 <input type="hidden" name="FloorAdd[]" value="${Floor}">
 <input type="hidden" name="FlatAdd[]" value="${Flat}">
 <input type="hidden" name="Special_MarkAdd[]" value="${Special_Mark}">
 <input type="hidden" name="LocationAdd[]" value="${Location}">
 <input type="hidden" name="Address_DetailsAdd[]" value="${Address_Details}">
 <input type="hidden" name="GovernrateAdd[]" value="${Governrate}">
 <input type="hidden" name="CityAdd[]" value="${City}">
 <input type="hidden" name="PlaceAdd[]" value="${Place}">
                               </td>

                                <td>
                    <button id="Del" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                </td>

                             </tr>`;

        document.getElementById("data-dt").innerHTML += table;



        $("#data-dt").on("click", "#Del", function(e) {
            $(this).closest("tr").remove();

        });
    }

</script>


<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
<script>
    let map;
    let marker;

    function getLocation() {
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(
                function(position) {
                    const latitude = position.coords.latitude;
                    const longitude = position.coords.longitude;

                    // عرض البيانات في الإنبتات
                    document.getElementById("latInput").value = latitude;
                    document.getElementById("lonInput").value = longitude;

                    // إرسال البيانات إلى PHP
                    fetch('location.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/x-www-form-urlencoded'
                        },
                        body: `lat=${latitude}&lon=${longitude}`
                    })
                        .then(response => response.text())
                        .then(data => {

                        });

                    // عرض الخريطة
                    if (!map) {
                        map = L.map('map').setView([latitude, longitude], 13);

                        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                            attribution: '© OpenStreetMap contributors'
                        }).addTo(map);

                        marker = L.marker([latitude, longitude]).addTo(map)
                            .bindPopup('موقعك الحالي').openPopup();
                    } else {
                        map.setView([latitude, longitude], 13);
                        marker.setLatLng([latitude, longitude]);
                    }
                },
                function(error) {
                    alert("حدث خطأ: " + error.message);
                }
            );
        } else {
            alert("المتصفح لا يدعم تحديد الموقع.");
        }
    }
</script>


@endpush
