@extends('admin.index')
@section('content')
@php
use App\Models\VendorsStatementsColumn;
$colum=VendorsStatementsColumn::orderBy('id','desc')->first();
@endphp
<title>{{trans('admin.VendorsStatement')}}</title>
<style>
   .box{
   position: relative;
   padding:20px 10px;
   border: 1px solid #ccc;
   border-radius: 5px;
   margin-top:25px;
   }
   .box h3{
   position: absolute;
   background: white;
   top: -25px;
   padding: 5px;
   }
   .nav-item{
   width:50%;
   }
   .select-border , .select2-selection--single ,.select2-selection--multiple, input[type="checkbox"]{
   border: 2px solid #584576!important;
   font-size:15px;
   }
   /* The container */
   .container {
   display: block;
   position: relative;
   padding-right: 35px;
   margin-bottom: 12px;
   cursor: pointer;
   font-size: 13px;
   -webkit-user-select: none;
   -moz-user-select: none;
   -ms-user-select: none;
   user-select: none;
   }
   /* Hide the browser's default checkbox */
   .container input {
   position: absolute;
   opacity: 0;
   cursor: pointer;
   height: 0;
   width: 0;
   }
   /* Create a custom checkbox */
   .checkmark {
   position: absolute;
   top: 0;
   right: 0;
   height: 20px;
   width: 20px;
   border-radius: 3px;
   border: 2px solid #584576;
   transition:.5s;
   }
   /* On mouse-over, add a grey background color */
   .container:hover input ~ .checkmark {
   background-color: #ccc;
   transition:.5s;
   }
   /* When the checkbox is checked, add a blue background */
   .container input:checked ~ .checkmark {
   background-color: #584576;
   }
   /* Create the checkmark/indicator (hidden when not checked) */
   .checkmark:after {
   content: "";
   position: absolute;
   display: none;
   }
   /* Show the checkmark when checked */
   .container input:checked ~ .checkmark:after {
   display: block;
   }
   /* Style the checkmark/indicator */
   .container .checkmark:after {
   left: 5px;
   top: 1px;
   width: 7px;
   height: 12px;
   border: solid white;
   border-width: 0 3px 3px 0;
   -webkit-transform: rotate(45deg);
   -ms-transform: rotate(45deg);
   transform: rotate(45deg);
   }
</style>
<main id="js-page-content" role="main" class="page-content">
   <ol class="breadcrumb page-breadcrumb">
      <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Reports')}}</a></li>
      <li class="breadcrumb-item active">{{trans('admin.VendorsStatement')}}</li>
      <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
         class="js-get-date"></span></li>
   </ol>
   <form action="{{url('VendorsStatementFilter')}}" method="post" enctype="multipart/form-data">
       @csrf
      @honeypot
      <div class="row">
         <div class="col-xl-12">
            <div  class="panel">
               <div class="panel-container show">
                  <div class="panel-content">
                     <div class="panel-container show">
                        <span id="ex"> @include('admin.layouts.messages')</span>
                        <div class="panel-content">
                           <ul class="nav nav-tabs" role="tablist">
                              <li class="nav-item" >
                                 <a class="nav-link active" data-toggle="tab" href="#tab_borders_icons-1" role="tab" style="background: #add8e680;"><i class="fal fa-home mr-1"></i>{{trans('admin.Filter')}}</a>
                              </li>
                              <li class="nav-item">
                                 <a class="nav-link" data-toggle="tab" href="#tab_borders_icons-2" role="tab" style="background: #ffe4e1a6;"><i class="fal fa-user mr-1" ></i> {{trans('admin.Columns')}}</a>
                              </li>
                           </ul>
                           <div class="tab-content border border-top-0 p-3">
                              <div class="tab-pane fade show active" id="tab_borders_icons-1" role="tabpanel">
                                 <div class="row">
                                    <div class="col-lg-12">
                                       <div class="row">
                                          <div class="form-group col-md-4 col-12">
                                             <label class="form-label" for="simpleinput">{{trans('admin.From')}}</label><span class="strick">*</span>
                                             <input  type="date" value="{{date('Y-m-d')}}" id="From" name="From" class="form-control  select-border" required>
                                          </div>
                                          <div class="form-group col-md-4 col-12">
                                             <label class="form-label" for="simpleinput">{{trans('admin.To')}}</label><span class="strick">*</span>
                                             <input  type="date" value="{{date('Y-m-d')}}" id="To" name="To" class="form-control  select-border" required>
                                          </div>
                                    
                                       
                                          <div class="form-group col-md-4 col-12">
                                             <label class="form-label" for="">  {{trans('admin.Account')}} ({{trans('admin.Vendors')}}) </label>
                                           <span style="color: red" id="select_all_accounts"><i class="fal fa-sliders-h"></i></span>
                                              <span style="color: red" id="remove_all_accounts"><i class="fal fa-trash"></i></span>
                                             <select class="select2 form-control w-100 ; select-border" multiple  id="Account" name="Account[]">
                                                   @foreach($Clients as $client)
                                                  <option value="{{$client->id}}"> 
                                                      {{app()->getLocale() == 'ar' ?$client->Name :$client->NameEn}} 
                                                 </option>
                                                @endforeach 
                                             </select>
                                          </div>
                                        
                                        
                                       </div>
                                    </div>
                                   
                                 </div>
                              </div>
                              <div class="tab-pane fade" id="tab_borders_icons-2" role="tabpanel">
                                 <div class="row">
                                    <div class="col-md-6">
                                       <div class="box" style="background: #8000803b;">
                                          <h3> {{trans('admin.ChoiceColumn')}}  </h3>
                                          <div class="row">
                                             <div class="col-md-4 demo">
                                                <label class="container">{{trans('admin.Account_Code')}}
                                                <input  type="checkbox" id="Account_CodeBill" name="Account_CodeDet" value="1" @if($colum->Account_Code == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span>
                                                </label>
                                                <label class="container">
                                               {{trans('admin.Account_Name')}}
                                                <input  type="checkbox" name="Account_NameDet" id="Account_NameBill" value="1" @if($colum->Account_Name == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container">  
                                               {{trans('admin.Debiator_Before')}}
                                                <input  type="checkbox" name="Debiator_BeforeDet" value="1" id="Debiator_BeforeBill" @if($colum->Debiator_Before == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                 
                                                        <label class="container">  
                                               {{trans('admin.Creditor_Before')}}
                                             <input  type="checkbox" name="Creditor_BeforeDet" value="1" id="Creditor_BeforeBill" @if($colum->Creditor_Before == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                 
                                                <label class="container">
                                                    {{trans('admin.Total_Debitor')}}
                                                <input type="checkbox" name="Total_DebitorDet" id="Total_DebitorBill" value="1" @if($colum->Total_Debitor == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container">
                                                  {{trans('admin.Total_Creditor')}}
                                                <input  type="checkbox" name="Total_CreditorDet" id="Total_CreditorBill" value="1" @if($colum->Total_Creditor == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container"> 
                                                 {{trans('admin.Debitor_Balance')}}
                                                <input  type="checkbox" name="Debitor_BalanceDet" value="1" id="Debitor_BalanceBill" @if($colum->Debitor_Balance == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                                <label class="container">
                                                {{trans('admin.Creditor_Balance')}}
                                                <input  type="checkbox" name="Creditor_BalanceDet" id="Creditor_BalanceBill" value="1" @if($colum->Creditor_Balance == 1) checked class="FF che" @else class="FF Unche" @endif >
                                                <span class="checkmark"></span> 
                                                </label>
                                             
                                             </div>
                                          </div>
                                       </div>
                                    </div>
                                 
                                    <div class="col-md-2">
                                       <div class="box" style="background: #ffffff;">
                                          <div class="row">
                                             <div class="col-md-12 demo">
                                                <div class="custom-control custom-checkbox">
                                                   <button type="button" id="ChoicedAll"  class="btn btn-warning"><i class="fal fa-check-square"></i> 
                                                  {{trans('admin.ChoicedAll')}}     
                                                   </button>
                                                </div>
                                                <div class="custom-control custom-checkbox">
                                                   <button type="button" id="CancelChoicedAll" class="btn btn-info"><i class="fal fa-square"></i> 
                                                  {{trans('admin.CancelChoicedAll')}}       
                                                   </button>
                                                </div>
                                                <div class="custom-control custom-checkbox">
                                                   <button type="button" id="OppositeChoiced" class="btn btn-danger"><i class="fal fa-square"></i> 
                                                 {{trans('admin.OppositeChoiced')}}       
                                                   </button>
                                                </div>
                                                <div class="custom-control custom-checkbox">
                                                   <button type="button" id="DefaultChoiced" class="btn btn-secondary"><i class="fal fa-check"></i> 
                                                      {{trans('admin.DefaultChoiced')}}       
                                                   </button>
                                                </div>
                                                <div class="custom-control custom-checkbox">
                                                   <button type="button" id="SaveasDefault" class="btn btn-success"><i class="fal fa-check-circle"></i> 
                                                   {{trans('admin.SaveasDefault')}}         
                                                   </button>
                                                </div>
                                             </div>
                                          </div>
                                       </div>
                                    </div>
                                 </div>
                              </div>
                           </div>
                           <div class="form-row">
                              <div class="buttons mt-3">
                                 <button type="submit" class="btn btn-primary"><i class="fal fa-save"></i> 
                                 {{trans('admin.ShowReport')}}         
                                 </button>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </form>
</main>
@endsection
@push('js')
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
<script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
<script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
<script>
   //_fnFeatureHtmlLength();
   $(document).ready(function () {
       // Setup - add a text input to each footer cell
       $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
       $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
           var title = $(this).text();
           $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');
   
           $('input', this).on('keyup change', function () {
               if (table.column(i).search() !== this.value) {
                   table
                       .column(i)
                       .search(this.value)
                       .draw();
               }
           });
       });
       var table = $('#dt-basic-example').DataTable(
           {
               responsive: true,
               orderCellsTop: true,
               fixedHeader: true,
               lengthChange: true,
   
               dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                   "<'row'<'col-sm-12'tr>>" +
                   "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
   
               buttons: [
                   {
                       extend: 'pageLength',
                       className: 'btn-outline-default'
                   },
                   {
                       extend: 'colvis',
                       text: 'Column Visibility',
                       titleAttr: 'Col visibility',
                       className: 'btn-outline-default'
                   },
                   {
                       extend: 'pdfHtml5',
                       text: 'PDF',
                       titleAttr: 'Generate PDF',
                       className: 'btn-outline-danger btn-sm mr-1'
                   },
                   {
                       extend: 'excelHtml5',
                       text: 'Excel',
                       titleAttr: 'Generate Excel',
                       className: 'btn-outline-success btn-sm mr-1'
                   },
                   {
                       extend: 'csvHtml5',
                       text: 'CSV',
                       titleAttr: 'Generate CSV',
                       className: 'btn-outline-primary btn-sm mr-1'
                   },
                   {
                       extend: 'copyHtml5',
                       text: 'Copy',
                       titleAttr: 'Copy to clipboard',
                       className: 'btn-outline-primary btn-sm mr-1'
                   },
                   {
                       extend: 'print',
                       text: 'Print',
                       titleAttr: 'Print Table',
                       className: 'btn-outline-primary btn-sm'
                   }
               ],
           });
       $('.js-thead-colors a').on('click', function () {
           var theadColor = $(this).attr("data-bg");
           console.log(theadColor);
           $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
       });
   
       $('.js-tbody-colors a').on('click', function () {
           var theadColor = $(this).attr("data-bg");
           console.log(theadColor);
           $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
       });
   
   });
   
</script>
<!-- Search Selecet -->
<script>
   $(document).ready(function()
   {
       $(function()
       {
           $('.select2').select2();
   
           $(".select2-placeholder-multiple").select2(
           {
               placeholder: "Select State"
           });
           $(".js-hide-search").select2(
           {
               minimumResultsForSearch: 1 / 0
           });
           $(".js-max-length").select2(
           {
               maximumSelectionLength: 2,
               placeholder: "Select maximum 2 items"
           });
           $(".select2-placeholder").select2(
           {
               placeholder: "Select a state",
               allowClear: true
           });
   
           $(".js-select2-icons").select2(
           {
               minimumResultsForSearch: 1 / 0,
               templateResult: icon,
               templateSelection: icon,
               escapeMarkup: function(elm)
               {
                   return elm
               }
           });
   
           function icon(elm)
           {
               elm.element;
               return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
           }
   
   
   $('#AccountDificit').select2({
   placeholder: "select...",
   ajax: {
   type: "GET",
   dataType: 'json',
   url: 'AllSubAccounts',
   processResults: function (data) {
     return {
       results: $.map(data, function(obj, index) {
         return { id: index, text: obj };
       })
     };
       
       	console.log(data);
       
   },
   data: function (params) {  
     var query = {
       search: params.term
     };
     if (params.term == "*") query.items = [];
     return { json: JSON.stringify( query ) }
   }
   }
   });
   
   
   $('#AccountDificit').on('select2:select', function (e) {
   console.log("select done", e.params.data);
   });
      
           
   $('#AccountExcess').select2({
   placeholder: "select...",
   ajax: {
   type: "GET",
   dataType: 'json',
   url: 'AllSubAccounts',
   processResults: function (data) {
     return {
       results: $.map(data, function(obj, index) {
         return { id: index, text: obj };
       })
     };
       
       	console.log(data);
       
   },
   data: function (params) {  
     var query = {
       search: params.term
     };
     if (params.term == "*") query.items = [];
     return { json: JSON.stringify( query ) }
   }
   }
   });
   
   
   $('#AccountExcess').on('select2:select', function (e) {
   console.log("select done", e.params.data);
   });
                      
   
           
         $("#client").select2({
           placeholder: "select...",
           ajax: {
               type: "GET",
               dataType: "json",
               url: "AllClientsFilter",
               processResults: function (data) {
                   return {
                       results: $.map(data, function (obj, index) {
   
                           return { id: index, text: obj };
                       }),
                   };
   
                   console.log(data);
               },
             data: function (params) {  
   
       
              var query = {
                       search: params.term,
                   };
                           
       
         $.ajax({
                         url: 'AllClientsFilterJS/'+params.term,
                         type:"GET",
                         dataType:"json",
                         beforeSend: function(){
                             $('#loader').css("visibility", "visible");
                         },
   
                         success:function(data) {
                                     $('#client').empty();  
                             $.each(data, function(key, value){
   
                    $('#client').append('<option value="'+ key +'">' + value + '</option>');
              
                             });
                         },
                         complete: function(){
                             $('#loader').css("visibility", "hidden");
                         }
                     });
       
       
       
   }
           },
       });
   
       $("#client").on("select2:select", function (e) {
           console.log("select done", e.params.data);
       });
       
                   
           
       });
   });
</script>



<!-- ~Multi Select Choiced and removed  -->
<script>

$('#select_all_accounts').click(function() {

             $("#Account").select2("destroy");
$("#Account").find('option').attr('selected',true);
$("#Account").select2();
  
});
    
$('#remove_all_accounts').click(function() {

            $("#Account").select2("destroy");
$("#Account").find('option').attr('selected',false);
$("#Account").select2();
});
    


</script>

<!-- Choiced Checkbox -->
<script>
    
    $('.FF').on('click' , function(){
    var $a1Check  = $(this).is(':checked');

   
    if($a1Check){
       $(this).val(1);
    }
    else{
         $(this).val(0);
    }    
    
        
    
    
});
    
    
    $('#ChoicedAll').click(function() {
    $('.FF').prop('checked', true);
    $('.FF').val(1);
  
});
    
    
$('#CancelChoicedAll').click(function() {
    $('.FF').prop('checked', false);
  $('.FF').val(0);
});

    
$('#OppositeChoiced').click(function() {
    
    $('.FF').each(function () {
  $(this).prop('checked', !$(this).is(':checked'));
        
        
         var $a1Check  = $(this).is(':checked');

   
    if($a1Check){
       $(this).val(1);
    }
    else{
         $(this).val(0);
    }    
        
});

    
});
    
    
    $('#DefaultChoiced').click(function() {
    
    $('.Unche').prop('checked', false);
     $('.che').prop('checked', true);

       $('.che').val(1);
       $('.Unche').val(0);
});

     $('#SaveasDefault').click(function() {
    
    var Account_CodeBill = $('#Account_CodeBill').val();  
    var Account_NameBill = $('#Account_NameBill').val();  
    var Debiator_BeforeBill = $('#Debiator_BeforeBill').val();  
    var Creditor_BeforeBill = $('#Creditor_BeforeBill').val();  
    var Total_DebitorBill = $('#Total_DebitorBill').val();  
    var Total_CreditorBill = $('#Total_CreditorBill').val();  
    var Debitor_BalanceBill = $('#Debitor_BalanceBill').val();  
    var Creditor_BalanceBill = $('#Creditor_BalanceBill').val();  
  

                         $.ajax({
                   url: 'SaveDefaultColumnsVendorsStatement',
                   type:"GET",
                   data:{
                   Account_CodeBill:Account_CodeBill,
                   Account_NameBill:Account_NameBill,
                   Debiator_BeforeBill:Debiator_BeforeBill,
                   Creditor_BeforeBill:Creditor_BeforeBill,
                   Total_DebitorBill:Total_DebitorBill,
                   Total_CreditorBill:Total_CreditorBill,
                   Debitor_BalanceBill:Debitor_BalanceBill,
                   Creditor_BalanceBill:Creditor_BalanceBill
                 
              
                   },
                   dataType:"json",
                   beforeSend: function(){
                       $('#loader').css("visibility", "visible");
                   },
   
                   success:function(data) {
   
                
                alert('تم الحفظ كافتراضي');      
         
       
                   },
                   complete: function(){
                       $('#loader').css("visibility", "hidden");
                   }
               });
    
});

</script>

@endpush