@extends('admin.index')
@section('content')

<title>{{trans('admin.ProfitDelegateSalesDetails')}}</title>
<style>
   .box{
   position: relative;
   padding:20px 10px;
   border: 1px solid #ccc;
   border-radius: 5px;
   margin-top:25px;
   }
   .box h3{
   position: absolute;
   background: white;
   top: -25px;
   padding: 5px;
   }
   .nav-item{
   width:50%;
   }
   .select-border , .select2-selection--single ,.select2-selection--multiple, input[type="checkbox"]{
   border: 2px solid #584576!important;
   font-size:15px;
   }
   /* The container */
   .container {
   display: block;
   position: relative;
   padding-right: 35px;
   margin-bottom: 12px;
   cursor: pointer;
   font-size: 13px;
   -webkit-user-select: none;
   -moz-user-select: none;
   -ms-user-select: none;
   user-select: none;
   }
   /* Hide the browser's default checkbox */
   .container input {
   position: absolute;
   opacity: 0;
   cursor: pointer;
   height: 0;
   width: 0;
   }
   /* Create a custom checkbox */
   .checkmark {
   position: absolute;
   top: 0;
   right: 0;
   height: 20px;
   width: 20px;
   border-radius: 3px;
   border: 2px solid #584576;
   transition:.5s;
   }
   /* On mouse-over, add a grey background color */
   .container:hover input ~ .checkmark {
   background-color: #ccc;
   transition:.5s;
   }
   /* When the checkbox is checked, add a blue background */
   .container input:checked ~ .checkmark {
   background-color: #584576;
   }
   /* Create the checkmark/indicator (hidden when not checked) */
   .checkmark:after {
   content: "";
   position: absolute;
   display: none;
   }
   /* Show the checkmark when checked */
   .container input:checked ~ .checkmark:after {
   display: block;
   }
   /* Style the checkmark/indicator */
   .container .checkmark:after {
   left: 5px;
   top: 1px;
   width: 7px;
   height: 12px;
   border: solid white;
   border-width: 0 3px 3px 0;
   -webkit-transform: rotate(45deg);
   -ms-transform: rotate(45deg);
   transform: rotate(45deg);
   }
</style>
<main id="js-page-content" role="main" class="page-content">
   <ol class="breadcrumb page-breadcrumb">
      <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Reports')}}</a></li>
      <li class="breadcrumb-item active">{{trans('admin.ProfitDelegateSalesDetails')}}</li>
      <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
         class="js-get-date"></span></li>
   </ol>
   <form action="{{url('ProfitDelegateSalesDetailsFilter')}}" method="post" enctype="multipart/form-data">
@csrf
      <div class="row">
         <div class="col-xl-12">
            <div  class="panel">
               <div class="panel-container show">
                  <div class="panel-content">
                     <div class="panel-container show">
                        <span id="ex"> @include('admin.layouts.messages')</span>
                        <div class="panel-content">
                           <ul class="nav nav-tabs" role="tablist">
                              <li class="nav-item" >
                                 <a class="nav-link active" data-toggle="tab" href="#tab_borders_icons-1" role="tab" style="background: #add8e680;"><i class="fal fa-home mr-1"></i>{{trans('admin.Filter')}}</a>
                              </li>

                           </ul>
                           <div class="tab-content border border-top-0 p-3">
                              <div class="tab-pane fade show active" id="tab_borders_icons-1" role="tabpanel">
                                 <div class="row">
                                    <div class="col-lg-12">
                                       <div class="row">
                                         <div class="form-group col-md-4 col-12">
                                             <label class="form-label" for="simpleinput">{{trans('admin.From')}}</label><span class="strick">*</span>
                                             <input  type="date" value="{{date('Y-m-d')}}" id="From" name="From" class="form-control  select-border" required>
                                          </div>
                                          <div class="form-group col-md-4 col-12">
                                             <label class="form-label" for="simpleinput">{{trans('admin.To')}}</label><span class="strick">*</span>
                                             <input  type="date" value="{{date('Y-m-d')}}" id="To" name="To" class="form-control  select-border" required>
                                          </div>
                                                      <div class="form-group col-md-4 col-12 no-print">
                                             <label class="form-label" for="">  {{trans('admin.Delegate')}}  </label>
                                                <span style="color: red" id="select_all_dele"><i class="fal fa-sliders-h"></i></span>
                                              <span style="color: red" id="remove_all_dele"><i class="fal fa-trash"></i></span>
                                             <select class="select2 form-control w-100 ; select-border" multiple id="Delegate" name="Delegate[]" required>
                                                @foreach($Employess as $emp)
                                                  <option value="{{$emp->id}}">

                                                    {{app()->getLocale() == 'ar' ?$emp->Name :$emp->NameEn}}
                                                 </option>
                                                @endforeach
                                             </select>
                                          </div>
                                          <div class="form-group col-md-4 col-12">
                                             <label class="form-label" for="">  {{trans('admin.Branch')}} </label>
                                             <select  class="select2 form-control w-100 select-border" id="Branch"   name="Branch">
                                                <option value=""> {{trans('admin.Branch')}}</option>
                                               @foreach($Branches as $branch)
                                                  <option value="{{$branch->id}}">

                                               {{app()->getLocale() == 'ar' ?$branch->Arabic_Name :$branch->English_Name}}
                                                 </option>
                                                @endforeach
                                             </select>
                                          </div>
                                          <div class="form-group col-md-4 col-12 no-print">
                                             <label class="form-label" for="">  {{trans('admin.Stores')}}  </label>

                                              <span style="color: red" id="select_all_stores"><i class="fal fa-sliders-h"></i></span>
                                              <span style="color: red" id="remove_all_stores"><i class="fal fa-trash"></i></span>
                                             <select  class="select2 form-control w-100 select-border" multiple id="Store" name="Store[]" >

                                                   @foreach($Stores as $store)
                                                  <option value="{{$store->id}}">

                                                      {{app()->getLocale() == 'ar' ?$store->Name :$store->NameEn}}
                                                 </option>
                                                @endforeach
                                             </select>
                                          </div>


                                                <div class="form-group col-md-4 col-12">
                                             <label class="form-label" for="">  {{trans('admin.Group')}}  </label>
                                                <span style="color: red" id="select_all_group"><i class="fal fa-sliders-h"></i></span>
                                              <span style="color: red" id="remove_all_group"><i class="fal fa-trash"></i></span>
                                             <select class="select2 form-control w-100 ; select-border" multiple id="Group" name="Group[]">
                                                   @foreach($Group as $grp)
                                                  <option value="{{$grp->id}}">

                                                        {{app()->getLocale() == 'ar' ?$grp->Name :$grp->NameEn}}
                                                 </option>
                                                @endforeach
                                             </select>
                                          </div>

                                                   <div class="form-group col-md-4 col-12">
                                             <label class="form-label" for="">  {{trans('admin.Group')}}  </label>
                                             <select class="select2 form-control w-100 ; select-border"  id="GroupSingle" >
                                                 <option value="">{{trans('admin.Group')}}</option>
                                                   @foreach($Group as $grp)
                                                  <option value="{{$grp->id}}">    {{app()->getLocale() == 'ar' ?$grp->Name :$grp->NameEn}} </option>
                                                @endforeach
                                             </select>
                                          </div>

                                          <div class="form-group col-md-4 col-12">
                                             <label class="form-label" for="">  {{trans('admin.Brand')}}  </label>
                                                <span style="color: red" id="select_all_brand"><i class="fal fa-sliders-h"></i></span>
                                              <span style="color: red" id="remove_all_brand"><i class="fal fa-trash"></i></span>
                                             <select class="select2 form-control w-100 ; select-border" multiple id="Brand" name="Brand[]">
                                                   @foreach($Brand as $brn)
                                                  <option value="{{$brn->id}}">

                                                    {{app()->getLocale() == 'ar' ?$brn->Name :$brn->NameEn}}
                                                 </option>
                                                @endforeach
                                             </select>
                                          </div>


                                               <div class="form-group col-md-4 col-12 no-print">
                                             <label class="form-label" for=""> {{trans('admin.Payment_Method')}}  </label>
                                                <span style="color: red" id="select_all_paymethod"><i class="fal fa-sliders-h"></i></span>
                                              <span style="color: red" id="remove_all_paymethod"><i class="fal fa-trash"></i></span>
                                             <select class="select2 form-control w-100 ; select-border" multiple id="Payment_Method" name="Payment_Method[]">

                                                <option value="Cash"> {{trans('admin.Cash')}}</option>
                                                <option value="Later"> {{trans('admin.Later')}}</option>
                                                <option value="Check"> {{trans('admin.Check')}}</option>
                                                <option value="Installment"> {{trans('admin.Installment')}}</option>
                                                <option value="Cash_Visa"> {{trans('admin.Cash_Visa')}}</option>
                                                <option value="Cash_Collection"> {{trans('admin.Cash_Collection')}}</option>
                                                <option value="Delivery"> {{trans('admin.Delivery')}}</option>
                                                <option value="InstallmentCompanies"> {{trans('admin.InstallmentCompanies')}}</option>
                                                <option value="Visa"> {{trans('admin.Visa')}}</option>

                                             </select>
                                          </div>

                                       </div>
                                    </div>

                                 </div>
                              </div>

                           </div>
                           <div class="form-row">
                              <div class="buttons mt-3">
                                 <button type="submit" class="btn btn-primary"><i class="fal fa-save"></i>
                                 {{trans('admin.ShowReport')}}
                                 </button>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </form>
</main>
@endsection
@push('js')
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
<script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
<script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>

<script>

   //_fnFeatureHtmlLength();
   $(document).ready(function () {
       // Setup - add a text input to each footer cell
       $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
       $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
           var title = $(this).text();
           $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

           $('input', this).on('keyup change', function () {
               if (table.column(i).search() !== this.value) {
                   table
                       .column(i)
                       .search(this.value)
                       .draw();
               }
           });
       });
       var table = $('#dt-basic-example').DataTable(
           {
               responsive: true,
               orderCellsTop: true,
               fixedHeader: true,
               lengthChange: true,

               dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                   "<'row'<'col-sm-12'tr>>" +
                   "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

               buttons: [
                   {
                       extend: 'pageLength',
                       className: 'btn-outline-default'
                   },
                   {
                       extend: 'colvis',
                       text: 'Column Visibility',
                       titleAttr: 'Col visibility',
                       className: 'btn-outline-default'
                   },
                   {
                       extend: 'pdfHtml5',
                       text: 'PDF',
                       titleAttr: 'Generate PDF',
                       className: 'btn-outline-danger btn-sm mr-1'
                   },
                   {
                       extend: 'excelHtml5',
                       text: 'Excel',
                       titleAttr: 'Generate Excel',
                       className: 'btn-outline-success btn-sm mr-1'
                   },
                   {
                       extend: 'csvHtml5',
                       text: 'CSV',
                       titleAttr: 'Generate CSV',
                       className: 'btn-outline-primary btn-sm mr-1'
                   },
                   {
                       extend: 'copyHtml5',
                       text: 'Copy',
                       titleAttr: 'Copy to clipboard',
                       className: 'btn-outline-primary btn-sm mr-1'
                   },
                   {
                       extend: 'print',
                       text: 'Print',
                       titleAttr: 'Print Table',
                       className: 'btn-outline-primary btn-sm'
                   }
               ],
           });
       $('.js-thead-colors a').on('click', function () {
           var theadColor = $(this).attr("data-bg");
           console.log(theadColor);
           $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
       });

       $('.js-tbody-colors a').on('click', function () {
           var theadColor = $(this).attr("data-bg");
           console.log(theadColor);
           $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
       });

   });

</script>
<!-- Search Selecet -->
<script>
   $(document).ready(function()
   {
       $(function()
       {
           $('.select2').select2();

           $(".select2-placeholder-multiple").select2(
           {
               placeholder: "Select State"
           });
           $(".js-hide-search").select2(
           {
               minimumResultsForSearch: 1 / 0
           });
           $(".js-max-length").select2(
           {
               maximumSelectionLength: 2,
               placeholder: "Select maximum 2 items"
           });
           $(".select2-placeholder").select2(
           {
               placeholder: "Select a state",
               allowClear: true
           });

           $(".js-select2-icons").select2(
           {
               minimumResultsForSearch: 1 / 0,
               templateResult: icon,
               templateSelection: icon,
               escapeMarkup: function(elm)
               {
                   return elm
               }
           });

           function icon(elm)
           {
               elm.element;
               return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
           }


   $('#AccountDificit').select2({
   placeholder: "select...",
   ajax: {
   type: "GET",
   dataType: 'json',
   url: 'AllSubAccounts',
   processResults: function (data) {
     return {
       results: $.map(data, function(obj, index) {
         return { id: index, text: obj };
       })
     };

       	console.log(data);

   },
   data: function (params) {
     var query = {
       search: params.term
     };
     if (params.term == "*") query.items = [];
     return { json: JSON.stringify( query ) }
   }
   }
   });


   $('#AccountDificit').on('select2:select', function (e) {
   console.log("select done", e.params.data);
   });


   $('#AccountExcess').select2({
   placeholder: "select...",
   ajax: {
   type: "GET",
   dataType: 'json',
   url: 'AllSubAccounts',
   processResults: function (data) {
     return {
       results: $.map(data, function(obj, index) {
         return { id: index, text: obj };
       })
     };

       	console.log(data);

   },
   data: function (params) {
     var query = {
       search: params.term
     };
     if (params.term == "*") query.items = [];
     return { json: JSON.stringify( query ) }
   }
   }
   });


   $('#AccountExcess').on('select2:select', function (e) {
   console.log("select done", e.params.data);
   });



         $("#client").select2({
           placeholder: "select...",
           ajax: {
               type: "GET",
               dataType: "json",
               url: "AllClientsFilter",
               processResults: function (data) {
                   return {
                       results: $.map(data, function (obj, index) {

                           return { id: index, text: obj };
                       }),
                   };

                   console.log(data);
               },
             data: function (params) {


              var query = {
                       search: params.term,
                   };


         $.ajax({
                         url: 'AllClientsFilterJS/'+params.term,
                         type:"GET",
                         dataType:"json",
                         beforeSend: function(){
                             $('#loader').css("visibility", "visible");
                         },

                         success:function(data) {
                                     $('#client').empty();
                             $.each(data, function(key, value){

                    $('#client').append('<option value="'+ key +'">' + value + '</option>');

                             });
                         },
                         complete: function(){
                             $('#loader').css("visibility", "hidden");
                         }
                     });



   }
           },
       });

       $("#client").on("select2:select", function (e) {
           console.log("select done", e.params.data);
       });



       });
   });
</script>

<!-- Filter Branch and client group -->
<script>

     $('#Branch').on('change', function(){
      var Branch = $('#Branch').val();
                         $.ajax({
                   url: 'BranchReportStoresFilter',
                   type:"GET",
                   data:{
                   Branch:Branch
                   },
                   dataType:"json",
                   beforeSend: function(){
                       $('#loader').css("visibility", "visible");
                   },

                   success:function(data) {

                       $('#Store').empty();

                       $.each(data, function(key, value){

             $('#Store').append('<option value="'+ key +'">' + value + '</option>');

                       });


                        $.ajax({
                   url: 'BranchReportSafesFilter',
                   type:"GET",
                   data:{
                   Branch:Branch
                   },
                   dataType:"json",
                   beforeSend: function(){
                       $('#loader').css("visibility", "visible");
                   },

                   success:function(data) {

                       $('#Safe').empty();

                       $.each(data, function(key, value){

             $('#Safe').append('<option value="'+ key +'">' + value + '</option>');

                       });





                   },
                   complete: function(){
                       $('#loader').css("visibility", "hidden");
                   }
               });


                   },
                   complete: function(){
                       $('#loader').css("visibility", "hidden");
                   }
               });


 });

        $('#GroupSingle').on('change', function(){
      var Group = $('#GroupSingle').val();
                         $.ajax({
                   url: 'GroupSingleFilter',
                   type:"GET",
                   data:{
                   Group:Group
                   },
                   dataType:"json",
                   beforeSend: function(){
                       $('#loader').css("visibility", "visible");
                   },

                   success:function(data) {

                       $('#Group').empty();

                       $.each(data, function(key, value){

             $('#Group').append('<option value="'+ key +'">' + value + '</option>');

                       });


                            $("#Group").select2("destroy");
$("#Group").find('option').attr('selected',true);
$("#Group").select2();

                   },
                   complete: function(){
                       $('#loader').css("visibility", "hidden");
                   }
               });


 });


</script>

<!-- ~Multi Select Choiced and removed  -->
<script>
$('#select_all_stores').click(function() {

  $("#Store").select2("destroy");
$("#Store").find('option').attr('selected',true);
$("#Store").select2();

});


$('#remove_all_stores').click(function() {
 $("#Store").select2("destroy");
$("#Store").find('option').attr('selected',false);
$("#Store").select2();
});

$('#select_all_safes').click(function() {
     $("#Safe").select2("destroy");
$("#Safe").find('option').attr('selected',true);
$("#Safe").select2();

});

$('#remove_all_safes').click(function() {
    $("#Safe").select2("destroy");
$("#Safe").find('option').attr('selected',false);
$("#Safe").select2();
});


$('#select_all_type').click(function() {

             $("#Type").select2("destroy");
$("#Type").find('option').attr('selected',true);
$("#Type").select2();

});

$('#remove_all_type').click(function() {

            $("#Type").select2("destroy");
$("#Type").find('option').attr('selected',false);
$("#Type").select2();
});



$('#select_all_user').click(function() {

             $("#User").select2("destroy");
$("#User").find('option').attr('selected',true);
$("#User").select2();

});

$('#remove_all_user').click(function() {

            $("#User").select2("destroy");
$("#User").find('option').attr('selected',false);
$("#User").select2();
});

$('#select_all_group').click(function() {

             $("#Group").select2("destroy");
$("#Group").find('option').attr('selected',true);
$("#Group").select2();

});

$('#remove_all_group').click(function() {

            $("#Group").select2("destroy");
$("#Group").find('option').attr('selected',false);
$("#Group").select2();
});

$('#select_all_brand').click(function() {

             $("#Brand").select2("destroy");
$("#Brand").find('option').attr('selected',true);
$("#Brand").select2();

});

$('#remove_all_brand').click(function() {

            $("#Brand").select2("destroy");
$("#Brand").find('option').attr('selected',false);
$("#Brand").select2();
});



$('#select_all_dele').click(function() {

             $("#Delegate").select2("destroy");
$("#Delegate").find('option').attr('selected',true);
$("#Delegate").select2();

});

$('#remove_all_dele').click(function() {

            $("#Delegate").select2("destroy");
$("#Delegate").find('option').attr('selected',false);
$("#Delegate").select2();
});

</script>

@endpush
