@extends('admin.index')
@section('content')

    <title>{{trans('admin.Paymentss')}}</title>

    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.RealStates')}}</a></li>
            <li class="breadcrumb-item active">{{trans('admin.Paymentss')}}</li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                    class="js-get-date"></span></li>
        </ol>

        <div class="row">
            <div class="col-xl-12">
                <div id="panel-1" class="panel">
                    <div class="panel-hdr">
                        <h2>
                            <span class="fw-300"><i>{{trans('admin.Paymentss')}} => {{$data->Name}}</i></span>
                        </h2>

                        <div class="panel-toolbar">

                            <a href="{{url('AddPaymentsProject/'.$data->id)}}" class="btn btn-default">{{trans('admin.AddNew')}}</a>
                            <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>

                            @include('admin.layouts.toolbar')
                        </div>

                    </div>
                    <div class="panel-container show">
                        <span id="ex"> @include('admin.layouts.messages')</span>
                        <div class="panel-content">
                            <!-- datatable start -->
                            <table id="dt-basic-example"
                                   class="table table-bordered table-hover table-striped w-100">
                                <thead class="bg-highlight">
                                <tr>
                                    <th>{{trans('admin.Code')}}</th>
                                    <th>{{trans('admin.Date')}}</th>
                                    <th>{{trans('admin.Time')}}</th>
                                    <th>{{trans('admin.Safe')}}</th>
                                    <th>{{trans('admin.Client')}}</th>
                                    <th>{{trans('admin.Delegate')}}</th>
                                    <th>{{trans('admin.Store')}}</th>
                                    <th>{{trans('admin.Coin')}}</th>
                                    <th>{{trans('admin.Draw')}}</th>
                                    <th>{{trans('admin.Cost_Center')}}</th>
                                    <th>{{trans('admin.Note')}}</th>
                                    <th>{{trans('admin.Details')}}</th>
                                    <th>{{trans('admin.Actions')}}</th>


                                </tr>
                                </thead>
                                <tbody>

                                @foreach($items as $item)
                                    <tr>
                                        <td>{{$item->Code}}</td>
                                        <td>{{$item->Date}}</td>
                                        <td>{{$item->Time}}</td>
                                        <td>

                                            @if(!empty($item->Safe()->first()->Name))
                                                {{app()->getLocale() == 'ar' ?$item->Safe()->first()->Name :$item->Safe()->first()->NameEn}}

                                            @endif


                                        </td>
                                        <td>

                                            @if(!empty($item->Client()->first()->Name))
                                                {{app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn}}

                                            @endif


                                        </td>
                                        <td>

                                            @if(!empty($item->Delegate()->first()->Name))
                                                {{app()->getLocale() == 'ar' ?$item->Delegate()->first()->Name :$item->Delegate()->first()->NameEn}}

                                            @endif


                                        </td>
                                        <td>

                                            @if(!empty($item->Store()->first()->Name))
                                                {{app()->getLocale() == 'ar' ?$item->Store()->first()->Name :$item->Store()->first()->NameEn}}

                                            @endif


                                        </td>

                                        <td>

                                            @if(!empty($item->Coin()->first()->Arabic_Name))
                                                {{app()->getLocale() == 'ar' ?$item->Coin()->first()->Arabic_Name :$item->Coin()->first()->English_Name}}

                                            @endif


                                        </td>

                                        <td>{{$item->Draw}}</td>
                                        <td>

                                            @if(!empty($item->Cost_Center()->first()->Arabic_Name))
                                                {{app()->getLocale() == 'ar' ?$item->Cost_Center()->first()->Arabic_Name :$item->Cost_Center()->first()->English_Name}}

                                            @endif


                                        </td>


                                        <td>{{$item->Note}}</td>
                                        <td>
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#details{{$item->id}}">
                                                {{trans('admin.Details')}}</button>
                                        </td>

                                        <td class="text-center">

                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>

                                            <a href="{{url('EditPaymentProject/'.$item->id)}}" class="btn btn-default"><i class="fal fa-edit"></i></a>
                                            <a href="{{url('PaymentProjectPrint/'.$item->id)}}" class="btn btn-default"><i class="fal fa-print"></i></a>

                                        </td>
                                    </tr>
                                @endforeach


                                </tbody>
                                <tfoot>
                                <tr>
                                    <th>{{trans('admin.Code')}}</th>
                                    <th>{{trans('admin.Date')}}</th>
                                    <th>{{trans('admin.Time')}}</th>
                                    <th>{{trans('admin.Safe')}}</th>
                                    <th>{{trans('admin.Client')}}</th>
                                    <th>{{trans('admin.Delegate')}}</th>
                                    <th>{{trans('admin.Store')}}</th>
                                    <th>{{trans('admin.Coin')}}</th>
                                    <th>{{trans('admin.Draw')}}</th>
                                    <th>{{trans('admin.Cost_Center')}}</th>
                                    <th>{{trans('admin.Note')}}</th>
                                    <th>{{trans('admin.Details')}}</th>
                                    <th>{{trans('admin.Actions')}}</th>
                                </tr>
                                </tfoot>
                            </table>
                            <!-- datatable end -->
                        </div>
                    </div>
                </div>
            </div>
        </div>


        @foreach($items as $item)


            <!-- Modal Delete -->
            <div class="modal fade" id="default-example-modal-center{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                {{trans('admin.RUSWDT')}} <strong>
                                    {{app()->getLocale() == 'ar' ?$item->Code :$item->Code}}
                                </strong>
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                            <a href="{{url('DeletePaymentProject/'.$item->id)}}"  class="btn btn-primary"> {{trans('admin.Yes')}}</a>
                        </div>
                    </div>
                </div>
            </div>



            <!-- Modal Details -->
            <div class="modal fade" id="details{{$item->id}}" tabindex="-1" role="dialog"
                 aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                {{trans('admin.Details')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">


                            @php
                                $details=\App\Models\RealStates\PaymentssProductsRealProjects::where('Payment',$item->id)->get();
                            @endphp
                            <div class="mt-3">
                                <div style="overflow:auto">
                                    <table id="details" class="table table-bordered table-hover table-striped ">
                                        <thead>
                                        <tr>
                                            <th>{{trans('admin.Code')}} </th>
                                            <th>{{trans('admin.Name')}} </th>
                                            <th>{{trans('admin.Unit')}} </th>
                                            <th>{{trans('admin.AvQty')}} </th>
                                            <th>{{trans('admin.Qty')}} </th>
                                            <th>{{trans('admin.Price')}} </th>
                                            <th>{{trans('admin.Discount')}} </th>
                                            <th>{{trans('admin.Total_Bf_Tax')}} </th>
                                            <th>{{trans('admin.Total_Tax')}} </th>
                                            <th>{{trans('admin.Total')}} </th>
                                            <th>{{trans('admin.The_Net')}} </th>
                                            <th>{{trans('admin.Cost')}} </th>
                                            <th>{{trans('admin.Total_Cost')}} </th>
                                        </tr>
                                        </thead>
                                        <tbody id="">
                                        @php  $bonus=0; @endphp
                                        @foreach($details as $detail)


                                            <tr>

                                                <td>{{$detail->Product_Code}} </td>
                                                <td>

                                                    @if(!empty($detail->Product()->first()->P_Ar_Name))
                                                        {{app()->getLocale() == 'ar' ?$detail->Product()->first()->P_Ar_Name :$detail->Product()->first()->P_En_Name}}
                                                    @endif
                                                </td>
                                                <td>
                                                    @if(!empty($detail->Unit()->first()->Name ))
                                                        {{app()->getLocale() == 'ar' ?$detail->Unit()->first()->Name :$detail->Unit()->first()->NameEn}}
                                                    @endif
                                                </td>
                                                <td>{{$detail->AvQty}}</td>
                                                <td>{{$detail->Qty}}</td>
                                                <td>{{$detail->Price}}</td>
                                                <td>{{$detail->Discount}}</td>
                                                <td>{{$detail->Total_Bf_Tax}}</td>
                                                <td>{{$detail->Total_Tax}}</td>
                                                <td>{{$detail->Total}}</td>
                                                <td>{{$detail->Total_Net}} </td>
                                                <td>{{$detail->CostPrice}}</td>
                                                <td>{{$detail->TotCostNew}}</td>




                                            </tr>
                                        @endforeach
                                        </tbody>

                                    </table>
                                </div>
                                <div style="overflow:auto">
                                    <table class="table table-bordered table-hover table-striped mt-4">
                                        <tbody>
                                        <tr>
                                            <td>{{trans('admin.Product_Numbers')}}</td>
                                            <td>{{$item->Product_Numbers}}</td>

                                            <td>{{trans('admin.Total_Qty')}}</td>
                                            <td>{{$item->Total_Qty}}</td>

                                            <td>{{trans('admin.Total_Price')}}</td>
                                            <td>{{number_format((float)$item->Total_Price , 2, '.', '')}}</td>

                                        </tr>

                                        <tr>
                                            <td>{{trans('admin.Total_Discount')}}</td>
                                            <td>{{$item->Total_Discount}}</td>

                                            <td>{{trans('admin.Total_Bf_Taxes')}}</td>
                                            <td>{{$item->Total_BF_Taxes}}</td>

                                            <td>{{trans('admin.Total_Taxes')}}</td>
                                            <td>{{$item->Total_Taxes }}</td>
                                        </tr>

                                        <tr>
                                            <td>{{trans('admin.Total_Net')}}</td>
                                            <td>{{$item->Total_Net}}</td>

                                            <td>{{trans('admin.Paid')}}</td>
                                            <td>{{$item->Pay}}</td>


                                            <td>{{trans('admin.Discount_Bill')}}</td>
                                            <td>{{$item->DiscountBill}}</td>
                                        </tr>





                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary"
                                        data-dismiss="modal">{{trans('admin.Close')}}</button>
                            </div>
                        </div>
                    </div>
                </div>

            </div>




        @endforeach
    </main>

@endsection

@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>
@endpush

