@extends('admin.index')
@section('content')
@php
use App\Models\EmpRatio;
use App\Models\EmpPOSStores;
use App\Models\AllowencesEmp;
use App\Models\DiscountsEmp;
use App\Models\EmpsProducationQuantity;
use App\Models\AttendencePolicyEmp;
use App\Models\DepaarturePolicyEmp;
@endphp
  <title>{{trans('admin.JobRequestsSechdule')}}</title>


     <main id="js-page-content" role="main" class="page-content">
                    <ol class="breadcrumb page-breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.HR')}}</a></li>
                        <li class="breadcrumb-item active"> {{trans('admin.JobRequestsSechdule')}} </li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                                class="js-get-date"></span></li>
                    </ol>

                    <!-- data entry -->

                    <div class="row hide-table">
                        <div class="col-xl-12">
                            <div id="panel-1" class="panel">
                                <div class="panel-hdr">
                                    <h2>
                                    {{trans('admin.JobRequestsSechdule')}}
                                    </h2>

                                    <div class="panel-toolbar">
                                        <button class="btn btn-primary btn-sm" data-toggle="dropdown">Table
                                            Style</button>
                                        @include('admin.layouts.toolbar')
                                    </div>

                                </div>
                                <div class="panel-container show">
                                                     <span id="ex"> @include('admin.layouts.messages')</span>
                                    <div class="panel-content">

                                        <!-- datatable start -->
                                        <div style="overflow:auto;">
                                        <table id="dt-basic-example"
                                            class="table table-bordered table-hover table-striped ">
                                            <thead class="bg-highlight">
                                                <tr>
                                                    <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Arabic_Name')}}</th>
                                                    <th>{{trans('admin.English_Name')}}</th>
                                                    <th>{{trans('admin.Emp_Type')}}</th>
                                                    <th>{{trans('admin.Salary')}}</th>
                                                    <th>{{trans('admin.Job')}}</th>
                                                    <th>{{trans('admin.Department')}}</th>
                                                 
                                                    <th>{{trans('admin.Account_Emp')}}</th>
                                                 
                                                    <th>{{trans('admin.Details')}}</th>
                                                    <th>{{trans('admin.Ratio')}}</th>
                                                     <th>{{trans('admin.Stores')}}</th>
                                                     <th>{{trans('admin.Allowances')}}</th>
                                                     <th>{{trans('admin.production_quantity')}}</th>
                                                     <th>{{trans('admin.Attendence_Policy')}}</th>
                                                     <th>{{trans('admin.Departure_Policy')}}</th>
                                                     <th>{{trans('admin.Discounts')}}</th>
                                                     <th>{{trans('admin.Data')}}</th>
                                                    <th>{{trans('admin.Actions')}} </th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($items as $item)
                                                 <tr @if($item->Delete == 1) class="deleted" @endif>
                                                    <td>{{$item->Code}}</td>
                                                    <td>{{$item->Name}}</td>
                                                    <td>{{$item->NameEn}}</td>
                                                    <td>
                                                    @if($item->Emp_Type == 'Manager')
                                                        {{trans('admin.Manager')}}
                                                 @elseif($item->Emp_Type == 'Production_Manager')
                                                         {{trans('admin.Production_Manager')}}
                                                    @elseif($item->Emp_Type == 'Saller')
                                                        {{trans('admin.Saller')}}
                                                    @elseif($item->Emp_Type == 'Buyer')
                                                        {{trans('admin.Buyer')}}
                                                    @elseif($item->Emp_Type == 'Driver')
                                                        {{trans('admin.Driver')}}
                                                    @elseif($item->Emp_Type == 'Engineer')
                                                        {{trans('admin.Engineer')}}
                                                    @elseif($item->Emp_Type == 'Techinical')
                                                        {{trans('admin.Techinical')}}
                                                    @elseif($item->Emp_Type == 'Delivery')
                                                        {{trans('admin.Delivery')}}
                                                    @elseif($item->Emp_Type == 'Designer')
                                                        {{trans('admin.Designer')}}
                                                    @elseif($item->Emp_Type == 'Programmer')
                                                        {{trans('admin.Programmer')}}
                                                    @elseif($item->Emp_Type == 'Accountant')
                                                        {{trans('admin.Accountant')}}
                                                    @elseif($item->Emp_Type == 'StoreKeeper')
                                                        {{trans('admin.Store_Keeper')}}
                                                    @elseif($item->Emp_Type == 'ObserverQuality')
                                                        {{trans('admin.Observer_Quality')}}
                                                    @elseif($item->Emp_Type == 'Supervisor')
                                                        {{trans('admin.Supervisor')}}
                                                    @elseif($item->Emp_Type == 'Doctor')
                                                        {{trans('admin.Doctor')}}
                                                    @elseif($item->Emp_Type == 'Teacher')
                                                        {{trans('admin.Teacher')}}
                                                    @elseif($item->Emp_Type == 'Worker')
                                                        {{trans('admin.Worker')}}
                                                    @elseif($item->Emp_Type == 'Nurse')
                                                        {{trans('admin.Nurse')}}
                                                    @elseif($item->Emp_Type == 'Cashier')
                                                        {{trans('admin.Cashier')}}
                                                    @elseif($item->Emp_Type == 'Chef')
                                                        {{trans('admin.Chef')}}
                                                    @elseif($item->Emp_Type == 'Waiter')
                                                        {{trans('admin.Waiter')}}
                                                    @elseif($item->Emp_Type == 'Secuirty')
                                                        {{trans('admin.Secuirty')}}
                                                    @endif
                                                    </td>
                                                    <td>{{$item->Salary}}</td>

                                                     <td>
                                                         @if(!empty($item->Job()->first()->Arabic_Name))


                                                             {{app()->getLocale() == 'ar' ?$item->Job()->first()->Arabic_Name :$item->Job()->first()->English_Name}}
                                                         @endif
                                                     </td>
                                                     <td>
                                                         @if(!empty($item->Department()->first()->Arabic_Name))


                                                             {{app()->getLocale() == 'ar' ?$item->Department()->first()->Arabic_Name :$item->Department()->first()->English_Name}}
                                                         @endif
                                                     </td>

                                                     <td>
                                                         @if(!empty($item->Account_Emp()->first()->Code))
                                                             {{$item->Account_Emp()->first()->Code}}
                                                         @endif

                                                     </td>
                                                    <td>
                                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center-open{{$item->id}}">
                                                            {{trans('admin.Details')}}
                                                        </button>
                                                    </td>
                                                         <td>
                                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#ratio{{$item->id}}">
                                                            {{trans('admin.Ratio')}}
                                                        </button>
                                                    </td>

                                                              <td>
                                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Stores{{$item->id}}">
                                                            {{trans('admin.Stores')}}
                                                        </button>
                                                    </td>


                                                                     <td>
                                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Allownces{{$item->id}}">
                                                            {{trans('admin.Allowances')}}
                                                        </button>
                                                    </td>


                                                                                 <td>
                                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#PrQ{{$item->id}}">
                                                            {{trans('admin.production_quantity')}}
                                                        </button>
                                                    </td>


                                                                                          <td>
                                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Attendence_Policy{{$item->id}}">
                                                            {{trans('admin.Attendence_Policy')}}
                                                        </button>
                                                    </td>


                                                                                          <td>
                                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Departure_Policy{{$item->id}}">
                                                            {{trans('admin.Departure_Policy')}}
                                                        </button>
                                                    </td>


                                                                     <td>
                                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Discounts{{$item->id}}">
                                                            {{trans('admin.Discounts')}}
                                                        </button>
                                                    </td>

                                                            <td>
                                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Data{{$item->id}}">
                                                            {{trans('admin.Data')}}
                                                        </button>
                                                    </td>

                                                    <td class="text-center">


                                                        @if($item->Delete == 0)

                                                            @can('حذف موظف')
                                                                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>
                                                            @endcan


                                                            @can('تعديل موظف')
                                                                <a href="{{url('EditEmp/'.$item->id)}}" class="btn btn-default"><i class="fal fa-edit"></i></a>
                                                            @endcan

                                                            <a href="{{url('PrintEmp/'.$item->id)}}" class="btn btn-default"><i class="fal fa-print"></i></a>
                                                            <a href="{{url('PrintCardEmp/'.$item->id)}}" class="btn btn-default"><i class="fal fa-id-card"></i></a>

                                                                <a href="{{url('TransToEmp/'.$item->id)}}" class="btn btn-default" ><i class="fal fa-arrow-right"></i></a>

                                                        @endif

                                                        @if($item->Delete == 1)

                                                            <span class="btn btn-danger">{{trans('admin.Deleted')}}</span>

                                                        @endif




                                                    </td>
                                                </tr>
                                                @endforeach

                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                         <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Arabic_Name')}}</th>
                                                    <th>{{trans('admin.English_Name')}}</th>
                                                    <th>{{trans('admin.Emp_Type')}}</th>
                                                    <th>{{trans('admin.Salary')}}</th>
                                                    <th>{{trans('admin.Job')}}</th>
                                                    <th>{{trans('admin.Department')}}</th>
                                                 
                                                    <th>{{trans('admin.Account_Emp')}}</th>
                                                 
                                                    <th>{{trans('admin.Details')}}</th>
                                                    <th>{{trans('admin.Ratio')}}</th>
                                                     <th>{{trans('admin.Stores')}}</th>
                                                     <th>{{trans('admin.Allowances')}}</th>
                                                     <th>{{trans('admin.production_quantity')}}</th>
                                                     <th>{{trans('admin.Attendence_Policy')}}</th>
                                                     <th>{{trans('admin.Departure_Policy')}}</th>
                                                     <th>{{trans('admin.Discounts')}}</th>
                                                     <th>{{trans('admin.Data')}}</th>
                                                    <th>{{trans('admin.Actions')}} </th>
                                                </tr>
                                            </tfoot>

                                        </table>
                                       </div>
                                        <!-- datatable end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </main>

@foreach($items as $item)
    <!-- Modal Delete -->
    <div class="modal fade" id="default-example-modal-center{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        {{trans('admin.RUSWDT')}} <strong>{{$item->Code}}</strong>
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.No')}}</button>
                    <a href="{{url('DeleteEmp/'.$item->id)}}" class="btn btn-primary">{{trans('admin.Yes')}}</a>
                </div>
            </div>
        </div>
    </div>


    <!-- Modal Details -->
    <div class="modal fade" id="default-example-modal-center-open{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        {{trans('admin.Details')}}
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-row">
                        <div class="mt-12" style="overflow:auto">
                            <table id="" class="table table-bordered table-hover table-striped " style="width:120%">
                                <thead>
                                <tr>
                                    <th>{{trans('admin.Attendence')}} </th>
                                    <th>{{trans('admin.Departure')}} </th>
                                    <th>{{trans('admin.Hours_Numbers')}} </th>
                                    <th>{{trans('admin.Days_Numbers')}} </th>
                                    <th>{{trans('admin.Day_Price')}} </th>
                                    <th>{{trans('admin.Image')}} </th>
                                    <th>{{trans('admin.Notes')}} </th>
                                    <th>{{trans('admin.Bank_Account')}} </th>
                                    <th>{{trans('admin.Qualifications')}} </th>
                                    <th>{{trans('admin.Address')}} </th>
                                    <th>{{trans('admin.Social_Status')}} </th>
                                    <th>{{trans('admin.ID_Number')}} </th>
                                    <th>{{trans('admin.Contract_Start')}} </th>
                                    <th>{{trans('admin.Contract_End')}} </th>
                                    <th>{{trans('admin.Phone')}} </th>
                                    <th>{{trans('admin.Phone2')}} </th>
                                    <th>{{trans('admin.Bill_Numbers')}} </th>
                                    <th>{{trans('admin.NumbersOfBill')}} </th>
                                    <th>{{trans('admin.IDExpireDate')}} </th>
                                    <th>{{trans('admin.LicensExpireDate')}} </th>
                                    <th>{{trans('admin.PassportExpireDate')}} </th>
                                    <th>{{trans('admin.Group')}} </th>
                                </tr>
                                </thead>
                                <tbody id="">
                                <tr>
                                    <td>{{$item->Attendence}}</td>
                                    <td>{{$item->Departure}}</td>
                                    <td>{{$item->Hours_Numbers}}</td>
                                    <td>{{$item->Days_Numbers}}</td>
                                    <td>{{$item->Day_Price}}</td>
                                    <td>
                                        <img class="img-fluid" src="{{URL::to($item->Image)}}">
                                    </td>
                                    <td>{{$item->Note}}</td>
                                    <td>{{$item->Bank_Account}}</td>
                                    <td>{{$item->Qualifications}}</td>
                                    <td>{{$item->Address}}</td>
                                    <td>{{$item->Social_Status}}</td>
                                    <td>{{$item->ID_Number}}</td>
                                    <td>{{$item->Contract_Start}}</td>
                                    <td>{{$item->Contract_End}}</td>
                                    <td>{{$item->Phone}}</td>
                                    <td>{{$item->Phone2}}</td>
                                    <td>

                                        @if($item->Bill_Num == 1)
                                            {{trans('admin.Yes')}}
                                        @else
                                            {{trans('admin.No')}}
                                        @endif

                                    </td>
                                    <td>{{$item->NumbersOfBill}}</td>
                                    <td>{{$item->IDExpireDate}}</td>
                                    <td>{{$item->LicensExpireDate}}</td>
                                    <td>{{$item->PassportExpireDate}}</td>
                                    <td>@if(!empty($item->Pro_Group()->first()->Name))


                                            {{app()->getLocale() == 'ar' ?$item->Pro_Group()->first()->Name :$item->Pro_Group()->first()->NameEn}}

                                        @endif
                                    </td>
                                </tr>
                                </tbody>

                            </table>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <!-- Modal Ratios -->
    <div class="modal fade" id="ratio{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        {{trans('admin.Ratio')}}
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                @php $ratios = EmpRatio::where('Emp',$item->id)->get(); @endphp
                <div class="modal-body">
                    <div class="form-row">
                        <div class="mt-12">
                            <table id="" class="table table-bordered table-hover table-striped w-100">
                                <thead>
                                <tr>
                                    <th>{{trans('admin.From')}} </th>
                                    <th>{{trans('admin.To')}} </th>
                                    <th>{{trans('admin.Salary')}} </th>
                                    <th>{{trans('admin.Rate')}} </th>
                                    <th>{{trans('admin.Rate_Type')}} </th>
                                </tr>
                                </thead>
                                <tbody id="">
                                @foreach($ratios as $rate)
                                    <tr>
                                        <td>{{$rate->From}}</td>
                                        <td>{{$rate->To}}</td>
                                        <td>{{$rate->Salary}}</td>
                                        <td>{{$rate->Rate}}</td>
                                        <td>{{$rate->Type}}</td>
                                    </tr>
                                @endforeach
                                </tbody>
                                <tfoot>
                                <tr>
                                    <th>{{trans('admin.From')}} </th>
                                    <th>{{trans('admin.To')}} </th>
                                    <th>{{trans('admin.Salary')}} </th>
                                    <th>{{trans('admin.Rate')}} </th>
                                    <th>{{trans('admin.Rate_Type')}} </th>
                                </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>


    <!-- Modal Stores -->
    <div class="modal fade" id="Stores{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        {{trans('admin.Ratio')}}
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                @php $posss = EmpPOSStores::where('Emp',$item->id)->get(); @endphp
                <div class="modal-body">
                    <div class="form-row">
                        <div class="mt-12">
                            <table id="" class="table table-bordered table-hover table-striped w-100">
                                <thead>
                                <tr>
                                    <th>{{trans('admin.Store')}} </th>
                                </tr>
                                </thead>
                                <tbody id="">
                                @foreach($posss as $rate)
                                    <tr>
                                        <td>
                                            @if(!empty($rate->Store()->first()->Name))



                                                {{app()->getLocale() == 'ar' ?$rate->Store()->first()->Name :$rate->Store()->first()->NameEn}}

                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>

                            </table>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>



    <!-- Modal Data -->
    <div class="modal fade" id="Data{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        {{trans('admin.Data')}}
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-row">
                        <div class="mt-12" style="overflow:auto">
                            <table id="" class="table table-bordered table-hover table-striped" style="width:120%">
                                <thead>
                                <tr>
                                    <th>{{trans('admin.CV')}} </th>
                                    <th>{{trans('admin.ID_Image')}} </th>
                                    <th>{{trans('admin.Criminal_status')}} </th>
                                    <th>{{trans('admin.Contract')}} </th>
                                    <th>{{trans('admin.health_certificate')}} </th>
                                    <th>{{trans('admin.Search_Card')}} </th>
                                    <th>{{trans('admin.Recruitment_certificate')}} </th>
                                    <th>{{trans('admin.employee_profile')}} </th>
                                    <th>{{trans('admin.duration_criminal_investigation')}} </th>
                                    <th>{{trans('admin.Birthdate')}} </th>
                                    <th>{{trans('admin.Attitude_recruiting')}} </th>
                                    <th>{{trans('admin.Job_Number')}} </th>
                                    <th>{{trans('admin.date_resignation')}} </th>
                                    <th>{{trans('admin.Living')}} </th>
                                    <th>{{trans('admin.Branch')}} </th>
                                    <th>{{trans('admin.Level')}} </th>
                                    <th>{{trans('admin.Nationality')}} </th>
                                    <th>{{trans('admin.Religion')}} </th>
                                    <th>{{trans('admin.Insurance_salary')}} </th>
                                    <th>{{trans('admin.Insurance_companies')}} </th>
                                    <th>{{trans('admin.Previous_experience')}} </th>
                                    <th>{{trans('admin.Account')}}</th>
                                    <th>{{trans('admin.User')}}</th>
                                    <th>{{trans('admin.MonthlyTarget')}}</th>
                                    <th>{{trans('admin.QuarterTarget')}}</th>
                                    <th>{{trans('admin.SemiTarget')}}</th>
                                    <th>{{trans('admin.YearlyTarget')}}</th>
                                    <th>{{trans('admin.SearchCode')}}</th>
                                </tr>
                                </thead>
                                <tbody id="">
                                <tr>

                                    <td>
                                        <img class="img-fluid" src="{{URL::to($item->CV)}}">
                                    </td>
                                    <td>
                                        <img class="img-fluid" src="{{URL::to($item->ID_Image)}}">
                                    </td>
                                    <td>
                                        <img class="img-fluid" src="{{URL::to($item->Criminal_status)}}">
                                    </td>
                                    <td>
                                        <img class="img-fluid" src="{{URL::to($item->Contract)}}">
                                    </td>
                                    <td>
                                        <img class="img-fluid" src="{{URL::to($item->health_certificate)}}">
                                    </td>
                                    <td>
                                        <img class="img-fluid" src="{{URL::to($item->Search_Card)}}">
                                    </td>
                                    <td>
                                        <img class="img-fluid" src="{{URL::to($item->Recruitment_certificate)}}">
                                    </td>
                                    <td>
                                        <img class="img-fluid" src="{{URL::to($item->employee_profile)}}">
                                    </td>
                                    <td>{{$item->duration_criminal_investigation}}</td>
                                    <td>{{$item->Birthdate}}</td>
                                    <td>{{$item->Attitude_recruiting}}</td>
                                    <td>{{$item->Job_Number}}</td>
                                    <td>{{$item->date_resignation}}</td>
                                    <td>{{$item->Living}}</td>
                                    <td>@if(!empty($item->Branch()->first()->Arabic_Name))

                                            {{app()->getLocale() == 'ar' ?$item->Branch()->first()->Arabic_Name :$item->Branch()->first()->English_Name}}
                                        @endif
                                    </td>
                                    <td>@if(!empty($item->Level()->first()->Arabic_Name))
                                            {{app()->getLocale() == 'ar' ?$item->Level()->first()->Arabic_Name :$item->Level()->first()->English_Name}}

                                        @endif
                                    </td>
                                    <td>@if(!empty($item->Nationality()->first()->Arabic_Name))
                                            {{app()->getLocale() == 'ar' ?$item->Nationality()->first()->Arabic_Name :$item->Nationality()->first()->English_Name}}

                                        @endif
                                    </td>
                                    <td>{{$item->Religion}}</td>
                                    <td>{{$item->Insurance_salary}}</td>
                                    <td>@if(!empty($item->Insurance_companies()->first()->Arabic_Name))

                                            {{app()->getLocale() == 'ar' ?$item->Insurance_companies()->first()->Arabic_Name :$item->Insurance_companies()->first()->English_Name}}
                                        @endif
                                    </td>
                                    <td>{{$item->Previous_experience}}</td>
                                    <td>
                                        @if(!empty($item->Account()->first()->Name))
                                            {{app()->getLocale() == 'ar' ?$item->Account()->first()->Name :$item->Account()->first()->NameEn}}
                                        @endif
                                    </td>
                                    <td>
                                        @if(!empty($item->User()->first()->name))
                                            {{app()->getLocale() == 'ar' ?$item->User()->first()->name :$item->User()->first()->nameEn}}
                                        @endif
                                    </td>
                                    <td>{{$item->MonthlyTarget}}</td>
                                    <td>{{$item->QuarterTarget}}</td>
                                    <td>{{$item->SemiTarget}}</td>
                                    <td>{{$item->YearlyTarget}}</td>
                                    <td>{{$item->SearchCode}}</td>

                                </tr>
                                </tbody>

                            </table>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>



    <!-- Modal Allownces -->
    <div class="modal fade" id="Allownces{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        {{trans('admin.Allowances')}}
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                @php $posss = AllowencesEmp::where('Emp',$item->id)->get(); @endphp
                <div class="modal-body">
                    <div class="form-row">
                        <div class="mt-12">
                            <table id="" class="table table-bordered table-hover table-striped w-100">
                                <thead>
                                <tr>
                                    <th>{{trans('admin.Name')}} </th>
                                    <th>{{trans('admin.Amount')}} </th>
                                </tr>
                                </thead>
                                <tbody id="">
                                @foreach($posss as $rate)
                                    <tr>
                                        <td>
                                            @if(!empty($rate->Allow()->first()->Arabic_Name))


                                                {{app()->getLocale() == 'ar' ?$rate->Allow()->first()->Arabic_Name :$rate->Allow()->first()->English_Name}}
                                            @endif
                                        </td>
                                        <td>

                                            {{$rate->AmountAllow}}

                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>

                            </table>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>



    <!-- Modal Discounts -->
    <div class="modal fade" id="Discounts{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        {{trans('admin.Discounts')}}
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                @php $posss = DiscountsEmp::where('Emp',$item->id)->get(); @endphp
                <div class="modal-body">
                    <div class="form-row">
                        <div class="mt-12">
                            <table id="" class="table table-bordered table-hover table-striped w-100">
                                <thead>
                                <tr>
                                    <th>{{trans('admin.Name')}} </th>
                                    <th>{{trans('admin.Amount')}} </th>
                                </tr>
                                </thead>
                                <tbody id="">
                                @foreach($posss as $rate)
                                    <tr>
                                        <td>
                                            @if(!empty($rate->Discount()->first()->Arabic_Name))


                                                {{app()->getLocale() == 'ar' ?$rate->Discount()->first()->Arabic_Name :$rate->Discount()->first()->English_Name}}
                                            @endif
                                        </td>
                                        <td>

                                            {{$rate->AmountDiscount}}

                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>

                            </table>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>



    <!-- Modal production_quantity -->
    <div class="modal fade" id="PrQ{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        {{trans('admin.production_quantity')}}
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                @php $posss = EmpsProducationQuantity::where('Emp',$item->id)->get(); @endphp
                <div class="modal-body">
                    <div class="form-row">
                        <div class="mt-12">
                            <table id="" class="table table-bordered table-hover table-striped w-100">
                                <thead>
                                <tr>
                                    <th>{{trans('admin.From')}} </th>
                                    <th>{{trans('admin.To')}} </th>
                                    <th>{{trans('admin.Value')}} </th>

                                </tr>
                                </thead>
                                <tbody id="">
                                @foreach($posss as $rate)
                                    <tr>
                                        <td>

                                            {{$rate->FromQ}}

                                        </td>
                                        <td>

                                            {{$rate->ToQ}}

                                        </td>
                                        <td>

                                            {{$rate->ValueQ}}

                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>

                            </table>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>


    <!-- Modal Attendence_Policy -->
    <div class="modal fade" id="Attendence_Policy{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        {{trans('admin.Attendence_Policy')}}
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                @php $posss = AttendencePolicyEmp::where('Emp',$item->id)->get(); @endphp
                <div class="modal-body">
                    <div class="form-row">
                        <div class="mt-12">
                            <table id="" class="table table-bordered table-hover table-striped w-100">
                                <thead>
                                <tr>
                                    <th>{{trans('admin.From')}} </th>
                                    <th>{{trans('admin.To')}} </th>
                                    <th>{{trans('admin.Discount')}} </th>

                                </tr>
                                </thead>
                                <tbody id="">
                                @foreach($posss as $rate)
                                    <tr>
                                        <td>

                                            {{$rate->From}}

                                        </td>
                                        <td>

                                            {{$rate->To}}

                                        </td>
                                        <td>

                                            {{$rate->Discount}}

                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>

                            </table>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>


    <!-- Modal Departure_Policy -->
    <div class="modal fade" id="Departure_Policy{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        {{trans('admin.Departure_Policy')}}
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                @php $posss = DepaarturePolicyEmp::where('Emp',$item->id)->get(); @endphp
                <div class="modal-body">
                    <div class="form-row">
                        <div class="mt-12">
                            <table id="" class="table table-bordered table-hover table-striped w-100">
                                <thead>
                                <tr>
                                    <th>{{trans('admin.From')}} </th>
                                    <th>{{trans('admin.To')}} </th>
                                    <th>{{trans('admin.Discount')}} </th>

                                </tr>
                                </thead>
                                <tbody id="">
                                @foreach($posss as $rate)
                                    <tr>
                                        <td>

                                            {{$rate->From}}

                                        </td>
                                        <td>

                                            {{$rate->To}}

                                        </td>
                                        <td>

                                            {{$rate->Discount}}

                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>

                            </table>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>


@endforeach



@endsection


@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
    <style>
        th{
            width:135px!important;
        }
    </style>
 <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search '  + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    // responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>

  <script>
    $(document).ready(function()
    {
        $(function()
        {
            $('.select2').select2();

            $(".select2-placeholder-multiple").select2(
            {
                placeholder: "Select State"
            });
            $(".js-hide-search").select2(
            {
                minimumResultsForSearch: 1 / 0
            });
            $(".js-max-length").select2(
            {
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items"
            });
            $(".select2-placeholder").select2(
            {
                placeholder: "Select a state",
                allowClear: true
            });

            $(".js-select2-icons").select2(
            {
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function(elm)
                {
                    return elm
                }
            });

            function icon(elm)
            {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
            }

            $(".js-data-example-ajax").select2(
            {
                ajax:
                {
                    url: "https://api.github.com/search/repositories",
                    dataType: 'json',
                    delay: 250,
                    data: function(params)
                    {
                        return {
                            q: params.term, // search term
                            page: params.page
                        };
                    },
                    processResults: function(data, params)
                    {
                        // parse the results into the format expected by Select2
                        // since we are using custom formatting functions we do not need to
                        // alter the remote JSON data, except to indicate that infinite
                        // scrolling can be used
                        params.page = params.page || 1;

                        return {
                            results: data.items,
                            pagination:
                            {
                                more: (params.page * 30) < data.total_count
                            }
                        };
                    },
                    cache: true
                },
                placeholder: 'Search for a repository',
                escapeMarkup: function(markup)
                {
                    return markup;
                }, // let our custom formatter work
                minimumInputLength: 1,
                templateResult: formatRepo,
                templateSelection: formatRepoSelection
            });

            function formatRepo(repo)
            {
                if (repo.loading)
                {
                    return repo.text;
                }

                var markup = "<div class='select2-result-repository clearfix d-flex'>" +
                    "<div class='select2-result-repository__avatar mr-2'><img src='" + repo.owner.avatar_url + "' class='width-2 height-2 mt-1 rounded' /></div>" +
                    "<div class='select2-result-repository__meta'>" +
                    "<div class='select2-result-repository__title fs-lg fw-500'>" + repo.full_name + "</div>";

                if (repo.description)
                {
                    markup += "<div class='select2-result-repository__description fs-xs opacity-80 mb-1'>" + repo.description + "</div>";
                }

                markup += "<div class='select2-result-repository__statistics d-flex fs-sm'>" +
                    "<div class='select2-result-repository__forks mr-2'><i class='fal fa-lightbulb'></i> " + repo.forks_count + " Forks</div>" +
                    "<div class='select2-result-repository__stargazers mr-2'><i class='fal fa-star'></i> " + repo.stargazers_count + " Stars</div>" +
                    "<div class='select2-result-repository__watchers mr-2'><i class='fal fa-eye'></i> " + repo.watchers_count + " Watchers</div>" +
                    "</div>" +
                    "</div></div>";

                return markup;
            }

            function formatRepoSelection(repo)
            {
                return repo.full_name || repo.text;
            }
        });
    });

</script>
<script>
    var autoSave = $('#autoSave');
    var interval;
    var timer = function()
    {
        interval = setInterval(function()
        {
            //start slide...
            if (autoSave.prop('checked'))
                saveToLocal();

            clearInterval(interval);
        }, 3000);
    };

    //save
    var saveToLocal = function()
    {
        localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
        console.log("saved");
    }

    //delete
    var removeFromLocal = function()
    {
        localStorage.removeItem("summernoteData");
        $('#saveToLocal').summernote('reset');
    }

    $(document).ready(function()
    {
        //init default
        $('.js-summernote').summernote(
        {
            height: 200,
            tabsize: 2,
            placeholder: "Type here...",
            dialogsFade: true,
            toolbar: [
                ['style', ['style']],
                ['font', ['strikethrough', 'superscript', 'subscript']],
                ['font', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['height', ['height']]
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ],
            callbacks:
            {
                //restore from localStorage
                onInit: function(e)
                {
                    $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                },
                onChange: function(contents, $editable)
                {
                    clearInterval(interval);
                    timer();
                }
            }
        });

        //load emojis
        $.ajax(
        {
            url: 'https://api.github.com/emojis',
            async: false
        }).then(function(data)
        {
            window.emojis = Object.keys(data);
            window.emojiUrls = data;
        });

        //init emoji example
        $(".js-hint2emoji").summernote(
        {
            height: 100,
            toolbar: false,
            placeholder: 'type starting with : and any alphabet',
            hint:
            {
                match: /:([\-+\w]+)$/,
                search: function(keyword, callback)
                {
                    callback($.grep(emojis, function(item)
                    {
                        return item.indexOf(keyword) === 0;
                    }));
                },
                template: function(item)
                {
                    var content = emojiUrls[item];
                    return '<img src="' + content + '" width="20" /> :' + item + ':';
                },
                content: function(item)
                {
                    var url = emojiUrls[item];
                    if (url)
                    {
                        return $('<img />').attr('src', url).css('width', 20)[0];
                    }
                    return '';
                }
            }
        });

        //init mentions example
        $(".js-hint2mention").summernote(
        {
            height: 100,
            toolbar: false,
            placeholder: "type starting with @",
            hint:
            {
                mentions: ['jayden', 'sam', 'alvin', 'david'],
                match: /\B@(\w*)$/,
                search: function(keyword, callback)
                {
                    callback($.grep(this.mentions, function(item)
                    {
                        return item.indexOf(keyword) == 0;
                    }));
                },
                content: function(item)
                {
                    return '@' + item;
                }
            }
        });

    });

</script>
<script type="text/javascript">


    $(".show-table").click(function(){
        $(".hide-table").show();
    });

</script>

@endpush
