@extends('admin.index')
@section('content')

  <title>{{trans('admin.PerivousMettings')}}</title>

    <main id="js-page-content" role="main" class="page-content">
                    <ol class="breadcrumb page-breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.CRM')}}</a></li>
                        <li class="breadcrumb-item active">{{trans('admin.PerivousMettings')}}</li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                                class="js-get-date"></span></li>
                    </ol>

                    <div class="row">
                        <div class="col-xl-12">
                            <div id="panel-1" class="panel">
                                <div class="panel-hdr">
                                    <h2>
                                         <span class="fw-300"><i>{{trans('admin.PerivousMettings')}}</i></span>
                                    </h2>

                                    <div class="panel-toolbar">
                                           @can('اضافه مقابله')
                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg">{{trans('admin.AddNew')}}</button>
                                         @endcan

                                        <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>

                                               @include('admin.layouts.toolbar')
                                    </div>

                                </div>
                                <div class="panel-container show">
                                   <span id="ex"> @include('admin.layouts.messages')</span>
                                    <div class="panel-content">
                                        <!-- datatable start -->
                                        <div style="overflow:auto;">
                                        <table id="dt-basic-example"
                                            class="table table-bordered table-hover table-striped ">
                                            <thead class="bg-highlight">
                                                <tr>
                                                    <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Date')}}</th>
                                                    <th>{{trans('admin.Time')}}</th>
                                                    <th>{{trans('admin.Notes')}}</th>
                                                    <th>{{trans('admin.Employee')}}</th>
                                                    <th>{{trans('admin.Client')}}</th>
                                                    <th>{{trans('admin.Phone')}}</th>

                                                    <th>{{trans('admin.InterviewType')}}</th>
                                                    <th>{{trans('admin.StatusNote')}}</th>
                                                    <th>{{trans('admin.Data')}}</th>
                                                    <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                            </thead>
                                            <tbody>

                                            @foreach($items as $item)
                                                    <tr>
                                                    <td>{{$item->Code}}</td>
                                                    <td>{{$item->Date}}</td>
                                                    <td>{{$item->Time}}</td>
                                                    <td>{{$item->Note}}</td>
                                                    <td>
                                                        @if(!empty($item->Emp()->first()->Name))
                                                 {{app()->getLocale() == 'ar' ?$item->Emp()->first()->Name :$item->Emp()->first()->NameEn}}
                                                        @endif

                                                    </td>
                                                    <td>
                                                        @if(!empty($item->Client()->first()->Name))
                                                  {{app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn}}
                                                        @endif
                                                        </td>
                                                    <td>
                                                         @if(!empty($item->Client()->first()->Phone))
                                                        {{$item->Client()->first()->Phone}}
                                                        @endif

                                                        </td>

                                                    <td>
                                                        @if(!empty($item->Type()->first()->Arabic_Name))
                                      {{app()->getLocale() == 'ar' ?$item->Type()->first()->Arabic_Name :$item->Type()->first()->English_Name}}
                                                        @endif
                                                        </td>
                                                        <td>
                                      <button type="button" class="btn btn-default" data-toggle="modal" data-target="#StatusNote{{$item->id}}"><i class="fal fa-book"></i></button>
                                    </td>
                                                                       <td>
                                                        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#show-data{{$item->id}}">
                                                           {{trans('admin.Data')}}
                                                        </button>
                                                    </td>
                                           <td>
                                      <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-user"></i></button>
                                    </td>

                                                </tr>
                                             @endforeach


                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                   <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Date')}}</th>
                                                    <th>{{trans('admin.Time')}}</th>
                                                    <th>{{trans('admin.Notes')}}</th>
                                                    <th>{{trans('admin.Employee')}}</th>
                                                    <th>{{trans('admin.Client')}}</th>
                                                    <th>{{trans('admin.Phone')}}</th>

                                                    <th>{{trans('admin.InterviewType')}}</th>
                                                    <th>{{trans('admin.StatusNote')}}</th>
                                                    <th>{{trans('admin.Data')}}</th>
                                                    <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                        </div>
                                        {{$items->Links()}}
                                        <!-- datatable end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


         @foreach($items as $item)

                      <!-- Modal Add -->
                      <div class="modal fade" id="default-example-modal-center{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">
                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>
                                   <div class="modal-body">
                                    <form action="{{url('AddNEWInterviews')}}" method="post">
                                        {!! csrf_field() !!}
                                              @honeypot
                                        <div class="form-row">

                                        <div class="form-group col-lg-4">
                                     <label class="form-label" for="simpleinput"> {{trans('admin.Date')}}</label>
            <input type="date" name="Date"  value="{{date('Y-m-d')}}" class="form-control" required >
                                        </div>
                                  <div class="form-group col-lg-4">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Time')}}</label>
                <input type="time" name="Time"  value='{{date("H:i", time())}}' class="form-control" required >
                                        </div>

                            <input type="hidden" name="Emp" value="{{$item->Emp}}">
                            <input type="hidden" name="Client" value="{{$item->Client}}">


                                                    <div class="form-group col-lg-4">
                                            <label class="form-label" for="simpleinput">{{trans('admin.InterviewType')}}</label>
              <select class="select2 form-control" name="Type" required>
                                <option value="">{{trans('admin.InterviewType')}}</option>
                                            @foreach($InterviewsTypes as $int)
                    <option value="{{$int->id}}">
                     {{app()->getLocale() == 'ar' ?$int->Arabic_Name :$int->English_Name}}
                  </option>
                                           @endforeach
                                            </select>
                                        </div>

                                         <div class="form-group col-lg-12">
                                <label class="form-label" for="simpleinput"> {{trans('admin.StatusNote')}}</label>
                                <textarea name="StatusNote" class="form-control">

                                        {{old('StatusNote')}}
                                        </textarea>
                                        </div>


                                        </div>
                                    <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                                    <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                                </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                        <!-- Modal Status Note -->
                      <div class="modal fade" id="StatusNote{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">
                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>
                                   <div class="modal-body">

                                       {{$item->StatusNote}}
                                    <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>

                                </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    <!-- Modal show data -->
    <div class="modal fade" id="show-data{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                             {{trans('admin.Data')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">
      <div style="overflow:auto;">
        <table id="" class="table table-bordered table-hover table-striped " >
                                            <thead class="bg-highlight">
                                                <tr>

                                   <th>{{trans('admin.Activity')}}</th>
                                                    <th>{{trans('admin.Governrate')}}</th>
                                                    <th>{{trans('admin.City')}}</th>
                                                    <th>{{trans('admin.Client_Status')}}</th>
                                                </tr>
                                            </thead>
                                            <tbody>

                                                <tr>
                                              <td>

                                                    @if(!empty($item->Client()->first()->Activity()->first()->Arabic_Name))
                                                       {{app()->getLocale() == 'ar' ?$item->Client()->first()->Activity()->first()->Arabic_Name :$item->Client()->first()->Activity()->first()->English_Name}}
                                                    @endif

                                                    </td>
                                                    <td>
                                                      @if(!empty($item->Client()->first()->Governrate()->first()->Arabic_Name))
                                                      {{app()->getLocale() == 'ar' ?$item->Client()->first()->Governrate()->first()->Arabic_Name :$item->Client()->first()->Governrate()->first()->English_Name}}
                                                    @endif
                                                    </td>
                                                    <td>
                                                      @if(!empty($item->Client()->first()->City()->first()->Arabic_Name))
                                               {{app()->getLocale() == 'ar' ?$item->Client()->first()->City()->first()->Arabic_Name :$item->Client()->first()->City()->first()->English_Name}}
                                                    @endif
                                                    </td>
                                                    <td>
                                                      @if(!empty($item->Client()->first()->ClientStatus()->first()->Arabic_Name))
                                                     {{app()->getLocale() == 'ar' ?$item->Client()->first()->ClientStatus()->first()->Arabic_Name :$item->Client()->first()->ClientStatus()->first()->English_Name}}
                                                    @endif
                                                    </td>

                                                </tr>


                                            </tbody>


                                        </table>

                                        </div>

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>

                        </div>
                    </div>
                </div>
            </div>



        @endforeach
                </main>

@endsection

@push('js')
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
  <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>

    <!-- Search Selecet -->
 <script>
        $(document).ready(function()
        {
            $(function()
            {
                $('.select2').select2();

                $(".select2-placeholder-multiple").select2(
                {
                    placeholder: "Select State"
                });
                $(".js-hide-search").select2(
                {
                    minimumResultsForSearch: 1 / 0
                });
                $(".js-max-length").select2(
                {
                    maximumSelectionLength: 2,
                    placeholder: "Select maximum 2 items"
                });
                $(".select2-placeholder").select2(
                {
                    placeholder: "Select a state",
                    allowClear: true
                });

                $(".js-select2-icons").select2(
                {
                    minimumResultsForSearch: 1 / 0,
                    templateResult: icon,
                    templateSelection: icon,
                    escapeMarkup: function(elm)
                    {
                        return elm
                    }
                });

                function icon(elm)
                {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
                }


  $('.Client').select2({
    placeholder: "select...",
    ajax: {
        type: "GET",
        dataType: 'json',
        url: 'AllClients',
        processResults: function (data) {
          return {
            results: $.map(data, function(obj, index) {
              return { id: index, text: obj };
            })
          };

            	console.log(data);

        },
       data: function (params) {


                   var query = {
                            search: params.term,
                        };


              $.ajax({
                              url: 'AllClientsJ/'+params.term,
                              type:"GET",
                              dataType:"json",
                              beforeSend: function(){
                                  $('#loader').css("visibility", "visible");
                              },

                              success:function(data) {
                                          $('.Client').empty();
                                  $.each(data, function(key, value){

                         $('.Client').append('<option value="'+ key +'">' + value + '</option>');

                                  });
                              },
                              complete: function(){
                                  $('#loader').css("visibility", "hidden");
                              }
                          });



        }
    }
  });


$('.Client').on('select2:select', function (e) {
	console.log("select done", e.params.data);
});



          $('#Client').select2({
    placeholder: "select...",
    ajax: {
        type: "GET",
        dataType: 'json',
        url: 'AllClients',
        processResults: function (data) {
          return {
            results: $.map(data, function(obj, index) {
              return { id: index, text: obj };
            })
          };

            	console.log(data);

        },
       data: function (params) {


                   var query = {
                            search: params.term,
                        };


              $.ajax({
                              url: 'AllClientsJ/'+params.term,
                              type:"GET",
                              dataType:"json",
                              beforeSend: function(){
                                  $('#loader').css("visibility", "visible");
                              },

                              success:function(data) {
                                          $('#Client').empty();
                                  $.each(data, function(key, value){

                         $('#Client').append('<option value="'+ key +'">' + value + '</option>');

                                  });
                              },
                              complete: function(){
                                  $('#loader').css("visibility", "hidden");
                              }
                          });



        }
    }
  });


$('#Client').on('select2:select', function (e) {
	console.log("select done", e.params.data);
});



            });
        });



    </script>

    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    // responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>

<!-- Add New Client -->
<script>
    function NewClients(){

    var Governrate = $('#Governrate').val();
    var City = $('#City').val();
    var Activity = $('#Activity').val();
    var Responsible = $('#Responsible').val();
    var Platform = $('#Platform').val();
    var Campagin = $('#Campagin').val();
    var Name = $('#Name').val();
    var PriceLevel = $('#PriceLevel').val();
    var Phone = $('#Phone').val();

          if(Name) {
                         $.ajax({
                             url: 'AddNewClientAjax',
                             type:"GET",
                             data:{
                                Governrate:Governrate,
                                City:City,
                                Activity:Activity,
                                Responsible:Responsible,
                                Platform:Platform,
                                Campagin:Campagin,
                                Name:Name,
                                PriceLevel:PriceLevel,
                                Phone:Phone
                             },
                             dataType:"json",
                             beforeSend: function(){
                                 $('#loader').css("visibility", "visible");
                             },

                             success:function(data) {
                                 $.each(data, function(key, value){

                     alert('تم الاضافه بنجاح');

     $('#Governrate').val('');
     $('#City').val('');
     $('#Activity').val('');
     $('#Responsible').val('');
     $('#Platform').val('');
     $('#Campagin').val('');
     $('#Name').val('');
     $('#PriceLevel').val('');
     $('#Phone').val('');


                                 });
                             },
                             complete: function(){
                                 $('#loader').css("visibility", "hidden");
                             }
                         });
                     }else{

                        alert('حقل الاسم مطلوب');

                     }



    }
</script>

<!-- Filter Governrate and City !-->
<script>
   $(document).ready(function() {

       $('#Governrate').on('change', function(){
           var countryId = $(this).val();
           if(countryId) {
               $.ajax({
                   url: 'GovernrateFilter/'+countryId,
                   type:"GET",
                   dataType:"json",
                   beforeSend: function(){
                       $('#loader').css("visibility", "visible");
                   },

                   success:function(data) {

                       $('#City').empty();

                       $.each(data, function(key, value){

             $('#City').append('<option value="'+ key +'">' + value + '</option>');

                       });
                   },
                   complete: function(){
                       $('#loader').css("visibility", "hidden");
                   }
               });
           } else {

               $('select[name="states"]').empty();
           }

       });

   });

   $(document).ready(function() {


           var countryId = $('#Governrate').val();
           if(countryId) {
               $.ajax({
                   url: 'GovernrateFilter/'+countryId,
                   type:"GET",
                   dataType:"json",
                   beforeSend: function(){
                       $('#loader').css("visibility", "visible");
                   },

                   success:function(data) {

                       $('#City').empty();

                       $.each(data, function(key, value){

             $('#City').append('<option value="'+ key +'">' + value + '</option>');

                       });
                   },
                   complete: function(){
                       $('#loader').css("visibility", "hidden");
                   }
               });
           } else {

               $('select[name="states"]').empty();
           }


   });
</script>
<!-- Filter Platform and Campaigns !-->
<script>
   $(document).ready(function() {

       $('#Platform').on('change', function(){
           var countryId = $(this).val();
           if(countryId) {
               $.ajax({
                   url: 'PlatformFilter/'+countryId,
                   type:"GET",
                   dataType:"json",
                   beforeSend: function(){
                       $('#loader').css("visibility", "visible");
                   },

                   success:function(data) {

                       $('#Campagin').empty();

                       $.each(data, function(key, value){

             $('#Campagin').append('<option value="'+ key +'">' + value + '</option>');

                       });
                   },
                   complete: function(){
                       $('#loader').css("visibility", "hidden");
                   }
               });
           } else {

               $('select[name="states"]').empty();
           }

       });

   });

    $(document).ready(function() {

           var countryId = $('#Platform').val();
           if(countryId) {
               $.ajax({
                   url: 'PlatformFilter/'+countryId,
                   type:"GET",
                   dataType:"json",
                   beforeSend: function(){
                       $('#loader').css("visibility", "visible");
                   },

                   success:function(data) {

                       $('#Campagin').empty();

                       $.each(data, function(key, value){

             $('#Campagin').append('<option value="'+ key +'">' + value + '</option>');

                       });
                   },
                   complete: function(){
                       $('#loader').css("visibility", "hidden");
                   }
               });
           } else {

               $('select[name="states"]').empty();
           }



   });
</script>

@endpush

