@extends('admin.index')
@section('content')

    <title>{{trans('admin.Itinerary')}}</title>

    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.CRM')}}</a></li>
            <li class="breadcrumb-item active">{{trans('admin.Itinerary')}}</li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                    class="js-get-date"></span></li>
        </ol>

        <div class="row">
            <div class="col-xl-12">
                <div id="panel-1" class="panel">
                    <div class="panel-hdr">
                        <h2>
                            <span class="fw-300"><i>{{trans('admin.Itinerary')}}</i></span>
                        </h2>

                        <div class="panel-toolbar">

                            @include('admin.layouts.toolbar')
                        </div>

                    </div>
                    <div class="panel-container show">
                        <span id="ex"> @include('admin.layouts.messages')</span>
                        <div class="panel-content">

                        <div class="row">

                           <div class="col-md-2">
                               <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#Sat">{{trans('admin.Sat')}}</button>
                           </div>
                           <div class="col-md-2">
                               <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#Sun">{{trans('admin.Sun')}}</button>
                           </div>
                           <div class="col-md-2">
                                    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#Mon">{{trans('admin.Mon')}}</button>
                           </div>
                           <div class="col-md-2">
                             <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#Tue">{{trans('admin.Tue')}}</button>
                           </div>
                           <div class="col-md-2">
                                  <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#Wed">{{trans('admin.Wed')}}</button>
                           </div>
                           <div class="col-md-1">
                                <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#Thr">{{trans('admin.Thr')}}</button>
                           </div>
                           <div class="col-md-1">
                             <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#Fri">{{trans('admin.Fri')}}</button>
                           </div>

                        </div>

                        </div>
                        <!-- datatable end -->
                    </div>
                </div>
            </div>
        </div>
        </div>


    </main>


    <!-- Modal Sat -->
    <div class="modal fade" id="Sat" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        {{trans('admin.Sat')}}
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">

                    <div id="mobile-overflow m-2">
                        <table
                               class="table table-bordered table-hover table-striped w-100 mobile-width">
                            <thead class="bg-highlight">
                            <tr>
                                <th>{{trans('admin.Time')}}</th>
                                <th>{{trans('admin.Client')}}</th>
                                <th>{{trans('admin.Phone')}}</th>
                                <th>{{trans('admin.City')}}</th>
                                <th>{{trans('admin.Place')}}</th>
                                <th>{{trans('admin.Address')}}</th>
                                @if(auth()->guard('admin')->user()->emp == 0)
                                <th>{{trans('admin.Actions')}}</th>
                                @endif
                            </tr>
                            </thead>
                            <tbody>

                            @foreach($items as $item)

                               @if($item->Day == 'Sat')

                                   @if(!empty($item->Client))
                                       @php
                                           $cust=\App\Models\Customers::where('Account',$item->Client)->first();

                                
                                
                                if(!empty($cust->City)){
                                           if(!empty($cust->City()->first()->Arabic_Name)){

                                        $city=app()->getLocale() == 'ar' ?$cust->City()->first()->Arabic_Name :$cust->City()->first()->English_Name;

                                 }else{
                                               $city='';
                                 }
                                
                                
                                }else{
                                  $city='';
                                
                                }
                                
                                
                                
                                
                                   if(!empty($cust->Place)){    
                                           if(!empty($cust->Place()->first()->Arabic_Name)){

                                        $place=app()->getLocale() == 'ar' ?$cust->Place()->first()->Arabic_Name :$cust->Place()->first()->English_Name;

                                 }else{
                                               $place='';
                                 }
                                
                                }else{
                                               $place='';
                                 }




  if(!empty($cust)){
      $phone=$cust->Phone;
      $address=$cust->Address;
  }else{
     $phone='';
     $address='';
  }



                                       @endphp

                                   @endif
                                <tr>

<td>{{$item->Time}}</td>
                                    <td>

                                        @if(!empty($item->Client()->first()->Name))

                                        {{app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn}}

                                        @endif

                                    </td>
                                    <td>{{$phone}}</td>
                                    <td>{{$city}}</td>
                                    <td>{{$place}}</td>
                                    <td>{{$address}}</td>

                                    @if(auth()->guard('admin')->user()->emp == 0)
                                    <td>

                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>

                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg-edit{{$item->id}}"><i class="fal fa-edit"></i></button>

                                    </td>
                                    @endif

                                </tr>
                               @endif
                            @endforeach


                            </tbody>
                        </table>
                    </div>



                    @if(auth()->guard('admin')->user()->emp == 0)
                        <form action="{{url('AddItinerary')}}" method="post">
                            {!! csrf_field() !!}
                            @honeypot
                    <div class="row p-3">

                        <div class="col-lg-12 p-3">
{{trans('admin.AddNew')}}
                        </div>
                            <input type="hidden" name="Emp" value="{{$emp}}">
                            <input type="hidden" name="Day" value="Sat">


                            <div class="form-row">

                                <div class="form-group col-lg-6">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Client')}}</label>
                                    <select class="select2 form-control"  name="Client" required>
                                        <option value="">{{trans('admin.Client')}}</option>
                                        @foreach($Clients as $cli)
                                            <option value="{{$cli->id}}">   {{app()->getLocale() == 'ar' ?$cli->Name :$cli->NameEn}}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="form-group col-lg-6">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Time')}}</label>
                                    <input type="time" name="Time"     class="form-control" required >
                                </div>


                            </div>

                            <div class="modal-footer">

                                <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                            </div>



                    </div>
                        </form>
                    @endif



                </div>
                <div class="modal-footer">

                    <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>
                </div>
            </div>
        </div>
    </div>



    <!-- Modal Sun -->
    <div class="modal fade" id="Sun" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        {{trans('admin.Sun')}}
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">

                    <div id="mobile-overflow m-2">
                        <table
                            class="table table-bordered table-hover table-striped w-100 mobile-width">
                            <thead class="bg-highlight">
                            <tr>
                                <th>{{trans('admin.Time')}}</th>
                                <th>{{trans('admin.Client')}}</th>
                                <th>{{trans('admin.Phone')}}</th>
                                <th>{{trans('admin.City')}}</th>
                                <th>{{trans('admin.Place')}}</th>
                                <th>{{trans('admin.Address')}}</th>
                                @if(auth()->guard('admin')->user()->emp == 0)
                                    <th>{{trans('admin.Actions')}}</th>
                                @endif
                            </tr>
                            </thead>
                            <tbody>

                            @foreach($items as $item)

                                @if($item->Day == 'Sun')

                                    @if(!empty($item->Client))
                                        @php
                                            $cust=\App\Models\Customers::where('Account',$item->Client)->first();
            if(!empty($cust->City()->first()->Arabic_Name)){

                                        $city=app()->getLocale() == 'ar' ?$cust->City()->first()->Arabic_Name :$cust->City()->first()->English_Name;

                                 }else{
                                               $city='';
                                 }
                                           if(!empty($cust->Place()->first()->Arabic_Name)){

                                        $place=app()->getLocale() == 'ar' ?$cust->Place()->first()->Arabic_Name :$cust->Place()->first()->English_Name;

                                 }else{
                                               $place='';
                                 }



  if(!empty($cust)){
      $phone=$cust->Phone;
      $address=$cust->Address;
  }else{
     $phone='';
     $address='';
  }


                                        @endphp

                                    @endif
                                    <tr>

                                        <td>{{$item->Time}}</td>
                                        <td>

                                            @if(!empty($item->Client()->first()->Name))

                                                {{app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn}}

                                            @endif

                                        </td>
                                        <td>{{$phone}}</td>
                                        <td>{{$city}}</td>
                                        <td>{{$place}}</td>
                                        <td>{{$address}}</td>

                                        @if(auth()->guard('admin')->user()->emp == 0)
                                            <td>

                                                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>

                                                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg-edit{{$item->id}}"><i class="fal fa-edit"></i></button>

                                            </td>
                                        @endif

                                    </tr>
                                @endif
                            @endforeach


                            </tbody>
                        </table>
                    </div>



                    @if(auth()->guard('admin')->user()->emp == 0)
                        <form action="{{url('AddItinerary')}}" method="post">
                            {!! csrf_field() !!}
                            @honeypot
                            <div class="row p-3">

                                <div class="col-lg-12 p-3">
                                    {{trans('admin.AddNew')}}
                                </div>
                                <input type="hidden" name="Emp" value="{{$emp}}">
                                <input type="hidden" name="Day" value="Sun">


                                <div class="form-row">

                                    <div class="form-group col-lg-6">
                                        <label class="form-label" for="simpleinput">{{trans('admin.Client')}}</label>
                                        <select class="select2 form-control"  name="Client" required>
                                            <option value="">{{trans('admin.Client')}}</option>
                                            @foreach($Clients as $cli)
                                                <option value="{{$cli->id}}">   {{app()->getLocale() == 'ar' ?$cli->Name :$cli->NameEn}}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="form-group col-lg-6">
                                        <label class="form-label" for="simpleinput"> {{trans('admin.Time')}}</label>
                                        <input type="time" name="Time"     class="form-control" required >
                                    </div>


                                </div>

                                <div class="modal-footer">

                                    <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                                </div>



                            </div>
                        </form>
                    @endif



                </div>
                <div class="modal-footer">

                    <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>
                </div>
            </div>
        </div>
    </div>


    <!-- Modal Mon -->
    <div class="modal fade" id="Mon" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        {{trans('admin.Mon')}}
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">

                    <div id="mobile-overflow m-2">
                        <table
                            class="table table-bordered table-hover table-striped w-100 mobile-width">
                            <thead class="bg-highlight">
                            <tr>
                                <th>{{trans('admin.Time')}}</th>
                                <th>{{trans('admin.Client')}}</th>
                                <th>{{trans('admin.Phone')}}</th>
                                <th>{{trans('admin.City')}}</th>
                                <th>{{trans('admin.Place')}}</th>
                                <th>{{trans('admin.Address')}}</th>
                                @if(auth()->guard('admin')->user()->emp == 0)
                                    <th>{{trans('admin.Actions')}}</th>
                                @endif
                            </tr>
                            </thead>
                            <tbody>

                            @foreach($items as $item)

                                @if($item->Day == 'Mon')

                                    @if(!empty($item->Client))
                                        @php
                                            $cust=\App\Models\Customers::where('Account',$item->Client)->first();
            if(!empty($cust->City()->first()->Arabic_Name)){

                                        $city=app()->getLocale() == 'ar' ?$cust->City()->first()->Arabic_Name :$cust->City()->first()->English_Name;

                                 }else{
                                               $city='';
                                 }
                                           if(!empty($cust->Place()->first()->Arabic_Name)){

                                        $place=app()->getLocale() == 'ar' ?$cust->Place()->first()->Arabic_Name :$cust->Place()->first()->English_Name;

                                 }else{
                                               $place='';
                                 }




  if(!empty($cust)){
      $phone=$cust->Phone;
      $address=$cust->Address;
  }else{
     $phone='';
     $address='';
  }


                                        @endphp

                                    @endif
                                    <tr>

                                        <td>{{$item->Time}}</td>
                                        <td>

                                            @if(!empty($item->Client()->first()->Name))

                                                {{app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn}}

                                            @endif

                                        </td>
                                        <td>{{$phone}}</td>
                                        <td>{{$city}}</td>
                                        <td>{{$place}}</td>
                                        <td>{{$address}}</td>

                                        @if(auth()->guard('admin')->user()->emp == 0)
                                            <td>

                                                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>

                                                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg-edit{{$item->id}}"><i class="fal fa-edit"></i></button>

                                            </td>
                                        @endif

                                    </tr>
                                @endif
                            @endforeach


                            </tbody>
                        </table>
                    </div>



                    @if(auth()->guard('admin')->user()->emp == 0)
                        <form action="{{url('AddItinerary')}}" method="post">
                            {!! csrf_field() !!}
                            @honeypot
                            <div class="row p-3">

                                <div class="col-lg-12 p-3">
                                    {{trans('admin.AddNew')}}
                                </div>
                                <input type="hidden" name="Emp" value="{{$emp}}">
                                <input type="hidden" name="Day" value="Mon">


                                <div class="form-row">

                                    <div class="form-group col-lg-6">
                                        <label class="form-label" for="simpleinput">{{trans('admin.Client')}}</label>
                                        <select class="select2 form-control"  name="Client" required>
                                            <option value="">{{trans('admin.Client')}}</option>
                                            @foreach($Clients as $cli)
                                                <option value="{{$cli->id}}">   {{app()->getLocale() == 'ar' ?$cli->Name :$cli->NameEn}}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="form-group col-lg-6">
                                        <label class="form-label" for="simpleinput"> {{trans('admin.Time')}}</label>
                                        <input type="time" name="Time"     class="form-control" required >
                                    </div>


                                </div>

                                <div class="modal-footer">

                                    <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                                </div>



                            </div>
                        </form>
                    @endif



                </div>
                <div class="modal-footer">

                    <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>
                </div>
            </div>
        </div>
    </div>



    <!-- Modal Tue -->
    <div class="modal fade" id="Tue" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        {{trans('admin.Tue')}}
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">

                    <div id="mobile-overflow m-2">
                        <table
                            class="table table-bordered table-hover table-striped w-100 mobile-width">
                            <thead class="bg-highlight">
                            <tr>
                                <th>{{trans('admin.Time')}}</th>
                                <th>{{trans('admin.Client')}}</th>
                                <th>{{trans('admin.Phone')}}</th>
                                <th>{{trans('admin.City')}}</th>
                                <th>{{trans('admin.Place')}}</th>
                                <th>{{trans('admin.Address')}}</th>
                                @if(auth()->guard('admin')->user()->emp == 0)
                                    <th>{{trans('admin.Actions')}}</th>
                                @endif
                            </tr>
                            </thead>
                            <tbody>

                            @foreach($items as $item)

                                @if($item->Day == 'Tue')

                                    @if(!empty($item->Client))
                                        @php
                                            $cust=\App\Models\Customers::where('Account',$item->Client)->first();
            if(!empty($cust->City()->first()->Arabic_Name)){

                                        $city=app()->getLocale() == 'ar' ?$cust->City()->first()->Arabic_Name :$cust->City()->first()->English_Name;

                                 }else{
                                               $city='';
                                 }
                                           if(!empty($cust->Place()->first()->Arabic_Name)){

                                        $place=app()->getLocale() == 'ar' ?$cust->Place()->first()->Arabic_Name :$cust->Place()->first()->English_Name;

                                 }else{
                                               $place='';
                                 }



  if(!empty($cust)){
      $phone=$cust->Phone;
      $address=$cust->Address;
  }else{
     $phone='';
     $address='';
  }


                                        @endphp

                                    @endif
                                    <tr>

                                        <td>{{$item->Time}}</td>
                                        <td>

                                            @if(!empty($item->Client()->first()->Name))

                                                {{app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn}}

                                            @endif

                                        </td>
                                        <td>{{$phone}}</td>
                                        <td>{{$city}}</td>
                                        <td>{{$place}}</td>
                                        <td>{{$address}}</td>

                                        @if(auth()->guard('admin')->user()->emp == 0)
                                            <td>

                                                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>

                                                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg-edit{{$item->id}}"><i class="fal fa-edit"></i></button>

                                            </td>
                                        @endif

                                    </tr>
                                @endif
                            @endforeach


                            </tbody>
                        </table>
                    </div>



                    @if(auth()->guard('admin')->user()->emp == 0)
                        <form action="{{url('AddItinerary')}}" method="post">
                            {!! csrf_field() !!}
                            @honeypot
                            <div class="row p-3">

                                <div class="col-lg-12 p-3">
                                    {{trans('admin.AddNew')}}
                                </div>
                                <input type="hidden" name="Emp" value="{{$emp}}">
                                <input type="hidden" name="Day" value="Tue">


                                <div class="form-row">

                                    <div class="form-group col-lg-6">
                                        <label class="form-label" for="simpleinput">{{trans('admin.Client')}}</label>
                                        <select class="select2 form-control"  name="Client" required>
                                            <option value="">{{trans('admin.Client')}}</option>
                                            @foreach($Clients as $cli)
                                                <option value="{{$cli->id}}">   {{app()->getLocale() == 'ar' ?$cli->Name :$cli->NameEn}}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="form-group col-lg-6">
                                        <label class="form-label" for="simpleinput"> {{trans('admin.Time')}}</label>
                                        <input type="time" name="Time"     class="form-control" required >
                                    </div>


                                </div>

                                <div class="modal-footer">

                                    <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                                </div>



                            </div>
                        </form>
                    @endif



                </div>
                <div class="modal-footer">

                    <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>
                </div>
            </div>
        </div>
    </div>



    <!-- Modal Wed -->
    <div class="modal fade" id="Wed" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        {{trans('admin.Wed')}}
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">

                    <div id="mobile-overflow m-2">
                        <table
                            class="table table-bordered table-hover table-striped w-100 mobile-width">
                            <thead class="bg-highlight">
                            <tr>
                                <th>{{trans('admin.Time')}}</th>
                                <th>{{trans('admin.Client')}}</th>
                                <th>{{trans('admin.Phone')}}</th>
                                <th>{{trans('admin.City')}}</th>
                                <th>{{trans('admin.Place')}}</th>
                                <th>{{trans('admin.Address')}}</th>
                                @if(auth()->guard('admin')->user()->emp == 0)
                                    <th>{{trans('admin.Actions')}}</th>
                                @endif
                            </tr>
                            </thead>
                            <tbody>

                            @foreach($items as $item)

                                @if($item->Day == 'Wed')

                                    @if(!empty($item->Client))
                                        @php
                                            $cust=\App\Models\Customers::where('Account',$item->Client)->first();
            if(!empty($cust->City()->first()->Arabic_Name)){

                                        $city=app()->getLocale() == 'ar' ?$cust->City()->first()->Arabic_Name :$cust->City()->first()->English_Name;

                                 }else{
                                               $city='';
                                 }
                                           if(!empty($cust->Place()->first()->Arabic_Name)){

                                        $place=app()->getLocale() == 'ar' ?$cust->Place()->first()->Arabic_Name :$cust->Place()->first()->English_Name;

                                 }else{
                                               $place='';
                                 }

  if(!empty($cust)){
      $phone=$cust->Phone;
      $address=$cust->Address;
  }else{
     $phone='';
     $address='';
  }


                                        @endphp

                                    @endif
                                    <tr>

                                        <td>{{$item->Time}}</td>
                                        <td>

                                            @if(!empty($item->Client()->first()->Name))

                                                {{app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn}}

                                            @endif

                                        </td>
                                        <td>{{$phone}}</td>
                                        <td>{{$city}}</td>
                                        <td>{{$place}}</td>
                                        <td>{{$address}}</td>

                                        @if(auth()->guard('admin')->user()->emp == 0)
                                            <td>

                                                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>

                                                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg-edit{{$item->id}}"><i class="fal fa-edit"></i></button>

                                            </td>
                                        @endif

                                    </tr>
                                @endif
                            @endforeach


                            </tbody>
                        </table>
                    </div>



                    @if(auth()->guard('admin')->user()->emp == 0)
                        <form action="{{url('AddItinerary')}}" method="post">
                            {!! csrf_field() !!}
                            @honeypot
                            <div class="row p-3">

                                <div class="col-lg-12 p-3">
                                    {{trans('admin.AddNew')}}
                                </div>
                                <input type="hidden" name="Emp" value="{{$emp}}">
                                <input type="hidden" name="Day" value="Wed">


                                <div class="form-row">

                                    <div class="form-group col-lg-6">
                                        <label class="form-label" for="simpleinput">{{trans('admin.Client')}}</label>
                                        <select class="select2 form-control"  name="Client" required>
                                            <option value="">{{trans('admin.Client')}}</option>
                                            @foreach($Clients as $cli)
                                                <option value="{{$cli->id}}">   {{app()->getLocale() == 'ar' ?$cli->Name :$cli->NameEn}}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="form-group col-lg-6">
                                        <label class="form-label" for="simpleinput"> {{trans('admin.Time')}}</label>
                                        <input type="time" name="Time"     class="form-control" required >
                                    </div>


                                </div>

                                <div class="modal-footer">

                                    <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                                </div>



                            </div>
                        </form>
                    @endif



                </div>
                <div class="modal-footer">

                    <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>
                </div>
            </div>
        </div>
    </div>



    <!-- Modal Thr -->
    <div class="modal fade" id="Thr" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        {{trans('admin.Thr')}}
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">

                    <div id="mobile-overflow m-2">
                        <table
                            class="table table-bordered table-hover table-striped w-100 mobile-width">
                            <thead class="bg-highlight">
                            <tr>
                                <th>{{trans('admin.Time')}}</th>
                                <th>{{trans('admin.Client')}}</th>
                                <th>{{trans('admin.Phone')}}</th>
                                <th>{{trans('admin.City')}}</th>
                                <th>{{trans('admin.Place')}}</th>
                                <th>{{trans('admin.Address')}}</th>
                                @if(auth()->guard('admin')->user()->emp == 0)
                                    <th>{{trans('admin.Actions')}}</th>
                                @endif
                            </tr>
                            </thead>
                            <tbody>

                            @foreach($items as $item)

                                @if($item->Day == 'Thr')

                                    @if(!empty($item->Client))
                                        @php
                                            $cust=\App\Models\Customers::where('Account',$item->Client)->first();

                                   if(!empty($cust->City()->first()->Arabic_Name)){

                                        $city=app()->getLocale() == 'ar' ?$cust->City()->first()->Arabic_Name :$cust->City()->first()->English_Name;

                                 }else{
                                               $city='';
                                 }
                                           if(!empty($cust->Place()->first()->Arabic_Name)){

                                        $place=app()->getLocale() == 'ar' ?$cust->Place()->first()->Arabic_Name :$cust->Place()->first()->English_Name;

                                 }else{
                                               $place='';
                                 }



  if(!empty($cust)){
      $phone=$cust->Phone;
      $address=$cust->Address;
  }else{
     $phone='';
     $address='';
  }


                                        @endphp

                                    @endif
                                    <tr>

                                        <td>{{$item->Time}}</td>
                                        <td>

                                            @if(!empty($item->Client()->first()->Name))

                                                {{app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn}}

                                            @endif

                                        </td>
                                        <td>{{$phone}}</td>
                                        <td>{{$city}}</td>
                                        <td>{{$place}}</td>
                                        <td>{{$address}}</td>

                                        @if(auth()->guard('admin')->user()->emp == 0)
                                            <td>

                                                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>

                                                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg-edit{{$item->id}}"><i class="fal fa-edit"></i></button>

                                            </td>
                                        @endif

                                    </tr>
                                @endif
                            @endforeach


                            </tbody>
                        </table>
                    </div>



                    @if(auth()->guard('admin')->user()->emp == 0)
                        <form action="{{url('AddItinerary')}}" method="post">
                            {!! csrf_field() !!}
                            @honeypot
                            <div class="row p-3">

                                <div class="col-lg-12 p-3">
                                    {{trans('admin.AddNew')}}
                                </div>
                                <input type="hidden" name="Emp" value="{{$emp}}">
                                <input type="hidden" name="Day" value="Thr">


                                <div class="form-row">

                                    <div class="form-group col-lg-6">
                                        <label class="form-label" for="simpleinput">{{trans('admin.Client')}}</label>
                                        <select class="select2 form-control"  name="Client" required>
                                            <option value="">{{trans('admin.Client')}}</option>
                                            @foreach($Clients as $cli)
                                                <option value="{{$cli->id}}">   {{app()->getLocale() == 'ar' ?$cli->Name :$cli->NameEn}}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="form-group col-lg-6">
                                        <label class="form-label" for="simpleinput"> {{trans('admin.Time')}}</label>
                                        <input type="time" name="Time"     class="form-control" required >
                                    </div>


                                </div>

                                <div class="modal-footer">

                                    <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                                </div>



                            </div>
                        </form>
                    @endif



                </div>
                <div class="modal-footer">

                    <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>
                </div>
            </div>
        </div>
    </div>



    <!-- Modal Fri -->
    <div class="modal fade" id="Fri" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        {{trans('admin.Fri')}}
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">

                    <div id="mobile-overflow m-2">
                        <table
                            class="table table-bordered table-hover table-striped w-100 mobile-width">
                            <thead class="bg-highlight">
                            <tr>
                                <th>{{trans('admin.Time')}}</th>
                                <th>{{trans('admin.Client')}}</th>
                                <th>{{trans('admin.Phone')}}</th>
                                <th>{{trans('admin.City')}}</th>
                                <th>{{trans('admin.Place')}}</th>
                                <th>{{trans('admin.Address')}}</th>
                                @if(auth()->guard('admin')->user()->emp == 0)
                                    <th>{{trans('admin.Actions')}}</th>
                                @endif
                            </tr>
                            </thead>
                            <tbody>

                            @foreach($items as $item)

                                @if($item->Day == 'Fri')

                                    @if(!empty($item->Client))
                                        @php
                                            $cust=\App\Models\Customers::where('Account',$item->Client)->first();
            if(!empty($cust->City()->first()->Arabic_Name)){

                                        $city=app()->getLocale() == 'ar' ?$cust->City()->first()->Arabic_Name :$cust->City()->first()->English_Name;

                                 }else{
                                               $city='';
                                 }
                                           if(!empty($cust->Place()->first()->Arabic_Name)){

                                        $place=app()->getLocale() == 'ar' ?$cust->Place()->first()->Arabic_Name :$cust->Place()->first()->English_Name;

                                 }else{
                                               $place='';
                                 }



  if(!empty($cust)){
      $phone=$cust->Phone;
      $address=$cust->Address;
  }else{
     $phone='';
     $address='';
  }


                                        @endphp

                                    @endif
                                    <tr>

                                        <td>{{$item->Time}}</td>
                                        <td>

                                            @if(!empty($item->Client()->first()->Name))

                                                {{app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn}}

                                            @endif

                                        </td>
                                        <td>{{$phone}}</td>
                                        <td>{{$city}}</td>
                                        <td>{{$place}}</td>
                                        <td>{{$address}}</td>

                                        @if(auth()->guard('admin')->user()->emp == 0)
                                            <td>

                                                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>

                                                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg-edit{{$item->id}}"><i class="fal fa-edit"></i></button>

                                            </td>
                                        @endif

                                    </tr>
                                @endif
                            @endforeach


                            </tbody>
                        </table>
                    </div>



                    @if(auth()->guard('admin')->user()->emp == 0)
                        <form action="{{url('AddItinerary')}}" method="post">
                            {!! csrf_field() !!}
                            @honeypot
                            <div class="row p-3">

                                <div class="col-lg-12 p-3">
                                    {{trans('admin.AddNew')}}
                                </div>
                                <input type="hidden" name="Emp" value="{{$emp}}">
                                <input type="hidden" name="Day" value="Fri">


                                <div class="form-row">

                                    <div class="form-group col-lg-6">
                                        <label class="form-label" for="simpleinput">{{trans('admin.Client')}}</label>
                                        <select class="select2 form-control"  name="Client" required>
                                            <option value="">{{trans('admin.Client')}}</option>
                                            @foreach($Clients as $cli)
                                                <option value="{{$cli->id}}">   {{app()->getLocale() == 'ar' ?$cli->Name :$cli->NameEn}}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="form-group col-lg-6">
                                        <label class="form-label" for="simpleinput"> {{trans('admin.Time')}}</label>
                                        <input type="time" name="Time"     class="form-control" required >
                                    </div>


                                </div>

                                <div class="modal-footer">

                                    <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                                </div>



                            </div>
                        </form>
                    @endif



                </div>
                <div class="modal-footer">

                    <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}}</button>
                </div>
            </div>
        </div>
    </div>


    @foreach($items as $item)


        <!-- Modal Edit-->
        <div class="modal fade" id="default-example-modal-lg-edit{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">{{trans('admin.Edit')}}  </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form action="{{url('EditItinerary/'.$item->id)}}" method="post">
                            {!! csrf_field() !!}
                            @honeypot
                            <input type="hidden" name="Emp" value="{{$emp}}">


                            <div class="form-row">

                                <div class="form-group col-lg-4">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Client')}}</label>
                                    <select class="select2 form-control"  name="Client" required>
                                        <option value="">{{trans('admin.Client')}}</option>
                                        @foreach($Clients as $cli)
                                            <option value="{{$cli->id}}" @if($item->Client == $cli->id) selected @endif>   {{app()->getLocale() == 'ar' ?$cli->Name :$cli->NameEn}}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="form-group col-lg-4">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Time')}}</label>
                                    <input type="time" name="Time"   value="{{$item->Time}}"  class="form-control" required >
                                </div>


                            </div>

                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                                <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal Delete -->
        <div class="modal fade" id="default-example-modal-center{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">
                            {{trans('admin.RUSWDT')}}
                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                        <a href="{{url('DeleteItinerary/'.$item->id)}}"  class="btn btn-primary"> {{trans('admin.Yes')}}</a>
                    </div>
                </div>
            </div>
        </div>



    @endforeach


@endsection

@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>

    <!-- Search Selecet -->
    <script>
        $(document).ready(function()
        {
            $(function()
            {
                $('.select2').select2();

                $(".select2-placeholder-multiple").select2(
                    {
                        placeholder: "Select State"
                    });
                $(".js-hide-search").select2(
                    {
                        minimumResultsForSearch: 1 / 0
                    });
                $(".js-max-length").select2(
                    {
                        maximumSelectionLength: 2,
                        placeholder: "Select maximum 2 items"
                    });
                $(".select2-placeholder").select2(
                    {
                        placeholder: "Select a state",
                        allowClear: true
                    });

                $(".js-select2-icons").select2(
                    {
                        minimumResultsForSearch: 1 / 0,
                        templateResult: icon,
                        templateSelection: icon,
                        escapeMarkup: function(elm)
                        {
                            return elm
                        }
                    });

                function icon(elm)
                {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
                }


                $('.Client').select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: 'json',
                        url: 'AllCli',
                        processResults: function (data) {
                            return {
                                results: $.map(data, function(obj, index) {
                                    return { id: index, text: obj };
                                })
                            };

                            console.log(data);

                        },
                        data: function (params) {


                            var query = {
                                search: params.term,
                            };


                            $.ajax({
                                url: 'AllCliJ/'+params.term,
                                type:"GET",
                                dataType:"json",
                                beforeSend: function(){
                                    $('#loader').css("visibility", "visible");
                                },

                                success:function(data) {
                                    $('.Client').empty();
                                    $.each(data, function(key, value){

                                        $('.Client').append('<option value="'+ key +'">' + value + '</option>');

                                    });
                                },
                                complete: function(){
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    }
                });


                $('.Client').on('select2:select', function (e) {
                    console.log("select done", e.params.data);
                });



                $('#Client').select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: 'json',
                        url: 'AllCli',
                        processResults: function (data) {
                            return {
                                results: $.map(data, function(obj, index) {
                                    return { id: index, text: obj };
                                })
                            };

                            console.log(data);

                        },
                        data: function (params) {


                            var query = {
                                search: params.term,
                            };


                            $.ajax({
                                url: 'AllCliJ/'+params.term,
                                type:"GET",
                                dataType:"json",
                                beforeSend: function(){
                                    $('#loader').css("visibility", "visible");
                                },

                                success:function(data) {
                                    $('#Client').empty();
                                    $.each(data, function(key, value){

                                        $('#Client').append('<option value="'+ key +'">' + value + '</option>');

                                    });
                                },
                                complete: function(){
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    }
                });


                $('#Client').on('select2:select', function (e) {
                    console.log("select done", e.params.data);
                });



            });
        });



    </script>
@endpush

