@extends('admin.index')
@section('content')
@php
use App\Models\Interviews;
use App\Models\Sales;
@endphp
  <title>{{trans('admin.Interviews')}}</title>

    <main id="js-page-content" role="main" class="page-content">
                    <ol class="breadcrumb page-breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.CRM')}}</a></li>
                        <li class="breadcrumb-item active">{{trans('admin.Interviews')}}</li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                                class="js-get-date"></span></li>
                    </ol>

          <!-- Filter -->
                    <div class="row">
                        <div class="col-lg-12">
                            <div id="panel-2" class="panel">
                                <div class="panel-hdr">
                                    <h2>
                                        <span class="fw-300"><i>   {{trans('admin.Interviews')}}  </i></span>
                                    </h2>
                                </div>
                                <div class="panel-container show">
                                    <div class="panel-content">
                                        <form action="{{url('FilterInterviews')}}" method="get" class="form-row">
                                            <div class="form-group col-md-2">
                              <label class="form-label" for="simpleinput">{{trans('admin.From')}}</label>
                                                <input type="date" value="{{date('Y-m-d')}}" name="From" class="form-control" required>
                                            </div>
                                            <div class="form-group col-md-2">
                              <label class="form-label" for="simpleinput">{{trans('admin.To')}}</label>
                                                <input type="date" value="{{date('Y-m-d')}}" name="To" class="form-control" required>
                                            </div>
                                            <div class="form-group col-lg-2">
                           <label class="form-label" for="simpleinput">{{trans('admin.Code')}}</label>
                               <input type="text"  name="Code" class="form-control" >
                                            </div>

                                     <div class="form-group col-lg-3">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Employee')}}</label>
              <select class="select2 form-control" name="Emp" >
                                <option value="">{{trans('admin.Employee')}}</option>
                                            @foreach($Employess as $emp)
                    <option value="{{$emp->id}}">
                   {{app()->getLocale() == 'ar' ?$emp->Name :$emp->NameEn}}
                  </option>
                                           @endforeach
                                            </select>
                                        </div>

                                                    <div class="form-group col-lg-3">
                                            <label class="form-label" for="simpleinput">{{trans('admin.InterviewType')}}</label>
              <select class="select2 form-control" name="Type" >
                                <option value="">{{trans('admin.InterviewType')}}</option>
                                            @foreach($InterviewsTypes as $int)
                    <option value="{{$int->id}}">
                       {{app()->getLocale() == 'ar' ?$int->Arabic_Name :$int->English_Name}}
                  </option>
                                           @endforeach
                                            </select>
                                        </div>

                                        <div class="form-group col-lg-3">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Client')}}</label>
              <select class="js-data-example-ajax form-control" id="Client" name="Client" >
                                <option value="">{{trans('admin.Client')}}</option>
                                            </select>
                                        </div>


                           <div class="form-group col-lg-3">
                                            <label class="form-label" for="simpleinput">{{trans('admin.User')}}</label>
              <select class="select2 form-control" name="User" >
                                <option value="">{{trans('admin.User')}}</option>
                                            @foreach($Users as $user)
                    <option value="{{$user->id}}">
                    {{app()->getLocale() == 'ar' ?$user->Name :$user->NameEn}}
                  </option>
                                           @endforeach
                                            </select>
                                        </div>

                                   <div class="form-group col-lg-2">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Status')}}</label>
              <select class="select2 form-control" name="Status" >
                                <option value="">{{trans('admin.Status')}}</option>
                                <option value="0">{{trans('admin.Not_Done')}}</option>
                                <option value="1">{{trans('admin.Done')}}</option>

                                            </select>
                                        </div>


                                               <div class="form-group col-lg-2">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Rateee')}}</label>
              <select class="select2 form-control" name="Rateee" >
                                <option value="">{{trans('admin.Rateee')}}</option>
                                <option value="1">✭</option>
                                <option value="2">✭✭</option>
                                <option value="3">✭✭✭</option>
                                <option value="4">✭✭✭✭</option>
                                <option value="5">✭✭✭✭✭</option>
                                            </select>
                                        </div>

                                            <div class="form-group col-lg-2">
                            <button type="submit" class="btn btn-primary"><i class="fal fa-search"></i></button>
                                            </div>

                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-xl-12">
                            <div id="panel-1" class="panel">
                                <div class="panel-hdr">
                                    <h2>
                                         <span class="fw-300"><i>{{trans('admin.Interviews')}}</i></span>
                                    </h2>

                                    <div class="panel-toolbar">
                                           @can('اضافه مقابله')
                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg">{{trans('admin.AddNew')}}</button>
                                         @endcan

                                        <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>

                                               @include('admin.layouts.toolbar')
                                    </div>

                                </div>
                                <div class="panel-container show">
                                   <span id="ex"> @include('admin.layouts.messages')</span>
                                    <div class="panel-content">
                                        <!-- datatable start -->
                                        <div style="overflow:auto;">
                                        <table id="dt-basic-example"
                                            class="table table-bordered table-hover table-striped " >
                                            <thead class="bg-highlight">
                                                <tr>
                                                    <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Date')}}</th>
                                                    <th>{{trans('admin.Time')}}</th>
                                                    <th>{{trans('admin.Notes')}}</th>
                                                    <th>{{trans('admin.Employee')}}</th>
                                                    <th>{{trans('admin.Client')}}</th>
                                                    <th>{{trans('admin.Phone')}}</th>

                                                    <th>{{trans('admin.InterviewType')}}</th>

                                                    <th>{{trans('admin.Rateee')}}</th>

                                                     <th>{{trans('admin.Previous_Interviews')}}</th>
                                                     <th>{{trans('admin.Data')}}</th>
                                                    <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                            </thead>
                                            <tbody>

                                            @foreach($items as $item)
      <tr @if($item->Status == 1)   style=" background: linear-gradient(45deg, #69323200, #5bb1bb);" @endif>
                                                    <td>{{$item->Code}}</td>
                                                    <td>{{$item->Date}}</td>
                                                    <td>{{$item->Time}}</td>
                                                    <td>
                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Note{{$item->id}}"> {{trans('admin.Notes')}} </button>
                                                    </td>
                                                    <td>
                                                        @if(!empty($item->Emp()->first()->Name))
             {{app()->getLocale() == 'ar' ?$item->Emp()->first()->Name :$item->Emp()->first()->NameEn}}
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if(!empty($item->Client()->first()->Name))
           {{app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn}}
                                                        @endif
                                                    </td>
                                                    <td>
                                                         @if(!empty($item->Client()->first()->Phone))
                                                        {{$item->Client()->first()->Phone}}
                                                        @endif

                                                        </td>



                                                    <td>
                                                        @if(!empty($item->Type()->first()->Arabic_Name))
            {{app()->getLocale() == 'ar' ?$item->Type()->first()->Arabic_Name :$item->Type()->first()->English_Name}}
                                                        @endif
                                                    </td>

                                                    <td>

                                       <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Rate{{$item->id}}">{{$item->Rate}} <i class="fal fa-star"></i></button>
                                                    </td>



                                                                       <td>
                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center-open{{$item->id}}"> {{trans('admin.Previous_Interviews')}} </button>

                                                </td>

                                                    <td>
                                                        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#show-data{{$item->id}}">
                                                           {{trans('admin.Data')}}
                                                        </button>
                                                    </td>
                                                    <td class="text-center">


                                          @can('حذف مقابله')
                      <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>
                                   @endcan
                                        @can('تعديل مقابله')
                         <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg-edit{{$item->id}}"><i class="fal fa-edit"></i></button>
                        @endcan
                                                    </td>
                                                </tr>
                                             @endforeach


                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                  <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Date')}}</th>
                                                    <th>{{trans('admin.Time')}}</th>
                                                    <th>{{trans('admin.Notes')}}</th>
                                                    <th>{{trans('admin.Employee')}}</th>
                                                    <th>{{trans('admin.Client')}}</th>
                                                    <th>{{trans('admin.Phone')}}</th>

                                                    <th>{{trans('admin.InterviewType')}}</th>

                                                    <th>{{trans('admin.Rateee')}}</th>

                                                     <th>{{trans('admin.Previous_Interviews')}}</th>
                                                     <th>{{trans('admin.Data')}}</th>
                                                    <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                        </div>
                                        {{$items->Links()}}
                                        <!-- datatable end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Modal Add-->
            <div class="modal fade" id="default-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-xl" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">{{trans('admin.AddNew')}}  </h5>

                                     <button style="margin: 22px" type="button" class="btn btn-default" data-toggle="modal" data-target="#NewClient">
                                            <i class="fal fa-user"></i>
                                     </button>

                               <!-- Modal New Client -->
            <div class="modal fade" id="NewClient" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                            <div class="modal-content">
                                <div class="modal-header">

                                    <h4 class="modal-body row">


                                                   <div class="form-group col-md-3">
                <label class="form-label" for="simpleinput"> {{trans('admin.Arabic_Name')}}  </label><span class="strick">*</span>
                        <input type="text" id="Name" value="{{old('Name')}}" class="form-control">
                                                                    </div>

                                                      <div class="form-group col-md-3">
                <label class="form-label" for="simpleinput"> {{trans('admin.English_Name')}}  </label><span class="strick">*</span>
                        <input type="text" id="NameEn" value="{{old('NameEn')}}" class="form-control">
                                                                    </div>

                                                     <div class="form-group col-md-3">
                <label class="form-label" for="simpleinput"> {{trans('admin.Phone')}}  </label><span class="strick">*</span>
                        <input type="number" id="Phone" value="{{old('Phone')}}" class="form-control">
                                                                    </div>
                                                               <div class="form-group col-md-3">
                <label class="form-label" for="">   {{trans('admin.Price_Level')}} </label><span class="strick">*</span>
                             <select class="select2 form-control w-100" id="PriceLevel">
                                    <option value="1"> {{trans('admin.Level1')}} </option>
                                    <option value="2"> {{trans('admin.Level2')}} </option>
                                    <option value="3"> {{trans('admin.Level3')}} </option>

                                                                        </select>
                                                                    </div>

                                   <div class="form-group col-md-2">
                                    <label class="form-label" for="">  {{trans('admin.Governrate')}} </label>
                                          <select class="select2 form-control w-100" id="Governrate" >
                                                   <option value="">{{trans('admin.Governrate')}}</option>
                                              @foreach($Governrates as $gov)
                                                    <option value="{{$gov->id}}">

                             {{app()->getLocale() == 'ar' ?$gov->Arabic_Name :$gov->English_Name}}
                                              </option>
                                              @endforeach
                                                        </select>
                                                    </div>
                                            <div class="form-group col-md-2">
                                        <label class="form-label" for="">  {{trans('admin.City')}}</label>
                                               <select class="select2 form-control w-100" id="City" >
                                  <option value="">{{trans('admin.City')}}</option>
                                              @foreach($Cities as $cit)
                                            <option value="{{$cit->id}}">

                                  {{app()->getLocale() == 'ar' ?$cit->Arabic_Name :$cit->English_Name}}
                                              </option>
                                              @endforeach
                                                                        </select>
                                                                    </div>
                                            <div class="form-group col-md-2">
                                      <label class="form-label" for="">  {{trans('admin.Activity')}}</label>
                                            <select class="select2 form-control w-100" id="Activity">
                                              <option value="">{{trans('admin.Activity')}}</option>
                                              @foreach($Activites as $act)
                                                    <option value="{{$act->id}}">

                                                      {{app()->getLocale() == 'ar' ?$act->Arabic_Name :$act->English_Name}}
                                              </option>
                                              @endforeach
                                                                        </select>
                                                                    </div>
                                            <div class="form-group col-md-2">
                                        <label class="form-label" for="">  {{trans('admin.Responsible')}}</label>
                                            <select class="select2 form-control w-100" id="Responsible">
                                                 <option value="">{{trans('admin.Responsible')}}</option>
                                              @foreach($Employess as $emp)
                                                    <option value="{{$emp->id}}">

                                                      {{app()->getLocale() == 'ar' ?$emp->Name :$emp->NameEn}}
                                              </option>
                                              @endforeach
                                                                        </select>
                                                                    </div>
   <div class="form-group col-md-2">
                                      <label class="form-label" for="">  {{trans('admin.Platforms')}} </label>
                                            <select class="select2 form-control w-100" id="Platform" >
                                                <option value="">{{trans('admin.Platforms')}}</option>
                                              @foreach($Platforms as $pl)
                                                    <option value="{{$pl->id}}">

                                          {{app()->getLocale() == 'ar' ?$pl->Arabic_Name :$pl->English_Name}}
                                              </option>
                                              @endforeach
                                                                        </select>
                                                                    </div>
                                            <div class="form-group col-md-2">
                                           <label class="form-label" for="">  {{trans('admin.Campagin')}} </label>
                                     <select class="select2 form-control w-100" id="Campagin">
                                            <option value=""> {{trans('admin.Campagin')}}</option>
                                                               @foreach($Campaigns as $camp)
                                            <option value="{{$camp->id}}" >

                                      {{app()->getLocale() == 'ar' ?$camp->Arabic_Name :$camp->English_Name}}
                                              </option>
                                              @endforeach

                                                                        </select>
                                                                    </div>


                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>

                                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                   <button type="button" onclick="NewClients()"  class="btn btn-primary"> {{trans('admin.AddNew')}}</button>
                                </div>

                            </div>
                        </div>
                    </div>

                                      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>

                                </div>
                                <div class="modal-body">
                                    <form action="{{url('AddInterviews')}}" method="post">
                                        {!! csrf_field() !!}
                                              @honeypot
                                        <div class="form-row">
                                        <div class="form-group col-lg-4">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Code')}}</label>
              <input type="text" value="{{$Code}}"  class="form-control" disabled>
              <input type="hidden"  name="Code" value="{{$Code}}"  class="form-control">
                                        </div>
                                        <div class="form-group col-lg-4">
                                     <label class="form-label" for="simpleinput"> {{trans('admin.Date')}}</label>
            <input type="date" name="Date"  value="{{date('Y-m-d')}}" class="form-control" required >
                                        </div>
                                  <div class="form-group col-lg-4">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Time')}}</label>
                <input type="time" name="Time"  value='{{date("H:i", time())}}' class="form-control" required >
                                        </div>


                                        <div class="form-group col-lg-4">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Employee')}}</label>
              <select class="select2 form-control" name="Emp" required>
                                <option value="">{{trans('admin.Employee')}}</option>
                                            @foreach($Employess as $emp)
                    <option value="{{$emp->id}}">  {{app()->getLocale() == 'ar' ?$emp->Name :$emp->NameEn}}      </option>
                                           @endforeach
                                            </select>
                                        </div>

                                                    <div class="form-group col-lg-4">
                                            <label class="form-label" for="simpleinput">{{trans('admin.InterviewType')}}</label>
              <select class="select2 form-control" name="Type" required>
                                <option value="">{{trans('admin.InterviewType')}}</option>
                                            @foreach($InterviewsTypes as $int)
                    <option value="{{$int->id}}">
                      {{app()->getLocale() == 'ar' ?$int->Arabic_Name :$int->English_Name}}
                  </option>
                                           @endforeach
                                            </select>
                                        </div>

                                        <div class="form-group col-lg-4">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Client')}}</label>
              <select class="js-data-example-ajax form-control Client" name="Client" required>
                                <option value="">{{trans('admin.Client')}}</option>
                                            </select>
                                        </div>

                                        <div class="form-group col-lg-12">
                                     <label class="form-label" for="simpleinput"> {{trans('admin.Notes')}}</label>
            <input type="text" name="Note"  value="{{old('Note')}}" class="form-control"  >
                                        </div>

                                        </div>
                                    <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                                    <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                                </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>


         @foreach($items as $item)
             <!-- Modal Edit-->
                    <div class="modal fade" id="default-example-modal-lg-edit{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">{{trans('admin.Edit')}}  </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{url('EditInterviews/'.$item->id)}}" method="post">
                                        {!! csrf_field() !!}
                                              @honeypot
                            <input type="hidden" name="Status" value="{{$item->Status}}">
                            <input type="hidden" name="Rate" value="{{$item->Rate}}">
                            <input type="hidden" name="User" value="{{$item->User}}">

                                      <div class="form-row">
                                        <div class="form-group col-lg-4">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Code')}}</label>
              <input type="text" value="{{$item->Code}}"  class="form-control" disabled>
              <input type="hidden"  name="Code" value="{{$item->Code}}"  class="form-control">
                                        </div>
                                        <div class="form-group col-lg-4">
                                     <label class="form-label" for="simpleinput"> {{trans('admin.Date')}}</label>
            <input type="date" name="Date"  value="{{$item->Date}}" class="form-control" required >
                                        </div>
                                  <div class="form-group col-lg-4">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Time')}}</label>
                <input type="time" name="Time"  value="{{$item->Time}}" class="form-control" required >
                                        </div>


                                        <div class="form-group col-lg-4">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Employee')}}</label>
              <select class="select2 form-control" name="Emp" required>
                                <option value="">{{trans('admin.Employee')}}</option>
                                            @foreach($Employess as $emp)
     <option value="{{$emp->id}}" @if($item->Emp == $emp->id) selected  @endif>{{app()->getLocale() == 'ar' ?$emp->Name :$emp->NameEn}} </option>
                                           @endforeach
                                            </select>
                                        </div>

                                                    <div class="form-group col-lg-4">
                                            <label class="form-label" for="simpleinput">{{trans('admin.InterviewType')}}</label>
              <select class="select2 form-control" name="Type" required>
                                <option value="">{{trans('admin.InterviewType')}}</option>
                                            @foreach($InterviewsTypes as $int)
       <option value="{{$int->id}}" @if($item->Type == $int->id) selected  @endif>             {{app()->getLocale() == 'ar' ?$int->Arabic_Name :$int->English_Name}}  </option>
                                           @endforeach
                                            </select>
                                        </div>

                                        <div class="form-group col-lg-4">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Client')}}</label>
              <select class="js-data-example-ajax form-control Client" name="Client" required>
                                <option value="{{$item->Client}}">
                  {{app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn}}
                  </option>
                                            </select>
                                        </div>

                                        <div class="form-group col-lg-12">
                                     <label class="form-label" for="simpleinput"> {{trans('admin.Notes')}}</label>
            <input type="text" name="Note"  value="{{$item->Note}}" class="form-control"  >
                                        </div>

                                        </div>
                                    <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                                    <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                                </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                      <!-- Modal Delete -->
                      <div class="modal fade" id="default-example-modal-center{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">
                                          {{trans('admin.RUSWDT')}} <strong>{{$item->Code}}</strong>
                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>

                                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                   <a href="{{url('DeleteInterviews/'.$item->id)}}"  class="btn btn-primary"> {{trans('admin.Yes')}}</a>
                                </div>
                            </div>
                        </div>
                    </div>


                  <!-- Modal Done -->
                      <div class="modal fade" id="Done{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                  <form action="{{url('Done/'.$item->id)}}" method="get">
                                <div class="modal-header">
                                    <h4 class="modal-title">

                                <div class="row">
                                <textarea name="StatusNote" class="form-control">

                                        {{old('StatusNote')}}
                                        </textarea>
                                        </div>

                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>

                                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                  <button type="submit" class="btn btn-secondary" > {{trans('admin.Yes')}}</button>

                                </div>
                                </form>
                            </div>
                        </div>
                    </div>


              <!-- Modal Rate -->
                      <div class="modal fade" id="Rate{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                  <form action="{{url('Rate/'.$item->id)}}" method="get">
                                <div class="modal-header">
                                    <h4 class="modal-title">


                                        <div class="row">
                                    <div class="col-md-12">
                                    <label><i class="fal fa-star"></i></label>
                                    <input type="radio" name="Rate" value="1">
                                            </div>

                                     <div class="col-md-12">
                                    <label>
                                        <i class="fal fa-star"></i>
                                        <i class="fal fa-star"></i>

                                        </label>
                                    <input type="radio" name="Rate" value="2">
                                            </div>

                                                 <div class="col-md-12">
                                    <label>
                                        <i class="fal fa-star"></i>
                                        <i class="fal fa-star"></i>
                                        <i class="fal fa-star"></i>

                                                     </label>
                                    <input type="radio" name="Rate" value="3">
                                            </div>

                                                 <div class="col-md-12">
                                    <label>
                                        <i class="fal fa-star"></i>
                                        <i class="fal fa-star"></i>
                                        <i class="fal fa-star"></i>
                                        <i class="fal fa-star"></i>

                                                     </label>
                                    <input type="radio" name="Rate" value="4">
                                            </div>

                                                 <div class="col-md-12">
                                    <label>
                                        <i class="fal fa-star"></i>
                                        <i class="fal fa-star"></i>
                                        <i class="fal fa-star"></i>
                                        <i class="fal fa-star"></i>
                                        <i class="fal fa-star"></i>
                                                     </label>
                                    <input type="radio" name="Rate" value="5">
                                            </div>

                                        </div>

                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>

                                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                  <button type="submit" class="btn btn-secondary" > {{trans('admin.Yes')}}</button>

                                </div>
                                </form>
                            </div>
                        </div>
                    </div>

                 <!-- Modal Status -->
                 <div class="modal fade" id="Status{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">
                                    {{$item->StatusNote}}
                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>

                                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                    <a href="{{url('NotDone/'.$item->id)}}" class="btn btn-default">{{trans('admin.Done_Do_U_Want_Change_Status_to_not_click_here')}}</a>
                                </div>
                            </div>
                        </div>
                    </div>

                     <!-- Modal History-->
        <div class="modal fade" id="default-example-modal-center-open{{$item->id}}" tabindex="-1" role="dialog"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">

                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>

                        <div class="modal-body">
                            @php
            $Backs=Interviews::orderBy('id','desc')
            ->where('Client',$item->Client)
            ->where('Status',1)
            ->get();

                $visit=Interviews::orderBy('id','desc')
            ->where('Client',$item->Client)
             ->where('Status',1)
            ->count();

            $billNum=Sales::orderBy('id','desc')
            ->where('Client',$item->Client()->first()->Account)
            ->count();

            $billTot=Sales::orderBy('id','desc')
            ->where('Client',$item->Client()->first()->Account)
            ->get()->sum('Total_Price');

                            @endphp

                            @foreach($Backs as $bb)
                            <div class="form-row">
                                <div class="form-group col-lg-4">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Employee')}} </label>
                                    <input type="text" value="{{app()->getLocale() == 'ar' ?$bb->Emp()->first()->Name :$bb->Emp()->first()->NameEn}}"  class="form-control" disabled>
                                </div>
                                <div class="form-group col-lg-4">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Date')}}  </label>
                                    <input type="date" value="{{$bb->Date}}"  class="form-control" disabled>
                                </div>
                                <div class="form-group col-lg-4">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Time')}}  </label>
                                    <input type="time" value="{{$bb->Time}}"  class="form-control" disabled>
                                </div>
                                <div class="form-group col-lg-12">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Interview_Biref')}} </label>
                                    <input type="text" value="{{$bb->StatusNote}}" class="form-control"  disabled>

                                </div>
                            </div>
                            @endforeach

                        @can('جدول الزيارات و عدد الفواتير')
                        <div class="mt-3">
                            <table id=""
                            class="table table-bordered table-hover table-striped w-100">
                            <thead>
                                <tr>
                                    <th> {{trans('admin.VisitNum')}}</th>
                                    <th> {{trans('admin.BillsNum')}}</th>
                                    <th> {{trans('admin.BillsTotal')}}</th>
                                </tr>
                            </thead>
                            <tbody id="">
                                <tr>
                                    <td> {{$visit}}</td>
                                    <td> {{$billNum}}</td>
                                    <td> {{$billTot}}</td>

                                </tr>
                            </tbody>
                        </table>
                        </div>
                        @endcan

                        <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>
</div>

         <!-- Modal Note -->
            <div class="modal fade" id="Note{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">

                                <div class="modal-header">
                                    <h4 class="modal-title">
                                <div class="row">
                                  {{$item->Note}}
                                        </div>
                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>

                                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>

                                </div>

                            </div>
                        </div>
                    </div>


            <!-- Modal show data -->
    <div class="modal fade" id="show-data{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                             {{trans('admin.Data')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">
      <div style="overflow:auto;">
        <table id="" class="table table-bordered table-hover table-striped " >
                                            <thead class="bg-highlight">
                                                <tr>

                            <th>{{trans('admin.Activity')}}</th>
                                                    <th>{{trans('admin.Governrate')}}</th>
                                                    <th>{{trans('admin.City')}}</th>
                                                    <th>{{trans('admin.Client_Status')}}</th>
  <th>{{trans('admin.User')}}</th>
   <th>{{trans('admin.Status')}}</th>

                                                </tr>
                                            </thead>
                                            <tbody>

                                                <tr>
                                                   <td>

                                                    @if(!empty($item->Client()->first()->Activity()->first()->Arabic_Name))
                  {{app()->getLocale() == 'ar' ?$item->Client()->first()->Activity()->first()->Arabic_Name :$item->Client()->first()->Activity()->first()->English_Name}}
                                                    @endif

                                                    </td>
                                                    <td>
                                                      @if(!empty($item->Client()->first()->Governrate()->first()->Arabic_Name))

                  {{app()->getLocale() == 'ar' ?$item->Client()->first()->Governrate()->first()->Arabic_Name :$item->Client()->first()->Governrate()->first()->English_Name}}
                                                    @endif
                                                    </td>
                                                    <td>
                                                      @if(!empty($item->Client()->first()->City()->first()->Arabic_Name))

              {{app()->getLocale() == 'ar' ?$item->Client()->first()->City()->first()->Arabic_Name :$item->Client()->first()->City()->first()->English_Name}}
                                                    @endif
                                                    </td>
                                                    <td>
                                                      @if(!empty($item->Client()->first()->ClientStatus()->first()->Arabic_Name))

                  {{app()->getLocale() == 'ar' ?$item->Client()->first()->ClientStatus()->first()->Arabic_Name :$item->Client()->first()->ClientStatus()->first()->English_Name}}
                                                    @endif
                                                    </td>
     <td>

                                                     {{app()->getLocale() == 'ar' ?$item->User()->first()->name :$item->User()->first()->nameEn}}
                                                    </td>
      <td>


                                    @if($item->Status == 0)

                                <!--
              <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Done{{$item->id}}"></button>
                                -->

                                                    <i class="fal fa-times"></i>

                                    @elseif($item->Status == 1)

                 <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Status{{$item->id}}">
                    {{trans('admin.Status')}}
                                                    </button>

                                    @endif

                                                    </td>


                                                </tr>


                                            </tbody>


                                        </table>

                                        </div>

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>

                        </div>
                    </div>
                </div>
            </div>




        @endforeach
                </main>
@if(app()->getLocale() == 'ar' )
<input type="hidden" id="LANG" value="ar">
@else
<input type="hidden" id="LANG" value="en">
@endif

@endsection

@push('js')
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
  <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>

    <!-- Search Selecet -->
 <script>
        $(document).ready(function()
        {
            $(function()
            {
                $('.select2').select2();

                $(".select2-placeholder-multiple").select2(
                {
                    placeholder: "Select State"
                });
                $(".js-hide-search").select2(
                {
                    minimumResultsForSearch: 1 / 0
                });
                $(".js-max-length").select2(
                {
                    maximumSelectionLength: 2,
                    placeholder: "Select maximum 2 items"
                });
                $(".select2-placeholder").select2(
                {
                    placeholder: "Select a state",
                    allowClear: true
                });

                $(".js-select2-icons").select2(
                {
                    minimumResultsForSearch: 1 / 0,
                    templateResult: icon,
                    templateSelection: icon,
                    escapeMarkup: function(elm)
                    {
                        return elm
                    }
                });

                function icon(elm)
                {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
                }


  $('.Client').select2({
    placeholder: "select...",
    ajax: {
        type: "GET",
        dataType: 'json',
        url: 'AllClients',
        processResults: function (data) {
          return {
            results: $.map(data, function(obj, index) {
              return { id: index, text: obj };
            })
          };

            	console.log(data);

        },
       data: function (params) {


                   var query = {
                            search: params.term,
                        };


              $.ajax({
                              url: 'AllClientsJ/'+params.term,
                              type:"GET",
                              dataType:"json",
                              beforeSend: function(){
                                  $('#loader').css("visibility", "visible");
                              },

                              success:function(data) {
                                          $('.Client').empty();
                                  $.each(data, function(key, value){

                         $('.Client').append('<option value="'+ key +'">' + value + '</option>');

                                  });
                              },
                              complete: function(){
                                  $('#loader').css("visibility", "hidden");
                              }
                          });



        }
    }
  });


$('.Client').on('select2:select', function (e) {
	console.log("select done", e.params.data);
});



          $('#Client').select2({
    placeholder: "select...",
    ajax: {
        type: "GET",
        dataType: 'json',
        url: 'AllClients',
        processResults: function (data) {
          return {
            results: $.map(data, function(obj, index) {
              return { id: index, text: obj };
            })
          };

            	console.log(data);

        },
       data: function (params) {


                   var query = {
                            search: params.term,
                        };


              $.ajax({
                              url: 'AllClientsJ/'+params.term,
                              type:"GET",
                              dataType:"json",
                              beforeSend: function(){
                                  $('#loader').css("visibility", "visible");
                              },

                              success:function(data) {
                                          $('#Client').empty();
                                  $.each(data, function(key, value){

                         $('#Client').append('<option value="'+ key +'">' + value + '</option>');

                                  });
                              },
                              complete: function(){
                                  $('#loader').css("visibility", "hidden");
                              }
                          });



        }
    }
  });


$('#Client').on('select2:select', function (e) {
	console.log("select done", e.params.data);
});



            });
        });



    </script>

    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    // responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>

<!-- Add New Client -->
<script>
    function NewClients(){

    var Governrate = $('#Governrate').val();
    var City = $('#City').val();
    var Activity = $('#Activity').val();
    var Responsible = $('#Responsible').val();
    var Platform = $('#Platform').val();
    var Campagin = $('#Campagin').val();
    var Name = $('#Name').val();
    var PriceLevel = $('#PriceLevel').val();
    var Phone = $('#Phone').val();

       var NameEn = $('#NameEn').val();
   var LANG = $('#LANG').val();
       if(NameEn == ''){

               NameEn = Name ;
          }
          if(Name) {
                         $.ajax({
                             url: 'AddNewClientAjax',
                             type:"GET",
                             data:{
                                Governrate:Governrate,
                                City:City,
                                Activity:Activity,
                                Responsible:Responsible,
                                Platform:Platform,
                                Campagin:Campagin,
                                Name:Name,
                                PriceLevel:PriceLevel,
                                Phone:Phone,
                                NameEn:NameEn
                             },
                             dataType:"json",
                             beforeSend: function(){
                                 $('#loader').css("visibility", "visible");
                             },

                             success:function(data) {
                                 $.each(data, function(key, value){

                                         if(LANG == 'ar'){
                            alert('تم الاضافه بنجاح');
                       }else{
                           alert('Added Successfully');
                       }


     $('#Governrate').val('');
     $('#City').val('');
     $('#Activity').val('');
     $('#Responsible').val('');
     $('#Platform').val('');
     $('#Campagin').val('');
     $('#Name').val('');
     $('#PriceLevel').val('');
     $('#Phone').val('');


                                 });
                             },
                             complete: function(){
                                 $('#loader').css("visibility", "hidden");
                             }
                         });
                     }else{

                         if(LANG == 'ar'){
                       alert('حقل الاسم مطلوب');
                      }else{

                       alert('Name Input is Required');
                      }

                     }



    }
</script>

<!-- Filter Governrate and City !-->
<script>
   $(document).ready(function() {

       $('#Governrate').on('change', function(){
           var countryId = $(this).val();
           if(countryId) {
               $.ajax({
                   url: 'GovernrateFilter/'+countryId,
                   type:"GET",
                   dataType:"json",
                   beforeSend: function(){
                       $('#loader').css("visibility", "visible");
                   },

                   success:function(data) {

                       $('#City').empty();

                       $.each(data, function(key, value){

             $('#City').append('<option value="'+ key +'">' + value + '</option>');

                       });
                   },
                   complete: function(){
                       $('#loader').css("visibility", "hidden");
                   }
               });
           } else {

               $('select[name="states"]').empty();
           }

       });

   });

   $(document).ready(function() {


           var countryId = $('#Governrate').val();
           if(countryId) {
               $.ajax({
                   url: 'GovernrateFilter/'+countryId,
                   type:"GET",
                   dataType:"json",
                   beforeSend: function(){
                       $('#loader').css("visibility", "visible");
                   },

                   success:function(data) {

                       $('#City').empty();

                       $.each(data, function(key, value){

             $('#City').append('<option value="'+ key +'">' + value + '</option>');

                       });
                   },
                   complete: function(){
                       $('#loader').css("visibility", "hidden");
                   }
               });
           } else {

               $('select[name="states"]').empty();
           }


   });
</script>
<!-- Filter Platform and Campaigns !-->
<script>
   $(document).ready(function() {

       $('#Platform').on('change', function(){
           var countryId = $(this).val();
           if(countryId) {
               $.ajax({
                   url: 'PlatformFilter/'+countryId,
                   type:"GET",
                   dataType:"json",
                   beforeSend: function(){
                       $('#loader').css("visibility", "visible");
                   },

                   success:function(data) {

                       $('#Campagin').empty();

                       $.each(data, function(key, value){

             $('#Campagin').append('<option value="'+ key +'">' + value + '</option>');

                       });
                   },
                   complete: function(){
                       $('#loader').css("visibility", "hidden");
                   }
               });
           } else {

               $('select[name="states"]').empty();
           }

       });

   });

    $(document).ready(function() {

           var countryId = $('#Platform').val();
           if(countryId) {
               $.ajax({
                   url: 'PlatformFilter/'+countryId,
                   type:"GET",
                   dataType:"json",
                   beforeSend: function(){
                       $('#loader').css("visibility", "visible");
                   },

                   success:function(data) {

                       $('#Campagin').empty();

                       $.each(data, function(key, value){

             $('#Campagin').append('<option value="'+ key +'">' + value + '</option>');

                       });
                   },
                   complete: function(){
                       $('#loader').css("visibility", "hidden");
                   }
               });
           } else {

               $('select[name="states"]').empty();
           }



   });
</script>

@endpush

