@extends('admin.index')
@section('content')

    <title>{{trans('admin.FollowList')}}</title>

    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.CRM')}}</a></li>
            <li class="breadcrumb-item active">{{trans('admin.FollowList')}}</li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                    class="js-get-date"></span></li>
        </ol>

        <div class="row">
            <div class="col-xl-12">
                <div id="panel-1" class="panel">
                    <div class="panel-hdr">
                        <h2>
                            <span class="fw-300"><i>{{trans('admin.FollowList')}}</i></span>
                            <span class="fw-300"><i>{{$DAY}}</i></span>
                        </h2>

                        <div class="panel-toolbar">

                            @if(auth()->guard('admin')->user()->emp == 0)
                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#NewAdd">{{trans('admin.AddNew')}}</button>
                            @endif

                            @include('admin.layouts.toolbar')
                        </div>

                    </div>
                    <div class="panel-container show">
                        <span id="ex"> @include('admin.layouts.messages')</span>
                        <div class="panel-content">

                     <div id="mobile-overflow m-2">
                                    <table
                                        class="table table-bordered table-hover table-striped w-100 mobile-width">
                                        <thead class="bg-highlight">
                                        <tr>
                                            <th>{{trans('admin.Time')}}</th>
                                            <th>{{trans('admin.Client')}}</th>
                                            <th>{{trans('admin.Phone')}}</th>
                                            <th>{{trans('admin.Phone2')}}</th>
                                            <th>{{trans('admin.Phone3')}}</th>
                                            <th>{{trans('admin.Phone4')}}</th>
                                            <th>{{trans('admin.Governrate')}}</th>
                                            <th>{{trans('admin.City')}}</th>
                                            <th>{{trans('admin.Place')}}</th>
                                            <th>{{trans('admin.Address')}}</th>

                                                <th>{{trans('admin.Actions')}}</th>

                                        </tr>
                                        </thead>
                                        <tbody>

                                        @foreach($items as $item)


                                                @if(!empty($item->Client))
                                                    @php
                                                        $cust=\App\Models\Customers::where('Account',$item->Client)->first();

                                                        if(!empty($cust->City)){

                                                     $city=app()->getLocale() == 'ar' ?$cust->City()->first()->Arabic_Name :$cust->City()->first()->English_Name;

                                              }else{
                                                            $city='';
                                              }
                                                        if(!empty($cust->Place)){

                                                     $place=app()->getLocale() == 'ar' ?$cust->Place()->first()->Arabic_Name :$cust->Place()->first()->English_Name;

                                              }else{
                                                            $place='';
                                              }

                                                if(!empty($cust->Governrate)){

                                                     $gov=app()->getLocale() == 'ar' ?$cust->Governrate()->first()->Arabic_Name :$cust->Governrate()->first()->English_Name;

                                              }else{
                                                            $gov='';
                                              }




               if(!empty($cust)){
                   $phone=$cust->Phone;
                   $phone2=$cust->Phone2;
                   $phone3=$cust->Phone3;
                   $phone4=$cust->Phone4;
                   $address=$cust->Address;
               }else{
                  $phone='';
                  $phone2='';
                  $phone3='';
                  $phone4='';
                  $address='';
               }



                                                    @endphp

                                                @endif
                                                <tr>

                                                    <td>{{$item->Time}}</td>
                                                    <td>

                                                        @if(!empty($item->Client()->first()->Name))

                                                            {{app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn}}

                                                        @endif

                                                    </td>
                                                    <td>{{$phone}}</td>
                                                    <td>{{$phone2}}</td>
                                                    <td>{{$phone3}}</td>
                                                    <td>{{$phone4}}</td>
                                                    <td>{{$gov}}</td>
                                                    <td>{{$city}}</td>
                                                    <td>{{$place}}</td>
                                                    <td>{{$address}}</td>

                                                    @if(auth()->guard('admin')->user()->emp == 0)
                                                        <td>

                                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>

                                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg-edit{{$item->id}}"><i class="fal fa-edit"></i></button>



                                                        </td>
                                                    @else

                                                        <td>
                                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#AddComment{{$item->id}}"><i class="fal fa-comment"></i></button>
                                                        </td>

                                                    @endif


                                                </tr>

                                        @endforeach


                                        </tbody>
                                    </table>
                                </div>



                        </div>
                        {{$items->Links()}}
                    </div>
                </div>
            </div>
        </div>
        </div>




    </main>



    <!-- Modal Add-->
    <div class="modal fade" id="NewAdd" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">       {{trans('admin.AddNew')}}  </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">
                    @if(auth()->guard('admin')->user()->emp == 0)
                        <form action="{{url('AddFollowList')}}" method="post">
                            {!! csrf_field() !!}
                            @honeypot
                            <div class="row p-3">

                                <input type="hidden" name="Emp" value="{{$emp}}">
                                <input type="hidden" name="Day" value="{{$AddDay}}">




                                    <div class="form-group col-lg-6">
                                        <label class="form-label" for="simpleinput">{{trans('admin.Client')}}</label>
                                        <select class="select2 form-control client"  name="Client" required>
                                            <option value="">{{trans('admin.Client')}}</option>

                                        </select>
                                    </div>

                                    <div class="form-group col-lg-6">
                                        <label class="form-label" for="simpleinput"> {{trans('admin.Time')}}</label>
                                        <input type="time" name="Time"     class="form-control" required >
                                    </div>




                                <div class="modal-footer">

                                    <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                                </div>



                            </div>
                        </form>
                    @endif



                </div>
            </div>
        </div>
    </div>




    @foreach($items as $item)


        <!-- Modal Edit-->
        <div class="modal fade" id="default-example-modal-lg-edit{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">{{trans('admin.Edit')}}  </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form action="{{url('EditFollowList/'.$item->id)}}" method="post">
                            {!! csrf_field() !!}
                            @honeypot
                            <input type="hidden" name="Emp" value="{{$emp}}">




                                <div class="form-group col-lg-6">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Client')}}</label>
                                    <select class="select2 form-control client"  name="Client" required>
                                        <option value="">{{trans('admin.Client')}}</option>

                                    </select>
                                </div>

                                <div class="form-group col-lg-6">
                                    <label class="form-label" for="simpleinput"> {{trans('admin.Time')}}</label>
                                    <input type="time" name="Time"   value="{{$item->Time}}"  class="form-control" required >
                                </div>




                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                                <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal AddComment-->
        <div class="modal fade" id="AddComment{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">{{trans('admin.Edit')}}  </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form action="{{url('AddCommentToClientFollow')}}" method="post" enctype="multipart/form-data">
                            {!! csrf_field() !!}
                            @honeypot
                            <div class="tab-content border border-top-0 p-3">
                                <div class="tab-pane fade show active" id="tab_borders_icons-1" role="tabpanel">
                                    <div class="form-row">

                                       @php $cust=\App\Models\Customers::where('Account',$item->Client)->first();   @endphp
                                        <div class="form-group col-lg-6">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Code')}} </label>
                                            <input type="text" value="{{$Code}}" class="form-control " disabled>
                                            <input type="hidden" name="Code" value="{{$Code}}" class="form-control">
                                            <input type="hidden" name="Customer" value="{{$cust->id}}" class="form-control">

                                        </div>
                                        <div class="form-group col-lg-6">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                                            <input type="date" name="Date" value="{{date('Y-m-d')}}" class="form-control" readonly>
                                        </div>

                                        <div class="form-group col-lg-4">
                                            <label class="form-label" for="">{{trans('admin.Rate_Interview')}}</label>
                                            <select class="select2 form-control w-100" name="Rate" >
                                                <option value="">{{trans('admin.Rate_Interview')}}</option>
                                                @foreach($Rates as $rate)
                                                    <option value="{{$rate->id}}">
                                                        {{app()->getLocale() == 'ar' ?$rate->Arabic_Name :$rate->English_Name}}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="form-group col-lg-4">
                                            <label class="form-label" for="">{{trans('admin.Interview_Type')}}</label>
                                            <select class="select2 form-control w-100" name="Type" >
                                                <option value="">{{trans('admin.Interview_Type')}}</option>
                                                @foreach($Types as $type)
                                                    <option value="{{$type->id}}">
                                                        {{app()->getLocale() == 'ar' ?$type->Arabic_Name :$type->English_Name}}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div class="form-group col-lg-6">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Visit_Cost')}}</label>
                                            <input type="number" step="any" name="Visit_Cost" value="{{old('Visit_Cost')}}" class="form-control" >
                                        </div>


                                        <div class="form-group col-lg-6">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Note')}}</label>
                                            <input type="text" name="Note" value="{{old('Note')}}" class="form-control">
                                        </div>




                                        <div class="form-group col-lg-12">
                                            <label class="form-label" for="simpleinput"> {{trans('admin.Arabic_Comment')}}</label>
                                            <textarea type="text" name="Comment" class="form-control" required>
                                {{old('Comment')}}
                                </textarea>
                                        </div>

                                        <div class="form-group col-lg-12">
                                            <label class="form-label" for="simpleinput"> {{trans('admin.English_Comment')}}</label>
                                            <textarea type="text" name="CommentEn" class="form-control">
                                {{old('CommentEn')}}
                                </textarea>
                                        </div>



                                    </div>
                                </div>

                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                                    <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal Delete -->
        <div class="modal fade" id="default-example-modal-center{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">
                            {{trans('admin.RUSWDT')}}
                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                        <a href="{{url('DeleteFollowList/'.$item->id)}}"  class="btn btn-primary"> {{trans('admin.Yes')}}</a>
                    </div>
                </div>
            </div>
        </div>



    @endforeach


@endsection

@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>

    <!-- Search Selecet -->
    <script>
        $(document).ready(function()
        {
            $(function()
            {
                $('.select2').select2();

                $(".select2-placeholder-multiple").select2(
                    {
                        placeholder: "Select State"
                    });
                $(".js-hide-search").select2(
                    {
                        minimumResultsForSearch: 1 / 0
                    });
                $(".js-max-length").select2(
                    {
                        maximumSelectionLength: 2,
                        placeholder: "Select maximum 2 items"
                    });
                $(".select2-placeholder").select2(
                    {
                        placeholder: "Select a state",
                        allowClear: true
                    });

                $(".js-select2-icons").select2(
                    {
                        minimumResultsForSearch: 1 / 0,
                        templateResult: icon,
                        templateSelection: icon,
                        escapeMarkup: function(elm)
                        {
                            return elm
                        }
                    });

                function icon(elm)
                {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
                }


                $(".client").select2({

                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "AllClientsFilter",
                        processResults: function(data) {
                            return {
                                results: $.map(data, function(obj, index) {

                                    return {
                                        id: index,
                                        text: obj
                                    };
                                }),
                            };

                            console.log(data);
                        },
                        data: function(params) {

                            $.ajax({
                                url: 'AllClientsFilterJS/' + params.term,
                                type: "GET",
                                dataType: "json",
                                beforeSend: function() {
                                    $('#loader').css("visibility", "visible");
                                },

                                success: function(data) {
                                    $('.client').empty();
                                    $.each(data, function(key, value) {

                                        $('.client').append('<option value="' + key + '">' + value + '</option>');

                                    });




                                },
                                complete: function() {
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    },
                });

                $(".client").on("select2:select", function(e) {
                    console.log("select done", e.params.data);
                });



            });
        });



    </script>
@endpush

