@php use App\Models\CommentsClients;use App\Models\Customers;use App\Models\Sales; @endphp
@extends('admin.index')
@section('content')

    <title>{{trans('admin.CustomerPeriodReports')}}</title>

    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.CRM')}}</a></li>
            <li class="breadcrumb-item active">{{trans('admin.CustomerPeriodReports')}}</li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                    class="js-get-date"></span></li>
        </ol>

        <div class="row">
            <div class="col-xl-12">
                <div id="panel-1" class="panel">
                    <div class="panel-hdr">
                        <h2>
                            <span class="fw-300"><i>{{trans('admin.CustomerPeriodReports')}}</i></span>
                        </h2>

                        <div class="panel-toolbar">

                        </div>
                        @include('admin.layouts.toolbar')
                    </div>
                    <div class="panel-container show">
                        <span id="ex"> @include('admin.layouts.messages')</span>
                        <div class="panel-content">
                            <!-- datatable start -->
                            <table id="dt-basic-example"
                                   class="table table-bordered table-hover table-striped w-100">
                                <thead class="bg-highlight">
                                <tr>
                                    <th>{{trans('admin.Clients_Count')}}</th>
                                    <th>{{trans('admin.Comments_Count')}}</th>
                                    <th>{{trans('admin.Sales_Bill_Count')}}</th>
                                    <th>{{trans('admin.Total_Sales_Bill')}}</th>

                                </tr>
                                </thead>
                                <tbody>


                                <tr>

                                    <td>
                                        <button type="button" class="btn btn-primary" data-toggle="modal"
                                                data-target="#details">{{$CustmersCount}}</button>
                                    </td>
                                    <td>{{$CommentsCount}}</td>
                                    <td>{{$SalesCount}}</td>
                                    <td>{{$SalesTotal}}</td>


                                </tr>

                                </tbody>
                                <tfoot>
                                <tr>
                                    <th>{{trans('admin.Clients_Count')}}</th>
                                    <th>{{trans('admin.Comments_Count')}}</th>
                                    <th>{{trans('admin.Sales_Bill_Count')}}</th>
                                    <th>{{trans('admin.Total_Sales_Bill')}}</th>
                                </tr>
                                </tfoot>
                            </table>
                            <!-- datatable end -->

                        </div>
                    </div>
                </div>
            </div>
        </div>


        <!-- Modal Details -->
        <div class="modal fade" id="details" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">
                            {{trans('admin.details')}}
                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>
                    <div class="modal-body">

                        <table
                            class="table table-bordered table-hover table-striped w-100">
                            <thead class="bg-highlight">
                            <tr>
                                <th>{{trans('admin.Governrate')}}</th>
                                <th>{{trans('admin.Count')}}</th>


                            </tr>
                            </thead>
                            <tbody>

                            @foreach($Governrates as $gov)
                                @php    $Count=Customers::whereBetween('Date',[$From,$To])->where('Governrate',$gov->id)->count();  @endphp
                                <tr>


                                    <td>{{app()->getLocale() == 'ar' ?$gov->Arabic_Name :$gov->English_Name}}</td>

                                    <td>{{$Count}}</td>


                                </tr>
                            @endforeach

                            </tbody>
                        </table>


                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                                data-dismiss="modal"> {{trans('admin.Close')}}</button>

                    </div>
                </div>
            </div>
        </div>

    </main>

@endsection

@push('js')
    <link rel="stylesheet" media="screen, print"
          href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            exportOptions: {
                                format: {
                                    body: function ( inner, rowidx, colidx, node ) {
                                        if ($(node).children("select").length > 0) {
                                            // we are in a cell containing a "select" drop-down - so, get it:
                                            var selectNode = node.firstElementChild;
                                            var txt = selectNode.options[selectNode.selectedIndex].text;
                                            //var txt = selectNode.options[selectNode.selectedIndex].text;
                                            return txt;
                                        } else {

                                            if ($(node).children("input").length > 0) {
                                                return $(node).children("input").first().val();
                                            } else {
                                                return inner;
                                            }


                                        }
                                    }
                                }
                            },
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>
@endpush

