@extends('admin.index')
@section('content')


  <title>{{trans('admin.InsurancePaperReport')}}</title>

<style>
    .over-flow{
        overflow:auto;
    }
    .table-width{
        width:180%;
    }
    @media print{
            .over-flow{
            overflow:visible;
        }
        .table-width{
            width:100%;
        }
        @page{

            margin:0;
            padding:0;
        }
    }
</style>

   <main id="js-page-content" role="main" class="page-content">
                    <ol class="breadcrumb page-breadcrumb no-print">
                        <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Accounts_Reports')}} </a></li>
                        <li class="breadcrumb-item active">{{trans('admin.InsurancePaperReport')}}</li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                                class="js-get-date"></span></li>
                    </ol>

                    <!-- data entry -->
                    <div class="row ">
                        <div class="col-lg-12">
                            <div id="panel-2" class="panel">
                                <div class="panel-hdr no-print">
                                    <h2>
                                        <span class="fw-300"><i>   {{trans('admin.Filter')}}</i></span>
                                    </h2>
                                </div>
                                <div class="panel-container show">
                                    <div class="panel-content">
                                             <form action="{{url('InsurancePaperReportFilter')}}" method="get">


                                        <div class="form-row">
                                            <div class="form-group col-md-2 col-4">
                                                <label class="form-label" for="simpleinput">{{trans('admin.From')}}</label>
                                                <input type="date" id="from" value="{{date('Y-m-d')}}" name="from" class="form-control">
                                            </div>
                                            <div class="form-group col-md-2 col-4">
                                                <label class="form-label" for="simpleinput">{{trans('admin.To')}}</label>
                                                <input type="date" id="to" value="{{date('Y-m-d')}}" name="to" class="form-control">
                                            </div>

                                            <div class="form-group col-md-2 no-print">
                                                <label class="form-label" for="">  {{trans('admin.Coin')}}</label>

              <select id="coin"  data-placeholder="{{trans('admin.Coin')}}" name="coin" class="js-data-example-ajax form-control">
                                <option value="">{{trans('admin.Coin')}}</option>
                                                </select>

                                            </div>
                                            <div class="form-group col-md-2 col-4">
                                                <label class="form-label" for="">  {{trans('admin.Account')}}</label>

                <select id="account" data-placeholder="{{trans('admin.Account')}}" name="account" class="js-data-example-ajax form-control">
                                 <option value="">{{trans('admin.Account')}}</option>
                                                </select>
                                            </div>

                                            <div class="form-group col-md-2 no-print">
                                                <label class="form-label" for="">  {{trans('admin.User')}}</label>
                             <select id="user" data-placeholder="{{trans('admin.User')}}" name="user" class="js-data-example-ajax form-control">
                                 <option value="" >{{trans('admin.User')}}</option>
                                                </select>
                                            </div>


                 <div class="form-group col-md-2 no-print">
                                    <label class="form-label" for="">{{trans('admin.Bank')}}   </label>
                        <select class="js-data-example-ajax form-control w-100"  id="Bank" name="Bank" >
                                    </select>
                                </div>

                                            <div class="form-group col-md-2 no-print">

                                                       <div class="buttons m-2">
                                            <button type="submit" class="btn btn-primary"><i class="fal fa-search"></i></button>
                                                </div>
                                            </div>
                                        </div>
                                                  </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="row hide-table" style="display: none">
                        <div class="col-xl-12">
                            <div id="panel-1" class="panel">
                                <div class="panel-hdr">
                                    <h2>
                                       {{trans('admin.InsurancePaperReport')}}
                                    </h2>

                                    <div class="panel-toolbar">
                                        <button class="btn btn-primary btn-sm" data-toggle="dropdown">Table
                                            Style</button>
                          @include('admin.layouts.toolbar')
                                    </div>

                                </div>
                                <div class="panel-container show">
                                    <div class="panel-content">
                                        <!-- datatable start -->
                                        <div class="over-flow">
                                        <table id="X"
                                            class="table table-bordered table-hover table-striped">
                                            <thead class="bg-highlight">
                                                <tr>
                                                    <th> {{trans('admin.Code')}} </th>
                                                    <th> {{trans('admin.Date')}} </th>
                                                    <th> {{trans('admin.Account_Name')}} </th>
                                                    <th> {{trans('admin.From')}} </th>
                                                    <th> {{trans('admin.To')}} </th>
                                                    <th> {{trans('admin.Due_Date')}} </th>
                                                    <th> {{trans('admin.Amount')}} </th>
                                                    <th>{{trans('admin.Coin')}} </th>
                                                    <th>{{trans('admin.Draw')}} </th>
                                                    <th>{{trans('admin.Coin_Amount')}} </th>
                                                    <th>{{trans('admin.Notes')}} </th>
                                                    <th>{{trans('admin.User')}}</th>

                                                </tr>
                                            </thead>
                                            <tbody class="Data">

                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                           <th> {{trans('admin.Code')}} </th>
                                                    <th> {{trans('admin.Date')}} </th>
                                                    <th> {{trans('admin.Account_Name')}} </th>
                                                    <th> {{trans('admin.From')}} </th>
                                                    <th> {{trans('admin.To')}} </th>
                                                    <th> {{trans('admin.Due_Date')}} </th>
                                                    <th> {{trans('admin.Amount')}} </th>
                                                    <th>{{trans('admin.Coin')}} </th>
                                                    <th>{{trans('admin.Draw')}} </th>
                                                    <th>{{trans('admin.Coin_Amount')}} </th>
                                                    <th>{{trans('admin.Notes')}} </th>
                                                    <th>{{trans('admin.User')}}</th>
                                                </tr>
                                            </tfoot>

                                        </table>
                                        </div>
                                        <div id="mobile-overflow">
                                        <table class="table table-bordered table-hover table-striped w-100 mt-4 mobile-width">
                                            <tbody>
                                                <tr>
                                                    <td>{{trans('admin.Numbers')}}</td>
                                                    <td></td>
                                                    <td>{{trans('admin.Total')}}</td>
                                                    <td></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        </div>
                                        <!-- datatable end -->
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </main>



@endsection


@push('js')
   <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
  <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>


<!-- Search Selecet -->
 <script>
        $(document).ready(function()
        {
            $(function()
            {
                $('.select2').select2();

                $(".select2-placeholder-multiple").select2(
                {
                    placeholder: "Select State"
                });
                $(".js-hide-search").select2(
                {
                    minimumResultsForSearch: 1 / 0
                });
                $(".js-max-length").select2(
                {
                    maximumSelectionLength: 2,
                    placeholder: "Select maximum 2 items"
                });
                $(".select2-placeholder").select2(
                {
                    placeholder: "Select a state",
                    allowClear: true
                });

                $(".js-select2-icons").select2(
                {
                    minimumResultsForSearch: 1 / 0,
                    templateResult: icon,
                    templateSelection: icon,
                    escapeMarkup: function(elm)
                    {
                        return elm
                    }
                });

                function icon(elm)
                {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
                }

                      $('#Bank').select2({
    placeholder: "select...",
    ajax: {
        type: "GET",
        dataType: 'json',
        url: 'AllBanksAccounts',
        processResults: function (data) {
          return {
            results: $.map(data, function(obj, index) {
              return { id: index, text: obj };
            })
          };

            	console.log(data);

        },
   data: function (params) {


                   var query = {
                            search: params.term,
                        };


              $.ajax({
                              url: 'AllBanksAccountsJ/'+params.term,
                              type:"GET",
                              dataType:"json",
                              beforeSend: function(){
                                  $('#loader').css("visibility", "visible");
                              },

                              success:function(data) {
                                          $('#Bank').empty();
                                  $.each(data, function(key, value){

                         $('#Bank').append('<option value="'+ key +'">' + value + '</option>');

                                  });

                                     fetch_customer_data();



    function fetch_customer_data(from = '',to = '',coin = '',account = '',type = '',cost = '',user = '',CheckStatus = '',CheckType = '',Bank = '')
    {
     $.ajax({
      url:'Checks_ReportsFilter',
      method:'GET',
      data:{from:from,to:to,coin:coin,account:account,type:type,cost:cost,user:user,CheckStatus:CheckStatus,CheckType:CheckType,Bank:Bank},
      dataType:'json',
      success:function(data)
      {


       $('.Data').html(data.table_data);
       $('.TD').html(data.totalD);
       $('.TC').html(data.totalC);
       $('.NUM').html(data.totalN);
       $('.DIF').html(data.dif);


      }
     })
    }


     var from = $('#from').val();
     var to = $('#to').val();
     var coin = $('#coin').val();
     var account = $('#account').val();
     var type = $('#type').val();
     var cost = $('#cost').val();
     var user = $('#user').val();
     var CheckStatus = $('#CheckStatus').val();
     var CheckType = $('#CheckType').val();
     var Bank = $('#Bank').val();
     fetch_customer_data(from,to,coin,account,type,cost,user,CheckStatus,CheckType,Bank);




                              },
                              complete: function(){
                                  $('#loader').css("visibility", "hidden");
                              }
                          });



        }
    }
  });


$('#Bank').on('select2:select', function (e) {
	console.log("select done", e.params.data);
});


  $('#coin').select2({
    ajax: {
        type: "GET",
        dataType: 'json',
        url: 'AllCoins',
        processResults: function (data) {
          return {
            results: $.map(data, function(obj, index) {
              return { id: index, text: obj };
            })
          };
        },
        data: function (params) {


                   var query = {
                            search: params.term,
                        };


              $.ajax({
                              url: 'AllCoinsJ/'+params.term,
                              type:"GET",
                              dataType:"json",
                              beforeSend: function(){
                                  $('#loader').css("visibility", "visible");
                              },

                              success:function(data) {
                                          $('#coin').empty();
                                  $.each(data, function(key, value){

                         $('#coin').append('<option value="'+ key +'">' + value + '</option>');

                                  });

                                                                    fetch_customer_data();



    function fetch_customer_data(from = '',to = '',coin = '',account = '',type = '',cost = '',user = '',CheckStatus = '',CheckType = '',Bank = '')
    {
     $.ajax({
      url:'Checks_ReportsFilter',
      method:'GET',
      data:{from:from,to:to,coin:coin,account:account,type:type,cost:cost,user:user,CheckStatus:CheckStatus,CheckType:CheckType,Bank:Bank},
      dataType:'json',
      success:function(data)
      {


       $('.Data').html(data.table_data);
       $('.TD').html(data.totalD);
       $('.TC').html(data.totalC);
       $('.NUM').html(data.totalN);
       $('.DIF').html(data.dif);


      }
     })
    }


     var from = $('#from').val();
     var to = $('#to').val();
     var coin = $('#coin').val();
     var account = $('#account').val();
     var type = $('#type').val();
     var cost = $('#cost').val();
     var user = $('#user').val();
     var CheckStatus = $('#CheckStatus').val();
     var CheckType = $('#CheckType').val();
     var Bank = $('#Bank').val();
     fetch_customer_data(from,to,coin,account,type,cost,user,CheckStatus,CheckType,Bank);


                              },
                              complete: function(){
                                  $('#loader').css("visibility", "hidden");
                              }
                          });



        }
        }
  });



$('#coin').on('select2:select', function (e) {
	console.log("select done", e.params.data);
});


  $('#account').select2({
    placeholder: "select...",
    ajax: {
        type: "GET",
        dataType: 'json',
        url: 'AllSubAccounts',
        processResults: function (data) {
          return {
            results: $.map(data, function(obj, index) {
              return { id: index, text: obj };
            })
          };

            	console.log(data);

        },
          data: function (params) {


                   var query = {
                            search: params.term,
                        };


              $.ajax({
                              url: 'AllSubAccountsJ/'+params.term,
                              type:"GET",
                              dataType:"json",
                              beforeSend: function(){
                                  $('#loader').css("visibility", "visible");
                              },

                              success:function(data) {
                                          $('#account').empty();
                                  $.each(data, function(key, value){

                         $('#account').append('<option value="'+ key +'">' + value + '</option>');

                                  });

                                                                  fetch_customer_data();



    function fetch_customer_data(from = '',to = '',coin = '',account = '',type = '',cost = '',user = '',CheckStatus = '',CheckType = '',Bank = '')
    {
     $.ajax({
      url:'Checks_ReportsFilter',
      method:'GET',
      data:{from:from,to:to,coin:coin,account:account,type:type,cost:cost,user:user,CheckStatus:CheckStatus,CheckType:CheckType,Bank:Bank},
      dataType:'json',
      success:function(data)
      {


       $('.Data').html(data.table_data);
       $('.TD').html(data.totalD);
       $('.TC').html(data.totalC);
       $('.NUM').html(data.totalN);
       $('.DIF').html(data.dif);


      }
     })
    }


     var from = $('#from').val();
     var to = $('#to').val();
     var coin = $('#coin').val();
     var account = $('#account').val();
     var type = $('#type').val();
     var cost = $('#cost').val();
     var user = $('#user').val();
     var CheckStatus = $('#CheckStatus').val();
     var CheckType = $('#CheckType').val();
     var Bank = $('#Bank').val();
     fetch_customer_data(from,to,coin,account,type,cost,user,CheckStatus,CheckType,Bank);



                              },
                              complete: function(){
                                  $('#loader').css("visibility", "hidden");
                              }
                          });



        }
    }
  });


$('#account').on('select2:select', function (e) {
	console.log("select done", e.params.data);
});


      $('#cost').select2({
    placeholder: "select...",
    ajax: {
        type: "GET",
        dataType: 'json',
        url: 'AllCostss',
        processResults: function (data) {
          return {
            results: $.map(data, function(obj, index) {
              return { id: index, text: obj };
            })
          };

            	console.log(data);

        },

         data: function (params) {


                   var query = {
                            search: params.term,
                        };


              $.ajax({
                              url: 'AllCostssJ/'+params.term,
                              type:"GET",
                              dataType:"json",
                              beforeSend: function(){
                                  $('#loader').css("visibility", "visible");
                              },

                              success:function(data) {
                                          $('#cost').empty();
                                  $.each(data, function(key, value){

                         $('#cost').append('<option value="'+ key +'">' + value + '</option>');

                                  });

                                                                  fetch_customer_data();



    function fetch_customer_data(from = '',to = '',coin = '',account = '',type = '',cost = '',user = '',CheckStatus = '',CheckType = '',Bank = '')
    {
     $.ajax({
      url:'Checks_ReportsFilter',
      method:'GET',
      data:{from:from,to:to,coin:coin,account:account,type:type,cost:cost,user:user,CheckStatus:CheckStatus,CheckType:CheckType,Bank:Bank},
      dataType:'json',
      success:function(data)
      {


       $('.Data').html(data.table_data);
       $('.TD').html(data.totalD);
       $('.TC').html(data.totalC);
       $('.NUM').html(data.totalN);
       $('.DIF').html(data.dif);


      }
     })
    }


     var from = $('#from').val();
     var to = $('#to').val();
     var coin = $('#coin').val();
     var account = $('#account').val();
     var type = $('#type').val();
     var cost = $('#cost').val();
     var user = $('#user').val();
     var CheckStatus = $('#CheckStatus').val();
     var CheckType = $('#CheckType').val();
     var Bank = $('#Bank').val();
     fetch_customer_data(from,to,coin,account,type,cost,user,CheckStatus,CheckType,Bank);



                              },
                              complete: function(){
                                  $('#loader').css("visibility", "hidden");
                              }
                          });



        }

    }
  });


$('#cost').on('select2:select', function (e) {
	console.log("select done", e.params.data);
});



  $('#user').select2({
    placeholder: "select...",
    ajax: {
        type: "GET",
        dataType: 'json',
        url: 'AllUsers',
        processResults: function (data) {
          return {
            results: $.map(data, function(obj, index) {
              return { id: index, text: obj };
            })
          };

            	console.log(data);

        },
         data: function (params) {


                   var query = {
                            search: params.term,
                        };


              $.ajax({
                              url: 'AllUsersJ/'+params.term,
                              type:"GET",
                              dataType:"json",
                              beforeSend: function(){
                                  $('#loader').css("visibility", "visible");
                              },

                              success:function(data) {
                                          $('#user').empty();
                                  $.each(data, function(key, value){

                         $('#user').append('<option value="'+ key +'">' + value + '</option>');

                                  });

                                                                    fetch_customer_data();



    function fetch_customer_data(from = '',to = '',coin = '',account = '',type = '',cost = '',user = '',CheckStatus = '',CheckType = '',Bank = '')
    {
     $.ajax({
      url:'Checks_ReportsFilter',
      method:'GET',
      data:{from:from,to:to,coin:coin,account:account,type:type,cost:cost,user:user,CheckStatus:CheckStatus,CheckType:CheckType,Bank:Bank},
      dataType:'json',
      success:function(data)
      {


       $('.Data').html(data.table_data);
       $('.TD').html(data.totalD);
       $('.TC').html(data.totalC);
       $('.NUM').html(data.totalN);
       $('.DIF').html(data.dif);


      }
     })
    }


     var from = $('#from').val();
     var to = $('#to').val();
     var coin = $('#coin').val();
     var account = $('#account').val();
     var type = $('#type').val();
     var cost = $('#cost').val();
     var user = $('#user').val();
     var CheckStatus = $('#CheckStatus').val();
     var CheckType = $('#CheckType').val();
     var Bank = $('#Bank').val();
     fetch_customer_data(from,to,coin,account,type,cost,user,CheckStatus,CheckType,Bank);


                              },
                              complete: function(){
                                  $('#loader').css("visibility", "hidden");
                              }
                          });



        }
    }
  });


$('#user').on('select2:select', function (e) {
	console.log("select done", e.params.data);
});



            });
        });



    </script>

<script>
    var autoSave = $('#autoSave');
    var interval;
    var timer = function()
    {
        interval = setInterval(function()
        {
            //start slide...
            if (autoSave.prop('checked'))
                saveToLocal();

            clearInterval(interval);
        }, 3000);
    };

    //save
    var saveToLocal = function()
    {
        localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
        console.log("saved");
    }

    //delete
    var removeFromLocal = function()
    {
        localStorage.removeItem("summernoteData");
        $('#saveToLocal').summernote('reset');
    }

    $(document).ready(function()
    {
        //init default
        $('.js-summernote').summernote(
        {
            height: 200,
            tabsize: 2,
            placeholder: "Type here...",
            dialogsFade: true,
            toolbar: [
                ['style', ['style']],
                ['font', ['strikethrough', 'superscript', 'subscript']],
                ['font', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['height', ['height']]
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ],
            callbacks:
            {
                //restore from localStorage
                onInit: function(e)
                {
                    $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                },
                onChange: function(contents, $editable)
                {
                    clearInterval(interval);
                    timer();
                }
            }
        });

        //load emojis
        $.ajax(
        {
            url: 'https://api.github.com/emojis',
            async: false
        }).then(function(data)
        {
            window.emojis = Object.keys(data);
            window.emojiUrls = data;
        });

        //init emoji example
        $(".js-hint2emoji").summernote(
        {
            height: 100,
            toolbar: false,
            placeholder: 'type starting with : and any alphabet',
            hint:
            {
                match: /:([\-+\w]+)$/,
                search: function(keyword, callback)
                {
                    callback($.grep(emojis, function(item)
                    {
                        return item.indexOf(keyword) === 0;
                    }));
                },
                template: function(item)
                {
                    var content = emojiUrls[item];
                    return '<img src="' + content + '" width="20" /> :' + item + ':';
                },
                content: function(item)
                {
                    var url = emojiUrls[item];
                    if (url)
                    {
                        return $('<img />').attr('src', url).css('width', 20)[0];
                    }
                    return '';
                }
            }
        });

        //init mentions example
        $(".js-hint2mention").summernote(
        {
            height: 100,
            toolbar: false,
            placeholder: "type starting with @",
            hint:
            {
                mentions: ['jayden', 'sam', 'alvin', 'david'],
                match: /\B@(\w*)$/,
                search: function(keyword, callback)
                {
                    callback($.grep(this.mentions, function(item)
                    {
                        return item.indexOf(keyword) == 0;
                    }));
                },
                content: function(item)
                {
                    return '@' + item;
                }
            }
        });

    });

</script>
<script type="text/javascript">


    $(".show-table").click(function(){
        $(".hide-table").show();
    });

</script>

    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>


@endpush

