@extends('admin.index')
@section('content')

<title>{{trans('admin.Transfer_Sure')}}</title>
<main id="js-page-content" role="main" class="page-content">
    <ol class="breadcrumb page-breadcrumb">
        <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Accounts')}}</a></li>
        <li class="breadcrumb-item">{{trans('admin.Transfer_Sure')}}</li>
        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
    </ol>
    <div class="row">
        <div class="col-lg-12">
            <div id="panel-2" class="panel">
                <div class="panel-hdr">
                    <h2>
                        <span class="fw-300"><i> {{trans('admin.Transfer_Sure')}} </i></span>
                    </h2>
                </div>
                <div class="panel-container show">
                    <span id="ex"> @include('admin.layouts.messages')</span>
                    <div class="panel-content">
                        <form action="{{url('SureSafeTransfer/'.$item->id)}}" method="post">
                            {!! csrf_field() !!}
                            @honeypot
                            <div class="form-row">

                                <div class="form-group col-lg-1">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Code')}} </label>
                                    <input type="text" value="{{$item->Code}}" class="form-control" disabled>
                                    <input type="hidden" name="Code" value="{{$item->Code}}">
                                    <input type="hidden" name="Files" value="{{$item->File}}">
                                    <input type="hidden" name="Edit" value="{{$item->Edit}}">
                                </div>

                                @if(auth()->guard('admin')->user()->emp == 0)
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                                    <input type="date" name="Date" value="{{$item->Date}}" class="form-control" required>
                                </div>
                                @else

                                @if(auth()->guard('admin')->user()->Date == 1)
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                                    <input type="date" name="Date" value="{{$item->Date}}" class="form-control" required>
                                </div>
                                @else

                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                                    <input type="date" name="Date" value="{{$item->Date}}" class="form-control" required readonly>
                                </div>
                                @endif

                                @endif



                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="">{{trans('admin.Branch')}}</label>
                                    <select class="select2 form-control w-100" name="Branch">
                                        <option value="">{{trans('admin.Branch')}}</option>
                                        @foreach($Branches as $bran)
                                        <option value="{{$bran->id}}" @if($item->Branch == $bran->id) selected @endif>


                                            {{app()->getLocale() == 'ar' ?$bran->Arabic_Name :$bran->English_Name}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>



                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="">{{trans('admin.Currency')}}</label>
                                    <select class="select2 form-control w-100" name="Coin" required>
                                        <option value="">{{trans('admin.Currency')}}</option>
                                        @foreach($Coins as $coin)
                                        <option value="{{$coin->id}}" @if($coin->id == $item->Coin) selected @endif>
                                            {{app()->getLocale() == 'ar' ?$coin->Arabic_Name :$coin->English_Name}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Draw')}}</label>
                                    <input type="number" step="any" name="Draw" value="{{$item->Draw}}" class="form-control" required />
                                </div>

                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="">{{trans('admin.Cost_Center')}}</label>
                                    <select class="select2 form-control w-100" name="Cost_Center">
                                        <option value="">{{trans('admin.Cost_Center')}}</option>
                                        @foreach($CostCenters as $cost)
                                        <option value="{{$cost->id}}" @if($cost->id == $item->Cost_Center) selected @endif>
                                            {{app()->getLocale() == 'ar' ?$cost->Arabic_Name :$cost->English_Name}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>




                                <!--new row-->
                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Amount')}}</label>
                                    <input type="number" name="Amount" id="Amount" onkeyup="ChangeP()" onclick="ChangeP()" class="form-control" onkeypress="ChangeP()" value="{{$item->Amount}}" required readonly>
                                    <input type="hidden" name="OldAmount" value="{{$item->OldAmount}}">
                                </div>


                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="">{{trans('admin.From_Safe')}}</label>
                                    <select class="js-data-example-ajax form-control w-100" id="Safe" name="From_Safe" required>

                                        @if(!empty($item->From_Safe()->first()->Name))
                                        <option value="{{$item->From_Safe}}" selected>
                                            {{app()->getLocale() == 'ar' ?$item->From_Safe()->first()->Name :$item->From_Safe()->first()->NameEn}}
                                        </option>

                                        @endif
                                    </select>
                                </div>

                                <div class="form-group col-lg-2">
                                    <label class="form-label"> {{trans('admin.Safe_Balance')}} </label>
                                    <input type="text" disabled class="form-control" id="SafeBalance">
                                </div>

                                <div class="form-group col-lg-2">
                                    <label class="form-label" for=""> {{trans('admin.To_Safe')}}</label>
                                    <select class="js-data-example-ajax form-control w-100" id="ToSafe" name="To_Safe" required>

                                        @foreach($ToSafes as $safe)


                                            <option value="{{$safe->id}}" @if($safe->id == $item->To_Safe) selected @endif >
                                                {{app()->getLocale() == 'ar' ?$safe->Name :$safe->NameEn}}
                                            </option>

                                        @endforeach
                                    </select>
                                </div>

                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="">{{trans('admin.Delegate')}}</label>
                                    <select class="select2 form-control w-100" name="Delegate">
                                        <option value="">{{trans('admin.Delegate')}}</option>
                                        @foreach($Emps as $emp)
                                        <option value="{{$emp->id}}" @if($item->Delegate == $emp->id) selected @endif>

                                            {{app()->getLocale() == 'ar' ?$emp->Name :$emp->NameEn}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>


                                <div class="form-group col-lg-9">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Notes')}}</label>
                                    <input type="text" name="Note" value="{{$item->Note}}" class="form-control">
                                </div>


                                <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.File')}}</label>
                                    <input type="file" name="File">

                                </div>


                                <div class="buttons mt-3 pt-2" id="Submit">
                                    <button type="submit" class="btn btn-primary"> <i class="fal fa-folder"></i> {{trans('admin.Save')}} </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">

    </div>

</main>

@endsection
@push('js')
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">

<script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
<script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>

<script>
    var autoSave = $('#autoSave');
    var interval;
    var timer = function() {
        interval = setInterval(function() {
            //start slide...
            if (autoSave.prop('checked'))
                saveToLocal();

            clearInterval(interval);
        }, 3000);
    };

    //save
    var saveToLocal = function() {
        localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
        console.log("saved");
    }

    //delete
    var removeFromLocal = function() {
        localStorage.removeItem("summernoteData");
        $('#saveToLocal').summernote('reset');
    }

    $(document).ready(function() {
        //init default
        $('.js-summernote').summernote({
            height: 200,
            tabsize: 2,
            placeholder: "Type here...",
            dialogsFade: true,
            toolbar: [
                ['style', ['style']],
                ['font', ['strikethrough', 'superscript', 'subscript']],
                ['font', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['height', ['height']]
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ],
            callbacks: {
                //restore from localStorage
                onInit: function(e) {
                    $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                },
                onChange: function(contents, $editable) {
                    clearInterval(interval);
                    timer();
                }
            }
        });

        //load emojis
        $.ajax({
            url: 'https://api.github.com/emojis',
            async: false
        }).then(function(data) {
            window.emojis = Object.keys(data);
            window.emojiUrls = data;
        });

        //init emoji example
        $(".js-hint2emoji").summernote({
            height: 100,
            toolbar: false,
            placeholder: 'type starting with : and any alphabet',
            hint: {
                match: /:([\-+\w]+)$/,
                search: function(keyword, callback) {
                    callback($.grep(emojis, function(item) {
                        return item.indexOf(keyword) === 0;
                    }));
                },
                template: function(item) {
                    var content = emojiUrls[item];
                    return '<img src="' + content + '" width="20" /> :' + item + ':';
                },
                content: function(item) {
                    var url = emojiUrls[item];
                    if (url) {
                        return $('<img />').attr('src', url).css('width', 20)[0];
                    }
                    return '';
                }
            }
        });

        //init mentions example
        $(".js-hint2mention").summernote({
            height: 100,
            toolbar: false,
            placeholder: "type starting with @",
            hint: {
                mentions: ['jayden', 'sam', 'alvin', 'david'],
                match: /\B@(\w*)$/,
                search: function(keyword, callback) {
                    callback($.grep(this.mentions, function(item) {
                        return item.indexOf(keyword) == 0;
                    }));
                },
                content: function(item) {
                    return '@' + item;
                }
            }
        });

    });

</script>
<script>
    function Insert() {
        var debit = document.getElementById('debit').value;
        var creditor = document.getElementById('creditor').value;
        // var accountCode = document.getElementById('account-code').value;
        var accountName = document.getElementById('select-one').value;
        // var centersCost = document.getElementById('centers-cost').value;
        var statement = document.getElementById('statement').value;

        var table = ` <tr>
                                <td>${debit}</td>
                                <td>${creditor}</td>
                                <td></td>
                                <td>${accountName}</td>
                                <td></td>
                                <td>${statement}</td>
                                <td>
                                    <button type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                </td>
                             </tr>`;
        document.getElementById('data-dt').innerHTML += table;
    }

</script>



<!-- Search Selecet -->
<script>
    $(document).ready(function() {
        $(function() {
            $('.select2').select2();

            $(".select2-placeholder-multiple").select2({
                placeholder: "Select State"
            });
            $(".js-hide-search").select2({
                minimumResultsForSearch: 1 / 0
            });
            $(".js-max-length").select2({
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items"
            });
            $(".select2-placeholder").select2({
                placeholder: "Select a state",
                allowClear: true
            });

            $(".js-select2-icons").select2({
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function(elm) {
                    return elm
                }
            });

            function icon(elm) {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
            }



            $('#Safe').select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: 'json',
                    url: 'AllSafes',
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            })
                        };

                        console.log(data);

                    },
                    data: function(params) {


                        var query = {
                            search: params.term,
                        };


                        $.ajax({
                            url: 'AllSafesJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#Safe').empty();
                                $.each(data, function(key, value) {

                                    $('#Safe').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                }
            });


            $('#Safe').on('select2:select', function(e) {
                console.log("select done", e.params.data);
            });






        });
    });

</script>

<!-- Safe Balance  -->
<script>
    $(document).ready(function() {

        $('#Safe').on('change', function() {
            var countryId = $(this).val();
            if (countryId) {
                $.ajax({
                    url: 'SafeBalanceFilter/' + countryId,
                    type: "GET",
                    dataType: "json",
                    beforeSend: function() {
                        $('#loader').css("visibility", "visible");
                    },

                    success: function(data) {
                        $.each(data, function(key, value) {


                            $('#SafeBalance').val(parseFloat(key).toFixed(2));
                            $('#SafeBalance').val(parseFloat(value).toFixed(2));
                        });

                        var Balance = $('#SafeBalance').val();
                        var Amount = $('#Amount').val();

                        if (parseFloat(Amount) > parseFloat(Balance)) {

                            document.getElementById('Submit').style.display = 'none';

                        } else {

                            document.getElementById('Submit').style.display = 'block';

                        }


                    },
                    complete: function() {
                        $('#loader').css("visibility", "hidden");
                    }
                });
            } else {

                $('select[name="state"]').empty();
            }

        });

    });

    $(document).ready(function() {

        var countryId = $('#Safe').val();
        if (countryId) {
            $.ajax({
                url: 'SafeBalanceFilter/' + countryId,
                type: "GET",
                dataType: "json",
                beforeSend: function() {
                    $('#loader').css("visibility", "visible");
                },

                success: function(data) {
                    $.each(data, function(key, value) {


                        $('#SafeBalance').val(parseFloat(key).toFixed(2));
                        $('#SafeBalance').val(parseFloat(value).toFixed(2));
                    });

                    var Balance = $('#SafeBalance').val();
                    var Amount = $('#Amount').val();

                    if (parseFloat(Amount) > parseFloat(Balance)) {

                        document.getElementById('Submit').style.display = 'none';

                    } else {

                        document.getElementById('Submit').style.display = 'block';

                    }


                },
                complete: function() {
                    $('#loader').css("visibility", "hidden");
                }
            });
        } else {

            $('select[name="state"]').empty();
        }

    });

</script>

<script>
    function ChangeP() {

        var Balance = $('#SafeBalance').val();
        var Amount = $('#Amount').val();

        if (parseFloat(Amount) > parseFloat(Balance)) {


            document.getElementById('Submit').style.display = 'none';

        } else {

            if (parseFloat(Amount) < 0) {
                document.getElementById('Submit').style.display = 'none';
            } else {
                document.getElementById('Submit').style.display = 'block';
            }


        }


    }

</script>

<style>
    .form-control {
        border: 2px solid #584576 !important;
    }

</style>

@endpush
