@extends('admin.index')
@section('content')

  <title>{{trans('admin.Spend_Profits')}}</title>

 <main id="js-page-content" role="main" class="page-content">
                    <ol class="breadcrumb page-breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Capital')}}</a></li>
                        <li class="breadcrumb-item active">{{trans('admin.Spend_Profits')}}</li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                                class="js-get-date"></span></li>
                    </ol>

                    <div class="row">
                        <div class="col-xl-12">
                            <div id="panel-1" class="panel">
                                <div class="panel-hdr">
                                    <h2>
                                        <span class="fw-300"><i> {{trans('admin.Spend_Profits')}}  </i></span>
                                    </h2>

                                    <div class="panel-toolbar">

                      @can('اضافه صرف ارباح')
                     <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg">{{trans('admin.AddNew')}}</button>
                    @endcan


                            <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>
             @include('admin.layouts.toolbar')
                                    </div>
                                </div>
                                <div class="panel-container show">
                                      <span id="ex"> @include('admin.layouts.messages')</span>
                                    <div class="panel-content">
                                        <!-- datatable start -->
                                        <div id="mobile-overflow">
                                        <table id="dt-basic-example"
                                            class="table table-bordered table-hover table-striped w-100 mobile-width">
                                            <thead class="bg-highlight">
                                                <tr>
                                                    <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Date')}}</th>
                                                    <th>{{trans('admin.Draw')}}</th>
                                                    <th>{{trans('admin.Amount')}}</th>
                                                    <th>{{trans('admin.Remaining_Profits')}}</th>
                                                    <th>{{trans('admin.Partner')}}</th>
                                                    <th>{{trans('admin.Safe')}}</th>
                                                    <th>{{trans('admin.Coin')}}</th>
                                                    <th>{{trans('admin.Cost_Center')}}</th>
                                                    <th>{{trans('admin.Payment_Method')}}</th>
                                                    <th>{{trans('admin.User')}}</th>
                                                    <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($items as $item)
                                                <tr>
                                                    <td>{{$item->Code}}</td>
                                                    <td>{{$item->Date}}</td>
                                                    <td>{{$item->Draw}}</td>
                                                    <td>{{$item->Amount}}</td>
                                                    <td>{{$item->Remaining_Profit}}</td>
                                                    <td>{{$item->Partner()->first()->Name}}</td>
                                                    <td>{{$item->Safe()->first()->Name}}</td>
                                                    <td>{{$item->Coin()->first()->Arabic_Name}}</td>
                                <td>@if(!empty($item->Cost_Center)){{$item->Cost_Center()->first()->Arabic_Name}} @endif</td>
                                <td>
                                    @if($item->Payment_Method == 'Cash')
                                        {{trans('admin.Cash')}}
                                    @else
                                        {{trans('admin.ReInvestment')}}
                                    @endif

                                </td>
                                                    <td>{{$item->User()->first()->name}}</td>
                                                    <td class="text-center">
        <a href="{{url('PrintSpendProfits/'.$item->id)}}" class="btn btn-default"><i class="fal fa-print"></i></a>
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                 <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Date')}}</th>
                                                    <th>{{trans('admin.Draw')}}</th>
                                                    <th>{{trans('admin.Amount')}}</th>
                                                    <th>{{trans('admin.Remaining_Profits')}}</th>
                                                    <th>{{trans('admin.Partner')}}</th>
                                                    <th>{{trans('admin.Safe')}}</th>
                                                    <th>{{trans('admin.Coin')}}</th>
                                                    <th>{{trans('admin.Cost_Center')}}</th>
                                                    <th>{{trans('admin.Payment_Method')}}</th>
                                                    <th>{{trans('admin.User')}}</th>
                                                    <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                        </div>
                                        <!-- datatable end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    <!-- Modal Add-->
             <div class="modal fade" id="default-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">{{trans('admin.AddNew')}}  </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>
                                <div class="modal-body">
                          <form action="{{url('AddSpendProfit')}}" method="post" enctype="multipart/form-data">
                                        {!! csrf_field() !!}
                                        <div class="form-row">

                                    <div class="form-group col-lg-3">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Code')}} </label>
                                            <input type="text" value="{{$Code}}" class="form-control " disabled>
                                            <input type="hidden" name="Code" value="{{$Code}}" class="form-control">
                                        </div>
                                        <div class="form-group col-lg-3">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                           <input type="date" name="Date" value="{{date('Y-m-d')}}" class="form-control" required>
                                        </div>

                                                     <div class="form-group col-lg-3">
                                            <label class="form-label" for="">{{trans('admin.Partner')}}</label>
       <select class="select2 form-control w-100" name="Partner" onchange="Result()" id="Partner" required>
                                                 <option value=""> {{trans('admin.Partner')}}</option>
                                            @foreach($Partners as $part)
                                                <option value="{{$part->id}}">
                                                {{$part->Name}}
                                                </option>
                                            @endforeach
                                            </select>
                                        </div>
                                                     <div class="form-group col-lg-3">
                                            <label class="form-label" for="">{{trans('admin.Payment_Method')}}</label>
       <select class="select2 form-control w-100" name="Payment_Method"  required>
                                                 <option value=""> {{trans('admin.Payment_Method')}}</option>
                                                 <option value="Cash"> {{trans('admin.Cash')}}</option>
                                                 <option value="ReInvestment"> {{trans('admin.ReInvestment')}}</option>
                                            </select>
                                        </div>

                                     <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Amount')}}</label>
         <input type="number" step="any" name="Amount" onclick="Result()" onkeyup="Result()" id="Amount" value="{{old('Amount')}}"  class="form-control" required>
                                            </div>

                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="simpleinput"> {{trans('admin.Profits')}}</label>
                                                <input type="number"  id="profit"   class="form-control" disabled>
                                            </div>

                                                 <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Remaining_Profits')}}</label>
             <input type="number"  id="Remaining_Profits" value="{{old('Remaining_Profits')}}"  class="form-control" disabled>
                 <input type="hidden" name="Remaining_Profit" id="Remaining_ProfitsHide">
                                            </div>



                                               <div class="form-group col-lg-3">
                                            <label class="form-label" for="">{{trans('admin.Safe')}}</label>
                                            <select class="select2 form-control w-100" name="Safe" required>
                                                 <option value=""> {{trans('admin.Safe')}}</option>
                                            @foreach($Safes as $safe)
                                                <option value="{{$safe->id}}">
                                                {{$safe->Name}}
                                                </option>
                                            @endforeach
                                            </select>
                                        </div>

                                        <div class="form-group col-lg-3">
                                            <label class="form-label" for="">{{trans('admin.Coin')}}</label>
                                            <select class="select2 form-control w-100" name="Coin" required>
                                                 <option value=""> {{trans('admin.Coin')}}</option>
                                            @foreach($Coins as $coin)
                                                <option value="{{$coin->id}}">
                                                {{$coin->Arabic_Name}}
                                                </option>
                                            @endforeach
                                            </select>
                                        </div>

                                        <div class="form-group col-lg-3">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Draw')}}</label>
                                            <input type="text" name="Draw" value="1" class="form-control" required>
                                        </div>

                                            <div class="form-group col-lg-3">
                                            <label class="form-label" for=""> {{trans('admin.Cost_Center')}} </label>
                                            <select class="select2 form-control w-100" name="Cost_Center">
                                            <option value=""> {{trans('admin.Cost_Center')}}</option>
                                            @foreach($CostCenters as $cost)
                                                <option value="{{$cost->id}}">
                                                {{$cost->Arabic_Name}}
                                                </option>
                                            @endforeach
                                            </select>
                                        </div>

                                        </div>
                                         <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                        <button type="submit" class="btn btn-primary"> {{trans('admin.Add')}}</button>
                                </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>


                </main>
@endsection

@push('js')
  <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    // responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>
<!-- Search Selecet -->
 <script>
        $(document).ready(function()
        {
            $(function()
            {
                $('.select2').select2();

                $(".select2-placeholder-multiple").select2(
                {
                    placeholder: "Select State"
                });
                $(".js-hide-search").select2(
                {
                    minimumResultsForSearch: 1 / 0
                });
                $(".js-max-length").select2(
                {
                    maximumSelectionLength: 2,
                    placeholder: "Select maximum 2 items"
                });
                $(".select2-placeholder").select2(
                {
                    placeholder: "Select a state",
                    allowClear: true
                });

                $(".js-select2-icons").select2(
                {
                    minimumResultsForSearch: 1 / 0,
                    templateResult: icon,
                    templateSelection: icon,
                    escapeMarkup: function(elm)
                    {
                        return elm
                    }
                });

                function icon(elm)
                {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
                }


  $('#AccountCode').select2({
    placeholder: "select...",
    ajax: {
        type: "GET",
        dataType: 'json',
        url: 'AllSubAccounts',
        processResults: function (data) {
          return {
            results: $.map(data, function(obj, index) {
              return { id: index, text: obj };
            })
          };

            	console.log(data);

        },
        data: function (params) {
          var query = {
            search: params.term
          };
          if (params.term == "*") query.items = [];
          return { json: JSON.stringify( query ) }
        }
    }
  });


$('#AccountCode').on('select2:select', function (e) {
	console.log("select done", e.params.data);
});


            });
        });



    </script>

<!-- Search Partner -->
<script>
function Result(){

   var  Partner = $('#Partner').val();
   var  Amount = $('#Amount').val();

                      if(Partner) {
                          $.ajax({
                              url: 'PartnerFilter/'+Partner,
                              type:"GET",
                              dataType:"json",
                              beforeSend: function(){
                                  $('#loader').css("visibility", "visible");
                              },

                              success:function(data) {
                                  $.each(data, function(key, value){
            var result = parseFloat(Amount) -  parseFloat(data.spending) ;
                    $('#Remaining_Profits').val(parseFloat(result));
                    $('#Remaining_ProfitsHide').val(parseFloat(result));
                    $('#profit').val(parseFloat(data.profit));
                                  });
                              },
                              complete: function(){
                                  $('#loader').css("visibility", "hidden");
                              }
                          });
                      } else {

                          $('select[name="state"]').empty();
                      }

}
</script>

@endpush

