@extends('admin.index')
@section('content')
@php
use App\Models\JournalizingDetails;
use App\Models\CompanyData;
$Def=CompanyData::orderBy('id','desc')->first();
use App\Models\AccountsDefaultData;
$DefAcc=AccountsDefaultData::orderBy('id','desc')->first();
@endphp
<title>{{trans('admin.Journalizing_Sechdule')}}</title>


<main id="js-page-content" role="main" class="page-content">
    <ol class="breadcrumb page-breadcrumb">
        <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Accounts')}}</a></li>
        <li class="breadcrumb-item active"> {{trans('admin.Journalizing_Sechdule')}} </li>
        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
    </ol>

    <!-- Filter  -->

    <div class="panel-container show">
        <div class="panel-content">


            <form action="{{url('JournalizingSechduleFilter')}}" method="get">

                <div class="form-row">
                    <div class="form-group col-md-3 col-4-print">
                        <label class="form-label" for="simpleinput">{{trans('admin.From')}}</label>
                        <input type="date" id="from" value="{{date('Y-m-d')}}" name="From" class="form-control">
                    </div>
                    <div class="form-group col-md-3 col-4-print">
                        <label class="form-label" for="simpleinput">{{trans('admin.To')}}</label>
                        <input type="date" id="to" value="{{date('Y-m-d')}}" name="To" class="form-control">
                    </div>
                    <div class="form-group col-md-3 no-print">
                        <label class="form-label" for=""> {{trans('admin.Bond_Type')}} </label>
                        <select class="select2 form-control w-100" id="type" name="Type">
                            <option value=""> {{trans('admin.Bond_Type')}}</option>
                            @foreach($Types as $type)
                            <option value="{{$type->Type}}">
                                {{app()->getLocale() == 'ar' ?$type->Type :$type->TypeEn}}
                            </option>

                            @endforeach

                        </select>
                    </div>

                    <div class="buttons m-2">
                        <button type="submit" class="btn btn-primary"><i class="fal fa-search"></i></button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="row hide-table">
        <div class="col-xl-12">
            <div id="panel-1" class="panel">
                <div class="panel-hdr">
                    <h2>
                        {{trans('admin.Journalizing_Sechdule')}}
                    </h2>

                    <div class="panel-toolbar">
                        <a href="{{'ExportAllJournalizing'}}" class="btn btn-success btn-sm">
                            Export Excel
                        </a>

                        <button class="btn btn-primary btn-sm" data-toggle="dropdown">Table Style</button>

                        @include('admin.layouts.toolbar')

                    </div>

                </div>
                <div class="panel-container show">
                    <span id="ex"> @include('admin.layouts.messages')</span>
                    <div class="panel-content">

                        <!-- datatable start -->
                        <div style="overflow:auto;">
                            <table id="dt-basic-example" class="table table-bordered table-hover table-striped " style="width:100%;">

                                <thead class="bg-highlight">
                                    <tr>
                                        <th>{{trans('admin.Date')}}</th>
                                        <th>{{trans('admin.Code')}}</th>
                                        <th> {{trans('admin.Bond_Type')}} </th>
                                        <th>{{trans('admin.Details')}}</th>
                                        <th>{{trans('admin.Data')}}</th>
                                        <th>{{trans('admin.Actions')}} </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($items as $item)
                                    <tr @if($item->Edit == 1) class="edited" @elseif($item->Delete == 1) class="deleted" @elseif($item->Transfer == 1) class="transfered" @endif>
                                        <td>{{$item->Date}}</td>
                                        <td>{{$item->Code}}</td>
                                        <td>
                                            {{app()->getLocale() == 'ar' ?$item->Type :$item->TypeEn}}
                                            ({{$item->Code_Type}})
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center-open{{$item->id}}" onclick="Sum({{$item->id}})">
                                                {{trans('admin.Details')}}
                                            </button>
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#show-data{{$item->id}}">
                                                {{trans('admin.Data')}}
                                            </button>
                                        </td>
                                        <td class="text-center">

                                            <a href="{{url('JournalizingPrint/'.$item->id)}}" class="btn btn-default">
                                                {{trans('admin.Print')}}
                                            </a>

                                            @if($item->Edit == 0 and $item->Delete == 0)

                                            @if($item->Type == 'القيود اليومية')



                                            @if($DefAcc->Sure_Recipts == 1)

                                            @if($item->Status == 0)

                                            @can('تعديل القيود اليوميه')
                                            <a href="{{url('EditJournalizing/'.$item->id)}}" class="btn btn-default"><i class="fal fa-edit"></i></a>
                                            @endcan


                                            @can('حذف القيود اليوميه')
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>
                                            @endcan


                                            @can('تأكيد قيد يومي')
                                            <a href="{{url('SureJournalizing/'.$item->id)}}" class="btn btn-default"><i class="fal fa-check"></i></a>
                                            @endcan

                                            @endif

                                            @else


                                            @can('تعديل القيود اليوميه')
                                            <a href="{{url('EditJournalizing/'.$item->id)}}" class="btn btn-default"><i class="fal fa-edit"></i></a>
                                            @endcan


                                            @can('حذف القيود اليوميه')
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>
                                            @endcan



                                            @endif




                                            @endif
                                            @endif

                                            @if($item->Edit == 1)
                                            <span class="btn btn-warning">{{trans('admin.Edited_to_New_One')}} ({{$item->Edit_New_Code}})</span>
                                            @elseif($item->Delete == 1)

                                            <span class="btn btn-danger">{{trans('admin.Deleted')}}</span>

                                            @elseif($item->Transfer == 1)

                                            <span class="btn btn-primary">{{trans('admin.Transfer_to')}} ({{$item->Edit_New_Code}})</span>
                                            @endif



                                        </td>
                                    </tr>
                                    @endforeach

                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>{{trans('admin.Date')}}</th>
                                        <th>{{trans('admin.Code')}}</th>
                                        <th> {{trans('admin.Bond_Type')}} </th>

                                        <th>{{trans('admin.Details')}}</th>
                                        <th>{{trans('admin.Data')}}</th>
                                        <th>{{trans('admin.Actions')}} </th>
                                    </tr>
                                </tfoot>

                            </table>

                            {{$items->Links()}}
                        </div>
                        <!-- datatable end -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

@foreach($items as $item)
<!-- Modal Delete -->
<div class="modal fade" id="default-example-modal-center{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    {{trans('admin.RUSWDT')}} <strong>{{$item->Code}}</strong>
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>

            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.No')}}</button>
                <a href="{{url('DeleteJournalizing/'.$item->id)}}" class="btn btn-primary">{{trans('admin.Yes')}}</a>
            </div>
        </div>
    </div>
</div>

<!--modal show data-->
<div class="modal fade" id="show-data{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    {{trans('admin.Data')}}
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <div class="modal-body">
                <div style="overflow:auto;">
                    <table id="" class="table table-bordered table-hover table-striped " style="width:100%;">

                        <thead class="bg-highlight">
                            <tr>

                                <th> {{trans('admin.Coin')}}</th>
                                <th>{{trans('admin.Draw')}} </th>
                                <th> {{trans('admin.Cost_Center')}} </th>
                                <th> {{trans('admin.Branch')}} </th>

                            </tr>
                        </thead>
                        <tbody>

                            <tr>

                                <td>
                                    @if(!empty($item->Coin_fk->Arabic_Name))
                                    {{app()->getLocale() == 'ar' ?$item->Coin_fk->Arabic_Name :$item->Coin_fk->English_Name}}
                                    @endif

                                </td>
                                <td>{{$item->Draw}}</td>
                                <td>

                                    @if(!empty($item->Cost_Center()->first()->Arabic_Name))
                                    {{app()->getLocale() == 'ar' ?$item->Cost_Center()->first()->Arabic_Name :$item->Cost_Center()->first()->English_Name}}
                                    @endif
                                </td>
                                <td>
                                    @if(!empty($item->Branch()->first()->Arabic_Name))
                                    {{app()->getLocale() == 'ar' ?$item->Branch()->first()->Arabic_Name :$item->Branch()->first()->English_Name}}
                                    @endif
                                </td>


                            </tr>


                        </tbody>
                        <tfoot>
                            <tr>

                                <th> {{trans('admin.Coin')}}</th>
                                <th>{{trans('admin.Draw')}} </th>
                                <th> {{trans('admin.Cost_Center')}} </th>
                                <th> {{trans('admin.Branch')}} </th>

                            </tr>
                        </tfoot>

                    </table>


                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>

            </div>

        </div>
    </div>

</div>
<!-- Modal Details -->
<div class="modal fade" id="default-example-modal-center-open{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    {{trans('admin.Details')}}
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-row">

                    <div class="form-group col-lg-12">
                        <label class="form-label" for="">{{trans('admin.Notes')}} </label>
                        <input type="text" value="{{$item->Note}}" id="simpleinput" class="form-control" disabled>
                    </div>
                </div>

                @php
                $details=JournalizingDetails::where('Joun_ID',$item->id)->get();
                $count=JournalizingDetails::where('Joun_ID',$item->id)->get()->count();
                @endphp
                <div class="mt-3">
                    <table id="" class="table table-bordered table-hover table-striped w-100">

                        <thead>
                            <tr>
                                <th>{{trans('admin.Debitor')}} </th>
                                <th>{{trans('admin.Creditor')}} </th>
                                <th>{{trans('admin.Account_Code')}} </th>
                                <th>{{trans('admin.Account_Name')}} </th>
                                <th>{{trans('admin.Statement')}} </th>

                            </tr>
                        </thead>
                        <tbody id="">
                            @foreach($details as $detail)
                            <tr>
                                <td class="Deb{{$item->id}}">{{$detail->Debitor}}</td>
                                <td class="Cred{{$item->id}}">{{$detail->Creditor}}</td>
                                <td>

                                    @if(!empty($detail->Account()->first()->Code))
                                    {{$detail->Account()->first()->Code}}
                                    @endif

                                </td>
                                <td>
                                    @if(!empty($detail->Account()->first()->Name))
                                    {{app()->getLocale() == 'ar' ?$detail->Account()->first()->Name :$detail->Account()->first()->NameEn}}
                                    @endif

                                </td>
                                <td>{{$detail->Statement}}</td>
                            </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th>{{trans('admin.Debitor')}} </th>
                                <th>{{trans('admin.Creditor')}} </th>
                                <th>{{trans('admin.Account_Code')}} </th>
                                <th>{{trans('admin.Account_Name')}} </th>
                                <th>{{trans('admin.Statement')}} </th>

                            </tr>
                        </tfoot>
                    </table>
                    <table class="table table-bordered table-hover table-striped w-100 mt-4">
                        <tbody>

                            <tr>
                                <td>{{trans('admin.Numbers')}}</td>
                                <td>{{$count}}</td>
                                <td>{{trans('admin.Total_Debitor')}}</td>
                                <td id="DEB{{$item->id}}"></td>
                                <td>{{trans('admin.Total_Creditor')}}</td>
                                <td id="CRED{{$item->id}}"></td>
                                @if($item->Type == 'القيد الافتتاحي')
                                <td>{{trans('admin.Capital')}}</td>
                                <td>{{$item->Total_Debaitor - $item->Total_Creditor}}</td>
                                @endif
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                    <a class="btn btn-primary" href="#" onclick="window.print()"> <i class="fal fa-print"></i> {{trans('admin.Print')}}</a>
                </div>
            </div>
        </div>
    </div>

</div>
@endforeach



@endsection


@push('js')
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">


<style>
    th {
        width: 135px !important;
    }

</style>

<script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
<script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
<script>
    //_fnFeatureHtmlLength();
    $(document).ready(function() {
        // Setup - add a text input to each footer cell
        $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
        $('#dt-basic-example thead tr:eq(1) th').each(function(i) {
            var title = $(this).text();
            $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + '" />');

            $('input', this).on('keyup change', function() {
                if (table.column(i).search() !== this.value) {
                    table
                        .column(i)
                        .search(this.value)
                        .draw();
                }
            });
        });
        var table = $('#dt-basic-example').DataTable({
            // responsive: true,
            orderCellsTop: true,
            fixedHeader: true,
            lengthChange: true,

            dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

            buttons: [{
                    extend: 'pageLength',
                    className: 'btn-outline-default'
                },
                {
                    extend: 'colvis',
                    text: 'Column Visibility',
                    titleAttr: 'Col visibility',
                    className: 'btn-outline-default'
                },
                {
                    extend: 'pdfHtml5',
                    text: 'PDF',
                    titleAttr: 'Generate PDF',
                    className: 'btn-outline-danger btn-sm mr-1'
                },
                {
                    extend: 'excelHtml5',
                    text: 'Excel',
                    titleAttr: 'Generate Excel',
                    className: 'btn-outline-success btn-sm mr-1'
                },
                {
                    extend: 'csvHtml5',
                    text: 'CSV',
                    titleAttr: 'Generate CSV',
                    className: 'btn-outline-primary btn-sm mr-1'
                },
                {
                    extend: 'copyHtml5',
                    text: 'Copy',
                    titleAttr: 'Copy to clipboard',
                    className: 'btn-outline-primary btn-sm mr-1'
                },
                {
                    extend: 'print',
                    text: 'Print',
                    titleAttr: 'Print Table',
                    className: 'btn-outline-primary btn-sm'
                }
            ],
        });
        $('.js-thead-colors a').on('click', function() {
            var theadColor = $(this).attr("data-bg");
            console.log(theadColor);
            $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
        });

        $('.js-tbody-colors a').on('click', function() {
            var theadColor = $(this).attr("data-bg");
            console.log(theadColor);
            $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
        });

    });

</script>

<script>
    $(document).ready(function() {
        $(function() {
            $('.select2').select2();

            $(".select2-placeholder-multiple").select2({
                placeholder: "Select State"
            });
            $(".js-hide-search").select2({
                minimumResultsForSearch: 1 / 0
            });
            $(".js-max-length").select2({
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items"
            });
            $(".select2-placeholder").select2({
                placeholder: "Select a state",
                allowClear: true
            });

            $(".js-select2-icons").select2({
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function(elm) {
                    return elm
                }
            });

            function icon(elm) {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
            }

            $(".js-data-example-ajax").select2({
                ajax: {
                    url: "https://api.github.com/search/repositories",
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            q: params.term, // search term
                            page: params.page
                        };
                    },
                    processResults: function(data, params) {
                        // parse the results into the format expected by Select2
                        // since we are using custom formatting functions we do not need to
                        // alter the remote JSON data, except to indicate that infinite
                        // scrolling can be used
                        params.page = params.page || 1;

                        return {
                            results: data.items,
                            pagination: {
                                more: (params.page * 30) < data.total_count
                            }
                        };
                    },
                    cache: true
                },
                placeholder: 'Search for a repository',
                escapeMarkup: function(markup) {
                    return markup;
                }, // let our custom formatter work
                minimumInputLength: 1,
                templateResult: formatRepo,
                templateSelection: formatRepoSelection
            });

            function formatRepo(repo) {
                if (repo.loading) {
                    return repo.text;
                }

                var markup = "<div class='select2-result-repository clearfix d-flex'>" +
                    "<div class='select2-result-repository__avatar mr-2'><img src='" + repo.owner.avatar_url + "' class='width-2 height-2 mt-1 rounded' /></div>" +
                    "<div class='select2-result-repository__meta'>" +
                    "<div class='select2-result-repository__title fs-lg fw-500'>" + repo.full_name + "</div>";

                if (repo.description) {
                    markup += "<div class='select2-result-repository__description fs-xs opacity-80 mb-1'>" + repo.description + "</div>";
                }

                markup += "<div class='select2-result-repository__statistics d-flex fs-sm'>" +
                    "<div class='select2-result-repository__forks mr-2'><i class='fal fa-lightbulb'></i> " + repo.forks_count + " Forks</div>" +
                    "<div class='select2-result-repository__stargazers mr-2'><i class='fal fa-star'></i> " + repo.stargazers_count + " Stars</div>" +
                    "<div class='select2-result-repository__watchers mr-2'><i class='fal fa-eye'></i> " + repo.watchers_count + " Watchers</div>" +
                    "</div>" +
                    "</div></div>";

                return markup;
            }

            function formatRepoSelection(repo) {
                return repo.full_name || repo.text;
            }
        });
    });

</script>
<script>
    var autoSave = $('#autoSave');
    var interval;
    var timer = function() {
        interval = setInterval(function() {
            //start slide...
            if (autoSave.prop('checked'))
                saveToLocal();

            clearInterval(interval);
        }, 3000);
    };

    //save
    var saveToLocal = function() {
        localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
        console.log("saved");
    }

    //delete 
    var removeFromLocal = function() {
        localStorage.removeItem("summernoteData");
        $('#saveToLocal').summernote('reset');
    }

    $(document).ready(function() {
        //init default
        $('.js-summernote').summernote({
            height: 200,
            tabsize: 2,
            placeholder: "Type here...",
            dialogsFade: true,
            toolbar: [
                ['style', ['style']],
                ['font', ['strikethrough', 'superscript', 'subscript']],
                ['font', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['height', ['height']]
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ],
            callbacks: {
                //restore from localStorage
                onInit: function(e) {
                    $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                },
                onChange: function(contents, $editable) {
                    clearInterval(interval);
                    timer();
                }
            }
        });

        //load emojis
        $.ajax({
            url: 'https://api.github.com/emojis',
            async: false
        }).then(function(data) {
            window.emojis = Object.keys(data);
            window.emojiUrls = data;
        });

        //init emoji example
        $(".js-hint2emoji").summernote({
            height: 100,
            toolbar: false,
            placeholder: 'type starting with : and any alphabet',
            hint: {
                match: /:([\-+\w]+)$/,
                search: function(keyword, callback) {
                    callback($.grep(emojis, function(item) {
                        return item.indexOf(keyword) === 0;
                    }));
                },
                template: function(item) {
                    var content = emojiUrls[item];
                    return '<img src="' + content + '" width="20" /> :' + item + ':';
                },
                content: function(item) {
                    var url = emojiUrls[item];
                    if (url) {
                        return $('<img />').attr('src', url).css('width', 20)[0];
                    }
                    return '';
                }
            }
        });

        //init mentions example
        $(".js-hint2mention").summernote({
            height: 100,
            toolbar: false,
            placeholder: "type starting with @",
            hint: {
                mentions: ['jayden', 'sam', 'alvin', 'david'],
                match: /\B@(\w*)$/,
                search: function(keyword, callback) {
                    callback($.grep(this.mentions, function(item) {
                        return item.indexOf(keyword) == 0;
                    }));
                },
                content: function(item) {
                    return '@' + item;
                }
            }
        });

    });

</script>
<script type="text/javascript">
    $(".show-table").click(function() {
        $(".hide-table").show();
    });

</script>

<!--  Sum Deb and Cred -->
<script>
    function Sum(r) {
        var Deb = 0;
        $('.Deb' + r).each(function() {
            Deb += parseFloat($(this).text());
        });

        var Cred = 0;
        $('.Cred' + r).each(function() {
            Cred += parseFloat($(this).text());
        });

        $('#DEB' + r).text(Deb);
        $('#CRED' + r).text(Cred);
    }

</script>
<script>
    function SumP(r) {
        var Deb = 0;
        $('.DebP' + r).each(function() {
            Deb += parseFloat($(this).text());
        });

        var Cred = 0;
        $('.CredP' + r).each(function() {
            Cred += parseFloat($(this).text());
        });

        $('#DEBP' + r).text(Deb);
        $('#CREDP' + r).text(Cred);
    }

</script>



@endpush
