@extends('admin.index')
@section('content')
    @php
        use App\Models\AccountsDefaultData;use App\Models\PayProfitInvestors;use App\Models\UpdateValuesInvestors;
        $Def=AccountsDefaultData::orderBy('id','desc')->first();
    @endphp
    <title>{{trans('admin.Investors')}}</title>

    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Accounts')}}</a></li>
            <li class="breadcrumb-item active"> {{trans('admin.Investors')}}</li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
        </ol>

        <div class="row">
            <div class="col-xl-12">
                <div id="panel-1" class="panel">
                    <div class="panel-hdr">
                        <h2>
                            {{trans('admin.Investors')}}
                        </h2>

                        <div class="panel-toolbar">


                            <button type="button" class="btn btn-default btn-sm margin-btn" data-toggle="modal"
                                    data-target="#default-example-modal-center-add">
                                {{trans('admin.AddNew')}}</button>


                            <button class="btn btn-primary btn-sm" data-toggle="dropdown">Table
                                Style
                            </button>
                            @include('admin.layouts.toolbar')
                        </div>

                    </div>
                    <div class="panel-container show">
                        <span id="ex"> @include('admin.layouts.messages')</span>
                        <div class="panel-content">

                            <!-- datatable start -->
                            <div id="mobile-overflow">
                                <table id="dt-basic-example"
                                       class="table table-bordered table-hover table-striped w-100 mobile-width">
                                    <thead class="bg-highlight">
                                    <tr>
                                        <th>{{trans('admin.Date')}}</th>
                                        <th>{{trans('admin.Name')}}</th>
                                        <th>{{trans('admin.Investment_Value')}}</th>
                                        <th> {{trans('admin.Profit_Precent')}}</th>
                                        <th> {{trans('admin.Investment_Period')}}</th>
                                        <th> {{trans('admin.Liquidation_Time')}}</th>
                                        <th> {{trans('admin.Account_Code')}}</th>
                                        <th> {{trans('admin.Paid_Profits')}}</th>
                                        <th> {{trans('admin.More_Investment')}}</th>
                                        <th> {{trans('admin.Data')}}</th>
                                        <th> {{trans('admin.Actions')}}</th>

                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($items as $item)
                                        <tr>
                                            <td>{{$item->Date}}</td>
                                            <td>{{$item->Name}}</td>
                                            <td>{{$item->Investment_Value}}</td>
                                            <td>{{$item->Profit_Precent}}</td>
                                            <td>{{$item->Investment_Period}}</td>
                                            <td>{{$item->Liquidation_Time}}</td>
                                            <td>
                                                @if(!empty($item->Account()->first()->Code))
                                                    {{app()->getLocale() == 'ar' ?$item->Account()->first()->Code :$item->Account()->first()->Code}}

                                                @endif
                                            </td>


                                            <td>
                                                <button type="button" class="btn btn-primary" data-toggle="modal"
                                                        data-target="#Paid{{$item->id}}">
                                                    {{trans('admin.Paid_Profits')}}
                                                </button>
                                            </td>
                                            <td>
                                                <button type="button" class="btn btn-primary" data-toggle="modal"
                                                        data-target="#More{{$item->id}}">
                                                    {{trans('admin.More_Investment')}}
                                                </button>
                                            </td>
                                            <td>
                                                <button type="button" class="btn btn-primary" data-toggle="modal"
                                                        data-target="#show-data{{$item->id}}">
                                                    {{trans('admin.Data')}}
                                                </button>
                                            </td>

                                            <td>


                                                @if($item->Status == 0)

                                                    <button type="button" class="btn btn-default" data-toggle="modal"
                                                            data-target="#Delete{{$item->id}}">
                                                        <i class="fal fa-trash"></i>
                                                    </button>

                                                    <button type="button" class="btn btn-default" data-toggle="modal"
                                                            data-target="#End{{$item->id}}">
                                                        <i class="fal fa-times"></i>
                                                    </button>


                                                    <button type="button" class="btn btn-default" data-toggle="modal"
                                                            data-target="#plus{{$item->id}}">
                                                        <i class="fal fa-plus"></i>
                                                    </button>

                                                @else

                                                    <span
                                                        class="btn btn-danger">{{trans('admin.Ended')}} => {{$item->End_Date}}</span>

                                                @endif


                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                    <tfoot>
                                    <tr>
                                        <th>{{trans('admin.Date')}}</th>
                                        <th>{{trans('admin.Name')}}</th>
                                        <th>{{trans('admin.Investment_Value')}}</th>
                                        <th> {{trans('admin.Profit_Precent')}}</th>
                                        <th> {{trans('admin.Investment_Period')}}</th>
                                        <th> {{trans('admin.Liquidation_Time')}}</th>
                                        <th> {{trans('admin.Account_Code')}}</th>
                                        <th> {{trans('admin.More_Investment')}}</th>
                                        <th> {{trans('admin.Data')}}</th>
                                        <th> {{trans('admin.Actions')}}</th>
                                    </tr>
                                    </tfoot>
                                </table>
                            </div>
                            {{$items->Links()}}
                            <!-- datatable end -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>


    <!-- Modal Add -->
    <div class="modal fade" id="default-example-modal-center-add" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        {{trans('admin.AddNew')}}
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <form action="{{url('AddInvestors')}}" method="post" enctype="multipart/form-data">
                    {!! csrf_field() !!}
                    @honeypot
                    <div class="modal-body">

                        <div class="row">

                            <div class="form-group col-lg-4">
                                <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                                <input type="date" name="Date" value="{{old('Date')}}" class="form-control" required>
                            </div>
                            <div class="form-group col-lg-4">
                                <label class="form-label" for="simpleinput">{{trans('admin.Name')}}</label>
                                <input type="text" name="Name" value="{{old('Name')}}" class="form-control" required>
                            </div>
                            <div class="form-group col-lg-4">
                                <label class="form-label" for="simpleinput">{{trans('admin.Investment_Value')}}</label>
                                <input type="number" step="any" name="Investment_Value"
                                       value="{{old('Investment_Value')}}" class="form-control" required>
                            </div>
                            <div class="form-group col-lg-4">
                                <label class="form-label" for="simpleinput">{{trans('admin.Profit_Precent')}}</label>
                                <input type="number" step="any" name="Profit_Precent" value="{{old('Profit_Precent')}}"
                                       class="form-control" required>
                            </div>


                            <div class="form-group col-lg-4">
                                <label class="form-label" for="">{{trans('admin.Coin')}}</label>
                                <select class="select2 form-control w-100" name="Coin" required>
                                    <option value=""> {{trans('admin.Coin')}}</option>
                                    @foreach($Coins as $coin)
                                        <option value="{{$coin->id}}" @if($coin->id == $Def->Coin) selected @endif>

                                            {{app()->getLocale() == 'ar' ?$coin->Arabic_Name :$coin->English_Name}}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group col-lg-4">
                                <label class="form-label" for="simpleinput">{{trans('admin.Draw')}}</label>
                                <input type="text" name="Draw" value="1" class="form-control" required>
                            </div>


                            <div class="form-group col-lg-4">
                                <label class="form-label" for="">{{trans('admin.Safe')}}</label>
                                <select class="select2 form-control w-100" name="Safe" required>
                                    <option value=""> {{trans('admin.Safe')}}</option>
                                    @foreach($Safes as $safe)
                                        <option value="{{$safe->id}}">

                                            {{app()->getLocale() == 'ar' ?$safe->Name :$safe->NameEn}}
                                        </option>
                                    @endforeach
                                </select>
                            </div>


                            <div class="form-group col-lg-4">
                                <label class="form-label" for="simpleinput">{{trans('admin.Investment_Period')}}</label>
                                <input type="text" name="Investment_Period" value="{{old('Investment_Period')}}"
                                       class="form-control">
                            </div>

                            <div class="form-group col-lg-4">
                                <label class="form-label" for="simpleinput">{{trans('admin.Liquidation_Time')}}</label>
                                <input type="text" name="Liquidation_Time" value="{{old('Liquidation_Time')}}"
                                       class="form-control">
                            </div>


                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                                data-dismiss="modal">{{trans('admin.Close')}}</button>
                        <button type="submit" class="btn btn-primary">{{trans('admin.Save')}}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    @foreach($items as $item)

        <!-- Modal Delete -->
        <div class="modal fade" id="Delete{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered " role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">
                            {{trans('admin.Delete')}}
                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>
                    <div class="modal-body">
                        {{trans('admin.RUSWDT')}} <strong>{{$item->Name}}</strong>
                    </div>
                    <div class="modal-footer">

                        <button type="button" class="btn btn-secondary"
                                data-dismiss="modal"> {{trans('admin.No')}}</button>
                        <a href="{{url('DeleteInvestors/'.$item->id)}}"
                           class="btn btn-primary"> {{trans('admin.Yes')}}</a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal End -->
        <div class="modal fade" id="End{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered " role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">
                            {{trans('admin.End')}}
                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>
                    <div class="modal-body">
                        {{trans('admin.RUSWTEnd')}}
                    </div>
                    <div class="modal-footer">

                        <button type="button" class="btn btn-secondary"
                                data-dismiss="modal"> {{trans('admin.No')}}</button>
                        <a href="{{url('EndInvestors/'.$item->id)}}" class="btn btn-primary"> {{trans('admin.Yes')}}</a>
                    </div>
                </div>
            </div>
        </div>

        <!--modal More Investment-->
        <div class="modal fade" id="More{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">
                            {{trans('admin.More_Investment')}}
                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div style="overflow:auto">
                            <table id="" class="table table-bordered table-hover table-striped">
                                <thead class="bg-highlight">
                                <tr>
                                    <th> {{trans('admin.Date')}}</th>
                                    <th> {{trans('admin.Value')}}</th>

                                </tr>
                                </thead>
                                <tbody>
                                @php  $details=UpdateValuesInvestors::where('Investor',$item->id)->get(); @endphp
                                @foreach($details as $det)
                                    <tr>


                                        <td>{{$det->Date}}</td>
                                        <td>{{$det->Valye}}</td>


                                    </tr>
                                @endforeach
                                </tbody>

                            </table>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                                data-dismiss="modal"> {{trans('admin.Close')}}</button>
                    </div>

                </div>
            </div>
        </div>

        <!--modal Paid Profits-->
        <div class="modal fade" id="Paid{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">
                            {{trans('admin.Paid_Profits')}}
                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div style="overflow:auto">
                            <table id="" class="table table-bordered table-hover table-striped">
                                <thead class="bg-highlight">
                                <tr>
                                    <th> {{trans('admin.Date')}}</th>
                                    <th> {{trans('admin.Profit')}}</th>

                                </tr>
                                </thead>
                                <tbody>
                                @php  $details=PayProfitInvestors::where('Investor',$item->id)->get(); @endphp
                                @foreach($details as $det)
                                    <tr>


                                        <td>{{$det->Date}}</td>
                                        <td>{{$det->Profit}}</td>


                                    </tr>
                                @endforeach
                                </tbody>

                            </table>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                                data-dismiss="modal"> {{trans('admin.Close')}}</button>
                    </div>

                </div>
            </div>
        </div>
        <!--modal show data-->
        <div class="modal fade" id="show-data{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">
                            {{trans('admin.Data')}}
                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div style="overflow:auto">
                            <table id="" class="table table-bordered table-hover table-striped">
                                <thead class="bg-highlight">
                                <tr>
                                    <th> {{trans('admin.Draw')}}</th>
                                    <th> {{trans('admin.Coin')}}</th>
                                    <th> {{trans('admin.Safe')}}</th>
                                    <th> {{trans('admin.Due_Account')}}</th>
                                    <th> {{trans('admin.Expenses_Account')}}</th>
                                </tr>
                                </thead>
                                <tbody>

                                <tr>


                                    <td>{{$item->Draw}}</td>
                                    <td>{{$item->Coin()->first()->Arabic_Name}}</td>


                                    <td>
                                        @if(!empty($item->Safe()->first()->Name))
                                            {{app()->getLocale() == 'ar' ?$item->Safe()->first()->Name :$item->Safe()->first()->NameEn}}

                                        @endif
                                    </td>


                                    <td>
                                        @if(!empty($item->Due_Account()->first()->Code))
                                            {{app()->getLocale() == 'ar' ?$item->Due_Account()->first()->Code :$item->Due_Account()->first()->Code}}

                                        @endif
                                    </td>


                                    <td>
                                        @if(!empty($item->Expenses_Account()->first()->Code))
                                            {{app()->getLocale() == 'ar' ?$item->Expenses_Account()->first()->Code :$item->Expenses_Account()->first()->Code}}

                                        @endif
                                    </td>


                                </tr>

                                </tbody>

                            </table>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                                data-dismiss="modal"> {{trans('admin.Close')}}</button>
                    </div>

                </div>
            </div>
        </div>


        <!-- Modal plus -->
        <div class="modal fade" id="plus{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">
                            {{trans('admin.Asset_Sale')}}
                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>
                    <form action="{{url('MoreValueInvestors/'.$item->id)}}" method="post">
                        {!! csrf_field() !!}
                        <div class="modal-body">
                            <div class="row">
                                <div class="form-group col-lg-3">
                                    <label class="form-label"
                                           for="simpleinput">{{trans('admin.Date')}}</label>
                                    <input type="date" name="Date" class="form-control" required>
                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Value')}}</label>
                                    <input type="number" step="any" name="Value" class="form-control" required>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">

                            <button type="button" class="btn btn-secondary"
                                    data-dismiss="modal"> {{trans('admin.Close')}}</button>
                            <button type="submit" class="btn btn-primary"> {{trans('admin.Update')}}</button>

                        </div>
                    </form>
                </div>
            </div>
        </div>

    @endforeach

@endsection

@push('js')
    <link rel="stylesheet" media="screen, print"
          href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">

    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable({
                // responsive: true,
                orderCellsTop: true,
                fixedHeader: true,
                lengthChange: true,

                dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                    "<'row'<'col-sm-12'tr>>" +
                    "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                buttons: [{
                    extend: 'pageLength',
                    className: 'btn-outline-default'
                },
                    {
                        extend: 'colvis',
                        text: 'Column Visibility',
                        titleAttr: 'Col visibility',
                        className: 'btn-outline-default'
                    },
                    {
                        extend: 'pdfHtml5',
                        text: 'PDF',
                        titleAttr: 'Generate PDF',
                        className: 'btn-outline-danger btn-sm mr-1'
                    },
                    {
                        extend: 'excelHtml5',
                        text: 'Excel',
                        titleAttr: 'Generate Excel',
                        className: 'btn-outline-success btn-sm mr-1'
                    },
                    {
                        extend: 'csvHtml5',
                        text: 'CSV',
                        titleAttr: 'Generate CSV',
                        className: 'btn-outline-primary btn-sm mr-1'
                    },
                    {
                        extend: 'copyHtml5',
                        text: 'Copy',
                        titleAttr: 'Copy to clipboard',
                        className: 'btn-outline-primary btn-sm mr-1'
                    },
                    {
                        extend: 'print',
                        text: 'Print',
                        titleAttr: 'Print Table',
                        className: 'btn-outline-primary btn-sm'
                    }
                ],
            });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>
    <script>
        var autoSave = $('#autoSave');
        var interval;
        var timer = function () {
            interval = setInterval(function () {
                //start slide...
                if (autoSave.prop('checked'))
                    saveToLocal();

                clearInterval(interval);
            }, 3000);
        };

        //save
        var saveToLocal = function () {
            localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
            console.log("saved");
        }

        //delete
        var removeFromLocal = function () {
            localStorage.removeItem("summernoteData");
            $('#saveToLocal').summernote('reset');
        }

        $(document).ready(function () {
            //init default
            $('.js-summernote').summernote({
                height: 200,
                tabsize: 2,
                placeholder: "Type here...",
                dialogsFade: true,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['strikethrough', 'superscript', 'subscript']],
                    ['font', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['fontname', ['fontname']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['height', ['height']]
                        ['table', ['table']],
                    ['insert', ['link', 'picture', 'video']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ],
                callbacks: {
                    //restore from localStorage
                    onInit: function (e) {
                        $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                    },
                    onChange: function (contents, $editable) {
                        clearInterval(interval);
                        timer();
                    }
                }
            });

            //load emojis
            $.ajax({
                url: 'https://api.github.com/emojis',
                async: false
            }).then(function (data) {
                window.emojis = Object.keys(data);
                window.emojiUrls = data;
            });

            //init emoji example
            $(".js-hint2emoji").summernote({
                height: 100,
                toolbar: false,
                placeholder: 'type starting with : and any alphabet',
                hint: {
                    match: /:([\-+\w]+)$/,
                    search: function (keyword, callback) {
                        callback($.grep(emojis, function (item) {
                            return item.indexOf(keyword) === 0;
                        }));
                    },
                    template: function (item) {
                        var content = emojiUrls[item];
                        return '<img src="' + content + '" width="20" /> :' + item + ':';
                    },
                    content: function (item) {
                        var url = emojiUrls[item];
                        if (url) {
                            return $('<img />').attr('src', url).css('width', 20)[0];
                        }
                        return '';
                    }
                }
            });

            //init mentions example
            $(".js-hint2mention").summernote({
                height: 100,
                toolbar: false,
                placeholder: "type starting with @",
                hint: {
                    mentions: ['jayden', 'sam', 'alvin', 'david'],
                    match: /\B@(\w*)$/,
                    search: function (keyword, callback) {
                        callback($.grep(this.mentions, function (item) {
                            return item.indexOf(keyword) == 0;
                        }));
                    },
                    content: function (item) {
                        return '@' + item;
                    }
                }
            });

        });

    </script>


    <!-- Search Selecet -->
    <script>
        $(document).ready(function () {
            $(function () {
                $('.select2').select2();

                $(".select2-placeholder-multiple").select2({
                    placeholder: "Select State"
                });
                $(".js-hide-search").select2({
                    minimumResultsForSearch: 1 / 0
                });
                $(".js-max-length").select2({
                    maximumSelectionLength: 2,
                    placeholder: "Select maximum 2 items"
                });
                $(".select2-placeholder").select2({
                    placeholder: "Select a state",
                    allowClear: true
                });

                $(".js-select2-icons").select2({
                    minimumResultsForSearch: 1 / 0,
                    templateResult: icon,
                    templateSelection: icon,
                    escapeMarkup: function (elm) {
                        return elm
                    }
                });

                function icon(elm) {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
                }


                $('#Main_Account').select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: 'json',
                        url: 'AllMainAssetsAccounts',
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {
                                    return {
                                        id: index,
                                        text: obj
                                    };
                                })
                            };

                            console.log(data);

                        },
                        data: function (params) {


                            var query = {
                                search: params.term,
                            };


                            $.ajax({
                                url: 'AllMainAssetsAccountsJ/' + params.term,
                                type: "GET",
                                dataType: "json",
                                beforeSend: function () {
                                    $('#loader').css("visibility", "visible");
                                },

                                success: function (data) {
                                    $('#Main_Account').empty();
                                    $.each(data, function (key, value) {

                                        $('#Main_Account').append('<option value="' + key + '">' + value + '</option>');

                                    });
                                },
                                complete: function () {
                                    $('#loader').css("visibility", "hidden");
                                }
                            });


                        }
                    }
                });


                $('#Main_Account').on('select2:select', function (e) {
                    console.log("select done", e.params.data);
                });


                $('#Main_New_Account').select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: 'json',
                        url: 'AllMainAssetsAccounts',
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {
                                    return {
                                        id: index,
                                        text: obj
                                    };
                                })
                            };

                            console.log(data);

                        },
                        data: function (params) {


                            var query = {
                                search: params.term,
                            };


                            $.ajax({
                                url: 'AllMainAssetsAccountsJ/' + params.term,
                                type: "GET",
                                dataType: "json",
                                beforeSend: function () {
                                    $('#loader').css("visibility", "visible");
                                },

                                success: function (data) {
                                    $('#Main_Account').empty();
                                    $.each(data, function (key, value) {

                                        $('#Main_Account').append('<option value="' + key + '">' + value + '</option>');

                                    });
                                },
                                complete: function () {
                                    $('#loader').css("visibility", "hidden");
                                }
                            });


                        }
                    }
                });


                $('#Main_New_Account').on('select2:select', function (e) {
                    console.log("select done", e.params.data);
                });


                $('.AccEx').select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: 'json',
                        url: 'AllAccountsExpenses',
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {
                                    return {
                                        id: index,
                                        text: obj
                                    };
                                })
                            };

                            console.log(data);

                        },
                        data: function (params) {


                            var query = {
                                search: params.term,
                            };


                            $.ajax({
                                url: 'AllAccountsExpensesJ/' + params.term,
                                type: "GET",
                                dataType: "json",
                                beforeSend: function () {
                                    $('#loader').css("visibility", "visible");
                                },

                                success: function (data) {
                                    $('.AccEx').empty();
                                    $.each(data, function (key, value) {

                                        $('.AccEx').append('<option value="' + key + '">' + value + '</option>');

                                    });
                                },
                                complete: function () {
                                    $('#loader').css("visibility", "hidden");
                                }
                            });


                        }
                    }
                });


                $('.AccEx').on('select2:select', function (e) {
                    console.log("select done", e.params.data);
                });


                $('.AccCom').select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: 'json',
                        url: 'AllAccountsComplex',
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {
                                    return {
                                        id: index,
                                        text: obj
                                    };
                                })
                            };

                            console.log(data);

                        },
                        data: function (params) {


                            var query = {
                                search: params.term,
                            };


                            $.ajax({
                                url: 'AllAccountsComplexJ/' + params.term,
                                type: "GET",
                                dataType: "json",
                                beforeSend: function () {
                                    $('#loader').css("visibility", "visible");
                                },

                                success: function (data) {
                                    $('.AccCom').empty();
                                    $.each(data, function (key, value) {

                                        $('.AccCom').append('<option value="' + key + '">' + value + '</option>');

                                    });
                                },
                                complete: function () {
                                    $('#loader').css("visibility", "hidden");
                                }
                            });


                        }
                    }
                });


                $('.AccCom').on('select2:select', function (e) {
                    console.log("select done", e.params.data);
                });


                $("#vendor").select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "AllVendors",
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {

                                    return {
                                        id: index,
                                        text: obj
                                    };
                                }),
                            };

                            console.log(data);
                        },
                        data: function (params) {


                            var query = {
                                search: params.term,
                            };


                            $.ajax({
                                url: 'AllVendorsJ/' + params.term,
                                type: "GET",
                                dataType: "json",
                                beforeSend: function () {
                                    $('#loader').css("visibility", "visible");
                                },

                                success: function (data) {
                                    $('#vendor').empty();
                                    $.each(data, function (key, value) {

                                        $('#vendor').append('<option value="' + key + '">' + value + '</option>');

                                    });
                                },
                                complete: function () {
                                    $('#loader').css("visibility", "hidden");
                                }
                            });


                        }
                    },
                });

                $("#vendor").on("select2:select", function (e) {
                    console.log("select done", e.params.data);
                });

                $(".client").select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "AllClientsFilter",
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (obj, index) {

                                    return {
                                        id: index,
                                        text: obj
                                    };
                                }),
                            };

                            console.log(data);
                        },
                        data: function (params) {


                            var query = {
                                search: params.term,
                            };


                            $.ajax({
                                url: 'AllClientsFilterJ/' + params.term,
                                type: "GET",
                                dataType: "json",
                                beforeSend: function () {
                                    $('#loader').css("visibility", "visible");
                                },

                                success: function (data) {
                                    $('.client').empty();
                                    $.each(data, function (key, value) {

                                        $('.client').append('<option value="' + key + '">' + value + '</option>');

                                    });
                                },
                                complete: function () {
                                    $('#loader').css("visibility", "hidden");
                                }
                            });


                        }
                    },
                });

                $(".client").on("select2:select", function (e) {
                    console.log("select done", e.params.data);
                });


            });
        });

    </script>

@endpush
