@extends('admin.index')
@section('content')
@php
use App\Models\AcccountingManual;
@endphp
<title>{{trans('admin.Accounting_Manual')}}</title>


<main id="js-page-content" role="main" class="page-content">
    <ol class="breadcrumb page-breadcrumb no-print">
        <li class="breadcrumb-item"><a href="index.html">{{trans('admin.Accounts')}}</a></li>
        <li class="breadcrumb-item active">{{trans('admin.Accounting_Manual')}}</li>
        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
    </ol>


    @include('admin.layouts.PrintHeader')




    <div class="row">
        <div class="col-lg-12">
            <div id="panel-2" class="panel">
                <div class="panel-hdr no-print">
                    <h2>
                        <span class="fw-300"><i>{{trans('admin.AddNew')}}</i></span>
                    </h2>
                </div>
                <div class="panel-container show">
                    <div class="panel-content">

                        @can('اضافه حساب في الدليل المحاسبي')
                        <form class="form-row" action="{{url('AddAccount')}}" method="post">
                            {!! csrf_field() !!}
                            @honeypot
                            <div class="form-group col-md-2 col-2-print">
                                <label class="form-label" for="simpleinput">{{trans('admin.Arabic_Name')}}</label>
                                <input type="text" name="Name" value="{{old('Name')}}" id="simpleinput" class="form-control" required>
                            </div>
                            <div class="form-group col-md-2 col-2-print">
                                <label class="form-label" for="simpleinput">{{trans('admin.English_Name')}}</label>
                                <input type="text" name="NameEn" value="{{old('NameEn')}}" id="simpleinput" class="form-control">
                            </div>


                            <div class="form-group col-md-2 col-2-print">
                                <label class="form-label" for=""> {{trans('admin.Account_Type')}}</label>
                                <select class="select2 form-control w-100" name="Type" required>
                                    <option value="0">{{trans('admin.Main')}}</option>
                                    <option value="1">{{trans('admin.Sub')}}</option>
                                </select>
                            </div>

                            <div class="form-group col-md-2 col-2-print">
                                <label class="form-label" for=""> {{trans('admin.Main_Account')}} </label>
                                <select id="account" class="select2 form-control w-100" name="Parent">


                                </select>
                            </div>
                            <div class="form-group col-md-2 col-2-print">
                                <label class="form-label" for="simpleinput">{{trans('admin.Code')}} </label>
                                <input type="text" name="Account_Code" value="{{old('Account_Code')}}" id="simpleinput" class="form-control">
                            </div>

                            <div class="form-group col-md-2 col-2-print">
                                <label class="form-label" for="simpleinput">{{trans('admin.Notes')}}</label>
                                <input type="text" name="Note" id="simpleinput" class="form-control" value="{{old('Note')}}">
                            </div>

                            @if($Def->Show_Group == 1)
                            <div class="form-group col-md-2 col-2-print">
                                <label class="form-label" for="simpleinput">{{trans('admin.Group')}}</label>
                                <select class="select2 form-control" name="Pro_Group">
                                    <option value="">{{trans('admin.Group')}}</option>
                                    @foreach($Groups as $grop)

                                    <option value="{{$grop->id}}">{{$grop->Name}}</option>
                                    @endforeach
                                </select>
                            </div>
                            @endif

                            <div class="form-group col-md-2 buttons mt-2 pt-3 no-print">
                                <button type="submit" class="btn btn-primary"> <i class="fal fa-folder"></i> {{trans('admin.Save')}}</button>
                            </div>
                        </form>
                        @endcan



                              @can('حذف حساب في الدليل المحاسبي')
                            <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#Delete"><i class="fal fa-trash-alt"></i>{{trans('admin.Delete')}}</button>
                        @endcan


                    @can('تعديل حساب في الدليل المحاسبي')
                            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#Edit"><i class="fal fa-edit"></i>{{trans('admin.Edit')}}</button>
                        @endcan
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="row">
        <div class="col-lg-12">
            <div id="panel-1" class="panel">
                <div class="panel-hdr">
                    <h2>
                        <span class="fw-300"><i>{{trans('admin.Accounting_Manual')}}</i></span>
                        <span class="fw-300" style="color: darkred"><i>({{trans('admin.AlertAccounting')}})</i></span>
                    </h2>

                </div>
                <div class="panel-container show">
                    <span id="ex"> @include('admin.layouts.messages')</span>


                    <div class="panel-content">
                        <div class="tree">
                            <ul>
                                @foreach($parents as $par)
                                    <li>
                                        <span onclick="SupGroups({{$par->id}})"><i class="fal fa-folder"></i> {{$par->Code}} - {{app()->getLocale() == 'ar' ?$par->Name :$par->NameEn}} </span>




                                        <ul class="Data{{$par->id}}">




                                        </ul>



                                    </li>



                                @endforeach

                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>



    <!-- Modal Delete -->
    <div class="modal fade" id="Delete" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">

                        {{trans('admin.Delete')}}
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>

                <form action="{{url('DeleteAccount')}}" method="get">
                    <div class="modal-body">


                        <div class="form-group col-md-12">
                            <label class="form-label" for=""> {{trans('admin.Account')}} </label>
                            <select  class="select2 form-control w-100"  name="Parent" required>
                                <option value="">{{trans('admin.Account')}}</option>
                                @foreach($parentss as $par)
                                    <option value="{{$par->id}}">

                                        {{app()->getLocale() == 'ar' ?$par->Name :$par->NameEn}}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                        <button type="submit" class="btn btn-secondary">{{trans('admin.Delete')}}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>




    <!-- Modal Edit-->
    <div class="modal fade" id="Edit" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{trans('admin.Edit')}}  </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="{{url('EditAccount')}}" method="post" enctype="multipart/form-data">
                        {!! csrf_field() !!}


                        <div class="form-group col-md-12">
                            <label class="form-label" for=""> {{trans('admin.Account')}} </label>
                            <select  class="select2 form-control w-100" id="ID"  name="ID" onchange="ChangeEditGroup()" required>
                                <option value="">{{trans('admin.Account')}}</option>
                                @foreach($parentss as $par)
                                    <option value="{{$par->id}}">

                                        {{app()->getLocale() == 'ar' ?$par->Name :$par->NameEn}}
                                    </option>
                                @endforeach
                            </select>
                        </div>


                        <div class="form-row">
                            <div class="form-group col-lg-6">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Arabic_Name')}} </label>
                                <input type="text" id="Name" name="Name"   class="form-control" required>
                            </div>

                            <div class="form-group col-lg-6">
                                <label class="form-label" for="simpleinput"> {{trans('admin.English_Name')}} </label>
                                <input type="text"  id="NameEn" name="NameEn"   class="form-control" required>
                            </div>

                            <div class="form-group col-lg-12">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Code')}} </label>
                                <input type="text" name="Account_Code" id="Account_Code"  class="form-control" required>
                            </div>


                            <div class="form-group col-md-3">
                                <label class="form-label" for="simpleinput">{{trans('admin.Notes')}}</label>
                                <input type="text" name="Note" id="Note" class="form-control" >
                            </div>


                            <input type="text"  id="Pro_Group" class="form-control"  readonly>
                            @if($Def->Show_Group == 1)
                                <div class="form-group col-md-12 col-12-print">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Group')}}</label>
                                    <select class="select2 form-control" name="Pro_Group">
                                        <option value="">{{trans('admin.Group')}}</option>
                                        @foreach($Groups as $grop)

                                            <option value="{{$grop->id}}">{{$grop->Name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            @endif


                            <input type="text"  id="Parent" name="OldParent" class="form-control"  readonly>
                            <div class="form-group col-md-12">
                                <label class="form-label" for=""> {{trans('admin.Main_Account')}} </label>
                                <select  class="select2 form-control w-100 account"  name="Parent">
                                    <option value="">{{trans('admin.Main_Account')}}</option>

                                </select>
                            </div>



                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}} </button>
                            <button type="submit" class="btn btn-primary">{{trans('admin.SaveChanges')}} </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>



</main>


@endsection


@push('js')
<!-- DEMO related CSS below -->
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/fa-brands.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/miscellaneous/treeview/treeview.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">


<script src="{{asset('Admin/js/miscellaneous/treeview/treeview.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
<script>
    document.addEventListener("DOMContentLoaded", function() {
        // Handler when the DOM is fully loaded
    });
</script>
<!-- Search Selecet -->
<script>
    $(document).ready(function() {
        $(function() {
            $('.select2').select2();

            $(".select2-placeholder-multiple").select2({
                placeholder: "Select State"
            });
            $(".js-hide-search").select2({
                minimumResultsForSearch: 1 / 0
            });
            $(".js-max-length").select2({
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items"
            });
            $(".select2-placeholder").select2({
                placeholder: "Select a state",
                allowClear: true
            });

            $(".js-select2-icons").select2({
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function(elm) {
                    return elm
                }
            });

            function icon(elm) {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
            }



            $('#account').select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: 'json',
                    url: 'AllMainAccounts',
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            })
                        };

                        console.log(data);

                    },
                    data: function(params) {


                        var query = {
                            search: params.term,
                        };


                        $.ajax({
                            url: 'MainAccountss/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#account').empty();
                                $.each(data, function(key, value) {

                                    $('#account').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                }
            });


            $('#account').on('select2:select', function(e) {
                console.log("select done", e.params.data);
            });



            $('.account').select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: 'json',
                    url: 'AllMainAccounts',
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            })
                        };

                        console.log(data);

                    },
                    data: function(params) {


                        var query = {
                            search: params.term,
                        };


                        $.ajax({
                            url: 'MainAccountss/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#account').empty();
                                $.each(data, function(key, value) {

                                    $('#account').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                }
            });


            $('.account').on('select2:select', function(e) {
                console.log("select done", e.params.data);
            });




        });
    });
</script>

<style>
    .form-control {
        border: 2px solid #584576 !important;
    }

    .btn i {
        /*color: red;*/
    }
</style>

<!-- Sup Groups Filter -->
<script>
    function SupGroups(Parent){


        $.ajax({
            url:'SupAccountFilter',
            method:'GET',
            data:{Parent:Parent},
            dataType:'json',
            success:function(data)
            {


                $('.Data'+Parent).html(data.table_data);


            }
        })





    }
</script>

<script>
    function  ChangeEditGroup(){

        $group=$('#ID').val();
        $.ajax({
            url:'EditAccountFilter',
            method:'GET',
            data:{group:$group},
            dataType:'json',
            success:function(data)
            {



                $('#Name').val(data.Name);
                $('#NameEn').val(data.NameEn);
                $('#Account_Code').val(data.Account_Code);
                $('#Note').val(data.Note);
                $('#Pro_Group').val(data.Pro_Group_Name);
                $('#Parent').val(data.Parent_Name);








            }
        })


    }
</script>




@endpush
