<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB; // تأكد من استيراد DB Facade

class AddCCForeignKeyToSalesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('comments_clients', function (Blueprint $table) {
            // قم بتحويل العمود مباشرة إلى BIGINT باستخدام القيمة الحالية
            // إذا كان العمود يحتوي على قيم غير رقمية (مثل نصوص)، سيفشل هذا التحويل.
            // يجب أن تكون القيم الحالية قابلة للتحويل إلى BIGINT.
            DB::statement('ALTER TABLE "comments_clients" ALTER COLUMN "Responsible" TYPE BIGINT USING "Responsible"::BIGINT');
            DB::statement('ALTER TABLE "comments_clients" ALTER COLUMN "Customer" TYPE BIGINT USING "Customer"::BIGINT');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('comments_clients', function (Blueprint $table) {
            // للرجوع، قم بتحويل العمود مرة أخرى إلى TEXT
            DB::statement('ALTER TABLE "comments_clients" ALTER COLUMN "Responsible" TYPE TEXT USING "Responsible"::TEXT');
            DB::statement('ALTER TABLE "comments_clients" ALTER COLUMN "Customer" TYPE TEXT USING "Customer"::TEXT');
        });
    }
}
