<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class ChangeCustomerColumnTypeInCommentsClientsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Clean or convert data (optional but recommended)
        DB::table('comments_clients')->update([
            'Customer' => DB::raw("REGEXP_REPLACE(\"Customer\", '[^0-9]', '', 'g')") // Remove non-numeric characters
        ]);

        // Change the column type using raw SQL
        DB::statement('ALTER TABLE comments_clients ALTER COLUMN "Customer" TYPE bigint USING "Customer"::bigint');
}

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Revert the column type back to text
        DB::statement('ALTER TABLE comments_clients ALTER COLUMN "Customer" TYPE text USING "Customer"::text');
    }
}
