<?php

namespace App\Traits;
use App\Models\Journalizing;
use App\Models\UsersMoves;
use App\Models\MaintainceDefaultData;
use App\Models\Purchases;
use App\Models\Vendors;
use App\Models\Event;
use App\Models\GeneralDaily;
use App\Models\JournalizingDetails;
use App\Models\AcccountingManual;
use App\Models\PurchasesDefaultData;
use App\Models\SalesDefaultData;
use App\Models\AccountsDefaultData;
use App\Models\StoresDefaultData;
use App\Models\ModuleSettingsNum;
use App\Models\SafesBanks;
use App\Models\Stores;
use App\Models\Customers;
use App\Models\Taxes;
use App\Models\Notifications;
use App\Models\BarcodeSettings;
use App\Models\DefaultDataShowHide;
use App\Models\ProductUnits;
use App\Models\ProductsQty;
use App\Models\ProductMoves;
use App\Models\FifoQty;
use App\Models\StoresMoves;
use App\Models\ExpireDateQty;
use DB;
use Str;
trait GeneralTrait
{



    // User Moves ===================
    public function UserCreateMoves($data)
    {

        if(!empty(auth()->guard('admin')->user()->id)){
            $id=auth()->guard('admin')->user()->id;
        }else{
            $id=$data['id'];
        }

    $dataUser['User']=$id;
    $dataUser['Date']=date('Y-m-d');
    $dataUser['Time']=date("h:i:s a", time());
    $dataUser['Screen']=$data['screen_ar'];
    $dataUser['ScreenEn']=$data['screen_en'];
    $dataUser['Type']='اضافه جديده';
    $dataUser['TypeEn']='New Add';

    $dataUser['Explain']=$data['explain_ar'];

    if(!empty($data['explain_en'])){
    $dataUser['ExplainEn']=$data['explain_en'];
    }else{
    $dataUser['ExplainEn']=$data['explain_ar'];

    }

    UsersMoves::create($dataUser);


    }


    public function UserUpdateMoves($data)
    {

        if(!empty(auth()->guard('admin')->user()->id)){
            $id=auth()->guard('admin')->user()->id;
        }else{
            $id=$data['id'];
        }

        $dataUser['User']=$id;
    $dataUser['Date']=date('Y-m-d');
    $dataUser['Time']=date("h:i:s a", time());
    $dataUser['Screen']=$data['screen_ar'];
    $dataUser['ScreenEn']=$data['screen_en'];
    $dataUser['Type']='تعديل';
    $dataUser['TypeEn']='Edit';

    $dataUser['Explain']=$data['explain_ar'];

    if(!empty($data['explain_en'])){
    $dataUser['ExplainEn']=$data['explain_en'];
    }else{
    $dataUser['ExplainEn']=$data['explain_ar'];

    }

    UsersMoves::create($dataUser);


    }


    public function UserDeleteMoves($data)
    {

        if(!empty(auth()->guard('admin')->user()->id)){
            $id=auth()->guard('admin')->user()->id;
        }else{
            $id=$data['id'];
        }

        $dataUser['User']=$id;
    $dataUser['Date']=date('Y-m-d');
    $dataUser['Time']=date("h:i:s a", time());
    $dataUser['Screen']=$data['screen_ar'];
    $dataUser['ScreenEn']=$data['screen_en'];
    $dataUser['Type']='حذف';
    $dataUser['TypeEn']='Delete';

    $dataUser['Explain']=$data['explain_ar'];

    if(!empty($data['explain_en'])){
    $dataUser['ExplainEn']=$data['explain_en'];
    }else{
    $dataUser['ExplainEn']=$data['explain_ar'];

    }

    UsersMoves::create($dataUser);


    }

    public function UserCustomMoves($data)
    {

        if(!empty(auth()->guard('admin')->user()->id)){
            $id=auth()->guard('admin')->user()->id;
        }else{
            $id=$data['id'];
        }

        $dataUser['User']=$id;
    $dataUser['Date']=date('Y-m-d');
    $dataUser['Time']=date("h:i:s a", time());
    $dataUser['Screen']=$data['screen_ar'];
    $dataUser['ScreenEn']=$data['screen_en'];
    $dataUser['Type']=$data['type_ar'];
    $dataUser['TypeEn']=$data['type_en'];

    $dataUser['Explain']=$data['explain_ar'];

    if(!empty($data['explain_en'])){
    $dataUser['ExplainEn']=$data['explain_en'];
    }else{
    $dataUser['ExplainEn']=$data['explain_ar'];

    }

    UsersMoves::create($dataUser);


    }

    // End User Moves ===================


    // Whene Delete Something in Default Data ===================
    public function DefaultDataDelete($model,$id,$item)
    {

    $check=$model::latest('id')->first();

    if($check->$item == $id){

    session()->flash('error',trans('admin.Cant_Delete_Default_Data'));
    return 1;
    }



    return 0;



    }


    // Used Maximum ===================
    public function MaxUse($name,$model,$num)
    {


    $Module=ModuleSettingsNum::orderBy('id','desc')->first();

    if($Module->$name == 1){

    $count=$model::count();

    if($Module->$num <= $count){ $result=1; }else{ $result=0; } }else{ $result=0; } return $result;


    }




    // Create New Code===================

    public function ReturnCode($model) { $res=$model::orderBy('id','desc')->first();

        if(!empty($res->Code)){

        $Code=$res->Code + 1 ;

        }else{

        $Code=1;

        }

        return $Code;


        }


        // Jounralizing ===================

        public function CreateNewJun($data)
        {

        if(!empty($data['branch'])){
        $branch = $data['branch'] ;
        }else{
        $branch = null ;
        }

        if(!empty($data['status'])){
        $status = $data['status'] ;
        }else{
        $status = 1 ;
        }


        $ID = DB::table('journalizings')->insertGetId(

        array(

        'Type' => $data['type_ar'],
        'TypeEn' => $data['type_en'],
        'Code_Type' =>$data['code_type'],
        'Date' => $data['date'],
        'Draw' => $data['draw'],
        'Coin' => $data['coin'],
        'Branch' => $branch,
        'Cost_Center' => $data['cost_center'],
        'Total_Debaitor' => $data['total'],
        'Total_Creditor' => $data['total'],
        'Note' =>$data['note'],
        'Status' =>$status,

        )
        );



        return $ID;


        }


        public function JunDetails($data)
        {


        if(!empty($data['branch'])){
        $branch = $data['branch'] ;
        }else{


        $branch = null ;
        }


        if(!empty($data['admin_id'])){
        $user = $data['admin_id'] ;
        }else{


            $user = auth()->guard('admin')->user()->id ;
        }



        $PRODUCTSS['Joun_ID']=$data['joun_id'];
        $PRODUCTSS['Debitor']=$data['debitor_debt'];
        $PRODUCTSS['Creditor']=$data['creditor_debt'];
        $PRODUCTSS['Account']=$data['account_debt'];
        $PRODUCTSS['Statement']=$data['note'];

        JournalizingDetails::create($PRODUCTSS);

        $Gen['Code']=$data['code'];
        $Gen['Code_Type']=$data['code_type'];
        $Gen['Date']=$data['date'];
        $Gen['Type']=$data['type_ar'];
        $Gen['TypeEn']=$data['type_en'];
        $Gen['Debitor']=$data['debitor_debt'];
        $Gen['Creditor']=$data['creditor_debt'];
        $Gen['Statement']=$data['note'];
        $Gen['Draw']=$data['draw'];
        $Gen['Branch']= $branch;
        $Gen['Debitor_Coin']= $data['draw'] * $data['debitor_debt'];
        $Gen['Creditor_Coin']=$data['draw'] * $data['creditor_debt'];
        $Gen['Account']=$data['account_debt'];
        $Gen['Coin']= $data['coin'];
        $Gen['Cost_Center']=$data['cost_center'];
        $Gen['userr']= $user;

        GeneralDaily::create($Gen);


        $PRODUCTSS['Joun_ID']=$data['joun_id'];
        $PRODUCTSS['Debitor']=$data['debitor_cred'];
        $PRODUCTSS['Creditor']=$data['creditor_cred'];
        $PRODUCTSS['Account']=$data['account_cred'];
        $PRODUCTSS['Statement']=$data['note'];


        JournalizingDetails::create($PRODUCTSS);

        $Gen['Code']=$data['code'];
        $Gen['Code_Type']=$data['code_type'];
        $Gen['Date']=$data['date'];
        $Gen['Type']=$data['type_ar'];
        $Gen['TypeEn']=$data['type_en'];
        $Gen['Debitor']=$data['debitor_cred'];
        $Gen['Creditor']=$data['creditor_cred'];
        $Gen['Statement']=$data['note'];
        $Gen['Draw']=$data['draw'];
        $Gen['Branch']= $branch;
        $Gen['Debitor_Coin']= $data['draw'] * $data['debitor_cred'];
        $Gen['Creditor_Coin']=$data['draw'] * $data['creditor_cred'];
        $Gen['Account']=$data['account_cred'];
        $Gen['Coin']= $data['coin'];
        $Gen['Cost_Center']=$data['cost_center'];
        $Gen['userr']= $user;

        GeneralDaily::create($Gen);


        }

        public function OneJunDetails($data ,$type)
        {


            if(!empty($data['admin_id'])){
                $user = $data['admin_id'] ;
            }else{


                $user = auth()->guard('admin')->user()->id ;
            }

            if(!empty($data['branch'])){
        $branch = $data['branch'] ;
        }else{


        $branch = null ;
        }


        $PRODUCTSS['Joun_ID']=$data['joun_id'];
        $PRODUCTSS['Debitor']=$data['debitor'];
        $PRODUCTSS['Creditor']=$data['creditor'];
        $PRODUCTSS['Account']=$data['account'];
        $PRODUCTSS['Statement']=$data['note'];

        JournalizingDetails::create($PRODUCTSS);


        if($type == 0){
        $Gen['Code']=$data['code'];
        $Gen['Code_Type']=$data['code_type'];
        $Gen['Date']=$data['date'];
        $Gen['Type']=$data['type_ar'];
        $Gen['TypeEn']=$data['type_en'];
        $Gen['Debitor']=$data['debitor'];
        $Gen['Creditor']=$data['creditor'];
        $Gen['Statement']=$data['note'];
        $Gen['Draw']=$data['draw'];
        $Gen['Debitor_Coin']= $data['draw'] * $data['debitor'];
        $Gen['Creditor_Coin']=$data['draw'] * $data['creditor'];
        $Gen['Account']=$data['account'];
        $Gen['Coin']= $data['coin'];
        $Gen['Branch']= $branch;
        $Gen['Cost_Center']=$data['cost_center'];
        $Gen['userr']= $user;

        GeneralDaily::create($Gen);
        }



        }

        // End Jounralizing ===================



        // Upload File ===================
        public function UploadFile($imageFile)
        {



        if($imageFile){
        $image_nameFile=Str::random(10);
        $extFile=strtolower($imageFile->getClientOriginalExtension());
        $image_full_nameFile=$image_nameFile .'.' . $extFile ;
        $upload_pathFile='SafeTransferFiles/';
        $image_urlFile=$upload_pathFile.$image_full_nameFile;
        $successFile=$imageFile->move($upload_pathFile,$image_full_nameFile);
        }


        if(!empty($image_urlFile)){

        $zFile=$image_urlFile;

        }else{
        $zFile=null;
        }




        return $zFile;


        }



        // Create Event ===================

        public function CreateEvent($data)
        {


        $event['Start_Date']=$data['start_date'];
        $event['End_Date']=$data['end_date'];
        $event['Event_Ar_Name']=$data['event_name_ar'];
        $event['Event_En_Name']=$data['event_name_en'];
        $event['Type']=$data['type'];
        $event['Type_ID']=$data['type_id'];
        $event['Type_Code']=$data['type_code'];
        $event['Emp']=$data['emp'];
        $event['Client']=$data['client'];
        $event['Product']=$data['product'];
        $event['Customer']=$data['customer'];
        Event::create($event);


        }


        // Create Notifications ===================

        public function CreateNotification($data)
        {


        $notii['Date']=date('Y-m-d');
        $notii['Status']=0;
        $notii['Noti_Ar_Name']=$data['noti_name_ar'];
        $notii['Noti_En_Name']=$data['noti_name_ar'];
        $notii['Type']=$data['type_ar'];
        $notii['TypeEn']=$data['type_en'];
        $notii['Type_Code']=$data['type_code'];
        $notii['Emp']=$data['emp'];
        $notii['Client']=$data['client'];
        $notii['Product']=$data['product'];
        $notii['Store']=$data['store'];
        $notii['Safe']=$data['safe'];

        Notifications::create($notii);

        notify()->warning($data['notify_name']);


        }



        // Create Account in Account Manual

        public function CreateAccount($name_ar,$name_en ,$parent ,$note)
        {


        $count=AcccountingManual::orderBy('id','desc')->where('Parent',$parent)->count();
        $code=AcccountingManual::orderBy('id','desc')->where('Parent',$parent)->first();
        $codee=AcccountingManual::find($parent);

        if($count == 0){

        $x=$codee->Code.'01';
        $data['Code']=(int) $x ;

        }else{

        $y=substr($code->Code, strlen($codee->Code));
        $newY=$y + 1 ;

        if(strlen($newY) == 1){
        $NewXY='0'.$newY;
        }else{
        $NewXY=$newY;
        }
        $x= $codee->Code.$NewXY;
        $data['Code']=(int) $x;

        }

        $data['Name']=$name_ar;
        $data['NameEn']=$name_en;
        $data['Type']=1;
        $data['Parent']=$parent;
        $data['Note']=$note;
        $data['User']=auth()->guard('admin')->user()->id;
        AcccountingManual::create($data);

        $Acc=AcccountingManual::latest('id')->first();
        return $Acc->id ;


        }
   public function CreateAccountMain($name_ar,$name_en ,$parent ,$note)
        {


        $count=AcccountingManual::orderBy('id','desc')->where('Parent',$parent)->count();
        $code=AcccountingManual::orderBy('id','desc')->where('Parent',$parent)->first();
        $codee=AcccountingManual::find($parent);

        if($count == 0){

        $x=$codee->Code.'01';
        $data['Code']=(int) $x ;

        }else{

        $y=substr($code->Code, strlen($codee->Code));
        $newY=$y + 1 ;

        if(strlen($newY) == 1){
        $NewXY='0'.$newY;
        }else{
        $NewXY=$newY;
        }
        $x= $codee->Code.$NewXY;
        $data['Code']=(int) $x;

        }

        $data['Name']=$name_ar;
        $data['NameEn']=$name_en;
        $data['Type']=0;
        $data['Parent']=$parent;
        $data['Note']=$note;
        $data['User']=auth()->guard('admin')->user()->id;
        AcccountingManual::create($data);

        $Acc=AcccountingManual::latest('id')->first();
        return $Acc->id ;


        }

        public function CreateAccountByName($name_ar,$name_en ,$parent ,$note)
        {


        $count=AcccountingManual::orderBy('id','desc')->where('Name',$parent)->count();
        $code=AcccountingManual::orderBy('id','desc')->where('Name',$parent)->first();
        $codee=AcccountingManual::latest('id')->where('Name',$parent)->first();


        if($count == 0){

        $x=$codee->Code.'01';
        $data['Code']=(int) $x ;

        }else{

        $y=substr($code->Code, strlen($codee->Code));

        if(!empty($y)) {
            $newY = $y + 1;

            if (strlen($newY) == 1) {
                $NewXY = '0' . $newY;
            } else {
                $NewXY = $newY;
            }
            $x = $codee->Code . $NewXY;
            $data['Code'] = (int)$x;
        }else{
            $x=$codee->Code.'01';
            $data['Code']=(int) $x ;
        }

        }

        $data['Name']=$name_ar;
        $data['NameEn']=$name_en;
        $data['Type']=1;
        $data['Parent']=$codee->id;
        $data['Note']=$note;
        $data['User']=auth()->guard('admin')->user()->id;
        AcccountingManual::create($data);

        $Acc=AcccountingManual::latest('id')->first();
        return $Acc->id ;


        }


        public function CreateAccountApi($name_ar,$name_en ,$parent ,$note,$id)
        {


        $count=AcccountingManual::orderBy('id','desc')->where('Parent',$parent)->count();
        $code=AcccountingManual::orderBy('id','desc')->where('Parent',$parent)->first();
        $codee=AcccountingManual::find($parent);

        if($count == 0){

        $x=$codee->Code.'01';
        $data['Code']=(int) $x ;

        }else{

        $y=substr($code->Code, strlen($codee->Code));
        $newY=$y + 1 ;

        if(strlen($newY) == 1){
        $NewXY='0'.$newY;
        }else{
        $NewXY=$newY;
        }
        $x= $codee->Code.$NewXY;
        $data['Code']=(int) $x;

        }

        $data['Name']=$name_ar;
        $data['NameEn']=$name_en;
        $data['Type']=1;
        $data['Parent']=$parent;
        $data['Note']=$note;
        $data['User']=$id;
        AcccountingManual::create($data);

        $Acc=AcccountingManual::latest('id')->first();
        return $Acc->id ;


        }


        //Safe Credit
        public function SafeCredit($safe,$amount)
        {

        $debt=GeneralDaily::where('Account',$safe)->get()->sum('Debitor');
        $crdt=GeneralDaily::where('Account',$safe)->get()->sum('Creditor');
        $dif=$debt - $crdt ;
        $SafyFatora=$amount;

        if($dif < $SafyFatora){ return 1; } return 0 ; }


    //Filter Products  (Supplay Chain) =====================================
       public function FilterProduct($search)
        {


        $DefSHOW=DefaultDataShowHide::orderBy('id','desc')->first();
        if($DefSHOW->Search_Typical ==  0){

            $data =ProductUnits::whereRelation('Product', 'Status', 0)
                ->whereIn('P_Type',['Completed','Raw','Service','Industrial','Subscribe'])
               ->whereRelation('Product',function ($query)  use ($search) {

               $query->where('P_Ar_Name','ILIKE', "%{$search}%")
               ->orWhere('P_En_Name','ILIKE', "%{$search}%");

               })->OrWhere(function ($query)  use ($search) {

               $query->where('Barcode','ILIKE', "%{$search}%");

               })

                ->where('Def',1)
               ->limit(100)
               ->get();





              }else{

                   $data =ProductUnits::whereRelation('Product', 'Status', 0)
                   ->whereIn('P_Type',['Completed','Raw','Service','Industrial','Subscribe'])
               ->whereRelation('Product',function ($query)  use ($search) {

               $query->where('P_Ar_Name', $search)
               ->orWhere('P_En_Name', $search);

               })->OrWhere(function ($query)  use ($search) {

               $query->where('Barcode', $search);

               })
                       ->where('Def',1)
               ->limit(100)
               ->get();


                }



           return $data ;

       }

           public function FilterProductQty($search,$store)
        {

                 $DefSHOW=DefaultDataShowHide::orderBy('id','desc')->first();
  if($DefSHOW->Search_Typical ==  0){
        if(!empty($store)){

           $Prodss=ProductsQty::whereRelation('Product', 'Status', 0)


           ->whereRelation('Product',function ($query) use ($search) {

           $query->where('P_Ar_Name','ILIKE', "%{$search}%")
           ->orWhere('P_En_Name','ILIKE', "%{$search}%");

           })->OrWhere(function ($query)  use ($search) {

           $query->where('V_Name','ILIKE', "%{$search}%")
           ->orWhere('VV_Name','ILIKE', "%{$search}%");

           })->OrWhere(function ($query)  use ($search) {

           $query->where('P_Code','ILIKE', "%{$search}%")
   ->orWhere('PP_Code','ILIKE', "%{$search}%")
                               ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                               ->orWhere('PPPP_Code','ILIKE', "%{$search}%");
           })

          ->where('Store',$store)
          ->limit(100)
               ->get();

        }else{

              $Prodss=ProductsQty::whereRelation('Product', 'Status', 0)


           ->whereRelation('Product',function ($query) use ($search) {

           $query->where('P_Ar_Name','ILIKE', "%{$search}%")
           ->orWhere('P_En_Name','ILIKE', "%{$search}%");

           })->OrWhere(function ($query)  use ($search) {

           $query->where('V_Name','ILIKE', "%{$search}%")
           ->orWhere('VV_Name','ILIKE', "%{$search}%");

           })->OrWhere(function ($query)  use ($search) {

           $query->where('P_Code','ILIKE', "%{$search}%")

           ->orWhere([
           ['PP_Code','ILIKE', "%{$search}%"],
           ['PPP_Code','ILIKE', "%{$search}%"],
           ['PPPP_Code','ILIKE', "%{$search}%"],
           ]);

           })

          ->limit(100)
               ->get();


        }

  }else{

        if(!empty($store)){

           $Prodss=ProductsQty::whereRelation('Product', 'Status', 0)


           ->whereRelation('Product',function ($query) use ($search) {

           $query->where('P_Ar_Name', $search)
           ->orWhere('P_En_Name', $search);

           })->OrWhere(function ($query)  use ($search) {

           $query->where('V_Name', $search)
           ->orWhere('VV_Name', $search);

           })->OrWhere(function ($query)  use ($search) {

           $query->where('P_Code', $search)

           ->orWhere([
           ['PP_Code', $search],
           ['PPP_Code', $search],
           ['PPPP_Code', $search],
           ]);

           })

          ->where('Store',$store)
          ->limit(100)
               ->get();

        }else{

                 $Prodss=ProductsQty::whereRelation('Product', 'Status', 0)


           ->whereRelation('Product',function ($query) use ($search) {

           $query->where('P_Ar_Name', $search)
           ->orWhere('P_En_Name', $search);

           })->OrWhere(function ($query)  use ($search) {

           $query->where('V_Name', $search)
           ->orWhere('VV_Name', $search);

           })->OrWhere(function ($query)  use ($search) {

           $query->where('P_Code', $search)
  ->orWhere('PP_Code' ,$search)
                            ->orWhere('PPP_Code' ,$search)
                            ->orWhere('PPPP_Code' ,$search);
           })

          ->limit(100)
               ->get();


        }


  }

           return $Prodss ;

       }



    //Product Moves

    public function ProductMoves($data){


         $move['Date']=$data['Date'];
         $move['Type']=$data['Type'] ;
         $move['TypeEn']=$data['TypeEn'] ;
         $move['Bill_Num']=$data['Bill_Num'];
         $move['Incom']=$data['Incom'];
         $move['Outcom']=$data['Outcom'];
         $move['Current']=$data['Current'];
         $move['CostIn']=$data['CostIn'];
         $move['CostOut']=$data['CostOut'];
         $move['CostCurrent']=$data['CostCurrent'];
         $move['P_Ar_Name']=$data['P_Ar_Name'];
         $move['P_En_Name']=$data['P_En_Name'];
         $move['P_Code']=$data['P_Code'];
         $move['Unit']=$data['Unit'];
         $move['Qty']=$data['Qty'];
         $move['Group']=$data['Group'];
         $move['Store']=$data['Store'];
         $move['Product']=$data['Product'];
         $move['V1']=$data['V1'];
         $move['V2']=$data['V2'];
         $move['Brand']=$data['Brand'];
         $move['Safe']=$data['Safe'];
         $move['Branch']=$data['Branch'];
         $move['SalePrice']=$data['SalePrice'];
         $move['ProductPrice']=$data['ProductPrice'];
         $move['Delegate']=$data['Delegate'];
         $move['Payment_Method']=$data['Payment_Method'];
         $move['User']=$data['User'];
         ProductMoves::create($move);





    }



    //StoresMoves

    public function StoresMoves($data){



           $dataStMove['Date']=$data['Date'];
           $dataStMove['Code']=$data['Code'];
           $dataStMove['Time']=$data['Time'];
           $dataStMove['Branch']=$data['Branch'];
           $dataStMove['Store']=$data['Store'];
           $dataStMove['Safe']=$data['Safe'];
           $dataStMove['Type']=$data['Type'];
           $dataStMove['TypeEn']=$data['TypeEn'];
           $dataStMove['Cost_Center']=$data['Cost_Center'];
           $dataStMove['User']=$data['User'];
           $dataStMove['Coin']=$data['Coin'];
           $dataStMove['Note']=$data['Note'];
           $dataStMove['Total_Qty']=$data['Total_Qty'];
           $dataStMove['Total_Price']=$data['Total_Price'];
           $dataStMove['Account']=$data['Account'];
           $dataStMove['Ship']=$data['Ship'];
           $dataStMove['ID']=$data['ID'];
           StoresMoves::create($dataStMove);




    }




    //Fifo Avliable Qty

    public function FifoAvQty($store,$product,$code,$date){


               $fifo =FifoQty::
               where('Store',$store)
               ->where('Product',$product)
               ->where('P_Code',$code)
               ->where('Purchases_Date',$date)
               ->first();

               if(empty($fifo)){

               $fifo =FifoQty::
               where('Store',$store)
               ->where('Product',$product)
               ->where('PP_Code',$code)
               ->where('Purchases_Date',$date)
               ->first();

               if(empty($fifo)){

               $fifo =FifoQty::
               where('Store',$store)
               ->where('Product',$product)
               ->where('PPP_Code',$code)
               ->where('Purchases_Date',$date)
               ->first();


               if(empty($fifo)){

               $fifo =FifoQty::
               where('Store',$store)
               ->where('Product',$product)
               ->where('PPPP_Code',$code)
               ->where('Purchases_Date',$date)
               ->first();

               }

               }

               }


               return $fifo ;



    }

    public function FifoAvQtyDate($store,$product,$code){


              $fifo =FifoQty::orderBy('id','asc')
              ->where('Store',$store)
              ->where('Product',$product)
              ->where('P_Code',$code)
              ->where('Qty','!=',0)
              ->first();



              if(empty($fifo)){


              $fifo =FifoQty::orderBy('id','asc')
              ->where('Store',$store)
              ->where('Product',$product)
              ->where('PP_Code',$code)
              ->where('Qty','!=',0)
              ->first();

              if(empty($fifo)){

              $fifo =FifoQty::orderBy('id','asc')
              ->where('Store',$store)
              ->where('Product',$product)
              ->where('PPP_Code',$code)
              ->where('Qty','!=',0)
              ->first();


              if(empty($fifo)){

              $fifo =FifoQty::orderBy('id','asc')
              ->where('Store',$store)
              ->where('Product',$product)
              ->where('PPPP_Code',$code)
              ->where('Qty','!=',0)
              ->first();

              }

              }

              }

      return $fifo ;




    }

    public function TestCost($store,$product,$code,$id,$Purchases_Date){


                   $rr=ProductUnits::where('Product',$product)->where('Def',1)->first();

                   $fifo =FifoQty::
                   where('Store',$store)
                   ->where('Product',$product)
                   ->where('P_Code',$code)
                   ->where('id','!=',$id)
                   ->where('Purchases_Date','>',$Purchases_Date)
                   ->first();

                   if(empty($fifo)){

                   $fifo =FifoQty::
                   where('Store',$store)
                   ->where('Product',$product)
                   ->where('PP_Code',$code)
                   ->where('id','!=',$id)
                   ->where('Purchases_Date','>',$Purchases_Date)
                   ->first();

                   if(empty($fifo)){

                   $fifo =FifoQty::
                   where('Store',$store)
                   ->where('Product',$product)
                   ->where('PPP_Code',$code)
                   ->where('id','!=',$id)
                   ->where('Purchases_Date','>',$Purchases_Date)
                   ->first();


                   if(empty($fifo)){

                   $fifo =FifoQty::
                   where('Store',$store)
                   ->where('Product',$product)
                   ->where('PPPP_Code',$code)
                   ->where('id','!=',$id)
                   ->where('Purchases_Date','>',$Purchases_Date)
                   ->first();

                   }

                   }

                   }

                   if(!empty($fifo)){

                   if($fifo->Qty == 0){



                   $ty=$this->TestCost($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);

                   $AVERAGE = $ty ;

                   }else{
                   $AVERAGE = $fifo->Cost_Price ;
                   }


                   }else{

                   $AVERAGE = $rr->Price ;

                   }

        return $AVERAGE ;


    }


    //Products Avalibles Qties
        public function ProAvQties($store,$product,$code){

      $Quantity =ProductsQty::
              where('Store',$store)
              ->where('Product',$product)
              ->where('P_Code',$code)
              ->first();

              if(empty($Quantity)){

              $Quantity =ProductsQty::
              where('Store',$store)
              ->where('Product',$product)
              ->where('PP_Code',$code)
              ->first();

              if(empty($Quantity)){

              $Quantity =ProductsQty::
              where('Store',$store)
              ->where('Product',$product)
              ->where('PPP_Code',$code)
              ->first();


              if(empty($Quantity)){

              $Quantity =ProductsQty::
              where('Store',$store)
              ->where('Product',$product)
              ->where('PPPP_Code',$code)
              ->first();

              }

              }

              }



               return $Quantity ;



    }

    public function ProAvQtiesDamaged($store,$product,$code){

        $Quantity =ProductsQty::
        where('Store',$store)
            ->where('Product',$product)
            ->where('P_Code',$code)
            ->where('Original','Damage')
            ->first();

        if(empty($Quantity)){

            $Quantity =ProductsQty::
            where('Store',$store)
                ->where('Product',$product)
                ->where('PP_Code',$code)
                ->where('Original','Damage')
                ->first();

            if(empty($Quantity)){

                $Quantity =ProductsQty::
                where('Store',$store)
                    ->where('Product',$product)
                    ->where('PPP_Code',$code)
                    ->where('Original','Damage')
                    ->first();


                if(empty($Quantity)){

                    $Quantity =ProductsQty::
                    where('Store',$store)
                        ->where('Product',$product)
                        ->where('PPPP_Code',$code)
                        ->where('Original','Damage')
                        ->first();

                }

            }

        }



        return $Quantity ;



    }
     public function ProAvQtiesUnit($store,$product,$code,$unit){

      $Quantity =ProductsQty::where("Unit",$unit)
              ->where('Store',$store)
              ->where('Product',$product)
              ->where('P_Code',$code)
              ->first();

              if(empty($Quantity)){

              $Quantity =ProductsQty::
              where("Unit",$unit)
                  ->where('Store',$store)
              ->where('Product',$product)
              ->where('PP_Code',$code)
              ->first();

              if(empty($Quantity)){

              $Quantity =ProductsQty::
              where("Unit",$unit)
                  ->where('Store',$store)
              ->where('Product',$product)
              ->where('PPP_Code',$code)
              ->first();


              if(empty($Quantity)){

              $Quantity =ProductsQty::
              where("Unit",$unit)
                  ->where('Store',$store)
              ->where('Product',$product)
              ->where('PPPP_Code',$code)
              ->first();

              }

              }

              }



               return $Quantity ;



    }


    //Expire Date Avalibles Qties
        public function ExpireAvQties($store,$product,$code){

      $Quantity =ExpireDateQty::
              where('Store',$store)
              ->where('Product',$product)
              ->where('P_Code',$code)
              ->first();

              if(empty($Quantity)){

              $Quantity =ExpireDateQty::
              where('Store',$store)
              ->where('Product',$product)
              ->where('PP_Code',$code)
              ->first();

              if(empty($Quantity)){

              $Quantity =ExpireDateQty::
              where('Store',$store)
              ->where('Product',$product)
              ->where('PPP_Code',$code)
              ->first();


              if(empty($Quantity)){

              $Quantity =ExpireDateQty::
              where('Store',$store)
              ->where('Product',$product)
              ->where('PPPP_Code',$code)
              ->first();

              }

              }

              }



               return $Quantity ;



    }

         public function ExpireAvQtiesCheck($store,$product,$code,$date){

      $Quantity =ExpireDateQty::
              where('Store',$store)
              ->where('Product',$product)
              ->where('P_Code',$code)
              ->where('Exp_Date',$date)
              ->first();

              if(empty($Quantity)){

              $Quantity =ExpireDateQty::
              where('Store',$store)
              ->where('Product',$product)
              ->where('PP_Code',$code)
              ->where('Exp_Date',$date)
              ->first();

              if(empty($Quantity)){

              $Quantity =ExpireDateQty::
              where('Store',$store)
              ->where('Product',$product)
              ->where('PPP_Code',$code)
              ->where('Exp_Date',$date)
              ->first();


              if(empty($Quantity)){

              $Quantity =ExpireDateQty::
              where('Store',$store)
              ->where('Product',$product)
              ->where('PPPP_Code',$code)
              ->where('Exp_Date',$date)
              ->first();

              }

              }

              }



               return $Quantity ;



    }



    // =======================  Purchases Filter  ========================

         public function FilterPurchProduct($search,$Group,$Brand)
        {


        $DefSHOW=DefaultDataShowHide::orderBy('id','desc')->first();
        if($DefSHOW->Search_Typical ==  0){

     $data = ProductUnits::query()->whereRelation('Product', 'Status', 0)


    ->when(!is_numeric($search), function ($query) use ($search) {
         return  $query->whereRelation('Product','P_Ar_Name','ILIKE', "%{$search}%")
               ->orWhereRelation('Product','P_En_Name','ILIKE', "%{$search}%");

    })

    ->when(is_numeric($search), function ($query) use ($search) {
         return  $query->where('Barcode','ILIKE', "%{$search}%") ;
    })

         ->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable'])
            ->limit(100)

               ->get();



              }else{

                   $data =ProductUnits::whereRelation('Product', 'Status', 0)


             ->when(!is_numeric($search), function ($query) use ($search) {
         return  $query->whereRelation('Product','P_Ar_Name', $search)
               ->orWhereRelation('Product','P_En_Name', $search);

    })

    ->when(is_numeric($search), function ($query) use ($search) {
         return  $query->where('Barcode', $search) ;
    })


                       ->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable'])

               ->limit(100)
               ->get();





                }


           return $data ;

       }

         public function FilterPurchProductSearchCode($search,$Group,$Brand)
        {

        $DefSHOW=DefaultDataShowHide::orderBy('id','desc')->first();
        if($DefSHOW->Search_Typical ==  0){

     $data = ProductUnits::query()->whereRelation('Product', 'Status', 0)
         ->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable'])

    ->when(!is_numeric($search), function ($query) use ($search) {
         return  $query->whereRelation('Product','SearchCode1','ILIKE', "%{$search}%")
               ->orWhereRelation('Product','SearchCode2','ILIKE', "%{$search}%");

    })

    ->when(is_numeric($search), function ($query) use ($search) {
             return  $query->whereRelation('Product','SearchCode1','ILIKE', "%{$search}%")
               ->orWhereRelation('Product','SearchCode2','ILIKE', "%{$search}%");
    })

         ->where('Def',1)
            ->limit(100)
               ->get();



              }else{

                   $data =ProductUnits::whereRelation('Product', 'Status', 0)
                  ->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable'])

      ->when(!is_numeric($search), function ($query) use ($search) {
         return  $query->whereRelation('Product','SearchCode1', $search)
               ->orWhereRelation('Product','SearchCode2', $search);

    })

    ->when(is_numeric($search), function ($query) use ($search) {
             return  $query->whereRelation('Product','SearchCode1', $search)
               ->orWhereRelation('Product','SearchCode2', $search);
    })
                       ->where('Def',1)
               ->limit(100)
               ->get();


                }



           return $data ;

       }


         public function FilterPurchProductShort($search,$Group,$Brand)
        {

        $DefSHOW=DefaultDataShowHide::orderBy('id','desc')->first();
        if($DefSHOW->Search_Typical ==  0){

     $data = ProductUnits::query()->whereRelation('Product', 'Status', 0)
         ->whereIn('P_Type',['Completed','Raw','Industrial','Additions'])

    ->when(!is_numeric($search), function ($query) use ($search) {
         return  $query->whereRelation('Product','P_Ar_Name','ILIKE', "%{$search}%")
               ->orWhereRelation('Product','P_En_Name','ILIKE', "%{$search}%");

    })

    ->when(is_numeric($search), function ($query) use ($search) {
         return  $query->where('Barcode','ILIKE', "%{$search}%") ;
    })
         ->where('Def',1)
            ->limit(100)
               ->get();



              }else{

                   $data =ProductUnits::whereRelation('Product', 'Status', 0)
                  ->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable'])

             ->when(!is_numeric($search), function ($query) use ($search) {
         return  $query->whereRelation('Product','P_Ar_Name', $search)
               ->orWhereRelation('Product','P_En_Name', $search);

    })

    ->when(is_numeric($search), function ($query) use ($search) {
         return  $query->where('Barcode', $search) ;
    })


                       ->where('Def',1)
               ->limit(100)
               ->get();


                }



           return $data ;

       }

         public function FilterPurchProductSearchCodeShort($search,$Group,$Brand)
        {

        $DefSHOW=DefaultDataShowHide::orderBy('id','desc')->first();
        if($DefSHOW->Search_Typical ==  0){

     $data = ProductUnits::query()->whereRelation('Product', 'Status', 0)
         ->whereIn('P_Type',['Completed','Raw','Industrial','Additions'])

    ->when(!is_numeric($search), function ($query) use ($search) {
         return  $query->whereRelation('Product','SearchCode1','ILIKE', "%{$search}%")
               ->orWhereRelation('Product','SearchCode2','ILIKE', "%{$search}%");

    })

    ->when(is_numeric($search), function ($query) use ($search) {
             return  $query->whereRelation('Product','SearchCode1','ILIKE', "%{$search}%")
               ->orWhereRelation('Product','SearchCode2','ILIKE', "%{$search}%");
    })
         ->where('Def',1)
            ->limit(100)
               ->get();



              }else{

                   $data =ProductUnits::whereRelation('Product', 'Status', 0)
                  ->whereIn('P_Type',['Completed','Raw','Industrial','Additions','Serial','Single_Variable','Duble_Variable'])

      ->when(!is_numeric($search), function ($query) use ($search) {
         return  $query->whereRelation('Product','SearchCode1', $search)
               ->orWhereRelation('Product','SearchCode2', $search);

    })

    ->when(is_numeric($search), function ($query) use ($search) {
             return  $query->whereRelation('Product','SearchCode1', $search)
               ->orWhereRelation('Product','SearchCode2', $search);
    })
                       ->where('Def',1)
               ->limit(100)
               ->get();


                }



           return $data ;

       }

// ======================  Sales Filters  =====================


    public function FilterSalesProductQty($search,$store,$Group,$Brand)
    {

        $DefSHOW=DefaultDataShowHide::latest('id')->first();
        if($DefSHOW->Search_Typical ==  0){
            if(!empty($store)){

                $Prodss=ProductsQty::whereRelation('Product', 'Status', 0)

                    ->whereRelation('Product',function ($query)  {

                        $query->whereIn('P_Type',['Completed','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                    })


                    ->whereRelation('Product',function ($query) use ($search) {

                        $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                            ->orWhere('P_En_Name','ILIKE', "%{$search}%");

                    })->OrWhere(function ($query)  use ($search) {

                        $query->where('V_Name','ILIKE', "%{$search}%")
                            ->orWhere('VV_Name','ILIKE', "%{$search}%");

                    })->OrWhere(function ($query)  use ($search) {

                        $query->where('P_Code','ILIKE', "%{$search}%")
                               ->orWhere('PP_Code','ILIKE', "%{$search}%")
                               ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                               ->orWhere('PPPP_Code','ILIKE', "%{$search}%");



                    })

                    ->where('Store',$store)
                    ->take(100)
                    ->get();



            }

        }else{

            if(!empty($store)){

                $Prodss=ProductsQty::whereRelation('Product', 'Status', 0)

                    ->whereRelation('Product',function ($query)  {

                        $query->whereIn('P_Type',['Completed','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                    })

                    ->whereRelation('Product',function ($query) use ($search) {

                        $query->where('P_Ar_Name', $search)
                            ->orWhere('P_En_Name', $search);

                    })->OrWhere(function ($query)  use ($search) {

                        $query->where('V_Name', $search)
                            ->orWhere('VV_Name', $search);

                    })->OrWhere(function ($query)  use ($search) {

                        $query->where('P_Code', $search)
                            ->orWhere('PP_Code' ,$search)
                            ->orWhere('PPP_Code' ,$search)
                            ->orWhere('PPPP_Code' ,$search);


                    })

                    ->where('Store',$store)
                    ->take(100)
                    ->get();

            }


        }

        return $Prodss ;

    }

    public function FilterSalesProductQtyWithout($search,$store,$Group,$Brand)
    {

        $DefSHOW=DefaultDataShowHide::latest('id')->first();
        if($DefSHOW->Search_Typical ==  0){
            if(!empty($store)){

                $Prodss=ProductsQty::whereRelation('Product', 'Status', 0)

                    ->whereRelation('Product',function ($query)  {

                        $query->whereIn('P_Type',['Completed','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                    })


                    ->whereRelation('Product',function ($query) use ($search) {

                        $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                            ->orWhere('P_En_Name','ILIKE', "%{$search}%");

                    })->OrWhere(function ($query)  use ($search) {

                        $query->where('V_Name','ILIKE', "%{$search}%")
                            ->orWhere('VV_Name','ILIKE', "%{$search}%");

                    })->OrWhere(function ($query)  use ($search) {

                        $query->where('P_Code','ILIKE', "%{$search}%")
                               ->orWhere('PP_Code','ILIKE', "%{$search}%")
                               ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                               ->orWhere('PPPP_Code','ILIKE', "%{$search}%");



                    })

->where('Store',$store)
                    ->limit(100)
                    ->get();



            }

        }else{

            if(!empty($store)){

                $Prodss=ProductsQty::whereRelation('Product', 'Status', 0)

                    ->whereRelation('Product',function ($query)  {

                        $query->whereIn('P_Type',['Completed','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                    })

                    ->whereRelation('Product',function ($query) use ($search) {

                        $query->where('P_Ar_Name', $search)
                            ->orWhere('P_En_Name', $search);

                    })->OrWhere(function ($query)  use ($search) {

                        $query->where('V_Name', $search)
                            ->orWhere('VV_Name', $search);

                    })->OrWhere(function ($query)  use ($search) {

                        $query->where('P_Code', $search)
                            ->orWhere('PP_Code' ,$search)
                            ->orWhere('PPP_Code' ,$search)
                            ->orWhere('PPPP_Code' ,$search);


                    })

                    ->where('Store',$store)
                    ->limit(100)
                    ->get();

            }


        }

        return $Prodss ;

    }

    public function FilterSalesProductQtySearchCode($search,$store,$Group,$Brand)
    {

        $DefSHOW=DefaultDataShowHide::latest('id')->first();
        if($DefSHOW->Search_Typical ==  0){
            if(!empty($store)){

                $Prodss=ProductsQty::whereRelation('Product', 'Status', 0)

                    ->whereRelation('Product',function ($query)  {

                        $query->whereIn('P_Type',['Completed','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                    })


                    ->whereRelation('Product',function ($query) use ($search) {

                        $query->where('SearchCode1','ILIKE', "%{$search}%")
                            ->orWhere('SearchCode2','ILIKE', "%{$search}%");

                    })

                    ->where('Store',$store)
                    ->limit(100)
                    ->get();



            }

        }else{

            if(!empty($store)){

                $Prodss=ProductsQty::whereRelation('Product', 'Status', 0)

                    ->whereRelation('Product',function ($query)  {

                        $query->whereIn('P_Type',['Completed','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                    })

                    ->whereRelation('Product',function ($query) use ($search) {

                        $query->where('SearchCode1', $search)
                            ->orWhere('SearchCode2', $search);

                    })



                    ->where('Store',$store)
                    ->limit(100)
                    ->get();

            }


        }

        return $Prodss ;

    }

    public function FilterSalesProduct($search,$Group,$Brand)
    {

        $DefSHOW=DefaultDataShowHide::orderBy('id','desc')->first();
        if($DefSHOW->Search_Typical ==  0){

            $data = ProductUnits::query()->whereRelation('Product', 'Status', 0)
                ->whereIn('P_Type',['Assembly','Service'])

                ->when(!is_numeric($search), function ($query) use ($search) {
                    return  $query->whereRelation('Product','P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhereRelation('Product','P_En_Name','ILIKE', "%{$search}%");

                })

                ->when(is_numeric($search), function ($query) use ($search) {
                    return  $query->where('Barcode','ILIKE', "%{$search}%") ;
                })

                ->where('Def',1)
                ->limit(100)
                ->get();



        }else{

            $data =ProductUnits::whereRelation('Product', 'Status', 0)
                ->whereIn('P_Type',['Assembly','Service'])

                ->when(!is_numeric($search), function ($query) use ($search) {
                    return  $query->whereRelation('Product','P_Ar_Name', $search)
                        ->orWhereRelation('Product','P_En_Name', $search);

                })

                ->when(is_numeric($search), function ($query) use ($search) {
                    return  $query->where('Barcode', $search) ;
                })


                ->where('Def',1)
                ->limit(100)
                ->get();


        }



        return $data ;

    }


    public function FilterSalesProductResturant($search,$Group,$Brand)
    {

        $DefSHOW=DefaultDataShowHide::orderBy('id','desc')->first();
        if($DefSHOW->Search_Typical ==  0){

            $data = ProductUnits::query()->whereRelation('Product', 'Status', 0)
                ->whereIn('P_Type',['Assembly','Service','Variable_Aggregate'])

                ->when(!is_numeric($search), function ($query) use ($search) {
                    return  $query->whereRelation('Product','P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhereRelation('Product','P_En_Name','ILIKE', "%{$search}%");

                })

                ->when(is_numeric($search), function ($query) use ($search) {
                    return  $query->where('Barcode','ILIKE', "%{$search}%") ;
                })

                ->where('Def',1)
                ->limit(100)
                ->get();



        }else{

            $data =ProductUnits::whereRelation('Product', 'Status', 0)
                ->whereIn('P_Type',['Assembly','Service','Variable_Aggregate'])

                ->when(!is_numeric($search), function ($query) use ($search) {
                    return  $query->whereRelation('Product','P_Ar_Name', $search)
                        ->orWhereRelation('Product','P_En_Name', $search);

                })

                ->when(is_numeric($search), function ($query) use ($search) {
                    return  $query->where('Barcode', $search) ;
                })


                ->where('Def',1)
                ->limit(100)
                ->get();


        }



        return $data ;

    }



    public function FilterSalesProductWithout($search,$Group,$Brand)
    {

        $DefSHOW=DefaultDataShowHide::orderBy('id','desc')->first();
        if($DefSHOW->Search_Typical ==  0){

            $data = ProductUnits::query()->whereRelation('Product', 'Status', 0)
                ->whereIn('P_Type',['Assembly','Service','Completed','Industrial','Additions'])

                ->when(!is_numeric($search), function ($query) use ($search) {
                    return  $query->whereRelation('Product','P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhereRelation('Product','P_En_Name','ILIKE', "%{$search}%");

                })

                ->when(is_numeric($search), function ($query) use ($search) {
                    return  $query->where('Barcode','ILIKE', "%{$search}%") ;
                })

                ->where('Def',1)
                ->limit(100)
                ->get();



        }else{

            $data =ProductUnits::whereRelation('Product', 'Status', 0)
                ->whereIn('P_Type',['Assembly','Service']) ->whereIn('P_Type',['Assembly','Service','Completed','Industrial','Additions'])
                ->when(!is_numeric($search), function ($query) use ($search) {
                    return  $query->whereRelation('Product','P_Ar_Name', $search)
                        ->orWhereRelation('Product','P_En_Name', $search);

                })

                ->when(is_numeric($search), function ($query) use ($search) {
                    return  $query->where('Barcode', $search) ;
                })


                ->where('Def',1)
                ->limit(100)
                ->get();


        }



        return $data ;

    }

       public function FilterSalesProductSearchCode($search,$Group,$Brand)
    {

        $DefSHOW=DefaultDataShowHide::orderBy('id','desc')->first();
        if($DefSHOW->Search_Typical ==  0){

            $data = ProductUnits::query()->whereRelation('Product', 'Status', 0)
                ->whereIn('P_Type',['Assembly','Service'])

                ->when(!is_numeric($search), function ($query) use ($search) {
                    return  $query->whereRelation('Product','P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhereRelation('Product','P_En_Name','ILIKE', "%{$search}%");

                })

                ->when(is_numeric($search), function ($query) use ($search) {
                    return  $query->where('Barcode','ILIKE', "%{$search}%") ;
                })
                ->where('Def',1)
                ->limit(100)
                ->get();



        }else{

            $data =ProductUnits::whereRelation('Product', 'Status', 0)
                ->whereIn('P_Type',['Assembly','Service'])

                ->when(!is_numeric($search), function ($query) use ($search) {
                    return  $query->whereRelation('Product','P_Ar_Name', $search)
                        ->orWhereRelation('Product','P_En_Name', $search);

                })

                ->when(is_numeric($search), function ($query) use ($search) {
                    return  $query->where('Barcode', $search) ;
                })


                ->where('Def',1)
                ->limit(100)
                ->get();


        }



        return $data ;

    }
       public function FilterSalesProductSearchCodeResturant($search,$Group,$Brand)
    {

        $DefSHOW=DefaultDataShowHide::orderBy('id','desc')->first();
        if($DefSHOW->Search_Typical ==  0){

            $data = ProductUnits::query()->whereRelation('Product', 'Status', 0)
                ->whereIn('P_Type',['Assembly','Service','Variable_Aggregate'])

                ->when(!is_numeric($search), function ($query) use ($search) {
                    return  $query->whereRelation('Product','P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhereRelation('Product','P_En_Name','ILIKE', "%{$search}%");

                })

                ->when(is_numeric($search), function ($query) use ($search) {
                    return  $query->where('Barcode','ILIKE', "%{$search}%") ;
                })
                ->where('Def',1)
                ->limit(100)
                ->get();



        }else{

            $data =ProductUnits::whereRelation('Product', 'Status', 0)
                ->whereIn('P_Type',['Assembly','Service','Variable_Aggregate'])

                ->when(!is_numeric($search), function ($query) use ($search) {
                    return  $query->whereRelation('Product','P_Ar_Name', $search)
                        ->orWhereRelation('Product','P_En_Name', $search);

                })

                ->when(is_numeric($search), function ($query) use ($search) {
                    return  $query->where('Barcode', $search) ;
                })


                ->where('Def',1)
                ->limit(100)
                ->get();


        }



        return $data ;

    }


    //POS
    public function FilterSalesProductQtyCount($search,$store,$Group,$Brand)
    {

        $DefSHOW=DefaultDataShowHide::latest('id')->first();
        if($DefSHOW->Search_Typical ==  0){
            if(!empty($store)){

                $Prodss=ProductsQty::whereRelation('Product', 'Status', 0)

                    ->whereRelation('Product',function ($query)  {

                        $query->whereIn('P_Type',['Completed','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                    })


                    ->whereRelation('Product',function ($query) use ($search) {

                        $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                            ->orWhere('P_En_Name','ILIKE', "%{$search}%");

                    })->OrWhere(function ($query)  use ($search) {

                        $query->where('V_Name','ILIKE', "%{$search}%")
                            ->orWhere('VV_Name','ILIKE', "%{$search}%");

                    })->OrWhere(function ($query)  use ($search) {

                        $query->where('P_Code','ILIKE', "%{$search}%")
   ->orWhere('PP_Code','ILIKE', "%{$search}%")
                               ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                               ->orWhere('PPPP_Code','ILIKE', "%{$search}%");
                    })

                    ->where('Store',$store)
                    ->get()->count();



            }

        }else{

            if(!empty($store)){

                $Prodss=ProductsQty::whereRelation('Product', 'Status', 0)

                    ->whereRelation('Product',function ($query)  {

                        $query->whereIn('P_Type',['Completed','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                    })

                    ->whereRelation('Product',function ($query) use ($search) {

                        $query->where('P_Ar_Name', $search)
                            ->orWhere('P_En_Name', $search);

                    })->OrWhere(function ($query)  use ($search) {

                        $query->where('V_Name', $search)
                            ->orWhere('VV_Name', $search);

                    })->OrWhere(function ($query)  use ($search) {

                        $query->where('P_Code', $search)
  ->orWhere('PP_Code' ,$search)
                            ->orWhere('PPP_Code' ,$search)
                            ->orWhere('PPPP_Code' ,$search);
                    })

                    ->where('Store',$store)
                    ->get()->count();

            }


        }

        return $Prodss ;

    }

    public function FilterSalesProductQtyGet($search,$store,$Group,$Brand)
    {

        $DefSHOW=DefaultDataShowHide::latest('id')->first();
        if($DefSHOW->Search_Typical ==  0){
            if(!empty($store)){

                $Prodss=ProductsQty::whereRelation('Product', 'Status', 0)

                    ->whereRelation('Product',function ($query)  {

                        $query->whereIn('P_Type',['Completed','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                    })


                    ->whereRelation('Product',function ($query) use ($search) {

                        $query->where('P_Ar_Name','ILIKE', "%{$search}%")
                            ->orWhere('P_En_Name','ILIKE', "%{$search}%");

                    })->OrWhere(function ($query)  use ($search) {

                        $query->where('V_Name','ILIKE', "%{$search}%")
                            ->orWhere('VV_Name','ILIKE', "%{$search}%");

                    })->OrWhere(function ($query)  use ($search) {

                        $query->where('P_Code','ILIKE', "%{$search}%")
   ->orWhere('PP_Code','ILIKE', "%{$search}%")
                               ->orWhere('PPP_Code','ILIKE', "%{$search}%")
                               ->orWhere('PPPP_Code','ILIKE', "%{$search}%");
                    })

                    ->where('Store',$store)
                    ->get()->sum('id');



            }

        }else{

            if(!empty($store)){

                $Prodss=ProductsQty::whereRelation('Product', 'Status', 0)

                    ->whereRelation('Product',function ($query)  {

                        $query->whereIn('P_Type',['Completed','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                    })

                    ->whereRelation('Product',function ($query) use ($search) {

                        $query->where('P_Ar_Name', $search)
                            ->orWhere('P_En_Name', $search);

                    })->OrWhere(function ($query)  use ($search) {

                        $query->where('V_Name', $search)
                            ->orWhere('VV_Name', $search);

                    })->OrWhere(function ($query)  use ($search) {

                        $query->where('P_Code', $search)
  ->orWhere('PP_Code' ,$search)
                            ->orWhere('PPP_Code' ,$search)
                            ->orWhere('PPPP_Code' ,$search);
                    })

                    ->where('Store',$store)
                    ->get()->sum('id');

            }


        }

        return $Prodss ;

    }

    public function FilterSalesProductQtyCountSearchCode($search,$store,$Group,$Brand)
    {

        $DefSHOW=DefaultDataShowHide::latest('id')->first();
        if($DefSHOW->Search_Typical ==  0){
            if(!empty($store)){

                $Prodss=ProductsQty::whereRelation('Product', 'Status', 0)

                    ->whereRelation('Product',function ($query)  {

                        $query->whereIn('P_Type',['Completed','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                    })


                    ->whereRelation('Product',function ($query) use ($search) {

                        $query->where('SearchCode1','ILIKE', "%{$search}%")
                            ->orWhere('SearchCode2','ILIKE', "%{$search}%");

                    })

                    ->where('Store',$store)
                    ->count();




            }

        }else{

            if(!empty($store)){

                $Prodss=ProductsQty::whereRelation('Product', 'Status', 0)

                    ->whereRelation('Product',function ($query)  {

                        $query->whereIn('P_Type',['Completed','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                    })

                    ->whereRelation('Product',function ($query) use ($search) {

                        $query->where('SearchCode1', $search)
                            ->orWhere('SearchCode2', $search);

                    })



                    ->where('Store',$store)
                    ->count();

            }


        }

        return $Prodss ;

    }

    public function FilterSalesProductQtyGetSearchCode($search,$store,$Group,$Brand)
    {

        $DefSHOW=DefaultDataShowHide::latest('id')->first();
        if($DefSHOW->Search_Typical ==  0){
            if(!empty($store)){

                $Prodss=ProductsQty::whereRelation('Product', 'Status', 0)

                    ->whereRelation('Product',function ($query)  {

                        $query->whereIn('P_Type',['Completed','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                    })


                    ->whereRelation('Product',function ($query) use ($search) {

                        $query->where('SearchCode1','ILIKE', "%{$search}%")
                            ->orWhere('SearchCode2','ILIKE', "%{$search}%");

                    })

                    ->where('Store',$store)
                    ->get()->sum('id');



            }

        }else{

            if(!empty($store)){

                $Prodss=ProductsQty::whereRelation('Product', 'Status', 0)

                    ->whereRelation('Product',function ($query)  {

                        $query->whereIn('P_Type',['Completed','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                    })

                    ->whereRelation('Product',function ($query) use ($search) {

                        $query->where('SearchCode1', $search)
                            ->orWhere('SearchCode2', $search);

                    })



                    ->where('Store',$store)
                    ->get()->sum('id');

            }


        }

        return $Prodss ;

    }


    public function FilterSalesProductQtyGroup($Group,$store)
    {


            if(!empty($store)){

                $Prodss=ProductsQty::whereRelation('Product', 'Status', 0)

                    ->whereRelation('Product', 'Group', $Group)
                    ->whereRelation('Product',function ($query)  {

                        $query->whereIn('P_Type',['Completed','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                    })
                    ->where('Store',$store)
                    ->limit(100)
                    ->get();



            }



        return $Prodss ;

    }

    public function FilterSalesProductGroup($Group)
    {

        $data =ProductUnits::whereRelation('Product', 'Status', 0)
            ->whereRelation('Product', 'Group', $Group)
            ->whereIn('P_Type',['Assembly','Service'])
            ->limit(100)
            ->get();


        return $data ;

    }

    public function FilterSalesProductGroupResturant($Group)
    {

        $data =ProductUnits::whereRelation('Product', 'Status', 0)
            ->whereRelation('Product', 'Group', $Group)
            ->whereIn('P_Type',['Assembly','Service','Variable_Aggregate'])
            ->limit(100)
            ->get();


        return $data ;

    }


    public function FilterSalesProductQtyBrand($Group,$store)
    {


            if(!empty($store)){

                $Prodss=ProductsQty::whereRelation('Product', 'Status', 0)

                    ->whereRelation('Product', 'Brand', $Group)
                    ->whereRelation('Product',function ($query)  {

                        $query->whereIn('P_Type',['Completed','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                    })
                    ->where('Store',$store)
                    ->limit(100)
                    ->get();



            }



        return $Prodss ;

    }

    public function FilterSalesProductBrand($Group)
    {

        $data =ProductUnits::whereRelation('Product', 'Status', 0)
            ->whereRelation('Product', 'Brand', $Group)
            ->whereIn('P_Type',['Assembly','Service'])
            ->limit(100)
            ->get();


        return $data ;

    }
    public function FilterSalesProductBrandResturant($Group)
    {

        $data =ProductUnits::whereRelation('Product', 'Status', 0)
            ->whereRelation('Product', 'Brand', $Group)
            ->whereIn('P_Type',['Assembly','Service','Variable_Aggregate'])
            ->limit(100)
            ->get();


        return $data ;

    }


    public function FilterSalesProductQtyAll($store)
    {


            if(!empty($store)){

                $Prodss=ProductsQty::whereRelation('Product', 'Status', 0)


                    ->whereRelation('Product',function ($query)  {

                        $query->whereIn('P_Type',['Completed','Industrial','Additions','Serial','Single_Variable','Duble_Variable']);


                    })
                    ->where('Store',$store)
                    ->limit(200)
                    ->get();



            }



        return $Prodss ;

    }

    public function FilterSalesProductAll()
    {

        $data =ProductUnits::whereRelation('Product', 'Status', 0)

            ->whereIn('P_Type',['Assembly','Service'])
            ->limit(100)
            ->get();


        return $data ;

    }
    public function FilterSalesProductAllResturant()
    {

        $data =ProductUnits::whereRelation('Product', 'Status', 0)

            ->whereIn('P_Type',['Assembly','Service','Variable_Aggregate'])
            ->limit(100)
            ->get();


        return $data ;

    }


//Supscribes

    public function FilterSupscribeProduct($search)
    {

        $DefSHOW=DefaultDataShowHide::orderBy('id','desc')->first();
        if($DefSHOW->Search_Typical ==  0){

            $data = ProductUnits::query()->whereRelation('Product', 'Status', 0)


                ->when(!is_numeric($search), function ($query) use ($search) {
                    return  $query->whereRelation('Product','P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhereRelation('Product','P_En_Name','ILIKE', "%{$search}%");

                })

                ->when(is_numeric($search), function ($query) use ($search) {
                    return  $query->where('Barcode','ILIKE', "%{$search}%") ;
                })
                ->where('Def',1)
                ->limit(100)

                ->get();



        }else{

            $data =ProductUnits::whereRelation('Product', 'Status', 0)


                ->when(!is_numeric($search), function ($query) use ($search) {
                    return  $query->whereRelation('Product','P_Ar_Name', $search)
                        ->orWhereRelation('Product','P_En_Name', $search);

                })

                ->when(is_numeric($search), function ($query) use ($search) {
                    return  $query->where('Barcode', $search) ;
                })


                ->where('Def',1)
                ->limit(100)

                ->get();


        }



        return $data ;

    }




// ================  FIFO Functions  =========================

    public function FindQty($store,$product,$code,$id,$Purchases_Date){


        $rr=ProductUnits::where('Product',$product)->where('Def',1)->first();

        $fifo =FifoQty::
        where('Store',$store)
            ->where('Product',$product)
            ->where('P_Code',$code)
            ->where('id','!=',$id)
            ->where('Purchases_Date','>',$Purchases_Date)
            ->first();

        if(empty($fifo)){

            $fifo =FifoQty::
            where('Store',$store)
                ->where('Product',$product)
                ->where('PP_Code',$code)
                ->where('id','!=',$id)
                ->where('Purchases_Date','>',$Purchases_Date)
                ->first();

            if(empty($fifo)){

                $fifo =FifoQty::
                where('Store',$store)
                    ->where('Product',$product)
                    ->where('PPP_Code',$code)
                    ->where('id','!=',$id)
                    ->where('Purchases_Date','>',$Purchases_Date)
                    ->first();


                if(empty($fifo)){

                    $fifo =FifoQty::
                    where('Store',$store)
                        ->where('Product',$product)
                        ->where('PPPP_Code',$code)
                        ->where('id','!=',$id)
                        ->where('Purchases_Date','>',$Purchases_Date)
                        ->first();

                }

            }

        }

        if(!empty($fifo)){

            if($fifo->Qty == 0){



                $Quntatity=$this->FindQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);



            }else{
                $qty = $fifo->Qty ;
            }


        }

        return  $qty  ;


    }


    public function MoreThanQty($store,$product,$code,$id,$Purchases_Date,$Qty){


        $rr=ProductUnits::where('Product',$product)->where('Def',1)->first();

        $totCost=0;
        $fifo =FifoQty::
        where('Store',$store)
            ->where('Product',$product)
            ->where('P_Code',$code)
            ->where('id','!=',$id)
            ->where('Purchases_Date','>',$Purchases_Date)
            ->first();

        if(empty($fifo)){

            $fifo =FifoQty::
            where('Store',$store)
                ->where('Product',$product)
                ->where('PP_Code',$code)
                ->where('id','!=',$id)
                ->where('Purchases_Date','>',$Purchases_Date)
                ->first();

            if(empty($fifo)){

                $fifo =FifoQty::
                where('Store',$store)
                    ->where('Product',$product)
                    ->where('PPP_Code',$code)
                    ->where('id','!=',$id)
                    ->where('Purchases_Date','>',$Purchases_Date)
                    ->first();


                if(empty($fifo)){

                    $fifo =FifoQty::
                    where('Store',$store)
                        ->where('Product',$product)
                        ->where('PPPP_Code',$code)
                        ->where('id','!=',$id)
                        ->where('Purchases_Date','>',$Purchases_Date)
                        ->first();

                }

            }

        }

        if(!empty($fifo)){


            if($fifo->Qty == 0){



                $Quntatity=$this->FindQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);


                if($Quntatity == 0){


                    $Quntatity=$this->FindQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);


                }else{



                    if($Quntatity >= $Qty){

                        $totCost += $fifo->Cost_Price * $Qty ;

                    }else{

                        $res=$Qty - $Quntatity ;


                        $totCost += $fifo->Cost_Price * $Quntatity ;

                        $ResdiualCost=$this->MoreThanQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$res);

                        $totCost +=$ResdiualCost;

                    }


                }



            }else{


                if($fifo->Qty >= $Qty){

                    $totCost += $fifo->Cost_Price * $Qty ;

                }else{

                    $res=$Qty - $fifo->Qty ;


                    $totCost += $fifo->Cost_Price * $fifo->Qty ;

                    $ResdiualCost=$this->MoreThanQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$res);

                    $totCost +=$ResdiualCost;

                }



            }


        }

        return  $totCost  ;


    }


    public function FifoStoreQty($store,$product,$code,$id,$Purchases_Date,$Qty,$Unit,$SalesID){

        $fifo =FifoQty::
        where('Store',$store)
            ->where('Product',$product)
            ->where('P_Code',$code)
            ->where('id','!=',$id)
            ->where('Purchases_Date','>',$Purchases_Date)
            ->first();

        if(empty($fifo)){

            $fifo =FifoQty::
            where('Store',$store)
                ->where('Product',$product)
                ->where('PP_Code',$code)
                ->where('id','!=',$id)
                ->where('Purchases_Date','>',$Purchases_Date)
                ->first();

            if(empty($fifo)){

                $fifo =FifoQty::
                where('Store',$store)
                    ->where('Product',$product)
                    ->where('PPP_Code',$code)
                    ->where('id','!=',$id)
                    ->where('Purchases_Date','>',$Purchases_Date)
                    ->first();


                if(empty($fifo)){

                    $fifo =FifoQty::
                    where('Store',$store)
                        ->where('Product',$product)
                        ->where('PPPP_Code',$code)
                        ->where('id','!=',$id)
                        ->where('Purchases_Date','>',$Purchases_Date)
                        ->first();

                }

            }

        }



        if(!empty($fifo)){

            if($fifo->Qty >= $Qty){


                $unit=ProductUnits::where('Unit',$Unit)->where('Product',$product)->first();

                $qq= $unit->Rate * $Qty ;

                $newqty=$fifo->Qty -  $qq ;

                FifoQty::where('id',$fifo->id)->update(['Qty'=>$newqty]);


                $fifQty['Sales_Qty']=$Qty;
                $fifQty['Sales_ID']=$SalesID;
                $fifQty['Fifo_ID']=$fifo->id;
                $fifQty['Store']=$fifo->Store;
                $fifQty['Product']=$fifo->Product;
                $fifQty['Cost_Price']=$fifo->Cost_Price;
                $fifQty['Purchases_Date']=$fifo->Purchases_Date;

                SalesFifoQty::create($fifQty);




            }else{


                $resdiualQty=$Qty - $fifo->Qty ;

                $unit=ProductUnits::where('Unit',$Unit)->where('Product',$product)->first();

                $qq= $unit->Rate * $fifo->Qty ;

                $newqty=$fifo->Qty -  $qq ;

                FifoQty::where('id',$fifo->id)->update(['Qty'=>$newqty]);


                $fifQty['Sales_Qty']=$fifo->Qty;
                $fifQty['Sales_ID']=$SalesID;
                $fifQty['Fifo_ID']=$fifo->id;
                $fifQty['Store']=$fifo->Store;
                $fifQty['Product']=$fifo->Product;
                $fifQty['Cost_Price']=$fifo->Cost_Price;
                $fifQty['Purchases_Date']=$fifo->Purchases_Date;

                SalesFifoQty::create($fifQty);





                $ResdiualCost=$this->FifoStoreQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$resdiualQty,$Unit,$SalesID);





            }


        }



        return  $newqty  ;


    }
    public function FifoStoreHoldQty($store,$product,$code,$id,$Purchases_Date,$Qty,$Unit,$SalesID){

        $fifo =FifoQty::
        where('Store',$store)
            ->where('Product',$product)
            ->where('P_Code',$code)
            ->where('id','!=',$id)
            ->where('Purchases_Date','>',$Purchases_Date)
            ->first();

        if(empty($fifo)){

            $fifo =FifoQty::
            where('Store',$store)
                ->where('Product',$product)
                ->where('PP_Code',$code)
                ->where('id','!=',$id)
                ->where('Purchases_Date','>',$Purchases_Date)
                ->first();

            if(empty($fifo)){

                $fifo =FifoQty::
                where('Store',$store)
                    ->where('Product',$product)
                    ->where('PPP_Code',$code)
                    ->where('id','!=',$id)
                    ->where('Purchases_Date','>',$Purchases_Date)
                    ->first();


                if(empty($fifo)){

                    $fifo =FifoQty::
                    where('Store',$store)
                        ->where('Product',$product)
                        ->where('PPPP_Code',$code)
                        ->where('id','!=',$id)
                        ->where('Purchases_Date','>',$Purchases_Date)
                        ->first();

                }

            }

        }



        if(!empty($fifo)){

            if($fifo->Qty >= $Qty){


                $unit=ProductUnits::where('Unit',$Unit)->where('Product',$product)->first();

                $qq= $unit->Rate * $Qty ;

                $newqty=$fifo->Qty -  $qq ;

                $hold_qty_fifo = $fifo->Hold_Qty + $qq;

                FifoQty::where('id', $fifo->id)->update(['Qty' => $newqty,'Hold_Qty'=>$hold_qty_fifo]);



            }else{


                $resdiualQty=$Qty - $fifo->Qty ;

                $unit=ProductUnits::where('Unit',$Unit)->where('Product',$product)->first();

                $qq= $unit->Rate * $fifo->Qty ;

                $newqty=$fifo->Qty -  $qq ;



                $hold_qty_fifo = $fifo->Hold_Qty + $qq;

                FifoQty::where('id', $fifo->id)->update(['Qty' => $newqty,'Hold_Qty'=>$hold_qty_fifo]);


                $ResdiualCost=$this->FifoStoreHoldQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$resdiualQty,$Unit,$SalesID);





            }


        }



        return  $newqty  ;


    }



    public function FifoStoreAssemblyQty($store,$product,$code,$id,$Purchases_Date,$Qty,$Unit,$AssQty,$SalesID){

        $fifo =FifoQty::
        where('Store',$store)
            ->where('Product',$product)
            ->where('P_Code',$code)
            ->where('id','!=',$id)
            ->where('Purchases_Date','>',$Purchases_Date)
            ->first();

        if(empty($fifo)){

            $fifo =FifoQty::
            where('Store',$store)
                ->where('Product',$product)
                ->where('PP_Code',$code)
                ->where('id','!=',$id)
                ->where('Purchases_Date','>',$Purchases_Date)
                ->first();

            if(empty($fifo)){

                $fifo =FifoQty::
                where('Store',$store)
                    ->where('Product',$product)
                    ->where('PPP_Code',$code)
                    ->where('id','!=',$id)
                    ->where('Purchases_Date','>',$Purchases_Date)
                    ->first();


                if(empty($fifo)){

                    $fifo =FifoQty::
                    where('Store',$store)
                        ->where('Product',$product)
                        ->where('PPPP_Code',$code)
                        ->where('id','!=',$id)
                        ->where('Purchases_Date','>',$Purchases_Date)
                        ->first();

                }

            }

        }



        if(!empty($fifo)){

            if($fifo->Qty >= ($Qty * $AssQty) ){


                $unit=ProductUnits::where('Unit',$Unit)->where('Product',$product)->first();

                $qq= $unit->Rate * ($Qty * $AssQty) ;

                $newqty=$fifo->Qty -  $qq ;

                FifoQty::where('id',$fifo->id)->update(['Qty'=>$newqty]);



                $fifQty['Sales_Qty']=($Qty * $AssQty);
                $fifQty['Sales_ID']=$SalesID;
                $fifQty['Fifo_ID']=$fifo->id;
                $fifQty['Store']=$fifo->Store;
                $fifQty['Product']=$fifo->Product;
                $fifQty['Cost_Price']=$fifo->Cost_Price;
                $fifQty['Purchases_Date']=$fifo->Purchases_Date;

                SalesFifoQty::create($fifQty);

            }else{


                $resdiualQty=($Qty * $AssQty)  - $fifo->Qty ;

                $unit=ProductUnits::where('Unit',$Unit)->where('Product',$product)->first();

                $qq= $unit->Rate * ($fifo->Qty  * $AssQty);

                $newqty=$fifo->Qty -  $qq ;

                FifoQty::where('id',$fifo->id)->update(['Qty'=>$newqty]);


                $fifQty['Sales_Qty']=$fifo->Qty;
                $fifQty['Sales_ID']=$SalesID;
                $fifQty['Fifo_ID']=$fifo->id;
                $fifQty['Store']=$fifo->Store;
                $fifQty['Product']=$fifo->Product;
                $fifQty['Cost_Price']=$fifo->Cost_Price;
                $fifQty['Purchases_Date']=$fifo->Purchases_Date;

                SalesFifoQty::create($fifQty);

                $ResdiualCost=$this->FifoStoreAssemblyQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$resdiualQty,$Unit,$AssQty,$SalesID);



            }


        }



        return  $newqty  ;


    }


    public function FifoStoreAssemblyHoldQty($store,$product,$code,$id,$Purchases_Date,$Qty,$Unit,$AssQty,$SalesID){

        $fifo =FifoQty::
        where('Store',$store)
            ->where('Product',$product)
            ->where('P_Code',$code)
            ->where('id','!=',$id)
            ->where('Purchases_Date','>',$Purchases_Date)
            ->first();

        if(empty($fifo)){

            $fifo =FifoQty::
            where('Store',$store)
                ->where('Product',$product)
                ->where('PP_Code',$code)
                ->where('id','!=',$id)
                ->where('Purchases_Date','>',$Purchases_Date)
                ->first();

            if(empty($fifo)){

                $fifo =FifoQty::
                where('Store',$store)
                    ->where('Product',$product)
                    ->where('PPP_Code',$code)
                    ->where('id','!=',$id)
                    ->where('Purchases_Date','>',$Purchases_Date)
                    ->first();


                if(empty($fifo)){

                    $fifo =FifoQty::
                    where('Store',$store)
                        ->where('Product',$product)
                        ->where('PPPP_Code',$code)
                        ->where('id','!=',$id)
                        ->where('Purchases_Date','>',$Purchases_Date)
                        ->first();

                }

            }

        }



        if(!empty($fifo)){

            if($fifo->Qty >= ($Qty * $AssQty) ){


                $unit=ProductUnits::where('Unit',$Unit)->where('Product',$product)->first();

                $qq= $unit->Rate * ($Qty * $AssQty) ;

                $newqty=$fifo->Qty -  $qq ;

                $hold_qty_fifo = $fifo->Hold_Qty + $qq;

                FifoQty::where('id', $fifo->id)->update(['Qty' => $newqty,'Hold_Qty'=>$hold_qty_fifo]);



            }else{


                $resdiualQty=($Qty * $AssQty)  - $fifo->Qty ;

                $unit=ProductUnits::where('Unit',$Unit)->where('Product',$product)->first();

                $qq= $unit->Rate * ($fifo->Qty  * $AssQty);

                $newqty=$fifo->Qty -  $qq ;

                $hold_qty_fifo = $fifo->Hold_Qty + $qq;

                FifoQty::where('id', $fifo->id)->update(['Qty' => $newqty,'Hold_Qty'=>$hold_qty_fifo]);




                $ResdiualCost=$this->FifoStoreAssemblyHoldQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$resdiualQty,$Unit,$AssQty,$SalesID);



            }


        }



        return  $newqty  ;


    }




    //======================================================================

    //Manfacturing Filter =======================================

    public function FilterManuProduct($search)
    {


        $DefSHOW=DefaultDataShowHide::orderBy('id','desc')->first();
        if($DefSHOW->Search_Typical ==  0){

            $data = ProductUnits::query()->whereRelation('Product', 'Status', 0)
                ->whereIn('P_Type',['Completed','Raw','Industrial','Service'])

                ->when(!is_numeric($search), function ($query) use ($search) {
                    return  $query->whereRelation('Product','P_Ar_Name','ILIKE', "%{$search}%")
                        ->orWhereRelation('Product','P_En_Name','ILIKE', "%{$search}%");

                })

                ->when(is_numeric($search), function ($query) use ($search) {
                    return  $query->where('Barcode','ILIKE', "%{$search}%") ;
                })


                ->limit(100)

                ->get();



        }else{

            $data =ProductUnits::whereRelation('Product', 'Status', 0)
                ->whereIn('P_Type',['Completed','Raw','Industrial','Service'])

                ->when(!is_numeric($search), function ($query) use ($search) {
                    return  $query->whereRelation('Product','P_Ar_Name', $search)
                        ->orWhereRelation('Product','P_En_Name', $search);

                })

                ->when(is_numeric($search), function ($query) use ($search) {
                    return  $query->where('Barcode', $search) ;
                })




                ->limit(100)
                ->get();





        }


        return $data ;

    }



    //Total Profit
    public function TOTALPROFIT($from,$to)
    {
        $AEryd=AcccountingManual::where('id',18)->first();


        if($AEryd->Parent == 0){

            $words=$AEryd->Code.'0';
            $wordsX=$AEryd->Code.'1';

        }else{

            $words=$AEryd->Code;
            $wordsX=$AEryd->Code;

        }

        $egmalymby3atDa2n=GeneralDaily::where('Account',48)
            ->whereBetween('Date', [$from, $to])
            ->get()->sum('Creditor_Coin');
        $egmalymby3atMadeen=GeneralDaily::where('Account',48)
            ->whereBetween('Date', [$from, $to])
            ->get()->sum('Debitor_Coin');

        $egmalymrdodatDa2n=GeneralDaily::where('Account',49)
            ->whereBetween('Date', [$from, $to])
            ->get()->sum('Creditor_Coin');

        $egmalymrdodatMadeen=GeneralDaily::where('Account',49)
            ->whereBetween('Date', [$from, $to])
            ->get()->sum('Debitor_Coin');

        $safy = abs($egmalymby3atDa2n - $egmalymby3atMadeen) -  abs($egmalymrdodatDa2n - $egmalymrdodatMadeen);


        $TotalDebErydat = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $words.'%')
            ->orWhere('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredErydat = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to)  {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $words.'%')
            ->orWhere('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');


        $EgmalyErydaat=  $TotalCredErydat -  $TotalDebErydat ;



        $ATaklfa=AcccountingManual::where('id',19)->first();

        if($ATaklfa->Parent == 0){

            $wordss=$ATaklfa->Code.'0';
            $wordssX=$ATaklfa->Code.'1';

        }else{

            $wordss=$ATaklfa->Code;
            $wordssX=$ATaklfa->Code;

        }

        $TotalDebTaklfa = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to)  {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordss.'%')
            ->orWhere('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredTaklfa = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to)  {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordss.'%')
            ->orWhere('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');


        $EgmalyTaklfa=  $TotalDebTaklfa -  $TotalCredTaklfa ;



        $Mogml = $EgmalyErydaat   -  $EgmalyTaklfa   ;


        $AMsrfoat=AcccountingManual::where('id',20)->first();

        if($AMsrfoat->Parent == 0){

            $wordsss=$AMsrfoat->Code.'0';
            $wordsssX=$AMsrfoat->Code.'1';

        }else{

            $wordsss=$AMsrfoat->Code;
            $wordsssX=$AMsrfoat->Code;


        }



        if(app()->getLocale() == 'ar' ){
            $xxxName=$AMsrfoat->Name;

        }else{
            $xxxName=$AMsrfoat->NameEn;

        }

        $TotalDebMasrofat = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to)  {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->orWhere('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofat = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to)  {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->orWhere('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');


        $EgmalyMasrofat=  $TotalDebMasrofat -  $TotalCredMasrofat ;


        $fg= $EgmalyTaklfa + $EgmalyMasrofat;
        if($EgmalyErydaat >  $fg){
            if($fg  <  0 ){

                $SafyRab7 =$EgmalyErydaat + ($EgmalyTaklfa  +   $EgmalyMasrofat)  ;
            }else{

                $SafyRab7 = $EgmalyErydaat -  ($EgmalyTaklfa  +   $EgmalyMasrofat)  ;

            }
        }elseif($EgmalyErydaat <  $fg){

            if($fg  <  0 ){

                $SafyRab7 =$EgmalyErydaat + ($EgmalyTaklfa  +   $EgmalyMasrofat)  ;
            }else{

                $SafyRab7 = $EgmalyErydaat -  ($EgmalyTaklfa  +   $EgmalyMasrofat)  ;

            }


        }elseif($EgmalyErydaat ==  $fg){

            $SafyRab7 = $EgmalyErydaat -  ($EgmalyTaklfa  +   $EgmalyMasrofat)  ;

        }



        return $SafyRab7 ;

    }


    //Total Capital
    public function TOTALCAPITAL()
    {

        $to=date('Y-m-d');
        //   =============  Asoul Sabta   ===========
        $ASabta=AcccountingManual::where('id',21)->first();
        if($ASabta->Parent == 0){

            $wordsSabta=$ASabta->Code.'0';

        }else{

            $wordsSabta=$ASabta->Code;

        }

        $TotalDebAsoulSabta = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($to) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsSabta.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredAsoulSabta = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($to) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsSabta.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');


        $EgmalyAsoulSabta=$TotalDebAsoulSabta - $TotalCredAsoulSabta ;


        //   End Asoul Sabta ====================================


        //   =============  Asoul Mtdawla   ===========

        $Amtdawla=AcccountingManual::where('id',22)->first();

        if($Amtdawla->Parent == 0){

            $wordsMtdawla=$Amtdawla->Code.'0';

        }else{

            $wordsMtdawla=$Amtdawla->Code;

        }

        $TotalDebAsoulMtadawla = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($to) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsMtdawla.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredAsoulMtadawla = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($to) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsMtdawla.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyAsoulMtadawla=$TotalDebAsoulMtadawla - $TotalCredAsoulMtadawla ;

        //   End Asoul Mtdawla  ====================================


        //   =============  Asoul Okhra   ===========

        $AOther=AcccountingManual::where('id',147)->first();

        if($AOther->Parent == 0){

            $wordsOther=$AOther->Code.'0';

        }else{

            $wordsOther=$AOther->Code;

        }


        $TotalDebAsoulOkhraa = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($to) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsOther.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredAsoulOkhraa = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($to) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsOther.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyAsoulOkhraa=$TotalDebAsoulOkhraa - $TotalCredAsoulOkhraa ;

        //   End Asoul Okhra  ====================================

        //  Asoul  ======================================
        $EgmalyAsoul=$EgmalyAsoulSabta + $EgmalyAsoulMtadawla + $EgmalyAsoulOkhraa ;

        //  Asoul End ======================================


        //  Khsoum  =========================


        $ATaklfa=AcccountingManual::where('id',16)->first();

        if($ATaklfa->Parent == 0){

            $wordss=$ATaklfa->Code.'0';

        }else{

            $wordss=$ATaklfa->Code;

        }




        $TotalDebKhsoum = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($to) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredKhsoum = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($to) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyKhsoum= $TotalCredKhsoum  - $TotalDebKhsoum ;


        // End  Khsoum  =========================


        //  Khsoum Tawela  =========================

        $ATaklfaTweel=AcccountingManual::where('id',148)->first();

        if($ATaklfaTweel->Parent == 0){

            $wordssTweel=$ATaklfaTweel->Code.'0';

        }else{

            $wordssTweel=$ATaklfaTweel->Code;

        }


        $TotalDebKhsoumTweel = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($to) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssTweel.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredKhsoumTweel = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($to) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssTweel.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyKhsoumTweel= $TotalCredKhsoumTweel  - $TotalDebKhsoumTweel ;

        //  End Khsoum Tweel ========================

        //   Khsoum Qaserr ========================

        $EgmalyKhsoumQaserr= $EgmalyKhsoum -  $EgmalyKhsoumTweel;

        //  End Khsoum Qaserr ========================

        //  Ras Mal #aml + Estsmar ========================

        $RasMal3aml=$EgmalyAsoulMtadawla - $EgmalyKhsoumQaserr;


        $Estsmar=$RasMal3aml + $EgmalyAsoulSabta + $EgmalyAsoulOkhraa ;

        // End  Ras Mal #aml + Estsmar ========================


        $data=['capital'=>$RasMal3aml , 'invest'=>$Estsmar ];
        return $data ;

    }
    public function NEWTOTALCAPITAL($from,$to)
    {


        //   =============  Asoul Sabta   ===========
        $ASabta=AcccountingManual::where('id',21)->first();
        if($ASabta->Parent == 0){

            $wordsSabta=$ASabta->Code.'0';

        }else{

            $wordsSabta=$ASabta->Code;

        }

        $TotalDebAsoulSabta = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsSabta.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredAsoulSabta = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                      ->whereBetween('general_dailies.Date', [$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsSabta.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');


        $EgmalyAsoulSabta=$TotalDebAsoulSabta - $TotalCredAsoulSabta ;


        //   End Asoul Sabta ====================================


        //   =============  Asoul Mtdawla   ===========

        $Amtdawla=AcccountingManual::where('id',22)->first();

        if($Amtdawla->Parent == 0){

            $wordsMtdawla=$Amtdawla->Code.'0';

        }else{

            $wordsMtdawla=$Amtdawla->Code;

        }

        $TotalDebAsoulMtadawla = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsMtdawla.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredAsoulMtadawla = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                      ->whereBetween('general_dailies.Date', [$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsMtdawla.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyAsoulMtadawla=$TotalDebAsoulMtadawla - $TotalCredAsoulMtadawla ;

        //   End Asoul Mtdawla  ====================================


        //   =============  Asoul Okhra   ===========

        $AOther=AcccountingManual::where('id',147)->first();

        if($AOther->Parent == 0){

            $wordsOther=$AOther->Code.'0';

        }else{

            $wordsOther=$AOther->Code;

        }


        $TotalDebAsoulOkhraa = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                      ->whereBetween('general_dailies.Date', [$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsOther.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredAsoulOkhraa = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsOther.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyAsoulOkhraa=$TotalDebAsoulOkhraa - $TotalCredAsoulOkhraa ;

        //   End Asoul Okhra  ====================================

        //  Asoul  ======================================
        $EgmalyAsoul=$EgmalyAsoulSabta + $EgmalyAsoulMtadawla + $EgmalyAsoulOkhraa ;

        //  Asoul End ======================================


        //  Khsoum  =========================


        $ATaklfa=AcccountingManual::where('id',16)->first();

        if($ATaklfa->Parent == 0){

            $wordss=$ATaklfa->Code.'0';

        }else{

            $wordss=$ATaklfa->Code;

        }




        $TotalDebKhsoum = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                   ->whereBetween('general_dailies.Date', [$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredKhsoum = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                     ->whereBetween('general_dailies.Date', [$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyKhsoum= $TotalCredKhsoum  - $TotalDebKhsoum ;


        // End  Khsoum  =========================


        //  Khsoum Tawela  =========================

        $ATaklfaTweel=AcccountingManual::where('id',148)->first();

        if($ATaklfaTweel->Parent == 0){

            $wordssTweel=$ATaklfaTweel->Code.'0';

        }else{

            $wordssTweel=$ATaklfaTweel->Code;

        }


        $TotalDebKhsoumTweel = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                      ->whereBetween('general_dailies.Date', [$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssTweel.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredKhsoumTweel = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) use ($from,$to) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                      ->whereBetween('general_dailies.Date', [$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssTweel.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyKhsoumTweel= $TotalCredKhsoumTweel  - $TotalDebKhsoumTweel ;

        //  End Khsoum Tweel ========================

        //   Khsoum Qaserr ========================

        $EgmalyKhsoumQaserr= $EgmalyKhsoum -  $EgmalyKhsoumTweel;

        //  End Khsoum Qaserr ========================

        //  Ras Mal #aml + Estsmar ========================

        $RasMal3aml=$EgmalyAsoulMtadawla - $EgmalyKhsoumQaserr;


        $Estsmar=$RasMal3aml + $EgmalyAsoulSabta + $EgmalyAsoulOkhraa ;

        // End  Ras Mal #aml + Estsmar ========================


        $data=['capital'=>$RasMal3aml , 'invest'=>$Estsmar ];
        return $data ;

    }



//Api =========================================================

    public function getCurrentLang()
    {
        return app()->getLocale();
    }

    public function returnError($msg)
    {
        return response()->json([
            'status' => 404,
            'msg' => $msg
        ]);
    }
    public function returnErrorKey($msg,$key)
    {
        return response()->json([
            'status' => 404,
            'msg' => $msg,
            $key => false
        ]);
    }


    public function returnSuccessMessage($msg = "")
    {
        return [
            'status' => 200,
            'msg' => $msg
        ];
    }

    public function returnData($key, $value, $msg = "")
    {
        return response()->json([
            'status' => 200,
            'msg' => $msg,
            $key => $value
        ]);
    }
    public function returnDataLocation($key, $value, $msg = "",$open)
    {
        return response()->json([
            'status' => 200,
            'msg' => $msg,
            $key => $value,
            'open' => $open,
        ]);
    }

    public function returnValidationError($code, $validator)
    {
        return $this->returnError($validator->errors()->first());
    }

    public function returnCodeAccordingToInput($validator)
    {
        $inputs = array_keys($validator->errors()->toArray());
        $code =0;
        return $code;
    }
    //========================================================


}
