<?php

namespace App\Services;
use App\Models\Products;
use App\Models\ProductSalesOrder;
use App\Models\ProductsConsists;
use App\Models\ProductsStartPeriods;
use App\Models\PurchasesDefaultData;
use App\Models\Admin;
use App\Models\GeneralDaily;
use App\Models\PurchasesOrder;
use App\Models\Purchases;
use App\Models\SalesDefaultData;
use App\Models\SubVirables;
use App\Models\Vendors;
use App\Services\Average;
use App\Traits\GeneralTrait;
use App\Models\DefaultDataShowHide;
use App\Models\Taxes;
use App\Models\Stores;
use App\Models\ProductUnits;
use App\Models\ProductsPurchases;
use App\Models\ProductsQty;
use App\Models\Measuerments;
use App\Models\StoreCount;
use App\Models\StoresDefaultData;
use App\Models\ExpireDateQty;
use App\Models\FifoQty;
use App\Models\ProductMoves;
use App\Models\ProductsPurchasesOrder;
use App\Models\ProductsShortcomings;
use App\Models\Shortcomings;
use DB;

class StoresService
{
    use GeneralTrait;


    //Start Period
    public function ItemsFilter($Filter)
    {

        $output = '';

        $average = new Average;

        $show = DefaultDataShowHide::orderBy('id', 'desc')->first();

        $st = Stores::find($Filter['store']);

        $units = ProductUnits::where('Product', $Filter['product'])->get();


        $search=$Filter['search'];
        if(is_numeric($search)){


            $rr = ProductUnits::where('Product', $Filter['product'])->where('Barcode', $search)->first();
        }else {
            $rr = ProductUnits::where('Product', $Filter['product'])->where('Def', 1)->first();
        }





        if ($show->Expire_Date == 1) {

            $EXPIRE = '<td><input type="date" id="ExpDate' . $Filter['product'] . '" class="form-control"> </td>';
        } else {

            $EXPIRE = '<input type="hidden" id="ExpDate' . $Filter['product'] . '" class="form-control">';
        }



        $pr = $average->AverageCostGetUnit($Filter['product'], $rr->Barcode, $Filter['store'],$rr->Unit);



        if (!empty($rr->Product()->first()->Brand)) {
            if (app()->getLocale() == 'ar') {
                $brandd = $rr->Product()->first()->Brand()->first()->Name;
            } else {
                $brandd = $rr->Product()->first()->Brand()->first()->NameEn;
            }

        } else {

            $brandd = "";

        }

        if ($show->Group_Brand == 1) {

            if (app()->getLocale() == 'ar') {
                $ShowGrBr = '(' . $brandd . ') (' . $rr->Product()->first()->Group()->first()->Name . ')';
            } else {

                $ShowGrBr = '(' . $brandd . ') (' . $rr->Product()->first()->Group()->first()->NameEn . ')';
            }

        } else {
            $ShowGrBr = '';
        }


        // 1 Complited  2 serial  3 single  4 double

        if ($Filter['type'] == 1) {

            $funUnit = 'onchange="UnitCodeStart(' . $Filter['product'] . ')"';
            $funTotal = 'onkeyup="StartTotal(' . $Filter['product'] . ')" onclick="StartTotal(' . $Filter['product'] . ')"';
            $funAdd = 'onclick="Fun(' . $Filter['product'] . ')"';

        } elseif ($Filter['type'] == 2) {

            $funUnit = 'onchange="UnitCodeStart(' . $Filter['product'] . ')"';
            $funTotal = 'onkeyup="StartTotal(' . $Filter['product'] . ')" onclick="StartTotal(' . $Filter['product'] . ')"';
            $funAdd = 'onclick="FunSerial(' . $Filter['product'] . ')"';

        } elseif ($Filter['type'] == 3) {

            $funUnit = 'onchange="UnitCodeStart(' . $Filter['product'] . ')"';
            $funTotal = 'onkeyup="StartTotal(' . $Filter['product'] . ')" onclick="StartTotal(' . $Filter['product'] . ')"';
            $funAdd = 'onclick="FunV(' . $Filter['product'] . ')"';

        } elseif ($Filter['type'] == 4) {

            $funUnit = 'onchange="UnitCodeStart(' . $Filter['product'] . ')"';
            $funTotal = 'onkeyup="StartTotal(' . $Filter['product'] . ')" onclick="StartTotal(' . $Filter['product'] . ')"';
            $funAdd = 'onclick="FunVV(' . $Filter['product'] . ')"';

        }

        $output .= '

       <tr id="Row' . $Filter['product'] . '">
        <td>
        ' . $Filter['PrrroName'] . ' ' . $ShowGrBr . '
 <input type="hidden"  id="P_Ar_Name' . $Filter['product'] . '" value="' . $Filter['name_ar'] . '">
        <input type="hidden"  id="P_En_Name' . $Filter['product'] . '" value="' . $Filter['name_en'] . '">
        <input type="hidden"  id="Product' . $Filter['product'] . '" value="' . $Filter['product'] . '">
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitStart' . $Filter['product'] . '" ' . $funUnit . '>
                <option value="">  ' . trans('admin.Choice_Unit') . '</option>
              ';

        foreach ($units as $uni) {
            $nam = Measuerments::find($uni->Unit);

            if (app()->getLocale() == 'ar') {
                $UnitNamme = $nam->Name;
            } else {

                $UnitNamme = $nam->NameEn;
            }
            $output .= '
            <option value="' . $uni->Unit . '"       ';
            if ($rr->Unit == $uni->Unit) {
                $output .= '  selected  ';
            }
            $output .= ' > ' . $UnitNamme . '</option>
                 ';


        }

        $output .= '

                        </select>
        </td>
        <td>
         <input type="text" id="CodeStart' . $Filter['product'] . '" class="form-control" value="' . $rr->Barcode . '"  disabled>
         <input type="hidden" id="UnitStartName' . $Filter['product'] . '" value="' . $Filter['UniiName'] . '">

        </td>

        <td>
        <input type="number" step="any" id="Qty' . $Filter['product'] . '"   class="form-control" ' . $funTotal . ' >

        </td>

              <td>

 <input type="number" step="any" id="Price' . $Filter['product'] . '" step="any"  class="form-control" ' . $funTotal . '" value="' . $pr . '"  >

        </td>


              <td>

  <input type="text" id="Total'.$Filter['product'].'"   class="form-control" disabled>
        </td>


       ' . $EXPIRE . '


        <td>

 <button type="button" class="btn btn-default waves-effect waves-themed" style="display:none" id="AddBtnPur' . $Filter['product'] . '" ' . $funAdd . ' >
          <i class="fal fa-plus"></i>
          </button>

          </td>
        </tr>


            ';



        return $output;

    }


public  function CreateNewStart($request)
{


    $s=Stores::find($request['Store']);
    $ID = DB::table('start_periods')->insertGetId(

        array(


            'Date' => $request['Date'],
            'Store' => $request['Store'],
            'Draw' => $request['Draw'],
            'Note' => $request['Note'],
            'Total_Products' => $request['TotalProducts'],
            'Total_Qty' => $request['TotalQty'],
            'Total_Price' => $request['TotalPrice'],
            'Coin' => $request['Coin'],
            'Time' =>date("h:i:s a", time()),
            'Branch' => $s->Branch,
            'User' => auth()->guard('admin')->user()->id,


        )
    );



    return $ID ;

}


    //Remove Qties
    public function RemoveQties($id, $type, $new_code)
    {

        $Products = ProductsStartPeriods::where('SP_ID', $id)->get();

        $def = StoresDefaultData::orderBy('id', 'desc')->first();

        foreach ($Products as $prod) {

            $unit = ProductUnits::where('Unit', $prod->Unit)->where('Product', $prod->Product)->first();

            $qq = $unit->Rate * $prod->Qty;
            $PR = $this->ProAvQties($prod->Store, $prod->Product, $prod->P_Code);

            if (!empty($PR)) {

                $newqty = $PR->Qty - $qq;
                ProductsQty::where('id', $PR->id)->update(['Qty' => $newqty]);

            }

            if (!empty($prod->Exp_Date)) {

                $PREX = $this->ExpireAvQtiesCheck($prod->Store, $prod->Product, $prod->P_Code, $prod->Exp_Date);

                if (!empty($PREX)) {

                    $newqtyEX = $PREX->Qty - $qq;
                    ExpireDateQty::where('id', $PREX->id)->update(['Qty' => $newqtyEX]);

                }

            }


            //Fifo

            if ($def->Cost_Price == 2) {


                $fifo = $this->FifoAvQty($prod->Store, $prod->Product, $prod->P_Code, $prod->Date);

                if (!empty($fifo)) {

                    $newqtyFifo = $fifo->Qty - $qq;
                    FifoQty::where('id', $fifo->id)->update(['Qty' => $newqtyFifo]);


                }


            }


            if ($type == 1) {
                ProductMoves::where('Type','بدايه فتره')
                    ->where('Product', $prod->Product)
                    ->where('P_Code', $prod->P_Code)
                    ->where('Bill_Num', $prod->SP_ID()->first()->Code)
                    ->update(['Delete' => 1]);

            } else {

                ProductMoves::where('Type','بدايه فتره')
                    ->where('Product', $prod->Product)
                    ->where('P_Code', $prod->P_Code)
                    ->where('Bill_Num', $prod->SP_ID()->first()->Code)
                    ->update(['Edit' => 1, 'Edit_New_Code' => $new_code]);


            }


        }

    }



    //Inventory
    public function ItemsFilterInventory($Filter)
    {

        $output = '';

        $average = new Average;
        $service = new SalesService;


        $showw=DefaultDataShowHide::orderBy('id','desc')->first();
        $st = Stores::find($Filter['store']);
        $TAXESS = Taxes::all();
        $Stores = Stores::all();
        $units = ProductUnits::where('Product', $Filter['product'])->get();


        $search=$Filter['search'];
        if(is_numeric($search)){


            $rr = ProductUnits::where('Product', $Filter['product'])->where('Barcode', $search)->first();
        }else {
            $rr = ProductUnits::where('Product', $Filter['product'])->where('Def', 1)->first();
        }


        $plow = ProductUnits::where('Product', $Filter['product'])->where('Rate', 1)->first();




        $ShowGrBr=$Filter['ShowGrBr'];
        $PrrroName=$Filter['PrrroName'];
        $UniiName=$Filter['UniiName'];
        $StoreNemo=$Filter['StoreNemo'];



        $EXPOOOs=ExpireDateQty::orderBy('id','desc')->where('Product',$Filter['product'])->where('Store',$Filter['store'])->where('P_Code',$Filter['P_Code'])->get();
        $EXPIRE='';
        if($showw->Expire_Date == 1){

            if(!empty($EXPOOOs)){

                $EXPPPP=ExpireDateQty::orderBy('id','desc')->where('Product',$Filter['product'])->where('Store',$Filter['store'])->where('P_Code',$Filter['P_Code'])->first();
                if(!empty($EXPPPP)){
                    $Exxxxx=$EXPPPP->id;
                }else{
                    $Exxxxx=1;
                }

            }else{
                $Exxxxx=1;
            }


            $EXPIRE='<td>
             <select class="select2 form-control w-100"   id="ExpDate'.$Filter['id'].'" onchange="ExpDateQty('.$Filter['id'].')">
                <option value="">'.trans('admin.Choice_Date').'</option>
              ';

            foreach($EXPOOOs as $exx){


                $EXPIRE .= '
            <option value="'.$exx->id.'"       ';  if($exx->id == $Exxxxx){    $EXPIRE .= '  selected  ';  }   $EXPIRE .= ' > '.$exx->Exp_Date.'</option>
                 ';


            }

            $EXPIRE .= '

                        </select>
        </td>';
        }else{

            $EXPIRE='<input type="hidden" id="ExpDate'.$Filter['id'].'"   class="form-control">';
        }


        if(!empty($Filter['Exp_Date'])){


            $PREX=$this->ExpireAvQtiesCheck($Filter['store'],$Filter['product'],$Filter['P_Code'],$Filter['Exp_Date']);

            if(!empty($PREX)){
                $AvalibleQunatity=$PREX->Qty / $rr->Rate;
            }else{

                $AvalibleQunatity=$Filter['qty'] / $rr->Rate;
            }


        }else{

            $AvalibleQunatity=$Filter['qty']/ $rr->Rate;

        }




        $Ser=ProductSalesOrder::where('Product',$Filter['product'])->where('Product_Code',$Filter['P_Code'])->first();


        // 1 Complited  2 serial  3 single  4 double

        if ($Filter['type'] == 1) {

            $funUnit = 'onchange="UnitCodeStartt(' . $Filter['id'] . ')"';


        } else{

            $funUnit = 'onchange="UnitCodeStart(' . $Filter['id'] . ')"';
        }

        //lw hw serial
        if(empty($Ser)){
        }



            if($Filter['store']  ==  $Filter['pro_store']) {
                $output .= '

       <tr id="Row' . $Filter['id'] . '">
        <td>
        ' . $PrrroName . ' ' . $ShowGrBr . '  ('.$Filter['v_name'] .')  ('.$Filter['vv_name'] .')
 <input type="hidden"  id="P_Ar_Name' . $Filter['id'] . '" value="' . $Filter['name_ar'] . '">
        <input type="hidden"  id="P_En_Name' . $Filter['id'] . '" value="' . $Filter['name_en'] . '">
        <input type="hidden"  id="Product' . $Filter['id'] . '" value="' . $Filter['product'] . '">
        <input type="hidden"  id="VOne' . $Filter['id'] . '" value="' . $Filter['v1'] . '">
        <input type="hidden"  id="VTwo' . $Filter['id'] . '" value="' . $Filter['v2'] . '">
        <input type="hidden"  id="V_Name' . $Filter['id'] . '" value="' . $Filter['v_name'] . '">
        <input type="hidden"  id="VV_Name' . $Filter['id'] . '" value="' . $Filter['vv_name'] . '">

        </td>




        <td>
             <select class="select2 form-control w-100"   id="UnitStart' . $Filter['id'] . '" ' . $funUnit . '>
                <option value="">' . trans('admin.Choice_Unit') . '</option>
              ';

                foreach ($units as $uni) {
                    $nam = Measuerments::find($uni->Unit);


                    if (app()->getLocale() == 'ar') {
                        $UnitNamme = $nam->Name;
                    } else {

                        $UnitNamme = $nam->NameEn;
                    }
                    $output .= '
            <option value="' . $uni->Unit . '"       ';
                    if ($rr->Unit == $uni->Unit) {
                        $output .= '  selected  ';
                    }
                    $output .= ' > ' . $UnitNamme . '</option>
                 ';


                }

                $output .= '

                        </select>
        </td>
        <td>
         <input type="text" id="CodeStart' . $Filter['id'] . '" class="form-control" value="' . $Filter['P_Code'] . '"  disabled>
         <input type="hidden" id="UnitStartName' . $Filter['id'] . '" value="' . $UniiName . '">

        </td>


              <td>


 <input type="number" id="Price'.$Filter['id'].'" step="any"  class="form-control" value="'.$Filter['Price'].'"  onkeyup="Inventory('.$Filter['id'] .')" onclick="Inventory('.$Filter['id'] .')">
 <input type="hidden" id="PRORATE'.$Filter['id'].'" value="'.$rr->Rate.'" >

        </td>


       ' . $EXPIRE . '

                   <td>

            <input type="text" class="form-control" id="Qty' . $Filter['id'] . '" value="' . $AvalibleQunatity . '" disabled >

            </td>




   <td style=" width:100px">
        <input type="number" id="Inventory'.$Filter['id'] .'" step="any"   class="form-control" onkeyup="Inventory('.$Filter['id'] .')" onclick="Inventory('.$Filter['id'] .')" >

        </td>

              <td style=" width:100px">

  <input type="text" id="Dificit'.$Filter['id'] .'"   class="form-control" disabled>
  <input type="hidden" id="TotalDificit'.$Filter['id'] .'">

        </td>

          <td style=" width:100px">
       <input type="text" id="Excess'.$Filter['id'] .'"   class="form-control" disabled>
     <input type="hidden" id="TotalExcess'.$Filter['id'] .'">
          </td>



        <td>

 <button type="button" class="btn btn-default waves-effect waves-themed" style="display:none" id="AddBtnPur' . $Filter['id'] . '" onclick="Fun(' . $Filter['id'] . ')">
          <i class="fal fa-plus"></i>
          </button>



          </td>
        </tr>


            ';




            }


        return $output;

    }




    //Stores Transfer

    public function ShowHideColumn($TypeTransfer,$OtherType,$Product,$id,$Tostore,$store)
    {

        $show=DefaultDataShowHide::latest('id')->first();
        $average = new Average;
        $Def=StoresDefaultData::orderBy('id','desc')->first();
        $plow = ProductUnits::where('Product', $Product)->where('Rate', 1)->first();
        $rr = ProductUnits::where('Product', $Product)->where('Def', 1)->first();
        if(auth()->guard('admin')->user()->emp != 0){

            if(auth()->guard('admin')->user()->cost_price  == 1){

                $CP='block';
            }else{

                $CP='none';

            }


        }else{

            // $this->authorize('السعر في تحويلات المخازن');
            if(auth()->guard('admin')->user()->can('السعر في تحويلات المخازن')){
                $CP='block';
            }else{
                $CP='none';
            }

        }



        if($Def->StoresTarnsferPrice == 0){

            $p='disabled';
        }elseif($Def->StoresTarnsferPrice == 1){

            $p='';
        }




        if(auth()->guard('admin')->user()->emp != 0){

            if(auth()->guard('admin')->user()->price_1 == 1){

                $parO='block';
            }else{

                $parO='none';
            }

            if(auth()->guard('admin')->user()->price_2 == 1){

                $parOO='block';
            }else{

                $parOO='none';
            }

            if(auth()->guard('admin')->user()->price_2 == 1){

                $parOOO='block';
            }else{

                $parOOO='none';
            }

        }else{
            $parO='block';
            $parOO='block';
            $parOOO='block';
        }


            if($TypeTransfer != ''){


                if($TypeTransfer == 1){

                    //Sale
                    $OLDDPrice=$average->AverageCostGetUnit($Product,$plow->Barcode,$store,$plow->Unit);
                    $Price=$rr->Price ;
                    $button='<button type="button" class="btn btn-default" data-toggle="modal" data-target="#dollar'.$id.'">
    <i class="fal fa-dollar-sign"></i>
    </button>';

                }else{



                    if($OtherType == 1){
                        //Cost from
                        $Price=$average->AverageCostGetUnit($Product,$rr->Barcode,$store,$rr->Unit);
                        $OLDDPrice=0;
                        $button='';
                    }else {


                        //Cost to
                        $Price=$average->AverageCostGetUnit($Product,$rr->Barcode,$Tostore,$rr->Unit);
                        $OLDDPrice=0;
                        $button='';



                    }



                }




            }else{


                if ($Def->StoresTarnsferPrice == 0) {
                    //Cost
                    $Price = $average->AverageCostGetUnit($Product,$rr->Barcode,$store,$rr->Unit);
                    $OLDDPrice = 0;
                    $button = '';
                } elseif ($Def->StoresTarnsferPrice == 1) {
                    //Sale
                    $OLDDPrice = $average->AverageCostGetUnit($Product,$rr->Barcode,$store,$rr->Unit);
                    $Price = $rr->Price;
                    $button = '<button type="button" class="btn btn-default" data-toggle="modal" data-target="#dollar' . $id . '">
    <i class="fal fa-dollar-sign"></i>
    </button>';
                }




            }


            $proCostPrice=$average->AverageCostGetUnit($Product,$rr->Barcode,$store,$rr->Unit);


    $data=[
            'CP'=>$CP,
            'p'=>$p,
            'parO'=>$parO,
            'parOO'=>$parOO,
            'parOOO'=>$parOOO,
            'proCostPrice'=>$proCostPrice,
            'Price'=>$Price,
            'OLDDPrice'=>$OLDDPrice,
            'button'=>$button,


        ];

        return $data;

    }



    public function ItemsFilterStoresTransfer($Filter)
    {

        $output = '';

        $average = new Average;

        $showw=DefaultDataShowHide::orderBy('id','desc')->first();
        $st = Stores::find($Filter['store']);
        $units = ProductUnits::where('Product', $Filter['product'])->get();
        $search=$Filter['search'];
        if(is_numeric($search)){


            $rr = ProductUnits::where('Product', $Filter['product'])->where('Barcode', $search)->first();
        }else {
            $rr = ProductUnits::where('Product', $Filter['product'])->where('Def', 1)->first();
        }

        $plow = ProductUnits::where('Product', $Filter['product'])->where('Rate', 1)->first();



        $ShowGrBr=$Filter['ShowGrBr'];
        $PrrroName=$Filter['PrrroName'];
        $UniiName=$Filter['UniiName'];
        $StoreNemo=$Filter['StoreNemo'];
        $TypeTransfer=$Filter['TypeTransfer'];
        $OtherType=$Filter['OtherType'];
        $Tostore=$Filter['Tostore'];
        $store=$Filter['store'];


        $hide=$this->ShowHideColumn($TypeTransfer,$OtherType,$Filter['product'],$Filter['id'],$Tostore,$store);
        $CP=$hide['CP'];
        $p=$hide['p'];
        $parO=$hide['parO'];
        $parOO=$hide['parOO'];
        $parOOO=$hide['parOOO'];
        $proCostPrice=$hide['proCostPrice'];
        $Price=$hide['Price'];
        $OLDDPrice=$hide['OLDDPrice'];
        $button=$hide['button'];






        $EXPOOOs=ExpireDateQty::orderBy('id','desc')->where('Product',$Filter['product'])->where('Store',$Filter['store'])->where('P_Code',$Filter['P_Code'])->get();
        $EXPIRE='';
        if($showw->Expire_Date == 1){

            if(!empty($EXPOOOs)){

                $EXPPPP=ExpireDateQty::orderBy('id','desc')->where('Product',$Filter['product'])->where('Store',$Filter['store'])->where('P_Code',$Filter['P_Code'])->first();
                if(!empty($EXPPPP)){
                    $Exxxxx=$EXPPPP->id;
                }else{
                    $Exxxxx=1;
                }

            }else{
                $Exxxxx=1;
            }


            $EXPIRE='<td>
             <select class="select2 form-control w-100"   id="ExpDate'.$Filter['id'].'" onchange="ExpDateQty('.$Filter['id'].')">
                <option value="">'.trans('admin.Choice_Date').'</option>
              ';

            foreach($EXPOOOs as $exx){


                $EXPIRE .= '
            <option value="'.$exx->id.'"       ';  if($exx->id == $Exxxxx){    $EXPIRE .= '  selected  ';  }   $EXPIRE .= ' > '.$exx->Exp_Date.'</option>
                 ';


            }

            $EXPIRE .= '

                        </select>
        </td>';
        }else{

            $EXPIRE='<input type="hidden" id="ExpDate'.$Filter['id'].'"   class="form-control">';
        }


        if(!empty($Filter['Exp_Date'])){


            $PREX=$this->ExpireAvQtiesCheck($Filter['store'],$Filter['product'],$Filter['P_Code'],$Filter['Exp_Date']);

            if(!empty($PREX)){
                $AvalibleQunatity=$PREX->Qty / $rr->Rate;
            }else{

                $AvalibleQunatity=$Filter['qty'] / $rr->Rate;
            }


        }else{

            $AvalibleQunatity=$Filter['qty']/ $rr->Rate;

        }


        $Ser=ProductSalesOrder::where('Product',$Filter['product'])->where('Product_Code',$Filter['P_Code'])->first();


        // 1 Complited  2 serial  3 single  4 double

        if ($Filter['type'] == 1) {

            $funUnit = 'onchange="UnitCodeStartt(' . $Filter['id'] . ')"';


        } else{

            $funUnit = 'onchange="UnitCodeStart(' . $Filter['id'] . ')"';
        }

        //lw hw serial
        if(empty($Ser)){
        }


if($AvalibleQunatity > 0){
        if($Filter['store']  ==  $Filter['pro_store']) {
            $output .= '

       <tr id="Row' . $Filter['id'] . '">
        <td>
        ' . $PrrroName . ' ' . $ShowGrBr . '  (' . $Filter['v_name'] . ')  (' . $Filter['vv_name'] . ')
 <input type="hidden"  id="P_Ar_Name' . $Filter['id'] . '" value="' . $Filter['name_ar'] . '">
        <input type="hidden"  id="P_En_Name' . $Filter['id'] . '" value="' . $Filter['name_en'] . '">
        <input type="hidden"  id="Product' . $Filter['id'] . '" value="' . $Filter['product'] . '">
        <input type="hidden"  id="VOne' . $Filter['id'] . '" value="' . $Filter['v1'] . '">
        <input type="hidden"  id="VTwo' . $Filter['id'] . '" value="' . $Filter['v2'] . '">
        <input type="hidden"  id="V_Name' . $Filter['id'] . '" value="' . $Filter['v_name'] . '">
        <input type="hidden"  id="VV_Name' . $Filter['id'] . '" value="' . $Filter['vv_name'] . '">

        </td>




        <td>
             <select class="select2 form-control w-100"   id="UnitStart' . $Filter['id'] . '" ' . $funUnit . '>
                <option value="">' . trans('admin.Choice_Unit') . '</option>
              ';

            foreach ($units as $uni) {
                $nam = Measuerments::find($uni->Unit);


                if (app()->getLocale() == 'ar') {
                    $UnitNamme = $nam->Name;
                } else {

                    $UnitNamme = $nam->NameEn;
                }
                $output .= '
            <option value="' . $uni->Unit . '"       ';
                if ($rr->Unit == $uni->Unit) {
                    $output .= '  selected  ';
                }
                $output .= ' > ' . $UnitNamme . '</option>
                 ';


            }

            $output .= '

                        </select>
        </td>
        <td>
         <input type="text" id="CodeStart' . $Filter['id'] . '" class="form-control" value="' . $Filter['P_Code'] . '"  disabled>
         <input type="hidden" id="UnitStartName' . $Filter['id'] . '" value="' . $UniiName . '">

        </td>


             <td style="display:'.$CP.'">


 <input type="number" '.$p.' id="Price' . $Filter['id'] . '" step="any"  class="form-control" value="' . $Price . '" onkeyup="Totaal('.$Filter['id'].')" onclick="Totaal('.$Filter['id'].')"  >
  <input type="hidden" id="OldPrice'.$Filter['id'].'" value="'.$OLDDPrice.'">
  <input type="hidden" id="CostPrice'.$Filter['id'].'" value="'.$proCostPrice.'">
 <input type="hidden" id="PRORATE' . $Filter['id'] . '" value="' . $rr->Rate . '" >

        </td>


       ' . $EXPIRE . '

                   <td>

            <input type="text" class="form-control" id="Qty' . $Filter['id'] . '" value="' . $AvalibleQunatity . '" disabled >

            </td>




          <td>
        <input type="number" id="Trans_Qty'.$Filter['id'].'" step="any"   class="form-control" onkeyup="Totaal('.$Filter['id'].')" onclick="Totaal('.$Filter['id'].')" >
        <input type="hidden"  id="TotalPrice'.$Filter['id'].'">
        </td>



        <td>

 <button type="button" class="btn btn-default waves-effect waves-themed" style="display:none" id="AddBtnPur' . $Filter['id'] . '" onclick="Fun(' . $Filter['id'] . ')">
          <i class="fal fa-plus"></i>
          </button>



    '.$button.'
        <div class="modal fade" id="dollar'.$Filter['id'].'" tabindex="-1" role="dialog"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                       '.trans('admin.Price').'
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">
                        <div class="mt-3">
                            <table id="" class="table table-bordered table-hover table-striped w-100">
                            <thead>
                                <tr>
                                    <th>  '.trans('admin.Price_One').' </th>
                                    <th>  '.trans('admin.Price_Two').' </th>
                                    <th>  '.trans('admin.Price_Three').' </th>
                                </tr>
                            </thead>
                            <tbody id="">
                                <tr>

                                     <td>
                   <button style="display:'.$parO.'" type="button" class="btn btn-default" onclick="ChangePriceU('.$Filter['id'].')">
           <input type="text" class="form-control" id="UnitPriceOne'.$Filter['id'].'" disabled value="'.$rr->Price.'">
           </button>

                                </td>
                                <td>
                    <button type="button" style="display:'.$parOO.'" class="btn btn-default" onclick="ChangePriceUU('.$Filter['id'].')">
            <input type="text" class="form-control" id="UnitPriceTwo'.$Filter['id'].'" disabled value="'.$rr->Price_Two.'">                 </button>
                                </td>
                                     <td>
                  <button type="button"  style="display:'.$parOOO.'" class="btn btn-default" onclick="ChangePriceUUU('.$Filter['id'].')">
        <input type="text" class="form-control" id="UnitPriceThree'.$Filter['id'].'" disabled value="'.$rr->Price_Three.'">                        </button>
                                     </td>

                                </tr>
                            </tbody>
                        </table>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">
                            <i class="fal fa-times"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            </div>




          </td>
        </tr>


            ';

        }


        }


        return $output;

    }


    //Consist
    public function ItemsFilterConsist($Filter)
    {

        $output = '';

        $average = new Average;
        $service = new SalesService;


        $showw=DefaultDataShowHide::orderBy('id','desc')->first();
        $st = Stores::find($Filter['store']);
        $TAXESS = Taxes::all();
        $Stores = Stores::all();
        $units = ProductUnits::where('Product', $Filter['product'])->get();
        $search=$Filter['search'];
        if(is_numeric($search)){


            $rr = ProductUnits::where('Product', $Filter['product'])->where('Barcode', $search)->first();
        }else {
            $rr = ProductUnits::where('Product', $Filter['product'])->where('Def', 1)->first();
        }


        $plow = ProductUnits::where('Product', $Filter['product'])->where('Rate', 1)->first();




        $ShowGrBr=$Filter['ShowGrBr'];
        $PrrroName=$Filter['PrrroName'];
        $UniiName=$Filter['UniiName'];
        $StoreNemo=$Filter['StoreNemo'];



        $EXPOOOs=ExpireDateQty::orderBy('id','desc')->where('Product',$Filter['product'])->where('Store',$Filter['store'])->where('P_Code',$Filter['P_Code'])->get();
        $EXPIRE='';
        if($showw->Expire_Date == 1){

            if(!empty($EXPOOOs)){

                $EXPPPP=ExpireDateQty::orderBy('id','desc')->where('Product',$Filter['product'])->where('Store',$Filter['store'])->where('P_Code',$Filter['P_Code'])->first();
                if(!empty($EXPPPP)){
                    $Exxxxx=$EXPPPP->id;
                }else{
                    $Exxxxx=1;
                }

            }else{
                $Exxxxx=1;
            }


            $EXPIRE='<td>
             <select class="select2 form-control w-100"   id="ExpDate'.$Filter['id'].'" onchange="ExpDateQty('.$Filter['id'].')">
                <option value="">'.trans('admin.Choice_Date').'</option>
              ';

            foreach($EXPOOOs as $exx){


                $EXPIRE .= '
            <option value="'.$exx->id.'"       ';  if($exx->id == $Exxxxx){    $EXPIRE .= '  selected  ';  }   $EXPIRE .= ' > '.$exx->Exp_Date.'</option>
                 ';


            }

            $EXPIRE .= '

                        </select>
        </td>';
        }else{

            $EXPIRE='<input type="hidden" id="ExpDate'.$Filter['id'].'"   class="form-control">';
        }


        if(!empty($Filter['Exp_Date'])){


            $PREX=$this->ExpireAvQtiesCheck($Filter['store'],$Filter['product'],$Filter['P_Code'],$Filter['Exp_Date']);

            if(!empty($PREX)){
                $AvalibleQunatity=$PREX->Qty / $rr->Rate;
            }else{

                $AvalibleQunatity=$Filter['qty'] / $rr->Rate;
            }


        }else{

            $AvalibleQunatity=$Filter['qty']/ $rr->Rate;

        }




        $Ser=ProductSalesOrder::where('Product',$Filter['product'])->where('Product_Code',$Filter['P_Code'])->first();


        // 1 Complited  2 serial  3 single  4 double

        if ($Filter['type'] == 1) {

            $funUnit = 'onchange="UnitCodeStartt(' . $Filter['id'] . ')"';


        } else{

            $funUnit = 'onchange="UnitCodeStart(' . $Filter['id'] . ')"';
        }

        //lw hw serial
        if(empty($Ser)){
        }



            if($Filter['store']  ==  $Filter['pro_store']) {
                $output .= '

       <tr id="Row' . $Filter['id'] . '">
        <td>
        ' . $PrrroName . ' ' . $ShowGrBr . '  ('.$Filter['v_name'] .')  ('.$Filter['vv_name'] .')
 <input type="hidden"  id="P_Ar_Name' . $Filter['id'] . '" value="' . $Filter['name_ar'] . '">
        <input type="hidden"  id="P_En_Name' . $Filter['id'] . '" value="' . $Filter['name_en'] . '">
        <input type="hidden"  id="Product' . $Filter['id'] . '" value="' . $Filter['product'] . '">
        <input type="hidden"  id="VOne' . $Filter['id'] . '" value="' . $Filter['v1'] . '">
        <input type="hidden"  id="VTwo' . $Filter['id'] . '" value="' . $Filter['v2'] . '">
        <input type="hidden"  id="V_Name' . $Filter['id'] . '" value="' . $Filter['v_name'] . '">
        <input type="hidden"  id="VV_Name' . $Filter['id'] . '" value="' . $Filter['vv_name'] . '">

        </td>




        <td>
             <select class="select2 form-control w-100"   id="UnitStart' . $Filter['id'] . '" ' . $funUnit . '>
                <option value="">' . trans('admin.Choice_Unit') . '</option>
              ';

                foreach ($units as $uni) {
                    $nam = Measuerments::find($uni->Unit);


                    if (app()->getLocale() == 'ar') {
                        $UnitNamme = $nam->Name;
                    } else {

                        $UnitNamme = $nam->NameEn;
                    }
                    $output .= '
            <option value="' . $uni->Unit . '"       ';
                    if ($rr->Unit == $uni->Unit) {
                        $output .= '  selected  ';
                    }
                    $output .= ' > ' . $UnitNamme . '</option>
                 ';


                }

                $output .= '

                        </select>
        </td>
        <td>
         <input type="text" id="CodeStart' . $Filter['id'] . '" class="form-control" value="' . $Filter['P_Code'] . '"  disabled>
         <input type="hidden" id="UnitStartName' . $Filter['id'] . '" value="' . $UniiName . '">

        </td>


         <td>

            <input type="text" class="form-control" id="Qty' . $Filter['id'] . '" value="' . $AvalibleQunatity . '" disabled >

            </td>

<td><input type="number" id="Cosist'.$Filter['id'].'" step="any"   class="form-control" onkeyup="Inventory('.$Filter['id'].')" onclick="Inventory('.$Filter['id'].')" ></td>

              <td>


 <input type="number" id="Price'.$Filter['id'].'" step="any"  class="form-control" value="'.$Filter['Price'].'" onkeyup="Inventory('.$Filter['id'].')" onclick="Inventory('.$Filter['id'].')" >
 <input type="hidden" id="PRORATE'.$Filter['id'].'" value="'.$rr->Rate.'" >

        </td>



              <td>

  <input type="text" id="Total'.$Filter['id'].'"   class="form-control" disabled>


        </td>

       ' . $EXPIRE . '


        <td>

 <button type="button" class="btn btn-default waves-effect waves-themed" style="display:none" id="AddBtnPur' . $Filter['id'] . '" onclick="Fun(' . $Filter['id'] . ')">
          <i class="fal fa-plus"></i>
          </button>



          </td>
        </tr>


            ';



            }


        return $output;

    }


//RemoveQtiesConsisit
    public function RemoveQtiesConsisit($id)
    {

        $Products=ProductsConsists::where('Consist_ID',$id)->get();
        $def = StoresDefaultData::orderBy('id', 'desc')->first();


        foreach($Products as $prod){

            if($prod->Product()->first()->P_Type != 'Service' or $prod->Product()->first()->P_Type != 'Assembly'){

                $unit=ProductUnits::where('Unit',$prod->Unit)->where('Product',$prod->Product)->first();

                $qq= $unit->Rate * $prod->Qty ;

                $PR = $this->ProAvQties($prod->Consist_ID()->first()->Store, $prod->Product, $prod->Product_Code);

                if(!empty($PR)){
                    $newqty=$PR->Qty + $qq ;

                    ProductsQty::where('id',$PR->id)->update(['Qty'=>$newqty]);

                }



                if(!empty($prod->Exp_Date)){

                    $unit=ProductUnits::where('Unit',$prod->Unit)->where('Product',$prod->Product)->first();
                    $qq= $unit->Rate *  $prod->Qty;
                    $EXPO=ExpireDateQty::find($prod->Exp_Date);
                    $NewExpQty=$EXPO->Qty +  $qq ;
                    ExpireDateQty::where('id',$prod->Exp_Date)->update(['Qty'=>$NewExpQty]);


                }



                if ($def->Cost_Price == 2) {


                    $fifo = $this->FifoAvQty($prod->Consist_ID()->first()->Store, $prod->Product, $prod->Product_Code,$prod->Consist_ID()->first()->Date);

                    if (!empty($fifo)) {

                        $newqtyFifo = $fifo->Qty + $qq;
                        FifoQty::where('id', $fifo->id)->update(['Qty' => $newqtyFifo]);


                    }


                }



                    ProductMoves::where('Type', 'توالف')
                        ->where('Product', $prod->Product)
                        ->where('P_Code', $prod->Product_Code)
                        ->where('Bill_Num', $prod->Consist_ID()->first()->Code)
                        ->update(['Delete' => 1]);


            }
        }


    }



    //ItemsFilterExchange
    public function ItemsFilterExchange($Filter)
    {

        $output = '';

        $average = new Average;
        $showe=DefaultDataShowHide::orderBy('id','desc')->first();
        $Def=SalesDefaultData::orderBy('id','desc')->first();
        $units=ProductUnits::where('Product',$Filter['product'])->get();
        $search=$Filter['search'];
        if(is_numeric($search)){


            $rr = ProductUnits::where('Product', $Filter['product'])->where('Barcode', $search)->first();
        }else {
            $rr = ProductUnits::where('Product', $Filter['product'])->where('Def', 1)->first();
        }



        $Stores=Stores::all();
        $cost = $average->AverageCostGetUnit($Filter['product'], $rr->Barcode, $Filter['store'],$rr->Unit);

        $PrrroName=$Filter['PrrroName'];
$UniiName=$Filter['UniiName'];
$StoreNemo=$Filter['StoreNemo'];
        $store=$Filter['store'];
        $pr= $rr->Price ;
        $st=Stores::find($Filter['store']);

        if($Def->Price_Sale == 0){
            $show='disabled';
        }else{

            $show='';
        }



        if ($showe->Expire_Date == 1) {

            $EXPIRE = '<td><input type="date" id="ExpDate' . $Filter['id'] . '" class="form-control"> </td>';
        } else {

            $EXPIRE = '<input type="hidden" id="ExpDate' . $Filter['id'] . '" class="form-control">';
        }




        // 1 Complited  2 serial  3 single  4 double

        if ($Filter['type'] == 1) {

            $funUnit = 'onchange="UnitCodePurchh(' . $Filter['id'] . ')"';
            $funTotal = 'onkeyup="PurchTotal(' . $Filter['id'] . ')" onclick="PurchTotal(' . $Filter['id'] . ')"';
            $funAdd = 'onclick="Fun(' . $Filter['id'] . ')"';

        } elseif ($Filter['type'] == 2) {

            $funUnit = 'onchange="UnitCodePurch(' . $Filter['id'] . ')"';
            $funTotal = 'onkeyup="PurchTotal(' . $Filter['id'] . ')" onclick="PurchTotal(' . $Filter['id'] . ')"';
            $funAdd = 'onclick="Fun(' . $Filter['id'] . ')"';

        } elseif ($Filter['type'] == 3) {

            $funUnit = 'onchange="UnitCodePurch(' . $Filter['id'] . ')"';
            $funTotal = 'onkeyup="PurchTotal(' . $Filter['id'] . ')" onclick="PurchTotal(' . $Filter['id'] . ')"';
            $funAdd = 'onclick="Fun(' . $Filter['id'] . ')"';

        } elseif ($Filter['type'] == 4) {

            $funUnit = 'onchange="UnitCodePurch(' . $Filter['id'] . ')"';
            $funTotal = 'onkeyup="PurchTotal(' . $Filter['id'] . ')" onclick="PurchTotal(' . $Filter['id'] . ')"';
            $funAdd = 'onclick="Fun(' . $Filter['id'] . ')"';

        }


        $llo='

 <input type="hidden" id="Price'.$Filter['id'].'" step="any"  class="form-control" '.$funTotal.' value="'.$pr.'" '.$show.' >

 <input type="hidden" id="Discount'.$Filter['id'].'" step="any"  class="form-control"  value="0" >
 <input type="hidden" id="Cost'.$Filter['id'].'" step="any"  class="form-control"  value="'.$cost.'" >
<input type="hidden" id="TotalBFTax'.$Filter['id'].'"   class="form-control" >
<input type="hidden" id="Tax'.$Filter['id'].'"   class="form-control" >
  <input type="hidden" id="Total'.$Filter['id'].'"   class="form-control" >

' ;


        $output .= '

       <tr id="Row'.$Filter['id'].'">
        <td>
        '.$PrrroName.'
 <input type="hidden"  id="P_Ar_Name'.$Filter['id'].'" value="'.$Filter['name_ar'].'">
        <input type="hidden"  id="P_En_Name'.$Filter['id'].'" value="'.$Filter['name_en'].'">
        <input type="hidden"  id="Product'.$Filter['id'].'" value="'.$Filter['product'].'">
        <input type="hidden"  id="VOne'.$Filter['id'].'" value="'.$Filter['v1'].'">
        <input type="hidden"  id="VTwo'.$Filter['id'].'" value="'.$Filter['v2'].'">
        <input type="hidden"  id="V_Name'.$Filter['id'].'" value="'.$Filter['v_name'].'">
        <input type="hidden"  id="VV_Name'.$Filter['id'].'" value="'.$Filter['vv_name'].'">
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitPurch'.$Filter['id'].'"  '.$funUnit.'>
                <option value="">  '.trans('admin.Choice_Unit').'</option>
              ';

        foreach($units as $uni){
            $nam=Measuerments::find($uni->Unit);
            if(app()->getLocale() == 'ar' ){
                $UnitNamme=$nam->Name;
            }else{

                $UnitNamme=$nam->NameEn;
            }
            $output .= '
            <option value="'.$uni->Unit.'"       ';  if ($rr->Unit == $uni->Unit) {    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';


        }

        $output .= '

                        </select>
        </td>
        <td>
         <input type="text" id="CodePurch'.$Filter['id'].'" class="form-control" value="'.$Filter['P_Code'].'"  disabled>
         <input type="hidden" id="UnitPurchName'.$Filter['id'].'" value="'.$UniiName.'">
         <input type="hidden" id="TaxRate'.$Filter['id'].'" value="'.$rr->Product()->first()->Tax()->first()->Rate.'">
         <input type="hidden" id="TaxType'.$Filter['id'].'" value="'.$rr->Product()->first()->Tax()->first()->Type.'">
         <input type="hidden" id="PurchTax'.$Filter['id'].'" value="'.$rr->Product()->first()->Tax.'">
        </td>


            <td>

            <input type="text" class="form-control" id="AvQty'.$Filter['id'].'" value="'.$Filter['qty'].'" disabled >

            </td>

        <td>
        <input type="number" id="Qty'.$Filter['id'].'"   class="form-control" '.$funTotal.' >

        </td>

        '.$llo.'


            <td>
   <select class="select2 form-control w-100"   id="StorePurch'.$Filter['id'].'" onchange="StoreNamePurch('.$Filter['id'].')">
              ';

        foreach($Stores as $stor){

            if(app()->getLocale() == 'ar' ){
                $StorNamme=$stor->Name;
            }else{

                $StorNamme=$stor->NameEn;
            }

            $output .= '
      <option value="'.$stor->id.'"       ';  if($stor->id == $store){    $output .= '  selected  ';  }   $output .= ' > '.$StorNamme.'</option>
                 ';
        }

        $output .= '

                        </select>
        </td>


  '.$EXPIRE.'

        <td>
         <input type="hidden" id="StorePurchName'.$Filter['id'].'"   class="form-control"  value="'.$StoreNemo.'" >
 <button type="button" class="btn btn-default waves-effect waves-themed" style="display:none" id="AddBtnPur'.$Filter['id'].'" '.$funAdd.'>
          <i class="fal fa-plus"></i>
          </button>


          </td>
        </tr>


            ';



        return $output;

    }

//ItemsFilterExchangeTwo
    public function ItemsFilterExchangeTwo($Filter)
    {

        $output = '';

        $average = new Average;
        $showe=DefaultDataShowHide::orderBy('id','desc')->first();
        $Def=SalesDefaultData::orderBy('id','desc')->first();
        $units=ProductUnits::where('Product',$Filter['product'])->get();
        $search=$Filter['search'];
        if(is_numeric($search)){


            $rr = ProductUnits::where('Product', $Filter['product'])->where('Barcode', $search)->first();
        }else {
            $rr = ProductUnits::where('Product', $Filter['product'])->where('Def', 1)->first();
        }



        $Stores=Stores::all();
        $cost = $Filter['cost'];

        $PrrroName=$Filter['PrrroName'];
        $UniiName=$Filter['UniiName'];
        $StoreNemo=$Filter['StoreNemo'];
        $store=$Filter['store'];
        $pr= $rr->Price ;
        $st=Stores::find($Filter['store']);

        if($Def->Price_Sale == 0){
            $show='disabled';
        }else{

            $show='';
        }



        if ($showe->Expire_Date == 1) {

            $EXPIRE = '<td><input type="date" id="ExpDate' . $Filter['id'] . '" class="form-control"> </td>';
        } else {

            $EXPIRE = '<input type="hidden" id="ExpDate' . $Filter['id'] . '" class="form-control">';
        }




        // 1 Complited  2 serial  3 single  4 double



            $funUnit = 'onchange="UnitCodePurchh(' . $Filter['id'] . ')"';
            $funTotal = 'onkeyup="PurchTotal(' . $Filter['id'] . ')" onclick="PurchTotal(' . $Filter['id'] . ')"';
            $funAdd = 'onclick="Fun(' . $Filter['id'] . ')"';




        $llo='

 <input type="hidden" id="Price'.$Filter['id'].'" step="any"  class="form-control" '.$funTotal.' value="'.$pr.'" '.$show.' >

 <input type="hidden" id="Discount'.$Filter['id'].'" step="any"  class="form-control"  value="0" >
 <input type="hidden" id="Cost'.$Filter['id'].'" step="any"  class="form-control"  value="'.$cost.'" >
<input type="hidden" id="TotalBFTax'.$Filter['id'].'"   class="form-control" >
<input type="hidden" id="Tax'.$Filter['id'].'"   class="form-control" >
  <input type="hidden" id="Total'.$Filter['id'].'"   class="form-control" >

' ;


        $output .= '

       <tr id="Row'.$Filter['id'].'">
        <td>
        '.$PrrroName.'
 <input type="hidden"  id="P_Ar_Name'.$Filter['id'].'" value="'.$Filter['name_ar'].'">
        <input type="hidden"  id="P_En_Name'.$Filter['id'].'" value="'.$Filter['name_en'].'">
        <input type="hidden"  id="Product'.$Filter['id'].'" value="'.$Filter['product'].'">
        <input type="hidden"  id="VOne'.$Filter['id'].'" value="'.$Filter['v1'].'">
        <input type="hidden"  id="VTwo'.$Filter['id'].'" value="'.$Filter['v2'].'">
        <input type="hidden"  id="V_Name'.$Filter['id'].'" value="'.$Filter['v_name'].'">
        <input type="hidden"  id="VV_Name'.$Filter['id'].'" value="'.$Filter['vv_name'].'">
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitPurch'.$Filter['id'].'"  '.$funUnit.'>
                <option value="">  '.trans('admin.Choice_Unit').'</option>
              ';

        foreach($units as $uni){
            $nam=Measuerments::find($uni->Unit);
            if(app()->getLocale() == 'ar' ){
                $UnitNamme=$nam->Name;
            }else{

                $UnitNamme=$nam->NameEn;
            }
            $output .= '
            <option value="'.$uni->Unit.'"       ';  if ($rr->Unit == $uni->Unit) {    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';


        }

        $output .= '

                        </select>
        </td>
        <td>
         <input type="text" id="CodePurch'.$Filter['id'].'" class="form-control" value="'.$Filter['P_Code'].'"  disabled>
         <input type="hidden" id="UnitPurchName'.$Filter['id'].'" value="'.$UniiName.'">
         <input type="hidden" id="TaxRate'.$Filter['id'].'" value="'.$rr->Product()->first()->Tax()->first()->Rate.'">
         <input type="hidden" id="TaxType'.$Filter['id'].'" value="'.$rr->Product()->first()->Tax()->first()->Type.'">
         <input type="hidden" id="PurchTax'.$Filter['id'].'" value="'.$rr->Product()->first()->Tax.'">
        </td>


            <td>

            <input type="text" class="form-control" id="AvQty'.$Filter['id'].'" value="'.$Filter['qty'].'" disabled >

            </td>

        <td>
        <input type="number" id="Qty'.$Filter['id'].'"   class="form-control" '.$funTotal.' >

        </td>

        '.$llo.'


            <td>
   <select class="select2 form-control w-100"   id="StorePurch'.$Filter['id'].'" onchange="StoreNamePurch('.$Filter['id'].')">
              ';

        foreach($Stores as $stor){

            if(app()->getLocale() == 'ar' ){
                $StorNamme=$stor->Name;
            }else{

                $StorNamme=$stor->NameEn;
            }

            $output .= '
      <option value="'.$stor->id.'"       ';  if($stor->id == $store){    $output .= '  selected  ';  }   $output .= ' > '.$StorNamme.'</option>
                 ';
        }

        $output .= '

                        </select>
        </td>


  '.$EXPIRE.'

        <td>
         <input type="hidden" id="StorePurchName'.$Filter['id'].'"   class="form-control"  value="'.$StoreNemo.'" >
 <button type="button" class="btn btn-default waves-effect waves-themed" style="display:none" id="AddBtnPur'.$Filter['id'].'" '.$funAdd.'>
          <i class="fal fa-plus"></i>
          </button>


          </td>
        </tr>


            ';



        return $output;

    }


    //ItemsFilterRecived
    public function ItemsFilterRecived($Filter)
    {

        $output = '';

        $average = new Average;
        $showe=DefaultDataShowHide::orderBy('id','desc')->first();
        $Def=SalesDefaultData::orderBy('id','desc')->first();
        $units=ProductUnits::where('Product',$Filter['product'])->get();

        $search=$Filter['search'];
        if(is_numeric($search)){


            $rr = ProductUnits::where('Product', $Filter['product'])->where('Barcode', $search)->first();
        }else {
            $rr = ProductUnits::where('Product', $Filter['product'])->where('Def', 1)->first();
        }


        $Stores=Stores::all();


        $PrrroName=$Filter['PrrroName'];
        $UniiName=$Filter['UniiName'];
        $StoreNemo=$Filter['StoreNemo'];
        $store=$Filter['store'];
        $pr= $rr->Price ;
        $st=Stores::find($Filter['store']);

        if($Def->Price_Sale == 0){
            $show='disabled';
        }else{

            $show='';
        }



        if ($showe->Expire_Date == 1) {

            $EXPIRE = '<td><input type="date" id="ExpDate' . $Filter['id'] . '" class="form-control"> </td>';
        } else {

            $EXPIRE = '<input type="hidden" id="ExpDate' . $Filter['id'] . '" class="form-control">';
        }




            $funUnit = 'onchange="UnitCodePurchh(' . $Filter['id'] . ')"';
            $funTotal = 'onkeyup="PurchTotal(' . $Filter['id'] . ')" onclick="PurchTotal(' . $Filter['id'] . ')"';
            $funAdd = 'onclick="Fun(' . $Filter['id'] . ')"';


        $IfQty=$this->ProAvQties($store,$Filter['product'],$rr->Barcode);

        if(!empty($IfQty)){

            $avQty=$IfQty->Qty;
        }else{
            $avQty=0;
        }

        $llo='

 <input type="hidden" id="Price'.$Filter['id'].'" step="any"  class="form-control" '.$funTotal.' value="'.$pr.'" '.$show.' >

 <input type="hidden" id="Discount'.$Filter['id'].'" step="any"  class="form-control"  value="0" >
<input type="hidden" id="TotalBFTax'.$Filter['id'].'"   class="form-control" >
<input type="hidden" id="Tax'.$Filter['id'].'"   class="form-control" >
  <input type="hidden" id="Total'.$Filter['id'].'"   class="form-control" >

' ;


        $output .= '

       <tr id="Row'.$Filter['id'].'">
        <td>
        '.$PrrroName.'
 <input type="hidden"  id="P_Ar_Name'.$Filter['id'].'" value="'.$Filter['name_ar'].'">
        <input type="hidden"  id="P_En_Name'.$Filter['id'].'" value="'.$Filter['name_en'].'">
        <input type="hidden"  id="Product'.$Filter['id'].'" value="'.$Filter['product'].'">
        <input type="hidden"  id="VOne'.$Filter['id'].'" value="">
        <input type="hidden"  id="VTwo'.$Filter['id'].'" value="">
        <input type="hidden"  id="V_Name'.$Filter['id'].'" value="">
        <input type="hidden"  id="VV_Name'.$Filter['id'].'" value="">
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitPurch'.$Filter['id'].'"  '.$funUnit.'>
                <option value="">  '.trans('admin.Choice_Unit').'</option>
              ';

        foreach($units as $uni){
            $nam=Measuerments::find($uni->Unit);
            if(app()->getLocale() == 'ar' ){
                $UnitNamme=$nam->Name;
            }else{

                $UnitNamme=$nam->NameEn;
            }
            $output .= '
            <option value="'.$uni->Unit.'"       ';  if ($rr->Unit == $uni->Unit) {    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';


        }

        $output .= '

                        </select>
        </td>
        <td>
         <input type="text" id="CodePurch'.$Filter['id'].'" class="form-control" value="'.$rr->Barcode.'"  disabled>
         <input type="hidden" id="UnitPurchName'.$Filter['id'].'" value="'.$UniiName.'">
         <input type="hidden" id="TaxRate'.$Filter['id'].'" value="'.$rr->Product()->first()->Tax()->first()->Rate.'">
         <input type="hidden" id="TaxType'.$Filter['id'].'" value="'.$rr->Product()->first()->Tax()->first()->Type.'">
         <input type="hidden" id="PurchTax'.$Filter['id'].'" value="'.$rr->Product()->first()->Tax.'">
           <input type="hidden" class="form-control" id="AvQty'.$Filter['id'].'" value="'.$avQty.'"  >
        </td>




        <td>
        <input type="number" id="Qty'.$Filter['id'].'"   class="form-control" '.$funTotal.' >

        </td>

        '.$llo.'


            <td>
   <select class="select2 form-control w-100"   id="StorePurch'.$Filter['id'].'" onchange="StoreNamePurch('.$Filter['id'].')">
              ';

        foreach($Stores as $stor){

            if(app()->getLocale() == 'ar' ){
                $StorNamme=$stor->Name;
            }else{

                $StorNamme=$stor->NameEn;
            }

            $output .= '
      <option value="'.$stor->id.'"       ';  if($stor->id == $store){    $output .= '  selected  ';  }   $output .= ' > '.$StorNamme.'</option>
                 ';
        }

        $output .= '

                        </select>
        </td>


  '.$EXPIRE.'

        <td>
         <input type="hidden" id="StorePurchName'.$Filter['id'].'"   class="form-control"  value="'.$StoreNemo.'" >
 <button type="button" class="btn btn-default waves-effect waves-themed" style="display:none" id="AddBtnPur'.$Filter['id'].'" '.$funAdd.'>
          <i class="fal fa-plus"></i>
          </button>


          </td>
        </tr>


            ';



        return $output;

    }



}
