<?php

namespace App\Services;
use App\Models\Products;
use App\Models\PurchasesDefaultData;
use App\Models\Admin;
use App\Models\GeneralDaily;
use App\Models\PurchasesOrder;
use App\Models\Purchases;
use App\Models\SubVirables;
use App\Models\Vendors;
use App\Traits\GeneralTrait;
use App\Models\DefaultDataShowHide;
use App\Models\Taxes;
use App\Models\Stores;
use App\Models\ProductUnits;
use App\Models\ProductsPurchases;
use App\Models\ProductsQty;
use App\Models\Measuerments;
use App\Models\StoreCount;
use App\Models\StoresDefaultData;
use App\Models\ExpireDateQty;
use App\Models\FifoQty;
use App\Models\ProductMoves;
use App\Models\ProductsPurchasesOrder;
use App\Models\ProductsShortcomings;
use App\Models\Shortcomings;

use App\Services\Average;
class PurchasesService
{
    use GeneralTrait;

    public function VendorIf($id)
    {


        $del = Vendors::find($id);

        $Purchases = PurchasesDefaultData::latest('id')->first();
        $Admin = Admin::where('emp', $id)->first();
        $xh = GeneralDaily::where('Account', $del->Account)->orderBy('id', 'desc')->first();
        $ord = PurchasesOrder::where('Vendor', $del->Account)->latest('id')->first();
        $Pord = Purchases::where('Vendor', $del->Account)->latest('id')->first();


        if ($Purchases->Vendor == $del->Account) {

            session()->flash('error', trans('admin.Cant_Delete_Default_Data'));
            return 1;

        }


        if (!empty($Admin)) {
            if ($Admin->vend == $id) {

                session()->flash('error', trans('admin.Cant_Delete_User_Admin'));
                return 1;

            }
        }


        if (!empty($xh)) {

            session()->flash('error', trans('admin.CantDeleteAnyItemHasTraffic'));
            return 1;

        }


        if (!empty($ord)) {

            session()->flash('error', trans('admin.CantDeleteAnyItemHasTraffic'));
            return 1;

        }


        if (!empty($Pord)) {

            session()->flash('error', trans('admin.CantDeleteAnyItemHasTraffic'));
            return 1;

        }


        return 0;

    }


    public function ItemsFilter($Filter)
    {

        $output = '';

        $average = new Average;

        $show = DefaultDataShowHide::orderBy('id', 'desc')->first();
        $Def = PurchasesDefaultData::orderBy('id', 'desc')->first();

        if (auth()->guard('admin')->user()->emp != 0) {
            $user = 'disabled';

            if (auth()->guard('admin')->user()->cost_price_purch == 0) {
                $Doollar = 'display: none;';
            } else {
                $Doollar = '';
            }

        } else {
            $user = '';
            $Doollar = '';
        }

        if ($show->Disc == 0) {
            $discShow = 'none';
        } else {
            $discShow = '';
        }

        if ($show->Tax == 0) {
            $taxShow = 'none';
        } else {
            $taxShow = '';
        }

        if ($show->Store == 0) {
            $storeShow = 'none';
        } else {
            $storeShow = '';
        }

        if ($show->Show_Barcode == 0) {
            $BarcodeShow = 'none';
        } else {
            $BarcodeShow = '';
        }

        if ($show->Show_Unit == 0) {
            $UnitShow = 'none';
        } else {
            $UnitShow = '';
        }


        $st = Stores::find($Filter['store']);
        $TAXESS = Taxes::all();
        $Stores = Stores::all();
        $units = ProductUnits::where('Product', $Filter['product'])->get();

$search=$Filter['search'];
        if(is_numeric($search)){


                $rr = ProductUnits::where('Product', $Filter['product'])->where('Barcode', 'like', '%'.$search.'%')->first();
        }else {
            $rr = ProductUnits::where('Product', $Filter['product'])->where('Def', 1)->first();
        }




        $plow = ProductUnits::where('Product', $Filter['product'])->where('Rate', 1)->first();

        if ($show->Expire_Date == 1) {

            $EXPIRE = '<td><input type="date" id="ExpDate' . $Filter['product'] . '" class="form-control"> </td>';
        } else {

            $EXPIRE = '<input type="hidden" id="ExpDate' . $Filter['product'] . '" class="form-control">';
        }

        $lastBill = ProductsPurchases::orderBy('id', 'desc')->where('Product', $Filter['product'])->where('Product_Code', $rr->Barcode)->first();
        $lastBillV = ProductsPurchases::orderBy('id', 'desc')->where('Product', $Filter['product'])->where('Product_Code', $rr->Barcode)->where('Vendor', $Filter['vendor'])->first();
        $qtyOther = ProductsQty::where('Product', $Filter['product'])->where('P_Code', $rr->Barcode)->where('Store', '!=', $Filter['store'])->get()->sum('Qty');

        $pr = $average->AverageCostGetUnit($Filter['product'], $rr->Barcode, $Filter['store'],$rr->Unit);


        if (!empty($lastBill)) {
            $priceone = $lastBill->Price;
        } else {
            $priceone = 0;

        }

        if (!empty($lastBillV)) {
            $pricetwo = $lastBillV->Price;
        } else {
            $pricetwo = 0;

        }


        if (!empty($rr->Product()->first()->Brand)) {
            if (app()->getLocale() == 'ar') {
                $brandd = $rr->Product()->first()->Brand()->first()->Name;
            } else {
                $brandd = $rr->Product()->first()->Brand()->first()->NameEn;
            }

        } else {

            $brandd = "";

        }

        if ($show->Group_Brand == 1) {

            if (app()->getLocale() == 'ar') {
                $ShowGrBr = '(' . $brandd . ') (' . $rr->Product()->first()->Group()->first()->Name . ')';
            } else {

                $ShowGrBr = '(' . $brandd . ') (' . $rr->Product()->first()->Group()->first()->NameEn . ')';
            }

        } else {
            $ShowGrBr = '';
        }


        // 1 Complited  2 serial  3 single  4 double

        if ($Filter['type'] == 1) {

            $funUnit = 'onchange="UnitCodePurchh(' . $Filter['product'] . ')"';
            $funTotal = 'onkeyup="PurchTotal(' . $Filter['product'] . ')" onclick="PurchTotal(' . $Filter['product'] . ')"';
            $funAdd = 'onclick="Fun(' . $Filter['product'] . ')"';

        } elseif ($Filter['type'] == 2) {

            $funUnit = 'onchange="UnitCodePurch(' . $Filter['product'] . ')"';
            $funTotal = 'onkeyup="PurchTotalSerial(' . $Filter['product'] . ')" onclick="PurchTotalSerial(' . $Filter['product'] . ')"';
            $funAdd = 'onclick="FunSerial(' . $Filter['product'] . ')"';

        } elseif ($Filter['type'] == 3) {

            $funUnit = 'onchange="UnitCodePurch(' . $Filter['product'] . ')"';
            $funTotal = 'onkeyup="PurchTotalV(' . $Filter['product'] . ')" onclick="PurchTotalV(' . $Filter['product'] . ')"';
            $funAdd = 'onclick="FunV(' . $Filter['product'] . ')"';

        } elseif ($Filter['type'] == 4) {

            $funUnit = 'onchange="UnitCodePurch(' . $Filter['product'] . ')"';
            $funTotal = 'onkeyup="PurchTotalVV(' . $Filter['product'] . ')" onclick="PurchTotalVV(' . $Filter['product'] . ')"';
            $funAdd = 'onclick="FunVV(' . $Filter['product'] . ')"';

        }





        $output .= '

       <tr id="Row' . $Filter['product'] . '">
        <td>
        ' . $Filter['PrrroName'] . ' ' . $ShowGrBr . '
 <input type="hidden"  id="P_Ar_Name' . $Filter['product'] . '" value="' . $Filter['name_ar'] . '">
        <input type="hidden"  id="P_En_Name' . $Filter['product'] . '" value="' . $Filter['name_en'] . '">
        <input type="hidden"  id="Product' . $Filter['product'] . '" value="' . $Filter['product'] . '">
        </td>

        <td style="display:' . $UnitShow . '">
             <select class="select2 form-control w-100"   id="UnitPurch' . $Filter['product'] . '" ' . $funUnit . '>
                <option value="">  ' . trans('admin.Choice_Unit') . '</option>
              ';

        foreach ($units as $uni) {
            $nam = Measuerments::find($uni->Unit);

            if (app()->getLocale() == 'ar') {
                $UnitNamme = $nam->Name;
            } else {

                $UnitNamme = $nam->NameEn;
            }
            $output .= '
            <option value="' . $uni->Unit . '"       ';
            if ($rr->Unit == $uni->Unit) {
                $output .= '  selected  ';
            }
            $output .= ' > ' . $UnitNamme . '</option>
                 ';


        }

        $output .= '

                        </select>
        </td>


        <td style="display:' . $BarcodeShow . '">
         <input type="text" id="CodePurch' . $Filter['product'] . '" class="form-control" value="' . $rr->Barcode . '"  disabled>
         <input type="hidden" id="UnitPurchName' . $Filter['product'] . '" value="' . $Filter['UniiName'] . '">
         <input type="hidden" id="TaxRate' . $Filter['product'] . '" value="' . $rr->Product()->first()->Tax()->first()->Rate . '">
         <input type="hidden" id="TaxType' . $Filter['product'] . '" value="' . $rr->Product()->first()->Tax()->first()->Type . '">
         <input type="hidden" id="PurchTax' . $Filter['product'] . '" value="' . $rr->Product()->first()->Tax . '">
        </td>

        <td>
        <input type="number" step="any" id="Qty' . $Filter['product'] . '"   class="form-control" ' . $funTotal . ' >

        </td>

              <td>

 <input type="number" id="Price' . $Filter['product'] . '" step="any"  class="form-control" ' . $funTotal . '" value="' . $pr . '"  >
  <input type="hidden"  id="Price_Sale' . $Filter['product'] . '" value="' . $rr->Price . '">
        </td>



                  <td style="display:' . $discShow . '">

 <input type="number" id="Discount' . $Filter['product'] . '" step="any"  class="form-control" ' . $funTotal . ' value="0" >
  <input type="hidden" id="TDiscPro' . $Filter['product'] . '"   class="form-control" value="0" >
<input type="hidden" id="TotalBFTax' . $Filter['product'] . '"   class="form-control" >
<input type="hidden" id="Tax' . $Filter['product'] . '"   class="form-control" >
  <input type="hidden" id="Total' . $Filter['product'] . '"   class="form-control" >
  <input type="hidden" id="TotalNet' . $Filter['product'] . '"   class="form-control" >
        </td>

      <td style="display:' . $taxShow . '">
   <select class="select2 form-control w-100"    id="OLDTAX' . $Filter['product'] . '" onchange="TAXPurch(' . $Filter['product'] . ')">
              ';

        foreach ($TAXESS as $tax) {
            if (app()->getLocale() == 'ar') {
                $txNamme = $tax->Name;
            } else {

                $txNamme = $tax->NameEn;
            }

            $output .= '
      <option value="' . $tax->id . '"       ';
            if ($tax->id == $rr->Product()->first()->Tax) {
                $output .= '  selected  ';
            }
            $output .= ' > ' . $txNamme . '</option>
                 ';
        }

        $output .= '

                        </select>
        </td>

            <td style="display:' . $storeShow . '">
   <select class="select2 form-control w-100" ' . $user . '   id="StorePurch' . $Filter['product'] . '" onchange="StoreNamePurch(' . $Filter['product'] . ')">
              ';

        foreach ($Stores as $stor) {
            if (app()->getLocale() == 'ar') {
                $StorNamme = $stor->Name;
            } else {

                $StorNamme = $stor->NameEn;
            }

            $output .= '
      <option value="' . $stor->id . '"       ';
            if ($stor->id == $Filter['store']) {
                $output .= '  selected  ';
            }
            $output .= ' > ' . $StorNamme . '</option>
                 ';
        }

        $output .= '

                        </select>
        </td>

       ' . $EXPIRE . '


        <td>
           <input type="hidden" id="StorePurchName' . $Filter['product'] . '"   class="form-control"  value="' . $Filter['StoreNemo'] . '" >
 <button type="button" class="btn btn-default waves-effect waves-themed" style="display:none" id="AddBtnPur' . $Filter['product'] . '" ' . $funAdd . ' >
          <i class="fal fa-plus"></i>
          </button>


                 <button type="button" style="' . $Doollar . '" class="btn btn-default" data-toggle="modal" data-target="#dollar' . $Filter['product'] . '">
    <i class="fal fa-dollar-sign"></i>
    </button>


        <div class="modal fade" id="dollar' . $Filter['product'] . '" tabindex="-1" role="dialog"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                               <h4 class="modal-title">
                             ' . trans('admin.Price') . '
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">
                        <div class="mt-3">
                            <table id="" class="table table-bordered table-hover table-striped w-100">
                            <thead>
                                <tr>
                                          <th>   ' . trans('admin.Price_One') . ' </th>
                                    <th>   ' . trans('admin.Price_Two') . ' </th>
                                    <th>   ' . trans('admin.Price_Three') . ' </th>
                                    <th> ' . trans('admin.Price_Last_Purch_Bill') . ' </th>
                                    <th> ' . trans('admin.Price_Last_Purch_Bill_from_this_Vendor') . ' </th>
                                    <th>    ' . trans('admin.Other_Stores_Qty') . ' </th>
                                    <th> ' . trans('admin.Actions') . ' </th>
                                </tr>
                            </thead>
                            <tbody id="">
                                <tr>

                                     <td>

                      <input type="text" id="UnitPriceOne' . $Filter['product'] . '" class="form-control" value="' . $rr->Price . '">
                                </td>
                                <td>
                         <input type="text" id="UnitPriceTwo' . $Filter['product'] . '" class="form-control" value="' . $rr->Price_Two . '">
                                </td>
                                     <td>

                     <input type="text" id="UnitPriceThree' . $Filter['product'] . '" class="form-control" value="' . $rr->Price_Three . '">

                     <input type="hidden" id="UnitPriceID' . $Filter['product'] . '"  value="' . $rr->id . '">
                                     </td>
                                      <td>
                                     ' . $priceone . '
                                     </td>
                                         <td>
                                         ' . $pricetwo . '
                                     </td>

                                         <td>
                                         ' . $qtyOther . '
                                     </td>

    <td>
    <button type="button" onclick="ChangePriceUnit(' . $Filter['product'] . ')" class="btn btn-primary">
    <i class="fal fa-edit"></i>
    </button>
    </td>
                                </tr>
                            </tbody>
                        </table>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">
                            <i class="fal fa-times"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            </div>


          </td>
        </tr>


            ';


        return $output;

    }


    public function ItemsFilterShort($Filter)
    {

        $output = '';

        $average = new Average;

        $show = DefaultDataShowHide::orderBy('id', 'desc')->first();
        $Def = PurchasesDefaultData::orderBy('id', 'desc')->first();

        if (auth()->guard('admin')->user()->emp != 0) {
            $user = 'disabled';

            if (auth()->guard('admin')->user()->cost_price_purch == 0) {
                $Doollar = 'display: none;';
            } else {
                $Doollar = '';
            }

        } else {
            $user = '';
            $Doollar = '';
        }

        if ($show->Disc == 0) {
            $discShow = 'none';
        } else {
            $discShow = '';
        }

        if ($show->Tax == 0) {
            $taxShow = 'none';
        } else {
            $taxShow = '';
        }

        if ($show->Store == 0) {
            $storeShow = 'none';
        } else {
            $storeShow = '';
        }

        if ($show->Show_Barcode == 0) {
            $BarcodeShow = 'none';
        } else {
            $BarcodeShow = '';
        }

        if ($show->Show_Unit == 0) {
            $UnitShow = 'none';
        } else {
            $UnitShow = '';
        }

        $st = Stores::find($Filter['store']);
        $TAXESS = Taxes::all();
        $Stores = Stores::all();
        $units = ProductUnits::where('Product', $Filter['product'])->get();

        $search=$Filter['search'];
        if(is_numeric($search)){
            $rr = ProductUnits::where('Product', $Filter['product'])->where('Barcode', $search)->first();
        }else {
            $rr = ProductUnits::where('Product', $Filter['product'])->where('Def', 1)->first();
        }



        $plow = ProductUnits::where('Product', $Filter['product'])->where('Rate', 1)->first();

        if ($show->Expire_Date == 1) {

            $EXPIRE = '<td><input type="date" id="ExpDate' . $Filter['product'] . '" class="form-control"> </td>';
        } else {

            $EXPIRE = '<input type="hidden" id="ExpDate' . $Filter['product'] . '" class="form-control">';
        }

        $lastBill = ProductsPurchases::orderBy('id', 'desc')->where('Product', $Filter['product'])->where('Product_Code', $rr->Barcode)->first();
        $lastBillV = ProductsPurchases::orderBy('id', 'desc')->where('Product', $Filter['product'])->where('Product_Code', $rr->Barcode)->where('Vendor', $Filter['vendor'])->first();
        $qtyOther = ProductsQty::where('Product', $Filter['product'])->where('P_Code', $rr->Barcode)->where('Store', '!=', $Filter['store'])->get()->sum('Qty');

        $pr = $average->AverageCostGetUnit($Filter['product'], $rr->Barcode, $Filter['store'],$rr->Unit);


        if (!empty($lastBill)) {
            $priceone = $lastBill->Price;
        } else {
            $priceone = 0;

        }

        if (!empty($lastBillV)) {
            $pricetwo = $lastBillV->Price;
        } else {
            $pricetwo = 0;

        }


        if (!empty($rr->Product()->first()->Brand)) {
            if (app()->getLocale() == 'ar') {
                $brandd = $rr->Product()->first()->Brand()->first()->Name;
            } else {
                $brandd = $rr->Product()->first()->Brand()->first()->NameEn;
            }

        } else {

            $brandd = "";

        }

        if ($show->Group_Brand == 1) {

            if (app()->getLocale() == 'ar') {
                $ShowGrBr = '(' . $brandd . ') (' . $rr->Product()->first()->Group()->first()->Name . ')';
            } else {

                $ShowGrBr = '(' . $brandd . ') (' . $rr->Product()->first()->Group()->first()->NameEn . ')';
            }

        } else {
            $ShowGrBr = '';
        }


        // 1 Complited  2 serial  3 single  4 double

        if ($Filter['type'] == 1) {

            $funUnit = 'onchange="UnitCodePurchh(' . $Filter['product'] . ')"';
            $funTotal = 'onkeyup="PurchTotal(' . $Filter['product'] . ')" onclick="PurchTotal(' . $Filter['product'] . ')"';
            $funAdd = 'onclick="Fun(' . $Filter['product'] . ')"';

        } elseif ($Filter['type'] == 2) {

            $funUnit = 'onchange="UnitCodePurch(' . $Filter['product'] . ')"';
            $funTotal = 'onkeyup="PurchTotalSerial(' . $Filter['product'] . ')" onclick="PurchTotalSerial(' . $Filter['product'] . ')"';
            $funAdd = 'onclick="FunSerial(' . $Filter['product'] . ')"';

        } elseif ($Filter['type'] == 3) {

            $funUnit = 'onchange="UnitCodePurch(' . $Filter['product'] . ')"';
            $funTotal = 'onkeyup="PurchTotalV(' . $Filter['product'] . ')" onclick="PurchTotalV(' . $Filter['product'] . ')"';
            $funAdd = 'onclick="FunV(' . $Filter['product'] . ')"';

        } elseif ($Filter['type'] == 4) {

            $funUnit = 'onchange="UnitCodePurch(' . $Filter['product'] . ')"';
            $funTotal = 'onkeyup="PurchTotalVV(' . $Filter['product'] . ')" onclick="PurchTotalVV(' . $Filter['product'] . ')"';
            $funAdd = 'onclick="FunVV(' . $Filter['product'] . ')"';

        }


        $output .= '

       <tr id="Row' . $Filter['product'] . '">
        <td>
        ' . $Filter['PrrroName'] . ' ' . $ShowGrBr . '
 <input type="hidden"  id="P_Ar_Name' . $Filter['product'] . '" value="' . $Filter['name_ar'] . '">
        <input type="hidden"  id="P_En_Name' . $Filter['product'] . '" value="' . $Filter['name_en'] . '">
        <input type="hidden"  id="Product' . $Filter['product'] . '" value="' . $Filter['product'] . '">
        </td>

        <td style="display:' . $UnitShow . '">
             <select class="select2 form-control w-100"   id="UnitPurch' . $Filter['product'] . '" ' . $funUnit . '>
                <option value="">  ' . trans('admin.Choice_Unit') . '</option>
              ';

        foreach ($units as $uni) {
            $nam = Measuerments::find($uni->Unit);

            if (app()->getLocale() == 'ar') {
                $UnitNamme = $nam->Name;
            } else {

                $UnitNamme = $nam->NameEn;
            }
            $output .= '
            <option value="' . $uni->Unit . '"       ';
            if ($rr->Unit == $uni->Unit) {
                $output .= '  selected  ';
            }
            $output .= ' > ' . $UnitNamme . '</option>
                 ';


        }


        $output .= '

                        </select>
        </td>
        <td style="display:' . $BarcodeShow . '">
         <input type="text" id="CodePurch' . $Filter['product'] . '" class="form-control" value="' . $rr->Barcode . '"  disabled>
         <input type="hidden" id="UnitPurchName' . $Filter['product'] . '" value="' . $Filter['UniiName'] . '">
         <input type="hidden" id="TaxRate' . $Filter['product'] . '" value="' . $rr->Product()->first()->Tax()->first()->Rate . '">
         <input type="hidden" id="TaxType' . $Filter['product'] . '" value="' . $rr->Product()->first()->Tax()->first()->Type . '">
         <input type="hidden" id="PurchTax' . $Filter['product'] . '" value="' . $rr->Product()->first()->Tax . '">
        </td>

          <td>
        <input type="text" id="AvQty' . $Filter['product'] . '"   class="form-control"  value="'.$Filter['AvQty'].'" readonly >

        </td>


        <td>
        <input type="number" step="any" id="Qty' . $Filter['product'] . '"   class="form-control" ' . $funTotal . ' >

        </td>

              <td>

 <input type="number" id="Price' . $Filter['product'] . '" step="any"  class="form-control" ' . $funTotal . '" value="' . $pr . '"  >
  <input type="hidden"  id="Price_Sale' . $Filter['product'] . '" value="' . $rr->Price . '">
        </td>



                  <td style="display:' . $discShow . '">

 <input type="number" id="Discount' . $Filter['product'] . '" step="any"  class="form-control" ' . $funTotal . ' value="0" >
  <input type="hidden" id="TDiscPro' . $Filter['product'] . '"   class="form-control" value="0" >
<input type="hidden" id="TotalBFTax' . $Filter['product'] . '"   class="form-control" >
<input type="hidden" id="Tax' . $Filter['product'] . '"   class="form-control" >
  <input type="hidden" id="Total' . $Filter['product'] . '"   class="form-control" >
   <input type="hidden" id="TotalNet' . $Filter['product'] . '"   class="form-control" >
        </td>

      <td style="display:' . $taxShow . '">
   <select class="select2 form-control w-100"    id="OLDTAX' . $Filter['product'] . '" onchange="TAXPurch(' . $Filter['product'] . ')">
              ';

        foreach ($TAXESS as $tax) {
            if (app()->getLocale() == 'ar') {
                $txNamme = $tax->Name;
            } else {

                $txNamme = $tax->NameEn;
            }

            $output .= '
      <option value="' . $tax->id . '"       ';
            if ($tax->id == $rr->Product()->first()->Tax) {
                $output .= '  selected  ';
            }
            $output .= ' > ' . $txNamme . '</option>
                 ';
        }

        $output .= '

                        </select>
        </td>

            <td style="display:' . $storeShow . '">
   <select class="select2 form-control w-100" ' . $user . '   id="StorePurch' . $Filter['product'] . '" onchange="StoreNamePurch(' . $Filter['product'] . ')">
              ';

        foreach ($Stores as $stor) {
            if (app()->getLocale() == 'ar') {
                $StorNamme = $stor->Name;
            } else {

                $StorNamme = $stor->NameEn;
            }

            $output .= '
      <option value="' . $stor->id . '"       ';
            if ($stor->id == $Filter['store']) {
                $output .= '  selected  ';
            }
            $output .= ' > ' . $StorNamme . '</option>
                 ';
        }

        $output .= '

                        </select>
        </td>

       ' . $EXPIRE . '


        <td>
           <input type="hidden" id="StorePurchName' . $Filter['product'] . '"   class="form-control"  value="' . $Filter['StoreNemo'] . '" >
 <button type="button" class="btn btn-default waves-effect waves-themed" style="display:none" id="AddBtnPur' . $Filter['product'] . '" ' . $funAdd . ' >
          <i class="fal fa-plus"></i>
          </button>


                 <button type="button" style="' . $Doollar . '" class="btn btn-default" data-toggle="modal" data-target="#dollar' . $Filter['product'] . '">
    <i class="fal fa-dollar-sign"></i>
    </button>


        <div class="modal fade" id="dollar' . $Filter['product'] . '" tabindex="-1" role="dialog"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                               <h4 class="modal-title">
                             ' . trans('admin.Price') . '
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">
                        <div class="mt-3">
                            <table id="" class="table table-bordered table-hover table-striped w-100">
                            <thead>
                                <tr>
                                          <th>   ' . trans('admin.Price_One') . ' </th>
                                    <th>   ' . trans('admin.Price_Two') . ' </th>
                                    <th>   ' . trans('admin.Price_Three') . ' </th>
                                    <th> ' . trans('admin.Price_Last_Purch_Bill') . ' </th>
                                    <th> ' . trans('admin.Price_Last_Purch_Bill_from_this_Vendor') . ' </th>
                                    <th>    ' . trans('admin.Other_Stores_Qty') . ' </th>
                                    <th> ' . trans('admin.Actions') . ' </th>
                                </tr>
                            </thead>
                            <tbody id="">
                                <tr>

                                     <td>

                      <input type="text" id="UnitPriceOne' . $Filter['product'] . '" class="form-control" value="' . $rr->Price . '">
                                </td>
                                <td>
                         <input type="text" id="UnitPriceTwo' . $Filter['product'] . '" class="form-control" value="' . $rr->Price_Two . '">
                                </td>
                                     <td>

                     <input type="text" id="UnitPriceThree' . $Filter['product'] . '" class="form-control" value="' . $rr->Price_Three . '">

                     <input type="hidden" id="UnitPriceID' . $Filter['product'] . '"  value="' . $rr->id . '">
                                     </td>
                                      <td>
                                     ' . $priceone . '
                                     </td>
                                         <td>
                                         ' . $pricetwo . '
                                     </td>

                                         <td>
                                         ' . $qtyOther . '
                                     </td>

    <td>
    <button type="button" onclick="ChangePriceUnit(' . $Filter['product'] . ')" class="btn btn-primary">
    <i class="fal fa-edit"></i>
    </button>
    </td>
                                </tr>
                            </tbody>
                        </table>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">
                            <i class="fal fa-times"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            </div>


          </td>
        </tr>


            ';


        return $output;

    }


    //Remove Qties
    public function RemoveQties($id, $type, $new_code)
    {

        $Products = ProductsPurchases::where('Purchase', $id)->where('Qty','!=',0)->get();

        $def = StoresDefaultData::orderBy('id', 'desc')->first();

        foreach ($Products as $prod) {

            $unit = ProductUnits::where('Unit', $prod->Unit)->where('Product', $prod->Product)->first();

            $qq = $unit->Rate * $prod->Qty;
            $PR = $this->ProAvQties($prod->Store, $prod->Product, $prod->Product_Code);

            if (!empty($PR)) {

                $newqty = $PR->Qty - $qq;
                ProductsQty::where('id', $PR->id)->update(['Qty' => $newqty]);

            }

            if (!empty($prod->Exp_Date)) {

                $PREX = $this->ExpireAvQtiesCheck($prod->Store, $prod->Product, $prod->Product_Code, $prod->Exp_Date);

                if (!empty($PREX)) {

                    $newqtyEX = $PREX->Qty - $qq;
                    ExpireDateQty::where('id', $PREX->id)->update(['Qty' => $newqtyEX]);

                }

            }


            //Fifo Purchases

            if ($def->Cost_Price == 2) {


                $fifo = $this->FifoAvQty($prod->Store, $prod->Product, $prod->Product_Code, $prod->Date);

                if (!empty($fifo)) {

                    $newqtyFifo = $fifo->Qty - $qq;
                    FifoQty::where('id', $fifo->id)->update(['Qty' => $newqtyFifo]);


                }


            }


            if ($type == 1) {
                ProductMoves::where('Type', 'مشتريات')
                    ->where('Product', $prod->Product)
                    ->where('P_Code', $prod->Product_Code)
                    ->where('Bill_Num', $prod->Purchase()->first()->Code)
                    ->update(['Delete' => 1]);

            } else {

                ProductMoves::where('Type', 'مشتريات')
                    ->where('Product', $prod->Product)
                    ->where('P_Code', $prod->Product_Code)
                    ->where('Bill_Num', $prod->Purchase()->first()->Code)
                    ->update(['Edit' => 1, 'Edit_New_Code' => $new_code]);


            }


        }

    }



    //Jounralizing Payment Methods =====================


    // =============  Cash =====================


    //Cash Normal
    public function PayCash($data, $status, $Vendor, $Safe, $Total_Price)
    {


        $NewMkhazns = StoreCount::all();

        if ($status == 1) {

            foreach ($NewMkhazns as $new) {

                $store = Stores::find($new->Store);

                $data['creditor_cred'] = $new->Total;
                $data['account_cred'] = $Vendor;
                $data['debitor_debt'] = $new->Total;
                $data['account_debt'] = $store->Account;

                $this->JunDetails($data);


                $data['creditor_cred'] = $new->Total;
                $data['account_cred'] = $Safe;
                $data['debitor_debt'] = $new->Total;
                $data['account_debt'] = $Vendor;

                $this->JunDetails($data);

            }

        } elseif ($status == 0) {


            $data['creditor_cred'] = $Total_Price;
            $data['account_cred'] = $Vendor;
            $data['debitor_debt'] = $Total_Price;
            $data['account_debt'] = 71;

            $this->JunDetails($data);


            $data['creditor_cred'] = $Total_Price;
            $data['account_cred'] = $Safe;
            $data['debitor_debt'] = $Total_Price;
            $data['account_debt'] = $Vendor;

            $this->JunDetails($data);


        }


    }


    //Cash with Tax
    public function PayCashTax($data, $status, $Vendor, $Safe, $Total_Taxes, $Total_Price)
    {


        $NewMkhazns = StoreCount::all();


        if ($status == 1) {


            foreach ($NewMkhazns as $new) {


                $TTAX = Taxes::find($new->Tax);
                $store = Stores::find($new->Store);


                $data['debitor'] = $new->Total;
                $data['creditor'] = 0;
                $data['account'] = $store->Account;
                $this->OneJunDetails($data, 0);


                if ($new->id == 1) {

                    $data['debitor'] = $Total_Taxes;
                    $data['creditor'] = 0;
                    $data['account'] = $TTAX->Account;
                    $this->OneJunDetails($data, 0);


                }

                if ($new->id == 1) {

                    $TOTTTT = StoreCount::get()->sum('Total');


                    $data['debitor'] = 0;
                    $data['creditor'] = $TOTTTT + $Total_Taxes;
                    $data['account'] = $Vendor;
                    $this->OneJunDetails($data, 0);


                    $data['creditor_cred'] = $TOTTTT + $Total_Taxes;
                    $data['account_cred'] = $Safe;
                    $data['debitor_debt'] = $TOTTTT + $Total_Taxes;
                    $data['account_debt'] = $Vendor;
                    $this->JunDetails($data);


                }

            }

        } elseif ($status == 0) {


            $data['debitor'] = $Total_Price;
            $data['creditor'] = 0;
            $data['account'] = 71;
            $this->OneJunDetails($data, 0);


            foreach ($NewMkhazns as $new) {
                $TTAX = Taxes::find($new->Tax);

                $data['debitor'] = $Total_Taxes;
                $data['creditor'] = 0;
                $data['account'] = $TTAX->Account;
                $this->OneJunDetails($data, 0);


            }

            $data['debitor'] = 0;
            $data['creditor'] = $Total_Price + $Total_Taxes;
            $data['account'] = $Vendor;
            $this->OneJunDetails($data, 0);


            $data['creditor_cred'] = $Total_Price + $Total_Taxes;
            $data['account_cred'] = $Safe;
            $data['debitor_debt'] = $Total_Price + $Total_Taxes;
            $data['account_debt'] = $Vendor;
            $this->JunDetails($data);

        }


    }


    //Cash With Discount
    public function PayCashDiscount($data, $status, $Vendor, $Safe, $RESIDUAL, $paid, $Total_Price)
    {


        $NewMkhazns = StoreCount::all();

        if ($status == 1) {

            foreach ($NewMkhazns as $new) {

                $store = Stores::find($new->Store);


                $data['creditor_cred'] = $new->Total - $RESIDUAL;
                $data['account_cred'] = $Vendor;
                $data['debitor_debt'] = $new->Total;
                $data['account_debt'] = $store->Account;
                $this->JunDetails($data);


                $data['debitor'] = 0;
                $data['creditor'] = $RESIDUAL;
                $data['account'] = 206;
                $this->OneJunDetails($data, 0);



                if ($new->id == 1) {

                    $data['creditor_cred'] = $paid;
                    $data['account_cred'] = $Safe;
                    $data['debitor_debt'] = $paid;
                    $data['account_debt'] = $Vendor;
                    $this->JunDetails($data);



                }


            }

        } elseif ($status == 0) {


            foreach ($NewMkhazns as $new) {

                $store = Stores::find($new->Store);


                $data['creditor_cred'] = $new->Total - $RESIDUAL;
                $data['account_cred'] = $Vendor;
                $data['debitor_debt'] = $new->Total;
                $data['account_debt'] = 71;
                $this->JunDetails($data);


                $data['debitor'] = 0;
                $data['creditor'] = $RESIDUAL;
                $data['account'] = 206;
                $this->OneJunDetails($data, 0);



                if ($new->id == 1) {

                    $data['creditor_cred'] = $paid;
                    $data['account_cred'] = $Safe;
                    $data['debitor_debt'] = $paid;
                    $data['account_debt'] = $Vendor;
                    $this->JunDetails($data);



                }


            }


        }

    }


    //Cash With Discount and Taxes
    public function PayCashTaxDiscount($data, $status, $Vendor, $Safe, $Total_Taxes, $RESIDUAL, $paid, $Total_Price)
    {


        $NewMkhazns = StoreCount::all();

        if ($status == 1) {


            foreach ($NewMkhazns as $new) {

                $store = Stores::find($new->Store);
                $TTAX = Taxes::find($new->Tax);


                $data['debitor'] = $new->Total;
                $data['creditor'] = 0;
                $data['account'] = $store->Account;
                $this->OneJunDetails($data, 0);


                if ($new->id == 1) {

                    $data['debitor'] = $Total_Taxes;
                    $data['creditor'] = 0;
                    $data['account'] = $TTAX->Account;
                    $this->OneJunDetails($data, 0);


                    $TOTTTT = StoreCount::get()->sum('Total');


                    $data['debitor'] = 0;
                    $data['creditor'] = $TOTTTT + $Total_Taxes - $RESIDUAL;
                    $data['account'] = $Vendor;
                    $this->OneJunDetails($data, 0);

                    $data['debitor'] = 0;
                    $data['creditor'] = $RESIDUAL;
                    $data['account'] = 206;
                    $this->OneJunDetails($data, 0);


                    $data['creditor_cred'] = $paid;
                    $data['account_cred'] = $Safe;
                    $data['debitor_debt'] = $paid;
                    $data['account_debt'] = $Vendor;
                    $this->JunDetails($data);





                }


            }

        } elseif ($status == 0) {


            foreach ($NewMkhazns as $new) {

                $store = Stores::find($new->Store);
                $TTAX = Taxes::find($new->Tax);


                $data['debitor'] = $new->Total;
                $data['creditor'] = 0;
                $data['account'] = 71;
                $this->OneJunDetails($data, 0);


                if ($new->id == 1) {

                    $data['debitor'] = $Total_Taxes;
                    $data['creditor'] = 0;
                    $data['account'] = $TTAX->Account;
                    $this->OneJunDetails($data, 0);


                    $TOTTTT = StoreCount::get()->sum('Total');


                    $data['debitor'] = 0;
                    $data['creditor'] = $TOTTTT + $Total_Taxes - $RESIDUAL;
                    $data['account'] = $Vendor;
                    $this->OneJunDetails($data, 0);

                    $data['debitor'] = 0;
                    $data['creditor'] = $RESIDUAL;
                    $data['account'] = 206;
                    $this->OneJunDetails($data, 0);


                    $data['creditor_cred'] = $paid;
                    $data['account_cred'] = $Safe;
                    $data['debitor_debt'] = $paid;
                    $data['account_debt'] = $Vendor;
                    $this->JunDetails($data);





                }


            }


        }


    }


    // =============  Later  =====================

    //Later Normal
    public function PayLater($data, $status, $Vendor, $Safe, $paid, $Total_Price)
    {


        $NewMkhazns = StoreCount::all();


        if ($status == 1) {


            foreach ($NewMkhazns as $new) {

                $store = Stores::find($new->Store);

                if (count($NewMkhazns) == 1) {
                    $amount = $Total_Price;
                } else {
                    $amount = $new->Total;

                }

                $data['creditor_cred'] = $amount;
                $data['account_cred'] = $Vendor;
                $data['debitor_debt'] = $amount;
                $data['account_debt'] = $store->Account;

                $this->JunDetails($data);


                if ($paid != 0 or $paid > 0) {


                    $data['creditor_cred'] = $paid;
                    $data['account_cred'] = $Safe;
                    $data['debitor_debt'] = $paid;
                    $data['account_debt'] = $Vendor;

                    $this->JunDetails($data);


                }

            }


        } elseif ($status == 0) {



            foreach ($NewMkhazns as $new) {

                $store = Stores::find($new->Store);

                if (count($NewMkhazns) == 1) {
                    $amount = $Total_Price;
                } else {
                    $amount = $new->Total;

                }

                $data['creditor_cred'] = $amount;
                $data['account_cred'] = $Vendor;
                $data['debitor_debt'] = $amount;
                $data['account_debt'] = 71;

                $this->JunDetails($data);


                if ($paid != 0 or $paid > 0) {


                    $data['creditor_cred'] = $paid;
                    $data['account_cred'] = $Safe;
                    $data['debitor_debt'] = $paid;
                    $data['account_debt'] = $Vendor;

                    $this->JunDetails($data);


                }

            }





        }


    }

    //Later with Tax
    public function PayLaterTax($data, $status, $Vendor, $Safe, $Total_Taxes, $paid, $Total_Price)
    {


        $NewMkhazns = StoreCount::all();

        if ($status == 1) {



            if (count($NewMkhazns) == 1) {

                foreach ($NewMkhazns as $new) {

                    $store = Stores::find($new->Store);
                    $TTAX = Taxes::find($new->Tax);


                    $data['debitor'] = $Total_Price;
                    $data['creditor'] = 0;
                    $data['account'] = $store->Account;
                    $this->OneJunDetails($data, 0);


                    if ($new->id == 1) {
                        $data['debitor'] = $Total_Taxes;
                        $data['creditor'] = 0;
                        $data['account'] = $TTAX->Account;
                        $this->OneJunDetails($data, 0);
                    }

                    $data['debitor'] = 0;
                    $data['creditor'] = $Total_Price + $Total_Taxes;
                    $data['account'] = $Vendor;
                    $this->OneJunDetails($data, 0);


                    if ($paid != 0 or $paid > 0) {


                        $data['creditor_cred'] = $paid;
                        $data['account_cred'] = $Safe;
                        $data['debitor_debt'] = $paid;
                        $data['account_debt'] = $Vendor;
                        $this->JunDetails($data);

                    }
                }

            } else {

                foreach ($NewMkhazns as $new) {

                    $store = Stores::find($new->Store);
                    $TTAX = Taxes::find($new->Tax);


                    $data['debitor'] = $new->Total;
                    $data['creditor'] = 0;
                    $data['account'] = $store->Account;
                    $this->OneJunDetails($data, 0);


                    if ($new->id == 1) {
                        $TOOOT = StoreCount::get()->sum('Total');


                        $data['creditor_cred'] = $TOOOT + $Total_Taxes;
                        $data['account_cred'] = $Vendor;
                        $data['debitor_debt'] = $Total_Taxes;
                        $data['account_debt'] = $TTAX->Account;
                        $this->JunDetails($data);


                    }


                }

                if ($paid != 0 or $paid > 0) {


                    $data['creditor_cred'] = $paid;
                    $data['account_cred'] = $Safe;
                    $data['debitor_debt'] = $paid;
                    $data['account_debt'] = $Vendor;
                    $this->JunDetails($data);


                }

            }

        } elseif ($status == 0) {




            if (count($NewMkhazns) == 1) {

                foreach ($NewMkhazns as $new) {

                    $store = Stores::find($new->Store);
                    $TTAX = Taxes::find($new->Tax);


                    $data['debitor'] = $Total_Price;
                    $data['creditor'] = 0;
                    $data['account'] = 71;
                    $this->OneJunDetails($data, 0);


                    if ($new->id == 1) {
                        $data['debitor'] = $Total_Taxes;
                        $data['creditor'] = 0;
                        $data['account'] = $TTAX->Account;
                        $this->OneJunDetails($data, 0);
                    }

                    $data['debitor'] = 0;
                    $data['creditor'] = $Total_Price + $Total_Taxes;
                    $data['account'] = $Vendor;
                    $this->OneJunDetails($data, 0);


                    if ($paid != 0 or $paid > 0) {


                        $data['creditor_cred'] = $paid;
                        $data['account_cred'] = $Safe;
                        $data['debitor_debt'] = $paid;
                        $data['account_debt'] = $Vendor;
                        $this->JunDetails($data);

                    }
                }

            } else {

                foreach ($NewMkhazns as $new) {

                    $store = Stores::find($new->Store);
                    $TTAX = Taxes::find($new->Tax);


                    $data['debitor'] = $new->Total;
                    $data['creditor'] = 0;
                    $data['account'] = 71;
                    $this->OneJunDetails($data, 0);


                    if ($new->id == 1) {
                        $TOOOT = StoreCount::get()->sum('Total');


                        $data['creditor_cred'] = $TOOOT + $Total_Taxes;
                        $data['account_cred'] = $Vendor;
                        $data['debitor_debt'] = $Total_Taxes;
                        $data['account_debt'] = $TTAX->Account;
                        $this->JunDetails($data);


                    }


                }

                if ($paid != 0 or $paid > 0) {


                    $data['creditor_cred'] = $paid;
                    $data['account_cred'] = $Safe;
                    $data['debitor_debt'] = $paid;
                    $data['account_debt'] = $Vendor;
                    $this->JunDetails($data);


                }

            }




        }


    }


    //Later With Discount
    public function PayLaterDiscount($data, $status, $Vendor, $Safe, $RESIDUAL, $paid, $Total_Price)
    {


        $NewMkhazns = StoreCount::all();
        if ($status == 1) {
            $NewMkhazns = StoreCount::all();

            if (count($NewMkhazns) == 1) {


                foreach ($NewMkhazns as $new) {

                    $store = Stores::find($new->Store);


                    $data['debitor'] = $Total_Price;
                    $data['creditor'] = 0;
                    $data['account'] = $store->Account;
                    $this->OneJunDetails($data, 0);


                    if ($paid != 0 or $paid > 0) {

                        $data['debitor'] = 0;
                        $data['creditor'] = $Total_Price - $RESIDUAL;
                        $data['account'] = $Vendor;
                        $this->OneJunDetails($data, 0);

                        $data['debitor'] = 0;
                        $data['creditor'] = $RESIDUAL;
                        $data['account'] = 206;
                        $this->OneJunDetails($data, 0);


                        $data['creditor_cred'] = $paid;
                        $data['account_cred'] = $Safe;
                        $data['debitor_debt'] = $paid;
                        $data['account_debt'] = $Vendor;
                        $this->JunDetails($data);


                    } else {


                        $data['debitor'] = 0;
                        $data['creditor'] = $Total_Price - $RESIDUAL;
                        $data['account'] = $Vendor;
                        $this->OneJunDetails($data, 0);


                        $data['debitor'] = 0;
                        $data['creditor'] = $RESIDUAL;
                        $data['account'] = 206;
                        $this->OneJunDetails($data, 0);


                    }


                }

            } else {


                foreach ($NewMkhazns as $new) {

                    $store = Stores::find($new->Store);

                    $data['debitor'] = $new->Total;
                    $data['creditor'] = 0;
                    $data['account'] = $store->Account;
                    $this->OneJunDetails($data, 0);

                    if ($paid != 0 or $paid > 0) {
                        $data['debitor'] = 0;
                        $data['creditor'] = $new->Total - $RESIDUAL;
                        $data['account'] = $Vendor;
                        $this->OneJunDetails($data, 0);
                    }


                }

                if ($paid != 0 or $paid > 0) {


                    $data['debitor'] = 0;
                    $data['creditor'] = $RESIDUAL;
                    $data['account'] = 206;
                    $this->OneJunDetails($data, 0);

                    $data['creditor_cred'] = $paid;
                    $data['account_cred'] = $Safe;
                    $data['debitor_debt'] = $paid ;
                    $data['account_debt'] = $Vendor;
                    $this->JunDetails($data);





                } else {


                    $data['debitor'] = 0;
                    $data['creditor'] = $Total_Price - $RESIDUAL;
                    $data['account'] = $Vendor;
                    $this->OneJunDetails($data, 0);


                    $data['debitor'] = 0;
                    $data['creditor'] = $RESIDUAL;
                    $data['account'] = 206;
                    $this->OneJunDetails($data, 0);


                }


            }

        } elseif ($status == 0) {



            if (count($NewMkhazns) == 1) {


                foreach ($NewMkhazns as $new) {

                    $store = Stores::find($new->Store);


                    $data['debitor'] = $Total_Price;
                    $data['creditor'] = 0;
                    $data['account'] =71;
                    $this->OneJunDetails($data, 0);


                    if ($paid != 0 or $paid > 0) {

                        $data['debitor'] = 0;
                        $data['creditor'] = $Total_Price - $RESIDUAL;
                        $data['account'] = $Vendor;
                        $this->OneJunDetails($data, 0);

                        $data['debitor'] = 0;
                        $data['creditor'] = $RESIDUAL;
                        $data['account'] = 206;
                        $this->OneJunDetails($data, 0);


                        $data['creditor_cred'] = $paid;
                        $data['account_cred'] = $Safe;
                        $data['debitor_debt'] = $paid;
                        $data['account_debt'] = $Vendor;
                        $this->JunDetails($data);


                    } else {


                        $data['debitor'] = 0;
                        $data['creditor'] = $Total_Price - $RESIDUAL;
                        $data['account'] = $Vendor;
                        $this->OneJunDetails($data, 0);


                        $data['debitor'] = 0;
                        $data['creditor'] = $RESIDUAL;
                        $data['account'] = 206;
                        $this->OneJunDetails($data, 0);


                    }


                }

            } else {


                foreach ($NewMkhazns as $new) {

                    $store = Stores::find($new->Store);

                    $data['debitor'] = $new->Total;
                    $data['creditor'] = 0;
                    $data['account'] = 71;
                    $this->OneJunDetails($data, 0);

                    if ($paid != 0 or $paid > 0) {
                        $data['debitor'] = 0;
                        $data['creditor'] = $new->Total - $RESIDUAL;
                        $data['account'] = $Vendor;
                        $this->OneJunDetails($data, 0);
                    }


                }

                if ($paid != 0 or $paid > 0) {


                    $data['debitor'] = 0;
                    $data['creditor'] = $RESIDUAL;
                    $data['account'] = 206;
                    $this->OneJunDetails($data, 0);

                    $data['creditor_cred'] = $paid;
                    $data['account_cred'] = $Safe;
                    $data['debitor_debt'] = $paid ;
                    $data['account_debt'] = $Vendor;
                    $this->JunDetails($data);





                } else {


                    $data['debitor'] = 0;
                    $data['creditor'] = $Total_Price - $RESIDUAL;
                    $data['account'] = $Vendor;
                    $this->OneJunDetails($data, 0);


                    $data['debitor'] = 0;
                    $data['creditor'] = $RESIDUAL;
                    $data['account'] = 206;
                    $this->OneJunDetails($data, 0);


                }


            }



        }


    }


    //Later With Discount and Taxes
    public function PayLaterTaxDiscount($data, $status, $Vendor, $Safe, $Total_Taxes, $RESIDUAL, $paid, $Total_Price)
    {


        $NewMkhazns = StoreCount::all();

        if ($status == 1) {


            if (count($NewMkhazns) == 1) {


                foreach ($NewMkhazns as $new) {

                    $store = Stores::find($new->Store);
                    $TTAX = Taxes::find($new->Tax);


                    $data['debitor'] = $Total_Price;
                    $data['creditor'] = 0;
                    $data['account'] = $store->Account;
                    $this->OneJunDetails($data, 0);


                    $data['debitor'] = $Total_Taxes;
                    $data['creditor'] = 0;
                    $data['account'] = $TTAX->Account;
                    $this->OneJunDetails($data, 0);


                    if ($paid != 0 or $paid > 0) {


                        $data['debitor'] = 0;
                        $data['creditor'] = $Total_Price + $Total_Taxes - $RESIDUAL;
                        $data['account'] = $Vendor;
                        $this->OneJunDetails($data, 0);


                        $data['debitor'] = 0;
                        $data['creditor'] = $RESIDUAL;
                        $data['account'] = 206;
                        $this->OneJunDetails($data, 0);

                        $data['creditor_cred'] = $paid;
                        $data['account_cred'] = $Safe;
                        $data['debitor_debt'] = $paid ;
                        $data['account_debt'] = $Vendor;
                        $this->JunDetails($data);





                    } else {


                        $data['debitor'] = 0;
                        $data['creditor'] = $Total_Price + $Total_Taxes - $RESIDUAL;
                        $data['account'] = $Vendor;
                        $this->OneJunDetails($data, 0);

                        $data['debitor'] = 0;
                        $data['creditor'] = $RESIDUAL;
                        $data['account'] = 206;
                        $this->OneJunDetails($data, 0);


                    }


                }

            } else {



                foreach ($NewMkhazns as $new) {

                    $store = Stores::find($new->Store);
                    $TTAX = Taxes::find($new->Tax);


                    $data['debitor'] = $Total_Price;
                    $data['creditor'] = 0;
                    $data['account'] = $store->Account;
                    $this->OneJunDetails($data, 0);


                    $data['debitor'] = $Total_Taxes;
                    $data['creditor'] = 0;
                    $data['account'] = $TTAX->Account;
                    $this->OneJunDetails($data, 0);


                    if ($paid != 0 or $paid > 0) {


                        $data['debitor'] = 0;
                        $data['creditor'] = $Total_Price + $Total_Taxes - $RESIDUAL;
                        $data['account'] = $Vendor;
                        $this->OneJunDetails($data, 0);


                        $data['debitor'] = 0;
                        $data['creditor'] = $RESIDUAL;
                        $data['account'] = 206;
                        $this->OneJunDetails($data, 0);

                        $data['creditor_cred'] = $paid;
                        $data['account_cred'] = $Safe;
                        $data['debitor_debt'] = $paid ;
                        $data['account_debt'] = $Vendor;
                        $this->JunDetails($data);





                    } else {


                        $data['debitor'] = 0;
                        $data['creditor'] = $Total_Price + $Total_Taxes - $RESIDUAL;
                        $data['account'] = $Vendor;
                        $this->OneJunDetails($data, 0);

                        $data['debitor'] = 0;
                        $data['creditor'] = $RESIDUAL;
                        $data['account'] = 206;
                        $this->OneJunDetails($data, 0);


                    }


                }


            }


        } elseif ($status == 0) {


            if (count($NewMkhazns) == 1) {


                foreach ($NewMkhazns as $new) {

                    $store = Stores::find($new->Store);
                    $TTAX = Taxes::find($new->Tax);


                    $data['debitor'] = $Total_Price;
                    $data['creditor'] = 0;
                    $data['account'] = 71;
                    $this->OneJunDetails($data, 0);


                    $data['debitor'] = $Total_Taxes;
                    $data['creditor'] = 0;
                    $data['account'] = $TTAX->Account;
                    $this->OneJunDetails($data, 0);


                    if ($paid != 0 or $paid > 0) {


                        $data['debitor'] = 0;
                        $data['creditor'] = $Total_Price + $Total_Taxes - $RESIDUAL;
                        $data['account'] = $Vendor;
                        $this->OneJunDetails($data, 0);


                        $data['debitor'] = 0;
                        $data['creditor'] = $RESIDUAL;
                        $data['account'] = 206;
                        $this->OneJunDetails($data, 0);

                        $data['creditor_cred'] = $paid;
                        $data['account_cred'] = $Safe;
                        $data['debitor_debt'] = $paid ;
                        $data['account_debt'] = $Vendor;
                        $this->JunDetails($data);





                    } else {


                        $data['debitor'] = 0;
                        $data['creditor'] = $Total_Price + $Total_Taxes - $RESIDUAL;
                        $data['account'] = $Vendor;
                        $this->OneJunDetails($data, 0);

                        $data['debitor'] = 0;
                        $data['creditor'] = $RESIDUAL;
                        $data['account'] = 206;
                        $this->OneJunDetails($data, 0);


                    }


                }

            } else {



                foreach ($NewMkhazns as $new) {

                    $store = Stores::find($new->Store);
                    $TTAX = Taxes::find($new->Tax);


                    $data['debitor'] = $Total_Price;
                    $data['creditor'] = 0;
                    $data['account'] = 71;
                    $this->OneJunDetails($data, 0);


                    $data['debitor'] = $Total_Taxes;
                    $data['creditor'] = 0;
                    $data['account'] = $TTAX->Account;
                    $this->OneJunDetails($data, 0);


                    if ($paid != 0 or $paid > 0) {


                        $data['debitor'] = 0;
                        $data['creditor'] = $Total_Price + $Total_Taxes - $RESIDUAL;
                        $data['account'] = $Vendor;
                        $this->OneJunDetails($data, 0);


                        $data['debitor'] = 0;
                        $data['creditor'] = $RESIDUAL;
                        $data['account'] = 206;
                        $this->OneJunDetails($data, 0);

                        $data['creditor_cred'] = $paid;
                        $data['account_cred'] = $Safe;
                        $data['debitor_debt'] = $paid ;
                        $data['account_debt'] = $Vendor;
                        $this->JunDetails($data);





                    } else {


                        $data['debitor'] = 0;
                        $data['creditor'] = $Total_Price + $Total_Taxes - $RESIDUAL;
                        $data['account'] = $Vendor;
                        $this->OneJunDetails($data, 0);

                        $data['debitor'] = 0;
                        $data['creditor'] = $RESIDUAL;
                        $data['account'] = 206;
                        $this->OneJunDetails($data, 0);


                    }


                }


            }



        }


    }


    // =============  Check  =====================


    //Check Normal
    public function PayCheck($data, $status, $Vendor, $Total_Price)
    {


        $NewMkhazns = StoreCount::all();

        if ($status == 1) {

            foreach ($NewMkhazns as $new) {

                $store = Stores::find($new->Store);

                $data['creditor_cred'] = $new->Total;
                $data['account_cred'] = $Vendor;
                $data['debitor_debt'] = $new->Total;
                $data['account_debt'] = $store->Account;

                $this->JunDetails($data);


//                $data['creditor_cred'] = $new->Total;
//                $data['account_cred'] = 42;
//                $data['debitor_debt'] = $new->Total;
//                $data['account_debt'] = $Vendor;
//
//                $this->JunDetails($data);

            }

        } elseif ($status == 0) {


            $data['creditor_cred'] = $Total_Price;
            $data['account_cred'] = $Vendor;
            $data['debitor_debt'] = $Total_Price;
            $data['account_debt'] = 71;

            $this->JunDetails($data);

//
//            $data['creditor_cred'] = $Total_Price;
//            $data['account_cred'] = 42;
//            $data['debitor_debt'] = $Total_Price;
//            $data['account_debt'] = $Vendor;
//
//            $this->JunDetails($data);


        }


    }


    //Check with Tax
    public function PayCheckTax($data, $status, $Vendor, $Total_Taxes, $Total_Price)
    {


        $NewMkhazns = StoreCount::all();


        if ($status == 1) {


            foreach ($NewMkhazns as $new) {


                $TTAX = Taxes::find($new->Tax);
                $store = Stores::find($new->Store);


                $data['debitor'] = $new->Total;
                $data['creditor'] = 0;
                $data['account'] = $store->Account;
                $this->OneJunDetails($data, 0);


                if ($new->id == 1) {

                    $data['debitor'] = $Total_Taxes;
                    $data['creditor'] = 0;
                    $data['account'] = $TTAX->Account;
                    $this->OneJunDetails($data, 0);


                    $TOTTTT = StoreCount::get()->sum('Total');


                    $data['debitor'] = 0;
                    $data['creditor'] = $TOTTTT + $Total_Taxes;
                    $data['account'] = $Vendor;
                    $this->OneJunDetails($data, 0);

//
//                    $data['creditor_cred'] = $TOTTTT + $Total_Taxes;
//                    $data['account_cred'] = 42;
//                    $data['debitor_debt'] = $TOTTTT + $Total_Taxes;
//                    $data['account_debt'] = $Vendor;
//                    $this->JunDetails($data);


                }

            }

        } elseif ($status == 0) {




            foreach ($NewMkhazns as $new) {


                $TTAX = Taxes::find($new->Tax);
                $store = Stores::find($new->Store);


                $data['debitor'] = $new->Total;
                $data['creditor'] = 0;
                $data['account'] =71;
                $this->OneJunDetails($data, 0);


                if ($new->id == 1) {

                    $data['debitor'] = $Total_Taxes;
                    $data['creditor'] = 0;
                    $data['account'] = $TTAX->Account;
                    $this->OneJunDetails($data, 0);


                    $TOTTTT = StoreCount::get()->sum('Total');


                    $data['debitor'] = 0;
                    $data['creditor'] = $TOTTTT + $Total_Taxes;
                    $data['account'] = $Vendor;
                    $this->OneJunDetails($data, 0);

//
//                    $data['creditor_cred'] = $TOTTTT + $Total_Taxes;
//                    $data['account_cred'] = 42;
//                    $data['debitor_debt'] = $TOTTTT + $Total_Taxes;
//                    $data['account_debt'] = $Vendor;
//                    $this->JunDetails($data);


                }

            }


        }


    }


    //Check With Discount
    public function PayCheckDiscount($data, $status, $Vendor, $RESIDUALSSSS, $RESIDUAL, $paid, $Total_Price)
    {


        $NewMkhazns = StoreCount::all();

        if ($status == 1) {

            foreach ($NewMkhazns as $new) {

                $store = Stores::find($new->Store);


                $data['debitor'] = $new->Total;
                $data['creditor'] = 0;
                $data['account'] = $store->Account;
                $this->OneJunDetails($data, 0);


                if ($new->id == 1) {

                    $Toot = StoreCount::get()->sum('Total');


                    $data['debitor'] = 0;
                    $data['creditor'] = $Toot - $RESIDUAL;
                    $data['account'] = $Vendor;
                    $this->OneJunDetails($data, 0);

                    $data['debitor'] = 0;
                    $data['creditor'] = $RESIDUAL;
                    $data['account'] = 206;
                    $this->OneJunDetails($data, 0);

//                    $data['creditor_cred'] = $Toot - $RESIDUAL;
//                    $data['account_cred'] = 42;
//                    $data['debitor_debt'] = $Toot;
//                    $data['account_debt'] = $Toot - $RESIDUAL;
//                    $this->JunDetails($data);
//




                }

            }

        } elseif ($status == 0) {


            foreach ($NewMkhazns as $new) {

                $store = Stores::find($new->Store);


                $data['debitor'] = $new->Total;
                $data['creditor'] = 0;
                $data['account'] = 71;
                $this->OneJunDetails($data, 0);


                if ($new->id == 1) {

                    $Toot = StoreCount::get()->sum('Total');


                    $data['debitor'] = 0;
                    $data['creditor'] = $Toot - $RESIDUAL;
                    $data['account'] = $Vendor;
                    $this->OneJunDetails($data, 0);

                    $data['debitor'] = 0;
                    $data['creditor'] = $RESIDUAL;
                    $data['account'] = 206;
                    $this->OneJunDetails($data, 0);

//                    $data['creditor_cred'] = $Toot - $RESIDUAL;
//                    $data['account_cred'] = 42;
//                    $data['debitor_debt'] = $Toot;
//                    $data['account_debt'] = $Toot - $RESIDUAL;
//                    $this->JunDetails($data);
//




                }

            }

        }


    }


    //Check With Discount and Taxes
    public function PayCheckTaxDiscount($data, $status, $Vendor, $RESIDUALSSSS, $Total_Taxes, $RESIDUAL, $paid, $Total_Price)
    {


        $NewMkhazns = StoreCount::all();

        if ($status == 1) {


            foreach ($NewMkhazns as $new) {

                $store = Stores::find($new->Store);
                $TTAX = Taxes::find($new->Tax);


                $data['debitor'] = $new->Total;
                $data['creditor'] = 0;
                $data['account'] = $store->Account;
                $this->OneJunDetails($data, 0);


                if ($new->id == 1) {

                    $data['debitor'] = $Total_Taxes;
                    $data['creditor'] = 0;
                    $data['account'] = $TTAX->Account;
                    $this->OneJunDetails($data, 0);


                    $TOTTTT = StoreCount::get()->sum('Total');


                    $data['debitor'] = 0;
                    $data['creditor'] = $TOTTTT + $Total_Taxes - $RESIDUAL;
                    $data['account'] = $Vendor;
                    $this->OneJunDetails($data, 0);

                    $data['debitor'] = 0;
                    $data['creditor'] = $RESIDUAL;
                    $data['account'] = 206;
                    $this->OneJunDetails($data, 0);

//
//                    $data['creditor_cred'] = (($TOTTTT + $Total_Taxes) - $RESIDUAL);
//                    $data['account_cred'] = 42;
//                    $data['debitor_debt'] = $Total_Price + $Total_Taxes;
//                    $data['account_debt'] = $Vendor;
//                    $this->JunDetails($data);





                }


            }

        } elseif ($status == 0) {



            foreach ($NewMkhazns as $new) {

                $store = Stores::find($new->Store);
                $TTAX = Taxes::find($new->Tax);


                $data['debitor'] = $new->Total;
                $data['creditor'] = 0;
                $data['account'] = 71;
                $this->OneJunDetails($data, 0);


                if ($new->id == 1) {

                    $data['debitor'] = $Total_Taxes;
                    $data['creditor'] = 0;
                    $data['account'] = $TTAX->Account;
                    $this->OneJunDetails($data, 0);


                    $TOTTTT = StoreCount::get()->sum('Total');


                    $data['debitor'] = 0;
                    $data['creditor'] = $TOTTTT + $Total_Taxes - $RESIDUAL;
                    $data['account'] = $Vendor;
                    $this->OneJunDetails($data, 0);

                    $data['debitor'] = 0;
                    $data['creditor'] = $RESIDUAL;
                    $data['account'] = 206;
                    $this->OneJunDetails($data, 0);

//
//                    $data['creditor_cred'] = (($TOTTTT + $Total_Taxes) - $RESIDUAL);
//                    $data['account_cred'] = 42;
//                    $data['debitor_debt'] = $Total_Price + $Total_Taxes;
//                    $data['account_debt'] = $Vendor;
//                    $this->JunDetails($data);





                }


            }



        }


    }


    //======================================================================================================




    //Jounralizing Payment Methods  Return Purchases =====================



     // ============  Cash ====================================

//Normal Cash
    public function PayReturnCash($data, $Vendor, $Safe, $Total_Price)
    {


        $NewMkhazns = StoreCount::all();


        foreach ($NewMkhazns as $new) {

            $store = Stores::find($new->Store);

            $data['creditor_cred'] = $new->Total;
            $data['account_cred'] = $store->Account;
            $data['debitor_debt'] = $new->Total;
            $data['account_debt'] = $Vendor;

            $this->JunDetails($data);


            $data['creditor_cred'] = $new->Total;
            $data['account_cred'] = $Vendor;
            $data['debitor_debt'] = $new->Total;
            $data['account_debt'] = $Safe;

            $this->JunDetails($data);

        }





    }

    //Cash with Tax
    public function PayReturnCashTax($data, $Vendor, $Safe, $Total_Taxes, $Total_Price)
    {


        $NewMkhazns = StoreCount::all();

        foreach($NewMkhazns as $new){

            $store=Stores::find($new->Store);
            $TTAX=Taxes::find($new->Tax);



            $data['debitor'] = $new->Total + $Total_Taxes;
            $data['creditor'] =0;
            $data['account'] = $Vendor;
            $this->OneJunDetails($data, 0);



            $data['debitor'] =0;
            $data['creditor'] =$new->Total;
            $data['account'] = $store->Account;
            $this->OneJunDetails($data, 0);


            $data['debitor'] =0;
            $data['creditor'] =$Total_Taxes;
            $data['account'] = $TTAX->Account;
            $this->OneJunDetails($data, 0);



            $data['creditor_cred'] = $new->Total + $Total_Taxes;
            $data['account_cred'] = $Vendor;
            $data['debitor_debt'] = $new->Total + $Total_Taxes;
            $data['account_debt'] = $Safe ;
            $this->JunDetails($data);


        }




    }


    //Cash With Discount
    public function PayReturnCashDiscount($data, $Vendor, $Safe, $RESIDUAL, $Total_Price)
    {

        $NewMkhazns = StoreCount::all();

        foreach ($NewMkhazns as $new) {

            $store = Stores::find($new->Store);


            $data['creditor_cred'] = $new->Total;
            $data['account_cred'] = $store->Account;
            $data['debitor_debt'] = $new->Total - $RESIDUAL;
            $data['account_debt'] = $Vendor ;
            $this->JunDetails($data);


            $data['debitor'] = $RESIDUAL;
            $data['creditor'] =0;
            $data['account'] = 206;
            $this->OneJunDetails($data, 0);


            $data['creditor_cred'] = $new->Total - $RESIDUAL;
            $data['account_cred'] = $Vendor;
            $data['debitor_debt'] = $new->Total - $RESIDUAL;
            $data['account_debt'] =$Safe ;
            $this->JunDetails($data);


        }

    }


    //Cash With Discount and Taxes
    public function PayReturnCashTaxDiscount($data, $Vendor, $Safe, $Total_Taxes, $RESIDUAL, $Total_Price)
    {


        $NewMkhazns = StoreCount::all();


        foreach($NewMkhazns as $new){

            $store=Stores::find($new->Store);
            $TTAX=Taxes::find($new->Tax);



            $data['debitor'] = $new->Total + $Total_Taxes - $RESIDUAL;
            $data['creditor'] = 0;
            $data['account'] = $Vendor;
            $this->OneJunDetails($data, 0);



            $data['debitor'] = $RESIDUAL;
            $data['creditor'] = 0;
            $data['account'] = 206;
            $this->OneJunDetails($data, 0);



            $data['debitor'] =0;
            $data['creditor'] = $new->Total;
            $data['account'] = $store->Account;
            $this->OneJunDetails($data, 0);


            $data['debitor'] = 0;
            $data['creditor'] = $Total_Taxes;
            $data['account'] = $TTAX->Account;
            $this->OneJunDetails($data, 0);



            $data['creditor_cred'] = $new->Total + $Total_Taxes - $RESIDUAL;
            $data['account_cred'] = $Vendor;
            $data['debitor_debt'] = $new->Total + $Total_Taxes - $RESIDUAL;
            $data['account_debt'] = $Safe ;
            $this->JunDetails($data);

        }


    }




    // ============  Later  ====================================



    //Later Normal
    public function PayReturnLater($data, $Vendor, $Safe, $paid, $Total_Price)
    {


        $NewMkhazns = StoreCount::all();



        foreach($NewMkhazns as $new){

            $store=Stores::find($new->Store);

            if (count($NewMkhazns) == 1) {
                $amount = $Total_Price;
            } else {
                $amount = $new->Total;

            }

            $data['creditor_cred'] = $amount;
            $data['account_cred'] = $store->Account;
            $data['debitor_debt'] = $amount;
            $data['account_debt'] = $Vendor;

            $this->JunDetails($data);

            if($paid != 0 or $paid > 0){


                $data['creditor_cred'] = $paid;
                $data['account_cred'] = $Vendor;
                $data['debitor_debt'] = $paid;
                $data['account_debt'] = $Safe;

                $this->JunDetails($data);

            }


        }




    }


    //Later with Tax
    public function PayReturnLaterTax($data, $Vendor, $Safe, $Total_Taxes, $paid, $Total_Price)
    {


        $NewMkhazns = StoreCount::all();

            $NewMkhazns = StoreCount::all();

            if (count($NewMkhazns) == 1) {

                foreach ($NewMkhazns as $new) {

                    $store = Stores::find($new->Store);
                    $TTAX = Taxes::find($new->Tax);




                    $data['debitor'] = $new->Total + $Total_Taxes;
                    $data['creditor'] = 0;
                    $data['account'] = $Vendor;
                    $this->OneJunDetails($data, 0);


                    $data['debitor'] = 0;
                    $data['creditor'] = $new->Total;
                    $data['account'] = $store->Account;
                    $this->OneJunDetails($data, 0);


                        $data['debitor'] = 0;
                        $data['creditor'] = $Total_Taxes;
                        $data['account'] = $TTAX->Account;
                        $this->OneJunDetails($data, 0);


                    if ($paid != 0 or $paid > 0) {


                        $data['creditor_cred'] = $paid;
                        $data['account_cred'] = $Vendor;
                        $data['debitor_debt'] = $paid;
                        $data['account_debt'] = $Safe ;
                        $this->JunDetails($data);

                    }
                }

            } else {

                foreach ($NewMkhazns as $new) {

                    $store = Stores::find($new->Store);
                    $TTAX = Taxes::find($new->Tax);




                    $data['debitor'] = $new->Total + $Total_Taxes;
                    $data['creditor'] = 0;
                    $data['account'] = $Vendor;
                    $this->OneJunDetails($data, 0);


                    $data['debitor'] = 0;
                    $data['creditor'] = $new->Total;
                    $data['account'] = $store->Account;
                    $this->OneJunDetails($data, 0);


                    $data['debitor'] = 0;
                    $data['creditor'] = $Total_Taxes;
                    $data['account'] = $TTAX->Account;
                    $this->OneJunDetails($data, 0);


                    if ($paid != 0 or $paid > 0) {


                        $data['creditor_cred'] = $paid;
                        $data['account_cred'] = $Vendor;
                        $data['debitor_debt'] = $paid;
                        $data['account_debt'] = $Safe ;
                        $this->JunDetails($data);

                    }
                }
            }




    }


    //Later With Discount
    public function PayReturnLaterDiscount($data, $Vendor, $Safe, $RESIDUAL, $paid, $Total_Price)
    {


        $NewMkhazns = StoreCount::all();

            $NewMkhazns = StoreCount::all();

            if (count($NewMkhazns) == 1) {


                foreach ($NewMkhazns as $new) {

                    $store = Stores::find($new->Store);


                    $data['debitor'] =0;
                    $data['creditor'] = $Total_Price ;
                    $data['account'] = $store->Account;
                    $this->OneJunDetails($data, 0);


                    if ($paid != 0 or $paid > 0) {

                        $data['debitor'] = $Total_Price - $RESIDUAL;
                        $data['creditor'] = 0;
                        $data['account'] = $Vendor;
                        $this->OneJunDetails($data, 0);

                        $data['debitor'] = $RESIDUAL;
                        $data['creditor'] = 0;
                        $data['account'] = 206;
                        $this->OneJunDetails($data, 0);



                        $data['creditor_cred'] = $paid;
                        $data['account_cred'] = $Vendor;
                        $data['debitor_debt'] = $paid;
                        $data['account_debt'] = $Safe ;
                        $this->JunDetails($data);




                    } else {




                        $data['debitor'] = $Total_Price - $RESIDUAL ;
                        $data['creditor'] = 0;
                        $data['account'] = $Vendor;
                        $this->OneJunDetails($data, 0);



                        $data['debitor'] = $RESIDUAL;
                        $data['creditor'] = 0;
                        $data['account'] = 206;
                        $this->OneJunDetails($data, 0);




                    }


                }

            } else {


                foreach ($NewMkhazns as $new) {

                    $store = Stores::find($new->Store);


                    $data['debitor'] =0;
                    $data['creditor'] = $new->Total ;
                    $data['account'] = $store->Account;
                    $this->OneJunDetails($data, 0);


                    if ($paid != 0 or $paid > 0) {

                        $data['debitor'] = $new->Total - $RESIDUAL;
                        $data['creditor'] = 0;
                        $data['account'] = $Vendor;
                        $this->OneJunDetails($data, 0);

                        $data['debitor'] = $RESIDUAL;
                        $data['creditor'] = 0;
                        $data['account'] = 206;
                        $this->OneJunDetails($data, 0);



                        $data['creditor_cred'] = $paid;
                        $data['account_cred'] = $Vendor;
                        $data['debitor_debt'] = $paid;
                        $data['account_debt'] = $Safe ;
                        $this->JunDetails($data);




                    } else {




                        $data['debitor'] = $new->Total - $RESIDUAL ;
                        $data['creditor'] = 0;
                        $data['account'] = $Vendor;
                        $this->OneJunDetails($data, 0);



                        $data['debitor'] = $RESIDUAL;
                        $data['creditor'] = 0;
                        $data['account'] = 206;
                        $this->OneJunDetails($data, 0);




                    }


                }


            }




    }


    //Later With Discount and Taxes
    public function PayReturnLaterTaxDiscount($data, $Vendor, $Safe, $Total_Taxes, $RESIDUAL, $paid, $Total_Price)
    {


        $NewMkhazns = StoreCount::all();


            $NewMkhazns = StoreCount::all();


            if (count($NewMkhazns) == 1) {


                foreach ($NewMkhazns as $new) {

                    $store = Stores::find($new->Store);
                    $TTAX = Taxes::find($new->Tax);


                    $data['debitor'] = 0;
                    $data['creditor'] = $new->Total;
                    $data['account'] = $store->Account;
                    $this->OneJunDetails($data, 0);


                    $data['debitor'] = 0;
                    $data['creditor'] = $Total_Taxes;
                    $data['account'] = $TTAX->Account;
                    $this->OneJunDetails($data, 0);


                    if ($paid != 0 or $paid > 0) {


                        $data['debitor'] =  $new->Total + $Total_Taxes - $RESIDUAL;
                        $data['creditor'] =0;
                        $data['account'] = $Vendor;
                        $this->OneJunDetails($data, 0);

                        $data['debitor'] = $RESIDUAL;
                        $data['creditor'] = 0;
                        $data['account'] = 206;
                        $this->OneJunDetails($data, 0);

                        $data['creditor_cred'] = $paid ;
                        $data['account_cred'] = $Vendor;
                        $data['debitor_debt'] = $paid ;
                        $data['account_debt'] =$Safe ;
                        $this->JunDetails($data);

                    } else {


                        $data['debitor'] =  $new->Total + $Total_Taxes - $RESIDUAL;
                        $data['creditor'] =0;
                        $data['account'] = $Vendor;
                        $this->OneJunDetails($data, 0);

                        $data['debitor'] = $RESIDUAL;
                        $data['creditor'] = 0;
                        $data['account'] = 206;
                        $this->OneJunDetails($data, 0);


                    }


                }

            } else {


                foreach ($NewMkhazns as $new) {

                    $store = Stores::find($new->Store);
                    $TTAX = Taxes::find($new->Tax);


                    $data['debitor'] = 0;
                    $data['creditor'] = $new->Total;
                    $data['account'] = $store->Account;
                    $this->OneJunDetails($data, 0);


                    $data['debitor'] = 0;
                    $data['creditor'] = $Total_Taxes;
                    $data['account'] = $TTAX->Account;
                    $this->OneJunDetails($data, 0);


                    if ($paid != 0 or $paid > 0) {


                        $data['debitor'] =  $new->Total + $Total_Taxes - $RESIDUAL;
                        $data['creditor'] =0;
                        $data['account'] = $Vendor;
                        $this->OneJunDetails($data, 0);

                        $data['debitor'] = $RESIDUAL;
                        $data['creditor'] = 0;
                        $data['account'] = 206;
                        $this->OneJunDetails($data, 0);

                        $data['creditor_cred'] = $paid ;
                        $data['account_cred'] = $Vendor;
                        $data['debitor_debt'] = $paid ;
                        $data['account_debt'] =$Safe ;
                        $this->JunDetails($data);

                    } else {


                        $data['debitor'] =  $new->Total + $Total_Taxes - $RESIDUAL;
                        $data['creditor'] =0;
                        $data['account'] = $Vendor;
                        $this->OneJunDetails($data, 0);

                        $data['debitor'] = $RESIDUAL;
                        $data['creditor'] = 0;
                        $data['account'] = 206;
                        $this->OneJunDetails($data, 0);


                    }


                }


            }





    }


//============================================================================================
    //Purchases Order
    public function SaveNewPurchOrder($requests, $ID)
    {

        $Bill = PurchasesOrder::findOrFail($ID);


        $purch = PurchasesDefaultData::orderBy('id', 'desc')->first();


        if (!empty($requests['Purchases_Date'])) {

            //Event


            $data = [

                'start_date' => $requests['Purchases_Date'],
                'end_date' => $requests['Purchases_Date'],
                'event_name_ar' => 'تحويل امر شراء الي   فاتورة مشتريات ',
                'event_name_en' => 'Transfer Purchase Order to Purchase Bill',
                'type' => 'امر الشراء',
                'type_id' => null,
                'type_code' => $Bill->Code,
                'emp' => $requests['Delegate'],
                'client' => $requests['Vendor'],
                'product' => null,
                'customer' => null,

            ];


            $this->CreateEvent($data);


        }


        $order = [
            'noti_name_ar' => 'امر شراء',
            'noti_name_en' => 'Purchases Order',
            'type_ar' => 'امر شراء',
            'type_en' => 'Purchases Order',
            'type_code' => $Bill->Code,
            'emp' => $requests['Delegate'],
            'client' => $requests['Vendor'],
            'product' => null,
            'store' => $requests['Store'],
            'safe' => $requests['Safe'],
            'notify_name' => trans('admin.Purchases_Order'),
        ];
        $this->CreateNotification($order);


        if ($purch->Quality_Qty == 1) {


            $order = [
                'noti_name_ar' => 'امر شراء يحتاج للجودة و الكمية',
                'noti_name_en' => 'Purchases Order Need to Quality and Qty',
                'type_ar' => 'امر شراء',
                'type_en' => 'Purchases Order',
                'type_code' => $Bill->Code,
                'emp' => $requests['Delegate'],
                'client' => $requests['Vendor'],
                'product' => null,
                'store' => $requests['Store'],
                'safe' => $requests['Safe'],
                'notify_name' => trans('admin.Purchases_Order_Quality'),
            ];
            $this->CreateNotification($order);


        }

        if(!empty($requests['Ship'])) {
            $ship = $requests['Ship'];
        }else{

            $ship = null;
        }
        //Products Details
        if (!empty($requests['Unit'])) {

            $P_Ar_Name = $requests['P_Ar_Name'];
            $P_En_Name = $requests['P_En_Name'];
            $Unit = $requests['Unit'];
            $P_Code = $requests['P_Code'];
            $Qty = $requests['Qty'];
            $Price = $requests['Price'];
            $Discount = $requests['Discount'];
            $TotalBFTax = $requests['TotalBFTax'];
            $TotalTax = $requests['TotalTax'];
            $PurchTax = $requests['PurchTax'];
            $Total = $requests['Total'];
            $StorePurch = $requests['StorePurch'];
            $Exp_Date = $requests['Exp_Date'];
            $Product = $requests['Product'];
            $VOne = $requests['VOne'];
            $VTwo = $requests['VTwo'];
            $V_Name = $requests['V_Name'];
            $VV_Name = $requests['VV_Name'];
            $Exp_Date = $requests['Exp_Date'];
            $Price_Sale = $requests['Price_Sale'];
            $TDiscount = $requests['TDiscPro'];
            $Total_Net = $requests['Total_Net'];



            if(!empty($requests['ChassisNumber'])){
                $ChassisNumber=$requests['ChassisNumber'];
            }else{
                $ChassisNumber=[];
            }
            if(!empty($requests['MotorNumber'])){
                $MotorNumber=$requests['MotorNumber'];
            }else{
                $MotorNumber=[];
            }





            for ($i = 0; $i < count($Unit); $i++) {

                $pp = ProductUnits::where('Product', $Product[$i])->where('Unit', $Unit[$i])->first();
                $plow = ProductUnits::where('Product', $Product[$i])->where('Rate', 1)->first();

                $uu['Product_Code'] = $P_Code[$i];
                $uu['P_Ar_Name'] = $P_Ar_Name[$i];
                $uu['SmallCode'] = $plow->Barcode;
                $uu['P_En_Name'] = $P_En_Name[$i];
                $uu['V_Name'] = $V_Name[$i];
                $uu['VV_Name'] = $VV_Name[$i];
                $uu['Original_Qty'] = $Qty[$i];
                $uu['Qty'] = $Qty[$i];
                $uu['SmallQty'] = $Qty[$i] * $pp->Rate;
                $uu['Price'] = $Price[$i];
                $uu['Discount'] = $Discount[$i];
                $uu['Tax'] = $PurchTax[$i];
                $uu['Total_Bf_Tax'] = $TotalBFTax[$i];
                $uu['Total_Tax'] = $TotalTax[$i];
                $uu['Total'] = $Total[$i];
                $uu['Total_Net'] = $Total_Net[$i];
                $uu['Store'] = $StorePurch[$i];
                $uu['Product'] = $Product[$i];
                $uu['Unit'] = $Unit[$i];
                $uu['Exp_Date'] = $Exp_Date[$i];
                $uu['TDiscount'] = $TDiscount[$i];
                $uu['P_Order'] = $ID;
                $uu['Date'] = $requests['Date'];
                $uu['Code'] = $Bill->Code;
                $uu['Refernce_Number'] = $requests['Refernce_Number'];
                $uu['Safe'] = $requests['Safe'];
                $uu['Vendor'] = $requests['Vendor'];
                $uu['Delegate'] = $requests['Delegate'];
                $uu['Payment_Method'] = $requests['Payment_Method'];
                $uu['Coin'] = $requests['Coin'];
                $uu['Ship'] = $ship;
                $uu['User'] = auth()->guard('admin')->user()->id;
                $uu['Cost_Center'] = $requests['Cost_Center'];

                if(!empty($ChassisNumber[$i])){
                    $uu['ChassisNumber']=$ChassisNumber[$i];
                }

                if(!empty($MotorNumber[$i])){
                    $uu['MotorNumber']=$MotorNumber[$i];
                }


                if (!empty($V_Name[$i]) and !empty($VV_Name[$i])) {

                    $my_value = $V_Name[$i];
                    $first_word = explode(' - ', trim($my_value))[0];
                    $second_word = explode(' - ', trim($my_value))[1];

                    $vId = SubVirables::where('Name', 'like', $first_word . '%')->first();
                    $vvId = SubVirables::where('Name', 'like', $second_word . '%')->first();
                    if (empty($vId)) {
                        $vId = SubVirables::where('NameEn', 'like', $first_word . '%')->first();
                    }

                    if (empty($vvId)) {
                        $vvId = SubVirables::where('NameEn', 'like', $second_word . '%')->first();
                    }
                    $uu['V1'] = $vId->id;
                    $uu['V2'] = $vvId->id;

                } else {

                    $uu['V1'] = $VOne[$i];
                    $uu['V2'] = $VTwo[$i];
                }
                ProductsPurchasesOrder::create($uu);


            }


        }


    }

//Shortmings

    public function SaveNewShortmings($requests, $ID)
    {

        $Bill = Shortcomings::findOrFail($ID);



        //Event

        if (!empty($requests['Purchases_Date'])) {
            $data = [

                'start_date' => $requests['Purchases_Date'],
                'end_date' => $requests['Purchases_Date'],
                'event_name_ar' => 'شراء نواقص',
                'event_name_en' => 'Buy Shortcomings',
                'type' => 'النواقص',
                'type_id' => null,
                'type_code' => $Bill->Code,
                'emp' => $requests['Delegate'],
                'client' => $requests['Vendor'],
                'product' => null,
                'customer' => null,

            ];


            $this->CreateEvent($data);
        }




//Noti
        $order = [
            'noti_name_ar' => 'فاتوره نواقص',
            'noti_name_en' =>'Shortmings Bill',
            'type_ar' => 'النواقص',
            'type_en' => 'Shortmings',
            'type_code' => $Bill->Code,
            'emp' => $requests['Delegate'],
            'client' => $requests['Vendor'],
            'product' => null,
            'store' => $requests['Store'],
            'safe' => $requests['Safe'],
            'notify_name' => trans('admin.Shortmings_Bill'),
        ];
        $this->CreateNotification($order);







        if(!empty($requests['Ship'])) {
            $ship = $requests['Ship'];
        }else{

            $ship = null;
        }

        //Products Details
        if (!empty($requests['Unit'])) {

            $P_Ar_Name = $requests['P_Ar_Name'];
            $P_En_Name = $requests['P_En_Name'];
            $Unit = $requests['Unit'];

            $P_Code = $requests['P_Code'];
            $Qty = $requests['Qty'];
            $Price = $requests['Price'];
            $Discount = $requests['Discount'];
            $TotalBFTax = $requests['TotalBFTax'];
            $TotalTax = $requests['TotalTax'];
            $PurchTax = $requests['PurchTax'];
            $Total = $requests['Total'];
            $StorePurch = $requests['StorePurch'];
            $Exp_Date = $requests['Exp_Date'];
            $Product = $requests['Product'];
            $VOne = $requests['VOne'];
            $VTwo = $requests['VTwo'];
            $V_Name = $requests['V_Name'];
            $VV_Name = $requests['VV_Name'];
            $Exp_Date = $requests['Exp_Date'];
            $Price_Sale = $requests['Price_Sale'];
            $TDiscount = $requests['TDiscPro'];
            $Total_Net = $requests['Total_Net'];

            for ($i = 0; $i < count($Unit); $i++) {

                $pp = ProductUnits::where('Product', $Product[$i])->where('Unit', $Unit[$i])->first();
                $plow = ProductUnits::where('Product', $Product[$i])->where('Rate', 1)->first();

                $uu['Product_Code'] = $P_Code[$i];
                $uu['P_Ar_Name'] = $P_Ar_Name[$i];
                $uu['SmallCode'] = $plow->Barcode;
                $uu['P_En_Name'] = $P_En_Name[$i];
                $uu['V_Name'] = $V_Name[$i];
                $uu['VV_Name'] = $VV_Name[$i];
                $uu['Original_Qty'] = $Qty[$i];
                $uu['Qty'] = $Qty[$i];
                $uu['SmallQty'] = $Qty[$i] * $pp->Rate;
                $uu['Price'] = $Price[$i];
                $uu['Discount'] = $Discount[$i];
                $uu['Tax'] = $PurchTax[$i];
                $uu['Total_Bf_Tax'] = $TotalBFTax[$i];
                $uu['Total_Tax'] = $TotalTax[$i];
                $uu['Total'] = $Total[$i];
                $uu['Total_Net'] = $Total_Net[$i];
                $uu['Store'] = $StorePurch[$i];
                $uu['Product'] = $Product[$i];
                $uu['Unit'] = $Unit[$i];
                $uu['Exp_Date'] = $Exp_Date[$i];
                $uu['TDiscount'] = $TDiscount[$i];
                $uu['Shortmings'] = $ID;
                $uu['Date'] = $requests['Date'];
                $uu['Code'] = $Bill->Code;
                $uu['Refernce_Number'] = $requests['Refernce_Number'];
                $uu['Safe'] = $requests['Safe'];
                $uu['Vendor'] = $requests['Vendor'];
                $uu['Delegate'] = $requests['Delegate'];
                $uu['Payment_Method'] = $requests['Payment_Method'];
                $uu['Coin'] = $requests['Coin'];
                $uu['Ship'] = $ship;
                $uu['User'] = auth()->guard('admin')->user()->id;
                $uu['Cost_Center'] = $requests['Cost_Center'];

                if (!empty($V_Name[$i]) and !empty($VV_Name[$i])) {

                    $my_value = $V_Name[$i];
                    $first_word = explode(' - ', trim($my_value))[0];
                    $second_word = explode(' - ', trim($my_value))[1];

                    $vId = SubVirables::where('Name', 'like', $first_word . '%')->first();
                    $vvId = SubVirables::where('Name', 'like', $second_word . '%')->first();
                    if (empty($vId)) {
                        $vId = SubVirables::where('NameEn', 'like', $first_word . '%')->first();
                    }

                    if (empty($vvId)) {
                        $vvId = SubVirables::where('NameEn', 'like', $second_word . '%')->first();
                    }
                    $uu['V1'] = $vId->id;
                    $uu['V2'] = $vvId->id;

                } else {

                    $uu['V1'] = $VOne[$i];
                    $uu['V2'] = $VTwo[$i];
                }
                ProductsShortcomings::create($uu);


            }


        }


    }




}
