<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ReturnWithoutBill extends Model
{
    use HasFactory;
      protected $table = 'return_without_bills';
      protected $fillable = [
        'Code',
        'Date',
        'Draw',
        'Payment_Method',
        'Status',
        'Vendor_Bill_Date',
        'Refernce_Number',
        'Note',
        'Product_Numbers',
        'Total_Qty',
        'Total_Discount',
        'Total_BF_Taxes',
        'Total_Taxes',
        'Total_Price',
        'Total_Cost',
        'Pay',
        'Safe',
        'Vendor',
        'Deficit_Account',
        'Delegate',
        'Store',
        'Coin',
        'Cost_Center',
        'User',
        'Due_Date',
        'Later_Due',
             'TaxBill',
        'TaxCode',
                'Time',
        'Branch',
        'Delete',
        'Current_Credit',
    ];

        public function Safe_fk()
    {
        return $this->belongsTo(AcccountingManual::class,'Safe');
    }

         public function Safe()
    {
        return $this->belongsTo(AcccountingManual::class,'Safe');
    }

          public function Vendor_fk()
    {
        return $this->belongsTo(AcccountingManual::class,'Vendor');
    }


              public function Vendor()
    {
        return $this->belongsTo(AcccountingManual::class,'Vendor');
    }



          public function Delegate()
    {
        return $this->belongsTo(Employess::class,'Delegate');
    }
          public function Delegate_fk()
    {
        return $this->belongsTo(Employess::class,'Delegate');
    }


          public function Store()
    {
        return $this->belongsTo(Stores::class,'Store');
    }


          public function Store_fk()
    {
        return $this->belongsTo(Stores::class,'Store');
    }


          public function Coin()
    {
        return $this->belongsTo(Coins::class,'Coin');
    }

          public function Coin_fk()
    {
        return $this->belongsTo(Coins::class,'Coin');
    }


          public function Cost_Center()
    {
        return $this->belongsTo(CostCenter::class,'Cost_Center');
    }

          public function Cost_Center_fk()
    {
        return $this->belongsTo(CostCenter::class,'Cost_Center');
    }



          public function User()
    {
        return $this->belongsTo(Admin::class,'User');
    }

          public function User_fk()
    {
        return $this->belongsTo(Admin::class,'User');
    }

              public function ProductsPurchases()
    {
        return $this->hasOne(ProductsPurchases::class);
    }

                  public function RecivedPurcht()
    {
        return $this->hasOne(RecivedPurcht::class);
    }

                             public function ReturnPurch()
    {
        return $this->hasOne(ReturnPurch::class);
    }

                  public function Ship()
    {
        return $this->belongsTo(AcccountingManual::class,'Ship');
    }

                  public function Ship_fk()
    {
        return $this->belongsTo(AcccountingManual::class);
    }



                     public function Check_Type()
    {
        return $this->belongsTo(ChecksTypes::class,'Check_Type');
    }


                     public function Check_Type_fk()
    {
        return $this->belongsTo(ChecksTypes::class,'Check_Type');
    }

         public function Branch()
    {
        return $this->belongsTo(Branches::class,'Branch');
    }

    public function Branch_fk()
    {
        return $this->belongsTo(Branches::class,'Branch');
    }


           public function CustomerGroup()
    {
        return $this->belongsTo(CustomersGroup::class,'CustomerGroup');
    }

           public function CustomerGroup_fk()
    {
        return $this->belongsTo(CustomersGroup::class,'CustomerGroup');
    }


           public function ProductReturnWithoutBill()
    {
        return $this->hasOne(ProductReturnWithoutBill::class);
    }




}
