<?php

namespace App\Models\RealStates;

use App\Models\Measuerments;
use App\Models\Products;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GoodsProductProject extends Model
{
    use HasFactory;
    protected $table = 'goods_product_projects';
    protected $fillable = [

        'Goods',
        'Product',
        'P_Code',
        'P_Ar_Name',
        'P_En_Name',
        'Unit',
        'Qty',
        'AvQty',
        'Price',
        'Total',

    ];

    public function Goods()
    {
        return $this->belongsTo(GoodsProject::class,'Goods');
    }

    public function Product()
    {
        return $this->belongsTo(Products::class,'Product');
    }

    public function Unit()
    {
        return $this->belongsTo(Measuerments::class,'Unit');
    }
}
