<?php

namespace App\Listeners\StoresTransfer;


use App\Events\StoresTransferEvent;
use App\Models\AssemblyProducts;
use App\Models\Coins;
use App\Models\Customers;
use App\Models\ExpireDateQty;
use App\Models\FifoQty;
use App\Models\ProductMoves;
use App\Models\Products;
use App\Models\ProductSales;
use App\Models\ProductsQty;
use App\Models\ProductsStoresTransfers;
use App\Models\ProductUnits;
use App\Models\Sales;
use App\Models\Shifts;
use App\Models\ShippingCompany;
use App\Models\StoreCountSales;
use App\Models\Stores;
use App\Models\StoresDefaultData;
use App\Models\StorsTransfers;
use App\Models\SubVirables;
use App\Models\Taxes;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use App\Traits\GeneralTrait;

use App\Models\Journalizing;
use DB;
use App\Services\Average;
use App\Services\PurchasesService;

class StoresTransferListener
{


    use GeneralTrait;

    public function __construct()
    {

    }


    public function handle(StoresTransferEvent $event)
    {


        $average = new Average ;

        $type=$event->type;
        $ID=$event->ID;
        $Def=StoresDefaultData::latest('id')->first();
        $def=StoresDefaultData::latest('id')->first();
        $Bill=StorsTransfers::findOrFail($ID);
        $F=StorsTransfers::find($ID);
        $Fstore = Stores::find($event->requests['From_Store']);
        $Tstore = Stores::find($event->requests['To_Store']);

        //elly shary


        if(empty( $event->requests['Ship'])){
            $event->requests['Ship']=null;
        }
        if(empty( $event->requests['CostShip'])){
            $event->requests['CostShip']=null;
        }        if(empty( $event->requests['Cost_Store'])){
            $event->requests['Cost_Store']=null;
        }
        $store=Stores::find($event->requests['From_Store']);

        $data['Code'] = $Bill->Code;
        $data['Date'] = $event->requests['Date'];
        $data['Draw'] = $event->requests['Draw'];
        $data['Total'] = $event->requests['Total'];
        $data['TotalQty'] = $event->requests['TotalQty'];
        $data['Total_Cost'] = $event->requests['Total_Cost'];
        $data['Note'] = $event->requests['Note'];
        $data['From_Store'] = $event->requests['From_Store'];
        $data['To_Store'] = $event->requests['To_Store'];
        $data['Coin'] = $event->requests['Coin'];
        $data['Ship'] = $event->requests['Ship'];
        $data['CostShip'] = $event->requests['CostShip'];
        $data['Cost_Center'] = null;
        $data['Status'] = 1 + $event->requests['Edit'];
        $data['Delegate']=$event->requests['Delegate'];
        $data['TypeTransfer']=$event->requests['TypeTransfer'];
        $data['Cost_Store']=$event->requests['Cost_Store'];
        $data['User'] = auth()->guard('admin')->user()->id;
        $data['Branch']=$store->Branch;

        StorsTransfers::where('id',$ID)->update($data);


        //Noti
        $order=[
            'noti_name_ar'=>'تأكيد تحويل مخازن',
            'noti_name_en'=>'Stores Transfer Need Confirmed',
            'type_ar'=>'تحويلات المخازن',
            'type_en'=>'Stores Transfer',
            'type_code'=>$Bill->Code,
            'emp'=>null,
            'client'=>null,
            'product'=>null,
            'store'=>$event->requests['To_Store'],
            'safe'=>null,
            'notify_name'=>trans('admin.StoresTRansfer_Confirmed'),
        ];
        $this->CreateNotification($order);




        //Qty and Details
        if(!empty($event->requests['Unit'])){

            ProductsStoresTransfers::where('ST_ID',$ID)->delete();

            $P_Ar_Name=$event->requests['P_Ar_Name'];
            $P_En_Name=$event->requests['P_En_Name'];
            $Unit=$event->requests['Unit'];
            $P_Code=$event->requests['P_Code'];
            $Qty=$event->requests['Qty'];
            $Price=$event->requests['Price'];
            $Product=$event->requests['Product'];
            $VOne=$event->requests['VOne'];
            $VTwo=$event->requests['VTwo'];
            $V_Name=$event->requests['V_Name'];
            $VV_Name=$event->requests['VV_Name'];
            $Exp_Date=$event->requests['Exp_Date'];
            $CostPrice=$event->requests['CostPrice'];
            $OldPrice=$event->requests['OldPrice'];
            $Trans_Qty=$event->requests['Trans_Qty'];
            $OrgTrans_Qty=$event->requests['Original_Trans_Qty'];
            $TotalP=$event->requests['TotalP'];

            for($i=0 ; $i < count($Unit) ; $i++){

                $pp=ProductUnits::where('Unit',$Unit[$i])->where('Product',$Product[$i])->first();
                $plow=ProductUnits::where('Product',$Product[$i])->where('Def',1)->first();

                $uu['ST_ID']=$ID;
                $uu['P_Ar_Name']=$P_Ar_Name[$i];
                $uu['P_En_Name']=$P_En_Name[$i];
                $uu['V_Name']=$V_Name[$i];
                $uu['VV_Name']=$VV_Name[$i];
                $uu['P_Code']=$P_Code[$i];
                $uu['SmallCode']=$plow->Barcode;
                $uu['Price']=$Price[$i];
                $uu['Av_Qty']=$Qty[$i];
                $uu['Trans_Qty']=$Trans_Qty[$i];
                $uu['Original_Trans_Qty']=$OrgTrans_Qty[$i];
                $uu['SmallTrans_Qty']=$Trans_Qty[$i] * $pp->Rate;
                $uu['Total']=$TotalP[$i];
                $uu['Product']=$Product[$i];
                $uu['V1']=$VOne[$i];
                $uu['V2']=$VTwo[$i];
                $uu['Unit']=$Unit[$i];
                $uu['OldPrice']=$OldPrice[$i];
                $uu['To_Store']=$event->requests['To_Store'];
                $uu['CostPrice']=$CostPrice[$i];
                $uu['Exp_Date']=$Exp_Date[$i];
                ProductsStoresTransfers::create($uu);


                if($type == 1) {

                    if (empty($event->requests['Ship'])) {

                        $prooooo = Products::find($Product[$i]);
                        $Quantity=$this->ProAvQties($event->requests['From_Store'],$Product[$i],$P_Code[$i]);
                        $QuantityTo=$this->ProAvQties($event->requests['To_Store'],$Product[$i],$P_Code[$i]);

                        $plow = ProductUnits::where('Product', $Product[$i])->where('Def', 1)->first();
                        $unit = ProductUnits::where('Unit', $Unit[$i])->where('Product', $Product[$i])->first();
                        $qq = $unit->Rate * $Trans_Qty[$i];
                        $newQQty = $unit->Rate * $Trans_Qty[$i];

                        $ty = $average->AverageCostGetUnit($Product[$i], $P_Code[$i],$event->requests['From_Store'],$Unit[$i]);

                        $CostTotalSale = $ty * $newQQty;


                        $prooooo=Products::findOrFail($Product[$i]);



                        $newqty = $Quantity->Qty - $qq;

                        $in = 0;
                        $out = $CostTotalSale;

                        $current= $newqty *  ($ty / $unit->Rate);
                        if (!empty($Quantity)) {
                            $old = $Quantity->Qty - $qq;
                            $cur = $old * ($ty / $unit->Rate);

                            if($old < 0){

                                return 5;
                            }

                            ProductsQty::where('id', $Quantity->id)->update(['Qty' => $old, 'Price' => $ty, 'TotalCost' => $cur]);

                        }


                        $store=Stores::find($event->requests['From_Store']);
                        //Product Moves
                        $move=[

                            'Date'=>$event->requests['Date'],
                            'Type'=> 'تحويل مخازن',
                            'TypeEn'=>'Stores Transfer',
                            'Bill_Num'=>$Bill->Code,
                            'Incom'=>0,
                            'Outcom'=>$qq,
                            'Current'=>$newqty,
                            'CostIn'=>number_format((float)$in, 2, '.', ''),
                            'CostOut'=>number_format((float)$out, 2, '.', ''),
                            'CostCurrent'=>number_format((float)$current, 2, '.', ''),
                            'P_Ar_Name'=>$P_Ar_Name[$i],
                            'P_En_Name'=>$P_En_Name[$i],
                            'P_Code'=>$P_Code[$i],
                            'Unit'=>$Unit[$i],
                            'Qty'=>$Trans_Qty[$i],
                            'Group'=>$prooooo->Group,
                            'Store'=>$event->requests['From_Store'],
                            'Product'=>$Product[$i],
                            'V1'=>$VOne[$i],
                            'V2'=>$VTwo[$i],
                            'Brand'=>$prooooo->Brand,
                            'Safe'=>null,
                            'Branch'=>$store->Branch,
                            'SalePrice'=>$plow->Price,
                            'ProductPrice'=>null,
                            'Delegate'=>$event->requests['Delegate'],
                            'Payment_Method'=>null,
                            'User'=>auth()->guard('admin')->user()->id,

                        ];
                        $this->ProductMoves($move);


                        //Fifo

                        if ($def->Cost_Price == 2) {

                            $fifo=$this->FifoAvQtyDate($event->requests['From_Store'],$Product[$i],$P_Code[$i]);

                            if (!empty($fifo)) {

                                if ($fifo->Qty >= $Trans_Qty[$i]) {


                                    $unit = ProductUnits::where('Unit', $Unit[$i])->where('Product', $Product[$i])->first();

                                    $qq = $unit->Rate * $Trans_Qty[$i];

                                    $newqty = $fifo->Qty - $qq;


                                    if($newqty < 0){

                                        return 5;
                                    }

                                    FifoQty::where('id', $fifo->id)->update(['Qty' => $newqty]);


                                } else {


                                    $resdiualQty = $Trans_Qty[$i] - $fifo->Qty;

                                    $unit = ProductUnits::where('Unit', $Unit[$i])->where('Product', $Product[$i])->first();

                                    $qq = $unit->Rate * $fifo->Qty;

                                    $newqty = $fifo->Qty - $qq;


                                    if($newqty < 0){

                                        return 5;
                                    }

                                    FifoQty::where('id', $fifo->id)->update(['Qty' => $newqty]);


                                    $ResdiualCost = $this->FifoStoreQty($fifo->Store, $fifo->Product, $fifo->P_Code, $fifo->id, $fifo->Purchases_Date, $resdiualQty, $Unit[$i]);


                                }


                            }


                        }



                        if (!empty($QuantityTo)) {
                            $prooooo = Products::find($Product[$i]);
                            $New = $QuantityTo->Qty + $qq;

                            if ($Def->StoresTarnsferPrice == 0) {

                                $prooooo=Products::findOrFail($Product[$i]);

                                if($prooooo->P_Type == 'Serial' or $prooooo->P_Type == 'Single_Variable' or $prooooo->P_Type == 'Duble_Variable' ) {
                                    $lastOperation = ProductMoves::latest('id')->where('P_Code', $P_Code[$i])->where('Product', $Product[$i])->where('Store', $event->requests['To_Store'])->first();
                                }else{
                                    $lastOperation = ProductMoves::latest('id')->where('Product', $Product[$i])->where('Store', $event->requests['To_Store'])->first();
                                }




                                if (!empty($lastOperation->Current)) {

                                    $newQQty = $unit->Rate * $Trans_Qty[$i];

                                    $ty=$average->AverageCost($TotalP[$i],$newQQty,$Product[$i],$P_Code[$i],$event->requests['To_Store'],$event->requests['Date'],$plow->Price);



                                    $prooooo=Products::findOrFail($Product[$i]);

                                    if($prooooo->P_Type == 'Serial' or $prooooo->P_Type == 'Single_Variable' or $prooooo->P_Type == 'Duble_Variable' ) {
                                        $lastOperation = ProductMoves::latest('id')->where('P_Code', $P_Code[$i])->where('Product', $Product[$i])->where('Store', $event->requests['To_Store'])->first();
                                    }else{
                                        $lastOperation = ProductMoves::latest('id')->where('Product', $Product[$i])->where('Store', $event->requests['To_Store'])->first();
                                    }



                                    $in = $TotalP[$i];
                                    $out = 0;
                                    if (!empty($lastOperation)) {
                                        $current = $lastOperation->CostCurrent + $TotalP[$i];
                                    } else {
                                        $current = $TotalP[$i];
                                    }


                                } else {

                                    $newQQty = $unit->Rate * $Trans_Qty[$i];

                                    $ty=$average->AverageCost($TotalP[$i],$newQQty,$Product[$i],$plow->Barcode,$event->requests['To_Store'],$event->requests['Date'],$plow->Price);

                                    $CostTotalSale = $ty * $newQQty;

                                    $in = $CostTotalSale;
                                    $out = 0;

                                    $current = $ty * $newQQty;
                                }


                            } else {


                                $newQQty = $unit->Rate * $Trans_Qty[$i];


                                $ty=$average->AverageCost($TotalP[$i],$newQQty,$Product[$i], $P_Code[$i],$event->requests['To_Store'],$event->requests['Date'],$plow->Price);

                                $prooooo=Products::findOrFail($Product[$i]);

                                if($prooooo->P_Type == 'Serial' or $prooooo->P_Type == 'Single_Variable' or $prooooo->P_Type == 'Duble_Variable' ) {
                                    $lastOperation = ProductMoves::latest('id')->where('P_Code', $P_Code[$i])->where('Product', $Product[$i])->where('Store', $event->requests['To_Store'])->first();
                                }else{
                                    $lastOperation = ProductMoves::latest('id')->where('Product', $Product[$i])->where('Store', $event->requests['To_Store'])->first();
                                }




                                $in = $TotalP[$i];
                                $out = 0;
                                if (!empty($lastOperation)) {
                                    $current = $lastOperation->CostCurrent + $TotalP[$i];
                                } else {
                                    $current = $TotalP[$i];
                                }


                            }


                            $cur = $New * $ty;
                            ProductsQty::where('id', $QuantityTo->id)->update(['Qty' => $New, 'Price' => $ty, 'TotalCost' => $cur]);


                            $store=Stores::find($event->requests['To_Store']);
                            //Product Moves
                            $move=[

                                'Date'=>$event->requests['Date'],
                                'Type'=> 'تحويل مخازن',
                                'TypeEn'=>'Stores Transfer',
                                'Bill_Num'=>$Bill->Code,
                                'Incom'=>$qq,
                                'Outcom'=>0,
                                'Current'=>$New,
                                'CostIn'=>number_format((float)$in, 2, '.', ''),
                                'CostOut'=>number_format((float)$out, 2, '.', ''),
                                'CostCurrent'=>number_format((float)$current, 2, '.', ''),
                                'P_Ar_Name'=>$P_Ar_Name[$i],
                                'P_En_Name'=>$P_En_Name[$i],
                                'P_Code'=>$P_Code[$i],
                                'Unit'=>$Unit[$i],
                                'Qty'=>$Trans_Qty[$i],
                                'Group'=>$prooooo->Group,
                                'Store'=>$event->requests['To_Store'],
                                'Product'=>$Product[$i],
                                'V1'=>$VOne[$i],
                                'V2'=>$VTwo[$i],
                                'Brand'=>$prooooo->Brand,
                                'Safe'=>null,
                                'Branch'=>$store->Branch,
                                'SalePrice'=>$plow->Price,
                                'ProductPrice'=>null,
                                'Delegate'=>$event->requests['Delegate'],
                                'Payment_Method'=>null,
                                'User'=>auth()->guard('admin')->user()->id,

                            ];
                            $this->ProductMoves($move);



                        } else {

                            $plow = ProductUnits::where('Product', $Product[$i])->where('Rate', 1)->first();
                            $unit = ProductUnits::where('Product', $Product[$i])->where('Unit', $Unit[$i])->first();



                            if ($Def->StoresTarnsferPrice == 0) {


                                $prooooo=Products::findOrFail($Product[$i]);

                                if($prooooo->P_Type == 'Serial' or $prooooo->P_Type == 'Single_Variable' or $prooooo->P_Type == 'Duble_Variable' ) {
                                    $lastOperation = ProductMoves::latest('id')->where('P_Code', $P_Code[$i])->where('Product', $Product[$i])->where('Store', $event->requests['To_Store'])->first();
                                }else{
                                    $lastOperation = ProductMoves::latest('id')->where('Product', $Product[$i])->where('Store', $event->requests['To_Store'])->first();
                                }



                                if (!empty($lastOperation->Current)) {


                                    $newQQty = $unit->Rate * $Trans_Qty[$i];

                                    $ty=$average->AverageCost($TotalP[$i],$newQQty,$Product[$i], $P_Code[$i],$event->requests['To_Store'],$event->requests['Date'],$plow->Price);

                                    $prooooo=Products::findOrFail($Product[$i]);

                                    if($prooooo->P_Type == 'Serial' or $prooooo->P_Type == 'Single_Variable' or $prooooo->P_Type == 'Duble_Variable' ) {
                                        $lastOperation = ProductMoves::latest('id')->where('P_Code', $P_Code[$i])->where('Product', $Product[$i])->where('Store', $event->requests['To_Store'])->first();
                                    }else{
                                        $lastOperation = ProductMoves::latest('id')->where('Product', $Product[$i])->where('Store', $event->requests['To_Store'])->first();
                                    }




                                    $in = ($TotalP[$i] / $unit->Rate);
                                    $out = 0;
                                    if (!empty($lastOperation)) {
                                        $current = $lastOperation->CostCurrent + ($TotalP[$i] / $unit->Rate);
                                    } else {
                                        $current = ($TotalP[$i] / $unit->Rate);
                                    }


                                } else {

                                    $newQQty = $unit->Rate * $Trans_Qty[$i];

                                    $ty=$average->AverageCost($TotalP[$i],$newQQty,$Product[$i], $plow->Barcode,$event->requests['To_Store'],$event->requests['Date'],$plow->Price);

                                    $CostTotalSale = $ty * $newQQty;

                                    $in = $CostTotalSale;
                                    $out = 0;

                                    $current = $ty * $newQQty;
                                }


                            } else {


                                $newQQty = $unit->Rate * $Trans_Qty[$i];
                                $ty=$average->AverageCost($TotalP[$i],$newQQty,$Product[$i], $P_Code[$i],$event->requests['To_Store'],$event->requests['Date'],$plow->Price);


                                $prooooo=Products::findOrFail($Product[$i]);

                                if($prooooo->P_Type == 'Serial' or $prooooo->P_Type == 'Single_Variable' or $prooooo->P_Type == 'Duble_Variable' ) {
                                    $lastOperation = ProductMoves::latest('id')->where('P_Code', $P_Code[$i])->where('Product', $Product[$i])->where('Store', $event->requests['To_Store'])->first();
                                }else{
                                    $lastOperation = ProductMoves::latest('id')->where('Product', $Product[$i])->where('Store', $event->requests['To_Store'])->first();
                                }




                                $in = $TotalP[$i];
                                $out = 0;
                                if (!empty($lastOperation)) {
                                    $current = $lastOperation->CostCurrent + ($TotalP[$i] / $unit->Rate);
                                } else {
                                    $current = ($TotalP[$i] / $unit->Rate);
                                }


                            }


                            $id_store = DB::table('products_stores')->insertGetId(

                                array(

                                    'P_Ar_Name' => $P_Ar_Name[$i],
                                    'P_En_Name' => $P_En_Name[$i],
                                    'P_Code' => $P_Code[$i],
                                    'Exp_Date' => null,
                                    'Product' => $Product[$i],
                                    'Store' => $event->requests['To_Store'],
                                    'V1' => $VOne[$i],
                                    'V2' => $VTwo[$i],
                                    'V_Name' => $V_Name[$i],
                                    'VV_Name' => $VV_Name[$i],

                                )
                            );


                            $plow = ProductUnits::where('Product', $Product[$i])->where('Rate', 1)->first();

                            $PRICE_RATE=$Price[$i]  /  $unit->Rate ;
                            $pqty['P_Ar_Name'] = $P_Ar_Name[$i];
                            $pqty['P_En_Name'] = $P_En_Name[$i];
                            $pqty['Qty'] = $qq;
                            $pqty['Price'] = $PRICE_RATE;
                            $pqty['Pro_Stores'] = $id_store;
                            $pqty['Store'] = $event->requests['To_Store'];
                            $pqty['Unit'] = $Unit[$i];
                            $pqty['Low_Unit'] = $plow->Unit;
                            $pqty['Product'] = $Product[$i];
                            $pqty['V1'] = $VOne[$i];
                            $pqty['V2'] = $VTwo[$i];
                            $pqty['V_Name'] = $V_Name[$i];
                            $pqty['VV_Name'] = $VV_Name[$i];


                            $prooooo = Products::find($Product[$i]);
                            $pqty['SearchCode1'] = $prooooo->SearchCode1;
                            $pqty['SearchCode2'] = $prooooo->SearchCode2;
                            if ($prooooo->P_Type == 'Serial' or $prooooo->P_Type == 'Single_Variable' or $prooooo->P_Type == 'Duble_Variable') {
                                $proooooStore = Stores::find($event->requests['To_Store']);
                                $pqty['Group'] = $prooooo->Group;
                                $pqty['Brand'] = $prooooo->Brand;
                                $pqty['Branch'] = $proooooStore->Branch;
                                $pqty['P_Code'] = $P_Code[$i];

                            } else {

                                $coco = array();
                                $CodesPrds = ProductUnits::where('Product', $Product[$i])->select('Barcode')->get();
                                foreach ($CodesPrds as $cco) {


                                    array_push($coco, $cco->Barcode);

                                }

                                $pqty['P_Code'] = $coco[0];

                                if (!empty($coco[1])) {
                                    $pqty['PP_Code'] = $coco[1];
                                } else {
                                    $pqty['PP_Code'] = null;
                                }

                                if (!empty($coco[2])) {
                                    $pqty['PPP_Code'] = $coco[2];
                                } else {
                                    $pqty['PPP_Code'] = null;
                                }

                                if (!empty($coco[3])) {
                                    $pqty['PPPP_Code'] = $coco[3];
                                } else {
                                    $pqty['PPPP_Code'] = null;
                                }
                            }


                            $pqty['TotalCost'] = $PRICE_RATE * $qq;
                            ProductsQty::create($pqty);



                            $store=Stores::find($event->requests['To_Store']);
                            //Product Moves
                            $move=[

                                'Date'=>$event->requests['Date'],
                                'Type'=> 'تحويل مخازن',
                                'TypeEn'=>'Stores Transfer',
                                'Bill_Num'=>$Bill->Code,
                                'Incom'=>$qq,
                                'Outcom'=>0,
                                'Current'=>$qq,
                                'CostIn'=>number_format((float)$in, 2, '.', ''),
                                'CostOut'=>number_format((float)$out, 2, '.', ''),
                                'CostCurrent'=>number_format((float)$current, 2, '.', ''),
                                'P_Ar_Name'=>$P_Ar_Name[$i],
                                'P_En_Name'=>$P_En_Name[$i],
                                'P_Code'=>$P_Code[$i],
                                'Unit'=>$Unit[$i],
                                'Qty'=>$Trans_Qty[$i],
                                'Group'=>$prooooo->Group,
                                'Store'=>$event->requests['To_Store'],
                                'Product'=>$Product[$i],
                                'V1'=>$VOne[$i],
                                'V2'=>$VTwo[$i],
                                'Brand'=>$prooooo->Brand,
                                'Safe'=>null,
                                'Branch'=>$store->Branch,
                                'SalePrice'=>$plow->Price,
                                'ProductPrice'=>null,
                                'Delegate'=>$event->requests['Delegate'],
                                'Payment_Method'=>null,
                                'User'=>auth()->guard('admin')->user()->id,

                            ];
                            $this->ProductMoves($move);



                        }




                      if(!empty($Exp_Date[$i])) {

                          $EXPOFrom=$this->ExpireAvQtiesCheck($event->requests['From_Store'],$Product[$i],$P_Code[$i],$Exp_Date[$i]);

                          if (!empty($EXPOFrom)) {
                              $unit = ProductUnits::where('Unit', $Unit[$i])->where('Product', $Product[$i])->first();
                              $qq = $unit->Rate * $Trans_Qty[$i];
                              $EXPO = ExpireDateQty::find($EXPOFrom->id);
                              $NewExpQty = $EXPO->Qty - $qq;

                              if($NewExpQty < 0){

                                  return 5;
                              }

                              ExpireDateQty::where('id', $EXPOFrom->id)->update(['Qty' => $NewExpQty]);

                          }


                          if (!empty($EXPOFrom)) {

                              $EXPOTo=$this->ExpireAvQtiesCheck($event->requests['To_Store'],$Product[$i],$P_Code[$i],$Exp_Date[$i]);


                              if (!empty($EXPOTo)) {

                                  $unit = ProductUnits::where('Unit', $Unit[$i])->where('Product', $Product[$i])->first();
                                  $qqT = $unit->Rate * $Trans_Qty[$i];
                                  $EXPOT = ExpireDateQty::find($EXPOTo->id);
                                  $NewExpQtyT = $EXPOT->Qty + $qqT;
                                  ExpireDateQty::where('id', $EXPOTo->id)->update(['Qty' => $NewExpQtyT]);
                              } else {


                                  $EXNEW['Qty'] = $unit->Rate * $Trans_Qty[$i];
                                  $EXNEW['P_Ar_Name'] = $EXPOFrom->P_Ar_Name;
                                  $EXNEW['P_En_Name'] = $EXPOFrom->P_En_Name;
                                  $EXNEW['P_Code'] = $EXPOFrom->P_Code;
                                  $EXNEW['PP_Code'] = $EXPOFrom->PP_Code;
                                  $EXNEW['PPP_Code'] = $EXPOFrom->PPP_Code;
                                  $EXNEW['PPPP_Code'] = $EXPOFrom->PPPP_Code;
                                  $EXNEW['V_Name'] = $EXPOFrom->V_Name;
                                  $EXNEW['VV_Name'] = $EXPOFrom->VV_Name;
                                  $EXNEW['Store'] = request('To_Store');
                                  $EXNEW['Unit'] = $EXPOFrom->Unit;
                                  $EXNEW['Product'] = $EXPOFrom->Product;
                                  $EXNEW['V1'] = $EXPOFrom->V1;
                                  $EXNEW['V2'] = $EXPOFrom->V2;
                                  $EXNEW['Low_Unit'] = $EXPOFrom->Low_Unit;
                                  $EXNEW['Exp_Date'] = $EXPOFrom->Exp_Date;
                                  $EXNEW['Group'] = $EXPOFrom->Group;
                                  $EXNEW['Brand'] = $EXPOFrom->Brand;
                                  $EXNEW['Branch'] = $EXPOFrom->Branch;

                                  ExpireDateQty::create($EXNEW);


                              }


                          }
                      }

                        //Fifo

                        if ($def->Cost_Price == 2) {

                            $fifo=$this->FifoAvQtyDate($event->requests['To_Store'],$Product[$i],$P_Code[$i]);


                            if (!empty($fifo)) {

                                $unit = ProductUnits::where('Unit', $Unit[$i])->where('Product', $Product[$i])->first();

                                $qq = $unit->Rate * $Trans_Qty[$i];

                                $newqty = $fifo->Qty + $qq;

                                FifoQty::where('id', $fifo->id)->update(['Qty' => $newqty, 'Original_Qty' => $newqty]);

                            } else {


                                if (!empty($V_Name[$i]) and !empty($VV_Name[$i])) {

                                    $my_value = $V_Name[$i];
                                    $first_word = explode(' - ', trim($my_value))[0];
                                    $second_word = explode(' - ', trim($my_value))[1];

                                    $vId = SubVirables::where('Name', 'like', $first_word . '%')->first();
                                    $vvId = SubVirables::where('Name', 'like', $second_word . '%')->first();
                                    if (empty($vId)) {
                                        $vId = SubVirables::where('NameEn', 'like', $first_word . '%')->first();
                                    }

                                    if (empty($vvId)) {
                                        $vvId = SubVirables::where('NameEn', 'like', $second_word . '%')->first();
                                    }
                                    $sNam = $first_word;
                                    $sId = $vId->id;
                                    $ssNam = $second_word;
                                    $ssId = $vvId->id;

                                } else {

                                    $sNam = $V_Name[$i];
                                    $ssNam = $VV_Name[$i];
                                    $sId = $VOne[$i];
                                    $ssId = $VTwo[$i];
                                }


                                $pqty['P_Ar_Name'] = $P_Ar_Name[$i];
                                $pqty['Exp_Date'] = null;
                                $pqty['P_En_Name'] = $P_En_Name[$i];
                                $pqty['Qty'] = $Trans_Qty[$i] * $pp->Rate;
                                $pqty['Original_Qty'] = $Trans_Qty[$i] * $pp->Rate;
                                $pqty['Cost_Price'] = $Price[$i];
                                $pqty['Store'] = $event->requests['To_Store'];
                                $pqty['Unit'] = $Unit[$i];
                                $pqty['Low_Unit'] = $plow->Unit;
                                $pqty['Product'] = $Product[$i];

                                $prooooo = Products::find($Product[$i]);
                                $pqty['SearchCode1'] = $prooooo->SearchCode1;
                                $pqty['SearchCode2'] = $prooooo->SearchCode2;
                                if (!empty($V_Name[$i]) and !empty($VV_Name[$i])) {

                                    $my_value = $V_Name[$i];
                                    $first_word = explode(' - ', trim($my_value))[0];
                                    $second_word = explode(' - ', trim($my_value))[1];

                                    $vId = SubVirables::where('Name', 'like', $first_word . '%')->first();
                                    $vvId = SubVirables::where('Name', 'like', $second_word . '%')->first();
                                    if (empty($vId)) {
                                        $vId = SubVirables::where('NameEn', 'like', $first_word . '%')->first();
                                    }

                                    if (empty($vvId)) {
                                        $vvId = SubVirables::where('NameEn', 'like', $second_word . '%')->first();
                                    }
                                    $pqty['V1'] = $vId->id;
                                    $pqty['V2'] = $vvId->id;
                                    $pqty['V_Name'] = $first_word;
                                    $pqty['VV_Name'] = $second_word;
                                    $pqty['P_Code'] = $P_Code[$i];

                                } else {


                                    if ($prooooo->P_Type == 'Serial') {

                                        $pqty['V1'] = $VOne[$i];
                                        $pqty['V2'] = $VTwo[$i];
                                        $pqty['V_Name'] = $V_Name[$i];
                                        $pqty['VV_Name'] = $VV_Name[$i];
                                        $pqty['P_Code'] = $P_Code[$i];

                                    } else {


                                        if ($prooooo->P_Type == 'Single_Variable') {
                                            $pqty['V1'] = $VOne[$i];
                                            $pqty['V2'] = $VTwo[$i];
                                            $pqty['V_Name'] = $V_Name[$i];
                                            $pqty['VV_Name'] = $VV_Name[$i];
                                            $pqty['P_Code'] = $P_Code[$i];

                                        } elseif ($prooooo->P_Type == 'Duble_Variable') {

                                            $pqty['P_Code'] = $P_Code[$i];

                                        } else {


                                            $coco = array();
                                            $CodesPrds = ProductUnits::where('Product', $Product[$i])->select('Barcode')->get();
                                            foreach ($CodesPrds as $cco) {


                                                array_push($coco, $cco->Barcode);

                                            }

                                            $pqty['V1'] = $VOne[$i];
                                            $pqty['V2'] = $VTwo[$i];
                                            $pqty['V_Name'] = $V_Name[$i];
                                            $pqty['VV_Name'] = $VV_Name[$i];
                                            $pqty['P_Code'] = $coco[0];

                                            if (!empty($coco[1])) {
                                                $pqty['PP_Code'] = $coco[1];
                                            } else {
                                                $pqty['PP_Code'] = null;
                                            }

                                            if (!empty($coco[2])) {
                                                $pqty['PPP_Code'] = $coco[2];
                                            } else {
                                                $pqty['PPP_Code'] = null;
                                            }

                                            if (!empty($coco[3])) {
                                                $pqty['PPPP_Code'] = $coco[3];
                                            } else {
                                                $pqty['PPPP_Code'] = null;
                                            }

                                        }


                                    }


                                }

                                $proooooStore = Stores::find($event->requests['To_Store']);
                                $pqty['Group'] = $prooooo->Group;
                                $pqty['Brand'] = $prooooo->Brand;
                                $pqty['Branch'] = $proooooStore->Branch;
                                $pqty['Purchases_Date'] =$event->requests['Date'];
                                FifoQty::create($pqty);


                            }


                        }


                    }

                }else{



                    $prooooo = Products::find($Product[$i]);
                    $Quantity=$this->ProAvQties($event->requests['From_Store'],$Product[$i],$P_Code[$i]);
                    $QuantityTo=$this->ProAvQties($event->requests['To_Store'],$Product[$i],$P_Code[$i]);

                    $plow = ProductUnits::where('Product', $Product[$i])->where('Rate', 1)->first();
                    $unit = ProductUnits::where('Unit', $Unit[$i])->where('Product', $Product[$i])->first();
                    $qq = $unit->Rate * $Trans_Qty[$i];
                    $newQQty = $unit->Rate * $Trans_Qty[$i];

                    $ty = $average->AverageCostGetUnit($Product[$i], $P_Code[$i],$event->requests['From_Store'],$Unit[$i]);

                    $CostTotalSale = $ty * $newQQty;


                    $prooooo=Products::findOrFail($Product[$i]);

                    if($prooooo->P_Type == 'Serial' or $prooooo->P_Type == 'Single_Variable' or $prooooo->P_Type == 'Duble_Variable' ) {
                        $lastOperation = ProductMoves::orderBy('id', 'desc')->where('P_Code', $P_Code[$i])->where('Product', $Product[$i])->where('Store', $event->requests['From_Store'])->first();
                    }else{
                        $lastOperation = ProductMoves::orderBy('id', 'desc')->where('Product', $Product[$i])->where('Store', $event->requests['From_Store'])->first();
                    }




                    $in = 0;
                    $out = $CostTotalSale;

                    if (!empty($lastOperation->Current)) {
                        if ($lastOperation->Current != 0) {
                            $current = ($lastOperation->Current - $newQQty) * $ty;
                        } else {
                            $current = ($newQQty) * $ty;
                        }
                    } else {
                        $current = ($newQQty) * $ty;
                    }
                    if (!empty($Quantity)) {
                        $old = $Quantity->Qty - $qq;
                        $cur = $old * ($ty / $unit->Rate);
                        if($old < 0){

                            return 5;
                        }

                        ProductsQty::where('id', $Quantity->id)->update(['Qty' => $old, 'Price' => $ty, 'TotalCost' => $cur]);

                    }


                    $store=Stores::find($event->requests['From_Store']);
                    //Product Moves
                    $move=[

                        'Date'=>$event->requests['Date'],
                        'Type'=> 'تحويل مخازن',
                        'TypeEn'=>'Stores Transfer',
                        'Bill_Num'=>$Bill->Code,
                        'Incom'=>0,
                        'Outcom'=>$qq,
                        'Current'=>$newqty,
                        'CostIn'=>number_format((float)$in, 2, '.', ''),
                        'CostOut'=>number_format((float)$out, 2, '.', ''),
                        'CostCurrent'=>number_format((float)$current, 2, '.', ''),
                        'P_Ar_Name'=>$P_Ar_Name[$i],
                        'P_En_Name'=>$P_En_Name[$i],
                        'P_Code'=>$P_Code[$i],
                        'Unit'=>$Unit[$i],
                        'Qty'=>$Trans_Qty[$i],
                        'Group'=>$prooooo->Group,
                        'Store'=>$event->requests['From_Store'],
                        'Product'=>$Product[$i],
                        'V1'=>$VOne[$i],
                        'V2'=>$VTwo[$i],
                        'Brand'=>$prooooo->Brand,
                        'Safe'=>null,
                        'Branch'=>$store->Branch,
                        'SalePrice'=>$plow->Price,
                        'ProductPrice'=>null,
                        'Delegate'=>$event->requests['Delegate'],
                        'Payment_Method'=>null,
                        'User'=>auth()->guard('admin')->user()->id,

                    ];
                    $this->ProductMoves($move);


                    //Fifo

                    if ($def->Cost_Price == 2) {

                        $fifo=$this->FifoAvQtyDate($event->requests['From_Store'],$Product[$i],$P_Code[$i]);

                        if (!empty($fifo)) {

                            if ($fifo->Qty >= $Trans_Qty[$i]) {


                                $unit = ProductUnits::where('Unit', $Unit[$i])->where('Product', $Product[$i])->first();

                                $qq = $unit->Rate * $Trans_Qty[$i];

                                $newqty = $fifo->Qty - $qq;

                                if($newqty < 0){

                                    return 5;
                                }


                                FifoQty::where('id', $fifo->id)->update(['Qty' => $newqty]);


                            } else {


                                $resdiualQty = $Trans_Qty[$i] - $fifo->Qty;

                                $unit = ProductUnits::where('Unit', $Unit[$i])->where('Product', $Product[$i])->first();

                                $qq = $unit->Rate * $fifo->Qty;

                                $newqty = $fifo->Qty - $qq;

                                if($newqty < 0){

                                    return 5;
                                }


                                FifoQty::where('id', $fifo->id)->update(['Qty' => $newqty]);


                                $ResdiualCost = $this->FifoStoreQty($fifo->Store, $fifo->Product, $fifo->P_Code, $fifo->id, $fifo->Purchases_Date, $resdiualQty, $Unit[$i]);


                            }


                        }


                    }



                    if (!empty($QuantityTo)) {
                        $prooooo = Products::find($Product[$i]);
                        $New = $QuantityTo->Qty + $qq;

                        if ($Def->StoresTarnsferPrice == 0) {


                            $lastOperation = ProductMoves::latest('id')->where('P_Code', $P_Code[$i])->where('Product', $Product[$i])->where('Store', $event->requests['To_Store'])->first();


                            if (!empty($lastOperation->Current)) {

                                $newQQty = $unit->Rate * $Trans_Qty[$i];

                                $ty=$average->AverageCost($TotalP[$i],$newQQty,$Product[$i],$P_Code[$i],$event->requests['To_Store'],$event->requests['Date'],$plow->Price);


                                if($prooooo->P_Type == 'Serial' or $prooooo->P_Type == 'Single_Variable' or $prooooo->P_Type == 'Duble_Variable' ) {
                                    $lastOperation = ProductMoves::latest('id')->where('Delete','!=',1)->where('Edit','!=',1)->where('P_Code', $P_Code[$i])->where('Product', $Product[$i])->where('Store', $event->requests['To_Store'])->first();
                                }else{
                                    $lastOperation = ProductMoves::latest('id')->where('Delete','!=',1)->where('Edit','!=',1)->where('Product', $Product[$i])->where('Store', $event->requests['To_Store'])->first();
                                }



                                $in = $TotalP[$i];
                                $out = 0;
                                if (!empty($lastOperation)) {
                                    $current = $lastOperation->CostCurrent + $TotalP[$i];
                                } else {
                                    $current = $TotalP[$i];
                                }


                            } else {

                                $newQQty = $unit->Rate * $Trans_Qty[$i];

                                $ty=$average->AverageCost($TotalP[$i],$newQQty,$Product[$i],$plow->Barcode,$event->requests['To_Store'],$event->requests['Date'],$plow->Price);

                                $CostTotalSale = $ty * $newQQty;

                                $in = $CostTotalSale;
                                $out = 0;

                                $current = $ty * $newQQty;
                            }


                        } else {


                            $newQQty = $unit->Rate * $Trans_Qty[$i];


                            $ty=$average->AverageCost($TotalP[$i],$newQQty,$Product[$i], $P_Code[$i],$event->requests['To_Store'],$event->requests['Date'],$plow->Price);

                            if($prooooo->P_Type == 'Serial' or $prooooo->P_Type == 'Single_Variable' or $prooooo->P_Type == 'Duble_Variable' ) {
                                $lastOperation = ProductMoves::latest('id')->where('Delete',0)->where('Edit',0)->where('P_Code', $P_Code[$i])->where('Product', $Product[$i])->where('Store', $event->requests['To_Store'])->first();
                            }else{
                                $lastOperation = ProductMoves::latest('id')->where('Delete',0)->where('Edit',0)->where('Product', $Product[$i])->where('Store', $event->requests['To_Store'])->first();
                            }



                            $in = $TotalP[$i];
                            $out = 0;
                            if (!empty($lastOperation)) {
                                $current = $lastOperation->CostCurrent + $TotalP[$i];
                            } else {
                                $current = $TotalP[$i];
                            }


                        }


                        $cur = $New * $ty;
                        ProductsQty::where('id', $QuantityTo->id)->update(['Qty' => $New, 'Price' => $ty, 'TotalCost' => $cur]);


                        $store=Stores::find($event->requests['To_Store']);
                        //Product Moves
                        $move=[

                            'Date'=>$event->requests['Date'],
                            'Type'=> 'تحويل مخازن',
                            'TypeEn'=>'Stores Transfer',
                            'Bill_Num'=>$Bill->Code,
                            'Incom'=>$qq,
                            'Outcom'=>0,
                            'Current'=>$New,
                            'CostIn'=>number_format((float)$in, 2, '.', ''),
                            'CostOut'=>number_format((float)$out, 2, '.', ''),
                            'CostCurrent'=>number_format((float)$current, 2, '.', ''),
                            'P_Ar_Name'=>$P_Ar_Name[$i],
                            'P_En_Name'=>$P_En_Name[$i],
                            'P_Code'=>$P_Code[$i],
                            'Unit'=>$Unit[$i],
                            'Qty'=>$Trans_Qty[$i],
                            'Group'=>$prooooo->Group,
                            'Store'=>$event->requests['To_Store'],
                            'Product'=>$Product[$i],
                            'V1'=>$VOne[$i],
                            'V2'=>$VTwo[$i],
                            'Brand'=>$prooooo->Brand,
                            'Safe'=>null,
                            'Branch'=>$store->Branch,
                            'SalePrice'=>$plow->Price,
                            'ProductPrice'=>null,
                            'Delegate'=>$event->requests['Delegate'],
                            'Payment_Method'=>null,
                            'User'=>auth()->guard('admin')->user()->id,

                        ];
                        $this->ProductMoves($move);



                    } else {

                        $plow = ProductUnits::where('Product', $Product[$i])->where('Rate', 1)->first();
                        $unit = ProductUnits::where('Product', $Product[$i])->where('Unit', $Unit[$i])->first();



                        if ($Def->StoresTarnsferPrice == 0) {


                            $lastOperation = ProductMoves::orderBy('id', 'desc')->where('P_Code', $P_Code[$i])->where('Product', $Product[$i])->where('Store', request('To_Store'))->first();

                            if (!empty($lastOperation->Current)) {


                                $newQQty = $unit->Rate * $Trans_Qty[$i];

                                $ty=$average->AverageCost($TotalP[$i],$newQQty,$Product[$i], $P_Code[$i],$event->requests['To_Store'],$event->requests['Date'],$plow->Price);

                                $lastOperation = ProductMoves::orderBy('id', 'desc')->where('P_Code', $P_Code[$i])->where('Product', $Product[$i])->where('Store', request('To_Store'))->first();


                                $in = $TotalP[$i];
                                $out = 0;
                                if (!empty($lastOperation)) {
                                    $current = $lastOperation->CostCurrent + ($TotalP[$i] / $unit->Rate);
                                } else {
                                    $current = ($TotalP[$i] / $unit->Rate);
                                }




                            } else {

                                $newQQty = $unit->Rate * $Trans_Qty[$i];

                                $ty=$average->AverageCost($TotalP[$i],$newQQty,$Product[$i], $plow->Barcode,$event->requests['To_Store'],$event->requests['Date'],$plow->Price);

                                $CostTotalSale = $ty * $newQQty;

                                $in = $CostTotalSale;
                                $out = 0;

                                $current = $ty * $newQQty;
                            }


                        } else {


                            $newQQty = $unit->Rate * $Trans_Qty[$i];
                            $ty=$average->AverageCost($TotalP[$i],$newQQty,$Product[$i], $P_Code[$i],$event->requests['To_Store'],$event->requests['Date'],$plow->Price);


                            $lastOperation = ProductMoves::orderBy('id', 'desc')->where('P_Code', $P_Code[$i])->where('Product', $Product[$i])->where('Store', request('To_Store'))->first();


                            $in = $TotalP[$i];
                            $out = 0;
                            if (!empty($lastOperation)) {
                                $current = $lastOperation->CostCurrent + ($TotalP[$i] / $unit->Rate);
                            } else {
                                $current = ($TotalP[$i] / $unit->Rate);
                            }


                        }


                        $id_store = DB::table('products_stores')->insertGetId(

                            array(

                                'P_Ar_Name' => $P_Ar_Name[$i],
                                'P_En_Name' => $P_En_Name[$i],
                                'P_Code' => $P_Code[$i],
                                'Exp_Date' => null,
                                'Product' => $Product[$i],
                                'Store' => $event->requests['To_Store'],
                                'V1' => $VOne[$i],
                                'V2' => $VTwo[$i],
                                'V_Name' => $V_Name[$i],
                                'VV_Name' => $VV_Name[$i],

                            )
                        );


                        $plow = ProductUnits::where('Product', $Product[$i])->where('Rate', 1)->first();
                        $PRICE_RATE=$Price[$i]  /  $unit->Rate ;
                        $pqty['P_Ar_Name'] = $P_Ar_Name[$i];
                        $pqty['P_En_Name'] = $P_En_Name[$i];
                        $pqty['Qty'] = $qq;
                        $pqty['Price'] = $PRICE_RATE;
                        $pqty['Pro_Stores'] = $id_store;
                        $pqty['Store'] = $event->requests['To_Store'];
                        $pqty['Unit'] = $Unit[$i];
                        $pqty['Low_Unit'] = $plow->Unit;
                        $pqty['Product'] = $Product[$i];
                        $pqty['V1'] = $VOne[$i];
                        $pqty['V2'] = $VTwo[$i];
                        $pqty['V_Name'] = $V_Name[$i];
                        $pqty['VV_Name'] = $VV_Name[$i];


                        $prooooo = Products::find($Product[$i]);
                        $pqty['SearchCode1'] = $prooooo->SearchCode1;
                        $pqty['SearchCode2'] = $prooooo->SearchCode2;
                        if ($prooooo->P_Type == 'Serial' or $prooooo->P_Type == 'Single_Variable' or $prooooo->P_Type == 'Duble_Variable') {
                            $proooooStore = Stores::find($event->requests['To_Store']);
                            $pqty['Group'] = $prooooo->Group;
                            $pqty['Brand'] = $prooooo->Brand;
                            $pqty['Branch'] = $proooooStore->Branch;
                            $pqty['P_Code'] = $P_Code[$i];

                        } else {

                            $coco = array();
                            $CodesPrds = ProductUnits::where('Product', $Product[$i])->select('Barcode')->get();
                            foreach ($CodesPrds as $cco) {


                                array_push($coco, $cco->Barcode);

                            }

                            $pqty['P_Code'] = $coco[0];

                            if (!empty($coco[1])) {
                                $pqty['PP_Code'] = $coco[1];
                            } else {
                                $pqty['PP_Code'] = null;
                            }

                            if (!empty($coco[2])) {
                                $pqty['PPP_Code'] = $coco[2];
                            } else {
                                $pqty['PPP_Code'] = null;
                            }

                            if (!empty($coco[3])) {
                                $pqty['PPPP_Code'] = $coco[3];
                            } else {
                                $pqty['PPPP_Code'] = null;
                            }
                        }


                        $pqty['TotalCost'] = $qq * $PRICE_RATE;
                        ProductsQty::create($pqty);



                        $store=Stores::find($event->requests['To_Store']);
                        //Product Moves
                        $move=[

                            'Date'=>$event->requests['Date'],
                            'Type'=> 'تحويل مخازن',
                            'TypeEn'=>'Stores Transfer',
                            'Bill_Num'=>$Bill->Code,
                            'Incom'=>$qq,
                            'Outcom'=>0,
                            'Current'=>$qq,
                            'CostIn'=>number_format((float)$in, 2, '.', ''),
                            'CostOut'=>number_format((float)$out, 2, '.', ''),
                            'CostCurrent'=>number_format((float)$current, 2, '.', ''),
                            'P_Ar_Name'=>$P_Ar_Name[$i],
                            'P_En_Name'=>$P_En_Name[$i],
                            'P_Code'=>$P_Code[$i],
                            'Unit'=>$Unit[$i],
                            'Qty'=>$Trans_Qty[$i],
                            'Group'=>$prooooo->Group,
                            'Store'=>$event->requests['To_Store'],
                            'Product'=>$Product[$i],
                            'V1'=>$VOne[$i],
                            'V2'=>$VTwo[$i],
                            'Brand'=>$prooooo->Brand,
                            'Safe'=>null,
                            'Branch'=>$store->Branch,
                            'SalePrice'=>$plow->Price,
                            'ProductPrice'=>null,
                            'Delegate'=>$event->requests['Delegate'],
                            'Payment_Method'=>null,
                            'User'=>auth()->guard('admin')->user()->id,

                        ];
                        $this->ProductMoves($move);



                    }




                    if(!empty($Exp_Date[$i])) {

                        $EXPOFrom=$this->ExpireAvQtiesCheck($event->requests['From_Store'],$Product[$i],$P_Code[$i],$Exp_Date[$i]);

                        if (!empty($EXPOFrom)) {
                            $unit = ProductUnits::where('Unit', $Unit[$i])->where('Product', $Product[$i])->first();
                            $qq = $unit->Rate * $Trans_Qty[$i];
                            $EXPO = ExpireDateQty::find($EXPOFrom->id);
                            $NewExpQty = $EXPO->Qty - $qq;

                            if($NewExpQty < 0){

                                return 5;
                            }

                            ExpireDateQty::where('id', $EXPOFrom->id)->update(['Qty' => $NewExpQty]);

                        }


                        if (!empty($EXPOFrom)) {

                            $EXPOTo=$this->ExpireAvQtiesCheck($event->requests['To_Store'],$Product[$i],$P_Code[$i],$Exp_Date[$i]);


                            if (!empty($EXPOTo)) {

                                $unit = ProductUnits::where('Unit', $Unit[$i])->where('Product', $Product[$i])->first();
                                $qqT = $unit->Rate * $Trans_Qty[$i];
                                $EXPOT = ExpireDateQty::find($EXPOTo->id);
                                $NewExpQtyT = $EXPOT->Qty + $qqT;
                                ExpireDateQty::where('id', $EXPOTo->id)->update(['Qty' => $NewExpQtyT]);
                            } else {


                                $EXNEW['Qty'] = $unit->Rate * $Trans_Qty[$i];
                                $EXNEW['P_Ar_Name'] = $EXPOFrom->P_Ar_Name;
                                $EXNEW['P_En_Name'] = $EXPOFrom->P_En_Name;
                                $EXNEW['P_Code'] = $EXPOFrom->P_Code;
                                $EXNEW['PP_Code'] = $EXPOFrom->PP_Code;
                                $EXNEW['PPP_Code'] = $EXPOFrom->PPP_Code;
                                $EXNEW['PPPP_Code'] = $EXPOFrom->PPPP_Code;
                                $EXNEW['V_Name'] = $EXPOFrom->V_Name;
                                $EXNEW['VV_Name'] = $EXPOFrom->VV_Name;
                                $EXNEW['Store'] = request('To_Store');
                                $EXNEW['Unit'] = $EXPOFrom->Unit;
                                $EXNEW['Product'] = $EXPOFrom->Product;
                                $EXNEW['V1'] = $EXPOFrom->V1;
                                $EXNEW['V2'] = $EXPOFrom->V2;
                                $EXNEW['Low_Unit'] = $EXPOFrom->Low_Unit;
                                $EXNEW['Exp_Date'] = $EXPOFrom->Exp_Date;
                                $EXNEW['Group'] = $EXPOFrom->Group;
                                $EXNEW['Brand'] = $EXPOFrom->Brand;
                                $EXNEW['Branch'] = $EXPOFrom->Branch;

                                ExpireDateQty::create($EXNEW);


                            }


                        }
                    }

                    //Fifo

                    if ($def->Cost_Price == 2) {

                        $fifo=$this->FifoAvQtyDate($event->requests['To_Store'],$Product[$i],$P_Code[$i]);


                        if (!empty($fifo)) {

                            $unit = ProductUnits::where('Unit', $Unit[$i])->where('Product', $Product[$i])->first();

                            $qq = $unit->Rate * $Trans_Qty[$i];

                            $newqty = $fifo->Qty + $qq;

                            FifoQty::where('id', $fifo->id)->update(['Qty' => $newqty, 'Original_Qty' => $newqty]);

                        } else {


                            if (!empty($V_Name[$i]) and !empty($VV_Name[$i])) {

                                $my_value = $V_Name[$i];
                                $first_word = explode(' - ', trim($my_value))[0];
                                $second_word = explode(' - ', trim($my_value))[1];

                                $vId = SubVirables::where('Name', 'like', $first_word . '%')->first();
                                $vvId = SubVirables::where('Name', 'like', $second_word . '%')->first();
                                if (empty($vId)) {
                                    $vId = SubVirables::where('NameEn', 'like', $first_word . '%')->first();
                                }

                                if (empty($vvId)) {
                                    $vvId = SubVirables::where('NameEn', 'like', $second_word . '%')->first();
                                }
                                $sNam = $first_word;
                                $sId = $vId->id;
                                $ssNam = $second_word;
                                $ssId = $vvId->id;

                            } else {

                                $sNam = $V_Name[$i];
                                $ssNam = $VV_Name[$i];
                                $sId = $VOne[$i];
                                $ssId = $VTwo[$i];
                            }


                            $pqty['P_Ar_Name'] = $P_Ar_Name[$i];
                            $pqty['Exp_Date'] = null;
                            $pqty['P_En_Name'] = $P_En_Name[$i];
                            $pqty['Qty'] = $Trans_Qty[$i] * $pp->Rate;
                            $pqty['Original_Qty'] = $Trans_Qty[$i] * $pp->Rate;
                            $pqty['Cost_Price'] = $Price[$i];
                            $pqty['Store'] = $event->requests['To_Store'];
                            $pqty['Unit'] = $Unit[$i];
                            $pqty['Low_Unit'] = $plow->Unit;
                            $pqty['Product'] = $Product[$i];

                            $prooooo = Products::find($Product[$i]);
                            $pqty['SearchCode1'] = $prooooo->SearchCode1;
                            $pqty['SearchCode2'] = $prooooo->SearchCode2;
                            if (!empty($V_Name[$i]) and !empty($VV_Name[$i])) {

                                $my_value = $V_Name[$i];
                                $first_word = explode(' - ', trim($my_value))[0];
                                $second_word = explode(' - ', trim($my_value))[1];

                                $vId = SubVirables::where('Name', 'like', $first_word . '%')->first();
                                $vvId = SubVirables::where('Name', 'like', $second_word . '%')->first();
                                if (empty($vId)) {
                                    $vId = SubVirables::where('NameEn', 'like', $first_word . '%')->first();
                                }

                                if (empty($vvId)) {
                                    $vvId = SubVirables::where('NameEn', 'like', $second_word . '%')->first();
                                }
                                $pqty['V1'] = $vId->id;
                                $pqty['V2'] = $vvId->id;
                                $pqty['V_Name'] = $first_word;
                                $pqty['VV_Name'] = $second_word;
                                $pqty['P_Code'] = $P_Code[$i];

                            } else {


                                if ($prooooo->P_Type == 'Serial') {

                                    $pqty['V1'] = $VOne[$i];
                                    $pqty['V2'] = $VTwo[$i];
                                    $pqty['V_Name'] = $V_Name[$i];
                                    $pqty['VV_Name'] = $VV_Name[$i];
                                    $pqty['P_Code'] = $P_Code[$i];

                                } else {


                                    if ($prooooo->P_Type == 'Single_Variable') {
                                        $pqty['V1'] = $VOne[$i];
                                        $pqty['V2'] = $VTwo[$i];
                                        $pqty['V_Name'] = $V_Name[$i];
                                        $pqty['VV_Name'] = $VV_Name[$i];
                                        $pqty['P_Code'] = $P_Code[$i];

                                    } elseif ($prooooo->P_Type == 'Duble_Variable') {

                                        $pqty['P_Code'] = $P_Code[$i];

                                    } else {


                                        $coco = array();
                                        $CodesPrds = ProductUnits::where('Product', $Product[$i])->select('Barcode')->get();
                                        foreach ($CodesPrds as $cco) {


                                            array_push($coco, $cco->Barcode);

                                        }

                                        $pqty['V1'] = $VOne[$i];
                                        $pqty['V2'] = $VTwo[$i];
                                        $pqty['V_Name'] = $V_Name[$i];
                                        $pqty['VV_Name'] = $VV_Name[$i];
                                        $pqty['P_Code'] = $coco[0];

                                        if (!empty($coco[1])) {
                                            $pqty['PP_Code'] = $coco[1];
                                        } else {
                                            $pqty['PP_Code'] = null;
                                        }

                                        if (!empty($coco[2])) {
                                            $pqty['PPP_Code'] = $coco[2];
                                        } else {
                                            $pqty['PPP_Code'] = null;
                                        }

                                        if (!empty($coco[3])) {
                                            $pqty['PPPP_Code'] = $coco[3];
                                        } else {
                                            $pqty['PPPP_Code'] = null;
                                        }

                                    }


                                }


                            }

                            $proooooStore = Stores::find($event->requests['To_Store']);
                            $pqty['Group'] = $prooooo->Group;
                            $pqty['Brand'] = $prooooo->Brand;
                            $pqty['Branch'] = $proooooStore->Branch;
                            $pqty['Purchases_Date'] =$event->requests['Date'];
                            FifoQty::create($pqty);


                        }


                    }





                }


            }


        }




        //Jounralizing
        $type_ar='تحويلات المخازن';
        $type_en='Stores Transfers';
        $debitor=$event->requests['Total'];
        $creditor=$event->requests['Total'];
        $account_cred=0;
        $account_debt=0;
        $date=$event->requests['Date'];
        $draw=$event->requests['Draw'];
        $coin=$event->requests['Coin'];
        $cost_center=null;
        $note=$event->requests['Note'];
        $total=$event->requests['Total'];
        $joun_id=0;
        $Code_Type=$Bill->Code;
        $Code=0;

        $data=[

            'type_ar'=>$type_ar,
            'type_en'=>$type_en,
            'code'=>$Code,
            'code_type'=>$Code_Type,
            'date'=>$date,
            'draw'=>$draw,
            'coin'=>$coin,
            'cost_center'=>$cost_center,
            'note'=>$note,
            'debitor_cred'=>0,
            'creditor_cred'=>$creditor,
            'account_cred'=>$account_cred,
            'debitor_debt'=>$debitor,
            'creditor_debt'=>0,
            'account_debt'=>$account_debt,
            'total'=>$total,
            'joun_id'=>$joun_id,
        ];

        $joun_id=$this->CreateNewJun($data);
        $new=Journalizing::findOrFail($joun_id);
        $data['code']=$new->Code;
        $data['joun_id']=$joun_id;




        if($type == 1) {


            if (!empty($F->Ship)) {

                $Ship = ShippingCompany::find($F->Ship);

                if ($event->requests['TypeTransfer'] != null) {

                    if ($event->requests['TypeTransfer']  == 1) {

                        $data['creditor_cred'] = $event->requests['TotalOld'];
                        $data['account_cred'] =  $Fstore->Account;
                        $data['debitor_debt'] = $event->requests['TotalOld'];
                        $data['account_debt'] = 52;
                        $this->JunDetails($data);

                        $data['creditor_cred'] = $event->requests['Total'];
                        $data['account_cred'] =  48;
                        $data['debitor_debt'] = $event->requests['Total'];
                        $data['account_debt'] = $Ship->Account;
                        $this->JunDetails($data);


                    } else {


                        $data['creditor_cred'] = $event->requests['Total'];
                        $data['account_cred'] =  $Fstore->Account;
                        $data['debitor_debt'] = $event->requests['Total'];
                        $data['account_debt'] = $Ship->Account;
                        $this->JunDetails($data);




                    }

                } else {

                    if ($Def->StoresTarnsferPrice == 0) {


                        $data['creditor_cred'] = $event->requests['Total'];
                        $data['account_cred'] =  $Fstore->Account;
                        $data['debitor_debt'] = $event->requests['Total'];
                        $data['account_debt'] = $Ship->Account;
                        $this->JunDetails($data);

                    } else {

                        $data['creditor_cred'] = $event->requests['TotalOld'];
                        $data['account_cred'] =  $Fstore->Account;
                        $data['debitor_debt'] = $event->requests['TotalOld'];
                        $data['account_debt'] = 52;
                        $this->JunDetails($data);

                        $data['creditor_cred'] = $event->requests['Total'];
                        $data['account_cred'] =  48;
                        $data['debitor_debt'] = $event->requests['Total'];
                        $data['account_debt'] = $Ship->Account;
                        $this->JunDetails($data);


                    }

                }

            } else {


                if ($event->requests['TypeTransfer']  != null) {

                    if ($event->requests['TypeTransfer']  == 1) {


                        $data['creditor_cred'] = $event->requests['TotalOld'];
                        $data['account_cred'] =  $Fstore->Account;
                        $data['debitor_debt'] = $event->requests['TotalOld'];
                        $data['account_debt'] = 52;
                        $this->JunDetails($data);


                        $data['creditor_cred'] = $event->requests['Total'];
                        $data['account_cred'] =  48;
                        $data['debitor_debt'] = $event->requests['Total'];
                        $data['account_debt'] = $Tstore->Account_Client;
                        $this->JunDetails($data);


                        $data['creditor_cred'] = $event->requests['Total'];
                        $data['account_cred'] =  $Tstore->Account_Client;
                        $data['debitor_debt'] = $event->requests['Total'];
                        $data['account_debt'] = $Tstore->Account;
                        $this->JunDetails($data);


                    } else {


                        $data['creditor_cred'] = $event->requests['Total'];
                        $data['account_cred'] =  $Fstore->Account;
                        $data['debitor_debt'] = $event->requests['Total'];
                        $data['account_debt'] = $Tstore->Account;
                        $this->JunDetails($data);


                    }

                } else {



                    if ($Def->StoresTarnsferPrice == 0) {


                        $data['creditor_cred'] = $event->requests['Total'];
                        $data['account_cred'] =  $Fstore->Account;
                        $data['debitor_debt'] = $event->requests['Total'];
                        $data['account_debt'] = $Tstore->Account;
                        $this->JunDetails($data);




                    } else {


                        $data['creditor_cred'] = $event->requests['TotalOld'];
                        $data['account_cred'] =  $Fstore->Account;
                        $data['debitor_debt'] = $event->requests['TotalOld'];
                        $data['account_debt'] = 52;
                        $this->JunDetails($data);


                        $data['creditor_cred'] = $event->requests['Total'];
                        $data['account_cred'] =  48;
                        $data['debitor_debt'] = $event->requests['Total'];
                        $data['account_debt'] = $Tstore->Account_Client;
                        $this->JunDetails($data);

                        $data['creditor_cred'] = $event->requests['Total'];
                        $data['account_cred'] =  $Tstore->Account_Client;
                        $data['debitor_debt'] = $event->requests['Total'];
                        $data['account_debt'] = $Tstore->Account;
                        $this->JunDetails($data);



                    }

                }
            }

        }else{

            $Ship = ShippingCompany::find($F->Ship);
            if ($Def->StoresTarnsferPrice == 0) {


                $data['creditor_cred'] = $event->requests['Total'];
                $data['account_cred'] =  $Ship->Account;
                $data['debitor_debt'] = $event->requests['Total'];
                $data['account_debt'] = $Tstore->Account;
                $this->JunDetails($data);

            }else{


                $data['creditor_cred'] = $event->requests['TotalOld'];
                $data['account_cred'] =  $Ship->Account;
                $data['debitor_debt'] = $event->requests['TotalOld'];
                $data['account_debt'] = 52;
                $this->JunDetails($data);


                $data['creditor_cred'] = $event->requests['Total'];
                $data['account_cred'] =  48;
                $data['debitor_debt'] = $event->requests['Total'];
                $data['account_debt'] = $Tstore->Account_Client;
                $this->JunDetails($data);


                $data['creditor_cred'] = $event->requests['Total'];
                $data['account_cred'] =  $Tstore->Account_Client;
                $data['debitor_debt'] = $event->requests['Total'];
                $data['account_debt'] = $Tstore->Account;
                $this->JunDetails($data);

            }


            $data['creditor_cred'] = $event->requests['CostShip'];
            $data['account_cred'] =   $event->requests['Safe'];
            $data['debitor_debt'] = $event->requests['CostShip'];
            $data['account_debt'] = $Ship->Account;
            $this->JunDetails($data);


        }



        //Stores Moves from
        $store=Stores::find($event->requests['From_Store']);
        $dataStMove=[

            'Date'=>date('Y-m-d'),
            'Code'=>$Bill->Code ,
            'Time'=>date("h:i:s a", time()),
            'Branch'=>$store->Branch,
            'Store'=>$event->requests['From_Store'],
            'Safe'=>null,
            'Type'=>'تحويلات مخازن من',
            'TypeEn'=>'Stores Transfer From',
            'Cost_Center'=>null,
            'User'=>auth()->guard('admin')->user()->id,
            'Coin'=>$event->requests['Coin'],
            'Note'=>$event->requests['Note'],
            'Total_Qty'=>$event->requests['TotalQty'],
            'Total_Price'=>$event->requests['Total'],
            'Account'=>null,
            'Ship'=>$event->requests['Ship'],
            'ID'=>$event->ID,

        ];
        $this->StoresMoves($dataStMove);


        //Stores Moves to
        $store=Stores::find($event->requests['To_Store']);
        $dataStMove=[

            'Date'=>date('Y-m-d'),
            'Code'=>$Bill->Code ,
            'Time'=>date("h:i:s a", time()),
            'Branch'=>$store->Branch,
            'Store'=>$event->requests['To_Store'],
            'Safe'=>null,
            'Type'=>'تحويلات مخازن الي',
            'TypeEn'=>'Stores Transfer To',
            'Cost_Center'=>null,
            'User'=>auth()->guard('admin')->user()->id,
            'Coin'=>$event->requests['Coin'],
            'Note'=>$event->requests['Note'],
            'Total_Qty'=>$event->requests['TotalQty'],
            'Total_Price'=>$event->requests['Total'],
            'Account'=>null,
            'Ship'=>$event->requests['Ship'],
            'ID'=>$event->ID,

        ];
        $this->StoresMoves($dataStMove);



    }
}
