<?php

namespace App\Listeners\Sales;


use App\Events\ReturnSalesEvent;
use App\Models\AccountsDefaultData;
use App\Models\AssemblyProducts;
use App\Models\Coins;
use App\Models\Customers;
use App\Models\Employess;
use App\Models\EmpRatio;
use App\Models\ExpireDateQty;
use App\Models\FifoQty;
use App\Models\GeneralDaily;
use App\Models\JournalizingDetails;
use App\Models\ProductMoves;
use App\Models\Products;
use App\Models\ProductSales;
use App\Models\ProductsQty;
use App\Models\ProductUnits;
use App\Models\ReturnSales;
use App\Models\ReturnSalesProducts;
use App\Models\Sales;
use App\Models\SalesFifoQty;
use App\Models\Shifts;
use App\Models\StoreCountSales;
use App\Models\Stores;
use App\Models\StoresDefaultData;
use App\Models\Taxes;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use App\Traits\GeneralTrait;

use App\Models\Journalizing;
use DB;
use App\Services\Average;
use App\Services\SalesService;

class ReturnSalesListener
{


    use GeneralTrait;

    public function __construct()
    {

    }


    public function handle(ReturnSalesEvent $event)
    {

        $service = new SalesService ;
        $average = new Average ;

        $ID=$event->ID;
        $Bill=ReturnSales::findOrFail($ID);
        $def=StoresDefaultData::latest('id')->first();
        $store=Stores::find($Bill->Store);

        if(!empty($event->requests['Pay'])){
            $paid = $event->requests['Pay'] ;
        }else{
            $paid = 0 ;
        }

        if(empty($event->requests['Cost_Center'])){
            $event->requests['Cost_Center'] = null ;
        }


        $order=[
            'noti_name_ar'=>'مرتجع مبيعات',
            'noti_name_en'=>'Sales Return',
            'type_ar'=>'مرتجع مبيعات',
            'type_en'=>'Sales Return',
            'type_code'=>$Bill->Code,
            'emp'=>$Bill->Delegate,
            'client'=>$Bill->Client,
            'product'=>null,
            'store'=>$Bill->Store,
            'safe'=>$Bill->Safe,
            'notify_name'=>trans('admin.SalesReturn'),
        ];
        $this->CreateNotification($order);


        if(!empty($event->requests['Unit'])) {

            StoreCountSales::truncate();

            $P_Ar_Name = $event->requests['P_Ar_Name'];
            $P_En_Name = $event->requests['P_En_Name'];
            $Unit = $event->requests['Unit'];
            $P_Code = $event->requests['P_Code'];
            $Qty = $event->requests['Qty'];
            $AvQty = $event->requests['AvQty'];
            $Price = $event->requests['Price'];
            $Discount = $event->requests['Discount'];
            $TotalBFTax = $event->requests['TransTotalBF'];
            $TotalTax = $event->requests['TransTotTax'];
            $PurchTax = $event->requests['PurchTax'];
            $Total = $event->requests['TransTotal'];
            $StorePurch = $event->requests['StorePurch'];
            $Exp_Date = $event->requests['Exp_Date'];
            $Product = $event->requests['Product'];
            $VOne = $event->requests['VOne'];
            $VTwo = $event->requests['VTwo'];
            $V_Name = $event->requests['V_Name'];
            $VV_Name = $event->requests['VV_Name'];
            $Exp_Date = $event->requests['Exp_Date'];
            $OQty = $event->requests['Original_Qty'];
            $RQty = $event->requests['Return_Qty'];
            $Patch_Number = $event->requests['Patch_Number'];
            $CostPrice=$event->requests['CostPrice'];

            for ($i = 0; $i < count($Unit); $i++) {


                if($RQty[$i] != 0){
                $pp = ProductUnits::where('Product', $Product[$i])->where('Unit', $Unit[$i])->first();
                $plow = ProductUnits::where('Product', $Product[$i])->where('Def', 1)->first();
                $prooooo = Products::find($Product[$i]);

                $uu['Product_Code'] = $P_Code[$i];
                $uu['P_Ar_Name'] = $P_Ar_Name[$i];
                $uu['P_En_Name'] = $P_En_Name[$i];
                $uu['V_Name'] = $V_Name[$i];
                $uu['VV_Name'] = $VV_Name[$i];
                $uu['Original_Qty'] = $OQty[$i];
                $uu['Recived_Qty'] = $RQty[$i];
                $uu['Qty'] = $Qty[$i];
                $uu['AvQty'] = $AvQty[$i];
                $uu['Price'] = $Price[$i];
                $uu['Cost'] = $CostPrice[$i];
                $uu['TotalCost'] = $CostPrice[$i] * $RQty[$i];
                $uu['Discount'] = $Discount[$i];
                $uu['Tax'] = $PurchTax[$i];
                $uu['Total_Bf_Tax'] = $TotalBFTax[$i];
                $uu['Total_Tax'] = $TotalTax[$i];
                $uu['Total'] = $Total[$i];
                $uu['Store'] = $StorePurch[$i];
                $uu['Product'] = $Product[$i];
                $uu['Unit'] = $Unit[$i];
                $uu['Exp_Date'] = $Exp_Date[$i];
                $uu['Return'] = $ID;
                $uu['V1'] = $VOne[$i];
                $uu['V2'] = $VTwo[$i];
                $uu['Date'] = date('Y-m-d');
                $uu['Code'] = $Bill->Code;
                $uu['Refernce_Number'] = $Bill->Refernce_Number;
                $uu['Safe'] = $Bill->Safe;
                $uu['Client'] = $Bill->Client;
                $uu['Executor'] = $Bill->Executor;
                $uu['Delegate'] = $Bill->Delegate;
                $uu['Coin'] = $Bill->Coin;
                $uu['Ship'] = $Bill->Ship;
                $uu['Patch_Number'] = $Patch_Number[$i];
                $uu['User'] = auth()->guard('admin')->user()->id;
                $uu['Cost_Center'] = $Bill->Cost_Center;
                $uu['Type'] = 'مرتجع مبيعات';
                $uu['TypeEn'] = 'Return Sales';


                $Aomla = Coins::find($Bill->Coin);
                $dreba = Taxes::find($PurchTax[$i]);

                $uu['CoinCode'] = $Aomla->Code;

                if ($Aomla->Code == 'EGP') {
                    $uu['CoinRate'] = 0.00;
                    $uu['CoinPrice'] = 0.00;
                    $uu['AmountEGP'] = $Price[$i];

                } else {

                    $uu['CoinRate'] = $Aomla->Draw;
                    $uu['CoinPrice'] = $Price[$i];
                    $uu['AmountEGP'] = $Aomla->Draw * $Price[$i];
                }

                $uu['SalesTotal'] = $Price[$i] * $RQty[$i];
                $uu['DiscountAmount'] = $Discount[$i] * $RQty[$i];
                $uu['NetTotal'] = ($Price[$i] * $RQty[$i]) - ($Discount[$i] * $RQty[$i]);
                $NET = ($Price[$i] * $RQty[$i]) - ($Discount[$i] * $RQty[$i]);


                if (!empty($dreba)) {
                    $TAM = ($dreba->Rate / 100) * $NET;
                    $uu['TaxType'] = $dreba->CodeTax;
                    $uu['TaxSubType'] = $dreba->SubType;
                    $uu['TaxRate'] = $dreba->Rate;
                    $uu['TaxAmount'] = ($dreba->Rate / 100) * $NET;
                    $uu['TotalBill'] = $NET + $TAM;
                }


                ReturnSalesProducts::create($uu);


                //7sab Taklft Mkhazn

                if ($prooooo->P_Type != 'Service' and $prooooo->P_Type != 'Assembly') {

                    $Cost = $average->AverageCostGetUnit($Product[$i], $P_Code[$i], $StorePurch[$i], $Unit[$i]);

                    $Mkhazns = StoreCountSales::all();

                    if (count($Mkhazns) == 0) {


                        $s['Total'] = $Cost * $RQty[$i];
                        $s['Store'] = $StorePurch[$i];
                        $s['Tax'] = $PurchTax[$i];
                        StoreCountSales::create($s);
                    } else {


                        $m = StoreCountSales::where('Store', $StorePurch[$i])->first();

                        if (!empty($m)) {

                            $newTot = $m->Total + ($Cost * $RQty[$i]);
                            StoreCountSales::where('id', $m->id)->update(['Total' => $newTot]);

                        } else {

                            $s['Total'] = $Cost * $RQty[$i];
                            $s['Store'] = $StorePurch[$i];
                            $s['Tax'] = $PurchTax[$i];
                            StoreCountSales::create($s);


                        }


                    }


                } else {


                    if ($prooooo->P_Type == 'Service') {

                        $Mkhazns = StoreCountSales::all();
                        if (count($Mkhazns) == 0) {

                            $s['Total'] = 0;
                            $s['Store'] = $StorePurch[$i];
                            $s['Tax'] = $PurchTax[$i];
                            StoreCountSales::create($s);

                        } else {
                            $m = StoreCountSales::where('Store', $StorePurch[$i])->first();

                            if (!empty($m)) {

                                $newTot = $m->Total + 0;
                                StoreCountSales::where('id', $m->id)->update(['Total' => $newTot]);

                            } else {

                                $s['Total'] = 0;
                                $s['Store'] = $StorePurch[$i];
                                $s['Tax'] = $PurchTax[$i];
                                StoreCountSales::create($s);


                            }

                        }
                    } else {


                        $Asembs = AssemblyProducts::where('p_id', $Product[$i])->get();

                        foreach ($Asembs as $ass) {


                            $Mkhazns = StoreCountSales::all();
                            $Cost = $average->AverageCostGetUnit($ass->Product, $ass->P_Code, $StorePurch[$i], $ass->Unit);

                            if (count($Mkhazns) == 0) {

                                $s['Total'] = $Cost * $RQty[$i];
                                $s['Store'] = $StorePurch[$i];
                                $s['Tax'] = $PurchTax[$i];
                                StoreCountSales::create($s);
                            } else {


                                $m = StoreCountSales::where('Store', $StorePurch[$i])->first();

                                if (!empty($m)) {

                                    $newTot = $m->Total + ($Cost * $RQty[$i]);
                                    StoreCountSales::where('id', $m->id)->update(['Total' => $newTot]);

                                } else {


                                    $s['Total'] = $Cost * $RQty[$i];
                                    $s['Store'] = $StorePurch[$i];
                                    $s['Tax'] = $PurchTax[$i];
                                    StoreCountSales::create($s);


                                }


                            }


                        }
                    }
                }



                if ($prooooo->P_Type == 'Assembly') {

                    $Asembs = AssemblyProducts::where('p_id', $Product[$i])->get();

                    foreach ($Asembs as $ass) {


                        $Quantity = $this->ProAvQties($StorePurch[$i], $ass->Product, $ass->P_Code);


                        if (!empty($Quantity)) {
                            $unit = ProductUnits::where('Unit', $ass->Unit)->where('Product', $ass->Product)->first();

                            $qq = $unit->Rate * ($RQty[$i] * $ass->Qty);

                            $newqty = $Quantity->Qty + $qq;

                            $ty = $average->AverageCostGetUnit($ass->Product, $ass->P_Code, $StorePurch[$i], $ass->Unit);

                            if($ty == 0){

                                $CostTotalSale = $CostPrice[$i] * $RQty[$i] ;
                                $in = $CostTotalSale;
                                $out = 0;
                                $current= $newqty *  ($CostPrice[$i] / $unit->Rate);
                                $cur = $newqty * ($CostPrice[$i] / $unit->Rate);
                                ProductsQty::where('id', $Quantity->id)->update(['Qty' => $newqty, 'Price' => $CostPrice[$i], 'TotalCost' => $cur]);
                            }else{

                                $CostTotalSale = $ty ;
                                $in = $CostTotalSale;
                                $out = 0;
                                $current= $newqty *  ($ty / $unit->Rate);
                                $cur = $newqty * ($ty / $unit->Rate);
                                ProductsQty::where('id', $Quantity->id)->update(['Qty' => $newqty, 'Price' => $ty, 'TotalCost' => $cur]);

                            }



                            //Products Moves
                            $move = [

                                'Date' => $event->requests['Date'],
                                'Type' => 'مرتجع مبيعات',
                                'TypeEn' => 'Return Sales',
                                'Bill_Num' => $Bill->Code,
                                'Incom' => $qq,
                                'Outcom' => 0,
                                'Current' => $newqty,
                                'CostIn' => number_format((float)$in, 2, '.', ''),
                                'CostOut' => number_format((float)$out, 2, '.', ''),
                                'CostCurrent' => number_format((float)$current, 2, '.', ''),
                                'P_Ar_Name' => $ass->P_Ar_Name,
                                'P_En_Name' => $ass->P_En_Name,
                                'P_Code' => $ass->P_Code,
                                'Unit' => $ass->Unit,
                                'Qty' => $RQty[$i] * $ass->Qty,
                                'Group' => $prooooo->Group,
                                'Store' => $StorePurch[$i],
                                'Product' => $ass->Product,
                                'V1' => null,
                                'V2' => null,
                                'Brand' => $prooooo->Brand,
                                'Safe' => $event->requests['Safe'],
                                'Branch' => $store->Branch,
                                'SalePrice' => $Price[$i],
                                'ProductPrice' => $pp->Price,
                                'Delegate' => $Bill->Delegate,
                                'Payment_Method' => $event->requests['Payment_Method'],
                                'User' => auth()->guard('admin')->user()->id,

                            ];

                            $this->ProductMoves($move);

                        }


                        if (!empty($Exp_Date[$i])) {
                            $unit = ProductUnits::where('Unit', $ass->Unit)->where('Product', $ass->Product)->first();

                            $qq = $unit->Rate * ($RQty[$i] * $ass->Qty);

                            $EXPO = ExpireDateQty::find($Exp_Date[$i]);
                            $NewExpQty = $EXPO->Qty + $qq;
                            ExpireDateQty::where('id', $Exp_Date[$i])->update(['Qty' => $NewExpQty]);


                        }


                        if ($def->Cost_Price == 2) {

                            $Fifos = SalesFifoQty::where('Sales_ID', $Bill->Sales)->get();

                            foreach ($Fifos as $fi) {


                                if ($fi->Sales_Qty >= ($RQty[$i] * $ass->Qty)) {

                                    $unit = ProductUnits::where('Unit', $ass->Unit)->where('Product', $ass->Product)->first();

                                    $qq = $unit->Rate * ($RQty[$i] * $ass->Qty);

                                    $newqty = $fi->Sales_Qty - $qq;

                                    SalesFifoQty::where('Sales_ID', $Bill->Sales)->update(['Sales_Qty' => $newqty]);

                                    $fio = FifoQty::find($fi->Fifo_ID);

                                    $qqq = $unit->Rate * ($RQty[$i] * $ass->Qty);

                                    $newqtyy = $fio->Qty + $qqq;

                                    FifoQty::where('id', $fi->Fifo_ID)->update(['Qty' => $newqtyy]);


                                } else {

                                    $unit = ProductUnits::where('Unit', $ass->Unit)->where('Product', $ass->Product)->first();

                                    $ressss = ($RQty[$i] * $ass->Qty) - $fi->Sales_Qty;

                                    $result = $RQty[$i] - $ressss;

                                    $qq = $unit->Rate * $result;

                                    SalesFifoQty::where('Sales_ID', $Bill->Sales)->update(['Sales_Qty' => $newqty]);

                                    $fio = FifoQty::find($fi->Fifo_ID);

                                    $newqtyy = $fio->Qty + $fi->Sales_Qty;

                                    FifoQty::where('id', $fi->Fifo_ID)->update(['Qty' => $newqtyy]);


                                }


                            }


                        }


                    }

                } elseif ($prooooo->P_Type != 'Service' and $prooooo->P_Type != 'Subscribe') {


                    $Quantity = $this->ProAvQties($StorePurch[$i], $Product[$i], $P_Code[$i]);

                    if (!empty($Quantity)) {
                        $unit = ProductUnits::where('Unit', $Unit[$i])->where('Product', $Product[$i])->first();

                        $qq = $unit->Rate * $RQty[$i];
                        $newQQty = $unit->Rate * $RQty[$i];
                        $newqty = $Quantity->Qty + $qq;

                        $ty = $average->AverageCostGetUnit($Product[$i], $P_Code[$i], $StorePurch[$i], $Unit[$i]);



                        if($ty == 0){

                            $CostTotalSale = $CostPrice[$i] * $RQty[$i] ;
                            $in = $CostTotalSale;
                            $out = 0;
                            $current= $newqty *  ($CostPrice[$i] / $unit->Rate);
                            $cur = $newqty * ($CostPrice[$i] / $unit->Rate);
                            ProductsQty::where('id', $Quantity->id)->update(['Qty' => $newqty, 'Price' => $CostPrice[$i], 'TotalCost' => $cur]);
                        }else {
                            $CostTotalSale = $ty;
                            $prooooo = Products::findOrFail($Product[$i]);
                            $in = $CostTotalSale;
                            $out = 0;
                            $current = $newqty * ($ty / $unit->Rate);
                            $cur = $newqty * ($ty / $unit->Rate);
                            ProductsQty::where('id', $Quantity->id)->update(['Qty' => $newqty, 'Price' => $ty, 'TotalCost' => $cur]);
                        }



                        //Products Moves
                        $move = [

                            'Date' => $event->requests['Date'],
                            'Type' => 'مرتجع مبيعات',
                            'TypeEn' => 'Return Sales',
                            'Bill_Num' => $Bill->Code,
                            'Incom' => $qq,
                            'Outcom' => 0,
                            'Current' => $newqty,
                            'CostIn' => number_format((float)$in, 2, '.', ''),
                            'CostOut' => number_format((float)$out, 2, '.', ''),
                            'CostCurrent' => number_format((float)$current, 2, '.', ''),
                            'P_Ar_Name' => $P_Ar_Name[$i],
                            'P_En_Name' => $P_En_Name[$i],
                            'P_Code' => $P_Code[$i],
                            'Unit' => $Unit[$i],
                            'Qty' => $RQty[$i],
                            'Group' => $prooooo->Group,
                            'Store' => $StorePurch[$i],
                            'Product' => $Product[$i],
                            'V1' => null,
                            'V2' => null,
                            'Brand' => $prooooo->Brand,
                            'Safe' => $event->requests['Safe'],
                            'Branch' => $store->Branch,
                            'SalePrice' => $Price[$i],
                            'ProductPrice' => $pp->Price,
                            'Delegate' => $Bill->Delegate,
                            'Payment_Method' => $event->requests['Payment_Method'],
                            'User' => auth()->guard('admin')->user()->id,

                        ];

                        $this->ProductMoves($move);


                    }


                    if (!empty($Exp_Date[$i])) {
                        $unit = ProductUnits::where('Unit', $Unit[$i])->where('Product', $Product[$i])->first();

                        $qq = $unit->Rate * $RQty[$i];


                        $EXPO = ExpireDateQty::find($Exp_Date[$i]);
                        $NewExpQty = $EXPO->Qty + $qq;
                        ExpireDateQty::where('id', $Exp_Date[$i])->update(['Qty' => $NewExpQty]);


                    }


                    if ($def->Cost_Price == 2) {

                        $Fifos = SalesFifoQty::where('Sales_ID', $Bill->Sales)->get();

                        foreach ($Fifos as $fi) {


                            if ($fi->Sales_Qty >= $RQty[$i]) {

                                $unit = ProductUnits::where('Unit', $Unit[$i])->where('Product', $Product[$i])->first();

                                $qq = $unit->Rate * $RQty[$i];

                                $newqty = $fi->Sales_Qty - $qq;

                                SalesFifoQty::where('Sales_ID', $Bill->Sales)->update(['Sales_Qty' => $newqty]);

                                $fio = FifoQty::find($fi->Fifo_ID);

                                $qqq = $unit->Rate * $RQty[$i];

                                $newqtyy = $fio->Qty + $qqq;

                                FifoQty::where('id', $fi->Fifo_ID)->update(['Qty' => $newqtyy]);


                            } else {

                                $unit = ProductUnits::where('Unit', $Unit[$i])->where('Product', $Product[$i])->first();

                                $ressss = $RQty[$i] - $fi->Sales_Qty;
                                $result = $RQty[$i] - $ressss;

                                $qq = $unit->Rate * $result;

                                $newqty = $fi->Sales_Qty - $qq;

                                SalesFifoQty::where('Sales_ID', $Bill->Sales)->update(['Sales_Qty' => $newqty]);

                                $fio = FifoQty::find($fi->Fifo_ID);

                                $newqtyy = $fio->Qty + $fi->Sales_Qty;

                                FifoQty::where('id', $fi->Fifo_ID)->update(['Qty' => $newqtyy]);


                            }


                        }


                    }


                }



                if ($RQty[$i] != 0) {

                    $prooo = ProductSales::where('Sales', $Bill->Sales)
                        ->where('Product_Code', $P_Code[$i])
                        ->where('Store', $StorePurch[$i])
                        ->where('Product', $Product[$i])
                        ->where('Unit', $Unit[$i])
                        ->first();

                    $NSQty = $prooo->SmallQty - ($RQty[$i] * $pp->Rate);
                    $NQty = $prooo->Qty - $RQty[$i];
                    $NBF = $prooo->Total_Bf_Tax - $TotalBFTax[$i];
                    $NTtax = $prooo->Total_Tax - $TotalTax[$i];
                    $NTot = $prooo->Total - $Total[$i];
                    if($prooo->Total_Net != 0) {
                        $NCost = $prooo->TotCostNew - ($CostPrice[$i] * $RQty[$i]);
                        $NTotNet= $prooo->Total_Net - ($Total[$i]+$TotalTax[$i] - ($RQty[$i] * $prooo->Discount)) ;
                    }else{
                        $NCost = $prooo->TotCostNew;
                        $NTotNet= $prooo->Total_Net ;
                    }
                    ProductSales::where('id', $prooo->id)->update(['Qty' => $NQty, 'SmallQty' => $NSQty, 'Total_Bf_Tax' => $NBF, 'Total_Tax' => $NTtax, 'Total' => $NTot , 'TotCostNew' => $NCost, 'Total_Net' => $NTotNet]);

                }


            }


        }}


        //Stores Moves

        $totpri=$event->requests['Total_Return_Value'];
        $dataStMove=[

            'Date'=>date('Y-m-d'),
            'Code'=>$Bill->Code ,
            'Time'=>date("h:i:s a", time()),
            'Branch'=>$store->Branch,
            'Store'=>$Bill->Store,
            'Safe'=>$Bill->Safe,
            'Type'=>'مرتجع مبيعات',
            'TypeEn'=>'Return Sales',
            'Cost_Center'=>$Bill->Cost_Center,
            'User'=>auth()->guard('admin')->user()->id,
            'Coin'=>$Bill->Coin,
            'Note'=>$Bill->Note,
            'Total_Qty'=>$Bill->Total_Qty,
            'Total_Price'=>$totpri,
            'Account'=>$Bill->Client,
            'Ship'=>$Bill->Ship,
            'ID'=>$event->ID,

        ];

        $this->StoresMoves($dataStMove);

        $AccDefff=AccountsDefaultData::orderBy('id','desc')->first();



        //Jounralizing
        $type_ar='مرتجع مبيعات';
        $type_en='Return Sales';
        $debitor=$event->requests['Total_Return_Value'];
        $creditor=$event->requests['Total_Return_Value'];
        $account_cred=0;
        $account_debt=0;
        $date=$event->requests['Date'];
        $draw=$event->requests['Draw'];
        $coin=$event->requests['Coin'];
        $cost_center=$event->requests['Cost_Center'];
        $note=$event->requests['Note'];
        $total=$event->requests['Total_Return_Value'];
        $joun_id=0;
        $Code_Type=$Bill->Code;
        $Code=0;

        $data=[

            'type_ar'=>$type_ar,
            'type_en'=>$type_en,
            'code'=>$Code,
            'code_type'=>$Code_Type,
            'date'=>$date,
            'draw'=>$draw,
            'coin'=>$coin,
            'cost_center'=>$cost_center,
            'note'=>$note,
            'debitor_cred'=>0,
            'creditor_cred'=>$creditor,
            'account_cred'=>$account_cred,
            'debitor_debt'=>$debitor,
            'creditor_debt'=>0,
            'account_debt'=>$account_debt,
            'total'=>$total,
            'joun_id'=>$joun_id,
        ];

        $joun_id=$this->CreateNewJun($data);
        $new=Journalizing::findOrFail($joun_id);
        $data['code']=$new->Code;
        $data['joun_id']=$joun_id;

        //Payment Methods
        $NewMkhazns=StoreCountSales::all();


        if($event->requests['Payment_Method'] == 'Cash'){

            if($event->requests['Total_Discount'] != 0){


                if($event->requests['Total_Taxes'] != 0){

                    foreach($NewMkhazns as $new){

                        $store=Stores::find($new->Store);

                        $data['creditor_cred']=$new->Total;
                        $data['account_cred']=52;
                        $data['debitor_debt']=$new->Total;
                        $data['account_debt']=$store->Account;
                        $this->JunDetails($data);

                    }

                    $data['debitor']=(($event->requests['Total_Return_Value'] - $event->requests['Total_Taxes']) -  $event->requests['Total_Discount'] ) + $event->requests['Total_Taxes'] ;
                    $data['creditor']=0;
                    $data['account']=$event->requests['Client'];
                    $this->OneJunDetails($data,0);


                    $data['debitor']=0;
                    $data['creditor']=(($event->requests['Total_Return_Value'] - $event->requests['Total_Taxes']) -  $event->requests['Total_Discount'] ) + $event->requests['Total_Taxes'];
                    $data['account']=$event->requests['Safe'];
                    $this->OneJunDetails($data,0);

                    $data['debitor']=0;
                    $data['creditor']=$event->requests['Total_Discount'];
                    $data['account']=50;
                    $this->OneJunDetails($data,0);


                    $data['debitor']=($event->requests['Total_Return_Value'] - $event->requests['Total_Taxes']) ;
                    $data['creditor']=0;
                    $data['account']=49;
                    $this->OneJunDetails($data,0);


                    foreach($NewMkhazns as $new){

                        $TTax=Taxes::find($new->Tax);


                        $data['debitor']=$event->requests['Total_Taxes'];
                        $data['creditor']=0;
                        $data['account']=$TTax->Account;
                        $this->OneJunDetails($data,0);


                    }



                    $data['debitor']=0;
                    $data['creditor']=(($event->requests['Total_Return_Value'] - $event->requests['Total_Taxes']) -  $event->requests['Total_Discount'] ) + $event->requests['Total_Taxes'] ;
                    $data['account']=$event->requests['Client'] ;
                    $this->OneJunDetails($data,0);


                }else{


                    foreach($NewMkhazns as $new){

                        $store=Stores::find($new->Store);

                        $data['creditor_cred']=$new->Total;
                        $data['account_cred']=52;
                        $data['debitor_debt']=$new->Total;
                        $data['account_debt']=$store->Account;
                        $this->JunDetails($data);

                    }


                    $data['debitor']=$event->requests['Total_Return_Value'] - $event->requests['Total_Discount'] ;
                    $data['creditor']=0;
                    $data['account']=$event->requests['Client'];
                    $this->OneJunDetails($data,0);


                    $data['debitor']=0;
                    $data['creditor']=$event->requests['Total_Return_Value'] - $event->requests['Total_Discount'];
                    $data['account']=$event->requests['Safe'];
                    $this->OneJunDetails($data,0);


                    $data['creditor_cred']=$event->requests['Total_Return_Value'] - $event->requests['Total_Discount'];
                    $data['account_cred']=$event->requests['Client'];
                    $data['debitor_debt']=$event->requests['Total_Return_Value'] ;
                    $data['account_debt']=49;
                    $this->JunDetails($data);

                    $data['debitor']=0;
                    $data['creditor']=$event->requests['Total_Discount'];
                    $data['account']=50;
                    $this->OneJunDetails($data,0);




                }

            }else{


                if($event->requests['Total_Taxes'] != 0){



                    foreach($NewMkhazns as $new){

                        $store=Stores::find($new->Store);

                        $data['creditor_cred']=$new->Total;
                        $data['account_cred']=52;
                        $data['debitor_debt']=$new->Total;
                        $data['account_debt']=$store->Account;
                        $this->JunDetails($data);

                    }

                    $data['creditor_cred']=$event->requests['Total_Return_Value'];
                    $data['account_cred']=$event->requests['Safe'];
                    $data['debitor_debt']=$event->requests['Total_Return_Value'];
                    $data['account_debt']=$event->requests['Client'];
                    $this->JunDetails($data);



                    $data['debitor']=$event->requests['Total_Return_Value'] - $event->requests['Total_Taxes'];
                    $data['creditor']=0;
                    $data['account']=49;
                    $this->OneJunDetails($data,0);


                    foreach($NewMkhazns as $new){

                        $TTax=Taxes::find($new->Tax);


                        $data['debitor']=$event->requests['Total_Taxes'];
                        $data['creditor']=0;
                        $data['account']=$TTax->Account;
                        $this->OneJunDetails($data,0);



                    }


                    $data['debitor']=0;
                    $data['creditor']=$event->requests['Total_Return_Value'] ;
                    $data['account']=$event->requests['Client'] ;
                    $this->OneJunDetails($data,0);

                }else{


                    foreach($NewMkhazns as $new){

                        $store=Stores::find($new->Store);

                        $data['creditor_cred']=$new->Total;
                        $data['account_cred']=52;
                        $data['debitor_debt']=$new->Total;
                        $data['account_debt']=$store->Account;
                        $this->JunDetails($data);

                    }


                    $data['creditor_cred']=$event->requests['Total_Return_Value'];
                    $data['account_cred']=$event->requests['Safe'];
                    $data['debitor_debt']=$event->requests['Total_Return_Value'];
                    $data['account_debt']=$event->requests['Client'];
                    $this->JunDetails($data);

                    $data['creditor_cred']=$event->requests['Total_Return_Value'];
                    $data['account_cred']=$event->requests['Client'];
                    $data['debitor_debt']=$event->requests['Total_Return_Value'];
                    $data['account_debt']=49;
                    $this->JunDetails($data);

                }
            }



        }elseif($event->requests['Payment_Method'] == 'Later'){


            if($event->requests['Total_Discount'] != 0){

                if($event->requests['Total_Taxes']  != 0){

                    foreach($NewMkhazns as $new){

                        $store=Stores::find($new->Store);

                        $data['creditor_cred']=$new->Total;
                        $data['account_cred']=52;
                        $data['debitor_debt']=$new->Total;
                        $data['account_debt']=$store->Account;
                        $this->JunDetails($data);

                    }


                    $data['debitor']=$event->requests['Total_Return_Value']  - $event->requests['Total_Taxes'];
                    $data['creditor']=0;
                    $data['account']=49;
                    $this->OneJunDetails($data,0);

                    foreach($NewMkhazns as $new){

                        $TTax=Taxes::find($new->Tax);
                        $data['debitor']=$event->requests['Total_Taxes'];
                        $data['creditor']=0;
                        $data['account']=$TTax->Account;
                        $this->OneJunDetails($data,0);


                    }


                    if($paid != 0 or $paid > 0){


                        $data['debitor']=0;
                        $data['creditor']=(($event->requests['Total_Return_Value'] - $event->requests['Total_Taxes']) -  $event->requests['Total_Discount'] ) + $event->requests['Total_Taxes'];
                        $data['account']=$event->requests['Client'];
                        $this->OneJunDetails($data,0);

                        $data['debitor']=0;
                        $data['creditor']=$event->requests['Total_Discount'];
                        $data['account']=50;
                        $this->OneJunDetails($data,0);

                        $data['debitor']=$paid ;
                        $data['creditor']=0;
                        $data['account']=$event->requests['Client'];
                        $this->OneJunDetails($data,0);


                        $data['debitor']=0;
                        $data['creditor']=$paid;
                        $data['account']=$event->requests['Safe'];
                        $this->OneJunDetails($data,0);





                    }else{


                        $data['debitor']=0;
                        $data['creditor']=(($event->requests['Total_Return_Value'] - $event->requests['Total_Taxes']) -  $event->requests['Total_Discount'] ) + $event->requests['Total_Taxes'];
                        $data['account']=$event->requests['Client'];
                        $this->OneJunDetails($data,0);

                        $data['debitor']=0;
                        $data['creditor']= $event->requests['Total_Discount'];
                        $data['account']=50;
                        $this->OneJunDetails($data,0);

                    }



                }else{

                    foreach($NewMkhazns as $new){

                        $store=Stores::find($new->Store);

                        $data['creditor_cred']=$new->Total;
                        $data['account_cred']=52;
                        $data['debitor_debt']=$new->Total;
                        $data['account_debt']=$store->Account;
                        $this->JunDetails($data);

                    }


                    $data['debitor']=$event->requests['Total_Return_Value'] ;
                    $data['creditor']=0;
                    $data['account']=49;
                    $this->OneJunDetails($data,0);



                    if($paid != 0 or $paid > 0){


                        $data['debitor']=0;
                        $data['creditor']=$event->requests['Total_Return_Value'] - $event->requests['Total_Discount'];
                        $data['account']=$event->requests['Client'];
                        $this->OneJunDetails($data,0);




                        $data['debitor']=0;
                        $data['creditor']=$event->requests['Total_Discount'];
                        $data['account']=50;
                        $this->OneJunDetails($data,0);


                        $data['debitor']=$paid ;
                        $data['creditor']=0;
                        $data['account']=$event->requests['Client'];
                        $this->OneJunDetails($data,0);


                        $data['debitor']=0;
                        $data['creditor']=$paid;
                        $data['account']=$event->requests['Safe'];
                        $this->OneJunDetails($data,0);




                    }else{


                        $data['debitor']=0;
                        $data['creditor']=$event->requests['Total_Return_Value'] - $event->requests['Total_Discount'];
                        $data['account']=$event->requests['Client'];
                        $this->OneJunDetails($data,0);

                        $data['debitor']=0;
                        $data['creditor']= $event->requests['Total_Discount'];
                        $data['account']=50;
                        $this->OneJunDetails($data,0);

                    }


                }
            }else{

                if($event->requests['Total_Taxes']  != 0){


                    foreach($NewMkhazns as $new){

                        $store=Stores::find($new->Store);

                        $data['creditor_cred']=$new->Total;
                        $data['account_cred']=52;
                        $data['debitor_debt']=$new->Total;
                        $data['account_debt']=$store->Account;
                        $this->JunDetails($data);

                    }


                    $data['debitor']=$event->requests['Total_Return_Value'] - $event->requests['Total_Taxes'];
                    $data['creditor']=0;
                    $data['account']=49;
                    $this->OneJunDetails($data,0);



                    foreach($NewMkhazns as $new){

                        $TTax=Taxes::find($new->Tax);
                        $data['debitor']=$event->requests['Total_Taxes'];
                        $data['creditor']=0;
                        $data['account']=$TTax->Account;
                        $this->OneJunDetails($data,0);


                    }


                    $data['debitor']=0;
                    $data['creditor']=$event->requests['Total_Return_Value'] ;
                    $data['account']=$event->requests['Client'] ;
                    $this->OneJunDetails($data,0);


                    if($paid != 0 or $paid > 0){

                        $data['creditor_cred']=$paid;
                        $data['account_cred']=$event->requests['Safe'];
                        $data['debitor_debt']=$paid;
                        $data['account_debt']=$event->requests['Client'];
                        $this->JunDetails($data);

                    }


                }else{


                    foreach($NewMkhazns as $new){

                        $store=Stores::find($new->Store);

                        $data['creditor_cred']=$new->Total;
                        $data['account_cred']=52;
                        $data['debitor_debt']=$new->Total;
                        $data['account_debt']=$store->Account;
                        $this->JunDetails($data);

                    }


                    $data['creditor_cred']=$event->requests['Total_Return_Value'];
                    $data['account_cred']=$event->requests['Client'];
                    $data['debitor_debt']=$event->requests['Total_Return_Value'];
                    $data['account_debt']=49;
                    $this->JunDetails($data);


                    if($paid != 0 or $paid > 0){


                        $data['creditor_cred']=$paid;
                        $data['account_cred']=$event->requests['Safe'];
                        $data['debitor_debt']=$paid;
                        $data['account_debt']=$event->requests['Client'];
                        $this->JunDetails($data);



                    }




                }
            }

        }


        //lw f nsb llmnadeb w el mnfzen
        if($AccDefff->Commission == 2){
            if(!empty($Bill->Delegate)){


                $Empooo=Employess::find($Bill->Delegate);
                $Ratios=EmpRatio::where('Emp',$Bill->Delegate)->get();
                $to=$event->requests['Total_Return_Value'] ;
                $s=0;
                foreach($Ratios as $r){
                    if($r->Typee == 1){

                        if($r->From  <=  (float)$to  and $r->To  >=  (float)$to ){

                            $xi=$r->Rate  / 100 ;
                            $xxi= $xi *  (float)$to;
                            $s+=$xxi;

                        }else{

                            $s+=0;

                        }


                    }

                }



                $JunID = DB::table('journalizings')->insertGetId(

                    array(


                        'Type' => 'استحقاق عمولة',
                        'TypeEn' => 'Commission Entitlement',
                        'Code_Type' => $Bill->Code,
                        'Date' => $event->requests['Date'],
                        'Draw' => $event->requests['Draw'],
                        'Coin' => $event->requests['Coin'],
                        'Cost_Center' =>$event->requests['Cost_Center'],
                        'Total_Debaitor' => $s,
                        'Total_Creditor' => $s,
                        'Note' => null,

                    )
                );

                $Code =Journalizing::findOrFail($JunID)->Code;

                $PRODUCTSS['Joun_ID']=$JunID;
                $PRODUCTSS['Debitor']=0;
                $PRODUCTSS['Creditor']=$s;
                $PRODUCTSS['Account']=$Empooo->Commission;
                $PRODUCTSS['Statement']=null;


                JournalizingDetails::create($PRODUCTSS);

                $Gen['Code']=$Code;
                $Gen['Code_Type']=$Bill->Code;
                $Gen['Date']=$event->requests['Date'];
                $Gen['Type']='استحقاق عمولة';
                $Gen['TypeEn']='Commission Entitlement';
                $Gen['Debitor']=0;
                $Gen['Creditor']=$s;
                $Gen['Statement']=null;
                $Gen['Draw']=$event->requests['Draw'];
                $Gen['Debitor_Coin']=$event->requests['Draw'] * 0;
                $Gen['Creditor_Coin']=$event->requests['Draw'] * $s;
                $Gen['Account']=$Empooo->Commission;
                $Gen['Coin']= $event->requests['Coin'];
                $Gen['Cost_Center']=$event->requests['Cost_Center'];
                $Gen['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Gen);


                $PRODUCTSS['Joun_ID']=$JunID;
                $PRODUCTSS['Debitor']=$s;
                $PRODUCTSS['Creditor']=0;
                $PRODUCTSS['Account']=$Empooo->Merit;
                $PRODUCTSS['Statement']=null;


                JournalizingDetails::create($PRODUCTSS);

                $Gen['Code']=$Code;
                $Gen['Code_Type']=$Bill->Code;
                $Gen['Date']=$event->requests['Date'];
                $Gen['Type']='استحقاق عمولة';
                $Gen['TypeEn']='Commission Entitlement';
                $Gen['Debitor']=$s;
                $Gen['Creditor']= 0;
                $Gen['Statement']=null;
                $Gen['Draw']=$event->requests['Draw'];
                $Gen['Debitor_Coin']= $event->requests['Draw'] * $s;
                $Gen['Creditor_Coin']=$event->requests['Draw'] * 0;
                $Gen['Account']=$Empooo->Merit;
                $Gen['Coin']= $event->requests['Coin'];
                $Gen['Cost_Center']=$event->requests['Cost_Center'];
                $Gen['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Gen);




            }


            if(!empty($Bill->Executor)){

                $Empooo=Employess::find($Bill->Executor);

                $Ratios=EmpRatio::where('Emp',$Bill->Executor)->get();
                $to=$event->requests['Total_Return_Value'] ;
                $e=0;

                foreach($Ratios as $r){
                    if($r->Typee == 2){

                        if($r->From  <=  (float)$to  and $r->To  >=  (float)$to ){

                            $xi=$r->Rate  / 100 ;
                            $xxi= $xi *  (float)$to;
                            $e+=$xxi;

                        }else{

                            $e+=0;

                        }


                    }

                }

                $JunID = DB::table('journalizings')->insertGetId(

                    array(

                        'Type' => 'استحقاق عمولة',
                        'TypeEn' => 'Commission Entitlement',
                        'Code_Type' => $Bill->Code,
                        'Date' => $event->requests['Date'],
                        'Draw' => $event->requests['Draw'],
                        'Coin' => $event->requests['Coin'],
                        'Cost_Center' =>$event->requests['Cost_Center'],
                        'Total_Debaitor' => $e,
                        'Total_Creditor' => $e,
                        'Note' => null,

                    )
                );

                $Code =Journalizing::findOrFail($JunID)->Code;

                $PRODUCTSS['Joun_ID']=$JunID;
                $PRODUCTSS['Debitor']=0;
                $PRODUCTSS['Creditor']=$e;
                $PRODUCTSS['Account']=$Empooo->Commission;
                $PRODUCTSS['Statement']=null;


                JournalizingDetails::create($PRODUCTSS);

                $Gen['Code']=$Code;
                $Gen['Code_Type']=$Bill->Code;
                $Gen['Date']=$event->requests['Date'];
                $Gen['Type']='استحقاق عمولة';
                $Gen['TypeEn']='Commission Entitlement';
                $Gen['Debitor']=0;
                $Gen['Creditor']=$e;
                $Gen['Statement']=null;
                $Gen['Draw']=$event->requests['Draw'];
                $Gen['Debitor_Coin']=$event->requests['Draw'] * 0;
                $Gen['Creditor_Coin']=$event->requests['Draw'] * $e;
                $Gen['Account']=$Empooo->Commission;
                $Gen['Coin']= $event->requests['Coin'];
                $Gen['Cost_Center']=$event->requests['Cost_Center'];
                $Gen['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Gen);


                $PRODUCTSS['Joun_ID']=$JunID;
                $PRODUCTSS['Debitor']=$e;
                $PRODUCTSS['Creditor']=0;
                $PRODUCTSS['Account']=$Empooo->Merit;
                $PRODUCTSS['Statement']=null;


                JournalizingDetails::create($PRODUCTSS);

                $Gen['Code']=$Code;
                $Gen['Code_Type']=$Bill->Code;
                $Gen['Date']=$event->requests['Date'];
                $Gen['Type']='استحقاق عمولة';
                $Gen['TypeEn']='Commission Entitlement';
                $Gen['Debitor']=$e;
                $Gen['Creditor']= 0;
                $Gen['Statement']=null;
                $Gen['Draw']=$event->requests['Draw'];
                $Gen['Debitor_Coin']= $event->requests['Draw'] * $e;
                $Gen['Creditor_Coin']=$event->requests['Draw'] * 0;
                $Gen['Account']=$Empooo->Merit;
                $Gen['Coin']= $event->requests['Coin'];
                $Gen['Cost_Center']=$event->requests['Cost_Center'];
                $Gen['userr']= auth()->guard('admin')->user()->id;

                GeneralDaily::create($Gen);



            }

        }





    }
}
