<?php

namespace App\Listeners\ReturnWithout;

use App\Events\ReturnWithoutEvent;
use App\Models\FifoQty;
use App\Models\ProductReturnWithoutBill;
use App\Models\ReturnWithoutBill;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use App\Traits\GeneralTrait;

use App\Models\Journalizing;
use App\Models\StoreCount;
use App\Models\SubVirables;
use App\Models\ExpireDateQty;
use App\Models\ProductUnits;
use App\Models\ProductMoves;
use App\Models\ProductsQty;
use App\Models\Stores;
use App\Models\StoresDefaultData;
use App\Models\Products;



use App\Events\AddJournalizingEvent;
use DB;
use App\Services\Average;
use App\Services\PurchasesService;

class ReturnWithoutListener
{


    use GeneralTrait;

    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\TestEvent  $event
     * @return void
     */
    public function handle(ReturnWithoutEvent $event)
    {

        $service = new PurchasesService ;
        $average = new Average ;

        $Bill=ReturnWithoutBill::findOrFail($event->ID);
        $branch=Stores::findOrFail($event->requests['Store']);
        $def=StoresDefaultData::latest('id')->first();


        //Event
        if(!empty($event->requests['Later_Due'])){

            $data=[

                'start_date'=>$event->requests['Later_Due'],
                'end_date'=>$event->requests['Later_Due'],
                'event_name_ar'=>'استحقاق فاتوره مشتريات آجل ',
                'event_name_en'=>'Due Purchase invoice',
                'type'=>'المشتريات',
                'type_id'=>null,
                'type_code'=>$Bill->Code,
                'emp'=>$event->requests['Delegate'],
                'client'=>$event->requests['Vendor'],
                'product'=>null,
                'customer'=>null,

            ];


            $this->CreateEvent($data);


        }


if(empty($event->requests['Ship'])){
    $event->requests['Ship']=null;
}

        //Products Details and Qties
        if(!empty($event->requests['Unit'])){

            StoreCount::truncate();

            $P_Ar_Name=$event->requests['P_Ar_Name'];
            $P_En_Name=$event->requests['P_En_Name'];
            $Unit=$event->requests['Unit'];
            $P_Code=$event->requests['P_Code'];
            $Qty=$event->requests['Qty'];
            $Price=$event->requests['Price'];  // cost price
            $Discount=$event->requests['Discount'];
            $TotalBFTax=$event->requests['TotalBFTax'];
            $TotalTax=$event->requests['TotalTax'];
            $PurchTax=$event->requests['PurchTax'];
            $Total=$event->requests['Total'];
            $StorePurch=$event->requests['StorePurch'];

            $Product=$event->requests['Product'];
            $VOne=$event->requests['VOne'];
            $VTwo=$event->requests['VTwo'];
            $V_Name=$event->requests['V_Name'];
            $VV_Name=$event->requests['VV_Name'];
            $Cost=$event->requests['Cost']; // sale price


            $TDiscount=$event->requests['TDiscPro'];


            for($i=0 ; $i < count($Unit) ; $i++){

                $pp=ProductUnits::where('Product',$Product[$i])->where('Unit',$Unit[$i])->first();
                $plow=ProductUnits::where('Product',$Product[$i])->where('Def',1)->first();

                $uu['Product_Code']=$P_Code[$i];
                $uu['P_Ar_Name']=$P_Ar_Name[$i];
                $uu['SmallCode']=$plow->Barcode;
                $uu['P_En_Name']=$P_En_Name[$i];
                $uu['V_Name']=$V_Name[$i];
                $uu['VV_Name']=$VV_Name[$i];
                $uu['Original_Qty']=$Qty[$i];
                $uu['Qty']=$Qty[$i];
                $uu['SmallQty']=$Qty[$i] * $pp->Rate;
                $uu['Price']=$Price[$i];
                $uu['Cost']=$Cost[$i];
                $uu['Discount']=$Discount[$i];
                $uu['Tax']=$PurchTax[$i];
                $uu['Total_Bf_Tax']=$TotalBFTax[$i];
                $uu['Total_Tax']=$TotalTax[$i];
                $uu['Total']=$Total[$i];
                $uu['Store']=$StorePurch[$i];
                $uu['Product']=$Product[$i];
                $uu['Unit']=$Unit[$i];
                $uu['TDiscount']=$TDiscount[$i];
                $uu['Bill']=$event->ID;
                $uu['Date']=$event->requests['Date'];
                $uu['Code']=$Bill->Code;
                $uu['Refernce_Number']=$event->requests['Refernce_Number'];
                $uu['Safe']=$event->requests['Safe'];
                $uu['Vendor']=$event->requests['Vendor'];
                $uu['Delegate']=$event->requests['Delegate'];
                $uu['Payment_Method']=$event->requests['Payment_Method'];
                $uu['Coin']=$event->requests['Coin'];
                $uu['Ship']=$event->requests['Ship'];
                $uu['User']=auth()->guard('admin')->user()->id;
                $uu['Cost_Center']=$event->requests['Cost_Center'];
                $uu['Type']='مشتريات';
                $uu['TypeEn']='Purchases';
                if( !empty($V_Name[$i]) and !empty($VV_Name[$i])){

                    $my_value = $V_Name[$i];
                    $first_word = explode(' - ',trim($my_value))[0];
                    $second_word = explode(' - ',trim($my_value))[1];

                    $vId=SubVirables::where('Name','like', $first_word.'%')->first();
                    $vvId=SubVirables::where('Name','like', $second_word.'%')->first();
                    if(empty($vId)){
                        $vId=SubVirables::where('NameEn','like', $first_word.'%')->first();
                    }

                    if(empty($vvId)){
                        $vvId=SubVirables::where('NameEn','like', $second_word.'%')->first();
                    }
                    $uu['V1']=$vId->id;
                    $uu['V2']=$vvId->id;

                }else{

                    $uu['V1']=$VOne[$i];
                    $uu['V2']=$VTwo[$i];
                }
                ProductReturnWithoutBill::create($uu);

                if($event->requests['Status'] == 1){


                    $Quantity=$this->ProAvQties($StorePurch[$i],$Product[$i],$P_Code[$i]);


                    if(!empty($Quantity)){

                        //if have old Qty

                        $unit=ProductUnits::where('Unit',$Unit[$i])->where('Product',$Product[$i])->first();
                        $plow=ProductUnits::where('Product',$Product[$i])->where('Def',1)->first();

                        $qq= $unit->Rate * $Qty[$i] ;
                        $newqty=$Quantity->Qty + $qq ;
                        $totalCost=$Cost[$i] * $Qty[$i];

                        $ty=$average->AverageCost($totalCost,$qq,$Product[$i],$P_Code[$i],$StorePurch[$i],$event->requests['Date'],$Cost[$i]);


                        $prooooo=Products::findOrFail($Product[$i]);

                        if($prooooo->P_Type == 'Serial' or $prooooo->P_Type == 'Single_Variable' or $prooooo->P_Type == 'Duble_Variable' ) {
                            $lastOperation = ProductMoves::latest('id')->where('Delete',0)->where('Edit',0)->where('P_Code', $P_Code[$i])->where('Product', $Product[$i])->where('Store', $StorePurch[$i])->first();
                        }else{
                            $lastOperation = ProductMoves::latest('id')->where('Delete',0)->where('Edit',0)->where('Product', $Product[$i])->where('Store', $StorePurch[$i])->first();
                        }

                        $in=$totalCost;
                        $out=0;
                        if(!empty($lastOperation)){
                            $current=$lastOperation->CostCurrent + $totalCost;
                        }else{
                            $current= $totalCost;
                        }
                        $cur=$newqty *  ($Cost[$i] / $unit->Rate) ;


                        //Add Qty to Store
                        ProductsQty::where('id',$Quantity->id)->update(['Qty'=>$newqty,'Price'=>$Cost[$i] , 'TotalCost'=>$cur]);

                        $prooooo=Products::find($Product[$i]);



                        //Product Moves
                        $move=[

                            'Date'=>$event->requests['Date'],
                            'Type'=>'مرتجع بدون فاتورة' ,
                            'TypeEn'=>'Return Withpout Bill',
                            'Bill_Num'=>$Bill->Code,
                            'Incom'=>$qq,
                            'Outcom'=>0,
                            'Current'=>$newqty,
                            'CostIn'=>number_format((float)$in, 2, '.', ''),
                            'CostOut'=>number_format((float)$out, 2, '.', ''),
                            'CostCurrent'=>number_format((float)$current, 2, '.', ''),
                            'P_Ar_Name'=>$P_Ar_Name[$i],
                            'P_En_Name'=>$P_En_Name[$i],
                            'P_Code'=>$P_Code[$i],
                            'Unit'=>$Unit[$i],
                            'Qty'=>$Qty[$i],
                            'Group'=>$prooooo->Group,
                            'Store'=>$StorePurch[$i],
                            'Product'=>$Product[$i],
                            'V1'=>$VOne[$i],
                            'V2'=>$VTwo[$i],
                            'Brand'=>$prooooo->Brand,
                            'Safe'=>$event->requests['Safe'],
                            'Branch'=>$branch->Branch,
                            'SalePrice'=>$plow->Price,
                            'ProductPrice'=>null,
                            'Delegate'=>$event->requests['Delegate'],
                            'Payment_Method'=>$event->requests['Payment_Method'],
                            'User'=>auth()->guard('admin')->user()->id,

                        ];

                        $this->ProductMoves($move);



                    }else{


                        //if new Qty in Store

                        if( !empty($V_Name[$i]) and !empty($VV_Name[$i])){
                            $my_value = $V_Name[$i];
                            $first_word = explode(' - ',trim($my_value))[0];
                            $second_word = explode(' - ',trim($my_value))[1];
                            $vId=SubVirables::where('Name','like', $first_word.'%')->first();
                            $vvId=SubVirables::where('Name','like', $second_word.'%')->first();
                            if(empty($vId)){
                                $vId=SubVirables::where('NameEn','like', $first_word.'%')->first();
                            }
                            if(empty($vvId)){
                                $vvId=SubVirables::where('NameEn','like', $second_word.'%')->first();
                            }
                            $sNam=$first_word;
                            $sId=$vId->id;
                            $ssNam=$second_word;
                            $ssId=$vvId->id;
                        }else{
                            $sNam=$V_Name[$i];
                            $ssNam=$VV_Name[$i];
                            $sId=$VOne[$i];
                            $ssId=$VTwo[$i];
                        }

                        $id_store = DB::table('products_stores')->insertGetId(

                            array(

                                'P_Ar_Name' => $P_Ar_Name[$i],
                                'P_En_Name' => $P_En_Name[$i],
                                'P_Code' => $P_Code[$i],
                                'Exp_Date' => null,
                                'Product' => $Product[$i],
                                'Store' =>$StorePurch[$i],
                                'V1' => $sId,
                                'V2' => $ssId,
                                'V_Name' => $sNam,
                                'VV_Name' => $ssNam,

                            )
                        );

                        $prooooo=Products::find($Product[$i]);

                        $pqty['P_Ar_Name']=$P_Ar_Name[$i];
                        $pqty['Exp_Date']=null;
                        $pqty['P_En_Name']=$P_En_Name[$i];
                        $pqty['Qty']=$Qty[$i] * $pp->Rate;
                        $pqty['Price']=$Cost[$i] / $pp->Rate;
                        $pqty['TotalCost']=($Cost[$i] / $pp->Rate) * ($Qty[$i] * $pp->Rate);
                        $pqty['Pro_Stores']=$id_store;
                        $pqty['Store']=$StorePurch[$i];
                        $pqty['Unit']=$Unit[$i];
                        $pqty['Low_Unit']=$plow->Unit;
                        $pqty['Product']=$Product[$i];

                        $pqty['SearchCode1']=$prooooo->SearchCode1;
                        $pqty['SearchCode2']=$prooooo->SearchCode2;
                        if( !empty($V_Name[$i]) and !empty($VV_Name[$i])){
                            $my_value = $V_Name[$i];
                            $first_word = explode(' - ',trim($my_value))[0];
                            $second_word = explode(' - ',trim($my_value))[1];
                            $vId=SubVirables::where('Name','like', $first_word.'%')->first();
                            $vvId=SubVirables::where('Name','like', $second_word.'%')->first();
                            if(empty($vId)){
                                $vId=SubVirables::where('NameEn','like', $first_word.'%')->first();
                            }
                            if(empty($vvId)){
                                $vvId=SubVirables::where('NameEn','like', $second_word.'%')->first();
                            }
                            $pqty['V1']=$vId->id;
                            $pqty['V2']=$vvId->id;
                            $pqty['V_Name']=$first_word;
                            $pqty['VV_Name']=$second_word;
                            $pqty['P_Code']=$P_Code[$i];

                        }else{

                            if($prooooo->P_Type == 'Serial'){

                                $pqty['V1']=$VOne[$i];
                                $pqty['V2']=$VTwo[$i];
                                $pqty['V_Name']=$V_Name[$i];
                                $pqty['VV_Name']=$VV_Name[$i];
                                $pqty['P_Code']=$P_Code[$i];

                            }else{


                                if($prooooo->P_Type == 'Single_Variable'){
                                    $pqty['V1']=$VOne[$i];
                                    $pqty['V2']=$VTwo[$i];
                                    $pqty['V_Name']=$V_Name[$i];
                                    $pqty['VV_Name']=$VV_Name[$i];
                                    $pqty['P_Code']=$P_Code[$i];

                                }elseif($prooooo->P_Type == 'Duble_Variable'){

                                    $pqty['P_Code']=$P_Code[$i];

                                }else{

                                    $coco=array();
                                    $CodesPrds=ProductUnits::where('Product',$Product[$i])->select('Barcode')->get();
                                    foreach($CodesPrds as $cco){

                                        array_push($coco,$cco->Barcode);

                                    }

                                    $pqty['V1']=$VOne[$i];
                                    $pqty['V2']=$VTwo[$i];
                                    $pqty['V_Name']=$V_Name[$i];
                                    $pqty['VV_Name']=$VV_Name[$i];
                                    $pqty['P_Code']=$coco[0];

                                    if(!empty($coco[1])){
                                        $pqty['PP_Code']=$coco[1];
                                    }else{
                                        $pqty['PP_Code']=null;
                                    }

                                    if(!empty($coco[2])){
                                        $pqty['PPP_Code']=$coco[2];
                                    }else{
                                        $pqty['PPP_Code']=null;
                                    }

                                    if(!empty($coco[3])){
                                        $pqty['PPPP_Code']=$coco[3];
                                    }else{
                                        $pqty['PPPP_Code']=null;
                                    }

                                }


                            }


                        }
                        $pqty['Group']=$prooooo->Group;
                        $pqty['Brand']=$prooooo->Brand;
                        $pqty['Branch']=$branch->Branch;
                        ProductsQty::create($pqty);



                        //product Moves
                        $newQQty=$Qty[$i] * $pp->Rate;

                        $totalCost=$Cost[$i] * $Qty[$i];



                        $ty=$average->AverageCost($totalCost,$newQQty,$Product[$i],$plow->Barcode,$StorePurch[$i],$event->requests['Date'],$Cost[$i]);

                        if($ty != 0){
                            $in=($Qty[$i] * $pp->Rate) * $ty ;
                            $out=0;
                            $current=($Qty[$i] * $pp->Rate) * $ty ;
                        }else{
                            $in=($Qty[$i] * $pp->Rate) * 1;
                            $out=0;
                            $current=($Qty[$i] * $pp->Rate) * 1;
                        }


                        //Product Moves
                        $move=[

                            'Date'=>$event->requests['Date'],
                            'Type'=>'مرتجع بدون فاتورة' ,
                            'TypeEn'=>'Return Without Bill',
                            'Bill_Num'=>$Bill->Code,
                            'Incom'=>$Qty[$i] * $pp->Rate,
                            'Outcom'=>0,
                            'Current'=>$Qty[$i] * $pp->Rate,
                            'CostIn'=>number_format((float)$in, 2, '.', ''),
                            'CostOut'=>number_format((float)$out, 2, '.', ''),
                            'CostCurrent'=>number_format((float)$current, 2, '.', ''),
                            'P_Ar_Name'=>$P_Ar_Name[$i],
                            'P_En_Name'=>$P_En_Name[$i],
                            'P_Code'=>$P_Code[$i],
                            'Unit'=>$Unit[$i],
                            'Qty'=>$Qty[$i],
                            'Group'=>$prooooo->Group,
                            'Store'=>$StorePurch[$i],
                            'Product'=>$Product[$i],
                            'V1'=>$VOne[$i],
                            'V2'=>$VTwo[$i],
                            'Brand'=>$prooooo->Brand,
                            'Safe'=>$event->requests['Safe'],
                            'Branch'=>$branch->Branch,
                            'SalePrice'=>$plow->Price,
                            'ProductPrice'=>null,
                            'Delegate'=>$event->requests['Delegate'],
                            'Payment_Method'=>$event->requests['Payment_Method'],
                            'User'=>auth()->guard('admin')->user()->id,

                        ];

                        $this->ProductMoves($move);


                    }


                    //Expire Date
                    if(!empty(null)){


                        $unit=ProductUnits::where('Unit',$Unit[$i])->where('Product',$Product[$i])->first();
                        $EXPO=$this->ExpireAvQties($StorePurch[$i],$Product[$i],$P_Code[$i]);



                        if(!empty($EXPO)){


                            if($EXPO->Exp_Date == null){

                                $qq= $unit->Rate * $Qty[$i] ;
                                $NewExpQty=$EXPO->Qty + $qq ;
                                ExpireDateQty::where('id',$EXPO->id)->update(['Qty'=>$NewExpQty]);

                            }else{


                                $EXNEW['Qty']=$unit->Rate * $Qty[$i];
                                $EXNEW['P_Ar_Name']=$EXPO->P_Ar_Name;
                                $EXNEW['P_En_Name']=$EXPO->P_En_Name;
                                $EXNEW['P_Code']=$EXPO->P_Code;
                                $EXNEW['PP_Code']=$EXPO->PP_Code;
                                $EXNEW['PPP_Code']=$EXPO->PPP_Code;
                                $EXNEW['PPPP_Code']=$EXPO->PPPP_Code;
                                $EXNEW['V_Name']=$EXPO->V_Name;
                                $EXNEW['VV_Name']=$EXPO->VV_Name;
                                $EXNEW['Store']=$EXPO->Store;
                                $EXNEW['Unit']=$EXPO->Unit;
                                $EXNEW['Product']=$EXPO->Product;
                                $EXNEW['V1']=$EXPO->V1;
                                $EXNEW['V2']=$EXPO->V2;
                                $EXNEW['Low_Unit']=$EXPO->Low_Unit;
                                $EXNEW['Exp_Date']=null;
                                $EXNEW['Group']=$EXPO->Group;
                                $EXNEW['Brand']=$EXPO->Brand;
                                $EXNEW['Branch']=$EXPO->Branch;

                                ExpireDateQty::create($EXNEW);

                            }


                        }else{

                            $CodesProducts=ProductUnits::where('Product',$Product[$i])->select('Barcode')->get();
                            $prooooo=Products::find($Product[$i]);


                            if( !empty($V_Name[$i]) and !empty($VV_Name[$i])){

                                $my_value = $V_Name[$i];
                                $first_word = explode(' - ',trim($my_value))[0];
                                $second_word = explode(' - ',trim($my_value))[1];

                                $vId=SubVirables::where('Name','like', $first_word.'%')->first();
                                $vvId=SubVirables::where('Name','like', $second_word.'%')->first();
                                if(empty($vId)){
                                    $vId=SubVirables::where('NameEn','like', $first_word.'%')->first();
                                }

                                if(empty($vvId)){
                                    $vvId=SubVirables::where('NameEn','like', $second_word.'%')->first();
                                }
                                $sNam=$first_word;
                                $sId=$vId->id;
                                $ssNam=$second_word;
                                $ssId=$vvId->id;

                            }else{

                                $sNam=$V_Name[$i];
                                $ssNam=$VV_Name[$i];
                                $sId=$VOne[$i];
                                $ssId=$VTwo[$i];
                            }

                            $EXNEW['Qty']=$unit->Rate * $Qty[$i];
                            $EXNEW['P_Ar_Name']=$P_Ar_Name[$i];
                            $EXNEW['P_En_Name']=$P_En_Name[$i];
                            $EXNEW['P_Code']=$P_Code[$i];
                            $EXNEW['Store']=$StorePurch[$i];
                            $EXNEW['V1']=$sId;
                            $EXNEW['V2']=$ssId;
                            $EXNEW['Exp_Date']=null;
                            $EXNEW['Unit']=$Unit[$i];
                            $EXNEW['Product']=$Product[$i];
                            $EXNEW['V_Name']=$sNam;
                            $EXNEW['VV_Name']=$ssNam;
                            $cocoSS=array();

                            foreach($CodesProducts as $ccoPro){


                                array_push($cocoSS,$ccoPro->Barcode);

                            }

                            $EXNEW['P_Code']=$cocoSS[0];

                            if(!empty($coco[1])){
                                $EXNEW['PP_Code']=$cocoSS[1];
                            }else{
                                $EXNEW['PP_Code']=null;
                            }

                            if(!empty($coco[2])){
                                $EXNEW['PPP_Code']=$cocoSS[2];
                            }else{
                                $EXNEW['PPP_Code']=null;
                            }

                            if(!empty($coco[3])){
                                $EXNEW['PPPP_Code']=$cocoSS[3];
                            }else{
                                $EXNEW['PPPP_Code']=null;
                            }

                            $EXNEW['Group']=$prooooo->Group;
                            $EXNEW['Brand']=$prooooo->Brand;
                            $EXNEW['Branch']=$branch->Branch;
                            $EXNEW['Low_Unit']=$plow->Unit;
                            ExpireDateQty::create($EXNEW);

                        }



                    }



                    //Fifo
                    if($def->Cost_Price == 2){


                        $fifo=$this->FifoAvQty($StorePurch[$i],$Product[$i],$P_Code[$i],$event->requests['Date']);


                        if(!empty($fifo)){

                            $qq= $pp->Rate * $Qty[$i] ;

                            $newqty=$fifo->Qty + $qq ;

                            FifoQty::where('id',$fifo->id)->update(['Qty'=>$newqty,'Original_Qty'=>$newqty]);

                        }else{


                            if( !empty($V_Name[$i]) and !empty($VV_Name[$i])){

                                $my_value = $V_Name[$i];
                                $first_word = explode(' - ',trim($my_value))[0];
                                $second_word = explode(' - ',trim($my_value))[1];

                                $vId=SubVirables::where('Name','like', $first_word.'%')->first();
                                $vvId=SubVirables::where('Name','like', $second_word.'%')->first();
                                if(empty($vId)){
                                    $vId=SubVirables::where('NameEn','like', $first_word.'%')->first();
                                }

                                if(empty($vvId)){
                                    $vvId=SubVirables::where('NameEn','like', $second_word.'%')->first();
                                }
                                $sNam=$first_word;
                                $sId=$vId->id;
                                $ssNam=$second_word;
                                $ssId=$vvId->id;

                            }else{

                                $sNam=$V_Name[$i];
                                $ssNam=$VV_Name[$i];
                                $sId=$VOne[$i];
                                $ssId=$VTwo[$i];
                            }

                            $prooooo=Products::find($Product[$i]);

                            $pqty['P_Ar_Name']=$P_Ar_Name[$i];
                            $pqty['Exp_Date']=null;
                            $pqty['P_En_Name']=$P_En_Name[$i];
                            $pqty['Qty']=$Qty[$i] * $pp->Rate;
                            $pqty['Original_Qty']=$Qty[$i] * $pp->Rate;
                            $pqty['Cost_Price']=$Price[$i];
                            $pqty['Store']=$StorePurch[$i];
                            $pqty['Unit']=$Unit[$i];
                            $pqty['Low_Unit']=$plow->Unit;
                            $pqty['Product']=$Product[$i];
                            $pqty['SearchCode1']=$prooooo->SearchCode1;
                            $pqty['SearchCode2']=$prooooo->SearchCode2;
                            if( !empty($V_Name[$i]) and !empty($VV_Name[$i])){

                                $my_value = $V_Name[$i];
                                $first_word = explode(' - ',trim($my_value))[0];
                                $second_word = explode(' - ',trim($my_value))[1];

                                $vId=SubVirables::where('Name','like', $first_word.'%')->first();
                                $vvId=SubVirables::where('Name','like', $second_word.'%')->first();
                                if(empty($vId)){
                                    $vId=SubVirables::where('NameEn','like', $first_word.'%')->first();
                                }

                                if(empty($vvId)){
                                    $vvId=SubVirables::where('NameEn','like', $second_word.'%')->first();
                                }
                                $pqty['V1']=$vId->id;
                                $pqty['V2']=$vvId->id;
                                $pqty['V_Name']=$first_word;
                                $pqty['VV_Name']=$second_word;
                                $pqty['P_Code']=$P_Code[$i];

                            }else{



                                if($prooooo->P_Type == 'Serial'){

                                    $pqty['V1']=$VOne[$i];
                                    $pqty['V2']=$VTwo[$i];
                                    $pqty['V_Name']=$V_Name[$i];
                                    $pqty['VV_Name']=$VV_Name[$i];
                                    $pqty['P_Code']=$P_Code[$i];

                                }else{


                                    if($prooooo->P_Type == 'Single_Variable'){
                                        $pqty['V1']=$VOne[$i];
                                        $pqty['V2']=$VTwo[$i];
                                        $pqty['V_Name']=$V_Name[$i];
                                        $pqty['VV_Name']=$VV_Name[$i];
                                        $pqty['P_Code']=$P_Code[$i];

                                    }elseif($prooooo->P_Type == 'Duble_Variable'){

                                        $pqty['P_Code']=$P_Code[$i];

                                    }else{



                                        $coco=array();
                                        $CodesPrds=ProductUnits::where('Product',$Product[$i])->select('Barcode')->get();
                                        foreach($CodesPrds as $cco){


                                            array_push($coco,$cco->Barcode);

                                        }

                                        $pqty['V1']=$VOne[$i];
                                        $pqty['V2']=$VTwo[$i];
                                        $pqty['V_Name']=$V_Name[$i];
                                        $pqty['VV_Name']=$VV_Name[$i];
                                        $pqty['P_Code']=$coco[0];

                                        if(!empty($coco[1])){
                                            $pqty['PP_Code']=$coco[1];
                                        }else{
                                            $pqty['PP_Code']=null;
                                        }

                                        if(!empty($coco[2])){
                                            $pqty['PPP_Code']=$coco[2];
                                        }else{
                                            $pqty['PPP_Code']=null;
                                        }

                                        if(!empty($coco[3])){
                                            $pqty['PPPP_Code']=$coco[3];
                                        }else{
                                            $pqty['PPPP_Code']=null;
                                        }

                                    }


                                }


                            }
                            $pqty['Group']=$prooooo->Group;
                            $pqty['Brand']=$prooooo->Brand;
                            $pqty['Branch']=$branch->Branch;
                            $pqty['Purchases_Date']=$event->requests['Date'];
                            FifoQty::create($pqty);

                        }




                    }




                }



                // if have more stores Calculate each store one by one
                $Mkhazns=StoreCount::all();

                $totalCost=$Cost[$i] * $Qty[$i];

                if(count($Mkhazns) == 0){

                    $s['Store']=$StorePurch[$i];
                    $s['Total']=$totalCost;
                    $s['Tax']=$PurchTax[$i];
                    StoreCount::create($s);

                }else{


                    $m=StoreCount::where('Store',$StorePurch[$i])->first();

                    if(!empty($m)){

                        $newTot=$m->Total + $totalCost ;
                        StoreCount::where('id',$m->id)->update(['Total'=>$newTot]);

                    }else{


                        $s['Store']=$StorePurch[$i];
                        $s['Total']=$totalCost;
                        $s['Tax']=$PurchTax[$i];
                        StoreCount::create($s);

                    }

                }


            }


        }


        //Stores Moves
        $totpri=($event->requests['Total_Taxes'] +  $event->requests['Total_Price']) -  ($event->requests['Total_Discount'] + $event->requests['DiscountBill']);

        $dataStMove=[

            'Date'=>date('Y-m-d'),
            'Code'=>$Bill->Code ,
            'Time'=>date("h:i:s a", time()),
            'Branch'=>$branch->Branch,
            'Store'=>$event->requests['Store'],
            'Safe'=>$event->requests['Safe'],
            'Type'=>'مشتريات',
            'TypeEn'=>'Purchases',
            'Cost_Center'=>$event->requests['Cost_Center'],
            'User'=>auth()->guard('admin')->user()->id,
            'Coin'=>$event->requests['Coin'],
            'Note'=>$event->requests['Note'],
            'Total_Qty'=>$event->requests['Total_Qty'],
            'Total_Price'=>$totpri,
            'Account'=>$event->requests['Vendor'],
            'Ship'=>$event->requests['Ship'],
            'ID'=>$event->ID,

        ];

        $this->StoresMoves($dataStMove);


        $COOOUNT=StoreCount::count();



        //Jounralizing
        $type_ar='مرتجع بدون فاتورة';
        $type_en='Return Without Bill';
        $debitor=$event->requests['Total_Price'];
        $creditor=$event->requests['Total_Price'];
        $account_cred=0;
        $account_debt=0;
        $date=$event->requests['Date'];
        $draw=$event->requests['Draw'];
        $coin=$event->requests['Coin'];
        $cost_center=$event->requests['Cost_Center'];
        $note=$event->requests['Note'];
        $total=$event->requests['Total_Price'];
        $joun_id=0;
        $Code_Type=$Bill->Code;
        $Code=0;

        $data=[

            'type_ar'=>$type_ar,
            'type_en'=>$type_en,
            'code'=>$Code,
            'code_type'=>$Code_Type,
            'date'=>$date,
            'draw'=>$draw,
            'coin'=>$coin,
            'cost_center'=>$cost_center,
            'note'=>$note,
            'debitor_cred'=>0,
            'creditor_cred'=>$creditor,
            'account_cred'=>$account_cred,
            'debitor_debt'=>$debitor,
            'creditor_debt'=>0,
            'account_debt'=>$account_debt,
            'total'=>$total,
            'joun_id'=>$joun_id,
        ];

        $joun_id=$this->CreateNewJun($data);
        $new=Journalizing::findOrFail($joun_id);
        $data['code']=$new->Code;
        $data['joun_id']=$joun_id;
        $NewMkhazns=StoreCount::all();
        if($event->requests['Payment_Method'] == 'Cash'){


            $data['creditor_cred'] =$event->requests['Total_Price'] ;
            $data['account_cred'] = $event->requests['Vendor'];
            $data['debitor_debt'] =$event->requests['Total_Price'];
            $data['account_debt'] = 49 ;
            $this->JunDetails($data);


            foreach($NewMkhazns as $new){

                $store=Stores::find($new->Store);

                $data['creditor_cred'] = $new->Total;
                $data['account_cred'] =52 ;
                $data['debitor_debt'] =$new->Total;
                $data['account_debt'] = $store->Account;
                $this->JunDetails($data);


            }


            $data['creditor_cred'] = $event->requests['Total_Price'];
            $data['account_cred'] = $event->requests['Safe'];
            $data['debitor_debt'] =$event->requests['Total_Price'];
            $data['account_debt'] = $event->requests['Vendor'];
            $this->JunDetails($data);


        }elseif($event->requests['Payment_Method']  == 'Later'){


            $data['creditor_cred'] =$event->requests['Total_Price'] ;
            $data['account_cred'] = $event->requests['Vendor'];
            $data['debitor_debt'] =$event->requests['Total_Price'];
            $data['account_debt'] = 49 ;
            $this->JunDetails($data);


            foreach($NewMkhazns as $new){

                $store=Stores::find($new->Store);

                $data['creditor_cred'] = $new->Total;
                $data['account_cred'] =52 ;
                $data['debitor_debt'] =$new->Total;
                $data['account_debt'] = $store->Account;
                $this->JunDetails($data);


            }



        }





    }
}
