<?php

namespace App\Listeners\Purchases;

use App\Events\PurchasesEvent;
use App\Models\FifoQty;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use App\Traits\GeneralTrait;

use App\Models\Journalizing;
use App\Models\StoreCount;
use App\Models\SubVirables;
use App\Models\ProductsPurchases;
use App\Models\ExpireDateQty;
use App\Models\ProductUnits;
use App\Models\ProductMoves;
use App\Models\ProductsQty;
use App\Models\Purchases;
use App\Models\Stores;
use App\Models\StoresDefaultData;
use App\Models\Products;



use App\Events\AddJournalizingEvent;
use DB;
use App\Services\Average;
use App\Services\PurchasesService;

class PurchasesListener
{


     use GeneralTrait;

    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\TestEvent  $event
     * @return void
     */
    public function handle(PurchasesEvent $event)
    {

       $service = new PurchasesService ;
       $average = new Average ;

      $Bill=Purchases::findOrFail($event->ID);
      $branch=Stores::findOrFail($event->requests['Store']);
      $def=StoresDefaultData::latest('id')->first();
          //Notifications

     if($event->requests['Status'] == 0){

                $order=[
                'noti_name_ar'=>'فاتوره المشتريات قيد انتظار',
                'noti_name_en'=>'Purchases Bill Pending',
                'type_ar'=>'المشتريات',
                'type_en'=>'Purchases',
                'type_code'=>$Bill->Code,
                'emp'=>$event->requests['Delegate'],
                'client'=>$event->requests['Vendor'],
                'product'=>null,
                'store'=>$event->requests['Store'],
                'safe'=>$event->requests['Safe'],
                'notify_name'=>trans('admin.PurchasesBillPending'),
            ];
            $this->CreateNotification($order);

          }


        //Event
        if(!empty($event->requests['Later_Due'])){

               $data=[

             'start_date'=>$event->requests['Later_Due'],
             'end_date'=>$event->requests['Later_Due'],
             'event_name_ar'=>'استحقاق فاتوره مشتريات آجل ',
             'event_name_en'=>'Due Purchase invoice',
             'type'=>'المشتريات',
             'type_id'=>null,
             'type_code'=>$Bill->Code,
             'emp'=>$event->requests['Delegate'],
             'client'=>$event->requests['Vendor'],
             'product'=>null,
             'customer'=>null,

         ];


           $this->CreateEvent($data);


      }




        //Products Details and Qties
          if(!empty($event->requests['Unit'])){

          StoreCount::truncate();

          $P_Ar_Name=$event->requests['P_Ar_Name'];
          $P_En_Name=$event->requests['P_En_Name'];
          $Unit=$event->requests['Unit'];
          $P_Code=$event->requests['P_Code'];
          $Qty=$event->requests['Qty'];
          $Price=$event->requests['Price'];
          $Discount=$event->requests['Discount'];
          $TotalBFTax=$event->requests['TotalBFTax'];
          $TotalTax=$event->requests['TotalTax'];
          $PurchTax=$event->requests['PurchTax'];
          $Total=$event->requests['Total'];
          $StorePurch=$event->requests['StorePurch'];
          $Exp_Date=$event->requests['Exp_Date'];
          $Product=$event->requests['Product'];
          $VOne=$event->requests['VOne'];
          $VTwo=$event->requests['VTwo'];
          $V_Name=$event->requests['V_Name'];
          $VV_Name=$event->requests['VV_Name'];
          $Exp_Date=$event->requests['Exp_Date'];
          $Price_Sale=$event->requests['Price_Sale'];
          $TDiscount=$event->requests['TDiscPro'];
              $Total_Net=$event->requests['Total_Net'];


              if(!empty($event->requests['ChassisNumber'])){
                  $ChassisNumber=$event->requests['ChassisNumber'];
              }else{
                  $ChassisNumber=[];
              }
              if(!empty($event->requests['MotorNumber'])){
                  $MotorNumber=$event->requests['MotorNumber'];
              }else{
                  $MotorNumber=[];
              }





          for($i=0 ; $i < count($Unit) ; $i++){

              $pp=ProductUnits::where('Product',$Product[$i])->where('Unit',$Unit[$i])->first();
              $plow=ProductUnits::where('Product',$Product[$i])->where('Def',1)->first();

              if(!empty($ChassisNumber[$i])){
                  $uu['ChassisNumber']=$ChassisNumber[$i];
              }

              if(!empty($MotorNumber[$i])){
                  $uu['MotorNumber']=$MotorNumber[$i];
              }

              $uu['Product_Code']=$P_Code[$i];
              $uu['P_Ar_Name']=$P_Ar_Name[$i];
              $uu['SmallCode']=$plow->Barcode;
              $uu['P_En_Name']=$P_En_Name[$i];
              $uu['V_Name']=$V_Name[$i];
              $uu['VV_Name']=$VV_Name[$i];
              $uu['Original_Qty']=$Qty[$i];
              $uu['Qty']=$Qty[$i];
              $uu['SmallQty']=$Qty[$i] * $pp->Rate;
              $uu['Price']=$Price[$i];
              $uu['Discount']=$Discount[$i];
              $uu['Tax']=$PurchTax[$i];
              $uu['Total_Bf_Tax']=$TotalBFTax[$i];
              $uu['Total_Tax']=$TotalTax[$i];
              $uu['Total']=$Total[$i];
              $uu['Total_Net']=$Total_Net[$i];
              $uu['Store']=$StorePurch[$i];
              $uu['Product']=$Product[$i];
              $uu['Unit']=$Unit[$i];
              $uu['Exp_Date']=$Exp_Date[$i];
              $uu['TDiscount']=$TDiscount[$i];
              $uu['Purchase']=$event->ID;
              $uu['Date']=$event->requests['Date'];
              $uu['Code']=$Bill->Code;
              $uu['Refernce_Number']=$event->requests['Refernce_Number'];
              $uu['Safe']=$event->requests['Safe'];
              $uu['Vendor']=$event->requests['Vendor'];
              $uu['Delegate']=$event->requests['Delegate'];
              $uu['Payment_Method']=$event->requests['Payment_Method'];
              $uu['Coin']=$event->requests['Coin'];
              $uu['Ship']=$event->requests['Ship'];
              $uu['User']=auth()->guard('admin')->user()->id;
              $uu['Cost_Center']=$event->requests['Cost_Center'];
              $uu['Type']='مشتريات';
              $uu['TypeEn']='Purchases';
              if( !empty($V_Name[$i]) and !empty($VV_Name[$i])){

              $my_value = $V_Name[$i];
              $first_word = explode(' - ',trim($my_value))[0];
              $second_word = explode(' - ',trim($my_value))[1];

              $vId=SubVirables::where('Name','like', $first_word.'%')->first();
              $vvId=SubVirables::where('Name','like', $second_word.'%')->first();
              if(empty($vId)){
              $vId=SubVirables::where('NameEn','like', $first_word.'%')->first();
              }

              if(empty($vvId)){
              $vvId=SubVirables::where('NameEn','like', $second_word.'%')->first();
              }
              $uu['V1']=$vId->id;
              $uu['V2']=$vvId->id;

              }else{

              $uu['V1']=$VOne[$i];
              $uu['V2']=$VTwo[$i];
              }
              ProductsPurchases::create($uu);

              $prooooo=Products::findOrFail($Product[$i]);
              if($event->requests['Status'] == 1){


        $Quantity=$this->ProAvQties($StorePurch[$i],$Product[$i],$P_Code[$i]);
                  $unit=ProductUnits::where('Unit',$Unit[$i])->where('Product',$Product[$i])->first();
                  $plow=ProductUnits::where('Product',$Product[$i])->where('Def',1)->first();


              if(!empty($Quantity)){

                  //if have old Qty


              $qq= $unit->Rate * $Qty[$i] ;
              $newqty=$Quantity->Qty + $qq ;



            $ty=$average->AverageCost($TotalBFTax[$i],$qq,$Product[$i],$P_Code[$i],$StorePurch[$i],$event->requests['Date'],$Price[$i]);



if($prooooo->P_Type == 'Serial' or $prooooo->P_Type == 'Single_Variable' or $prooooo->P_Type == 'Duble_Variable' ) {
    $lastOperation = ProductMoves::latest('id')->where('Delete',0)->where('Edit',0)->where('P_Code', $P_Code[$i])->where('Product', $Product[$i])->where('Store', $StorePurch[$i])->first();
}else{
    $lastOperation = ProductMoves::latest('id')->where('Delete',0)->where('Edit',0)->where('Product', $Product[$i])->where('Store', $StorePurch[$i])->first();
}

              $in=$TotalBFTax[$i];
              $out=0;
              if(!empty($lastOperation)){
              $current=$lastOperation->CostCurrent + $TotalBFTax[$i];
              }else{

              $current= $TotalBFTax[$i];

              }

              $cur=$newqty * $ty ;

                  //Add Qty to Store
              ProductsQty::where('id',$Quantity->id)->update(['Qty'=>$newqty,'Exp_Date'=>$Exp_Date[$i],'Price'=>$ty , 'TotalCost'=>$cur]);

              $prooooo=Products::find($Product[$i]);

                            //Product Moves
        $move=[

            'Date'=>$event->requests['Date'],
            'Type'=>'مشتريات' ,
            'TypeEn'=>'Purchases',
            'Bill_Num'=>$Bill->Code,
            'Incom'=>$qq,
            'Outcom'=>0,
            'Current'=>$newqty,
             'CostIn'=>number_format((float)$in, 2, '.', ''),
            'CostOut'=>number_format((float)$out, 2, '.', ''),
            'CostCurrent'=>number_format((float)$current, 2, '.', ''),
            'P_Ar_Name'=>$P_Ar_Name[$i],
            'P_En_Name'=>$P_En_Name[$i],
            'P_Code'=>$P_Code[$i],
            'Unit'=>$Unit[$i],
            'Qty'=>$Qty[$i],
            'Group'=>$prooooo->Group,
            'Store'=>$StorePurch[$i],
            'Product'=>$Product[$i],
            'V1'=>$VOne[$i],
            'V2'=>$VTwo[$i],
            'Brand'=>$prooooo->Brand,
            'Safe'=>$event->requests['Safe'],
            'Branch'=>$branch->Branch,
            'SalePrice'=>$plow->Price,
            'ProductPrice'=>null,
            'Delegate'=>$event->requests['Delegate'],
            'Payment_Method'=>$event->requests['Payment_Method'],
            'User'=>auth()->guard('admin')->user()->id,

        ];

    $this->ProductMoves($move);



              }else{


                  $PRICE_RATE=$Price[$i]  /  $unit->Rate ;

                    //if new Qty in Store

              if( !empty($V_Name[$i]) and !empty($VV_Name[$i])){
              $my_value = $V_Name[$i];
              $first_word = explode(' - ',trim($my_value))[0];
              $second_word = explode(' - ',trim($my_value))[1];
              $vId=SubVirables::where('Name','like', $first_word.'%')->first();
              $vvId=SubVirables::where('Name','like', $second_word.'%')->first();
              if(empty($vId)){
              $vId=SubVirables::where('NameEn','like', $first_word.'%')->first();
              }
              if(empty($vvId)){
              $vvId=SubVirables::where('NameEn','like', $second_word.'%')->first();
              }
              $sNam=$first_word;
              $sId=$vId->id;
              $ssNam=$second_word;
              $ssId=$vvId->id;
              }else{
              $sNam=$V_Name[$i];
              $ssNam=$VV_Name[$i];
              $sId=$VOne[$i];
              $ssId=$VTwo[$i];
              }

              $id_store = DB::table('products_stores')->insertGetId(

              array(

              'P_Ar_Name' => $P_Ar_Name[$i],
              'P_En_Name' => $P_En_Name[$i],
              'P_Code' => $P_Code[$i],
              'Exp_Date' => $Exp_Date[$i],
              'Product' => $Product[$i],
              'Store' =>$StorePurch[$i],
              'V1' => $sId,
              'V2' => $ssId,
              'V_Name' => $sNam,
              'VV_Name' => $ssNam,

              )
              );

                  $unit=ProductUnits::where('Unit',$Unit[$i])->where('Product',$Product[$i])->first();
              $prooooo=Products::find($Product[$i]);

              $pqty['P_Ar_Name']=$P_Ar_Name[$i];
              $pqty['Exp_Date']=$Exp_Date[$i];
              $pqty['P_En_Name']=$P_En_Name[$i];
              $pqty['Qty']=$Qty[$i] * $unit->Rate;
              $pqty['Price']=$PRICE_RATE;
              $pqty['TotalCost']=$PRICE_RATE * ($Qty[$i] * $unit->Rate);
              $pqty['Pro_Stores']=$id_store;
              $pqty['Store']=$StorePurch[$i];
              $pqty['Unit']=$Unit[$i];
              $pqty['Low_Unit']=$plow->Unit;
              $pqty['Product']=$Product[$i];
              $pqty['Price_Sale']=$Price_Sale[$i];
              $pqty['SearchCode1']=$prooooo->SearchCode1;
              $pqty['SearchCode2']=$prooooo->SearchCode2;
              if( !empty($V_Name[$i]) and !empty($VV_Name[$i])){
              $my_value = $V_Name[$i];
              $first_word = explode(' - ',trim($my_value))[0];
              $second_word = explode(' - ',trim($my_value))[1];
              $vId=SubVirables::where('Name','like', $first_word.'%')->first();
              $vvId=SubVirables::where('Name','like', $second_word.'%')->first();
              if(empty($vId)){
              $vId=SubVirables::where('NameEn','like', $first_word.'%')->first();
              }
              if(empty($vvId)){
              $vvId=SubVirables::where('NameEn','like', $second_word.'%')->first();
              }
              $pqty['V1']=$vId->id;
              $pqty['V2']=$vvId->id;
              $pqty['V_Name']=$first_word;
              $pqty['VV_Name']=$second_word;
              $pqty['P_Code']=$P_Code[$i];

              }else{

              if($prooooo->P_Type == 'Serial'){

              $pqty['V1']=$VOne[$i];
              $pqty['V2']=$VTwo[$i];
              $pqty['V_Name']=$V_Name[$i];
              $pqty['VV_Name']=$VV_Name[$i];
              $pqty['P_Code']=$P_Code[$i];

              }else{


              if($prooooo->P_Type == 'Single_Variable'){
              $pqty['V1']=$VOne[$i];
              $pqty['V2']=$VTwo[$i];
              $pqty['V_Name']=$V_Name[$i];
              $pqty['VV_Name']=$VV_Name[$i];
              $pqty['P_Code']=$P_Code[$i];

              }elseif($prooooo->P_Type == 'Duble_Variable'){

              $pqty['P_Code']=$P_Code[$i];

              }else{

              $coco=array();
              $CodesPrds=ProductUnits::where('Product',$Product[$i])->select('Barcode')->get();
              foreach($CodesPrds as $cco){

              array_push($coco,$cco->Barcode);

              }

              $pqty['V1']=$VOne[$i];
              $pqty['V2']=$VTwo[$i];
              $pqty['V_Name']=$V_Name[$i];
              $pqty['VV_Name']=$VV_Name[$i];
              $pqty['P_Code']=$coco[0];

              if(!empty($coco[1])){
              $pqty['PP_Code']=$coco[1];
              }else{
              $pqty['PP_Code']=null;
              }

              if(!empty($coco[2])){
              $pqty['PPP_Code']=$coco[2];
              }else{
              $pqty['PPP_Code']=null;
              }

              if(!empty($coco[3])){
              $pqty['PPPP_Code']=$coco[3];
              }else{
              $pqty['PPPP_Code']=null;
              }

              }


              }


              }
              $pqty['Group']=$prooooo->Group;
              $pqty['Brand']=$prooooo->Brand;
              $pqty['Branch']=$branch->Branch;

                  if(!empty($ChassisNumber[$i])){
                      $pqty['ChassisNumber']=$ChassisNumber[$i];
                  }

                  if(!empty($MotorNumber[$i])){
                      $pqty['MotorNumber']=$MotorNumber[$i];
                  }


                  ProductsQty::create($pqty);

                  //product Moves
              $newQQty=$Qty[$i] * $unit->Rate;
              $ty=$average->AverageCost($TotalBFTax[$i],$newQQty,$Product[$i],$plow->Barcode,$StorePurch[$i],$event->requests['Date'],$Price[$i]);

                  $in=$newQQty *  $PRICE_RATE;
                  $out=0;
                  $current=$newQQty * $PRICE_RATE;

    //Product Moves
        $move=[

            'Date'=>$event->requests['Date'],
            'Type'=>'مشتريات' ,
            'TypeEn'=>'Purchases',
            'Bill_Num'=>$Bill->Code,
            'Incom'=>$Qty[$i] * $unit->Rate,
            'Outcom'=>0,
            'Current'=>$Qty[$i] * $unit->Rate,
            'CostIn'=>number_format((float)$in, 2, '.', ''),
            'CostOut'=>number_format((float)$out, 2, '.', ''),
            'CostCurrent'=>number_format((float)$current, 2, '.', ''),
            'P_Ar_Name'=>$P_Ar_Name[$i],
            'P_En_Name'=>$P_En_Name[$i],
            'P_Code'=>$P_Code[$i],
            'Unit'=>$Unit[$i],
            'Qty'=>$Qty[$i],
            'Group'=>$prooooo->Group,
            'Store'=>$StorePurch[$i],
            'Product'=>$Product[$i],
            'V1'=>$VOne[$i],
            'V2'=>$VTwo[$i],
            'Brand'=>$prooooo->Brand,
            'Safe'=>$event->requests['Safe'],
            'Branch'=>$branch->Branch,
            'SalePrice'=>$plow->Price,
            'ProductPrice'=>null,
            'Delegate'=>$event->requests['Delegate'],
            'Payment_Method'=>$event->requests['Payment_Method'],
            'User'=>auth()->guard('admin')->user()->id,

        ];

    $this->ProductMoves($move);


              }


                  //Expire Date
              if(!empty($Exp_Date[$i])){


             $unit=ProductUnits::where('Unit',$Unit[$i])->where('Product',$Product[$i])->first();
             $EXPO=$this->ExpireAvQties($StorePurch[$i],$Product[$i],$P_Code[$i]);



              if(!empty($EXPO)){


              if($EXPO->Exp_Date == $Exp_Date[$i]){

              $qq= $unit->Rate * $Qty[$i] ;
              $NewExpQty=$EXPO->Qty + $qq ;
              ExpireDateQty::where('id',$EXPO->id)->update(['Qty'=>$NewExpQty]);

              }else{


              $EXNEW['Qty']=$unit->Rate * $Qty[$i];
              $EXNEW['P_Ar_Name']=$EXPO->P_Ar_Name;
              $EXNEW['P_En_Name']=$EXPO->P_En_Name;
              $EXNEW['P_Code']=$EXPO->P_Code;
              $EXNEW['PP_Code']=$EXPO->PP_Code;
              $EXNEW['PPP_Code']=$EXPO->PPP_Code;
              $EXNEW['PPPP_Code']=$EXPO->PPPP_Code;
              $EXNEW['V_Name']=$EXPO->V_Name;
              $EXNEW['VV_Name']=$EXPO->VV_Name;
              $EXNEW['Store']=$EXPO->Store;
              $EXNEW['Unit']=$EXPO->Unit;
              $EXNEW['Product']=$EXPO->Product;
              $EXNEW['V1']=$EXPO->V1;
              $EXNEW['V2']=$EXPO->V2;
              $EXNEW['Low_Unit']=$EXPO->Low_Unit;
              $EXNEW['Exp_Date']=$Exp_Date[$i];
              $EXNEW['Group']=$EXPO->Group;
              $EXNEW['Brand']=$EXPO->Brand;
              $EXNEW['Branch']=$EXPO->Branch;

              ExpireDateQty::create($EXNEW);

              }


              }else{

                 $CodesProducts=ProductUnits::where('Product',$Product[$i])->select('Barcode')->get();
                 $prooooo=Products::find($Product[$i]);


              if( !empty($V_Name[$i]) and !empty($VV_Name[$i])){

              $my_value = $V_Name[$i];
              $first_word = explode(' - ',trim($my_value))[0];
              $second_word = explode(' - ',trim($my_value))[1];

              $vId=SubVirables::where('Name','like', $first_word.'%')->first();
              $vvId=SubVirables::where('Name','like', $second_word.'%')->first();
              if(empty($vId)){
              $vId=SubVirables::where('NameEn','like', $first_word.'%')->first();
              }

              if(empty($vvId)){
              $vvId=SubVirables::where('NameEn','like', $second_word.'%')->first();
              }
              $sNam=$first_word;
              $sId=$vId->id;
              $ssNam=$second_word;
              $ssId=$vvId->id;

              }else{

              $sNam=$V_Name[$i];
              $ssNam=$VV_Name[$i];
              $sId=$VOne[$i];
              $ssId=$VTwo[$i];
              }

              $EXNEW['Qty']=$unit->Rate * $Qty[$i];
              $EXNEW['P_Ar_Name']=$P_Ar_Name[$i];
              $EXNEW['P_En_Name']=$P_En_Name[$i];
              $EXNEW['P_Code']=$P_Code[$i];
              $EXNEW['Store']=$StorePurch[$i];
              $EXNEW['V1']=$sId;
              $EXNEW['V2']=$ssId;
              $EXNEW['Exp_Date']=$Exp_Date[$i];
              $EXNEW['Unit']=$Unit[$i];
              $EXNEW['Product']=$Product[$i];
              $EXNEW['V_Name']=$sNam;
              $EXNEW['VV_Name']=$ssNam;
              $cocoSS=array();

              foreach($CodesProducts as $ccoPro){


              array_push($cocoSS,$ccoPro->Barcode);

              }

              $EXNEW['P_Code']=$cocoSS[0];

              if(!empty($coco[1])){
              $EXNEW['PP_Code']=$cocoSS[1];
              }else{
              $EXNEW['PP_Code']=null;
              }

              if(!empty($coco[2])){
              $EXNEW['PPP_Code']=$cocoSS[2];
              }else{
              $EXNEW['PPP_Code']=null;
              }

              if(!empty($coco[3])){
              $EXNEW['PPPP_Code']=$cocoSS[3];
              }else{
              $EXNEW['PPPP_Code']=null;
              }

              $EXNEW['Group']=$prooooo->Group;
              $EXNEW['Brand']=$prooooo->Brand;
              $EXNEW['Branch']=$branch->Branch;
              $EXNEW['Low_Unit']=$plow->Unit;
              ExpireDateQty::create($EXNEW);

              }



              }



              //Fifo
              if($def->Cost_Price == 2){


         $fifo=$this->FifoAvQty($StorePurch[$i],$Product[$i],$P_Code[$i],$event->requests['Date']);


              if(!empty($fifo)){

              $qq= $pp->Rate * $Qty[$i] ;

              $newqty=$fifo->Qty + $qq ;

              FifoQty::where('id',$fifo->id)->update(['Qty'=>$newqty,'Original_Qty'=>$newqty]);

              }else{


              if( !empty($V_Name[$i]) and !empty($VV_Name[$i])){

              $my_value = $V_Name[$i];
              $first_word = explode(' - ',trim($my_value))[0];
              $second_word = explode(' - ',trim($my_value))[1];

              $vId=SubVirables::where('Name','like', $first_word.'%')->first();
              $vvId=SubVirables::where('Name','like', $second_word.'%')->first();
              if(empty($vId)){
              $vId=SubVirables::where('NameEn','like', $first_word.'%')->first();
              }

              if(empty($vvId)){
              $vvId=SubVirables::where('NameEn','like', $second_word.'%')->first();
              }
              $sNam=$first_word;
              $sId=$vId->id;
              $ssNam=$second_word;
              $ssId=$vvId->id;

              }else{

              $sNam=$V_Name[$i];
              $ssNam=$VV_Name[$i];
              $sId=$VOne[$i];
              $ssId=$VTwo[$i];
              }

                  $PRICE_RATE=$Price[$i]  /  $unit->Rate ;
               $prooooo=Products::find($Product[$i]);

              $pqty['P_Ar_Name']=$P_Ar_Name[$i];
              $pqty['Exp_Date']=$Exp_Date[$i];
              $pqty['P_En_Name']=$P_En_Name[$i];
              $pqty['Qty']=$Qty[$i] * $pp->Rate;
              $pqty['Original_Qty']=$Qty[$i] * $pp->Rate;
              $pqty['Cost_Price']=$PRICE_RATE;
              $pqty['Store']=$StorePurch[$i];
              $pqty['Unit']=$Unit[$i];
              $pqty['Low_Unit']=$plow->Unit;
              $pqty['Product']=$Product[$i];
              $pqty['SearchCode1']=$prooooo->SearchCode1;
              $pqty['SearchCode2']=$prooooo->SearchCode2;
              if( !empty($V_Name[$i]) and !empty($VV_Name[$i])){

              $my_value = $V_Name[$i];
              $first_word = explode(' - ',trim($my_value))[0];
              $second_word = explode(' - ',trim($my_value))[1];

              $vId=SubVirables::where('Name','like', $first_word.'%')->first();
              $vvId=SubVirables::where('Name','like', $second_word.'%')->first();
              if(empty($vId)){
              $vId=SubVirables::where('NameEn','like', $first_word.'%')->first();
              }

              if(empty($vvId)){
              $vvId=SubVirables::where('NameEn','like', $second_word.'%')->first();
              }
              $pqty['V1']=$vId->id;
              $pqty['V2']=$vvId->id;
              $pqty['V_Name']=$first_word;
              $pqty['VV_Name']=$second_word;
              $pqty['P_Code']=$P_Code[$i];

              }else{



              if($prooooo->P_Type == 'Serial'){

              $pqty['V1']=$VOne[$i];
              $pqty['V2']=$VTwo[$i];
              $pqty['V_Name']=$V_Name[$i];
              $pqty['VV_Name']=$VV_Name[$i];
              $pqty['P_Code']=$P_Code[$i];

              }else{


              if($prooooo->P_Type == 'Single_Variable'){
              $pqty['V1']=$VOne[$i];
              $pqty['V2']=$VTwo[$i];
              $pqty['V_Name']=$V_Name[$i];
              $pqty['VV_Name']=$VV_Name[$i];
              $pqty['P_Code']=$P_Code[$i];

              }elseif($prooooo->P_Type == 'Duble_Variable'){

              $pqty['P_Code']=$P_Code[$i];

              }else{



              $coco=array();
              $CodesPrds=ProductUnits::where('Product',$Product[$i])->select('Barcode')->get();
              foreach($CodesPrds as $cco){


              array_push($coco,$cco->Barcode);

              }

              $pqty['V1']=$VOne[$i];
              $pqty['V2']=$VTwo[$i];
              $pqty['V_Name']=$V_Name[$i];
              $pqty['VV_Name']=$VV_Name[$i];
              $pqty['P_Code']=$coco[0];

              if(!empty($coco[1])){
              $pqty['PP_Code']=$coco[1];
              }else{
              $pqty['PP_Code']=null;
              }

              if(!empty($coco[2])){
              $pqty['PPP_Code']=$coco[2];
              }else{
              $pqty['PPP_Code']=null;
              }

              if(!empty($coco[3])){
              $pqty['PPPP_Code']=$coco[3];
              }else{
              $pqty['PPPP_Code']=null;
              }

              }


              }


              }
              $pqty['Group']=$prooooo->Group;
              $pqty['Brand']=$prooooo->Brand;
              $pqty['Branch']=$branch->Branch;
              $pqty['Purchases_Date']=$event->requests['Date'];
              FifoQty::create($pqty);

              }




              }




              }



              // if have more stores Calculate each store one by one
              $Mkhazns=StoreCount::all();
              if(count($Mkhazns) == 0){

              $s['Store']=$StorePurch[$i];
              $s['Total']=$TotalBFTax[$i];
              $s['Tax']=$PurchTax[$i];
              StoreCount::create($s);

              }else{


              $m=StoreCount::where('Store',$StorePurch[$i])->first();

              if(!empty($m)){

              $newTot=$m->Total + $TotalBFTax[$i] ;
              StoreCount::where('id',$m->id)->update(['Total'=>$newTot]);

              }else{


              $s['Store']=$StorePurch[$i];
              $s['Total']=$TotalBFTax[$i];
              $s['Tax']=$PurchTax[$i];
              StoreCount::create($s);

              }

              }


              }


              }






             //Stores Moves
          $totpri=($event->requests['Total_Taxes'] +  $event->requests['Total_Price']) -  ($event->requests['Total_Discount'] + $event->requests['DiscountBill']);

         $dataStMove=[

            'Date'=>date('Y-m-d'),
            'Code'=>$Bill->Code ,
            'Time'=>date("h:i:s a", time()),
            'Branch'=>$branch->Branch,
            'Store'=>$event->requests['Store'],
            'Safe'=>$event->requests['Safe'],
            'Type'=>'مشتريات',
            'TypeEn'=>'Purchases',
            'Cost_Center'=>$event->requests['Cost_Center'],
            'User'=>auth()->guard('admin')->user()->id,
            'Coin'=>$event->requests['Coin'],
            'Note'=>$event->requests['Note'],
            'Total_Qty'=>$event->requests['Total_Qty'],
            'Total_Price'=>$totpri,
            'Account'=>$event->requests['Vendor'],
            'Ship'=>$event->requests['Ship'],
            'ID'=>$event->ID,

        ];

         $this->StoresMoves($dataStMove);






    }
}
