<?php

namespace App\Listeners\OpeningEntries;

use App\Events\SureOpeningEntriesEvent;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use App\Traits\GeneralTrait;
use App\Models\Journalizing;
use App\Models\GeneralDaily;
use App\Models\SafesBanks;
use App\Models\OpeningEntries;
use App\Models\OpeningEntriesDetails;
use App\Events\AddJournalizingEvent;  
class SureOpeningEntriesListener
{
    

     use GeneralTrait;
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\TestEvent  $event
     * @return void
     */
    public function handle(SureOpeningEntriesEvent $event)
    {
              

          
                  
        
        $type_ar= 'القيد الإفتتاحي';
        $type_en= 'Opening Entries';
        $type=0;
        $Status=1;
        $custom=1;
        $code_type=OpeningEntries::findOrFail($event->requests['ID']);

        $Dif= $event->requests['Total_Debaitor'] - $event->requests['Total_Creditor'] ;
        
            if(!empty($event->requests['SecAccount'])){
             
             $acc=$event->requests['SecAccount'];
         }else{
             $acc=45;
         }
             

        if($event->requests['Capital'] < 0){ $cred=0; $deb=$Dif; }else{ $cred=$Dif; $deb=0; } 
        
        $custom_data=[ 
            'Debitor'=>$cred,
            'Creditor'=>$deb,
            'Account'=>$acc,
            'Statement'=>$event->requests['Note'],
            'Safe'=>null,
            'Branch'=>null,
            'Code_Type'=>$code_type->Code,
            'Date'=>$event->requests['Date'],
            'Draw'=>$event->requests['Draw'],
            'Coin'=>$event->requests['Coin'],
            'Cost_Center'=>$event->requests['Cost_Center'],

            ];

             AddJournalizingEvent::dispatch($event->requests,$Status,$type,$type_ar,$type_en,$custom,$custom_data);       
 
   
                   
        $dataUser=[
        'screen_ar'=>'القيد الإفتتاحي',
        'screen_en'=>'Opening Entries',
        'type_ar'=>'تأكيد',
        'type_en'=>'Sure',
        'explain_ar'=>$event->requests['Code'],
        'explain_en'=>$event->requests['Code'],
        ];
        $this->UserCustomMoves($dataUser);   
        
        
    
        //Notifications
    
            
              $order=[
                'noti_name_ar'=>'تأكيد القيد الافتتاحي',
                'noti_name_en'=>'Opening Entries  Confirmed',
                'type_ar'=>'القيد الافتتاحي',
                'type_en'=>'Opening Entries',
                'type_code'=>$event->requests['Code'],
                'emp'=>null,
                'client'=>null,
                'product'=>null,
                'store'=>null,
                'safe'=>null,
                'notify_name'=>trans('admin.OpeningEntries_Confirmed'),
            ];      
            $this->CreateNotification($order);      
          
        
        
                  

    
        
    }
}
