<?php


namespace App\Listeners\JobOrder;

use App\Events\JobOrderEvent;
use App\Models\GeneralDaily;
use App\Models\JobOrder;
use App\Models\JobOrdersExecutors;
use App\Models\JournalizingDetails;
use App\Models\ProductJobOrder;
use App\Models\ReciptVoucher;
use App\Models\ReciptVoucherDetails;
use App\Models\SafesBanks;
use App\Traits\GeneralTrait;
use App\Models\Journalizing;
use Illuminate\Support\Facades\DB;

class JobOrderListener
{


    use GeneralTrait;

    public function __construct()
    {

    }


    public function handle(JobOrderEvent $event)
    {

        $ID=$event->ID;
        $Bill=JobOrder::findOrFail($ID);

        if($event->requests['Payment_Method'] == 'Cash'){


            if(!empty($event->requests['Pay'])){

                $paid = $event->requests['Pay'] ;

            }else{

                $paid = $event->requests['Total_Price'] ;
            }

        }elseif($event->requests['Payment_Method'] == 'Later'){

            $paid = $event->requests['Pay'] ;

        }


        //Event
        $data=[

            'start_date'=>$event->requests['RecivedDate'],
            'end_date'=>$event->requests['RecivedDate'],
            'event_name_ar'=>'تسليم امر شغل',
            'event_name_en'=>'Job Order Recived',
            'type'=>'امر شغل',
            'type_id'=>null,
            'type_code'=>$Bill->Code,
            'emp'=>$event->requests['Delegate'],
            'client'=>$event->requests['Client'],
            'product'=>null,
            'customer'=>null,

        ];

        $this->CreateEvent($data);


        //Notify
            $order=[
                'noti_name_ar'=>'امر شغل',
                'noti_name_en'=>'Job Order',
                'type_ar'=>'امر شغل',
                'type_en'=>'Job Order',
                'type_code'=>$Bill->Code,
                'emp'=>$event->requests['Delegate'],
                'client'=>$event->requests['Client'],
                'product'=>null,
                'store'=>$event->requests['Store'],
                'safe'=>$event->requests['Safe'],
                'notify_name'=>trans('admin.JobOrder'),
            ];
            $this->CreateNotification($order);




        //Details
        if(!empty($event->requests['Unit'])){



            $Length=$event->requests['Length'];
            $Width=$event->requests['Width'] ;
            $Height=$event->requests['Height'] ;
            $Thickness=$event->requests['Thickness'] ;
            $Size=$event->requests['Size'] ;
            $Executor=$event->requests['Executor'];
            $P_Ar_Name=$event->requests['P_Ar_Name'];
            $P_En_Name=$event->requests['P_En_Name'];
            $Unit=$event->requests['Unit'];
            $P_Code=$event->requests['P_Code'];
            $Qty=$event->requests['Qty'];
            $Price=$event->requests['Price'];
            $Discount=$event->requests['Discount'];
            $TotalBFTax=$event->requests['TotalBFTax'];
            $TotalTax=$event->requests['TotalTax'];
            $PurchTax=$event->requests['PurchTax'];
            $Total=$event->requests['Total'];
            $Product=$event->requests['Product'];



            for($i=0 ; $i < count($Unit) ; $i++){

                $uu['Product_Code']=$P_Code[$i];
                $uu['P_Ar_Name']=$P_Ar_Name[$i];
                $uu['P_En_Name']=$P_En_Name[$i];
                $uu['Qty']=$Qty[$i];
                $uu['Price']=$Price[$i];
                $uu['Discount']=$Discount[$i];
                $uu['Tax']=$PurchTax[$i];
                $uu['Total_Bf_Tax']=$TotalBFTax[$i];
                $uu['Total_Tax']=$TotalTax[$i];
                $uu['Total']=$Total[$i];
                $uu['Store']=$event->requests['Store'] ;
                $uu['Product']=$Product[$i];
                $uu['Unit']=$Unit[$i];
                $uu['Length']=$Length[$i];
                $uu['Width']=$Width[$i];
                $uu['Height']=$Height[$i];
                $uu['Thickness']=$Thickness[$i];
                $uu['Size']=$Size[$i];
                $uu['Executor']=$Executor[$i];
                $uu['Order']=$ID;

                ProductJobOrder::create($uu);




                $job['Product']=$Product[$i];
                $job['Executor']=$Executor[$i];
                $job['Status']=0;
                $job['Order']=$ID;

                JobOrdersExecutors::create($job);



                //Notify
                $order=[
                    'noti_name_ar'=>'امر شغل',
                    'noti_name_en'=>'Job Order',
                    'type_ar'=>'امر شغل',
                    'type_en'=>'Job Order',
                    'type_code'=>$Bill->Code,
                    'emp'=>$Executor[$i],
                    'client'=>$event->requests['Client'],
                    'product'=>null,
                    'store'=>$event->requests['Store'],
                    'safe'=>$event->requests['Safe'],
                    'notify_name'=>trans('admin.JobOrder'),
                ];
                $this->CreateNotification($order);


            }


        }

        //Joun
        if(!empty($event->requests['Pay'])){


            $IDD = DB::table('recipt_vouchers')->insertGetId(

                array(


                    'Date' => $event->requests['Date'],
                    'Draw' => $event->requests['Draw'],
                    'Coin' => $event->requests['Coin'],
                    'Safe' => $event->requests['Safe'],
                    'Cost_Center' => $event->requests['Cost_Center'],
                    'Total_Creditor' => $event->requests['Pay'],
                    'Note' => $event->requests['Note'],
                    'Status' => null,
                    'File' => null,

                )
            );



            $CodeT=ReciptVoucher::findOrFail($IDD)->Code;
            $Debitor =$event->requests['Pay'];
            $Account =$event->requests['Client'];
            $Statement =$event->requests['Note'];

            $PRODUCTS['RV_ID']=$IDD;
            $PRODUCTS['Creditor']=$Debitor;
            $PRODUCTS['Account']=$Account;
            $PRODUCTS['Statement']=$Statement;


            ReciptVoucherDetails::create($PRODUCTS);



            $IDT = DB::table('journalizings')->insertGetId(

                array(


                    'Type' => 'سند قبض',
                    'TypeEn' => 'Receipt Voucher',
                    'Code_Type' =>$CodeT,
                    'Date' =>$event->requests['Date'] ,
                    'Draw' =>$event->requests['Draw'] ,
                    'Coin' =>$event->requests['Coin'] ,
                    'Cost_Center' =>$event->requests['Cost_Center'] ,
                    'Total_Debaitor' =>$event->requests['Pay'] ,
                    'Total_Creditor' =>$event->requests['Pay'] ,
                    'Note' =>$event->requests['Note'] ,

                )
            );

            $Code=Journalizing::findOrFail($IDT)->Code;

            $PRODUCTSS['Joun_ID']=$IDT;
            $PRODUCTSS['Debitor']=0;
            $PRODUCTSS['Creditor']=$Debitor;
            $PRODUCTSS['Account']=$Account;
            $PRODUCTSS['Statement']=$Statement;


            JournalizingDetails::create($PRODUCTSS);

            $Gen['Code']=$Code;
            $Gen['Code_Type']=$CodeT;
            $Gen['Date']=$event->requests['Date'];
            $Gen['Type']= 'سند قبض';
            $Gen['TypeEn']='Receipt Voucher';
            $Gen['Debitor']=0;
            $Gen['Creditor']=$Debitor;
            $Gen['Statement']=$Statement;
            $Gen['Draw']=$event->requests['Draw'];
            $Gen['Debitor_Coin']= $event->requests['Draw'] * 0;
            $Gen['Creditor_Coin']=$event->requests['Draw'] * $Debitor;
            $Gen['Account']=$Account;
            $Gen['Coin']= $event->requests['Coin'];
            $Gen['Cost_Center']= $event->requests['Cost_Center'];
            $Gen['userr']= auth()->guard('admin')->user()->id;

            GeneralDaily::create($Gen);


            $PRODUCTSSS['Joun_ID']=$IDT;
            $PRODUCTSSS['Debitor']=$Debitor;
            $PRODUCTSSS['Creditor']=0;
            $PRODUCTSSS['Account']=$event->requests['Safe'];
            $PRODUCTSSS['Statement']=null;
            JournalizingDetails::create($PRODUCTSSS);


            $Safe=SafesBanks::where('Account',$event->requests['Safe'])->orderBy('id','desc')->first();


            $Genn['Branch']=null;
            $Genn['Code']=$Code;
            $Genn['Code_Type']=$CodeT;
            $Genn['Date']=$event->requests['Date'];
            $Genn['Type']= 'سند قبض';
            $Genn['TypeEn']='Receipt Voucher';
            $Genn['Debitor']=$Debitor;
            $Genn['Creditor']=0;
            $Genn['Statement']=null;
            $Genn['Draw']=$event->requests['Draw'];
            $Genn['Debitor_Coin']= $event->requests['Draw'] * $Debitor;
            $Genn['Creditor_Coin']=$event->requests['Draw'] * 0;
            $Genn['Account']=$event->requests['Safe'];
            $Genn['Coin']= $event->requests['Coin'];
            $Genn['Cost_Center']=  $event->requests['Cost_Center'];
            $Genn['userr']= auth()->guard('admin')->user()->id;

            GeneralDaily::create($Genn);


            JobOrder::where('id',$ID)->update(['RecivedVoucherCode'=>$CodeT]);

        }





    }

}
