<?php

namespace App\Http\Resources;


use App\Models\ProductsStoresTransfers;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class StorsTransfersResources extends JsonResource
{
    public function toArray($request)
    {

        $lang = $request->header('lang', '');

        if($lang == 'ar'){
            $FromsafeName=$this->From_Store()->first()->Name;
            $TosafeName=$this->To_Store()->first()->Name;
            $CoinName=$this->Coin()->first()->Arabic_Name;


        }else{
            $FromsafeName=$this->From_Store()->first()->NameEn;
            $TosafeName=$this->To_Store()->first()->NameEn;
            $CoinName=$this->Coin()->first()->English_Name;


        }



        if(!empty($this->User()->first()->name)){



            if($lang == 'ar'){
                $User_Name=$this->User()->first()->name;
            }else{
                $User_Name=$this->User()->first()->nameEn;

            }


        }else{
            $User_Name='';
        }



        if(!empty($this->Delegate()->first()->name)){



            if($lang == 'ar'){
                $Delegate_Name=$this->Delegate()->first()->name;
            }else{
                $Delegate_Name=$this->Delegate()->first()->nameEn;

            }


        }else{
            $Delegate_Name='';
        }



        if(!empty($this->Branch()->first()->name)){



            if($lang == 'ar'){
                $Branch_Name=$this->Branch()->first()->name;
            }else{
                $Branch_Name=$this->Branch()->first()->nameEn;

            }


        }else{
            $Branch_Name='';
        }

        if(!empty($this->Ship()->first()->name)){



            if($lang == 'ar'){
                $Ship=$this->Ship()->first()->name;
            }else{
                $Ship=$this->Ship()->first()->nameEn;

            }


        }else{
            $Ship='';
        }


        $data = [

            'id'=>$this->id,
            'Code'=>$this->Code,
            'Date'=>$this->Date,
            'From_Store'=>$FromsafeName,
            'To_Store'=>$TosafeName,
            'Draw'=>$this->Draw,
            'Notes'=>$this->Notes,
            'Coin'=>$CoinName,
            'Shipping_Compaines'=>$Ship,
            'User'=>$User_Name,
            'Delegate'=>$Delegate_Name,
            'Delegate_id'=>$this->Delegate,
            'Branch'=>$Branch_Name,
            'Branch_id'=>$this->Branch,
            'from_store_id'=>$this->From_Store,
            'to_store_id'=>$this->To_Store,
            'coin_id'=>$this->Coin,
            'Shipping_Compaines_id'=>$this->Ship,
            'total'=>$this->Total,
            'total_qty'=>$this->TotalQty,
            'total_cost'=>$this->Total_Cost,


            'file'=>asset($this->File),
              'details'=>$this->when(!empty($this->id), function () {

        $Products=ProductsStoresTransfersResources::collection(ProductsStoresTransfers::where('ST_ID',$this->id)->get());

        return $Products;
    }),
        ];


        return $data ;
    }

}
