<?php

namespace App\Http\Resources\Reports\SupplyChain;


use App\Models\AssemblyProducts;
use App\Models\Measuerments;
use App\Models\ProductMoves;
use App\Models\ProductsQty;
use App\Models\ProductUnits;
use App\Models\Purchases;
use App\Models\StoresDefaultData;
use App\Services\Average;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class StoresBalancesApiResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');
        $search = $request->get('search');
        $store = $request->get('Store');
        $group = $request->get('group');
        $From = $request->get('From');
        $To = $request->get('To');
        $User = $request->get('User');
        $Type = $request->get('Type');
        $Balance = 0;

        if ($this->Type == 'مشتريات') {
            $pur = Purchases::find($this->Bill_Num);
            if (!empty($pur->Refernce_Number)) {
                $Ref = $pur->Refernce_Number;
            } else {
                $Ref = '';
            }


        } else {
            $Ref = '';
        }

        if ($this->Incom != 0) {
            $OneIn = $this->CostIn / $this->Incom;
        } else {

            $OneIn = $this->CostIn / 1;
        }

        if ($this->Outcom != 0) {
            $OneOut = $this->CostOut / $this->Outcom;
        } else {
            $OneOut = $this->CostOut / 1;
        }

        if ($this->Current != 0) {
            $OneCurrent = $this->CostCurrent / $this->Current;
        } else {
            $OneCurrent = $this->CostCurrent / 1;
        }

        if (!empty($this->Group)) {
            if ($lang == 'ar') {
                $Group = $this->Group()->first()->Name;
            } else {

                $Group = $this->Group()->first()->NameEn;
            }
        } else {

            $Group = '';
        }

        if (!empty($this->Unit)) {
            if ($lang == 'ar') {
                $Unit = $this->Unit()->first()->Name;
            } else {

                $Unit = $this->Unit()->first()->NameEn;
            }
        } else {

            $Unit = '';
        }

        if (!empty($this->Brand)) {
            if ($lang == 'ar') {
                $Brand = $this->Brand()->first()->Name;
            } else {

                $Brand = $this->Brand()->first()->NameEn;
            }
        } else {

            $Brand = '';
        }
        if (!empty($this->Safe)) {
            if ($lang == 'ar') {
                $Safe = $this->Safe()->first()->Name;
            } else {

                $Safe = $this->Safe()->first()->NameEn;
            }
        } else {

            $Safe = '';
        }
        if (!empty($this->Branch)) {
            if ($lang == 'ar') {
                $Branch = $this->Branch()->first()->Arabic_Name;
            } else {

                $Branch = $this->Branch()->first()->English_Name;
            }
        } else {

            $Branch = '';
        }


        if ($this->Payment_Method == 'Cash') {
            $payment = trans('admin.Cash');
        }elseif($this->Payment_Method == 'Later'){
            $payment = trans('admin.Later');
        }else{
            $payment='';
        }



        if(!empty($this->Store)){
            if($lang == 'ar' ){
                $SS=$this->Store()->first()->Name;
            }else{

                $SS=$this->Store()->first()->NameEn;
            }
        }else{

            $SS='';
        }

        if(!empty($this->V1)){
            if($lang == 'ar' ){
                $V=$this->V1()->first()->Name;
            }else{
                $V=$this->V1()->first()->NameEn;
            }
        }else{

            $V='';
        }

        if(!empty($this->V2)){
            if($lang == 'ar' ){
                $VV=$this->V2()->first()->Name;
            }else{

                $VV=$this->V2()->first()->NameEn;
            }
        }else{

            $VV='';
        }





        if($this->Edit == 1){ $classX="edited"; }elseif ($this->Delete == 1){ $classX="deleted"; }else{ $classX=""; }

        if($this->Edit == 1){

            $span=trans('admin.Edited_to_New_One').' '.$this->Edit_New_Code;

        }elseif($this->Delete == 1){

            $span=trans('admin.Deleted');

        }else{

            $span='';
        }



        if($group != ''){
            if($this->Group == $group){

                $x=ProductsQty::where('P_Code',$this->P_Code)->where('Product',$this->Product)->first();
                $m=ProductMoves::where('P_Code',$this->P_Code)->where('Product',$this->Product)->count();

                if(!empty($x)){
                    $Balance += $x->Qty /$m;
                }else{
                    $Balance += 0;

                }



                if($this->Product()->first()->P_Type == 'Completed' or $this->Product()->first()->P_Type == 'Raw' or $this->Product()->first()->P_Type == 'Industrial'){

                    if($lang == 'ar' ){
                        $ProoName=$this->P_Ar_Name;
                        $UiiName=$this->User()->first()->name;
                        $TypeName=$this->Type;

                    }else{
                        $ProoName=$this->P_En_Name;
                        $UiiName=$this->User()->first()->nameEn;
                        $TypeName=$this->TypeEn;

                    }




                    $data=[

                        'product_code'=>$this->P_Code
                        ,'product_name'=>$ProoName
                        ,'date'=>$this->Date
                        ,'type'=>$TypeName
                        ,'unit'=>$Unit
                        ,'bill_num'=>$this->Bill_Num
                        ,'income'=>$this->Incom
                        ,'outcome'=>$this->Outcom
                        ,'current_qty'=>$this->Current
                        ,'cost_current'=>$this->CostCurrent
                        ,'current_cost_per_one'=>number_format((float)$OneCurrent, 2, '.', '')
                        ,'group'=>$Group
                        ,'store'=>$SS
                        ,'user'=>$UiiName
                        ,'status'=>$span



                    ];


                    return $data ;



                }elseif($this->Product()->first()->P_Type == 'Serial'){

                    if($lang == 'ar' ){
                        $ProoName=$this->P_Ar_Name;
                        $UiiName=$this->User()->first()->name;
                        $TypeName=$this->Type;

                    }else{
                        $ProoName=$this->P_En_Name;
                        $UiiName=$this->User()->first()->nameEn;
                        $TypeName=$this->TypeEn;

                    }


                    $data=[

                        'product_code'=>$this->P_Code
                        ,'product_name'=>$ProoName
                        ,'date'=>$this->Date
                        ,'type'=>$TypeName
                        ,'unit'=>$Unit
                        ,'bill_num'=>$this->Bill_Num
                        ,'income'=>$this->Incom
                        ,'outcome'=>$this->Outcom
                        ,'current_qty'=>$this->Current
                        ,'cost_current'=>$this->CostCurrent
                        ,'current_cost_per_one'=>number_format((float)$OneCurrent, 2, '.', '')
                        ,'group'=>$Group
                        ,'store'=>$SS
                        ,'user'=>$UiiName
                        ,'status'=>$span



                    ];

                    return $data ;
                }elseif($this->Product()->first()->P_Type == 'Single_Variable'){

                    if($lang == 'ar' ){
                        $ProoName=$this->P_Ar_Name;
                        $UiiName=$this->User()->first()->name;
                        $TypeName=$this->Type;

                    }else{
                        $ProoName=$this->P_En_Name;
                        $UiiName=$this->User()->first()->nameEn;
                        $TypeName=$this->TypeEn;

                    }



                    $data=[

                        'product_code'=>$this->P_Code
                        ,'product_name'=>$ProoName . ($V)
                        ,'date'=>$this->Date
                        ,'type'=>$TypeName
                        ,'unit'=>$Unit
                        ,'bill_num'=>$this->Bill_Num
                        ,'income'=>$this->Incom
                        ,'outcome'=>$this->Outcom
                        ,'current_qty'=>$this->Current
                        ,'cost_current'=>$this->CostCurrent
                        ,'current_cost_per_one'=>number_format((float)$OneCurrent, 2, '.', '')
                        ,'group'=>$Group
                        ,'store'=>$SS
                        ,'user'=>$UiiName
                        ,'status'=>$span



                    ];


                    return $data ;
                }elseif($this->Product()->first()->P_Type == 'Duble_Variable'){

                    if($lang == 'ar' ){
                        $ProoName=$this->P_Ar_Name;
                        $UiiName=$this->User()->first()->name;
                        $TypeName=$this->Type;

                    }else{
                        $ProoName=$this->P_En_Name;
                        $UiiName=$this->User()->first()->nameEn;
                        $TypeName=$this->TypeEn;

                    }



                    $data=[

                        'product_code'=>$this->P_Code
                        ,'product_name'=>$ProoName . ($V) . ($VV)
                        ,'date'=>$this->Date
                        ,'type'=>$TypeName
                        ,'unit'=>$Unit
                        ,'bill_num'=>$this->Bill_Num
                        ,'income'=>$this->Incom
                        ,'outcome'=>$this->Outcom
                        ,'current_qty'=>$this->Current
                        ,'cost_current'=>$this->CostCurrent
                        ,'current_cost_per_one'=>number_format((float)$OneCurrent, 2, '.', '')
                        ,'group'=>$Group
                        ,'store'=>$SS
                        ,'user'=>$UiiName
                        ,'status'=>$span



                    ];

                    return $data ;

                }


            }

        }else{

            $x=ProductsQty::where('P_Code',$this->P_Code)->where('Product',$this->Product)->first();
            $m=ProductMoves::where('P_Code',$this->P_Code)->where('Product',$this->Product)->count();

            if(!empty($x)){
                $Balance += $x->Qty /$m;
            }else{
                $Balance += 0;

            }




            if($this->Product()->first()->P_Type == 'Completed' or $this->Product()->first()->P_Type == 'Raw' or $this->Product()->first()->P_Type == 'Industrial'){

                if($lang == 'ar' ){
                    $ProoName=$this->P_Ar_Name;
                    $UiiName=$this->User()->first()->name;
                    $TypeName=$this->Type;

                }else{
                    $ProoName=$this->P_En_Name;
                    $UiiName=$this->User()->first()->nameEn;
                    $TypeName=$this->TypeEn;

                }

                $data=[

                    'product_code'=>$this->P_Code
                    ,'product_name'=>$ProoName
                    ,'date'=>$this->Date
                    ,'type'=>$TypeName
                    ,'unit'=>$Unit
                    ,'bill_num'=>$this->Bill_Num
                    ,'income'=>$this->Incom
                    ,'outcome'=>$this->Outcom
                    ,'current_qty'=>$this->Current
                    ,'cost_current'=>$this->CostCurrent
                    ,'current_cost_per_one'=>number_format((float)$OneCurrent, 2, '.', '')
                    ,'group'=>$Group
                    ,'store'=>$SS
                    ,'user'=>$UiiName
                    ,'status'=>$span



                ];

                return $data ;

            }elseif($this->Product()->first()->P_Type == 'Serial'){

                if($lang == 'ar' ){
                    $ProoName=$this->P_Ar_Name;
                    $UiiName=$this->User()->first()->name;
                    $TypeName=$this->Type;

                }else{
                    $ProoName=$this->P_En_Name;
                    $UiiName=$this->User()->first()->nameEn;
                    $TypeName=$this->TypeEn;

                }

                $data=[

                    'product_code'=>$this->P_Code
                    ,'product_name'=>$ProoName
                    ,'date'=>$this->Date
                    ,'type'=>$TypeName
                    ,'unit'=>$Unit
                    ,'bill_num'=>$this->Bill_Num
                    ,'income'=>$this->Incom
                    ,'outcome'=>$this->Outcom
                    ,'current_qty'=>$this->Current
                    ,'cost_current'=>$this->CostCurrent
                    ,'current_cost_per_one'=>number_format((float)$OneCurrent, 2, '.', '')
                    ,'group'=>$Group
                    ,'store'=>$SS
                    ,'user'=>$UiiName
                    ,'status'=>$span



                ];
                return $data ;

            }elseif($this->Product()->first()->P_Type == 'Single_Variable'){

                if($lang == 'ar' ){
                    $ProoName=$this->P_Ar_Name;
                    $UiiName=$this->User()->first()->name;
                    $TypeName=$this->Type;

                }else{
                    $ProoName=$this->P_En_Name;
                    $UiiName=$this->User()->first()->nameEn;
                    $TypeName=$this->TypeEn;

                }

                $data=[

                    'product_code'=>$this->P_Code
                    ,'product_name'=>$ProoName . ($V)
                    ,'date'=>$this->Date
                    ,'type'=>$TypeName
                    ,'unit'=>$Unit
                    ,'bill_num'=>$this->Bill_Num
                    ,'income'=>$this->Incom
                    ,'outcome'=>$this->Outcom
                    ,'current_qty'=>$this->Current
                    ,'cost_current'=>$this->CostCurrent
                    ,'current_cost_per_one'=>number_format((float)$OneCurrent, 2, '.', '')
                    ,'group'=>$Group
                    ,'store'=>$SS
                    ,'user'=>$UiiName
                    ,'status'=>$span



                ];
                return $data ;


            }elseif($this->Product()->first()->P_Type == 'Duble_Variable'){

                if($lang == 'ar' ){
                    $ProoName=$this->P_Ar_Name;
                    $UiiName=$this->User()->first()->name;
                    $TypeName=$this->Type;

                }else{
                    $ProoName=$this->P_En_Name;
                    $UiiName=$this->User()->first()->nameEn;
                    $TypeName=$this->TypeEn;

                }


                $data=[

                    'product_code'=>$this->P_Code
                    ,'product_name'=>$ProoName . ($V) . ($VV)
                    ,'date'=>$this->Date
                    ,'type'=>$TypeName
                    ,'unit'=>$Unit
                    ,'bill_num'=>$this->Bill_Num
                    ,'income'=>$this->Incom
                    ,'outcome'=>$this->Outcom
                    ,'current_qty'=>$this->Current
                    ,'cost_current'=>$this->CostCurrent
                    ,'current_cost_per_one'=>number_format((float)$OneCurrent, 2, '.', '')
                    ,'group'=>$Group
                    ,'store'=>$SS
                    ,'user'=>$UiiName
                    ,'status'=>$span



                ];
                return $data ;

            }




        }









    }

}
