<?php

namespace App\Http\Resources\Reports\SupplyChain;


use App\Models\ProductSales;
use App\Models\ProductsPurchases;
use App\Models\Sales;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class ShiftsReportApiResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');

        if(!empty($this->Store)){

            $Store=$this->Store()->first()->Name;
        }else{

            $Store='';
        }

        if(!empty($this->Safe)){

            $Safe=$this->Safe()->first()->Name;
        }else{

            $Safe='';
        }



            $salesNumber=Sales::where('Edit',0)->where('Delete',0)->where('Shift_Code',$this->Code)->count();
            $ClientsNumber=Sales::where('Edit',0)->where('Delete',0)->where('Shift_Code',$this->Code)->distinct(['Client'])->count();

            if($lang == 'ar' ){
                $txNamme=$this->Emp()->first()->Name;
            }else{

                $txNamme=$this->Emp()->first()->NameEn;
            }


        $data=[

            'Code'=>$this->Code
            ,'Date'=>$this->Date
            ,'Total_Cash'=>$this->Total_Cash
            ,'Total_Later'=>$this->Total_Later
            ,'Total_Later_Not_Paid'=>$this->Total_Later_Not_Paid
            ,'Total_Later_Paid'=>$this->Total_Later_Paid
            ,'Total_Visa'=>$this->Total_Visa
            ,'Total_Recipt'=>$this->Total_Recipt
            ,'Total_Installment'=>$this->Total_Installment
            ,'Total_Checks'=>$this->Total_Checks
            ,'Total_Delivery'=>$this->Total_Delivery
            ,'Total_Installment_Companies'=>$this->Total_Installment_Companies
            ,'Total_Payment'=>$this->Total_Payment
            ,'Total'=>$this->Total
            ,'Amount'=>$this->Amount
            ,'txNamme'=>$txNamme
            ,'Store'=>$Store
            ,'Safe'=>$Safe
            ,'Note'=>$this->Note
            ,'salesNumber'=>$salesNumber
            ,'ClientsNumber'=>$ClientsNumber
            ,'Close_Date'=>$this->Close_Date


        ];


        return $data ;

    }

}
