<?php

namespace App\Http\Resources\Reports\SupplyChain;


use App\Models\ProductSalesOrder;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class ReturnWithoutBillReportApiResources extends JsonResource
{
    public function toArray($request)
    {

        $lang = $request->header('lang', '');

        if(!empty($this->Delegate()->first()->Name)){

            if($lang == 'ar' ){
                $dele=$this->Delegate()->first()->Name;
            }else{
                $dele=$this->Delegate()->first()->NameEn;
            }
        }else{

            $dele='';
        }




        if($lang == 'ar' ){
            $StName=$this->Store()->first()->Name;
            $SafeName=$this->Safe()->first()->Name;
            $CliName = $this->Vendor()->first()->Name;


        }else{
            $StName=$this->Store()->first()->NameEn;
            $SafeName=$this->Safe()->first()->NameEn;

            $CliName = $this->Vendor()->first()->NameEn;




        }


        if($this->Payment_Method == 'Cash'){
            $payment=trans('admin.Cash');
        }else{

            $payment=trans('admin.Later');
        }




        $data = [

            'Date'=>$this ->Date,
            'Code'=>$this ->Code,
            'Store_Name'=>$StName,
            'Safe_Name'=>$SafeName,
            'Client_Name'=>$CliName,
            'delegate'=>$dele,
            'payment'=>$payment,
            'Total_Qty'=>$this ->Total_Qty,
            'Total_Price'=>$this ->Total_Price,
            'Total_Cost'=>$this ->Total_Cost,



        ];


        return $data ;
    }

}
