<?php

namespace App\Http\Resources\Reports\SupplyChain;


use App\Models\AssemblyProducts;
use App\Models\Measuerments;
use App\Models\ProductMoves;
use App\Models\ProductSales;
use App\Models\ProductsQty;
use App\Models\ProductUnits;
use App\Models\Purchases;
use App\Models\StoresDefaultData;
use App\Services\Average;
use App\Services\SalesService;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class ProfitSalesProductFilterApiResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');

        $branch=$request->get('branch');
        $store=$request->get('store');
        $group=$request->get('group');
        $brand=$request->get('brand');
        $product_Name=$request->get('product_Name');
        $product_Code=$request->get('product_Code');
        $From=$request->get('From');
        $To=$request->get('To');
        $Client=$request->get('Client');
        $Safe=$request->get('Safe');
        $Payment_Method=$request->get('Payment_Method');
        $Delegate=$request->get('Delegate');
        $Code=$request->get('Code');

        $average=new Average();
        $units=ProductUnits::where('Product',$this->Product)->get();
        $rr=ProductUnits::where('Product',$this->Product)->where('Def',1)->first();
        $plow=ProductUnits::where('Product',$this->Product)->where('Rate',1)->first();

        $Average=$average->AverageCostGetUnit($this->Product,$plow->Barcode,$this->Store,$plow->Unit);


        $salesQty=ProductSales::whereBetween('Date', [$From,$To])

            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->whereRelation('Sales','Client',$Client);

            })


            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->whereRelation('Sales','Safe',$Safe);

            })

            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                return $query->whereRelation('Sales','Payment_Method',$Payment_Method);

            })



            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->whereRelation('Sales','Delegate',$Delegate);

            })


            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereRelation('Sales','Store',$store);

            })


            ->when(!empty($Code), function ($query) use ($Code) {
                return $query->whereRelation('Sales','Code',$Code);

            })

            ->whereRelation('Sales','Edit',0)->whereRelation('Sales','Delete',0)->where('Product',$this->Product)->get()->sum('Qty') ;





        $yy=ProductSales::whereBetween('Date', [$From,$To])

            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->whereRelation('Sales','Client',$Client);

            })


            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->whereRelation('Sales','Safe',$Safe);

            })

            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                return $query->whereRelation('Sales','Payment_Method',$Payment_Method);

            })



            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->whereRelation('Sales','Delegate',$Delegate);

            })


            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereRelation('Sales','Store',$store);

            })


            ->when(!empty($Code), function ($query) use ($Code) {
                return $query->whereRelation('Sales','Code',$Code);

            })


            ->whereRelation('Sales','Edit',0)->whereRelation('Sales','Delete',0)->where('Product',$this->Product)->get()->sum('Total_Net') ;
        $yyCost=ProductSales::whereBetween('Date', [$From,$To])

            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->whereRelation('Sales','Client',$Client);

            })


            ->when(!empty($Safe), function ($query) use ($Safe) {
                return $query->whereRelation('Sales','Safe',$Safe);

            })

            ->when(!empty($Payment_Method), function ($query) use ($Payment_Method) {
                return $query->whereRelation('Sales','Payment_Method',$Payment_Method);

            })



            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->whereRelation('Sales','Delegate',$Delegate);

            })


            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereRelation('Sales','Store',$store);

            })


            ->when(!empty($Code), function ($query) use ($Code) {
                return $query->whereRelation('Sales','Code',$Code);

            })


            ->whereRelation('Sales','Edit',0)->whereRelation('Sales','Delete',0)->where('Product',$this->Product)->get()->sum('TotCostNew') ;

        $f=  $yy  - $yyCost;




        if($lang == 'ar' ){
            $PrrroName=$this->P_Ar_Name;
            $StoreNemo=$this->Store()->first()->Name;
            $UnitName=$this->Unit()->first()->Name;

        }else{
            $PrrroName=$this->P_En_Name;
            $StoreNemo=$this->Store()->first()->NameEn;
            $UnitName=$this->Unit()->first()->NameEn;

        }


 if(!empty($this->Branch()->first()->Arabic_Name)) {

     if($lang == 'ar' ){
         $branch=$this->Branch()->first()->Arabic_Name;

     }else{
         $branch=$this->Branch()->first()->English_Name;

     }

        }else{

     $branch='';

 }


        if(!empty($this->Group()->first()->Name)) {

            if($lang == 'ar' ){
                $group=$this->Group()->first()->Name;

            }else{
                $group=$this->Group()->first()->NameEn;

            }

        }else{

            $group='';

        }

        if(!empty($this->Brand()->first()->Name)) {

            if($lang == 'ar' ){
                $brand=$this->Brand()->first()->Name;

            }else{
                $brand=$this->Brand()->first()->NameEn;

            }

        }else{

            $brand='';

        }



        $data=[

                'Product_Code'=>$this->P_Code
                ,'Product_Name'=>$PrrroName . ($this->V_Name). ($this->VV_Name)
                ,'Unit'=>$UnitName
                ,'Sales_Qty'=>$salesQty
                ,'Total_Net'=>$yy
                ,'Total_Cost'=>$yyCost
                ,'Profit'=>$f
                ,'Store'=>$StoreNemo
                ,'Branch'=>$branch
                ,'Group'=>$group
                ,'Brand'=>$brand
            ];


            return $data ;




    }

}
