<?php

namespace App\Http\Resources\Reports\SupplyChain;


use App\Models\ProductSalesOrder;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class ProductsStoresTransfersApiResources extends JsonResource
{
    public function toArray($request)
    {

        $lang = $request->header('lang', '');

        if($lang == 'ar'){

            $GROUP=$this ->Product()->first()->Group()->first()->Name;

            if(!empty($this ->Product()->first()->Brand()->first()->Name)){
                $BRAND=$this ->Product()->first()->Brand()->first()->Name;
            }else{
                $BRAND='';
            }


        }else{

            $GROUP=$this ->Product()->first()->Group()->first()->NameEn;
            if(!empty($this ->Product()->first()->Brand()->first()->NameEn)){
                $BRAND=$this ->Product()->first()->Brand()->first()->NameEn;
            }else{
                $BRAND='';
            }


        }

        $data = [

            'Product_Name'=>$this->Product()->first()->P_Ar_Name,
            'Product_Code'=>$this ->Product_Code,
            'Group'=>$GROUP,
            'Brand'=>$BRAND,
            'Qty'=>$this ->Av_Qty,
            'Price'=>$this ->Price,
            'Original_Qty'=>$this->Original_Trans_Qty,
            'Trans_Qty'=>$this->Trans_Qty,
            'Unit'=>$this->Unit()->first()->Name,
            'Total'=>$this ->Total,


        ];


        return $data ;
    }

}
