<?php

namespace App\Http\Resources\Reports\SupplyChain;


use App\Models\ProductSalesOrder;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class ProductSalesApiResources extends JsonResource
{
    public function toArray($request)
    {

        $lang = $request->header('lang', '');

        if(app()->getLocale() == 'ar' ){
            $ProoName=$this->P_Ar_Name;
            $UniiName=$this->Unit()->first()->Name;

        }else{
            $ProoName=$this->P_En_Name;
            $UniiName=$this->Unit()->first()->NameEn;

        }


        $data = [

            'Code'=>$this ->Code,
            'Name'=>$ProoName,
            'Unit'=>$UniiName,
            'Qty'=>$this ->Qty,
            'Price'=>$this ->Price,
            'Total'=>$this ->Total,
            'Notes'=>$this ->Note,


        ];


        return $data ;
    }

}
