<?php

namespace App\Http\Resources\Reports\SupplyChain;


use App\Models\AssemblyProducts;
use App\Models\DefaultDataShowHide;
use App\Models\Measuerments;
use App\Models\ProductSales;
use App\Models\ProductsQty;
use App\Models\ProductUnits;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class MostSalesProductsApiResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');
        $from = $request->get('from');
        $to = $request->get('to');
        $store = $request->get('store');
        $safe = $request->get('safe');
        $group = $request->get('group');
        $brand = $request->get('brand');
        $branch = $request->get('branch');
        $product_Name = $request->get('product_Name');
        $product_Code = $request->get('product_Code');


        $Sales_Qty=ProductSales::where('Product',$this->Product)
            ->whereBetween('Date',[$from,$to])
            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store',$store);
            })


            ->when(!empty($safe), function ($query) use ($safe) {
                return $query->whereIn('Safe', $safe);
            })


            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })


            ->when(!empty($brand), function ($query) use ($brand) {
                return $query->whereIn('Brand', $brand);
            })



            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })


            ->when(!empty($product_Name), function ($query) use ($product_Name) {
                return $query->where('P_Ar_Name', $product_Name);
            })


            ->when(!empty($product_Code), function ($query) use ($product_Code) {
                return $query->where('P_Code', $product_Code);
            })
            ->get()->sum('Qty');


        $Sales_Count=ProductSales::where('Product',$this->Product)
            ->whereBetween('Date',[$from,$to])
            ->when(!empty($store), function ($query) use ($store) {
                return $query->whereIn('Store',$store);
            })


            ->when(!empty($safe), function ($query) use ($safe) {
                return $query->whereIn('Safe', $safe);
            })


            ->when(!empty($group), function ($query) use ($group) {
                return $query->whereIn('Group', $group);
            })


            ->when(!empty($brand), function ($query) use ($brand) {
                return $query->whereIn('Brand', $brand);
            })



            ->when(!empty($branch), function ($query) use ($branch) {
                return $query->where('Branch', $branch);
            })


            ->when(!empty($product_Name), function ($query) use ($product_Name) {
                return $query->where('P_Ar_Name', $product_Name);
            })


            ->when(!empty($product_Code), function ($query) use ($product_Code) {
                return $query->where('P_Code', $product_Code);
            })
            ->count();



        if(!empty($this->V1()->first()->Name)){
           $v=$this->V1()->first()->Name;
        }else{
          $v='';
        }

        if(!empty($this->V2()->first()->Name)){
           $vv=$this->V2()->first()->Name;
        }else{
          $vv='';
        }


        $data = [


            'Product_Code' => $this->Product_Code
            , 'Product_Name' => $this->P_Ar_Name . ($v .' - '. $vv )
            , 'Sales_Count' => $Sales_Count
            , 'Sales_Qty' => $Sales_Qty


        ];

        return $data;

    }

}
