<?php

namespace App\Http\Resources\Reports\SupplyChain;


use App\Models\AssemblyProducts;
use App\Models\Measuerments;
use App\Models\ProductsQty;
use App\Models\ProductUnits;
use App\Models\StoresDefaultData;
use App\Services\Average;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class HoldQtiesReportApiResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');
        $search = $request->get('search');
        $store = $request->get('store');
        $group = $request->get('group');

        $units=ProductUnits::where('Product',$this->Product)->get();
        $rr=ProductUnits::where('Product',$this->Product)->where('Def',1)->first();


        $average=new Average();


        $def=StoresDefaultData::orderBy('id','desc')->first();
        if($def->Cost_Price == 2){


            $totCost=0;





            $rr = ProductUnits::where("Unit",$rr->Unit)->where('Product',$this->Product)->first();



            $fifo=$this->FifoAvQtyDate($store,$this->Product,$rr->Barcode);

            if(!empty($fifo)){

                if($fifo->Qty == 0){



                    $NNQuntatity=$this->FindQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);


                    if($NNQuntatity == 0){


                        $NNQuntatity=$this->FindQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);


                    }else{



                        if($NNQuntatity >= $this->Qty){

                            $totCost += $fifo->Cost_Price * $this->Qty ;

                        }else{

                            $res=$this->Qty - $NNQuntatity ;


                            $totCost += $fifo->Cost_Price * $NNQuntatity ;

                            $ResdiualCost=$this->MoreThanQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$res);

                            $totCost +=$ResdiualCost;

                        }


                    }



                }else{


                    if($fifo->Qty >= $this->Qty){

                        $totCost += $fifo->Cost_Price * $this->Qty ;

                    }else{

                        $res=$this->Qty - $fifo->Qty ;


                        $totCost += $fifo->Cost_Price * $fifo->Qty ;

                        $ResdiualCost=$this->MoreThanQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$res);

                        $totCost +=$ResdiualCost;

                    }



                }


            }



            $Average=$average->AverageCostGetUnit($this->Product,$rr->Barcode,$store,$rr->Unit);




        }else{






            $Average=$average->AverageCostGetUnit($this->Product,$rr->Barcode,$store,$rr->Unit);


            $SMallAverage=$Average;






        }





        if($this->Product()->first()->P_Type == 'Completed' or $this->Product()->first()->P_Type == 'Raw' or $this->Product()->first()->P_Type == 'Industrial'){



            if(app()->getLocale() == 'ar' ){
                $PrrroName=$this->P_Ar_Name;


            }else{
                $PrrroName=$this->P_En_Name;


            }



            $data=[

                'product_code'=>$rr->Barcode
                ,'product_name'=>$PrrroName
                ,'unit'=>$rr->Unit()->first()->Name
                ,'hold_qty'=>$this->Hold_Qty / $rr->Rate


            ];





        }elseif($this->Product()->first()->P_Type == 'Serial'){




            if(app()->getLocale() == 'ar' ){
                $PrrroName=$this->P_Ar_Name;


            }else{
                $PrrroName=$this->P_En_Name;


            }


            $data=[

                'product_code'=>$this->P_Code
                ,'product_name'=>$PrrroName
                ,'unit'=>$rr->Unit()->first()->Name
                ,'hold_qty'=>$this->Hold_Qty / $rr->Rate


            ];




        }elseif($this->Product()->first()->P_Type == 'Single_Variable'){




            if(app()->getLocale() == 'ar' ){
                $PrrroName=$this->P_Ar_Name;
                $PrrroVName=$this->V1()->first()->Name;


            }else{
                $PrrroName=$this->P_En_Name;
                $PrrroVName=$this->V1()->first()->NameEn;


            }


            $data=[

                'product_code'=>$this->P_Code
                ,'product_name'=>$PrrroName .($PrrroVName)
                ,'unit'=>$rr->Unit()->first()->Name
                ,'hold_qty'=>$this->Hold_Qty / $rr->Rate


            ];




        }elseif($this->Product()->first()->P_Type == 'Duble_Variable'){




            if(app()->getLocale() == 'ar' ){
                $PrrroName=$this->P_Ar_Name;
                $PrrroVName=$this->V1()->first()->Name;
                $PrrroVVName=$this->V2()->first()->Name;


            }else{
                $PrrroName=$this->P_En_Name;
                $PrrroVName=$this->V1()->first()->NameEn;
                $PrrroVVName=$this->V2()->first()->NameEn;


            }


            $data=[

                'product_code'=>$this->P_Code
                ,'product_name'=>$PrrroName .($PrrroVName) . ($PrrroVVName)
                ,'unit'=>$rr->Unit()->first()->Name
                ,'hold_qty'=>$this->Hold_Qty / $rr->Rate


            ];


        }





        return $data ;
    }

}
