<?php

namespace App\Http\Resources\Reports\SupplyChain;


use App\Models\AssemblyProducts;
use App\Models\Measuerments;
use App\Models\ProductMoves;
use App\Models\ProductsQty;
use App\Models\ProductUnits;
use App\Models\Purchases;
use App\Models\StoresDefaultData;
use App\Services\Average;
use App\Services\SalesService;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class ExceptProductProfitsApiResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');
        $search = $request->get('search');
        $store = $request->get('Store');

        $service = new SalesService() ;
        $average=new Average();
              $units=ProductUnits::where('Product',$this->Product)->get();
                $rr=ProductUnits::where('Product',$this->Product)->where('Def',1)->first();



                $Average=$average->AverageCostGetUnit($this->Product,$rr->Barcode,$store,$rr->Unit);


                $f=  ($rr->Price * ($this->Qty / $rr->Rate) )  - ($Average * ($this->Qty / $rr->Rate));
                $ff=   ($Average * ($this->Qty / $rr->Rate));
                $fff=  ($rr->Price * ($this->Qty / $rr->Rate) );

                if($this->Product()->first()->P_Type == 'Completed' or $this->Product()->first()->P_Type == 'Raw' or $this->Product()->first()->P_Type == 'Industrial'){


                    if($lang == 'ar' ){
                        $PrrroName=$this->P_Ar_Name;
                        $StoreNemo=$this->Store()->first()->Name;

                    }else{
                        $PrrroName=$this->P_En_Name;
                        $StoreNemo=$this->Store()->first()->NameEn;

                    }

                    $UNITS=$service->ProUnitsDataTwo($this->Product,$this->Store,$rr->Barcode);


                    $data=[

                        'product_code'=>$rr->Barcode
                        ,'product_id'=>$this->Product
                        ,'product_name'=>$PrrroName
                        ,'unit'=>$rr->Unit()->first()->Name
                          ,'units'=>$UNITS
                        ,'price'=>$rr->Price
                        ,'qty'=>$this->Qty / $rr->Rate
                        ,'cost_price'=>$Average
                        ,'profit'=>$f
                        ,'store'=>$StoreNemo



                    ];

                    return $data ;


                }elseif($this->Product()->first()->P_Type == 'Serial'){


                    if($lang == 'ar' ){
                        $PrrroName=$this->P_Ar_Name;
                        $StoreNemo=$this->Store()->first()->Name;

                    }else{
                        $PrrroName=$this->P_En_Name;
                        $StoreNemo=$this->Store()->first()->NameEn;

                    }


                    $UNITS=$service->ProUnitsDataTwo($this->Product,$this->Store,$this->P_Code);



                    $data=[

                        'product_code'=>$this->P_Code
                        ,'product_id'=>$this->Product
                        ,'product_name'=>$PrrroName
                        ,'unit'=>$rr->Unit()->first()->Name
                        ,'units'=>$UNITS
                        ,'price'=>$rr->Price
                        ,'qty'=>$this->Qty / $rr->Rate
                        ,'cost_price'=>$Average
                        ,'profit'=>$f
                        ,'store'=>$StoreNemo



                    ];

                    return $data ;


                }elseif($this->Product()->first()->P_Type == 'Single_Variable'){


                    if($lang == 'ar' ){
                        $PrrroName=$this->P_Ar_Name;
                        $StoreNemo=$this->Store()->first()->Name;

                    }else{
                        $PrrroName=$this->P_En_Name;
                        $StoreNemo=$this->Store()->first()->NameEn;

                    }

                          $UNITS=$service->ProUnitsDataTwo($this->Product,$this->Store,$this->P_Code);



                    $data=[

                        'product_code'=>$this->P_Code
                        ,'product_id'=>$this->Product
                        ,'product_name'=>$PrrroName . ($this->V_Name)
                        ,'unit'=>$rr->Unit()->first()->Name
                             ,'units'=>$UNITS
                        ,'price'=>$rr->Price
                        ,'qty'=>$this->Qty / $rr->Rate
                        ,'cost_price'=>$Average
                        ,'profit'=>$f
                        ,'store'=>$StoreNemo



                    ];
                    return $data ;



                }elseif($this->Product()->first()->P_Type == 'Duble_Variable'){


                    if($lang == 'ar' ){
                        $PrrroName=$this->P_Ar_Name;
                        $StoreNemo=$this->Store()->first()->Name;

                    }else{
                        $PrrroName=$this->P_En_Name;
                        $StoreNemo=$this->Store()->first()->NameEn;

                    }



                          $UNITS=$service->ProUnitsDataTwo($this->Product,$this->Store,$this->P_Code);



                    $data=[

                        'product_code'=>$this->P_Code
                        ,'product_id'=>$this->Product
                        ,'product_name'=>$PrrroName . ($this->V_Name). ($this->VV_Name)
                        ,'unit'=>$rr->Unit()->first()->Name
                             ,'units'=>$UNITS
                        ,'price'=>$rr->Price
                        ,'qty'=>$this->Qty / $rr->Rate
                        ,'cost_price'=>$Average
                        ,'profit'=>$f
                        ,'store'=>$StoreNemo



                    ];

                    return $data ;


                }









    }

}
