<?php

namespace App\Http\Resources\Reports\SupplyChain;


use App\Models\AssemblyProducts;
use App\Models\GeneralDaily;
use App\Models\PaymentVoucher;
use App\Models\PaymentVoucherDetails;
use App\Models\ProductSales;
use App\Models\ProductsQty;
use App\Models\ProductUnits;
use App\Models\ReciptVoucher;
use App\Models\ReciptVoucherDetails;
use App\Models\ReturnSales;
use App\Models\Sales;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class DetSalesGroupApiResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');

        $From = $request->get('From');
        $To = $request->get('To');
        $Client = $request->get('Client');
        $Store = $request->get('Store');
        $Delegate = $request->get('Delegate');
        $Executor = $request->get('Executor');
        $Group = $request->get('Group');
        $Brand = $request->get('Brand');


        $TotSer=ProductSales::where('Product',$this->Product)->where('Product_Code',$this->P_Code)->whereBetween('Date',[$From,$To])

            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->whereRelation('Sales','Client', $Client);
            })

            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->whereRelation('Sales','Store', $Store);
            })

            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->whereRelation('Sales','Delegate', $Delegate);
            })


            ->when(!empty($Executor), function ($query) use ($Executor) {
                return $query->whereRelation('Sales','Executor', $Executor);
            })

            ->whereRelation('Sales','Edit',0)->whereRelation('Sales','Delete',0)

            ->get()->sum('Total_Net');

        $QtySer=ProductSales::where('Product',$this->Product)->where('Product_Code',$this->P_Code)->whereBetween('Date',[$From,$To])
            ->when(!empty($Client), function ($query) use ($Client) {
                return $query->whereRelation('Sales','Client', $Client);
            })

            ->when(!empty($Store), function ($query) use ($Store) {
                return $query->whereRelation('Sales','Store', $Store);
            })

            ->when(!empty($Delegate), function ($query) use ($Delegate) {
                return $query->whereRelation('Sales','Delegate', $Delegate);
            })


            ->when(!empty($Executor), function ($query) use ($Executor) {
                return $query->whereRelation('Sales','Executor', $Executor);
            })

            ->whereRelation('Sales','Edit',0)->whereRelation('Sales','Delete',0)
            ->get()->sum('Qty');



            if ($lang == 'ar') {
                $xName = $this->Store()->first()->Name;

                if(!empty($this->V1()->first()->Name)){
                    $VName = $this->V1()->first()->Name;
                }else{
                    $VName='';
                }

                if(!empty($this->V2()->first()->Name)){
                    $VVName = $this->V2()->first()->Name;
                }else{
                    $VVName='';
                }



            } else {
                $xName = $this->Store()->first()->NameEn;

                if(!empty($this->V1()->first()->NameEn)){
                    $VName = $this->V1()->first()->NameEn;
                }else{
                    $VName='';
                }

                if(!empty($this->V2()->first()->NameEn)){
                    $VVName = $this->V2()->first()->NameEn;
                }else{
                    $VVName='';
                }

            }


            $data = [

                'Virable_One' => $VName
                , 'Virable_Two' => $VVName
                , 'Code' => $this->P_Code
                , 'Store' => $xName
                , 'Total_Qty' => $QtySer
                , 'Total' => $TotSer

            ];


            return $data;





    }

}
